package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestoreDatabase invokes the petadata.RestoreDatabase API synchronously
// api document: https://help.aliyun.com/api/petadata/restoredatabase.html
func (client *Client) RestoreDatabase(request *RestoreDatabaseRequest) (response *RestoreDatabaseResponse, err error) {
	response = CreateRestoreDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// RestoreDatabaseWithChan invokes the petadata.RestoreDatabase API asynchronously
// api document: https://help.aliyun.com/api/petadata/restoredatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RestoreDatabaseWithChan(request *RestoreDatabaseRequest) (<-chan *RestoreDatabaseResponse, <-chan error) {
	responseChan := make(chan *RestoreDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestoreDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestoreDatabaseWithCallback invokes the petadata.RestoreDatabase API asynchronously
// api document: https://help.aliyun.com/api/petadata/restoredatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RestoreDatabaseWithCallback(request *RestoreDatabaseRequest, callback func(response *RestoreDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestoreDatabaseResponse
		var err error
		defer close(result)
		response, err = client.RestoreDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestoreDatabaseRequest is the request struct for api RestoreDatabase
type RestoreDatabaseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RestoreTime          string           `position:"Query" name:"RestoreTime"`
	SrcDBName            string           `position:"Query" name:"SrcDBName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	BackupId             string           `position:"Query" name:"BackupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RestoreType          string           `position:"Query" name:"RestoreType"`
	InstanceName         string           `position:"Query" name:"InstanceName"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SrcInstanceId        string           `position:"Query" name:"SrcInstanceId"`
}

// RestoreDatabaseResponse is the response struct for api RestoreDatabase
type RestoreDatabaseResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	NewInstanceId string `json:"NewInstanceId" xml:"NewInstanceId"`
	DBName        string `json:"DBName" xml:"DBName"`
	OrderId       string `json:"OrderId" xml:"OrderId"`
}

// CreateRestoreDatabaseRequest creates a request to invoke RestoreDatabase API
func CreateRestoreDatabaseRequest() (request *RestoreDatabaseRequest) {
	request = &RestoreDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "RestoreDatabase", "petadata", "openAPI")
	return
}

// CreateRestoreDatabaseResponse creates a response to parse from RestoreDatabase response
func CreateRestoreDatabaseResponse() (response *RestoreDatabaseResponse) {
	response = &RestoreDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
