searchData={"items":[{"type":"module","title":"atomics","doc":"Atomic Functions\n\nThis module provides a set of functions to do atomic operations towards mutable\natomic variables. The implementation utilizes only atomic hardware instructions\nwithout any software level locking, which makes it very efficient for concurrent\naccess. The atomics are organized into arrays with the following semantics:\n\n- Atomics are 64 bit integers.\n- Atomics can be represented as either signed or unsigned.\n- Atomics wrap around at overflow and underflow operations.\n- All operations guarantee atomicity. No intermediate results can be seen. The\n  result of one mutation can only be the input to one following mutation.\n- All atomic operations are mutually ordered. If atomic B is updated _after_\n  atomic A, then that is how it will appear to any concurrent readers. No one\n  can read the new value of B and then read the old value of A.\n- Indexes into atomic arrays are one-based. An atomic array of arity N contains\n  N atomics with index from 1 to N.","ref":"atomics.html"},{"type":"function","title":"atomics.add/3","doc":"Add `Incr` to atomic.","ref":"atomics.html#add/3"},{"type":"function","title":"atomics.add_get/3","doc":"Atomically add `Incr` to atomic and return the result.","ref":"atomics.html#add_get/3"},{"type":"opaque","title":"atomics.atomics_ref/0","doc":"Identifies an atomic array returned from `new/2`.","ref":"atomics.html#t:atomics_ref/0"},{"type":"function","title":"atomics.compare_exchange/4","doc":"Atomically compare the atomic with `Expected`, and if those are equal, set\natomic to `Desired`.\n\nReturn `ok` if `Desired` was written. Return the actual atomic value if\nnot equal to `Expected`.","ref":"atomics.html#compare_exchange/4"},{"type":"function","title":"atomics.exchange/3","doc":"Atomically replace the value of the atomic with `Desired` and return the previous value.","ref":"atomics.html#exchange/3"},{"type":"function","title":"atomics.get/2","doc":"Read atomic value.","ref":"atomics.html#get/2"},{"type":"function","title":"atomics.info/1","doc":"Return information about an atomic array in a map.\n\nThe map has the following keys:\n\n- **`size`** - The number of atomics in the array.\n- **`max`** - The highest possible value an atomic in this array can hold.\n- **`min`** - The lowest possible value an atomic in this array can hold.\n- **`memory`** - Approximate memory consumption for the array in bytes.","ref":"atomics.html#info/1"},{"type":"function","title":"atomics.new/2","doc":"Create a new array of `Arity` number of atomics. All atomics in the array are\ninitially set to zero.\n\nArgument `Opts` is a list of the following possible options:\n\n- **`{signed, boolean()}`** - Indicate if the elements of the array will be\n  treated as signed or unsigned integers. Default is `true` (signed).\n\n  The integer interval for signed atomics are from `-(1 bsl 63)` to\n  `(1 bsl 63)-1` and for unsigned atomics from `0` to `(1 bsl 64)-1`.\n\nAtomics are not tied to the current process and are automatically garbage\ncollected when they are no longer referenced.","ref":"atomics.html#new/2"},{"type":"function","title":"atomics.put/3","doc":"Set atomic to `Value`.","ref":"atomics.html#put/3"},{"type":"function","title":"atomics.sub/3","doc":"Subtract `Decr` from atomic.","ref":"atomics.html#sub/3"},{"type":"function","title":"atomics.sub_get/3","doc":"Atomically subtract `Decr` from atomic and return the result.","ref":"atomics.html#sub_get/3"},{"type":"module","title":"counters","doc":"Counter Functions\n\nThis module provides a set of functions to do operations towards shared mutable\ncounter variables. The implementation does not utilize any software level\nlocking, which makes it very efficient for concurrent access. The counters are\norganized into arrays with the following semantics:\n\n- Counters are 64 bit signed integers.\n- Counters wrap around at overflow and underflow operations.\n- Counters are initialized to zero.\n- Write operations guarantee atomicity. No intermediate results can be seen from\n  a single write operation.\n- Two types of counter arrays can be created with options `atomics` or\n  `write_concurrency`. The `atomics` counters have good allround performance\n  with nice consistent semantics while `write_concurrency` counters offers even\n  better concurrent write performance at the expense of some potential read\n  inconsistencies. See `new/2`.\n- Indexes into counter arrays are one-based. A counter array of size N contains\n  N counters with index from 1 to N.","ref":"counters.html"},{"type":"function","title":"counters.add/3","doc":"Add `Incr` to counter at index `Ix`.","ref":"counters.html#add/3"},{"type":"opaque","title":"counters.counters_ref/0","doc":"Identifies a counter array returned from `new/2`.","ref":"counters.html#t:counters_ref/0"},{"type":"function","title":"counters.get/2","doc":"Read counter value.","ref":"counters.html#get/2"},{"type":"function","title":"counters.info/1","doc":"Return information about a counter array in a map.\n\nThe map has the following keys (at least):\n\n- **`size`** - The number of counters in the array.\n- **`memory`** - Approximate memory consumption for the array in bytes.","ref":"counters.html#info/1"},{"type":"function","title":"counters.new/2","doc":"Create a new counter array of `Size` counters. All counters in the array are\ninitially set to zero.\n\nArgument `Opts` is a list of the following possible options:\n\n- **`atomics` (Default)** - Counters will be sequentially consistent. If write\n  operation A is done sequentially before write operation B, then a concurrent\n  reader may see the result of none of them, only A, or both A and B. It cannot\n  see the result of only B.\n\n- **`write_concurrency`** - This is an optimization to achieve very efficient\n  concurrent [`add`](`add/3`) and [`sub`](`sub/3`) operations at the expense of\n  potential read inconsistency and memory consumption per counter.\n\n  Read operations may see sequentially inconsistent results with regard to\n  concurrent write operations. Even if write operation A is done sequentially\n  before write operation B, a concurrent reader may see any combination of A and\n  B, including only B. A read operation is only guaranteed to see all writes\n  done sequentially before the read. No writes are ever lost, but will\n  eventually all be seen.\n\n  The typical use case for `write_concurrency` is when concurrent calls to\n  [`add`](`add/3`) and [`sub`](`sub/3`) toward the same counters are very\n  frequent, while calls to [`get` ](`get/2`)and [`put`](`put/3`) are much less\n  frequent. The lack of absolute read consistency must also be acceptable.\n\nCounters are not tied to the current process and are automatically garbage\ncollected when they are no longer referenced.","ref":"counters.html#new/2"},{"type":"function","title":"counters.put/3","doc":"Write `Value` to counter at index `Ix`.\n\n> #### Note {: .info }\n>\n> Despite its name, the `write_concurrency` optimization does not improve `put`.\n> A call to `put` is a relatively heavy operation compared to the very\n> lightweight and scalable [`add`](`add/3`) and [`sub`](`sub/3`). The cost for a\n> `put` with `write_concurrency` is like a [`get` ](`get/2`)plus a `put` without\n> `write_concurrency`.","ref":"counters.html#put/3"},{"type":"function","title":"counters.sub/3","doc":"Subtract `Decr` from counter at index `Ix`.","ref":"counters.html#sub/3"},{"type":"module","title":"erl_prim_loader","doc":"The low-level Erlang loader. This module is used to load all Erlang modules into\nthe system. The start script is also fetched with this low-level loader.\n\n`erl_prim_loader` knows about the environment and how to fetch modules.\n\nCommand-line flag `-loader Loader` can be used to choose the method used by\n`erl_prim_loader`. Two `Loader` methods are supported by the Erlang runtime\nsystem: `efile` and `inet`.","ref":"erl_prim_loader.html"},{"type":"module","title":"Command-Line Flags - erl_prim_loader","doc":"The `erl_prim_loader` module interprets the following command-line flags:\n\n- **`-loader Loader`** - Specifies the name of the loader used by\n  `erl_prim_loader`. `Loader` can be `efile` (use the local file system) or\n  `inet` (load using the `boot_server` on another Erlang node).\n\n  If flag `-loader` is omitted, it defaults to `efile`.\n\n- **`-loader_debug`** - Makes the `efile` loader write some debug information,\n  such as the reason for failures, while it handles files.\n\n- **`-hosts Hosts`** - Specifies which other Erlang nodes the `inet` loader can\n  use. This flag is mandatory if flag `-loader inet` is present. On each host,\n  there must be on Erlang node with the `m:erl_boot_server`, which handles the\n  load requests. `Hosts` is a list of IP addresses (hostnames are not\n  acceptable).\n\n- **`-setcookie Cookie`** - Specifies the cookie of the Erlang runtime system.\n  This flag is mandatory if flag `-loader inet` is present.","ref":"erl_prim_loader.html#module-command-line-flags"},{"type":"module","title":"See Also - erl_prim_loader","doc":"`m:init`, `m:erl_boot_server`","ref":"erl_prim_loader.html#module-see-also"},{"type":"function","title":"erl_prim_loader.get_file/1","doc":"_Use of this function is deprecated in favor of [`read_file/1`](`read_file/1`)._\n\nFetches a file using the low-level loader. `Filename` is either an absolute\nfilename or only the name of the file, for example, `\"lists.beam\"`. If an\ninternal path is set to the loader, this path is used to find the file.\n`FullName` is the complete name of the fetched file. `Bin` is the contents of\nthe file as a binary.\n\n`Filename` can also be a file in an archive, for example,\n`$OTPROOT/lib/mnesia-4.4.7.ez/mnesia-4.4.7/ebin/mnesia.beam`. For\ninformation about archive files, see `m:code`.","ref":"erl_prim_loader.html#get_file/1"},{"type":"function","title":"erl_prim_loader.get_path/0","doc":"_Use of this function is deprecated in favor of `code:get_path/0`._\n\nGets the path set in the loader. The path is set by the `m:init` process\naccording to information found in the start script.","ref":"erl_prim_loader.html#get_path/0"},{"type":"function","title":"erl_prim_loader.list_dir/1","doc":"Lists all the files in a directory.\n\nReturns `{ok, Filenames}` if successful, otherwise `error`. `Filenames`\nis a list of the names of all the files in the directory. The names are\nnot sorted.\n\n`Dir` can also be a directory in an archive, for example,\n`$OTPROOT/lib/mnesia-4.4.7.ez/mnesia-4.4.7/ebin`. For information about\narchive files, see `m:code`.","ref":"erl_prim_loader.html#list_dir/1"},{"type":"function","title":"erl_prim_loader.read_file/1","doc":"Reads a file using the low-level loader.\n\nReturns `{ok, Bin}` if successful, otherwise `error`. `Bin` is the contents\nof the file as a binary.\n\n`Filename` can also be a file in an archive, for example,\n`$OTPROOT/lib/mnesia-4.4.7.ez/mnesia-4.4.7/ebin/mnesia.beam`. For\ninformation about archive files, see `m:code`.","ref":"erl_prim_loader.html#read_file/1"},{"type":"function","title":"erl_prim_loader.read_file_info/1","doc":"Retrieves information about a file.\n\nReturns `{ok, FileInfo}` if successful, otherwise `error`. `FileInfo` is a\nrecord [`file_info`](`t:file:file_info/0`), defined in the Kernel include file\n `file.hrl`. Include the following directive in the module from which the\nfunction is called:\n\n```erlang\n-include_lib(\"kernel/include/file.hrl\").\n```\n\nFor more information about the record see `file:read_file_info/2`.\n\n`Filename` can also be a file in an archive, for example,\n`$OTPROOT/lib/mnesia-4.4.7.ez/mnesia-4.4.7/ebin/mnesia`. For information\nabout archive files, see `m:code`.","ref":"erl_prim_loader.html#read_file_info/1"},{"type":"function","title":"erl_prim_loader.read_link_info/1","doc":"Works like `read_file_info/1` except that if `Filename` is a symbolic link,\ninformation about the link is returned in the [`file_info`](`t:file:file_info/0`)\nrecord and the `type` field of the record is set to `symlink`.\n\nIf `Filename` is not a symbolic link, this function returns exactly the same\nresult as [`read_file_info/1`](`read_file_info/1`). On platforms that do not\nsupport symbolic links, this function is always equivalent to\n[`read_file_info/1`](`read_file_info/1`).","ref":"erl_prim_loader.html#read_link_info/1"},{"type":"function","title":"erl_prim_loader.set_path/1","doc":"Sets the path of the loader if `m:init` interprets a `path` command in the start\nscript.","ref":"erl_prim_loader.html#set_path/1"},{"type":"behaviour","title":"erl_tracer","doc":"Erlang tracer behavior.\n\nThis behavior module implements the back end of the Erlang tracing system. The\nfunctions in this module are called whenever a trace probe is triggered. Both\nthe `enabled` and `trace` functions are called in the context of the entity that\ntriggered the trace probe. This means that the overhead by having the tracing\nenabled is greatly effected by how much time is spent in these functions. So, do\nas little work as possible in these functions.\n\n> #### Note {: .info }\n>\n> All functions in this behavior must be implemented as NIFs. This limitation\n> can be removed in a future releases. An\n> [example tracer module NIF](`m:erl_tracer#example`) implementation is provided\n> below.\n\n> #### Warning {: .warning }\n>\n> Do not send messages or issue port commands to the `Tracee` in any of the\n> callbacks. This is not allowed and can cause all sorts of strange behavior,\n> including, but not limited to, infinite recursions.\n\n[](){: #example }","ref":"erl_tracer.html"},{"type":"behaviour","title":"Erl Tracer Module Example - erl_tracer","doc":"In this example, a tracer module with a NIF back end sends a message for each\n`send` trace tag containing only the sender and receiver. Using this tracer\nmodule, a much more lightweight message tracer is used, which only records who\nsent messages to who.\n\nThe following is an example session using it on Linux:\n\n```erlang\n$ gcc -I erts-8.0/include/ -fPIC -shared -o erl_msg_tracer.so erl_msg_tracer.c\n$ erl\nErlang/OTP 19 [DEVELOPMENT] [erts-8.0] [source-ed2b56b] [64-bit] [smp:8:8] [async-threads:10] [hipe] [kernel-poll:false]\n\nEshell V8.0  (abort with ^G)\n1> c(erl_msg_tracer), erl_msg_tracer:load().\nok\n2> Tracer = spawn(fun F() -> receive M -> io:format(\"~p~n\",[M]), F() end end).\n<0.37.0>\n3> erlang:trace(new, true, [send,{tracer, erl_msg_tracer, Tracer}]).\n0\n{trace,<0.39.0>,<0.27.0>}\n4> {ok, D} = file:open(\"/tmp/tmp.data\",[write]).\n{trace,#Port<0.486>,<0.40.0>}\n{trace,<0.40.0>,<0.21.0>}\n{trace,#Port<0.487>,<0.4.0>}\n{trace,#Port<0.488>,<0.4.0>}\n{trace,#Port<0.489>,<0.4.0>}\n{trace,#Port<0.490>,<0.4.0>}\n{ok,<0.40.0>}\n{trace,<0.41.0>,<0.27.0>}\n5>\n```\n\n`erl_msg_tracer.erl`:\n\n```erlang\n-module(erl_msg_tracer).\n\n-export([enabled/3, trace/5, load/0]).\n\nload() ->\n    erlang:load_nif(\"erl_msg_tracer\", []).\n\nenabled(_, _, _) ->\n    error.\n\ntrace(_, _, _, _, _) ->\n    error.\n```\n\n`erl_msg_tracer.c`:\n\n```c\n#include  \n\n/* NIF interface declarations */\nstatic int load(ErlNifEnv* env, void** priv_data, ERL_NIF_TERM load_info);\nstatic int upgrade(ErlNifEnv* env, void** priv_data, void** old_priv_data, ERL_NIF_TERM load_info);\nstatic void unload(ErlNifEnv* env, void* priv_data);\n\n/* The NIFs: */\nstatic ERL_NIF_TERM enabled(ErlNifEnv* env, int argc, const ERL_NIF_TERM argv[]);\nstatic ERL_NIF_TERM trace(ErlNifEnv* env, int argc, const ERL_NIF_TERM argv[]);\n\nstatic ErlNifFunc nif_funcs[] = {\n    {\"enabled\", 3, enabled},\n    {\"trace\", 5, trace}\n};\n\nERL_NIF_INIT(erl_msg_tracer, nif_funcs, load, NULL, upgrade, unload)\n\nstatic int load(ErlNifEnv* env, void** priv_data, ERL_NIF_TERM load_info)\n{\n    *priv_data = NULL;\n    return 0;\n}\n\nstatic void unload(ErlNifEnv* env, void* priv_data)\n{\n\n}\n\nstatic int upgrade(ErlNifEnv* env, void** priv_data, void** old_priv_data,\n\t\t   ERL_NIF_TERM load_info)\n{\n    if (*old_priv_data != NULL || *priv_data != NULL) {\n\treturn -1; /* Don't know how to do that */\n    }\n    if (load(env, priv_data, load_info)) {\n\treturn -1;\n    }\n    return 0;\n}\n\n/*\n * argv[0]: TraceTag\n * argv[1]: TracerState\n * argv[2]: Tracee\n */\nstatic ERL_NIF_TERM enabled(ErlNifEnv* env, int argc, const ERL_NIF_TERM argv[])\n{\n    ErlNifPid to_pid;\n    if (enif_get_local_pid(env, argv[1], &to_pid))\n        if (!enif_is_process_alive(env, &to_pid))\n            if (enif_is_identical(enif_make_atom(env, \"trace_status\"), argv[0]))\n                /* tracer is dead so we should remove this tracepoint */\n                return enif_make_atom(env, \"remove\");\n            else\n                return enif_make_atom(env, \"discard\");\n\n    /* Only generate trace for when tracer != tracee */\n    if (enif_is_identical(argv[1], argv[2]))\n        return enif_make_atom(env, \"discard\");\n\n    /* Only trigger trace messages on 'send' */\n    if (enif_is_identical(enif_make_atom(env, \"send\"), argv[0]))\n        return enif_make_atom(env, \"trace\");\n\n    /* Have to answer trace_status */\n    if (enif_is_identical(enif_make_atom(env, \"trace_status\"), argv[0]))\n        return enif_make_atom(env, \"trace\");\n\n    return enif_make_atom(env, \"discard\");\n}\n\n/*\n * argv[0]: TraceTag, should only be 'send'\n * argv[1]: TracerState, process to send {Tracee, Recipient} to\n * argv[2]: Tracee\n * argv[3]: Message\n * argv[4]: Options, map containing Recipient\n */\nstatic ERL_NIF_TERM trace(ErlNifEnv* env, int argc, const ERL_NIF_TERM argv[])\n{\n    ErlNifPid to_pid;\n    ERL_NIF_TERM recipient, msg;\n\n    if (enif_get_local_pid(env, argv[1], &to_pid)) {\n      if (enif_get_map_value(env, argv[4], enif_make_atom(env, \"extra\"), &recipient)) {\n        msg = enif_make_tuple3(env, enif_make_atom(env, \"trace\"), argv[2], recipient);\n        enif_send(env, &to_pid, NULL, msg);\n      }\n    }\n\n    return enif_make_atom(env, \"ok\");\n}\n```","ref":"erl_tracer.html#module-erl-tracer-module-example"},{"type":"callback","title":"erl_tracer.enabled/3","doc":"This callback is called whenever a tracepoint is triggered.\n\nIt allows the tracer to decide whether a trace is to be generated or not. This\ncheck is made as early as possible to limit the amount of overhead associated\nwith tracing. If `trace` is returned, the necessary trace data is created and\nthe trace callback of the tracer is called. If `discard` is returned, this trace\ncall is discarded and no call to trace is done.\n\n`trace_status` is a special type of `TraceTag`, which is used to check if the\ntracer is still to be active. It is called in multiple scenarios, but most\nsignificantly it is used when tracing is started using this tracer. If `remove`\nis returned when the `trace_status` is checked, the tracer is removed from the\ntracee.\n\nThis function can be called multiple times per tracepoint, so it is important\nthat it is both fast and without side effects.","ref":"erl_tracer.html#c:enabled/3"},{"type":"callback","title":"erl_tracer.enabled_call/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`call | return_to`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_call/3`](`c:enabled_call/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_call/3"},{"type":"callback","title":"erl_tracer.enabled_garbage_collection/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`garbage_collection`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_garbage_collection/3`](`c:enabled_garbage_collection/3`) is\nundefined, [`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_garbage_collection/3"},{"type":"callback","title":"erl_tracer.enabled_ports/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`ports`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_ports/3`](`c:enabled_ports/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_ports/3"},{"type":"callback","title":"erl_tracer.enabled_procs/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`procs`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_procs/3`](`c:enabled_procs/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_procs/3"},{"type":"callback","title":"erl_tracer.enabled_receive/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`'receive'`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_receive/3`](`c:enabled_receive/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_receive/3"},{"type":"callback","title":"erl_tracer.enabled_running_ports/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`running_ports`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_running_ports/3`](`c:enabled_running_ports/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_running_ports/3"},{"type":"callback","title":"erl_tracer.enabled_running_procs/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`running_procs | running`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_running_procs/3`](`c:enabled_running_procs/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_running_procs/3"},{"type":"callback","title":"erl_tracer.enabled_send/3","doc":"This callback is called whenever a tracepoint with trace flag\n[`send`](`erlang:trace/3`) is triggered.\n\nIf [`enabled_send/3`](`c:enabled_send/3`) is undefined,\n[`Module:enabled/3`](`c:enabled/3`) is called instead.","ref":"erl_tracer.html#c:enabled_send/3"},{"type":"callback","title":"erl_tracer.trace/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled/3`](`c:enabled/3`) callback returned `trace`.\n\nIn it any side effects needed by the tracer are to be done. The tracepoint\npayload is located in the `TraceTerm`. The content of the `TraceTerm` depends on\nwhich `TraceTag` is triggered. `TraceTerm` corresponds to the fourth element in\nthe trace tuples described in [`trace:process/4`](`m:trace#process_trace_messages`).\n\nIf the trace tuple has five elements, the fifth element will be sent as the\n`extra` value in the `Opts` maps.\n\nThe `TraceTag` `seq_trace` is handled slightly differently. There is no `Tracee`\nfor `seq_trace`, instead the `Label` associated with the `seq_trace` event is\nspecified.\n\nFor more information on what `Label` and `SeqTraceInfo` can be, see\n`m:seq_trace`.","ref":"erl_tracer.html#c:trace/5"},{"type":"callback","title":"erl_tracer.trace_call/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_call/3`](`c:enabled_call/3`) callback returned `trace`.\n\nIf [`trace_call/5`](`c:trace_call/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_call/5"},{"type":"callback","title":"erl_tracer.trace_garbage_collection/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_garbage_collection/3`](`c:enabled_garbage_collection/3`)\ncallback returned `trace`.\n\nIf [`trace_garbage_collection/5`](`c:trace_garbage_collection/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_garbage_collection/5"},{"type":"type","title":"erl_tracer.trace_opts/0","doc":"The options for the tracee:\n\n- **`timestamp`** - If set the tracer has been requested to include a time\n  stamp.\n\n- **`extra`** - If set the tracepoint has included additional data about the\n  trace event. What the additional data is depends on which `TraceTag` has been\n  triggered. The `extra` trace data corresponds to the fifth element in the\n  trace tuples described in [trace:process/4](`m:trace#process_trace_messages`).\n\n- **`match_spec_result`** - If set the tracer has been requested to include the\n  output of a match specification that was run.\n\n- **`scheduler_id`** - If set the scheduler id is to be included by the tracer.","ref":"erl_tracer.html#t:trace_opts/0"},{"type":"callback","title":"erl_tracer.trace_ports/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_ports/3`](`c:enabled_ports/3`) callback returned `trace`.\n\nIf [`trace_ports/5`](`c:trace_ports/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_ports/5"},{"type":"callback","title":"erl_tracer.trace_procs/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_procs/3`](`c:enabled_procs/3`) callback returned `trace`.\n\nIf [`trace_procs/5`](`c:trace_procs/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_procs/5"},{"type":"callback","title":"erl_tracer.trace_receive/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_receive/3`](`c:enabled_receive/3`) callback returned `trace`.\n\nIf [`trace_receive/5`](`c:trace_receive/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_receive/5"},{"type":"callback","title":"erl_tracer.trace_running_ports/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_running_ports/3`](`c:enabled_running_ports/3`) callback\nreturned `trace`.\n\nIf [`trace_running_ports/5`](`c:trace_running_ports/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_running_ports/5"},{"type":"callback","title":"erl_tracer.trace_running_procs/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_running_procs/3`](`c:enabled_running_procs/3`) callback\nreturned `trace`.\n\nIf [`trace_running_procs/5`](`c:trace_running_procs/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_running_procs/5"},{"type":"callback","title":"erl_tracer.trace_send/5","doc":"This callback is called when a tracepoint is triggered and the\n[`Module:enabled_send/3`](`c:enabled_send/3`) callback returned `trace`.\n\nIf [`trace_send/5`](`c:trace_send/5`) is undefined,\n[`Module:trace/5`](`c:trace/5`) is called instead.","ref":"erl_tracer.html#c:trace_send/5"},{"type":"type","title":"erl_tracer.trace_tag/0","doc":"The different trace tags that the tracer is called with.\n\nEach trace tag is described in detail in [`Module:trace/5`](`c:trace/5`).","ref":"erl_tracer.html#t:trace_tag/0"},{"type":"type","title":"erl_tracer.trace_tag_call/0","doc":"","ref":"erl_tracer.html#t:trace_tag_call/0"},{"type":"type","title":"erl_tracer.trace_tag_gc/0","doc":"","ref":"erl_tracer.html#t:trace_tag_gc/0"},{"type":"type","title":"erl_tracer.trace_tag_ports/0","doc":"","ref":"erl_tracer.html#t:trace_tag_ports/0"},{"type":"type","title":"erl_tracer.trace_tag_procs/0","doc":"","ref":"erl_tracer.html#t:trace_tag_procs/0"},{"type":"type","title":"erl_tracer.trace_tag_receive/0","doc":"","ref":"erl_tracer.html#t:trace_tag_receive/0"},{"type":"type","title":"erl_tracer.trace_tag_running_ports/0","doc":"","ref":"erl_tracer.html#t:trace_tag_running_ports/0"},{"type":"type","title":"erl_tracer.trace_tag_running_procs/0","doc":"","ref":"erl_tracer.html#t:trace_tag_running_procs/0"},{"type":"type","title":"erl_tracer.trace_tag_send/0","doc":"","ref":"erl_tracer.html#t:trace_tag_send/0"},{"type":"type","title":"erl_tracer.tracee/0","doc":"The process or port that the trace belongs to.","ref":"erl_tracer.html#t:tracee/0"},{"type":"module","title":"erlang","doc":"The Erlang BIFs and predefined types.\n\nBy convention, most [Built-In Functions](`e:system:ref_man_functions.md#built-in-functions-bifs`)\n(BIFs) and all [predefined types](`e:system:typespec.md#predefined`) are included\nin this module. Some of the BIFs and all of the predefined types are viewed more\nor less as part of the Erlang programming language and are _auto-imported_.\nThus, it is not necessary to specify the module name. For example, the calls\n[`atom_to_list(erlang)`](`atom_to_list/1`) and [`erlang:atom_to_list(erlang)`](`atom_to_list/1`)\nare identical.\n\nAuto-imported BIFs are annotated with `auto-imported` and predefined types are\nannotated with `predefined`.\n\nSome auto-imported BIFs are also allowed in [guard expression](`e:system:expressions.md#guard-expressions`).\nSuch BIFs are annoted with both `auto-imported` and `guard-bif`.\n\nBIFs can fail for various reasons. All BIFs fail with reason `badarg` if they\nare called with arguments of an incorrect type. The other reasons are described\nin the description of each individual BIF.","ref":"erlang.html"},{"type":"type","title":"erlang./0","doc":"The empty `t:list/0`.","ref":"erlang.html#t:nil/0"},{"type":"function","title":"erlang.abs/1","doc":"Returns an integer or float that is the arithmetical absolute value of `Float`\nor `Int`.\n\nFor example:\n\n```erlang\n> abs(-3.33).\n3.33\n> abs(-3).\n3\n```","ref":"erlang.html#abs/1"},{"type":"function","title":"erlang.adler32/1","doc":"Computes and returns the adler32 checksum for `Data`.","ref":"erlang.html#adler32/1"},{"type":"function","title":"erlang.adler32/2","doc":"Continues computing the adler32 checksum by combining the previous checksum,\n`OldAdler`, with the checksum of `Data`.\n\nThe following code:\n\n```erlang\nX = erlang:adler32(Data1),\nY = erlang:adler32(X,Data2).\n```\n\nassigns the same value to `Y` as this:\n\n```erlang\nY = erlang:adler32([Data1,Data2]).\n```","ref":"erlang.html#adler32/2"},{"type":"function","title":"erlang.adler32_combine/3","doc":"Combines two previously computed adler32 checksums.\n\nThis computation requires the size of the data object for the second checksum\nto be known.\n\nThe following code:\n\n```erlang\nY = erlang:adler32(Data1),\nZ = erlang:adler32(Y,Data2).\n```\n\nassigns the same value to `Z` as this:\n\n```erlang\nX = erlang:adler32(Data1),\nY = erlang:adler32(Data2),\nZ = erlang:adler32_combine(X,Y,iolist_size(Data2)).\n```","ref":"erlang.html#adler32_combine/3"},{"type":"function","title":"erlang.alias/0","doc":"","ref":"erlang.html#alias/0"},{"type":"function","title":"erlang.alias/1","doc":"Create an alias which can be used when sending messages to the process that\ncreated the alias. When the alias has been deactivated, messages sent using the\nalias will be dropped. An alias can be deactivated using `unalias/1`.\n\nCurrently available options for [`alias/1`](`alias/1`):\n\n- **`explicit_unalias`** - The alias can only be deactivated via a call to\n  [`unalias/1`](`unalias/1`). This is also the default behaviour if no options\n  are passed or if `alias/0` is called.\n\n- **`reply`** - The alias will be automatically deactivated when a reply message\n  sent via the alias is received. The alias can also still be deactivated via a\n  call to [`unalias/1`](`unalias/1`).\n\nExample:\n\n```erlang\nserver() ->\n    receive\n        {request, AliasReqId, Request} ->\n            Result = perform_request(Request),\n            AliasReqId ! {reply, AliasReqId, Result}\n    end,\n    server().\n\nclient(ServerPid, Request) ->\n    AliasReqId = alias([reply]),\n    ServerPid ! {request, AliasReqId, Request},\n    %% Alias will be automatically deactivated if we receive a reply\n    %% since we used the 'reply' option...\n    receive\n        {reply, AliasReqId, Result} -> Result\n    after 5000 ->\n            unalias(AliasReqId),\n            %% Flush message queue in case the reply arrived\n            %% just before the alias was deactivated...\n            receive {reply, AliasReqId, Result} -> Result\n            after 0 -> exit(timeout)\n            end\n    end.\n```\n\nNote that both the server and the client in this example must be executing on at\nleast OTP 24 systems in order for this to work.\n\nFor more information on process aliases see the\n[_Process Aliases_](`e:system:ref_man_processes.md#process-aliases`) section of\nthe _Erlang Reference Manual_.","ref":"erlang.html#alias/1"},{"type":"type","title":"erlang.any/0","doc":"All possible Erlang terms. Synonym for `t:term/0`.","ref":"erlang.html#t:any/0"},{"type":"function","title":"erlang.append_element/2","doc":"Returns a new tuple that has one element more than `Tuple1`, and contains the\nelements in `Tuple1` followed by `Term` as the last element.\n\nSemantically equivalent to\n[`list_to_tuple(tuple_to_list(Tuple1) ++ [Term])`](`list_to_tuple/1`), but much\nfaster.\n\nFor example:\n\n```erlang\n> erlang:append_element({one, two}, three).\n{one,two,three}\n```","ref":"erlang.html#append_element/2"},{"type":"function","title":"erlang.apply/2","doc":"Calls a fun, passing the elements in `Args` as arguments.\n\nIf the number of elements in the arguments are known at compile time, the call\nis better written as `Fun(Arg1, Arg2, ... ArgN)`.\n\n> #### Warning {: .warning }\n>\n> Earlier, `Fun` could also be specified as `{Module, Function}`, equivalent to\n> [`apply(Module, Function, Args)`](`apply/3`). _This use is deprecated and will\n> stop working in a future release._","ref":"erlang.html#apply/2"},{"type":"function","title":"erlang.apply/3","doc":"Returns the result of applying `Function` in `Module` to `Args`. The applied\nfunction must be exported from `Module`. The arity of the function is the length\nof `Args`.\n\nFor example:\n\n```erlang\n> apply(lists, reverse, [[a, b, c]]).\n[c,b,a]\n> apply(erlang, atom_to_list, ['Erlang']).\n\"Erlang\"\n```\n\nIf the number of arguments are known at compile time, the call is better written\nas `Module:Function(Arg1, Arg2, ..., ArgN)`.\n\nFailure: `error_handler:undefined_function/3` is called if the applied function\nis not exported. The error handler can be redefined (see `process_flag/2`). If\n`error_handler` is undefined, or if the user has redefined the default\n`error_handler` so the replacement module is undefined, an error with reason\n`undef` is generated.","ref":"erlang.html#apply/3"},{"type":"type","title":"erlang.arity/0","doc":"The arity of a function or type.","ref":"erlang.html#t:arity/0"},{"type":"type","title":"erlang.atom/0","doc":"An Erlang [atom](`e:system:data_types.md#atom`).","ref":"erlang.html#t:atom/0"},{"type":"function","title":"erlang.atom_to_binary/1","doc":"","ref":"erlang.html#atom_to_binary/1"},{"type":"function","title":"erlang.atom_to_binary/2","doc":"Returns a binary corresponding to the text representation of `Atom`.\n\nIf `Encoding` is `latin1`, one byte exists for each character in the text\nrepresentation. If `Encoding` is `utf8` or `unicode`, the characters are encoded\nusing UTF-8 where characters may require multiple bytes.\n\n> #### Change {: .info }\n>\n> As from Erlang/OTP 20, atoms can contain any Unicode character and\n> [`atom_to_binary(Atom, latin1)`](`atom_to_binary/2`) may fail if the text\n> representation for `Atom` contains a Unicode character > 255.\n\nExample:\n\n```erlang\n> atom_to_binary('Erlang', latin1).\n<<\"Erlang\">>\n```","ref":"erlang.html#atom_to_binary/2"},{"type":"function","title":"erlang.atom_to_list/1","doc":"Returns a list of unicode code points corresponding to the text representation\nof `Atom`.\n\nFor example:\n\n```erlang\n> atom_to_list('Erlang').\n\"Erlang\"\n```\n\n```erlang\n> atom_to_list('你好').\n[20320,22909]\n```\n\nSee `m:unicode` for how to convert the resulting list to different formats.","ref":"erlang.html#atom_to_list/1"},{"type":"type","title":"erlang.binary/0","doc":"An Erlang [binary](`e:system:data_types.md#bit-strings-and-binaries`), that is,\na bitstring with a size divisible by 8.","ref":"erlang.html#t:binary/0"},{"type":"function","title":"erlang.binary_part/2","doc":"Extracts the part of the binary described by `PosLen`.\n\nNegative length can be used to extract bytes at the end of a binary. \n\nFor example:\n\n```erlang\n1> Bin = <<1,2,3,4,5,6,7,8,9,10>>.\n2> binary_part(Bin,{byte_size(Bin), -5}).\n<<6,7,8,9,10>>\n```\n\nFailure: `badarg` if `PosLen` in any way references outside the binary.\n\n`Start` is zero-based, that is:\n\n```erlang\n1> Bin = <<1,2,3>>\n2> binary_part(Bin,{0,2}).\n<<1,2>>\n```\n\nFor details about the `PosLen` semantics, see `m:binary`.","ref":"erlang.html#binary_part/2"},{"type":"function","title":"erlang.binary_part/3","doc":"","ref":"erlang.html#binary_part/3"},{"type":"function","title":"erlang.binary_to_atom/1","doc":"","ref":"erlang.html#binary_to_atom/1"},{"type":"function","title":"erlang.binary_to_atom/2","doc":"Returns the atom whose text representation is `Binary`. If `Encoding` is `utf8`\nor `unicode`, the binary must contain valid UTF-8 sequences.\n\n> #### Change {: .info }\n>\n> As from Erlang/OTP 20, [`binary_to_atom(Binary, utf8)`](`binary_to_atom/2`) is\n> capable of decoding any Unicode character. Earlier versions would fail if the\n> binary contained Unicode characters > 255.\n\n> #### Note {: .info }\n>\n> The number of characters that are permitted in an atom name is limited. The\n> default limits can be found in the\n> [Efficiency Guide (section System Limits)](`e:system:system_limits.md`).\n\n> #### Note {: .info }\n>\n> There is configurable limit on how many atoms that can exist and atoms are not\n> garbage collected. Therefore, it is recommended to consider whether\n> [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`) is a better option\n> than [`binary_to_atom/2`](`binary_to_atom/2`). The default limits can be found\n> in [Efficiency Guide (section System Limits)](`e:system:system_limits.md#atoms`).\n\nExamples:\n\n```erlang\n> binary_to_atom(<<\"Erlang\">>, latin1).\n'Erlang'\n```\n\n```erlang\n> binary_to_atom(<<1024/utf8>>, utf8).\n'Ѐ'\n```","ref":"erlang.html#binary_to_atom/2"},{"type":"function","title":"erlang.binary_to_existing_atom/1","doc":"","ref":"erlang.html#binary_to_existing_atom/1"},{"type":"function","title":"erlang.binary_to_existing_atom/2","doc":"As `binary_to_atom/2`, but the atom must exist.\n\nThe Erlang system has a [configurable limit](`e:system:system_limits.md#atoms`) for the\ntotal number of atoms that can exist, and atoms are not garbage collected.\nTherefore, it is not safe to create many atoms from binaries that come from an\nuntrusted source (for example, a file fetched from the Internet), for example,\nusing `binary_to_atom/2`. This function is thus the appropriate option when the\ninput binary comes from an untrusted source.\n\nAn atom exists in an Erlang system when included in a loaded Erlang module or\nwhen created programmatically (for example, by\n[`binary_to_atom/2`](`binary_to_atom/2`)). See the next note for an example of\nwhen an atom exists in the source code for an Erlang module but not in the\ncompiled version of the same module.\n\nFailure: `badarg` if the atom does not exist.\n\n> #### Note {: .info }\n>\n> Note that the compiler may optimize away atoms. For example, the compiler will\n> rewrite [`atom_to_list(some_atom)`](`atom_to_list/1`) to `\"some_atom\"`. If\n> that expression is the only mention of the atom `some_atom` in the containing\n> module, the atom will not be created when the module is loaded, and a\n> subsequent call to\n> [`binary_to_existing_atom(<<\"some_atom\">>, utf8)`](`binary_to_existing_atom/2`)\n> will fail.\n\n> #### Note {: .info }\n>\n> The number of characters that are permitted in an atom name is limited. The\n> default limits can be found in the\n> [Efficiency Guide (section System Limits)](`e:system:system_limits.md`).","ref":"erlang.html#binary_to_existing_atom/2"},{"type":"function","title":"erlang.binary_to_float/1","doc":"Returns the float whose text representation is `Binary`.\n\nFor example:\n\n```erlang\n> binary_to_float(<<\"2.2017764e+0\">>).\n2.2017764\n```\n\nThe float string format is the same as the format for\n[Erlang float literals](`e:system:data_types.md`) except for that underscores\nare not permitted.\n\nFailure: `badarg` if `Binary` contains a bad representation of a float.","ref":"erlang.html#binary_to_float/1"},{"type":"function","title":"erlang.binary_to_integer/1","doc":"Returns an integer whose text representation is `Binary`.\n\nFor example:\n\n```erlang\n> binary_to_integer(<<\"123\">>).\n123\n```\n\n[`binary_to_integer/1`](`binary_to_integer/1`) accepts the same string formats\nas `list_to_integer/1`.\n\nFailure: `badarg` if `Binary` contains a bad representation of an integer.","ref":"erlang.html#binary_to_integer/1"},{"type":"function","title":"erlang.binary_to_integer/2","doc":"Returns an integer whose text representation in base `Base` is `Binary`.\n\nFor example:\n\n```erlang\n> binary_to_integer(<<\"3FF\">>, 16).\n1023\n```\n\n[`binary_to_integer/2`](`binary_to_integer/2`) accepts the same string formats\nas `list_to_integer/2`.\n\nFailure: `badarg` if `Binary` contains a bad representation of an integer.","ref":"erlang.html#binary_to_integer/2"},{"type":"function","title":"erlang.binary_to_list/1","doc":"Returns a list of integers corresponding to the bytes of `Binary`.","ref":"erlang.html#binary_to_list/1"},{"type":"function","title":"erlang.binary_to_list/3","doc":"As [`binary_to_list/1`](`binary_to_list/1`), but returns a list of integers\ncorresponding to the bytes from position `Start` to position `Stop` in `Binary`.\nThe positions in the binary are numbered starting from 1.\n\n> #### Note {: .info }\n>\n> _The one-based indexing for binaries used by this function is deprecated._ New\n> code is to use `binary:bin_to_list/3` in STDLIB instead. All functions in\n> module `binary` consistently use zero-based indexing.","ref":"erlang.html#binary_to_list/3"},{"type":"function","title":"erlang.binary_to_term/1","doc":"Returns an Erlang term that is the result of decoding binary object `Binary`,\nwhich must be encoded according to the\n[Erlang external term format](erl_ext_dist.md).\n\n```erlang\n> Bin = term_to_binary(hello).\n<<131,100,0,5,104,101,108,108,111>>\n> hello = binary_to_term(Bin).\nhello\n```\n\n> #### Warning {: .warning }\n>\n> When decoding binaries from untrusted sources, the untrusted source may submit\n> data in a way to create resources, such as atoms and remote references, that\n> cannot be garbage collected and lead to Denial of Service attack. In such\n> cases, consider using [`binary_to_term/2`](`binary_to_term/2`) with the `safe`\n> option.\n\nSee also `term_to_binary/1` and `binary_to_term/2`.","ref":"erlang.html#binary_to_term/1"},{"type":"function","title":"erlang.binary_to_term/2","doc":"Equivalent to [`binary_to_term(Binary)`](`binary_to_term/1`), but can be configured to\nfit special purposes.\n\nThe allowed options are:\n\n- **`safe`** - Use this option when receiving binaries from an untrusted source.\n\n  When enabled, it prevents decoding data that can be used to attack the Erlang\n  runtime. In the event of receiving unsafe data, decoding fails with a `badarg`\n  error.\n\n  This prevents creation of new atoms directly, creation of new atoms indirectly\n  (as they are embedded in certain structures, such as process identifiers,\n  refs, and funs), and creation of new external function references. None of\n  those resources are garbage collected, so unchecked creation of them can\n  exhaust available memory.\n\n  ```erlang\n  > binary_to_term(<<131,100,0,5,\"hello\">>, [safe]).\n  ** exception error: bad argument\n  > hello.\n  hello\n  > binary_to_term(<<131,100,0,5,\"hello\">>, [safe]).\n  hello\n  ```\n\n  > #### Warning {: .warning }\n  >\n  > The `safe` option ensures the data is safely processed by the Erlang runtime\n  > but it does not guarantee the data is safe to your application. You must\n  > always validate data from untrusted sources. If the binary is stored or\n  > transits through untrusted sources, you should also consider\n  > cryptographically signing it.\n\n- **`used`** - Changes the return value to `{Term, Used}` where `Used` is the\n  number of bytes actually read from `Binary`.\n\n  ```erlang\n  > Input = <<131,100,0,5,\"hello\",\"world\">>.\n  <<131,100,0,5,104,101,108,108,111,119,111,114,108,100>>\n  > {Term, Used} = binary_to_term(Input, [used]).\n  {hello, 9}\n  > split_binary(Input, Used).\n  {<<131,100,0,5,104,101,108,108,111>>, <<\"world\">>}\n  ```\n\nFailure: `badarg` if `safe` is specified and unsafe data is decoded.\n\nSee also `term_to_binary/1`, `binary_to_term/1`, and `list_to_existing_atom/1`.","ref":"erlang.html#binary_to_term/2"},{"type":"function","title":"erlang.bit_size/1","doc":"Returns an integer that is the size in bits of `Bitstring`.\n\nFor example:\n\n```erlang\n> bit_size(<<433:16,3:3>>).\n19\n> bit_size(<<1,2,3>>).\n24\n```","ref":"erlang.html#bit_size/1"},{"type":"type","title":"erlang.bitstring/0","doc":"An Erlang [bitstring](`e:system:data_types.md#bit-strings-and-binaries`).","ref":"erlang.html#t:bitstring/0"},{"type":"type","title":"erlang.bitstring_list/0","doc":"","ref":"erlang.html#t:bitstring_list/0"},{"type":"function","title":"erlang.bitstring_to_list/1","doc":"Returns a list of integers corresponding to the bytes of `Bitstring`.\n\nIf the number of bits in the binary is not divisible by 8, the last element of\nthe list is a bitstring containing the remaining 1-7 bits.\n\nFor example:\n\n```erlang\n> bitstring_to_list(<<433:16>>).\n[1,177]\n```\n\n```erlang\n> bitstring_to_list(<<433:16,3:3>>).\n[1,177,<<3:3>>]\n```","ref":"erlang.html#bitstring_to_list/1"},{"type":"type","title":"erlang.boolean/0","doc":"A [boolean](`e:system:data_types.md#boolean`) value.","ref":"erlang.html#t:boolean/0"},{"type":"function","title":"erlang.bump_reductions/1","doc":"This implementation-dependent function increments the reduction counter for the\ncalling process.\n\nIn the Beam emulator, the reduction counter is normally incremented by one for\neach function and BIF call. A context switch is forced when the counter reaches\nthe maximum number of reductions for a process (4000 reductions in Erlang/OTP 19.2 and later).\n\n> #### Warning {: .warning }\n>\n> This BIF can be removed in a future version of the Beam machine without prior\n> warning. It is unlikely to be implemented in other Erlang implementations.","ref":"erlang.html#bump_reductions/1"},{"type":"type","title":"erlang.byte/0","doc":"A byte of data represented by an integer.","ref":"erlang.html#t:byte/0"},{"type":"function","title":"erlang.byte_size/1","doc":"Returns an integer that is the number of bytes needed to contain `Bitstring`.\nThat is, if the number of bits in `Bitstring` is not divisible by 8, the\nresulting number of bytes is rounded _up_.\n\nFor example:\n\n```erlang\n> byte_size(<<433:16,3:3>>).\n3\n> byte_size(<<1,2,3>>).\n3\n```","ref":"erlang.html#byte_size/1"},{"type":"function","title":"erlang.cancel_timer/1","doc":"","ref":"erlang.html#cancel_timer/1"},{"type":"function","title":"erlang.cancel_timer/2","doc":"Cancels a timer that has been created by [`erlang:start_timer`](`start_timer/4`)\nor [`erlang:send_after`](`send_after/4`). `TimerRef` identifies the timer, and\nwas returned by the BIF that created the timer.\n\n`Option`s:\n\n- **`{async, Async}`** - Asynchronous request for cancellation. `Async` defaults\n  to `false`, which causes the cancellation to be performed synchronously. When\n  `Async` is set to `true`, the cancel operation is performed asynchronously.\n  That is, `cancel_timer()` sends an asynchronous request for cancellation to\n  the timer service that manages the timer, and then returns `ok`.\n\n- **`{info, Info}`** - Requests information about the `Result` of the\n  cancellation. `Info` defaults to `true`, which means the `Result` is given.\n  When `Info` is set to `false`, no information about the result of the\n  cancellation is given.\n\n  - When `Async` is `false`: if `Info` is `true`, the `Result` is returned by\n    `erlang:cancel_timer()`. otherwise `ok` is returned.\n  - When `Async` is `true`: if `Info` is `true`, a message on the form\n    `{cancel_timer, TimerRef, Result}` is sent to the caller of\n    `erlang:cancel_timer()` when the cancellation operation has been performed,\n    otherwise no message is sent.\n\nMore `Option`s may be added in the future.\n\nIf `Result` is an integer, it represents the time in milliseconds left until the\ncanceled timer would have expired.\n\nIf `Result` is `false`, a timer corresponding to `TimerRef` could not be found.\nThis can be either because the timer had expired, already had been canceled, or\nbecause `TimerRef` never corresponded to a timer. Even if the timer had expired,\nit does not tell you if the time-out message has arrived at its destination yet.\n\n> #### Note {: .info }\n>\n> The timer service that manages the timer can be co-located with another\n> scheduler than the scheduler that the calling process is executing on. If so,\n> communication with the timer service takes much longer time than if it is\n> located locally. If the calling process is in critical path, and can do other\n> things while waiting for the result of this operation, or is not interested in\n> the result of the operation, you want to use option `{async, true}`. If using\n> option `{async, false}`, the calling process blocks until the operation has\n> been performed.\n\nSee also [`erlang:send_after/4`](`send_after/4`),\n[`erlang:start_timer/4`](`start_timer/4`), and\n[`erlang:read_timer/2`](`read_timer/2`).","ref":"erlang.html#cancel_timer/2"},{"type":"function","title":"erlang.ceil/1","doc":"Returns the smallest integer not less than `Number`.\n\nFor example:\n\n```erlang\n> ceil(5.5).\n6\n```","ref":"erlang.html#ceil/1"},{"type":"type","title":"erlang.char/0","doc":"An ASCII character or a `m:unicode` codepoint presented by an integer.","ref":"erlang.html#t:char/0"},{"type":"function","title":"erlang.check_old_code/1","doc":"Returns `true` if `Module` has\n[old code](`e:system:code_loading.md#code-replacement`), otherwise `false`.\n\nSee also `m:code`.","ref":"erlang.html#check_old_code/1"},{"type":"function","title":"erlang.check_process_code/2","doc":"","ref":"erlang.html#check_process_code/2"},{"type":"function","title":"erlang.check_process_code/3","doc":"Checks if the node local process identified by `Pid` executes old code for\n`Module`.\n\n`Option`s:\n\n- **`{allow_gc, boolean()}`** - Determines if garbage collection is allowed when\n  performing the operation. If `{allow_gc, false}` is passed, and a garbage\n  collection is needed to determine the result of the operation, the operation\n  is aborted (see information on `CheckResult` below). The default is to allow\n  garbage collection, that is, `{allow_gc, true}`.\n\n- **`{async, RequestId}`** - The function\n  [`check_process_code/3`](`check_process_code/3`) returns the value `async`\n  immediately after the request has been sent. When the request has been\n  processed, the process that called this function is passed a message on the\n  form `{check_process_code, RequestId, CheckResult}`.\n\nIf `Pid` equals `self/0`, and no `async` option has been passed, the operation\nis performed at once. Otherwise a request for the operation is sent to the\nprocess identified by `Pid`, and is handled when appropriate. If no `async`\noption has been passed, the caller blocks until `CheckResult` is available and\ncan be returned.\n\n`CheckResult` informs about the result of the request as follows:\n\n- **`true`** - The process identified by `Pid` executes old code for `Module`.\n  That is, the current call of the process executes old code for this module, or\n  the process has references to old code for this module, or the process\n  contains funs that references old code for this module.\n\n- **`false`** - The process identified by `Pid` does not execute old code for\n  `Module`.\n\n- **`aborted`** - The operation was aborted, as the process needed to be garbage\n  collected to determine the operation result, and the operation was requested\n  by passing option `{allow_gc, false}`.\n\n> #### Change {: .info }\n>\n> Up until ERTS version 8.\\*, the check process code operation checks for all\n> types of references to the old code. That is, direct references (e.g. return\n> addresses on the process stack), indirect references (`fun`s in process\n> context), and references to literals in the code.\n>\n> As of ERTS version 9.0, the check process code operation only checks for\n> direct references to the code. Indirect references via `fun`s will be ignored.\n> If such `fun`s exist and are used after a purge of the old code, an exception\n> will be raised upon usage (same as the case when the `fun` is received by the\n> process after the purge). Literals will be taken care of (copied) at a later\n> stage. This behavior can as of ERTS version 8.1 be enabled when\n> [building OTP](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring`),\n> and will automatically be enabled if dirty scheduler support is enabled.\n\nSee also `m:code`.\n\nFailures:\n\n- **`badarg`** - If `Pid` is not a node local process identifier.\n\n- **`badarg`** - If `Module` is not an atom.\n\n- **`badarg`** - If `OptionList` is an invalid list of options.","ref":"erlang.html#check_process_code/3"},{"type":"function","title":"erlang.convert_time_unit/3","doc":"Converts the `Time` value of time unit `FromUnit` to the corresponding\n`ConvertedTime` value of time unit `ToUnit`. The result is rounded using the\n`floor/1` function.\n\n> #### Warning {: .warning }\n>\n> You can lose accuracy and precision when converting between time units. To\n> minimize such loss, collect all data at `native` time unit and do the\n> conversion on the end result.","ref":"erlang.html#convert_time_unit/3"},{"type":"type","title":"erlang.cpu_topology/0","doc":"The current cpu topology.\n\n`node` refers to Non-Uniform Memory Access (NUMA) nodes. `thread` refers\nto hardware threads (for example, Intel hyper-threads).\n\nA level in term `CpuTopology` can be omitted if only one entry exists and\n`InfoList` is empty.\n\n`thread` can only be a sublevel to `core`. `core` can be a sublevel to\n`processor` or `node`. `processor` can be on the top level or a sublevel to\n`node`. `node` can be on the top level or a sublevel to `processor`. That\nis, NUMA nodes can be processor internal or processor external. A CPU\ntopology can consist of a mix of processor internal and external NUMA nodes,\nas long as each logical CPU belongs to _one_ NUMA node. Cache hierarchy is\nnot part of the `CpuTopology` type, but will be in a future release. Other\nthings can also make it into the CPU topology in a future release. So, expect\nthe `CpuTopology` type to change.","ref":"erlang.html#t:cpu_topology/0"},{"type":"function","title":"erlang.crc32/1","doc":"Computes and returns the crc32 (IEEE 802.3 style) checksum for `Data`.","ref":"erlang.html#crc32/1"},{"type":"function","title":"erlang.crc32/2","doc":"Continues computing the crc32 checksum by combining the previous checksum,\n`OldCrc`, with the checksum of `Data`.\n\nThe following code:\n\n```erlang\nX = erlang:crc32(Data1),\nY = erlang:crc32(X,Data2).\n```\n\nassigns the same value to `Y` as this:\n\n```erlang\nY = erlang:crc32([Data1,Data2]).\n```","ref":"erlang.html#crc32/2"},{"type":"function","title":"erlang.crc32_combine/3","doc":"Combines two previously computed crc32 checksums.\n\nThis computation requires the size of the data object for the second checksum\nto be known.\n\nThe following code:\n\n```erlang\nY = erlang:crc32(Data1),\nZ = erlang:crc32(Y,Data2).\n```\n\nassigns the same value to `Z` as this:\n\n```erlang\nX = erlang:crc32(Data1),\nY = erlang:crc32(Data2),\nZ = erlang:crc32_combine(X,Y,iolist_size(Data2)).\n```","ref":"erlang.html#crc32_combine/3"},{"type":"function","title":"erlang.date/0","doc":"Returns the current date as `{Year, Month, Day}`.\n\nThe time zone and Daylight Saving Time correction depend on the underlying OS.\nThe return value is based on the\n[OS System Time](time_correction.md#os-system-time).\n\nFor example:\n\n```erlang\n> date().\n{1995,2,19}\n```","ref":"erlang.html#date/0"},{"type":"function","title":"erlang.decode_packet/3","doc":"Decodes the binary `Bin` according to the packet protocol specified by `Type`.\nSimilar to the packet handling done by sockets with option `{packet,Type}.`\n\nIf an entire packet is contained in `Bin`, it is returned together with the\nremainder of the binary as `{ok,Packet,Rest}`.\n\nIf `Bin` does not contain the entire packet, `{more,Length}` is returned.\n`Length` is either the expected _total size_ of the packet, or `undefined` if\nthe expected packet size is unknown. `decode_packet` can then be called again\nwith more data added.\n\nIf the packet does not conform to the protocol format, `{error,Reason}` is\nreturned.\n\n`Type`s:\n\n- **`raw | 0`** - No packet handling is done. The entire binary is returned\n  unless it is empty.\n\n- **`1 | 2 | 4`** - Packets consist of a header specifying the number of bytes\n  in the packet, followed by that number of bytes. The length of the header can\n  be one, two, or four bytes; the order of the bytes is big-endian. The header\n  is stripped off when the packet is returned.\n\n- **`line`** - A packet is a line-terminated by a delimiter byte, default is the\n  latin-1 newline character. The delimiter byte is included in the returned\n  packet unless the line was truncated according to option `line_length`.\n\n- **`asn1 | cdr | sunrm | fcgi | tpkt`** - The header is _not_ stripped off.\n\n  The meanings of the packet types are as follows:\n\n  - **`asn1` \\- ASN.1 BER**\n\n  - **`sunrm` \\- Sun's RPC encoding**\n\n  - **`cdr` \\- CORBA (GIOP 1.1)**\n\n  - **`fcgi` \\- Fast CGI**\n\n  - **`tpkt` \\- TPKT format \\[RFC1006]**\n\n- **`http | httph | http_bin | httph_bin`** - The Hypertext Transfer Protocol.\n  The packets are returned with the format according to `HttpPacket` described\n  earlier. A packet is either a request, a response, a header, or an end of\n  header mark. Invalid lines are returned as `HttpError`.\n\n  Recognized request methods and header fields are returned as atoms. Others are\n  returned as strings. Strings of unrecognized header fields are formatted with\n  only capital letters first and after hyphen characters, for example,\n  `\"Sec-Websocket-Key\"`. Header field names are also returned in\n  `UnmodifiedField` as strings, without any conversion or formatting.\n\n  The protocol type `http` is only to be used for the first line when an\n  `HttpRequest` or an `HttpResponse` is expected. The following calls are to use\n  `httph` to get `HttpHeader`s until `http_eoh` is returned, which marks the end\n  of the headers and the beginning of any following message body.\n\n  The variants `http_bin` and `httph_bin` return strings (`HttpString`) as\n  binaries instead of lists.\n\n  Since OTP 26.0, `Host` may be an IPv6 address enclosed in `[]`, as defined in\n  [RFC2732 ](https://www.ietf.org/rfc/rfc2732.txt).\n\nOptions:\n\n- **`{packet_size, integer() >= 0}`** - Sets the maximum allowed size of the\n  packet body. If the packet header indicates that the length of the packet is\n  longer than the maximum allowed length, the packet is considered invalid.\n  Defaults to 0, which means no size limit.\n\n- **`{line_length, integer() >= 0}`** - For packet type `line`, lines longer\n  than the indicated length are truncated.\n\n  Option `line_length` also applies to `http*` packet types as an alias for\n  option `packet_size` if `packet_size` itself is not set. This use is only\n  intended for backward compatibility.\n\n- **`{line_delimiter, 0 =  erlang:decode_packet(1,<<3,\"abcd\">>,[]).\n{ok,<<\"abc\">>,<<\"d\">>}\n> erlang:decode_packet(1,<<5,\"abcd\">>,[]).\n{more,6}\n```","ref":"erlang.html#decode_packet/3"},{"type":"function","title":"erlang.delete_element/2","doc":"Returns a new tuple with element at `Index` removed from tuple `Tuple1`.\n\nFor example:\n\n```erlang\n> erlang:delete_element(2, {one, two, three}).\n{one,three}\n```","ref":"erlang.html#delete_element/2"},{"type":"function","title":"erlang.delete_module/1","doc":"Makes the current code for `Module` become old code and deletes all references\nfor this module from the export table. Returns `undefined` if the module does\nnot exist, otherwise `true`.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for the code server (see `m:code`) and is not to be used\n> elsewhere.\n\nFailure: `badarg` if there already is an old version of `Module`.","ref":"erlang.html#delete_module/1"},{"type":"function","title":"erlang.demonitor/1","doc":"If `MonitorRef` is a reference that the calling process obtained by calling\n`monitor/2`, this monitoring is turned off. If the monitoring is already turned\noff, nothing happens.\n\nOnce [`demonitor(MonitorRef)`](`demonitor/1`) has returned, it is guaranteed\nthat no `{'DOWN', MonitorRef, _, _, _}` message, because of the monitor, will be\nplaced in the caller message queue in the future. However, a\n`{'DOWN', MonitorRef, _, _, _}` message can have been placed in the caller\nmessage queue before the call. It is therefore usually advisable to remove such\na `'DOWN'` message from the message queue after monitoring has been stopped.\n[`demonitor(MonitorRef, [flush])`](`demonitor/2`) can be used instead of\n[`demonitor(MonitorRef)`](`demonitor/1`) if this cleanup is wanted.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP R11B (ERTS 5.5) [`demonitor/1`](`demonitor/1`) behaved\n> completely asynchronously, that is, the monitor was active until the\n> \"demonitor signal\" reached the monitored entity. This had one undesirable\n> effect. You could never know when you were guaranteed _not_ to receive a\n> `DOWN` message because of the monitor.\n>\n> The current behavior can be viewed as two combined operations: asynchronously\n> send a \"demonitor signal\" to the monitored entity and ignore any future\n> results of the monitor.\n\nFailure: It is an error if `MonitorRef` refers to a monitoring started by\nanother process. Not all such cases are cheap to check. If checking is cheap,\nthe call fails with `badarg`, for example if `MonitorRef` is a remote reference.","ref":"erlang.html#demonitor/1"},{"type":"function","title":"erlang.demonitor/2","doc":"The returned value is `true` unless `info` is part of `OptionList`.\n\n[`demonitor(MonitorRef, [])`](`demonitor/2`) is equivalent to\n[`demonitor(MonitorRef)`](`demonitor/1`).\n\n`Option`s:\n\n- **`flush`** - Removes (one) `{_, MonitorRef, _, _, _}` message, if there is\n  one, from the caller message queue after monitoring has been stopped.\n\n  Calling [`demonitor(MonitorRef, [flush])`](`demonitor/2`) is equivalent to the\n  following, but more efficient:\n\n  ```erlang\n  demonitor(MonitorRef),\n  receive\n      {_, MonitorRef, _, _, _} ->\n          true\n  after 0 ->\n          true\n  end\n  ```\n\n- **`info`** - The returned value is one of the following:\n\n  - **`true`** - The monitor was found and removed. In this case, no `'DOWN'`\n    message corresponding to this monitor has been delivered and will not be\n    delivered.\n\n  - **`false`** - The monitor was not found and could not be removed. This\n    probably because someone already has placed a `'DOWN'` message corresponding\n    to this monitor in the caller message queue.\n\n  If option `info` is combined with option `flush`, `false` is returned if a\n  flush was needed, otherwise `true`.\n\n> #### Change {: .info }\n>\n> More options can be added in a future release.\n\nFailures:\n\n- **`badarg`** - If `OptionList` is not a list.\n\n- **`badarg`** - If `Option` is an invalid option.\n\n- **`badarg`** - The same failure as for `demonitor/1`.","ref":"erlang.html#demonitor/2"},{"type":"type","title":"erlang.deprecated_time_unit/0","doc":"The `t:time_unit/0` type also consist of the following _deprecated_ symbolic\ntime units:\n\n- **`seconds`** - Same as [`second`](`t:time_unit/0`).\n\n- **`milli_seconds`** - Same as [`millisecond`](`t:time_unit/0`).\n\n- **`micro_seconds`** - Same as [`microsecond`](`t:time_unit/0`).\n\n- **`nano_seconds`** - Same as [`nanosecond`](`t:time_unit/0`).","ref":"erlang.html#t:deprecated_time_unit/0"},{"type":"function","title":"erlang.disconnect_node/1","doc":"Forces the disconnection of a node.\n\nDoing this makes it appears to the node `Node` as if the local node has crashed.\nThis BIF is mainly used in the Erlang network authentication protocols.\n\nReturns `true` if disconnection succeeds, otherwise `false`. If the local node\nis not alive, `ignored` is returned.\n\n> #### Note {: .info }\n>\n> This function may return before [`nodedown` messages](`monitor_node/2`) have\n> been delivered.","ref":"erlang.html#disconnect_node/1"},{"type":"function","title":"erlang.display/1","doc":"Prints a text representation of `Term` on the standard output.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging only. The printed representation may\n> contain internal details that do not match the high-level representation of\n> the term in Erlang.","ref":"erlang.html#display/1"},{"type":"function","title":"erlang.dist_ctrl_get_data/1","doc":"Get distribution channel data from the local node that is to be passed to the\nremote node.\n\nThe distribution channel is identified by `DHandle`. If no data is\navailable, the atom `none` is returned. One can request to be informed by a\nmessage when more data is available by calling\n[`erlang:dist_ctrl_get_data_notification(DHandle)`](`dist_ctrl_get_data_notification/1`).\n\nThe returned value when there are data available depends on the value of the\n`get_size` option configured on the distribution channel identified by\n`DHandle`. For more information see the documentation of the `get_size` option\nfor the [`erlang:dist_ctrl_set_opt/3`](`dist_ctrl_set_opt/3`) function.\n\n> #### Note {: .info }\n>\n> Only the process registered as distribution controller for the distribution\n> channel identified by `DHandle` is allowed to call this function.\n\nThis function is used when implementing an alternative distribution carrier\nusing processes as distribution controllers. `DHandle` is retrieved via the\ncallback [`f_handshake_complete`](alt_dist.md#hs_data_f_handshake_complete).\nMore information can be found in the documentation of\n[ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).","ref":"erlang.html#dist_ctrl_get_data/1"},{"type":"function","title":"erlang.dist_ctrl_get_data_notification/1","doc":"Request notification when more data is available to fetch using\n[`erlang:dist_ctrl_get_data(DHandle)`](`dist_ctrl_get_data/1`) for the\ndistribution channel identified by `DHandle`.\n\nWhen more data is present, the caller will be sent the message `dist_data`.\nOnce a `dist_data` messages has been sent, no more `dist_data` messages will\nbe sent until the [`dist_ctrl_get_data_notification/1`](`dist_ctrl_get_data_notification/1`)\nfunction has been called again.\n\n> #### Note {: .info }\n>\n> Only the process registered as distribution controller for the distribution\n> channel identified by `DHandle` is allowed to call this function.\n\nThis function is used when implementing an alternative distribution carrier\nusing processes as distribution controllers. `DHandle` is retrieved via the\ncallback [`f_handshake_complete`](alt_dist.md#hs_data_f_handshake_complete).\nMore information can be found in the documentation of\n[ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).","ref":"erlang.html#dist_ctrl_get_data_notification/1"},{"type":"function","title":"erlang.dist_ctrl_get_opt/2","doc":"Returns the value of the `get_size` option on the distribution channel\nidentified by `DHandle`. For more information see the documentation of the\n`get_size` option for the [`erlang:dist_ctrl_set_opt/3`](`dist_ctrl_set_opt/3`)\nfunction.\n\n> #### Note {: .info }\n>\n> Only the process registered as distribution controller for the distribution\n> channel identified by `DHandle` is allowed to call this function.\n\nThis function is used when implementing an alternative distribution carrier\nusing processes as distribution controllers. `DHandle` is retrieved via the\ncallback [`f_handshake_complete`](alt_dist.md#hs_data_f_handshake_complete).\nMore information can be found in the documentation of\n[ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).","ref":"erlang.html#dist_ctrl_get_opt/2"},{"type":"function","title":"erlang.dist_ctrl_input_handler/2","doc":"Register an alternate input handler process for the distribution channel\nidentified by `DHandle`.\n\nOnce this function has been called, `InputHandler` is the only process allowed to call\n[`erlang:dist_ctrl_put_data(DHandle, Data)`](`dist_ctrl_put_data/2`) with the\n`DHandle` identifying this distribution channel.\n\n> #### Note {: .info }\n>\n> When the distribution controller for the distribution channel identified by\n> `DHandle` is a process, it is the only process allowed to call this function.\n> This function is also allowed to be called when the distribution controller\n> for the distribution channel identified by `DHandle` is a port. The data\n> received by the port should in this case be delivered to the process\n> identified by `InputHandler` which in turn should call\n> [`erlang:dist_ctrl_put_data/2`](`dist_ctrl_put_data/2`).\n\nThis function is used when implementing an alternative distribution carrier.\n`DHandle` is retrieved via the callback\n[`f_handshake_complete`](alt_dist.md#hs_data_f_handshake_complete). More\ninformation can be found in the documentation of\n[ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).","ref":"erlang.html#dist_ctrl_input_handler/2"},{"type":"function","title":"erlang.dist_ctrl_put_data/2","doc":"Deliver distribution channel data from a remote node to the local node.\n\n> #### Note {: .info }\n>\n> Only the process registered as distribution controller for the distribution\n> channel identified by `DHandle` is allowed to call this function unless an\n> alternate input handler process has been registered using\n> [`erlang:dist_ctrl_input_handler(DHandle, InputHandler)`](`dist_ctrl_input_handler/2`).\n> If an alternate input handler has been registered, only the registered input\n> handler process is allowed to call this function.\n\nThis function is used when implementing an alternative distribution carrier.\n`DHandle` is retrieved via the callback\n[`f_handshake_complete`](alt_dist.md#hs_data_f_handshake_complete). More\ninformation can be found in the documentation of\n[ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).","ref":"erlang.html#dist_ctrl_put_data/2"},{"type":"function","title":"erlang.dist_ctrl_set_opt/3","doc":"Sets the value of the `get_size` option on the distribution channel identified\nby `DHandle`.\n\nThis option controls the return value of calls to\n[erlang:dist_ctrl_get_data(DHandle)](`dist_ctrl_get_data/1`) where `DHandle`\nequals `DHandle` used when setting this option. When the `get_size` option is:\n\n- **`false`** - and there are distribution data available, a call to\n  `erlang:dist_ctrl_get_data(DHandle)` will just return `Data` to pass over the\n  channel. This is the default value of the `get_size` option.\n\n- **`true`** - and there are distribution data available, a call to\n  `erlang:dist_ctrl_get_data(DHandle)` will return `Data` to pass over the\n  channel as well as the `Size` of `Data` in bytes. This is returned as a tuple\n  on the form `{Size, Data}`.\n\nAll options are set to default when a channel is closed.\n\n> #### Note {: .info }\n>\n> Only the process registered as distribution controller for the distribution\n> channel identified by `DHandle` is allowed to call this function.\n\nThis function is used when implementing an alternative distribution carrier\nusing processes as distribution controllers. `DHandle` is retrieved via the\ncallback [`f_handshake_complete`](alt_dist.md#hs_data_f_handshake_complete).\nMore information can be found in the documentation of\n[ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).","ref":"erlang.html#dist_ctrl_set_opt/3"},{"type":"opaque","title":"erlang.dist_handle/0","doc":"An opaque handle identifying a distribution channel.","ref":"erlang.html#t:dist_handle/0"},{"type":"type","title":"erlang.dynamic/0","doc":"The [dynamic](`e:system:typespec.md#dynamic`) type, which represents a statically unknown type","ref":"erlang.html#t:dynamic/0"},{"type":"function","title":"erlang.element/2","doc":"Returns the `N`th element (numbering from 1) of `Tuple`.\n\nFor example:\n\n```erlang\n> element(2, {a, b, c}).\nb\n```","ref":"erlang.html#element/2"},{"type":"function","title":"erlang.erase/0","doc":"Returns the process dictionary and deletes it.\n\nFor example:\n\n```erlang\n> put(key1, {1, 2, 3}),\nput(key2, [a, b, c]),\nerase().\n[{key1,{1,2,3}},{key2,[a,b,c]}]\n```","ref":"erlang.html#erase/0"},{"type":"function","title":"erlang.erase/1","doc":"Returns the value `Val` associated with `Key` and deletes it from the process\ndictionary. Returns `undefined` if no value is associated with `Key`.\n\nThe average time complexity for the current implementation of this function is\nO(`1`) and the worst case time complexity is O(`N`), where `N` is the number of\nitems in the process dictionary.\n\nFor example:\n\n```erlang\n> put(key1, {merry, lambs, are, playing}),\nX = erase(key1),\n{X, erase(key1)}.\n{{merry,lambs,are,playing},undefined}\n```","ref":"erlang.html#erase/1"},{"type":"function","title":"erlang.error/1","doc":"Raises an exception of class `error` with the reason `Reason`.\n\nAs evaluating this function causes an exception to be thrown, it has no return value.\n\nThe intent of the exception class `error` is to signal that an unexpected error\nhas happened (for example, a function is called with a parameter that has an\nincorrect type). See the guide about\n[errors and error handling](`e:system:errors.md`) for additional information.\nExample:\n\n```erlang\n> catch error(foobar).\n{'EXIT',{foobar,[{shell,apply_fun,3,\n                        [{file,\"shell.erl\"},{line,906}]},\n                 {erl_eval,do_apply,6,[{file,\"erl_eval.erl\"},{line,677}]},\n                 {erl_eval,expr,5,[{file,\"erl_eval.erl\"},{line,430}]},\n                 {shell,exprs,7,[{file,\"shell.erl\"},{line,687}]},\n                 {shell,eval_exprs,7,[{file,\"shell.erl\"},{line,642}]},\n                 {shell,eval_loop,3,[{file,\"shell.erl\"},{line,627}]}]}}\n```","ref":"erlang.html#error/1"},{"type":"function","title":"erlang.error/2","doc":"Raises an exception of class `error` with the reason `Reason`. `Args` is\nexpected to be the list of arguments for the current function or the atom\n`none`.\n\nIf `Args` is a list, it is used to provide the arguments for the current\nfunction in the stack back-trace. If it is `none`, the arity of the calling\nfunction is used in the stacktrace. As evaluating this function causes an\nexception to be raised, it has no return value.\n\nThe intent of the exception class `error` is to signal that an unexpected error\nhas happened (for example, a function is called with a parameter that has an\nincorrect type). See the guide about\n[errors and error handling](`e:system:errors.md`) for additional information.\nExample:\n\n`test.erl`:\n\n```erlang\n-module(test).\n-export([example_fun/2]).\n\nexample_fun(A1, A2) ->\n    erlang:error(my_error, [A1, A2]).\n```\n\nErlang shell:\n\n```erlang\n6> c(test).\n{ok,test}\n7> test:example_fun(arg1,\"this is the second argument\").\n** exception error: my_error\n     in function  test:example_fun/2\n         called as test:example_fun(arg1,\"this is the second argument\")\n```","ref":"erlang.html#error/2"},{"type":"function","title":"erlang.error/3","doc":"Raises an exception of class `error` with the reason `Reason`. `Args` is\nexpected to be the list of arguments for the current function or the atom\n`none`.\n\nIf `Args` is a list, it is used to provide the arguments for the current\nfunction in the stack back-trace. If it is `none`, the arity of the calling\nfunction is used in the stacktrace. As evaluating this function causes an\nexception to be raised, it has no return value.\n\nIf the `error_info` option is given, the `ErrorInfoMap` will be inserted into\nthe stacktrace. The information given in the `ErrorInfoMap` is to be used by\nerror formatters such as [`erl_error`](`erl_error:format_exception/4`) to\nprovide more context around an error.\n\nThe default `module` of the `ErrorInfoMap` is the module that the call to\n`error/3` is made. The default `function` is `format_error`. See\n[`format_error/2`](`c:erl_error:format_error/2`) for more details on how this\nModule:Function/2 is to be used\n\nThe intent of the exception class `error` is to signal that an unexpected error\nhas happened (for example, a function is called with a parameter that has an\nincorrect type). See the guide about\n[errors and error handling](`e:system:errors.md`) for additional information.","ref":"erlang.html#error/3"},{"type":"function","title":"erlang.exit/1","doc":"Raises an exception of class `exit` with exit reason `Reason`.\n\nAs evaluating this function causes an exception to be raised, it has no return value.\n\nThe intent of the exception class `exit` is that the current process should be\nstopped (for example when a message telling a process to stop is received).\n\nThis function differ from [`error/1,2,3`](`error/1`) by causing an exception of\na different class and by having a reason that does not include the list of\nfunctions from the call stack.\n\nSee the guide about [errors and error handling](`e:system:errors.md`) for\nadditional information.\n\nExample:\n\n```erlang\n> exit(foobar).\n** exception exit: foobar\n> catch exit(foobar).\n{'EXIT',foobar}\n```\n\n> #### Note {: .info }\n>\n> If a process calls [`exit(kill)`](`exit/1`) and does not catch the exception,\n> it will terminate with exit reason `kill` and also emit exit signals with exit\n> reason `kill` (not `killed`) to all linked processes. Such exit signals with\n> exit reason `kill` can be trapped by the linked processes. Note that this\n> means that signals with exit reason `kill` behave differently depending on how\n> they are sent because the signal will be untrappable if a process sends such a\n> signal to another process with [`erlang:exit/2`](`exit/2`).","ref":"erlang.html#exit/1"},{"type":"function","title":"erlang.exit/2","doc":"Sends an exit signal with exit reason `Reason` to the process or port identified\nby `Pid`.\n\nThe following behavior applies if `Reason` is any term, except `normal` or\n`kill`, and `P` is the process or port identified by `Pid`:\n\n- If `P` is not [trapping exits](`process_flag/2`), `P` exits with exit reason\n  `Reason`.\n- If `P` is [trapping exits](`process_flag/2`), the exit signal is transformed\n  into a message `{'EXIT', From, Reason}`, where `From` is the process\n  identifier of the process that sent the exit signal, and delivered to the\n  message queue of `P`.\n\nThe following behavior applies if `Reason` is the term `normal` and `Pid` is the\nidentifier of a process `P` which is not the same as the process that invoked\n`erlang:exit(Pid, normal)` (the behavior when a process sends a signal with the\n`normal` reason to itself is described in the warning):\n\n- If `P` is [trapping exits](`process_flag/2`), the exit signal is transformed\n  into a message `{'EXIT', From, normal}`, where `From` is the process\n  identifier of the process that sent the exit signal, and delivered to `P`'s\n  message queue.\n- The signal has no effect if `P` is not trapping exits.\n\nIf `Reason` is the atom `kill`, that is, if [`exit(Pid, kill)`](`exit/2`) is\ncalled, an untrappable exit signal is sent to the process that is identified by\n`Pid`, which unconditionally exits with exit reason `killed`. The exit reason is\nchanged from `kill` to `killed` to hint to linked processes that the killed\nprocess got killed by a call to [`exit(Pid, kill)`](`exit/2`).\n\n> #### Note {: .info }\n>\n> The functions [`erlang:exit/1`](`exit/1`) and [`erlang:exit/2`](`exit/2`) are\n> named similarly but provide very different functionalities. The\n> `erlang:exit/1` function should be used when the intent is to stop the current\n> process while `erlang:exit/2` should be used when the intent is to send an\n> exit signal to another process. Note also that `erlang:exit/1` raises an\n> exception that can be caught while `erlang:exit/2` does not cause any\n> exception to be raised.\n\n> #### Warning {: .warning }\n>\n> The only scenario that has not been covered by the description above is when a\n> process `P` sends an exit signal with reason `normal` to itself, that is\n> `erlang:exit(self(), normal)`. The behavior in this scenario is as follows:\n>\n> - If `P` is [trapping exits](`process_flag/2`), the exit signal is transformed\n>   into a message `{'EXIT', From, normal}`, where `From` is `P`'s process\n>   identifier, and delivered to `P`'s message queue.\n> - `P` exits with reason `normal` if `P` is not trapping exits.\n>\n> Note that the behavior described above is different from when a process sends\n> an exit signal with reason `normal` to another process. This is arguably\n> strange but this behavior is kept for backward compatibility reasons.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.","ref":"erlang.html#exit/2"},{"type":"type","title":"erlang.ext_binary/0","doc":"A binary data object, structured according to the Erlang external term format.","ref":"erlang.html#t:ext_binary/0"},{"type":"type","title":"erlang.ext_iovec/0","doc":"A term of type `t:iovec/0`, structured according to the Erlang external term\nformat.","ref":"erlang.html#t:ext_iovec/0"},{"type":"function","title":"erlang.external_size/1","doc":"Calculates, without doing the encoding, the maximum byte size for a term encoded\nin the Erlang external term format.\n\nThe following condition applies always:\n\n```erlang\n> Size1 = byte_size(term_to_binary(Term)),\n> Size2 = erlang:external_size(Term),\n> true = Size1 =< Size2.\ntrue\n```\n\nThis is equivalent to a call to:\n\n```erlang\nerlang:external_size(Term, [])\n```","ref":"erlang.html#external_size/1"},{"type":"function","title":"erlang.external_size/2","doc":"Calculates, without doing the encoding, the maximum byte size for a term encoded\nin the Erlang external term format.\n\nThe following condition applies always:\n\n```erlang\n> Size1 = byte_size(term_to_binary(Term, Options)),\n> Size2 = erlang:external_size(Term, Options),\n> true = Size1 =< Size2.\ntrue\n```\n\nOption `{minor_version, Version}` specifies how floats are encoded. For a\ndetailed description, see `term_to_binary/2`.","ref":"erlang.html#external_size/2"},{"type":"type","title":"erlang.float/0","doc":"An Erlang [float](`e:system:data_types.md#number`).","ref":"erlang.html#t:float/0"},{"type":"function","title":"erlang.float/1","doc":"Returns a float by converting `Number` to a float.\n\nFor example:\n\n```erlang\n> float(55).\n55.0\n```\n\n> #### Note {: .info }\n>\n> If used on the top level in a guard, it tests whether the argument is a\n> floating point number; for clarity, use `is_float/1` instead.\n>\n> When [`float/1`](`float/1`) is used in an expression in a guard, such as\n> '`float(A) == 4.0`', it converts a number as described earlier.","ref":"erlang.html#float/1"},{"type":"function","title":"erlang.float_to_binary/1","doc":"","ref":"erlang.html#float_to_binary/1"},{"type":"function","title":"erlang.float_to_binary/2","doc":"Returns a binary corresponding to the text representation of `Float` using fixed\ndecimal point formatting.\n\n`Options` behaves in the same way as `float_to_list/2`.\n\nFor example:\n\n```erlang\n> float_to_binary(7.12, [{decimals, 4}]).\n<<\"7.1200\">>\n> float_to_binary(7.12, [{decimals, 4}, compact]).\n<<\"7.12\">>\n> float_to_binary(7.12, [{scientific, 3}]).\n<<\"7.120e+00\">>\n> float_to_binary(7.12, [short]).\n<<\"7.12\">>\n> float_to_binary(0.1+0.2, [short]).\n<<\"0.30000000000000004\">>\n> float_to_binary(0.1+0.2)\n<<\"3.00000000000000044409e-01\">>\n```","ref":"erlang.html#float_to_binary/2"},{"type":"function","title":"erlang.float_to_list/1","doc":"","ref":"erlang.html#float_to_list/1"},{"type":"function","title":"erlang.float_to_list/2","doc":"Returns a string corresponding to the text representation of `Float` using fixed\ndecimal point formatting.\n\nAvailable options:\n\n- If option `decimals` is specified, the returned value contains at most\n  `Decimals` number of digits past the decimal point. If the number does not fit\n  in the internal static buffer of 256 bytes, the function throws `badarg`.\n- If option `compact` is specified, the trailing zeros at the end of the list\n  are truncated. This option is only meaningful together with option `decimals`.\n- If option `scientific` is specified, the float is formatted using scientific\n  notation with `Decimals` digits of precision.\n- If option `short` is specified, the float is formatted with the smallest\n  number of digits that still guarantees that\n  `F =:= list_to_float(float_to_list(F, [short]))`. When the float is inside the\n  range (-2⁵³, 2⁵³), the notation that yields the smallest number of characters\n  is used (scientific notation or normal decimal notation). Floats outside the\n  range (-2⁵³, 2⁵³) are always formatted using scientific notation to avoid\n  confusing results when doing arithmetic operations.\n- If `Options` is `[]`, the function behaves as `float_to_list/1`.\n\nExamples:\n\n```erlang\n> float_to_list(7.12, [{decimals, 4}]).\n\"7.1200\"\n> float_to_list(7.12, [{decimals, 4}, compact]).\n\"7.12\"\n> float_to_list(7.12, [{scientific, 3}]).\n\"7.120e+00\"\n> float_to_list(7.12, [short]).\n\"7.12\"\n> float_to_list(0.1+0.2, [short]).\n\"0.30000000000000004\"\n> float_to_list(0.1+0.2)\n\"3.00000000000000044409e-01\"\n```\n\nIn the last example, [`float_to_list(0.1+0.2)`](`float_to_list/1`) evaluates to\n`\"3.00000000000000044409e-01\"`. The reason for this is explained in\n[Representation of Floating Point Numbers](`e:system:data_types.md#float_representation_problem`).","ref":"erlang.html#float_to_list/2"},{"type":"function","title":"erlang.floor/1","doc":"Returns the largest integer not greater than `Number`.\n\nFor example:\n\n```erlang\n> floor(-10.5).\n-11\n```","ref":"erlang.html#floor/1"},{"type":"function","title":"erlang.fun_info/1","doc":"Returns a list with information about the fun `Fun`. Each list element is a\ntuple. The order of the tuples is undefined, and more tuples can be added in a\nfuture release.\n\n> #### Warning {: .warning }\n>\n> This BIF is mainly intended for debugging, but it can sometimes be useful in\n> library functions that need to verify, for example, the arity of a fun.\n\nTwo types of funs have slightly different semantics:\n\n- A fun created by `fun M:F/A` is called an _external_ fun. Calling it will\n  always call the function `F` with arity `A` in the latest code for module `M`.\n  Notice that module `M` does not even need to be loaded when the fun\n  `fun M:F/A` is created.\n- All other funs are called _local_. When a local fun is called, the same\n  version of the code that created the fun is called (even if a newer version of\n  the module has been loaded).\n\nThe following elements are always present in the list for both local and\nexternal funs:\n\n- **`{type, Type}`** - `Type` is `local` or `external`.\n\n- **`{module, Module}`** - `Module` (an atom) is the module name.\n\n  If `Fun` is a local fun, `Module` is the module in which the fun is defined.\n\n  If `Fun` is an external fun, `Module` is the module that the fun refers to.\n\n- **`{name, Name}`** - `Name` (an atom) is a function name.\n\n  If `Fun` is a local fun, `Name` is the name of the local function that\n  implements the fun. (This name was generated by the compiler, and is only of\n  informational use. As it is a local function, it cannot be called directly.)\n  If no code is currently loaded for the fun, `[]` is returned instead of an\n  atom.\n\n  If `Fun` is an external fun, `Name` is the name of the exported function that\n  the fun refers to.\n\n- **`{arity, Arity}`** - `Arity` is the number of arguments that the fun is to\n  be called with.\n\n- **`{env, Env}`** - `Env` (a list) is the environment or free variables for the\n  fun. For external funs, the returned list is always empty.\n\nThe following elements are only present in the list if `Fun` is local:\n\n- **`{pid, Pid}`** - `Pid` is the process identifier of `init` process on\n  the local node.\n\n  > #### Change {: .info }\n  >\n  > Starting in Erlang/OTP 27, `Pid` always points to the local `init` process,\n  > regardless of which process or node the fun was originally created on.\n  >\n  > See\n  > [Upcoming Potential Incompatibilities ](`e:general_info:upcoming_incompatibilities.md#fun-creator-pid-will-always-be-local-init-process`).\n\n- **`{index, Index}`** - `Index` (an integer) is an index into the module fun\n  table.\n\n- **`{new_index, Index}`** - `Index` (an integer) is an index into the module\n  fun table.\n\n- **`{new_uniq, Uniq}`** - `Uniq` (a binary) is a unique value for this fun. It\n  is calculated from the compiled code for the entire module.\n\n- **`{uniq, Uniq}`** - `Uniq` (an integer) is a unique value for this fun. As\n  from Erlang/OTP R15, this integer is calculated from the compiled code for the\n  entire module. Before Erlang/OTP R15, this integer was based on only the body\n  of the fun.","ref":"erlang.html#fun_info/1"},{"type":"function","title":"erlang.fun_info/2","doc":"Returns information about `Fun` as specified by `Item`, in the form\n`{Item,Info}`.\n\nFor any fun, `Item` can be any of the atoms `module`, `name`, `arity`, `env`, or\n`type`.\n\nFor a local fun, `Item` can also be any of the atoms `index`, `new_index`,\n`new_uniq`, `uniq`, and `pid`. For an external fun, the value of any of these\nitems is always the atom `undefined`.\n\nSee [`erlang:fun_info/1`](`fun_info/1`).","ref":"erlang.html#fun_info/2"},{"type":"type","title":"erlang.fun_info_item/0","doc":"","ref":"erlang.html#t:fun_info_item/0"},{"type":"function","title":"erlang.fun_to_list/1","doc":"Returns `String` that represents the code that created `Fun`.\n\n`String` has the following form, if `Fun` was created by a\n[fun expression](`e:system:expressions.md#fun-expressions`) of the form\n`fun ModuleName:FuncName/Arity`:\n\n`\"fun ModuleName:FuncName/Arity\"`\n\nThe form of `String` when `Fun` is created from other types of\n[fun expressions](`e:system:expressions.md#fun-expressions`) differs depending\non if the fun expression was executed while executing compiled code or if the\nfun expression was executed while executing uncompiled code (uncompiled\nescripts, the Erlang shell, and other code executed by the erl_eval module):\n\n- **compiled code** - `\"#Fun \"`, where M, I and U correspond to the values\n  named `module`, `index` and `uniq` in the result of\n  [`erlang:fun_info(Fun)`](`fun_info/1`).\n\n- **uncompiled code** - All funs created from fun expressions in uncompiled code\n  with the same arity are mapped to the same list by\n  [`fun_to_list/1`](`fun_to_list/1`).\n\n> #### Note {: .info }\n>\n> Generally, one can not use [`fun_to_list/1`](`fun_to_list/1`) to check if two\n> funs are equal as [`fun_to_list/1`](`fun_to_list/1`) does not take the fun's\n> environment into account. See [`erlang:fun_info/1`](`fun_info/1`) for how to\n> get the environment of a fun.\n\n> #### Change {: .info }\n>\n> The output of [`fun_to_list/1`](`fun_to_list/1`) can differ between Erlang\n> implementations and may change in future versions.\n\nExamples:\n\n```erlang\n-module(test).\n-export([add/1, add2/0, fun_tuple/0]).\nadd(A) -> fun(B) -> A + B end.\nadd2() -> fun add/1.\nfun_tuple() -> {fun() -> 1 end, fun() -> 1 end}.\n```\n\n```erlang\n> {fun test:add/1, test:add2()}.\n{fun test:add/1,#Fun }\n```\n\nExplanation: `fun test:add/1` is upgradable but `test:add2()` is not upgradable.\n\n```erlang\n> {test:add(1), test:add(42)}.\n{#Fun ,#Fun }\n```\n\nExplanation: `test:add(1)` and `test:add(42)` has the same string representation\nas the environment is not taken into account.\n\n```erlang\n>test:fun_tuple().\n{#Fun ,#Fun }\n```\n\nExplanation: The string representations differ because the funs come from\ndifferent fun expressions.\n\n```erlang\n> {fun() -> 1 end, fun() -> 1 end}. >\n{#Fun ,#Fun }\n```\n\nExplanation: All funs created from fun expressions of this form in uncompiled\ncode with the same arity are mapped to the same list by\n[`fun_to_list/1`](`fun_to_list/1`).","ref":"erlang.html#fun_to_list/1"},{"type":"type","title":"erlang.function/0","doc":"An Erlang [fun](`e:system:data_types.md#fun`).","ref":"erlang.html#t:function/0"},{"type":"function","title":"erlang.function_exported/3","doc":"Returns `true` if the module `Module` is\n[current](`e:system:code_loading.md#code-replacement`) and contains an exported\nfunction `Function/Arity`, or if there is a BIF (a built-in function implemented\nin C) with the specified name, otherwise returns `false`.","ref":"erlang.html#function_exported/3"},{"type":"function","title":"erlang.garbage_collect/0","doc":"Forces an immediate garbage collection of the executing process.\n\nThe function is not to be used unless it has been noticed (or there are good\nreasons to suspect) that the spontaneous garbage collection will occur too late\nor not at all.\n\n> #### Warning {: .warning }\n>\n> Improper use can seriously degrade system performance.","ref":"erlang.html#garbage_collect/0"},{"type":"function","title":"erlang.garbage_collect/1","doc":"","ref":"erlang.html#garbage_collect/1"},{"type":"function","title":"erlang.garbage_collect/2","doc":"Garbage collects the node local process identified by `Pid`.\n\n`Option`:\n\n- **`{async, RequestId}`** - The function\n  [`garbage_collect/2`](`garbage_collect/2`) returns the value `async`\n  immediately after the request has been sent. When the request has been\n  processed, the process that called this function is passed a message on the\n  form `{garbage_collect, RequestId, GCResult}`.\n\n- **`{type, 'major' | 'minor'}`** - Triggers garbage collection of requested\n  type. Default value is `'major'`, which would trigger a fullsweep GC. The\n  option `'minor'` is considered a hint and may lead to either minor or major GC\n  run.\n\nIf `Pid` equals `self/0`, and no `async` option has been passed, the garbage\ncollection is performed at once, that is, the same as calling\n`garbage_collect/0`. Otherwise a request for garbage collection is sent to the\nprocess identified by `Pid`, and will be handled when appropriate. If no `async`\noption has been passed, the caller blocks until `GCResult` is available and can\nbe returned.\n\n`GCResult` informs about the result of the garbage collection request as\nfollows:\n\n- **`true`** - The process identified by `Pid` has been garbage collected.\n\n- **`false`** - No garbage collection was performed, as the process identified\n  by `Pid` terminated before the request could be satisfied.\n\nNotice that the same caveats apply as for `garbage_collect/0`.\n\nFailures:\n\n- **`badarg`** - If `Pid` is not a node local process identifier.\n\n- **`badarg`** - If `OptionList` is an invalid list of options.","ref":"erlang.html#garbage_collect/2"},{"type":"type","title":"erlang.garbage_collection_defaults/0","doc":"A list with the system wide garbage collection defaults.","ref":"erlang.html#t:garbage_collection_defaults/0"},{"type":"function","title":"erlang.get/0","doc":"Returns the process dictionary as a list of `{Key, Val}` tuples. The items in\nthe returned list can be in any order.\n\nFor example:\n\n```erlang\n> put(key1, merry),\nput(key2, lambs),\nput(key3, {are, playing}),\nget().\n[{key1,merry},{key2,lambs},{key3,{are,playing}}]\n```","ref":"erlang.html#get/0"},{"type":"function","title":"erlang.get/1","doc":"Returns the value `Val` associated with `Key` in the process dictionary, or\n`undefined` if `Key` does not exist.\n\nThe expected time complexity for the current implementation of this function is\nO(`1`) and the worst case time complexity is O(`N`), where `N` is the number of\nitems in the process dictionary.\n\nFor example:\n\n```erlang\n> put(key1, merry),\nput(key2, lambs),\nput({any, [valid, term]}, {are, playing}),\nget({any, [valid, term]}).\n{are,playing}\n```","ref":"erlang.html#get/1"},{"type":"function","title":"erlang.get_cookie/0","doc":"Returns the magic cookie of the local node if the node is alive, otherwise the\natom `nocookie`. This value is set by `set_cookie/1`.","ref":"erlang.html#get_cookie/0"},{"type":"function","title":"erlang.get_cookie/1","doc":"Returns the magic cookie for node `Node` if the local node is alive, otherwise\nthe atom `nocookie`. This value is set by `set_cookie/2`.","ref":"erlang.html#get_cookie/1"},{"type":"function","title":"erlang.get_keys/0","doc":"Returns a list of all keys present in the process dictionary. The items in the\nreturned list can be in any order.\n\nFor example:\n\n```erlang\n> put(dog, {animal,1}),\nput(cow, {animal,2}),\nput(lamb, {animal,3}),\nget_keys().\n[dog,cow,lamb]\n```","ref":"erlang.html#get_keys/0"},{"type":"function","title":"erlang.get_keys/1","doc":"Returns a list of keys that are associated with the value `Val` in the process\ndictionary. The items in the returned list can be in any order.\n\nFor example:\n\n```erlang\n> put(mary, {1, 2}),\nput(had, {1, 2}),\nput(a, {1, 2}),\nput(little, {1, 2}),\nput(dog, {1, 3}),\nput(lamb, {1, 2}),\nget_keys({1, 2}).\n[mary,had,a,little,lamb]\n```","ref":"erlang.html#get_keys/1"},{"type":"function","title":"erlang.group_leader/0","doc":"Returns the process identifier of the group leader for the process evaluating\nthe function.\n\nEvery process is a member of some process group and all groups have a _group\nleader_. All I/O from the group is channeled to the group leader. When a new\nprocess is spawned, it gets the same group leader as the spawning process.\n\nInitially, at system startup, `init` is both its own group leader and the group\nleader of all processes. During the boot of a system the group leader for\nprocesses will be changed depending on the need of the system. Some examples\nwhere this is done are:\n\n- When an application is started, the top supervisor of that application will\n  have its group leader set to the application master. See `application:start/2`\n  for more details.\n- When running tests, both [`common_test`](`e:common_test:index.html`) and\n  `m:eunit` set the group leader in order to capture any I/O from the testcase.\n- The [interactive shell](`m:shell`) sets the group leader to intercept I/O.","ref":"erlang.html#group_leader/0"},{"type":"function","title":"erlang.group_leader/2","doc":"Sets the group leader of `Pid` to `GroupLeader`. Typically, this is used when a\nprocess started from a certain shell is to have another group leader than\n`init`.\n\nThe group leader should be rarely changed in applications with a supervision\ntree, because OTP assumes the group leader of their processes is their\napplication master.\n\nSetting the group leader follows the signal ordering guarantees described in the\n[Processes Chapter](`e:system:ref_man_processes.md#signals`) in the _Erlang\nReference Manual_.\n\nSee also `group_leader/0` and\n[OTP design principles](`e:system:applications.md#stopping`) related to starting\nand stopping applications.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.","ref":"erlang.html#group_leader/2"},{"type":"function","title":"erlang.halt/0","doc":"Equivalent to calling [`halt(0, [])`](`halt/2`).\n\nFor example:\n\n```erlang\n> halt().\nos_prompt%\n```","ref":"erlang.html#halt/0"},{"type":"function","title":"erlang.halt/1","doc":"Equivalent to calling [`halt(HaltType, [])`](`halt/2`).\n\nFor example:\n\n```erlang\n> halt(17).\nos_prompt% echo $?\n17\nos_prompt%\n```","ref":"erlang.html#halt/1"},{"type":"function","title":"erlang.halt/2","doc":"Halt the runtime system.\n\n- ```erlang\n  halt(Status :: non_neg_integer(), Options :: halt_options())\n  ```\n  {: #halt_status_2 }\n\n  Halt the runtime system with status code `Status`.\n\n  > #### Note {: .info }\n  >\n  > On many platforms, the OS supports only status codes 0-255. A too large\n  > status code is truncated by clearing the high bits.\n\n  Currently the following options are valid:\n\n  - **`{flush, EnableFlushing}`{: #halt_flush }** - If `EnableFlushing` equals\n    `true`, which also is the default behavior, the runtime system will perform\n    the following operations before terminating:\n\n    - Flush all outstanding output.\n    - Send all Erlang ports exit signals and wait for them to exit.\n    - Wait for all async threads to complete all outstanding async jobs.\n    - Call all installed [NIF _on halt_ callbacks](erl_nif.md#on_halt).\n    - Wait for all ongoing\n      [NIF calls with the _delay halt_ setting](erl_nif.md#delay_halt) enabled\n      to return.\n    - Call all installed `atexit`/`on_exit` callbacks.\n\n    If `EnableFlushing` equals `false`, the runtime system will terminate\n    immediately without performing any of the above listed operations.\n\n    > #### Change {: .info }\n    >\n    > Runtime systems prior to OTP 26.0 called all installed `atexit`/`on_exit`\n    > callbacks also when `flush` was disabled, but as of OTP 26.0 this is no\n    > longer the case.\n\n  - **`{flush_timeout, Timeout :: 0..2147483647 | infinity}`{: #halt_flush_timeout }** -\n    Sets a limit on the time allowed for [flushing](#halt_flush) prior to\n    termination of the runtime system. `Timeout` is in milliseconds. The default\n    value is determined by the the `erl` [`+zhft  `](erl_cmd.md#+zhft)\n    command line flag.\n\n    If flushing has been ongoing for `Timeout` milliseconds, flushing operations\n    will be interrupted and the runtime system will immediately be terminated\n    with the exit code `255`. If flushing is not enabled, the timeout will have\n    no effect on the system.\n\n    See also the `erl` [`+zhft  `](erl_cmd.md#+zhft) command line flag.\n    Note that the shortest timeout set by the command line flag and the\n    `flush_timeout` option will be the actual timeout value in effect.\n\n    Since: OTP 27.0\n\n- ```erlang\n  halt(Abort :: abort, Options :: halt_options())\n  ```\n  {: #halt_abort_2 }\n\n  Halt the Erlang runtime system by aborting and produce a core dump if core\n  dumping has been enabled in the environment that the runtime system is\n  executing in.\n\n  > #### Note {: .info }\n  >\n  > The [`{flush, boolean()}`](#halt_flush) option will be ignored, and\n  > flushing will be disabled.\n\n- ```erlang\n  halt(CrashDumpSlogan :: string(), Options :: halt_options())\n  ```\n  {: #halt_crash_dump_2 }\n\n  Halt the Erlang runtime system and generate an\n  [Erlang crash dump](crash_dump.md). The string `CrashDumpSlogan` will be used\n  as slogan in the Erlang crash dump created. The slogan will be trunkated if\n  `CrashDumpSlogan` is longer than 1023 characters.\n\n  > #### Note {: .info }\n  >\n  > The [`{flush, boolean()}`](#halt_flush) option will be ignored, and\n  > flushing will be disabled.\n\n  > #### Change {: .info }\n  >\n  > Behavior changes compared to earlier versions:\n  >\n  > - Before OTP 24.2, the slogan was truncated if `CrashDumpSlogan` was longer\n  >   than 200 characters. Now it will be truncated if longer than 1023\n  >   characters.\n  > - Before OTP 20.1, only code points in the range 0-255 were accepted in the\n  >   slogan. Now any Unicode string is valid.","ref":"erlang.html#halt/2"},{"type":"type","title":"erlang.halt_options/0","doc":"","ref":"erlang.html#t:halt_options/0"},{"type":"function","title":"erlang.hd/1","doc":"Returns the head of `List`, that is, the first element.\n\nIt works with improper lists.\n\nExamples:\n\n```erlang\n> hd([1,2,3,4,5]).\n1\n```\n\n```erlang\n> hd([first, second, third, so_on | improper_end]).\nfirst\n```\n\nFailure: `badarg` if `List` is an empty list `[]`.","ref":"erlang.html#hd/1"},{"type":"function","title":"erlang.hibernate/3","doc":"Puts the calling process into a wait state where its memory allocation has been\nreduced as much as possible. This is useful if the process does not expect to\nreceive any messages soon.\n\nThe process is awaken when a message is sent to it, and control resumes in\n`Module:Function` with the arguments specified by `Args` with the call stack\nemptied, meaning that the process terminates when that function returns. Thus\n`erlang:hibernate/3` never returns to its caller. The resume function\n`Module:Function/Arity` must be exported (`Arity` =:=\n[`length(Args)`](`length/1`)).\n\nIf the process has any message in its message queue, the process is awakened\nimmediately in the same way as described earlier.\n\nIn more technical terms, `erlang:hibernate/3` discards the call stack for the\nprocess, and then garbage collects the process. After this, all live data is in\none continuous heap. The heap is then shrunken to the exact same size as the\nlive data that it holds (even if that size is less than the minimum heap size\nfor the process).\n\nIf the size of the live data in the process is less than the minimum heap size,\nthe first garbage collection occurring after the process is awakened ensures\nthat the heap size is changed to a size not smaller than the minimum heap size.\n\nNotice that emptying the call stack means that any surrounding `catch` is\nremoved and must be re-inserted after hibernation. One effect of this is that\nprocesses started using `proc_lib` (also indirectly, such as `gen_server`\nprocesses), are to use `proc_lib:hibernate/3` instead, to ensure that the\nexception handler continues to work when the process wakes up.","ref":"erlang.html#hibernate/3"},{"type":"type","title":"erlang.identifier/0","doc":"An unique identifier for some entity, for example a\n[process](`e:system:ref_man_processes.md`), [port](`e:system:ports.md#ports`) or\n[monitor](`monitor/2`).","ref":"erlang.html#t:identifier/0"},{"type":"type","title":"erlang.info_list/0","doc":"","ref":"erlang.html#t:info_list/0"},{"type":"function","title":"erlang.insert_element/3","doc":"Returns a new tuple with element `Term` inserted at position `Index` in tuple\n`Tuple1`. All elements from position `Index` and upwards are pushed one step\nhigher in the new tuple `Tuple2`.\n\nFor example:\n\n```erlang\n> erlang:insert_element(2, {one, two, three}, new).\n{one,new,two,three}\n```","ref":"erlang.html#insert_element/3"},{"type":"type","title":"erlang.integer/0","doc":"An Erlang [integer](`e:system:data_types.md#number`).","ref":"erlang.html#t:integer/0"},{"type":"function","title":"erlang.integer_to_binary/1","doc":"Returns a binary corresponding to the text representation of `Integer`.\n\nFor example:\n\n```erlang\n> integer_to_binary(77).\n<<\"77\">>\n```","ref":"erlang.html#integer_to_binary/1"},{"type":"function","title":"erlang.integer_to_binary/2","doc":"Returns a binary corresponding to the text representation of `Integer` in base\n`Base`.\n\nFor example:\n\n```erlang\n> integer_to_binary(1023, 16).\n<<\"3FF\">>\n```","ref":"erlang.html#integer_to_binary/2"},{"type":"function","title":"erlang.integer_to_list/1","doc":"Returns a string corresponding to the text representation of `Integer`.\n\nFor example:\n\n```erlang\n> integer_to_list(77).\n\"77\"\n```","ref":"erlang.html#integer_to_list/1"},{"type":"function","title":"erlang.integer_to_list/2","doc":"Returns a string corresponding to the text representation of `Integer` in base\n`Base`.\n\nFor example:\n\n```erlang\n> integer_to_list(1023, 16).\n\"3FF\"\n```","ref":"erlang.html#integer_to_list/2"},{"type":"type","title":"erlang.iodata/0","doc":"A binary or list containing bytes and/or iodata.\n\nThis datatype is used to represent data that is meant to be output using\nany I/O module. For example: `file:write/2` or `gen_tcp:send/2`.\n\nTo convert an `t:iodata/0` term to `t:binary/0` you can use\n[iolist_to_binary/2](`iolist_to_binary/1`). To transcode a `t:string/0` or\n`t:unicode:chardata/0` to `t:iodata/0` you can use `unicode:characters_to_binary/1`.","ref":"erlang.html#t:iodata/0"},{"type":"type","title":"erlang.iolist/0","doc":"A list containing bytes and/or iodata.\n\nThis datatype is used to represent data that is meant to be output using any\nI/O module. For example: `file:write/2` or `gen_tcp:send/2`.\n\nIn most use cases you want to use `t:iodata/0` instead of this type.","ref":"erlang.html#t:iolist/0"},{"type":"function","title":"erlang.iolist_size/1","doc":"Returns an integer, that is the size in bytes, of the binary that would be the\nresult of [`iolist_to_binary(Item)`](`iolist_to_binary/1`).\n\nFor example:\n\n```erlang\n> iolist_size([1,2|<<3,4>>]).\n4\n```","ref":"erlang.html#iolist_size/1"},{"type":"function","title":"erlang.iolist_to_binary/1","doc":"Returns a binary that is made from the integers and binaries in\n`IoListOrBinary`.\n\nFor example:\n\n```erlang\n> Bin1 = <<1,2,3>>.\n<<1,2,3>>\n> Bin2 = <<4,5>>.\n<<4,5>>\n> Bin3 = <<6>>.\n<<6>>\n> iolist_to_binary([Bin1,1,[2,3,Bin2],4|Bin3]).\n<<1,2,3,1,2,3,4,5,4,6>>\n```","ref":"erlang.html#iolist_to_binary/1"},{"type":"function","title":"erlang.iolist_to_iovec/1","doc":"Returns an [iovec](`t:iovec/0`) that is made from the integers and binaries in\n`IoListOrBinary`. This function is useful when you want to flatten an iolist but\nyou do not need a single binary. This can be useful for passing the data to nif\nfunctions such as [`enif_inspect_iovec`](erl_nif.md#enif_inspect_iovec) or do\nmore efficient message passing. The advantage of using this function over\n`iolist_to_binary/1` is that it does not have to copy\n[off-heap binaries](`e:system:binaryhandling.md#refc_binary`).\n\nFor example:\n\n```erlang\n> Bin1 = <<1,2,3>>.\n<<1,2,3>>\n> Bin2 = <<4,5>>.\n<<4,5>>\n> Bin3 = <<6>>.\n<<6>>\n%% If you pass small binaries and integers it works as iolist_to_binary\n> erlang:iolist_to_iovec([Bin1,1,[2,3,Bin2],4|Bin3]).\n[<<1,2,3,1,2,3,4,5,4,6>>]\n%% If you pass larger binaries, they are split and returned in a form\n%% optimized for calling the C function writev.\n> erlang:iolist_to_iovec([<<1>>,<<2:8096>>,<<3:8096>>]).\n[<<1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n   0,...>>,\n <<0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n   ...>>,\n <<0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,...>>]\n```","ref":"erlang.html#iolist_to_iovec/1"},{"type":"type","title":"erlang.iovec/0","doc":"A list of binaries. This datatype is useful to use together with\n[`enif_inspect_iovec`](erl_nif.md#enif_inspect_iovec).","ref":"erlang.html#t:iovec/0"},{"type":"function","title":"erlang.is_alive/0","doc":"Returns `true` if the local node is alive (that is, if the node can be part of a\ndistributed system), otherwise `false`. A node is alive if it is started with:\n\n1. [`\"erl -name LONGNAME\"`](erl_cmd.md#name) or,\n1. [`\"erl -sname SHORTNAME\"`](erl_cmd.md#sname).\n\nA node can also be alive if it has got a name from a call to\n`net_kernel:start/2` and has not been stopped by a call to `net_kernel:stop/0`.","ref":"erlang.html#is_alive/0"},{"type":"function","title":"erlang.is_atom/1","doc":"Returns `true` if `Term` is an atom, otherwise `false`.","ref":"erlang.html#is_atom/1"},{"type":"function","title":"erlang.is_binary/1","doc":"Returns `true` if `Term` is a binary, otherwise `false`.\n\nA binary always contains a complete number of bytes.","ref":"erlang.html#is_binary/1"},{"type":"function","title":"erlang.is_bitstring/1","doc":"Returns `true` if `Term` is a bitstring (including a binary), otherwise `false`.","ref":"erlang.html#is_bitstring/1"},{"type":"function","title":"erlang.is_boolean/1","doc":"Returns `true` if `Term` is the atom `true` or the atom `false` (that is, a\nboolean). Otherwise returns `false`.","ref":"erlang.html#is_boolean/1"},{"type":"function","title":"erlang.is_builtin/3","doc":"This BIF is useful for builders of cross-reference tools.\n\nReturns `true` if `Module:Function/Arity` is a BIF implemented in C, otherwise\n`false`.","ref":"erlang.html#is_builtin/3"},{"type":"function","title":"erlang.is_float/1","doc":"Returns `true` if `Term` is a floating point number, otherwise `false`.","ref":"erlang.html#is_float/1"},{"type":"function","title":"erlang.is_function/1","doc":"Returns `true` if `Term` is a fun, otherwise `false`.","ref":"erlang.html#is_function/1"},{"type":"function","title":"erlang.is_function/2","doc":"Returns `true` if `Term` is a fun that can be applied with `Arity` number of\narguments, otherwise `false`.","ref":"erlang.html#is_function/2"},{"type":"function","title":"erlang.is_integer/1","doc":"Returns `true` if `Term` is an integer, otherwise `false`.","ref":"erlang.html#is_integer/1"},{"type":"function","title":"erlang.is_list/1","doc":"Returns `true` if `Term` is a list with zero or more elements, otherwise\n`false`.","ref":"erlang.html#is_list/1"},{"type":"function","title":"erlang.is_map/1","doc":"Returns `true` if `Term` is a map, otherwise `false`.","ref":"erlang.html#is_map/1"},{"type":"function","title":"erlang.is_map_key/2","doc":"Returns `true` if map `Map` contains `Key` and returns `false` if it does not\ncontain the `Key`.\n\nThe call fails with a `{badmap,Map}` exception if `Map` is not a map.\n\n_Example:_\n\n```erlang\n> Map = #{\"42\" => value}.\n#{\"42\" => value}\n> is_map_key(\"42\",Map).\ntrue\n> is_map_key(value,Map).\nfalse\n```","ref":"erlang.html#is_map_key/2"},{"type":"function","title":"erlang.is_number/1","doc":"Returns `true` if `Term` is an integer or a floating point number. Otherwise\nreturns `false`.","ref":"erlang.html#is_number/1"},{"type":"function","title":"erlang.is_pid/1","doc":"Returns `true` if `Term` is a process identifier, otherwise `false`.","ref":"erlang.html#is_pid/1"},{"type":"function","title":"erlang.is_port/1","doc":"Returns `true` if `Term` is a port identifier, otherwise `false`.","ref":"erlang.html#is_port/1"},{"type":"function","title":"erlang.is_process_alive/1","doc":"`Pid` must refer to a process at the local node.\n\nReturns `true` if the process exists and is alive, that is, is not exiting and\nhas not exited. Otherwise returns `false`.\n\nIf process `P1` calls [`is_process_alive(P2Pid)`](`is_process_alive/1`) it is\nguaranteed that all signals, sent from `P1` to `P2` (`P2` is the process with\nidentifier `P2Pid`) before the call, will be delivered to `P2` before the\naliveness of `P2` is checked. This guarantee means that one can use\n[`is_process_alive/1`](`is_process_alive/1`) to let a process `P1` wait until a\nprocess `P2`, which has got an exit signal with reason `kill` from P1, is\nkilled.\n\nFor example:\n\n```erlang\nexit(P2Pid, kill),\n% P2 might not be killed\nis_process_alive(P2Pid),\n% P2 is not alive (the call above always return false)\n```\n\nSee the documentation about [signals](`e:system:ref_man_processes.md#signals`)\nand [erlang:exit/2](`exit/2`) for more information about signals and exit\nsignals.","ref":"erlang.html#is_process_alive/1"},{"type":"function","title":"erlang.is_record/2","doc":"Returns `true` if `Term` is a tuple and its first element is `RecordTag`.\nOtherwise returns `false`.\n\n> #### Note {: .info }\n>\n> Normally the compiler treats calls to [`is_record/2`](`is_record/2`)\n> especially. It emits code to verify that `Term` is a tuple, that its first\n> element is `RecordTag`, and that the size is correct. However, if `RecordTag`\n> is not a literal atom, the BIF [`is_record/2`](`is_record/2`) is called\n> instead and the size of the tuple is not verified.\n\nAllowed in guard tests, if `RecordTag` is a literal atom.","ref":"erlang.html#is_record/2"},{"type":"function","title":"erlang.is_record/3","doc":"`RecordTag` must be an atom.\n\nReturns `true` if `Term` is a tuple, its first element is `RecordTag`, and its\nsize is `Size`. Otherwise returns `false`.\n\nAllowed in guard tests if `RecordTag` is a literal atom and `Size` is a literal\ninteger.\n\n> #### Note {: .info }\n>\n> This BIF is documented for completeness. Usually\n> [`is_record/2`](`is_record/2`) is to be used.","ref":"erlang.html#is_record/3"},{"type":"function","title":"erlang.is_reference/1","doc":"Returns `true` if `Term` is a reference, otherwise `false`.","ref":"erlang.html#is_reference/1"},{"type":"function","title":"erlang.is_tuple/1","doc":"Returns `true` if `Term` is a tuple, otherwise `false`.","ref":"erlang.html#is_tuple/1"},{"type":"function","title":"erlang.length/1","doc":"Returns the length of `List`.\n\nFor example:\n\n```erlang\n> length([1,2,3,4,5,6,7,8,9]).\n9\n```","ref":"erlang.html#length/1"},{"type":"type","title":"erlang.level_entry/0","doc":"","ref":"erlang.html#t:level_entry/0"},{"type":"type","title":"erlang.level_tag/0","doc":"","ref":"erlang.html#t:level_tag/0"},{"type":"function","title":"erlang.link/1","doc":"Sets up and activates a link between the calling process and another process or\na port identified by `PidOrPort`.\n\nWe will from here on call the identified process or port linkee. If the linkee\nis a port, it must reside on the same node as the caller.\n\nIf one of the participants of a link terminates, it will\n[send an exit signal](`e:system:ref_man_processes.md#sending_exit_signals`) to\nthe other participant. The exit signal will contain the\n[exit reason](`e:system:ref_man_processes.md#link_exit_signal_reason`) of the\nterminated participant. Other cases when exit signals are triggered due to a\nlink are when no linkee exist (`noproc` exit reason) and when the connection\nbetween linked processes on different nodes is lost or cannot be established\n(`noconnection` exit reason).\n\nAn existing link can be removed by calling `unlink/1`. For more information on\nlinks and exit signals due to links, see the _Processes_ chapter in the _Erlang\nReference Manual_:\n\n- [Links](`e:system:ref_man_processes.md#links`)\n- [Sending Exit Signals](`e:system:ref_man_processes.md#sending_exit_signals`)\n- [Receiving Exit Signals](`e:system:ref_man_processes.md#receiving_exit_signals`)\n\nFor historical reasons, [`link/1`](`link/1`) has a strange semi-synchronous\nbehavior when it is \"cheap\" to check if the linkee exists or not, and the caller\ndoes not [trap exits](#process_flag_trap_exit). If the above is true\nand the linkee does not exist, [`link/1`](`link/1`) will raise a `noproc` error\n_exception_. The expected behavior would instead have been that\n[`link/1`](`link/1`) returned `true`, and the caller later was sent an exit\nsignal with `noproc` exit reason, but this is unfortunately not the case. The\n`noproc` [exception](`e:system:errors.md#exceptions`) is not to be confused with\nan [exit signal](`e:system:ref_man_processes.md#sending_exit_signals`) with exit\nreason `noproc`. Currently it is \"cheap\" to check if the linkee exists when it\nis supposed to reside on the same node as the calling process.\n\nThe link setup and activation is performed asynchronously. If the link already\nexists, or if the caller attempts to create a link to itself, nothing is done. A\ndetailed description of the [link protocol](erl_dist_protocol.md#link_protocol)\ncan be found in the _Distribution Protocol_ chapter of the _ERTS User's Guide_.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.\n\nFailure:\n\n- `badarg` if `PidOrPort` does not identify a process or a node local port.\n- `noproc` linkee does not exist and it is \"cheap\" to check if it exists as\n  described above.","ref":"erlang.html#link/1"},{"type":"type","title":"erlang.list/0","doc":"An Erlang [list](`e:system:data_types.md#list`) containing terms of any type.","ref":"erlang.html#t:list/0"},{"type":"type","title":"erlang.list/1","doc":"An Erlang [list](`e:system:data_types.md#list`) containing terms of the type\n`ContentType`.","ref":"erlang.html#t:list/1"},{"type":"function","title":"erlang.list_to_atom/1","doc":"Returns the atom whose text representation is `String`.\n\nAs from Erlang/OTP 20, `String` may contain any Unicode character. Earlier\nversions allowed only ISO-latin-1 characters as the implementation did not allow\nUnicode characters above 255.\n\n> #### Note {: .info }\n>\n> The number of characters that are permitted in an atom name is limited. The\n> default limits can be found in the\n> [efficiency guide (section System Limits)](`e:system:system_limits.md`).\n\n> #### Note {: .info }\n>\n> There is a [configurable limit](`e:system:system_limits.md#atoms`)\n> on how many atoms that can exist and atoms are not\n> garbage collected. Therefore, it is recommended to consider if\n> `list_to_existing_atom/1` is a better option than\n> [`list_to_atom/1`](`list_to_atom/1`). The default limits can be found in the\n> [Efficiency Guide (section System Limits)](`e:system:system_limits.md`).\n\nExample:\n\n```erlang\n> list_to_atom(\"Erlang\").\n'Erlang'\n```","ref":"erlang.html#list_to_atom/1"},{"type":"function","title":"erlang.list_to_binary/1","doc":"Returns a binary that is made from the integers and binaries in `IoList`.\n\nFor example:\n\n```erlang\n> Bin1 = <<1,2,3>>.\n<<1,2,3>>\n> Bin2 = <<4,5>>.\n<<4,5>>\n> Bin3 = <<6>>.\n<<6>>\n> list_to_binary([Bin1,1,[2,3,Bin2],4|Bin3]).\n<<1,2,3,1,2,3,4,5,4,6>>\n```","ref":"erlang.html#list_to_binary/1"},{"type":"function","title":"erlang.list_to_bitstring/1","doc":"Returns a bitstring that is made from the integers and bitstrings in\n`BitstringList`. (The last tail in `BitstringList` is allowed to be a\nbitstring.)\n\nFor example:\n\n```erlang\n> Bin1 = <<1,2,3>>.\n<<1,2,3>>\n> Bin2 = <<4,5>>.\n<<4,5>>\n> Bin3 = <<6,7:4>>.\n<<6,7:4>>\n> list_to_bitstring([Bin1,1,[2,3,Bin2],4|Bin3]).\n<<1,2,3,1,2,3,4,5,4,6,7:4>>\n```","ref":"erlang.html#list_to_bitstring/1"},{"type":"function","title":"erlang.list_to_existing_atom/1","doc":"Returns the atom whose text representation is `String`, but only if there\nalready exists such atom. An atom exists if it has been created by the run-time\nsystem by either loading code or creating a term in which the atom is part.\n\nFailure: `badarg` if there does not already exist an atom whose text\nrepresentation is `String`.\n\n> #### Note {: .info }\n>\n> Note that the compiler may optimize away atoms. For example, the compiler will\n> rewrite [`atom_to_list(some_atom)`](`atom_to_list/1`) to `\"some_atom\"`. If\n> that expression is the only mention of the atom `some_atom` in the containing\n> module, the atom will not be created when the module is loaded, and a\n> subsequent call to\n> [`list_to_existing_atom(\"some_atom\")`](`list_to_existing_atom/1`) will fail.","ref":"erlang.html#list_to_existing_atom/1"},{"type":"function","title":"erlang.list_to_float/1","doc":"Returns the float whose text representation is `String`. \n\nFor example:\n\n```erlang\n> list_to_float(\"2.2017764e+0\").\n2.2017764\n```\n\nThe float string format is the same as the format for\n[Erlang float literals](`e:system:data_types.md`) except for that underscores\nare not permitted.\n\nFailure: `badarg` if `String` contains a bad representation of a float.","ref":"erlang.html#list_to_float/1"},{"type":"function","title":"erlang.list_to_integer/1","doc":"Returns an integer whose text representation is `String`.\n\nFor example:\n\n```erlang\n> list_to_integer(\"123\").\n123\n```\n\n```erlang\n> list_to_integer(\"-123\").\n-123\n```\n\n```erlang\n> list_to_integer(\"+123234982304982309482093833234234\").\n123234982304982309482093833234234\n```\n\n`String` must contain at least one digit character and can have an optional\nprefix consisting of a single \"`+`\" or \"`-`\" character (that is, `String` must\nmatch the regular expression `\"^[+-]?[0-9]+$\"`).\n\nFailure: `badarg` if `String` contains a bad representation of an integer.","ref":"erlang.html#list_to_integer/1"},{"type":"function","title":"erlang.list_to_integer/2","doc":"Returns an integer whose text representation in base `Base` is `String`.\n\nFor example:\n\n```erlang\n> list_to_integer(\"3FF\", 16).\n1023\n```\n\n```erlang\n> list_to_integer(\"+3FF\", 16).\n1023\n```\n\n```erlang\n> list_to_integer(\"3ff\", 16).\n1023\n```\n\n```erlang\n> list_to_integer(\"3fF\", 16).\n1023\n```\n\n```erlang\n> list_to_integer(\"-3FF\", 16).\n-1023\n```\n\nFor example, when `Base` is 16, `String` must match the regular expression\n`\"^[+-]?([0-9]|[A-F]|[a-f])+$\"`.\n\nFailure: `badarg` if `String` contains a bad representation of an integer.","ref":"erlang.html#list_to_integer/2"},{"type":"function","title":"erlang.list_to_pid/1","doc":"Returns a process identifier whose text representation is a `String`.\n\nFor example:\n\n```erlang\n> list_to_pid(\"<0.4.1>\").\n<0.4.1>\n```\n\nFailure: `badarg` if `String` contains a bad representation of a process\nidentifier.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging and is not to be used in application\n> programs.","ref":"erlang.html#list_to_pid/1"},{"type":"function","title":"erlang.list_to_port/1","doc":"Returns a port identifier whose text representation is a `String`.\n\nFor example:\n\n```erlang\n> list_to_port(\"#Port<0.4>\").\n#Port<0.4>\n```\n\nFailure: `badarg` if `String` contains a bad representation of a port\nidentifier.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging and is not to be used in application\n> programs.","ref":"erlang.html#list_to_port/1"},{"type":"function","title":"erlang.list_to_ref/1","doc":"Returns a reference whose text representation is a `String`.\n\nFor example:\n\n```erlang\n> list_to_ref(\"#Ref<0.4192537678.4073193475.71181>\").\n#Ref<0.4192537678.4073193475.71181>\n```\n\nFailure: `badarg` if `String` contains a bad representation of a reference.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging and is not to be used in application\n> programs.","ref":"erlang.html#list_to_ref/1"},{"type":"function","title":"erlang.list_to_tuple/1","doc":"Returns a tuple corresponding to `List`, for example\n\n```erlang\n> list_to_tuple([share, ['Ericsson_B', 163]]).\n{share, ['Ericsson_B', 163]}\n```\n\n`List` can contain any Erlang terms.","ref":"erlang.html#list_to_tuple/1"},{"type":"function","title":"erlang.load_module/2","doc":"Loads `Module` described by the object code contained within `Binary`.\n\nIf the code for module `Module` already exists, all export\nreferences are replaced so they point to the newly loaded code. The previously\nloaded code is kept in the system as old code, as there can still be processes\nexecuting that code.\n\nReturns either `{module, Module}`, or `{error, Reason}` if loading fails.\n`Reason` is one of the following:\n\n- **`badfile`** - The object code in `Binary` has an incorrect format _or_ the\n  object code contains code for another module than `Module`.\n\n- **`not_purged`** - `Binary` contains a module that cannot be loaded because\n  old code for this module already exists.\n\n- **`on_load`** - The code in `Binary` contains an `on_load` declaration that\n  must be executed before `Binary` can become the current code. Any previous\n  current code for `Module` will remain until the `on_load` call has finished.\n\n- **not_allowed** - The code in `Binary` has been compiled with features that\n  are currently not enabled in the runtime system.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for the code server (see `m:code`) and is not to be used\n> elsewhere.","ref":"erlang.html#load_module/2"},{"type":"function","title":"erlang.load_nif/2","doc":"Loads and links a dynamic library containing native implemented functions (NIFs)\nfor a module.\n\n`Path` is a file path to the shareable object/dynamic library file\nminus the OS-dependent file extension (`.so` for Unix and `.dll` for Windows).\nNotice that on most OSs the library has to have a different name on disc when an\nupgrade of the nif is done. If the name is the same, but the contents differ,\nthe old library may be loaded instead. For information on how to implement a NIF\nlibrary, see [`erl_nif(3)`](erl_nif.md).\n\n`LoadInfo` can be any term. It is passed on to the library as part of the\ninitialization. A good practice is to include a module version number to support\nfuture code upgrade scenarios.\n\nThe call to [`load_nif/2`](`load_nif/2`) must be made _directly_ from the Erlang\ncode of the module that the NIF library belongs to. It returns either `ok`, or\n`{error,{Reason,Text}}` if loading fails. `Reason` is one of the following atoms\nwhile `Text` is a human readable string that can give more information about the\nfailure:\n\n- **`load_failed`** - The OS failed to load the NIF library.\n\n- **`bad_lib`** - The library did not fulfill the requirements as a NIF library\n  of the calling module.\n\n- **`load | upgrade`** - The corresponding library callback was unsuccessful.\n\n- **`reload`** - A NIF library is already loaded for this module instance. The\n  previously deprecated `reload` feature was removed in OTP 20.\n\n- **`old_code`** - The call to [`load_nif/2`](`load_nif/2`) was made from the\n  old code of a module that has been upgraded; this is not allowed.\n\nIf the [`-nifs()`](`e:system:modules.md#nifs_attribute`) attribute is used\n(which is recommended), all NIFs in the dynamic library must be declared as such\nfor [`load_nif/2`](`load_nif/2`) to succeed. On the other hand, all functions\ndeclared with the `-nifs()` attribute do not have to be implemented by the\ndynamic library. This allows a target independent Erlang file to contain\nfallback implementations for functions that may lack NIF support depending on\ntarget OS/hardware platform.","ref":"erlang.html#load_nif/2"},{"type":"function","title":"erlang.loaded/0","doc":"Returns a list of all loaded Erlang modules (current and old code), including\npreloaded modules.\n\nSee also `m:code`.","ref":"erlang.html#loaded/0"},{"type":"function","title":"erlang.localtime/0","doc":"Returns the current local date and time,\n`{{Year, Month, Day}, {Hour, Minute, Second}}`.\n\nFor example:\n\n```erlang\n> erlang:localtime().\n{{1996,11,6},{14,45,17}}\n```\n\nThe time zone and Daylight Saving Time correction depend on the underlying OS.\nThe return value is based on the\n[OS System Time](time_correction.md#os-system-time).","ref":"erlang.html#localtime/0"},{"type":"function","title":"erlang.localtime_to_universaltime/1","doc":"Converts local date and time to Universal Time Coordinated (UTC), if supported\nby the underlying OS. Otherwise no conversion is done and `Localtime` is\nreturned.\n\nFor example:\n\n```erlang\n> erlang:localtime_to_universaltime({{1996,11,6},{14,45,17}}).\n{{1996,11,6},{13,45,17}}\n```\n\nFailure: `badarg` if `Localtime` denotes an invalid date and time.","ref":"erlang.html#localtime_to_universaltime/1"},{"type":"function","title":"erlang.localtime_to_universaltime/2","doc":"Converts local date and time to Universal Time Coordinated (UTC) as\n`erlang:localtime_to_universaltime/1`, but the caller decides if Daylight Saving\nTime is active.\n\nIf `IsDst == true`, `Localtime` is during Daylight Saving Time, if\n`IsDst == false` it is not. If `IsDst == undefined`, the underlying OS can\nguess, which is the same as calling\n`erlang:localtime_to_universaltime(Localtime)`.\n\nExamples:\n\n```erlang\n> erlang:localtime_to_universaltime({{1996,11,6},{14,45,17}}, true).\n{{1996,11,6},{12,45,17}}\n> erlang:localtime_to_universaltime({{1996,11,6},{14,45,17}}, false).\n{{1996,11,6},{13,45,17}}\n> erlang:localtime_to_universaltime({{1996,11,6},{14,45,17}}, undefined).\n{{1996,11,6},{13,45,17}}\n```\n\nFailure: `badarg` if `Localtime` denotes an invalid date and time.","ref":"erlang.html#localtime_to_universaltime/2"},{"type":"function","title":"erlang.make_ref/0","doc":"Returns a [unique reference](`e:system:system_limits.md#unique_references`). The\nreference is unique among connected nodes.\n\n> #### Warning {: .warning }\n>\n> Before OTP 23 when a node is restarted multiple times with the same node name,\n> references created on a newer node can be mistaken for a reference created on\n> an older node with the same node name.","ref":"erlang.html#make_ref/0"},{"type":"function","title":"erlang.make_tuple/2","doc":"Creates a new tuple of the specified `Arity`, where all elements are\n`InitialValue`.\n\nFor example:\n\n```erlang\n> erlang:make_tuple(4, []).\n{[],[],[],[]}\n```","ref":"erlang.html#make_tuple/2"},{"type":"function","title":"erlang.make_tuple/3","doc":"Creates a tuple of size `Arity`, where each element has value `DefaultValue`,\nand then fills in values from `InitList`.\n\nEach list element in `InitList` must be a two-tuple, where the first element is\na position in the newly created tuple and the second element is any term. If a\nposition occurs more than once in the list, the term corresponding to the last\noccurrence is used.\n\nFor example:\n\n```erlang\n> erlang:make_tuple(5, [], [{2,ignored},{5,zz},{2,aa}]).\n{[],aa,[],[],zz}\n```","ref":"erlang.html#make_tuple/3"},{"type":"type","title":"erlang.map/0","doc":"An Erlang [map](`e:system:data_types.md#map`) containing any number of key and\nvalue associations.","ref":"erlang.html#t:map/0"},{"type":"function","title":"erlang.map_get/2","doc":"Returns value `Value` associated with `Key` if `Map` contains `Key`.\n\nThe call fails with a `{badmap,Map}` exception if `Map` is not a map, or with a\n`{badkey,Key}` exception if no value is associated with `Key`.\n\n_Example:_\n\n```erlang\n> Key = 1337,\n  Map = #{42 => value_two,1337 => \"value one\",\"a\" => 1},\n  map_get(Key,Map).\n\"value one\"\n```","ref":"erlang.html#map_get/2"},{"type":"function","title":"erlang.map_size/1","doc":"Returns an integer, which is the number of key-value pairs in `Map`.\n\nFor example:\n\n```erlang\n> map_size(#{a=>1, b=>2, c=>3}).\n3\n```","ref":"erlang.html#map_size/1"},{"type":"function","title":"erlang.match_spec_test/3","doc":"Tests a match specification used in calls to `ets:select/2` and\n`trace:function/4`.\n\nThe function tests both a match specification for \"syntactic\" correctness and\nruns the match specification against the object.\nIf the match specification contains errors, the tuple\n`{error, Errors}` is returned, where `Errors` is a list of natural language\ndescriptions of what was wrong with the match specification.\n\nIf `Type` is `table`, the object to match against is to be a tuple. The function\nthen returns `{ok,Result,[],Warnings}`, where `Result` is what would have been\nthe result in a real `ets:select/2` call, or `false` if the match specification\ndoes not match the object tuple.\n\nIf `Type` is `trace`, the object to match against is to be a list. The function\nreturns `{ok, Result, Flags, Warnings}`, where `Result` is one of the following:\n\n- `true` if a trace message is to be emitted\n- `false` if a trace message is not to be emitted\n- The message term to be appended to the trace message\n\n`Flags` is a list containing all the trace flags to be enabled, currently this\nis only `return_trace`.\n\nThis is a useful debugging and test tool, especially when writing complicated\nmatch specifications.\n\nSee also `ets:test_ms/2`.","ref":"erlang.html#match_spec_test/3"},{"type":"type","title":"erlang.match_variable/0","doc":"","ref":"erlang.html#t:match_variable/0"},{"type":"function","title":"erlang.max/2","doc":"Returns the largest of `Term1` and `Term2`. If the terms compare equal with the\n`==` operator, `Term1` is returned.\n\nThe [Expressions section](`e:system:expressions.md#term-comparisons`) contains\ndescriptions of the `==` operator and how terms are ordered.\n\nExamples:\n\n```erlang\n> max(1, 2).\n2\n```\n\n```erlang\n> max(1.0, 1).\n1.0\n```\n\n```erlang\n> max(1, 1.0).\n1\n```\n\n```erlang\n> max(\"abc\", \"b\").\n\"b\"\n```\n\n> #### Change {: .info }\n>\n> Allowed in guards tests from Erlang/OTP 26.","ref":"erlang.html#max/2"},{"type":"type","title":"erlang.max_heap_size/0","doc":"Process max heap size configuration. For more info see\n[`process_flag(max_heap_size, MaxHeapSize)`](#process_flag_max_heap_size)","ref":"erlang.html#t:max_heap_size/0"},{"type":"type","title":"erlang.maybe_improper_list/0","doc":"An Erlang [list](`e:system:data_types.md#list`) that is not guaranteed to end\nwith a [`[]`](`t:nil/0`), and where the list elements can be of any type.","ref":"erlang.html#t:maybe_improper_list/0"},{"type":"type","title":"erlang.maybe_improper_list/2","doc":"An Erlang [list](`e:system:data_types.md#list`), that is not guaranteed to end\nwith a [`[]`](`t:nil/0`), and where the list elements are of the type\n`ContentType`.","ref":"erlang.html#t:maybe_improper_list/2"},{"type":"function","title":"erlang.md5/1","doc":"Computes an MD5 message digest from `Data`, where the length of the digest is\n128 bits (16 bytes). `Data` is a binary or a list of small integers and\nbinaries.\n\nFor more information about MD5, see\n[RFC 1321 - The MD5 Message-Digest Algorithm](https://www.ietf.org/rfc/rfc1321.txt).\n\n> #### Warning {: .warning }\n>\n> The MD5 Message-Digest Algorithm is _not_ considered safe for code-signing or\n> software-integrity purposes.","ref":"erlang.html#md5/1"},{"type":"function","title":"erlang.md5_final/1","doc":"Finishes the update of an MD5 `Context` and returns the computed `MD5` message\ndigest.","ref":"erlang.html#md5_final/1"},{"type":"function","title":"erlang.md5_init/0","doc":"Creates an MD5 context, to be used in the following calls to\n[`md5_update/2`](`md5_update/2`).","ref":"erlang.html#md5_init/0"},{"type":"function","title":"erlang.md5_update/2","doc":"Update an MD5 `Context` with `Data` and returns a `NewContext`.","ref":"erlang.html#md5_update/2"},{"type":"function","title":"erlang.memory/0","doc":"Returns a list with information about memory dynamically allocated by the Erlang\nemulator.\n\nEach list element is a tuple `{Type, Size}`. The first element `Type`\nis an atom describing memory type. The second element `Size` is the memory size\nin bytes.\n\nMemory types:\n\n- **`total`** - The total amount of memory currently allocated. This is the same\n  as the sum of the memory size for `processes` and `system`.\n\n- **`processes`** - The total amount of memory currently allocated for the\n  Erlang processes.\n\n- **`processes_used`** - The total amount of memory currently used by the Erlang\n  processes. This is part of the memory presented as `processes` memory.\n\n- **`system`** - The total amount of memory currently allocated for the emulator\n  that is not directly related to any Erlang process. Memory presented as\n  `processes` is not included in this memory. `m:instrument` can be used to get\n  a more detailed breakdown of what memory is part of this type.\n\n- **`atom`** - The total amount of memory currently allocated for atoms. This\n  memory is part of the memory presented as `system` memory.\n\n- **`atom_used`** - The total amount of memory currently used for atoms. This\n  memory is part of the memory presented as `atom` memory.\n\n- **`binary`** - The total amount of memory currently allocated for binaries.\n  This memory is part of the memory presented as `system` memory.\n\n- **`code`** - The total amount of memory currently allocated for Erlang code.\n  This memory is part of the memory presented as `system` memory.\n\n- **`ets`** - The total amount of memory currently allocated for ETS tables.\n  This memory is part of the memory presented as `system` memory.\n\n- **`maximum`** - The maximum total amount of memory allocated since the\n  emulator was started. This tuple is only present when the emulator is run with\n  instrumentation.\n\n  For information on how to run the emulator with instrumentation, see\n  `m:instrument` and/or [`erl(1)`](erl_cmd.md).\n\n> #### Note {: .info }\n>\n> The `system` value is not complete. Some allocated memory that is to be part\n> of this value is not.\n>\n> When the emulator is run with instrumentation, the `system` value is more\n> accurate, but memory directly allocated for `malloc` (and friends) is still\n> not part of the `system` value. Direct calls to `malloc` are only done from\n> OS-specific runtime libraries and perhaps from user-implemented Erlang drivers\n> that do not use the memory allocation functions in the driver interface.\n>\n> As the `total` value is the sum of `processes` and `system`, the error in\n> `system` propagates to the `total` value.\n>\n> The different amounts of memory that are summed are _not_ gathered atomically,\n> which introduces an error in the result.\n\nThe different values have the following relation to each other. Values beginning\nwith an uppercase letter is not part of the result.\n\n```text\ntotal      = processes + system\nprocesses  = processes_used + ProcessesNotUsed\nsystem     = atom + binary + code + ets + OtherSystem\natom       = atom_used + AtomNotUsed\nRealTotal  = processes + RealSystem\nRealSystem = system + MissedSystem\n```\n\nMore tuples in the returned list can be added in a future release.\n\n> #### Note {: .info }\n>\n> The `total` value is supposed to be the total amount of memory dynamically\n> allocated by the emulator. Shared libraries, the code of the emulator itself,\n> and the emulator stacks are not supposed to be included. That is, the `total`\n> value is _not_ supposed to be equal to the total size of all pages mapped to\n> the emulator.\n>\n> Also, because of fragmentation and prereservation of memory areas, the size of\n> the memory segments containing the dynamically allocated memory blocks can be\n> much larger than the total size of the dynamically allocated memory blocks.\n\n> #### Change {: .info }\n>\n> As from ERTS 5.6.4, `erlang:memory/0` requires that all\n> [`erts_alloc(3)`](erts_alloc.md) allocators are enabled (default behavior).\n\nFailure: `notsup` if an [`erts_alloc(3)`](erts_alloc.md) allocator has been\ndisabled.","ref":"erlang.html#memory/0"},{"type":"function","title":"erlang.memory/1","doc":"Returns the memory size in bytes allocated for memory of type `Type`. The\nargument can also be specified as a list of `t:memory_type/0` atoms, in which case\na corresponding list of `{memory_type(), Size :: integer >= 0}` tuples is\nreturned.\n\n> #### Change {: .info }\n>\n> As from ERTS 5.6.4, `erlang:memory/1` requires that all\n> [`erts_alloc(3)`](erts_alloc.md) allocators are enabled (default behavior).\n\nFailures:\n\n- **`badarg`** - If `Type` is not one of the memory types listed in the\n  description of [`erlang:memory/0`](`memory/0`).\n\n- **`badarg`** - If `maximum` is passed as `Type` and the emulator is not run in\n  instrumented mode.\n\n- **`notsup`** - If an [`erts_alloc(3)`](erts_alloc.md) allocator has been\n  disabled.\n\nSee also [`erlang:memory/0`](`memory/0`).","ref":"erlang.html#memory/1"},{"type":"type","title":"erlang.memory_type/0","doc":"","ref":"erlang.html#t:memory_type/0"},{"type":"type","title":"erlang.message_queue_data/0","doc":"See\n[`process_flag(message_queue_data, MQD)`](#process_flag_message_queue_data).\n\nProcess message queue data configuration. For more information, see\n[`process_flag(message_queue_data, MQD)`](#process_flag_message_queue_data)","ref":"erlang.html#t:message_queue_data/0"},{"type":"type","title":"erlang.mfa/0","doc":"A three-tuple representing a `Module:Function/Arity` function signature.","ref":"erlang.html#t:mfa/0"},{"type":"function","title":"erlang.min/2","doc":"Returns the smallest of `Term1` and `Term2`. If the terms compare equal with the\n`==` operator, `Term1` is returned.\n\nThe [Expressions section](`e:system:expressions.md#term-comparisons`) contains\ndescriptions of the `==` operator and how terms are ordered.\n\nExamples:\n\n```erlang\n> min(1, 2).\n1\n```\n\n```erlang\n> min(1.0, 1).\n1.0\n```\n\n```erlang\n> min(1, 1.0).\n1\n```\n\n```erlang\n> min(\"abc\", \"b\").\n\"abc\"\n```\n\n> #### Change {: .info }\n>\n> Allowed in guards tests from Erlang/OTP 26.","ref":"erlang.html#min/2"},{"type":"type","title":"erlang.module/0","doc":"An Erlang module represented by an atom.","ref":"erlang.html#t:module/0"},{"type":"function","title":"erlang.module_loaded/1","doc":"Returns `true` if the module `Module` is loaded as\n[_current code_](`e:system:code_loading.md#code-replacement`); otherwise,\n`false`. It does not attempt to load the module.","ref":"erlang.html#module_loaded/1"},{"type":"function","title":"erlang.monitor/2","doc":"Sends a monitor request of type `Type` to the entity identified by `Item`.\n\nIf the monitored entity does not exist or it changes monitored state, the caller\nof `monitor/2` is notified by a message on the following format:\n{: #monitor_message}\n\n```erlang\n{Tag, MonitorRef, Type, Object, Info}\n```\n\n> #### Note {: .info }\n>\n> The monitor request is an asynchronous signal. That is, it takes time before\n> the signal reaches its destination.\n\n`Type` can be one of the following atoms: `process`, `port` or `time_offset`.\n\nA `process` or `port` monitor is triggered only once, after that it is removed\nfrom both monitoring process and the monitored entity. Monitors are fired when\nthe monitored process or port terminates, does not exist at the moment of\ncreation, or if the connection to it is lost. If the connection to it is lost,\nwe do not know if it still exists. The monitoring is also turned off when\n`demonitor/1` is called.\n\nA `process` or `port` monitor by name resolves the `RegisteredName` to `t:pid/0`\nor `t:port/0` only once at the moment of monitor instantiation, later changes to\nthe name registration will not affect the existing monitor.\n\nWhen a `process` or `port` monitor is triggered, a `'DOWN'` message is sent that\nhas the following pattern:\n\n```erlang\n{'DOWN', MonitorRef, Type, Object, Info}\n```\n\nIn the monitor message `MonitorRef` and `Type` are the same as described\nearlier, and:\n\n- **`Object`** - The monitored entity, which triggered the event. When\n  monitoring a process or a local port, `Object` will be equal to the `t:pid/0`\n  or `t:port/0` that was being monitored. When monitoring process or port by\n  name, `Object` will have format `{RegisteredName, Node}` where\n  `RegisteredName` is the name which has been used with\n  `monitor/2` call and `Node` is local or remote node name (for\n  ports monitored by name, `Node` is always local node name).\n\n- **`Info`** - Either the exit reason of the process, `noproc` (process or port\n  did not exist at the time of monitor creation), or `noconnection` (no\n  connection to the node where the monitored process resides).\n\n- **Monitoring a `process`{: #monitor_process }** - Creates monitor between the\n  current process and another process identified by `Item`, which can be a\n  `t:pid/0` (local or remote), an atom `RegisteredName` or a tuple\n  `{RegisteredName, Node}` for a registered process, located elsewhere.\n\n  > #### Change {: .info }\n  >\n  > Before ERTS 10.0 (OTP 21.0), monitoring a process could fail with `badarg`\n  > if the monitored process resided on a primitive node (such as erl_interface\n  > or jinterface), where remote process monitoring is not implemented.\n  >\n  > Now, such a call to `monitor` will instead succeed and a monitor is created.\n  > But the monitor will only supervise the connection. That is, a\n  > `{'DOWN', _, process, _, noconnection}` is the only message that may be\n  > received, as the primitive node have no way of reporting the status of the\n  > monitored process.\n\n- **Monitoring a `port`{: #monitor_port }** - Creates monitor between the\n  current process and a port identified by `Item`, which can be a `t:port/0`\n  (only local), an atom `RegisteredName` or a tuple `{RegisteredName, Node}` for\n  a registered port, located on this node. Note, that attempt to monitor a\n  remote port will result in `badarg`.\n\n  Available since OTP 19.0.\n\n- **Monitoring a `time_offset`{: #monitor_time_offset }** - Monitors changes in\n  `time_offset/0` between\n  [Erlang monotonic time](time_correction.md#erlang-monotonic-time) and\n  [Erlang system time](time_correction.md#erlang-system-time). One valid `Item`\n  exists in combination with the `time_offset Type`, namely the atom\n  `clock_service`. Notice that the atom `clock_service` is _not_ the registered\n  name of a process. In this case it serves as an identifier of the runtime\n  system internal clock service at current runtime system instance.\n\n  The monitor is triggered when the time offset is changed. This either if the\n  time offset value is changed, or if the offset is changed from preliminary to\n  final during\n  [finalization of the time offset](#system_flag_time_offset) when the\n  [single time warp mode](time_correction.md#single-time-warp-mode) is used.\n  When a change from preliminary to final time offset is made, the monitor is\n  triggered once regardless of whether the time offset value was changed or not.\n\n  If the runtime system is in\n  [multi time warp mode](time_correction.md#multi-time-warp-mode), the time\n  offset is changed when the runtime system detects that the\n  [OS system time](time_correction.md#os-system-time) has changed. The runtime\n  system does, however, not detect this immediately when it occurs. A task\n  checking the time offset is scheduled to execute at least once a minute, so\n  under normal operation this is to be detected within a minute, but during\n  heavy load it can take longer time.\n\n  The monitor is _not_ automatically removed after it has been triggered. That\n  is, repeated changes of the time offset trigger the monitor repeatedly.\n\n  When the monitor is triggered a `'CHANGE'` message is sent to the monitoring\n  process. A `'CHANGE'` message has the following pattern:\n\n  ```erlang\n  {'CHANGE', MonitorRef, Type, Item, NewTimeOffset}\n  ```\n\n  where `MonitorRef`, `Type`, and `Item` are the same as described above, and\n  `NewTimeOffset` is the new time offset.\n\n  When the `'CHANGE'` message has been received you are guaranteed not to\n  retrieve the old time offset when calling\n  `erlang:time_offset/0`. Notice that you can observe the\n  change of the time offset when calling `erlang:time_offset/0` before you get\n  the `'CHANGE'` message.\n\n  Available since OTP 18.0.\n\nMaking several calls to `monitor/2` for the same `Item` and/or\n`Type` is not an error; it results in as many independent monitoring instances.\n\nThe monitor functionality is expected to be extended. That is, other `Type`s and\n`Item`s are expected to be supported in a future release.\n\n> #### Note {: .info }\n>\n> If or when `monitor/2` is extended, other possible values for\n> `Tag`, `Object`, and `Info` in the monitor message will be introduced.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.","ref":"erlang.html#monitor/2"},{"type":"function","title":"erlang.monitor/3","doc":"Provides an option list for modification of monitoring functionality provided by\n`monitor/2`. The `Type` and `Item` arguments have the same meaning as when\npassed to [`monitor/2`](`monitor/2`).\n\nCurrently available options:\n\n- **`{alias, UnaliasOpt}`** - The returned monitor reference will also become an\n  alias for the calling process. That is, the returned reference can be used for\n  sending messages to the calling process. See also `alias/0`. The `UnaliasOpt`\n  determines how the alias should be deactivated.\n\n  - **`explicit_unalias`** - Only an explicit call to `unalias/1` will\n    deactivate the alias.\n\n  - **`demonitor`** - The alias will be automatically deactivated when the\n    monitor is removed. This either via an explicit call to `demonitor/1` or\n    when it is automatically removed at the same time as a `'DOWN'` message is\n    delivered due to the monitor. The alias can also still be deactivated via a\n    call to [`unalias/1`](`unalias/1`).\n\n  - **`reply_demonitor`** - The alias will be automatically deactivated when the\n    monitor is removed (see `demonitor` option above) or a reply message sent\n    via the alias is received. When a reply message is received via the alias\n    the monitor will also be automatically removed. This is useful in\n    client/server scenarios when a client monitors the server and will get the\n    reply via the alias. Once the response is received both the alias and the\n    monitor will be automatically removed regardless of whether the response is\n    a reply or a `'DOWN'` message. The alias can also still be deactivated via a\n    call to [`unalias/1`](`unalias/1`). Note that if the alias is removed using\n    the [`unalias/1`](`unalias/1`) BIF, the monitor will still be left active.\n\n  Example:\n\n  ```erlang\n  server() ->\n      receive\n          {request, AliasReqId, Request} ->\n              Result = perform_request(Request),\n              AliasReqId ! {reply, AliasReqId, Result}\n      end,\n      server().\n\n  client(ServerPid, Request) ->\n      AliasMonReqId = monitor(process, ServerPid, [{alias, reply_demonitor}]),\n      ServerPid ! {request, AliasMonReqId, Request},\n      %% Alias as well as monitor will be automatically deactivated if we\n      %% receive a reply or a 'DOWN' message since we used 'reply_demonitor'\n      %% as unalias option...\n      receive\n          {reply, AliasMonReqId, Result} ->\n              Result;\n          {'DOWN', AliasMonReqId, process, ServerPid, ExitReason} ->\n              error(ExitReason)\n      end.\n  ```\n\n  Note that both the server and the client in this example must be executing on\n  at least OTP 24 systems in order for this to work.\n\n  For more information on process aliases see the\n  [_Process Aliases_](`e:system:ref_man_processes.md#process-aliases`) section\n  of the _Erlang Reference Manual_.\n\n- **`{tag, UserDefinedTag}`** - Replace the default `Tag` with `UserDefinedTag`\n  in the [monitor message](#monitor_message) delivered when the\n  monitor is triggered. For example, when monitoring a process, the `'DOWN'` tag\n  in the down message will be replaced by `UserDefinedTag`.\n\n  An example of how the `{tag, UserDefinedTag}` option can be used in order to\n  enable the new\n  [selective receive optimization](`e:system:eff_guide_processes.md#receiving-messages`),\n  introduced in OTP 24, when making multiple requests to different servers:\n\n  ```erlang\n  server() ->\n      receive\n          {request, From, ReqId, Request} ->\n              Result = perform_request(Request),\n              From ! {reply, self(), ReqId, Result}\n      end,\n      server().\n\n  client(ServerPids, Request) when is_list(ServerPids) ->\n      ReqId = make_ref(),\n      lists:foreach(fun (ServerPid) ->\n                            _ = monitor(process, ServerPid,\n                                        [{tag, {'DOWN', ReqId}}]),\n                            ServerPid ! {request, self(), ReqId, Request}\n                    end,\n                    ServerPids),\n      receive_replies(ReqId, length(ServerPids), []).\n\n  receive_replies(_ReqId, 0, Acc) ->\n      Acc;\n  receive_replies(ReqId, N, Acc) ->\n      %% The compiler will detect that we match on the 'ReqId'\n      %% reference in all clauses, and will enable the selective\n      %% receive optimization which makes the receive able to\n      %% skip past all messages present in the message queue at\n      %% the time when the 'ReqId' reference was created...\n      Res = receive\n                {reply, ServerPid, ReqId, Result} ->\n                    %% Here we typically would have deactivated the\n                    %% monitor by a call to demonitor(Mon, [flush]) but\n                    %% we ignore this in this example for simplicity...\n                    {ok, ServerPid, Result};\n                {{'DOWN', ReqId}, _Mon, process, ServerPid, ExitReason} ->\n                    {error, ServerPid, ExitReason}\n            end,\n      receive_replies(ReqId, N-1, [Res | Acc]).\n  ```\n\n  In order for this example to work as intended, the client must be executing on\n  at least an OTP 24 system, but the servers may execute on older systems.","ref":"erlang.html#monitor/3"},{"type":"function","title":"erlang.monitor_node/2","doc":"Monitor the status of the node `Node`. If `Flag` is `true`, monitoring is turned\non. If `Flag` is `false`, monitoring is turned off.\n\nMaking several calls to [`monitor_node(Node, true)`](`monitor_node/2`) for the\nsame `Node` is not an error; it results in as many independent monitoring\ninstances.\n\nIf `Node` fails or does not exist, the message `{nodedown, Node}` is delivered\nto the process. If a process has made two calls to\n[`monitor_node(Node, true)`](`monitor_node/2`) and `Node` terminates, two\n`nodedown` messages are delivered to the process. If there is no connection to\n`Node`, an attempt is made to create one. If this fails, a `nodedown` message is\ndelivered.\n\nThe delivery of the `nodedown` signal is not ordered with respect to other link\nor monitor signals from the node that goes down. If you need a guarantee that\nall signals from the remote node has been delivered before the `nodedown` signal\nis sent, you should use `net_kernel:monitor_nodes/1`.\n\nNodes connected through hidden connections can be monitored as any other nodes.\n\nFailure: `notalive` if the local node is not alive.","ref":"erlang.html#monitor_node/2"},{"type":"function","title":"erlang.monitor_node/3","doc":"Behaves as `monitor_node/2` except that it allows an extra option to be\nspecified, namely `allow_passive_connect`.\n\nThis option allows the BIF to wait the normal network connection time-out\nfor the _monitored node_ to connect itself, even if it cannot be actively\nconnected from this node (that is, it is blocked). The state where this can\nbe useful can only be achieved by using the Kernel option `dist_auto_connect once`.\nIf that option is not used, option `allow_passive_connect` has no effect.\n\n> #### Note {: .info }\n>\n> Option `allow_passive_connect` is used internally and is seldom needed in\n> applications where the network topology and the Kernel options in effect are\n> known in advance.\n\nFailure: `badarg` if the local node is not alive or the option list is\nmalformed.","ref":"erlang.html#monitor_node/3"},{"type":"type","title":"erlang.monitor_option/0","doc":"See `monitor/3`.","ref":"erlang.html#t:monitor_option/0"},{"type":"type","title":"erlang.monitor_port_identifier/0","doc":"","ref":"erlang.html#t:monitor_port_identifier/0"},{"type":"type","title":"erlang.monitor_process_identifier/0","doc":"","ref":"erlang.html#t:monitor_process_identifier/0"},{"type":"function","title":"erlang.monotonic_time/0","doc":"Returns the current\n[Erlang monotonic time](time_correction.md#erlang-monotonic-time) in `native`\n[time unit](`t:time_unit/0`). This is a monotonically increasing time\nsince some unspecified point in time.\n\n> #### Note {: .info }\n>\n> This is a\n> [monotonically increasing](time_correction.md#monotonically-increasing) time,\n> but _not_ a\n> [strictly monotonically increasing](time_correction.md#strictly-monotonically-increasing)\n> time. That is, consecutive calls to `erlang:monotonic_time/0` can produce the\n> same result.\n>\n> Different runtime system instances will use different unspecified points in\n> time as base for their Erlang monotonic clocks. That is, it is _pointless_\n> comparing monotonic times from different runtime system instances. Different\n> runtime system instances can also place this unspecified point in time\n> different relative runtime system start. It can be placed in the future (time\n> at start is a negative value), the past (time at start is a positive value),\n> or the runtime system start (time at start is zero). The monotonic time at\n> runtime system start can be retrieved by calling\n> [`erlang:system_info(start_time)`](#system_info_start_time).","ref":"erlang.html#monotonic_time/0"},{"type":"function","title":"erlang.monotonic_time/1","doc":"Returns the current\n[Erlang monotonic time](time_correction.md#erlang-monotonic-time) converted into\nthe `Unit` passed as argument.\n\nSame as calling\n[`erlang:convert_time_unit`](`convert_time_unit/3`)`(`[ `erlang:monotonic_time()`](`monotonic_time/0`)`, native, Unit)`,\nhowever optimized for commonly used `Unit`s.","ref":"erlang.html#monotonic_time/1"},{"type":"type","title":"erlang.neg_integer/0","doc":"A negative integer.","ref":"erlang.html#t:neg_integer/0"},{"type":"function","title":"erlang.nif_error/1","doc":"Works exactly like `error/1`, but Dialyzer thinks that this BIF will return an\narbitrary term. When used in a stub function for a NIF to generate an exception\nwhen the NIF library is not loaded, Dialyzer does not generate false warnings.","ref":"erlang.html#nif_error/1"},{"type":"function","title":"erlang.nif_error/2","doc":"Works exactly like `error/2`, but Dialyzer thinks that this BIF will return an\narbitrary term. When used in a stub function for a NIF to generate an exception\nwhen the NIF library is not loaded, Dialyzer does not generate false warnings.","ref":"erlang.html#nif_error/2"},{"type":"opaque","title":"erlang.nif_resource/0","doc":"An opaque handle identifying a\n[NIF resource object ](erl_nif.md#resource_objects).","ref":"erlang.html#t:nif_resource/0"},{"type":"type","title":"erlang.no_return/0","doc":"The type used to show that a function will _never_ return a value, that is it\nwill _always_ throw an exception.","ref":"erlang.html#t:no_return/0"},{"type":"type","title":"erlang.node/0","doc":"An Erlang [node](`e:system:distributed.md#nodes`) represented by an atom.","ref":"erlang.html#t:node/0"},{"type":"function","title":"erlang.node/0","doc":"Returns the name of the local node. If the node is not alive, `nonode@nohost` is\nreturned instead.","ref":"erlang.html#node/0"},{"type":"function","title":"erlang.node/1","doc":"Returns the node where `Arg` originates. `Arg` can be a process identifier, a\nreference, or a port. If `Arg` originates from the local node and the local node\nis not alive, `nonode@nohost` is returned.","ref":"erlang.html#node/1"},{"type":"function","title":"erlang.nodes/0","doc":"Returns a list of all nodes connected to this node through normal connections\n(that is, [hidden nodes](`e:system:distributed.md#hidden-nodes`) are not\nlisted). Same as [nodes(visible)](#nodes_visible).","ref":"erlang.html#nodes/0"},{"type":"function","title":"erlang.nodes/1","doc":"Returns a list of nodes according to the argument specified. The returned\nresult, when the argument is a list, is the list of nodes satisfying the\ndisjunction(s) of the list elements.\n\n`NodeType`s:\n\n- **`visible`{: #nodes_visible }** - Nodes connected to this node through normal\n  connections.\n\n- **`hidden`** - Nodes connected to this node through hidden connections.\n\n- **`connected`** - All nodes connected to this node.\n\n- **`this`** - This node.\n\n- **`known`** - Nodes that are known to this node. That is, connected nodes and\n  nodes referred to by process identifiers, port identifiers, and references\n  located on this node. The set of known nodes is garbage collected. Notice that\n  this garbage collection can be delayed. For more information, see\n  [`erlang:system_info(delayed_node_table_gc)`](#system_info_delayed_node_table_gc).\n\nSome equalities: `[node()] = nodes(this)`,\n`nodes(connected) = nodes([visible, hidden])`, and `nodes() = nodes(visible)`.","ref":"erlang.html#nodes/1"},{"type":"function","title":"erlang.nodes/2","doc":"Returns a list of `NodeInfo` tuples.\n\nThe first element is the node name. Nodes to be included in the list are determined\nby the first argument `Arg` in the same way as for [`nodes(Arg)`](`nodes/1`).\nThe second element of `NodeInfo` tuples is a map containing further information\nabout the node identified by the first element.\nThe information present in this map is determined by the\n`InfoOpts` map passed as the second argument. Currently the following\nassociations are allowed in the `InfoOpts` map:\n\n- **`connection_id => boolean()`** - If the value of the association equals\n  `true`, the `Info` map in the returned result will contain the key\n  `connection_id` associated with the value `ConnectionId`. If `ConnectionId`\n  equals `undefined`, the node is not connected to the node which the caller is\n  executing on, or is the node which the caller is executing on. If\n  `ConnectionId` is an integer, the node is currently connected to the node\n  which the caller is executing on.\n\n  [](){: #connection_id } The integer connection identifier value together with\n  a node name identifies a specific connection instance to the node with that\n  node name. The connection identifier value is node local. That is, on the\n  other node the connection identifier will _not_ be the same value. If a\n  connection is taken down and then taken up again, the connection identifier\n  value will change for the connection to that node. The amount of values for\n  connection identifiers are limited, so it is possible to see the same value\n  for different instances, but quite unlikely. It is undefined how the value\n  change between two consecutive connection instances.\n\n- **`node_type => boolean()`** - If the value of the association equals `true`,\n  the `Info` map in the returned result will contain the key `node_type`\n  associated with the value `NodeTypeInfo`. Currently the following node types\n  exist:\n\n  - **`visible`** - The node is connected to the node of the calling process\n    through an ordinary visible connection. That is, the node name would appear\n    in the result returned by `nodes/0`.\n\n  - **`hidden`** - The node is connected to the node of the calling process\n    through a hidden connection. That is, the node name would _not_ appear in\n    the result returned by `nodes/0`.\n\n  - **`this`** - This is the node of the calling process.\n\n  - **`known`** - The node is not connected but known to the node of the calling\n    process.\n\nExample:\n\n```erlang\n(a@localhost)1> nodes([this, connected], #{connection_id=>true, node_type=>true}).\n[{c@localhost,#{connection_id => 13892108,node_type => hidden}},\n {b@localhost,#{connection_id => 3067553,node_type => visible}},\n {a@localhost,#{connection_id => undefined,node_type => this}}]\n(a@localhost)2>\n```","ref":"erlang.html#nodes/2"},{"type":"type","title":"erlang.non_neg_integer/0","doc":"A non-negative integer, that is any positive integer or 0.","ref":"erlang.html#t:non_neg_integer/0"},{"type":"type","title":"erlang.none/0","doc":"This type is used to show that a function will _never_ return a value; that is\nit will _always_ throw an exception.\n\nIn a spec, use `t:no_return/0` for the sake of clarity.","ref":"erlang.html#t:none/0"},{"type":"type","title":"erlang.nonempty_binary/0","doc":"A `t:binary/0` that contains some data.","ref":"erlang.html#t:nonempty_binary/0"},{"type":"type","title":"erlang.nonempty_bitstring/0","doc":"A `t:bitstring/0` that contains some data.","ref":"erlang.html#t:nonempty_bitstring/0"},{"type":"type","title":"erlang.nonempty_improper_list/2","doc":"A [maybe_improper_list/2](`t:maybe_improper_list/0`) that contains some items.","ref":"erlang.html#t:nonempty_improper_list/2"},{"type":"type","title":"erlang.nonempty_list/0","doc":"A `t:list/0` that contains some items.","ref":"erlang.html#t:nonempty_list/0"},{"type":"type","title":"erlang.nonempty_list/1","doc":"A [list(ContentType)](`t:list/0`) that contains some items.","ref":"erlang.html#t:nonempty_list/1"},{"type":"type","title":"erlang.nonempty_maybe_improper_list/0","doc":"A `t:maybe_improper_list/0` that contains some items.","ref":"erlang.html#t:nonempty_maybe_improper_list/0"},{"type":"type","title":"erlang.nonempty_maybe_improper_list/2","doc":"A [maybe_improper_list(ContentType, TerminationType)](`t:maybe_improper_list/0`)\nthat contains some items.","ref":"erlang.html#t:nonempty_maybe_improper_list/2"},{"type":"type","title":"erlang.nonempty_string/0","doc":"A `t:string/0` that contains some characters.","ref":"erlang.html#t:nonempty_string/0"},{"type":"function","title":"erlang.now/0","doc":"> #### Warning {: .warning }\n>\n> _This function is deprecated. Do not use it._\n>\n> For more information, see section\n> [Time and Time Correction](time_correction.md) in the User's Guide.\n> Specifically, section [Dos and Dont's](time_correction.md#Dos_and_Donts)\n> describes what to use instead of `erlang:now/0`.\n\nReturns the tuple `{MegaSecs, Secs, MicroSecs}`, which is the elapsed time since\n00:00 GMT, January 1, 1970 (zero hour), if provided by the underlying OS.\nOtherwise some other point in time is chosen. It is also guaranteed that the\nfollowing calls to this BIF return continuously increasing values. Hence, the\nreturn value from `erlang:now/0` can be used to generate unique time stamps. If\nit is called in a tight loop on a fast machine, the time of the node can become\nskewed.\n\nCan only be used to check the local time of day if the time-zone information of\nthe underlying OS is properly configured.","ref":"erlang.html#now/0"},{"type":"type","title":"erlang.number/0","doc":"An Erlang [number](`e:system:data_types.md#number`).","ref":"erlang.html#t:number/0"},{"type":"function","title":"erlang.open_port/2","doc":"Returns a port identifier as the result of opening a new Erlang port. A port can\nbe seen as an external Erlang process.\n\nThe name of the executable as well as the arguments specified in `cd`, `env`,\n`args`, and `arg0` are subject to Unicode filename translation if the system is\nrunning in Unicode filename mode. To avoid translation or to force, for example\nUTF-8, supply the executable and/or arguments as a binary in the correct\nencoding. For details, see the module `m:file`, the function\n`file:native_name_encoding/0` in Kernel, and the\n[`Using Unicode in Erlang`](`e:stdlib:unicode_usage.md`) User's Guide.\n\n> #### Note {: .info }\n>\n> The characters in the name (if specified as a list) can only be > 255 if the\n> Erlang virtual machine is started in Unicode filename translation mode.\n> Otherwise the name of the executable is limited to the ISO Latin-1 character\n> set.\n\n`PortName`s:\n\n- **`{spawn, Command}`** - Starts an external program. `Command` is the name of\n  the external program to be run. `Command` runs outside the Erlang work space\n  unless an Erlang driver with the name `Command` is found. If found, that\n  driver is started. A driver runs in the Erlang work space, which means that it\n  is linked with the Erlang runtime system.\n\n  For external programs, `PATH` is searched (or an equivalent method is used to\n  find programs, depending on the OS). This is done by invoking the shell on\n  certain platforms. The first space-separated token of the command is\n  considered as the name of the executable (or driver). This (among other\n  things) makes this option unsuitable for running programs with spaces in\n  filenames or directory names. If spaces in executable filenames are desired,\n  use `{spawn_executable, Command}` instead.\n\n  > #### Warning {: .warning }\n  >\n  > On Unix systems, arguments are passed to a new operating system process as\n  > an array of strings but on Windows it is up to the child process to parse\n  > them and some Windows programs may apply their own rules, which are\n  > inconsistent with the standard C runtime `argv` parsing.\n  >\n  > This is particularly troublesome when invoking `.bat`, `.cmd`, or `.com`\n  > files as these run implicitly through `cmd.exe`, whose argument parsing is\n  > vulnerable to malicious input and can be used to run arbitrary shell\n  > commands.\n  >\n  > Therefore, if you are running on Windows and you execute batch files or\n  > `.com` applications, you must not pass untrusted input as arguments to the\n  > program. This affects both `spawn` and `spawn_executable`.\n\n- **`{spawn_executable, FileName}`** - Works like `{spawn, FileName}`, but only\n  runs external executables. `FileName` in its whole is used as the name of the\n  executable, including any spaces. If arguments are to be passed, the\n  `PortSettings` `args` and `arg0` can be used.\n\n  The shell is usually not invoked to start the program, it is executed\n  directly. `PATH` (or equivalent) is not searched. To find a program in `PATH`\n  to execute, use `os:find_executable/1`.\n\n  Only if a shell script or `.bat` file is executed, the appropriate command\n  interpreter is invoked implicitly, but there is still no command-argument\n  expansion or implicit `PATH` search.\n\n  If `FileName` cannot be run, an error exception is raised, with the POSIX\n  error code as the reason. The error reason can differ between OSs. Typically\n  the error `enoent` is raised when an attempt is made to run a program that is\n  not found and `eacces` is raised when the specified file is not executable.\n\n- **`{spawn_driver, Command}`** - Works like `{spawn, Command}`, but demands the\n  first (space-separated) token of the command to be the name of a loaded\n  driver. If no driver with that name is loaded, a `badarg` error is raised.\n\n- **`{fd, In, Out}`** - Allows an Erlang process to access any currently opened\n  file descriptors used by Erlang. The file descriptor `In` can be used for\n  standard input, and the file descriptor `Out` for standard output. It is only\n  used for various servers in the Erlang OS (`shell` and `user`). Hence, its use\n  is limited.\n\n`PortSettings` is a list of settings for the port. The valid settings are as\nfollows:\n\n- **`{packet, N}`** - Messages are preceded by their length, sent in `N` bytes,\n  with the most significant byte first. The valid values for `N` are 1, 2,\n  and 4.\n\n- **`stream`** - Output messages are sent without packet lengths. A user-defined\n  protocol must be used between the Erlang process and the external object.\n\n- **`{line, L}`** - Messages are delivered on a per line basis. Each line\n  (delimited by the OS-dependent newline sequence) is delivered in a single\n  message. The message data format is `{Flag, Line}`, where `Flag` is `eol` or\n  `noeol`, and `Line` is the data delivered (without the newline sequence).\n\n  `L` specifies the maximum line length in bytes. Lines longer than this are\n  delivered in more than one message, with `Flag` set to `noeol` for all but the\n  last message. If end of file is encountered anywhere else than immediately\n  following a newline sequence, the last line is also delivered with `Flag` set\n  to `noeol`. Otherwise lines are delivered with `Flag` set to `eol`.\n\n  The `{packet, N}` and `{line, L}` settings are mutually exclusive.\n\n- **`{cd, Dir}`** - Only valid for `{spawn, Command}` and\n  `{spawn_executable, FileName}`. The external program starts using `Dir` as its\n  working directory. `Dir` must be a string.\n\n- **`{env, Env}`** - Only valid for `{spawn, Command}`, and `{spawn_executable, FileName}`.\n  The environment of the started process is extended using the environment\n  specifications in `Env`.\n\n  `Env` is to be a list of tuples `{Name, Val}`, where `Name` is a `t:os:env_var_name/0`\n  representing the name of an environment variable, and `Val` is a `t:os:env_var_name/0`\n  representing the value it is to have in the spawned port process. Both `Name` and `Val` must\n  be strings.\n\n  If `Val` is set to the atom `false` or the empty string (that is `\"\"` or `[]`), open_port\n  will consider those variables unset just as if `os:unsetenv/1` had been called.\n\n  For information about encoding requirements, see documentation of the types\n  for `Name` and `Val`.\n\n- **`{args, [ string() | binary() ]}`** - Only valid for\n  `{spawn_executable, FileName}` and specifies arguments to the executable. Each\n  argument is specified as a separate string and (on Unix) eventually ends up as\n  one element each in the argument vector. On other platforms, a similar\n  behavior is mimicked.\n\n  The arguments are not expanded by the shell before they are supplied to the\n  executable. Most notably this means that file wildcard expansion does not\n  occur. To expand wildcards for the arguments, use `filelib:wildcard/1`. Notice\n  that even if the program is a Unix shell script, meaning that the shell\n  ultimately is invoked, wildcard expansion does not occur, and the script is\n  provided with the untouched arguments. On Windows, wildcard expansion is\n  always up to the program itself, therefore this is not an issue.\n\n  The executable name (also known as `argv[0]`) is not to be specified in this\n  list. The proper executable name is automatically used as `argv[0]`, where\n  applicable.\n\n  If you explicitly want to set the program name in the argument vector, option\n  `arg0` can be used.\n\n- **`{arg0, string() | binary()}`** - Only valid for\n  `{spawn_executable, FileName}` and explicitly specifies the program name\n  argument when running an executable. This can in some circumstances, on some\n  OSs, be desirable. How the program responds to this is highly system-dependent\n  and no specific effect is guaranteed.\n\n- **`exit_status`** - Only valid for `{spawn, Command}`, where `Command` refers\n  to an external program, and for `{spawn_executable, FileName}`.\n\n  When the external process connected to the port exits, a message of the form\n  `{Port,{exit_status,Status}}` is sent to the connected process, where `Status`\n  is the exit status of the external process. If the program aborts on Unix, the\n  same convention is used as the shells do (that is, 128+signal).\n\n  If option `eof` is specified also, the messages `eof` and `exit_status` appear\n  in an unspecified order.\n\n- **`use_stdio`** - Only valid for `{spawn, Command}` and\n  `{spawn_executable, FileName}`. It allows the standard input and output (file\n  descriptors 0 and 1) of the spawned (Unix) process for communication with\n  Erlang.\n\n- **`nouse_stdio`** - The opposite of `use_stdio`. It uses file descriptors 3\n  and 4 for communication with Erlang.\n\n- **`stderr_to_stdout`** - Affects ports to external programs. The executed\n  program gets its standard error file redirected to its standard output file.\n  `stderr_to_stdout` and `nouse_stdio` are mutually exclusive.\n\n- **`overlapped_io`** - Affects ports to external programs on Windows only. The\n  standard input and standard output handles of the port program are, if this\n  option is supplied, opened with flag `FILE_FLAG_OVERLAPPED`, so that the port\n  program can (and must) do overlapped I/O on its standard handles. This is not\n  normally the case for simple port programs, but an option of value for the\n  experienced Windows programmer. _On all other platforms, this option is\n  silently discarded._\n\n- **`in`** - The port can only be used for input.\n\n- **`out`** - The port can only be used for output.\n\n- **`binary`** - All I/O from the port is binary data objects as opposed to\n  lists of bytes.\n\n- **`eof`** - The port is not closed at the end of the file and does not produce\n  an exit signal. Instead, it remains open and a `{Port, eof}` message is sent\n  to the process holding the port.\n\n- **`hide`** - When running on Windows, suppresses creation of a new console\n  window when spawning the port program. (This option has no effect on other\n  platforms.)\n\n- **`{parallelism, Boolean}`** - [](){: #open_port_parallelism } Sets scheduler\n  hint for port parallelism. If set to `true`, the virtual machine schedules\n  port tasks; when doing so, it improves parallelism in the system. If set to\n  `false`, the virtual machine tries to perform port tasks immediately,\n  improving latency at the expense of parallelism. The default can be set at\n  system startup by passing command-line argument [`+spp`](erl_cmd.md#%2Bspp) to\n  [erl](erl_cmd.md).\n\n- **`{busy_limits_port, {Low, High} | disabled}`** - Sets limits that will be\n  used for controlling the busy state of the port.\n\n  When the ports internal output queue size becomes larger than or equal to\n  `High` bytes, it enters the busy state. When it becomes less than `Low` bytes\n  it leaves the busy state. When the port is in the busy state, processes\n  sending commands to it will be suspended until the port leaves the busy state.\n  Commands are in this context either `Port ! {Owner, {command, Data}}` or\n  `port_command/[2,3]`.\n\n  The `Low` limit is automatically adjusted to the same as `High` if it is set\n  larger then `High`. Valid range of values for `Low` and `High` is\n  `[1, (1 bsl (8*erlang:system_info(wordsize)))-2]`. If the atom `disabled` is\n  passed, the port will never enter the busy state.\n\n  The defaults are `Low = 4096` and `High = 8192`.\n\n  _Note_ that this option is only valid when spawning an executable (port\n  program) by opening the spawn driver and when opening the `fd` driver. This\n  option will cause a failure with a `badarg` exception when opening other\n  drivers.\n\n- **`{busy_limits_msgq, {Low, High} | disabled}`** - Sets limits that will be\n  used for controlling the busy state of the port message queue.\n\n  When the ports message queue size becomes larger than or equal to `High` bytes\n  it enters the busy state. When it becomes less than `Low` bytes it leaves the\n  busy state. When the port message queue is in the busy state, processes\n  sending commands to it will be suspended until the port message queue leaves\n  the busy state. Commands are in this context either\n  `Port ! {Owner, {command, Data}}` or `port_command/[2,3]`.\n\n  The `Low` limit is automatically adjusted to the same as `High` if it is set\n  larger then `High`. Valid range of values for `Low` and `High` is\n  `[1, (1 bsl (8*erlang:system_info(wordsize)))-2]`. If the atom `disabled` is\n  passed, the port message queue will never enter the busy state.\n\n  _Note_ that if the driver statically has disabled the use of this feature, a\n  failure with a `badarg` exception will be raised unless this option also is\n  set to `disable` or not passed at all.\n\n  The defaults are `Low = 4096` and `High = 8192` unless the driver itself does\n  modifications of these values.\n\n  _Note_ that the driver might fail if it also adjust these limits by itself and\n  you have disabled this feature.\n\n  The spawn driver (used when spawning an executable) and the `fd` driver do not\n  disable this feature and do not adjust these limits by themselves.\n\n  For more information see the documentation\n  [`erl_drv_busy_msgq_limits()`](erl_driver.md#erl_drv_busy_msgq_limits).\n\nDefault is `stream` for all port types and `use_stdio` for spawned ports.\n\nFailure: if the port cannot be opened, the exit reason is `badarg`,\n`system_limit`, or the POSIX error code that most closely describes the error,\nor `einval` if no POSIX code is appropriate:\n\n- **`badarg`** - Bad input arguments to `open_port`.\n\n- **`system_limit`** - All available ports in the Erlang emulator are in use.\n\n- **`enomem`** - Not enough memory to create the port.\n\n- **`eagain`** - No more available OS processes.\n\n- **`enametoolong`** - Too long external command.\n\n- **`emfile`** - No more available file descriptors (for the OS process that the\n  Erlang emulator runs in).\n\n- **`enfile`** - Full file table (for the entire OS).\n\n- **`eacces`** - `Command` specified in `{spawn_executable, Command}` does not\n  point out an executable file.\n\n- **`enoent`** - `FileName` specified in `{spawn_executable, FileName}` does not\n  point out an existing file.\n\nDuring use of a port opened using `{spawn, Name}`, `{spawn_driver, Name}`, or\n`{spawn_executable, Name}`, errors arising when sending messages to it are\nreported to the owning process using signals of the form\n`{'EXIT', Port, PosixCode}`. For the possible values of `PosixCode`, see\n`m:file`.\n\nThe maximum number of ports that can be open at the same time can be configured\nby passing command-line flag [`+Q`](erl_cmd.md#max_ports) to [erl](erl_cmd.md).","ref":"erlang.html#open_port/2"},{"type":"function","title":"erlang.phash2/1","doc":"","ref":"erlang.html#phash2/1"},{"type":"function","title":"erlang.phash2/2","doc":"Portable hash function that gives the same hash for the same Erlang term\nregardless of machine architecture and ERTS version.\n\nThe function returns a hash value for `Term` within the range\n`0..Range-1`. The maximum value for `Range` is 2^32. When without argument\n`Range`, a value in the range 0..2^27-1 is returned.\n\nThis BIF is always to be used for hashing terms. It distributes small integers\nbetter than [`phash/2`](`phash/2`), and it is faster for bignums and binaries.\n\nNotice that the range `0..Range-1` is different from the range of\n[`phash/2`](`phash/2`), which is `1..Range`.","ref":"erlang.html#phash2/2"},{"type":"function","title":"erlang.phash/2","doc":"> #### Warning {: .warning }\n>\n> This function is deprecated as [`erlang:phash2/2`](`phash2/2`) should be used\n> for new code. Note that `erlang:phash(X,N)` is not necessary equal to\n> `erlang:phash2(X,N)`\n\nPortable hash function that gives the same hash for the same Erlang term\nregardless of machine architecture and ERTS version (the BIF was introduced in\nERTS 4.9.1.1). The function returns a hash value for `Term` within the range\n`1..Range`. The maximum value for `Range` is 2^32.","ref":"erlang.html#phash/2"},{"type":"type","title":"erlang.pid/0","doc":"An Erlang [process identifier](`e:system:data_types.md#pid`).","ref":"erlang.html#t:pid/0"},{"type":"function","title":"erlang.pid_to_list/1","doc":"Returns a string corresponding to the text representation of `Pid`.\n\nFor example:\n\n```erlang\n> erlang:pid_to_list(self()).\n\"<0.85.0>\"\n```\n\n> #### Note {: .info }\n>\n> The [creation](erl_dist_protocol.md) for the node is not included in the list\n> representation of `Pid`. This means that processes in different incarnations\n> of a node with a specific name can get the same list representation.","ref":"erlang.html#pid_to_list/1"},{"type":"type","title":"erlang.port/0","doc":"An Erlang [port identifier](`e:system:data_types.md#port-identifier`).","ref":"erlang.html#t:port/0"},{"type":"function","title":"erlang.port_call/3","doc":"Performs a synchronous call to a port. The meaning of `Operation` and `Data`\ndepends on the port, that is, on the port driver. Not all port drivers support\nthis feature.\n\n`Port` is a port identifier, referring to a driver.\n\n`Operation` is an integer, which is passed on to the driver.\n\n`Data` is any Erlang term. This data is converted to binary term format and sent\nto the port.\n\nReturns a term from the driver. The meaning of the returned data also depends on\nthe port driver.\n\nFailures:\n\n- **`badarg`** - If `Port` is not an identifier of an open port, or the\n  registered name of an open port. If the calling process was previously linked\n  to the closed port, identified by `Port`, the exit signal from the port is\n  guaranteed to be delivered before this `badarg` exception occurs.\n\n- **`badarg`** - If `Operation` does not fit in a 32-bit integer.\n\n- **`badarg`** - If the port driver does not support synchronous control\n  operations.\n\n- **`badarg`** - If the port driver so decides for any reason (probably\n  something wrong with `Operation` or `Data`).\n\n  > #### Warning {: .warning }\n  >\n  > Do not call `port_call` with an unknown `Port` identifier and expect\n  > `badarg` exception. Any undefined behavior is possible (including node\n  > crash) depending on how the port driver interprets the supplied arguments.","ref":"erlang.html#port_call/3"},{"type":"function","title":"erlang.port_close/1","doc":"Closes an open port. Roughly the same as `Port ! {self(), close}` except for the\nerror behavior (see below), being synchronous, and that the port does _not_\nreply with `{Port, closed}`.\n\nAny process can close a port with [`port_close/1`](`port_close/1`), not only the\nport owner (the connected process). If the calling process is linked to the port\nidentified by `Port`, the exit signal from the port is guaranteed to be delivered before\n[`port_close/1`](`port_close/1`) returns.\n\nFor comparison: `Port ! {self(), close}` only fails with `badarg` if `Port` does\nnot refer to a port or a process. If `Port` is a closed port, nothing happens.\nIf `Port` is an open port and the calling process is the port owner, the port\nreplies with `{Port, closed}` when all buffers have been flushed and the port\nreally closes. If the calling process is not the port owner, the _port owner_\nfails with `badsig`.\n\nNotice that any process can close a port using `Port ! {PortOwner, close}` as if\nit itself was the port owner, but the reply always goes to the port owner.\n\nAs from Erlang/OTP R16, `Port ! {PortOwner, close}` is truly asynchronous.\nNotice that this operation has always been documented as an asynchronous\noperation, while the underlying implementation has been synchronous.\n[`port_close/1`](`port_close/1`) is however still fully synchronous because of\nits error behavior.\n\nFailure: `badarg` if `Port` is not an identifier of an open port, or the\nregistered name of an open port. If the calling process was previously linked to\nthe closed port, identified by `Port`, the exit signal from the port is\nguaranteed to be delivered before this `badarg` exception occurs.","ref":"erlang.html#port_close/1"},{"type":"function","title":"erlang.port_command/2","doc":"Sends data to a port. Same as `Port ! {PortOwner, {command, Data}}` except for\nthe error behavior and being synchronous (see below).\n\nAny process can send data to a port with [`port_command/2`](`port_command/2`),\nnot only the port owner (the connected process).\n\nFor comparison: `Port ! {PortOwner, {command, Data}}` only fails with `badarg`\nif `Port` does not refer to a port or a process. If `Port` is a closed port, the\ndata message disappears without a sound. If `Port` is open and the calling\nprocess is not the port owner, the _port owner_ fails with `badsig`. The port\nowner fails with `badsig` also if `Data` is an invalid I/O list.\n\nNotice that any process can send to a port using\n`Port ! {PortOwner, {command, Data}}` as if it itself was the port owner.\n\nIf the port is busy, the calling process is suspended until the port is not busy\nany more.\n\nAs from Erlang/OTP R16, `Port ! {PortOwner, {command, Data}}` is truly\nasynchronous. Notice that this operation has always been documented as an\nasynchronous operation, while the underlying implementation has been\nsynchronous. [`port_command/2`](`port_command/2`) is however still fully\nsynchronous because of its error behavior.\n\nFailures:\n\n- **`badarg`** - If `Port` is not an identifier of an open port, or the\n  registered name of an open port. If the calling process was previously linked\n  to the closed port, identified by `Port`, the exit signal from the port is\n  guaranteed to be delivered before this `badarg` exception occurs.\n\n- **`badarg`** - If `Data` is an invalid I/O list.\n\n> #### Warning {: .warning }\n>\n> Do not send data to an unknown port. Any undefined behavior is possible\n> (including node crash) depending on how the port driver interprets the data.","ref":"erlang.html#port_command/2"},{"type":"function","title":"erlang.port_command/3","doc":"Sends data to a port. [`port_command(Port, Data, [])`](`port_command/3`) equals\n[`port_command(Port, Data)`](`port_command/2`).\n\nIf the port command is aborted, `false` is returned, otherwise `true`.\n\nIf the port is busy, the calling process is suspended until the port is not busy\nanymore.\n\n`Option`s:\n\n- **`force`** - The calling process is not suspended if the port is busy,\n  instead the port command is forced through. The call fails with a `notsup`\n  exception if the driver of the port does not support this. For more\n  information, see driver flag\n  [`ERL_DRV_FLAG_SOFT_BUSY`](driver_entry.md#driver_flags).\n\n- **`nosuspend`** - The calling process is not suspended if the port is busy,\n  instead the port command is aborted and `false` is returned.\n\n> #### Change {: .info }\n>\n> More options can be added in a future release.\n\nFailures:\n\n- **`badarg`** - If `Port` is not an identifier of an open port, or the\n  registered name of an open port. If the calling process was previously linked\n  to the closed port, identified by `Port`, the exit signal from the port is\n  guaranteed to be delivered before this `badarg` exception occurs.\n\n- **`badarg`** - If `Data` is an invalid I/O list.\n\n- **`badarg`** - If `OptionList` is an invalid option list.\n\n- **`notsup`** - If option `force` has been passed, but the driver of the port\n  does not allow forcing through a busy port.\n\n> #### Warning {: .warning }\n>\n> Do not send data to an unknown port. Any undefined behavior is possible\n> (including node crash) depending on how the port driver interprets the data.","ref":"erlang.html#port_command/3"},{"type":"function","title":"erlang.port_connect/2","doc":"Sets the port owner (the connected port) to `Pid`. Roughly the same as\n`Port ! {Owner, {connect, Pid}}` except for the following:\n\n- The error behavior differs, see below.\n- The port does _not_ reply with `{Port,connected}`.\n- `port_connect/1` is synchronous, see below.\n- The new port owner gets linked to the port.\n\nThe old port owner stays linked to the port and must call\n[`unlink(Port)`](`unlink/1`) if this is not desired. Any process can set the\nport owner to be any process with [`port_connect/2`](`port_connect/2`).\n\nFor comparison: `Port ! {self(), {connect, Pid}}` only fails with `badarg` if\n`Port` does not refer to a port or a process. If `Port` is a closed port,\nnothing happens. If `Port` is an open port and the calling process is the port\nowner, the port replies with `{Port, connected}` to the old port owner. Notice\nthat the old port owner is still linked to the port, while the new is not. If\n`Port` is an open port and the calling process is not the port owner, the _port\nowner_ fails with `badsig`. The port owner fails with `badsig` also if `Pid` is\nnot an existing local process identifier.\n\nNotice that any process can set the port owner using\n`Port ! {PortOwner, {connect, Pid}}` as if it itself was the port owner, but the\nreply always goes to the port owner.\n\nAs from Erlang/OTP R16, `Port ! {PortOwner, {connect, Pid}}` is truly\nasynchronous. Notice that this operation has always been documented as an\nasynchronous operation, while the underlying implementation has been\nsynchronous. [`port_connect/2`](`port_connect/2`) is however still fully\nsynchronous because of its error behavior.\n\nFailures:\n\n- **`badarg`** - If `Port` is not an identifier of an open port, or the\n  registered name of an open port. If the calling process was previously linked\n  to the closed port, identified by `Port`, the exit signal from the port is\n  guaranteed to be delivered before this `badarg` exception occurs.\n\n- **`badarg`** - If the process identified by `Pid` is not an existing local\n  process.","ref":"erlang.html#port_connect/2"},{"type":"function","title":"erlang.port_control/3","doc":"Performs a synchronous control operation on a port. The meaning of `Operation`\nand `Data` depends on the port, that is, on the port driver. Not all port\ndrivers support this control feature.\n\nReturns a list of integers in the range 0..255, or a binary, depending on the\nport driver. The meaning of the returned data also depends on the port driver.\n\nFailures:\n\n- **`badarg`** - If `Port` is not an open port or the registered name of an open\n  port.\n\n- **`badarg`** - If `Operation` cannot fit in a 32-bit integer.\n\n- **`badarg`** - If the port driver does not support synchronous control\n  operations.\n\n- **`badarg`** - If the port driver so decides for any reason (probably\n  something wrong with `Operation` or `Data`).\n  > #### Warning {: .warning }\n  >\n  > Do not call [`port_control/3`](`port_control/3`) with an unknown `Port`\n  > identifier and expect `badarg` exception. Any undefined behavior is possible\n  > (including node crash) depending on how the port driver interprets the\n  > supplied arguments.","ref":"erlang.html#port_control/3"},{"type":"function","title":"erlang.port_info/1","doc":"Returns a list containing tuples with information about `Port`, or `undefined`\nif the port is not open.\n\nThe order of the tuples is undefined, and all the tuples are not mandatory.\nIf the port is closed and the calling process was\npreviously linked to the port, the exit signal from the port is guaranteed to be\ndelivered before [`port_info/1`](`port_info/1`) returns `undefined`.\n\nThe result contains information about the following `Item`s:\n\n- `registered_name` (if the port has a registered name)\n- `id`\n- `connected`\n- `links`\n- `name`\n- `input`\n- `output`\n\nFor more information about the different `Item`s, see `port_info/2`.\n\nFailure: `badarg` if `Port` is not a local port identifier, or an atom.","ref":"erlang.html#port_info/1"},{"type":"function","title":"erlang.port_info/2","doc":"Returns information about `Port`.\n\nIf the port identified by `Port` is not open, `undefined` is returned. If the port is closed and the calling process was previously linked to the port, the exit signal from the port is guaranteed to be delivered before `port_info/2` returns `undefined`.\n\n`Item` is one of the following and can be used to get various information about the `Port`.\n\n- `connected` - returns `{connected, Pid}` where `Pid` is the process identifier of the process connected to the port.\n- `id` - returns `{id, Index}` where `Index` is the internal index of the port. This index can be used to separate ports.\n- `input` - returns `{input, Bytes}` where `Bytes` is the total number of bytes read from the port.\n- `links` - returns `{links, Pids}` where `Pids` is a list of the process identifiers of the processes that the port is linked to.\n- `locking` - returns `{locking, Locking}` where `Locking` is one of the following:\n  * `port_level` (port-specific locking)\n  * `driver_level` (driver-specific locking)\n  Notice that these results are highly implementation-specific and can change in a future release.\n  \n  Since: OTP R16B\n- `memory` {: #port_info_memory } - returns `{memory, Bytes}` where `Bytes` is the total number of bytes allocated for this port by the runtime system. The port itself can have allocated memory that is not included in `Bytes`.\n  \n  Since: OTP R16B\n- `monitors` - returns `{monitors, Monitors}` where `Monitors` represent processes monitored by this port.\n  \n  Since: OTP R16B\n- `monitored_by` - returns `{monitored_by, MonitoredBy}` where `MonitoredBy` is a list of pids that are monitoring given port at the moment.\n  \n  Since: OTP 19.0\n- `name` - returns `{name, Name}` where `Name` is the command name set by `open_port/2`.\n- `os_pid` - returns `{os_pid, OsPid}` where `OsPid` is the process identifier (or equivalent) of an OS process created with [`open_port({spawn | spawn_executable, Command}, Options)`](`open_port/2`). If the port is not the result of spawning an OS process, the value is `undefined`.\n  \n  Since: OTP R16B\n- `output` - returns `{output, Bytes}` where `Bytes` is the total number of bytes written to the port from Erlang processes using `port_command/2`, `port_command/3`, or `Port ! {Owner, {command, Data}`.\n- `parallelism` - returns `{parallelism, Boolean}` where `Boolean` corresponds to the port parallelism hint used by this port. For more information, see option [`parallelism`](`m:erlang#open_port_parallelism`) of `open_port/2`.\n  \n  Since: OTP R16B\n- `queue_size` - returns `{queue_size, Bytes}` where `Bytes` is the total number of bytes queued by the port using the ERTS driver queue implementation.\n  \n  Since: OTP R16B\n- `registered_name` - returns `{registered_name, RegisteredName}` where `RegisteredName` is the registered name of the port. If the port has no registered name, `[]` is returned.\n\nFailure: `badarg` if `Port` is not a local port identifier, or an atom.","ref":"erlang.html#port_info/2"},{"type":"function","title":"erlang.port_to_list/1","doc":"Returns a string corresponding to the text representation of the port identifier\n`Port`.","ref":"erlang.html#port_to_list/1"},{"type":"function","title":"erlang.ports/0","doc":"Returns a list of port identifiers corresponding to all the ports existing on\nthe local node.\n\nNotice that an exiting port exists, but is not open.","ref":"erlang.html#ports/0"},{"type":"type","title":"erlang.pos_integer/0","doc":"An integer greater than zero.","ref":"erlang.html#t:pos_integer/0"},{"type":"function","title":"erlang.pre_loaded/0","doc":"Returns a list of Erlang modules that are preloaded in the run-time system.\n\nPre-loaded modules are Erlang modules that are needed to bootstrap the system to\nload the first Erlang modules from either disk or by using `m:erl_boot_server`.","ref":"erlang.html#pre_loaded/0"},{"type":"opaque","title":"erlang.prepared_code/0","doc":"","ref":"erlang.html#t:prepared_code/0"},{"type":"type","title":"erlang.priority_level/0","doc":"Process priority level. For more info see\n[`process_flag(priority, Level)`](#process_flag_priority)","ref":"erlang.html#t:priority_level/0"},{"type":"function","title":"erlang.process_display/2","doc":"Writes information about the local process `Pid` on [standard error](`t:io:standard_error/0`).\n\nThe only allowed value for the atom `Type` is `backtrace`, which shows the contents of\nthe call stack, including information about the call chain, with the current\nfunction printed first. The format of the output is not further defined.","ref":"erlang.html#process_display/2"},{"type":"function","title":"erlang.process_flag/2","doc":"Sets the process flag indicated to the specified value. Returns the previous value\nof the flag.\n\n`Flag` is one of the following:\n\n- ```erlang\n  process_flag(async_dist, boolean())\n  ```\n  {: #process_flag_async_dist }\n  \n  Enable or disable _fully asynchronous distributed signaling_ for the calling\n  process. When disabled, which is the default, the process sending a distributed\n  signal will block in the send operation if the buffer for the distribution\n  channel reach the [distribution buffer busy limit](erl_cmd.md#%2Bzdbbl). The\n  process will remain blocked until the buffer shrinks enough. This might in some\n  cases take a substantial amount of time. When `async_dist` is enabled, send\n  operations of distributed signals will always buffer the signal on the outgoing\n  distribution channel and then immediately return. That is, these send operations\n  will _never_ block the sending process.\n  \n  > #### Note {: .info }\n  >\n  > Since no flow control is enforced by the runtime system when `async_dist`\n  > process flag is enabled, you need to make sure that flow control for such data\n  > is implemented, or that the amount of such data is known to always be limited.\n  > Unlimited signaling with `async_dist` enabled in the absence of flow control\n  > will typically cause the sending runtime system to crash on an out of memory\n  > condition.\n  \n  Blocking due to disabled `async_dist` can be monitored by\n  [`erlang:system_monitor()`](`system_monitor/2`) using the\n  [`busy_dist_port`](#busy_dist_port) option. Only data buffered by\n  processes which (at the time of sending a signal) have disabled `async_dist`\n  will be counted when determining whether or not an operation should block the\n  caller.\n  \n  The `async_dist` flag can also be set on a new process when spawning it using\n  the [`spawn_opt()`](`spawn_opt/4`) BIF with the option\n  [`{async_dist, Enable}`](#spawn_opt_async_dist). The default\n  `async_dist` flag to use on newly spawned processes can be set by passing the\n  command line argument [`+pad  `](erl_cmd.md#%2Bpad) when starting the\n  runtime system. If the `+pad  ` command line argument is not passed, the\n  default value of the `async_dist` flag will be `false`.\n  \n  You can inspect the state of the `async_dist` process flag of a process by\n  calling [`process_info(Pid, async_dist)`](#process_info_async_dist).\n  \n- ```erlang\n  process_flag(trap_exit, boolean())\n  ```\n  {: #process_flag_trap_exit }\n  \n  When `trap_exit` is set to `true`, exit signals arriving to a process are\n  converted to `{'EXIT', From, Reason}` messages, which can be received as\n  ordinary messages. If `trap_exit` is set to `false`, the process exits if it\n  receives an exit signal other than `normal` and the exit signal is propagated to\n  its linked processes. Application processes are normally not to trap exits.\n  \n  See also `exit/2`.\n  \n- ```erlang\n  process_flag(error_handler, module())\n  ```\n  {: #process_flag_error_handler }\n  \n  Used by a process to redefine the `m:error_handler` for undefined function calls and\n  undefined registered processes. Use this flag with substantial caution, as code\n  auto-loading depends on the correct operation of the error handling module.\n  \n- ```erlang\n  process_flag(fullsweep_after,  non_neg_integer())\n  ```\n  \n  Changes the maximum number of generational collections before forcing a\n  fullsweep for the calling process.\n  \n- ```erlang\n  process_flag(min_heap_size, non_neg_integer())\n  ```\n  {: #process_flag_min_heap_size }\n  \n  Changes the minimum heap size for the calling process.\n  \n- ```erlang\n  process_flag(min_bin_vheap_size, non_neg_integer())\n  ```\n  \n  Changes the minimum binary virtual heap size for the calling process.\n  \n- ```erlang\n  process_flag(max_heap_size, max_heap_size())\n  ```\n  {: #process_flag_max_heap_size }\n  \n  This flag sets the maximum heap size for the calling process. If `MaxHeapSize`\n  is an integer, the system default values for `kill` and `error_logger` are used.\n  \n  For details on how the heap grows, see\n  [Sizing the heap](GarbageCollection.md#sizing-the-heap) in the ERTS internal\n  documentation.\n  \n  - **`size`** - The maximum size in words of the process. If set to zero, the\n    heap size limit is disabled. `badarg` is be thrown if the value is smaller\n    than [`min_heap_size`](#process_flag_min_heap_size). The size check\n    is only done when a garbage collection is triggered.\n  \n    `size` is the entire heap of the process when garbage collection is triggered.\n    This includes all generational heaps, the process stack, any\n    [messages that are considered to be part of the heap](#process_flag_message_queue_data),\n    and any extra memory that the garbage collector needs during collection.\n  \n    `size` is the same as can be retrieved using\n    [`erlang:process_info(Pid, total_heap_size)`](#process_info_total_heap_size),\n    or by adding `heap_block_size`, `old_heap_block_size` and `mbuf_size` from\n    [`erlang:process_info(Pid, garbage_collection_info)`](#process_info_garbage_collection_info).\n  \n  - **`kill`** - When set to `true`, the runtime system sends an untrappable exit\n    signal with reason `kill` to the process if the maximum heap size is reached.\n    The garbage collection that triggered the `kill` is not completed, instead the\n    process exits as soon as possible. When set to `false`, no exit signal is sent\n    to the process, instead it continues executing.\n  \n    If `kill` is not defined in the map, the system default will be used. The\n    default system default is `true`. It can be changed by either option\n    [\\+hmaxk](erl_cmd.md#%2Bhmaxk) in [erl](erl_cmd.md), or\n    [`erlang:system_flag(max_heap_size, MaxHeapSize)`](#system_flag_max_heap_size).\n  \n  - **`error_logger`** - When set to `true`, the runtime system logs an error\n    event via `m:logger`, containing details about the process when the maximum\n    heap size is reached. One log event is sent each time the limit is reached.\n  \n    If `error_logger` is not defined in the map, the system default is used. The\n    default system default is `true`. It can be changed by either the option\n    [\\+hmaxel](erl_cmd.md#%2Bhmaxel) int [erl](erl_cmd.md), or\n    [`erlang:system_flag(max_heap_size, MaxHeapSize)`](#system_flag_max_heap_size).\n  \n  - **`include_shared_binaries`** - When set to `true`, off-heap binaries are\n    included in the total sum compared against the `size` limit. Off-heap binaries\n    are typically larger binaries that may be shared between processes. The size\n    of a shared binary is included by all processes that are referring it. Also,\n    the entire size of a large binary may be included even if only a smaller part\n    of it is referred by the process.\n  \n    If `include_shared_binaries` is not defined in the map, the system default is\n    used. The default system default is `false`. It can be changed by either the\n    option [\\+hmaxib](erl_cmd.md#%2Bhmaxib) in [erl](erl_cmd.md), or\n    [`erlang:system_flag(max_heap_size, MaxHeapSize)`](#system_flag_max_heap_size).\n  \n  The heap size of a process is quite hard to predict, especially the amount of\n  memory that is used during the garbage collection. When contemplating using this\n  option, it is recommended to first run it in production with `kill` set to\n  `false` and inspect the log events to see what the normal peak sizes of the\n  processes in the system is and then tune the value accordingly.\n  \n- ```erlang\n  process_flag(message_queue_data, message_queue_data())\n  ```\n  {: #process_flag_message_queue_data }\n  \n  Determines how messages in the message queue are stored, as follows:\n  \n  - **`off_heap`** - _All_ messages in the message queue will be stored outside\n    the process heap. This implies that _no_ messages in the message queue will be\n    part of a garbage collection of the process.\n  \n  - **`on_heap`** - All messages in the message queue will eventually be placed on\n    the process heap. They can, however, be temporarily stored off the heap. This\n    is how messages have always been stored up until ERTS 8.0.\n  \n  The default value of the `message_queue_data` process flag is determined by the\n  command-line argument [`+hmqd`](erl_cmd.md#%2Bhmqd) in [erl](erl_cmd.md).\n  \n  If the process may potentially accumulate a large number of messages in its\n  queue it is recommended to set the flag value to `off_heap`. This is due to the\n  fact that the garbage collection of a process that has a large number of\n  messages stored on the heap can become extremely expensive and the process can\n  consume large amounts of memory. The performance of the actual message passing\n  is, however, generally better when the flag value is `on_heap`.\n  \n  Changing the flag value causes any existing messages to be moved. The move\n  operation is initiated, but not necessarily completed, by the time the function\n  returns.\n  \n- ```erlang\n  process_flag(priority, priority_level())\n  ```\n  {: #process_flag_priority }\n  \n  Sets the process priority. `Level` is an atom. Four priority levels exist:\n  `low`, `normal`, `high`, and `max`. Default is `normal`.\n  \n  > #### Note {: .info }\n  >\n  > Priority level `max` is reserved for internal use in the Erlang runtime\n  > system, and is _not_ to be used by others.\n  \n  Internally in each priority level, processes are scheduled in a round robin\n  fashion.\n  \n  Execution of processes on priority `normal` and `low` are interleaved. Processes\n  on priority `low` are selected for execution less frequently than processes on\n  priority `normal`.\n  \n  When runnable processes on priority `high` exist, no processes on priority `low`\n  or `normal` are selected for execution. Notice however that this does _not_ mean\n  that no processes on priority `low` or `normal` can run when processes are\n  running on priority `high`. When using multiple schedulers, more processes can\n  be running in parallel than processes on priority `high`. That is, a `low` and a\n  `high` priority process can execute at the same time.\n  \n  When runnable processes on priority `max` exist, no processes on priority `low`,\n  `normal`, or `high` are selected for execution. As with priority `high`,\n  processes on lower priorities can execute in parallel with processes on priority\n  `max`.\n  \n  Scheduling is pre-emptive. Regardless of priority, a process is pre-empted when\n  it has consumed more than a certain number of reductions since the last time it\n  was selected for execution.\n  \n  > #### Note {: .info }\n  >\n  > Do not depend on the scheduling to remain exactly as it is today. Scheduling\n  > is likely to be changed in a future release to use available processor cores\n  > better.\n  \n  There is _no_ automatic mechanism for avoiding priority inversion, such as\n  priority inheritance or priority ceilings. When using priorities, take this into\n  account and handle such scenarios by yourself.\n  \n  Making calls from a `high` priority process into code that you has no control\n  over can cause the `high` priority process to wait for a process with lower\n  priority. That is, effectively decreasing the priority of the `high` priority\n  process during the call. Even if this is not the case with one version of the\n  code that you have no control over, it can be the case in a future version of\n  it. This can, for example, occur if a `high` priority process triggers code\n  loading, as the code server runs on priority `normal`.\n  \n  Other priorities than `normal` are normally not needed. When other priorities\n  are used, use them with care, _especially_ priority `high`. A process on\n  priority `high` is only to perform work for short periods. Busy looping for long\n  periods in a `high` priority process causes most likely problems, as important\n  OTP servers run on priority `normal`.\n  \n- ```erlang\n  process_flag(save_calls, 0..10000)\n  ```\n  \n  `N` must be an integer in the interval 0..10000. If `N` > 0, call saving is made\n  active for the process. This means that information about the `N` most recent\n  global function calls, BIF calls, sends, and receives made by the process are\n  saved in a list, which can be retrieved with\n  [`process_info(Pid, last_calls)`](`process_info/2`). A global function call is\n  one in which the module of the function is explicitly mentioned. Only a fixed\n  amount of information is saved, as follows:\n  \n  - A tuple `{Module, Function, Arity}` for function calls\n  - The atoms `send`, `'receive'`, and `timeout` for sends and receives\n    (`'receive'` when a message is received and `timeout` when a receive times\n    out)\n  \n  If `N` = 0, call saving is disabled for the process, which is the default.\n  Whenever the size of the call saving list is set, its contents are reset.\n  \n- ```erlang\n  process_flag(sensitive, boolean())\n  ```\n  \n  Sets or clears flag `sensitive` for the current process. When a process has been\n  marked as sensitive by calling\n  [`process_flag(sensitive, true)`](`process_flag/2`), features in the runtime\n  system that can be used for examining the data or inner working of the process\n  are silently disabled.\n  \n  Features that are disabled include (but are not limited to) the following:\n  \n  - Tracing. Trace flags can still be set for the process, but no trace messages\n    of any kind are generated. (If flag `sensitive` is turned off, trace messages\n    are again generated if any trace flags are set.)\n  - Sequential tracing. The sequential trace token is propagated as usual, but no\n    sequential trace messages are generated.\n  \n  `process_info/1,2` cannot be used to read out the message queue or the process\n  dictionary (both are returned as empty lists).\n  \n  Stack back-traces cannot be displayed for the process.\n  \n  In crash dumps, the stack, messages, and the process dictionary are omitted.\n  \n  If `{save_calls,N}` has been set for the process, no function calls are saved to\n  the call saving list. (The call saving list is not cleared. Also, send, receive,\n  and time-out events are still added to the list.)","ref":"erlang.html#process_flag/2"},{"type":"function","title":"erlang.process_flag/3","doc":"Sets certain flags for the process `Pid`, in the same manner as\n`process_flag/2`. Returns the old value of the flag. The valid values for `Flag`\nare only a subset of those allowed in [`process_flag/2`](`process_flag/2`),\nnamely `save_calls`.\n\nFailure: `badarg` if `Pid` is not a local process.","ref":"erlang.html#process_flag/3"},{"type":"function","title":"erlang.process_info/1","doc":"Returns a list containing `InfoTuple`s with miscellaneous information about the\nprocess identified by `Pid`, or `undefined` if the process is not alive.\n\nThe order of the `InfoTuple`s is undefined and all `InfoTuple`s are not\nmandatory. The `InfoTuple`s part of the result can be changed without prior\nnotice.\n\nThe `InfoTuple`s with the following items are part of the result:\n\n- `current_function`\n- `initial_call`\n- `status`\n- `message_queue_len`\n- `links`\n- `dictionary`\n- `trap_exit`\n- `error_handler`\n- `priority`\n- `group_leader`\n- `total_heap_size`\n- `heap_size`\n- `stack_size`\n- `reductions`\n- `garbage_collection`\n\nIf the process identified by `Pid` has a registered name, also an `InfoTuple`\nwith item `registered_name` is included.\n\nFor information about specific `InfoTuple`s, see `process_info/2`.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for _debugging only_. For all other purposes, use\n> `process_info/2`.\n\nFailure: `badarg` if `Pid` is not a local process.","ref":"erlang.html#process_info/1"},{"type":"function","title":"erlang.process_info/2","doc":"Returns information about the process identified by `Pid`, as specified by\n`Item` or `ItemList`. Returns `undefined` if the process is not alive.\n\nIf the process is alive and a single `Item` is specified, the returned value is\nthe corresponding `InfoTuple`, unless `Item =:= registered_name` and the process\nhas no registered name. In this case, `[]` is returned. This strange behavior is\nbecause of historical reasons, and is kept for backward compatibility.\n\nIf `ItemList` is specified, the result is `InfoTupleList`. The `InfoTuple`s in\n`InfoTupleList` are included with the corresponding `Item`s in the same order as\nthe `Item`s were included in `ItemList`. Valid `Item`s can be included multiple\ntimes in `ItemList`.\n\nGetting process information follows the signal ordering guarantees described in\nthe [Processes Chapter](`e:system:ref_man_processes.md#signals`) in the _Erlang\nReference Manual_.\n\n> #### Note {: .info }\n>\n> If `registered_name` is part of `ItemList` and the process has no name\n> registered, a `{registered_name, []}`, `InfoTuple` _will_ be included in the\n> resulting `InfoTupleList`. This behavior is different when a single\n> `Item =:= registered_name` is specified, and when\n> [`process_info/1`](`process_info/1`) is used.\n\nValid `InfoTuple`s with corresponding `Item`s:\n\n- **`{async_dist, Enabled}`{: #process_info_async_dist }** - Since: OTP 25.3\n\n  Current value of the [`async_dist`](#process_flag_async_dist)\n  process flag.\n\n- **`{backtrace, Bin}`** - Binary `Bin` contains the same information as the\n  output from `erlang:process_display(Pid, backtrace)`. Use\n  [`binary_to_list/1`](`binary_to_list/1`) to obtain the string of characters\n  from the binary.\n\n- **`{binary, BinInfo}`** - `BinInfo` is a list containing miscellaneous\n  information about binaries on the heap of this process. This `InfoTuple` can\n  be changed or removed without prior notice. In the current implementation\n  `BinInfo` is a list of tuples. The tuples contain; `BinaryId`, `BinarySize`,\n  `BinaryRefcCount`.\n\n  Depending on the value of the\n  [`message_queue_data`](#process_flag_message_queue_data) process\n  flag the message queue may be stored on the heap.\n\n- **`{catchlevel, CatchLevel}`** - `CatchLevel` is the number of currently\n  active catches in this process. This `InfoTuple` can be changed or removed\n  without prior notice.\n\n- **`{current_function, {Module, Function, Arity} | undefined}`** - `Module`,\n  `Function`, `Arity` is the current function call of the process. The value\n  `undefined` can be returned if the process is currently executing native\n  compiled code.\n\n- **`{current_location, {Module, Function, Arity, Location}}`** - `Module`,\n  `Function`, `Arity` is the current function call of the process. `Location` is\n  a list of two-tuples describing the location in the source code.\n\n- **`{current_stacktrace, Stack}`**{: #process_info_current_stacktrace } -\n  Returns the current call stack back-trace\n  (_stacktrace_) of the process. The stack has the same format as in the `catch`\n  part of a `try`. See\n  [The call-stack back trace (stacktrace)](`e:system:errors.md#stacktrace`). The\n  depth of the stacktrace is truncated according to the `backtrace_depth` system\n  flag setting.\n\n- **`{dictionary, Dictionary}`** - `Dictionary` is the process dictionary.\n\n- **`{{dictionary, Key}, Value}`** - `Value` associated with `Key` in the\n  process dictionary.\n\n- **`{error_handler, Module}`** - `Module` is the `m:error_handler` module used by\n  the process (for undefined function calls, for example).\n\n- **`{garbage_collection, GCInfo}`** - `GCInfo` is a list containing\n  miscellaneous information about garbage collection for this process. The\n  content of `GCInfo` can be changed without prior notice.\n\n- **`{garbage_collection_info, GCInfo}`{: #process_info_garbage_collection_info }** -\n  `GCInfo` is a list containing miscellaneous detailed information about\n  garbage collection for this process. The content of `GCInfo` can be changed\n  without prior notice. For details about the meaning of each item, see\n  [`gc_minor_start`](`m:trace#gc_minor_start`) in `trace:process/4`.\n\n- **`{group_leader, GroupLeader}`** - `GroupLeader` is the group leader for the\n  I/O of the process.\n\n- **`{heap_size, Size}`** - `Size` is the size in words of the youngest heap\n  generation of the process. This generation includes the process stack. This\n  information is highly implementation-dependent, and can change if the\n  implementation changes.\n\n- **`{initial_call, {Module, Function, Arity}}`** - `Module`, `Function`,\n  `Arity` is the initial function call with which the process was spawned.\n\n- **`{links, PidsAndPorts}`** - `PidsAndPorts` is a list of process identifiers\n  and port identifiers, with processes or ports to which the process has a link.\n\n- **`{label, Label}`** -\n  `Label` is the label for the process. See `proc_lib:get_label/1`.\n\n   Since: OTP 27.2\n\n- **`{last_calls, false|Calls}`** - The value is `false` if call saving is not\n  active for the process (see `process_flag/3`). If call saving is active, a\n  list is returned, in which the last element is the most recent called.\n\n- **`{memory, Size}`** - [](){: #process_info_memory } `Size` is the size in\n  bytes of the process. This includes call stack, heap, and internal structures.\n\n- **`{message_queue_len, MessageQueueLen}`** - `MessageQueueLen` is the number\n  of messages currently in the message queue of the process. This is the length\n  of the list `MessageQueue` returned as the information item `messages` (see\n  below).\n\n- **`{messages, MessageQueue}`** - `MessageQueue` is a list of the messages to\n  the process, which have not yet been processed.\n\n- **`{min_heap_size, MinHeapSize}`** - `MinHeapSize` is the minimum heap size\n  for the process.\n\n- **`{min_bin_vheap_size, MinBinVHeapSize}`** - `MinBinVHeapSize` is the minimum\n  binary virtual heap size for the process.\n\n- **`{monitored_by, MonitoredBy}`** - A list of identifiers for all the\n  processes, ports and NIF resources, that are monitoring the process.\n\n- **`{monitors, Monitors}`** - A list of monitors (started by\n  [`monitor/2`](`monitor/2`)) that are active for the process. For a local\n  process monitor or a remote process monitor by a process identifier, the list\n  consists of:\n\n  - **`{process, Pid}`** - Process is monitored by pid.\n\n  - **`{process, {RegName, Node}}`** - Local or remote process is monitored by\n    name.\n\n  - **`{port, PortId}`** - Local port is monitored by port id.\n\n  - **`{port, {RegName, Node}}`** - Local port is monitored by name. Please\n    note, that remote port monitors are not supported, so `Node` will always be\n    the local node name.\n\n- **`{message_queue_data, MQD}`** - `MQD` is the current value of the\n  `message_queue_data` process flag, which can be either `off_heap` or\n  `on_heap`. For more information, see the documentation of\n  [`process_flag(message_queue_data, MQD)`](#process_flag_message_queue_data).\n\n- **`{parent, Pid}`** - `Pid` is the identifier of the parent process, the one\n  that spawned current process. When the process does not have a parent\n  `undefined` is returned. Only the initial process (`init`) on a node lacks a\n  parent, though.\n\n- **`{priority, Level}`** - `Level` is the current priority level for the\n  process. For more information on priorities, see\n  [`process_flag(priority, Level)`](#process_flag_priority).\n\n- **`{reductions, Number}`** - `Number` is the number of reductions executed by\n  the process.\n\n- **`{registered_name, Atom}`** - `Atom` is the registered process name. If the\n  process has no registered name, this tuple is not present in the list.\n\n- **`{sequential_trace_token, [] | SequentialTraceToken}`** -\n  `SequentialTraceToken` is the sequential trace token for the process. This\n  `InfoTuple` can be changed or removed without prior notice.\n\n- **`{stack_size, Size}`** - `Size` is the stack size, in words, of the process.\n\n- **`{status, Status}`** - `Status` is the status of the process and is one of\n  the following:\n\n  - `exiting`\n  - `garbage_collecting`\n  - `waiting` (for a message)\n  - `running`\n  - `runnable` (ready to run, but another process is running)\n  - `suspended` (suspended on a \"busy\" port or by the BIF\n    `erlang:suspend_process/1,2`)\n\n- **`{suspending, SuspendeeList}`** - `SuspendeeList` is a list of\n  `{Suspendee, ActiveSuspendCount, OutstandingSuspendCount}` tuples. `Suspendee`\n  is the process identifier of a process that has been, or is to be, suspended\n  by the process identified by `Pid` through the BIF\n  [`erlang:suspend_process/2`](`suspend_process/2`) or\n  [`erlang:suspend_process/1`](`suspend_process/1`).\n\n  `ActiveSuspendCount` is the number of times `Suspendee` has been suspended by\n  `Pid`. `OutstandingSuspendCount` is the number of not yet completed suspend\n  requests sent by `Pid`, that is:\n\n  - If `ActiveSuspendCount =/= 0`, `Suspendee` is currently in the suspended\n    state.\n  - If `OutstandingSuspendCount =/= 0`, option `asynchronous` of\n    `erlang:suspend_process/2` has been used and the suspendee has not yet been\n    suspended by `Pid`.\n\n  Notice that `ActiveSuspendCount` and `OutstandingSuspendCount` are not the\n  total suspend count on `Suspendee`, only the parts contributed by `Pid`.\n\n- **`{total_heap_size, Size}`{: #process_info_total_heap_size }** - `Size` is\n  the total size, in words, of all heap fragments of the process. This includes\n  the process stack and any unreceived messages that are considered to be part\n  of the heap.\n\n- **`{trace, InternalTraceFlags}`** - `InternalTraceFlags` is an integer\n  representing the internal trace flag for this process. This `InfoTuple` can be\n  changed or removed without prior notice.\n\n- **`{trap_exit, Boolean}`** - `Boolean` is `true` if the process is trapping\n  exits, otherwise `false`.\n\nNotice that not all implementations support all these `Item`s.\n\nFailures:\n\n- **`badarg`** - If `Pid` is not a local process.\n\n- **`badarg`** - If `Item` is an invalid item.","ref":"erlang.html#process_info/2"},{"type":"type","title":"erlang.process_info_item/0","doc":"","ref":"erlang.html#t:process_info_item/0"},{"type":"type","title":"erlang.process_info_result_item/0","doc":"","ref":"erlang.html#t:process_info_result_item/0"},{"type":"function","title":"erlang.processes/0","doc":"Returns a list of process identifiers corresponding to all the processes\ncurrently existing on the local node.\n\nNotice that an exiting process exists, but is not alive. That is,\n[`is_process_alive/1`](`is_process_alive/1`) returns `false` for an exiting\nprocess, but its process identifier is part of the result returned from\n`processes/0`.\n\nExample:\n\n```erlang\n> processes().\n[<0.0.0>,<0.2.0>,<0.4.0>,<0.5.0>,<0.7.0>,<0.8.0>]\n```","ref":"erlang.html#processes/0"},{"type":"function","title":"erlang.purge_module/1","doc":"Removes old code for `Module`. Before this BIF is used, `check_process_code/2`\nis to be called to check that no processes execute old code in the module.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for the code server (see `m:code`) and is not to be used\n> elsewhere.\n\n> #### Change {: .info }\n>\n> As from ERTS 8.0 (Erlang/OTP 19), any lingering processes that still execute\n> the old code is killed by this function. In earlier versions, such incorrect\n> use could cause much more fatal failures, like emulator crash.\n\nFailure: `badarg` if there is no old code for `Module`.","ref":"erlang.html#purge_module/1"},{"type":"function","title":"erlang.put/2","doc":"Adds a new `Key` to the process dictionary, associated with the value `Val`, and\nreturns `undefined`. If `Key` exists, the old value is deleted and replaced by\n`Val`, and the function returns the old value.\n\nThe average time complexity for the current implementation of this function is\nO(`1`) and the worst case time complexity is O(`N`), where `N` is the number of\nitems in the process dictionary.\n\nFor example:\n\n```erlang\n> X = put(name, walrus), Y = put(name, carpenter),\nZ = get(name),\n{X, Y, Z}.\n{undefined,walrus,carpenter}\n```\n\n> #### Note {: .info }\n>\n> The values stored when `put` is evaluated within the scope of a `catch` are\n> not retracted if a `throw` is evaluated, or if an error occurs.","ref":"erlang.html#put/2"},{"type":"function","title":"erlang.raise/3","doc":"Raises an exception of the specified class, reason, and call stack backtrace\n(_stacktrace_).\n\n`Class` is `error`, `exit`, or `throw`. So, if it were not for the stacktrace,\n`erlang:raise(Class, Reason, Stacktrace)` is equivalent to\n`erlang:Class(Reason)` (given that `Class` is a valid class).\n\n`Reason` can be any term.\n\n`Stacktrace` is a list as provided in a try-catch clause.\n\n```erlang\ntry\n    ...\ncatch Class:Reason:Stacktrace ->\n    ...\nend\n```\n\nThat is, a list of four-tuples `{Module, Function, Arity | Args, ExtraInfo}`,\nwhere `Module` and `Function` are atoms, and the third element is an integer\narity or an argument list. The stacktrace can also contain\n`{Fun, Args, ExtraInfo}` tuples, where `Fun` is a local fun and `Args` is an\nargument list.\n\nElement `ExtraInfo` at the end is optional. Omitting it is equivalent to\nspecifying an empty list.\n\nThe stacktrace is used as the exception stacktrace for the calling process; it\nis truncated to the current maximum stacktrace depth.\n\nAs evaluating this function causes the process to terminate, it has no return\nvalue unless the arguments are invalid, in which case the function _returns the\nerror reason_ `badarg`. If you want to be sure not to return, you can call\n[`error(erlang:raise(Class, Reason, Stacktrace))`](`error/1`) and hope to\ndistinguish exceptions later.\n\nSee the reference manual about [errors and error handling](`e:system:errors.md`)\nfor more information about exception classes and how to catch exceptions.","ref":"erlang.html#raise/3"},{"type":"type","title":"erlang.raise_stacktrace/0","doc":"A extended `t:stacktrace/0` that can be passed to `raise/3`.","ref":"erlang.html#t:raise_stacktrace/0"},{"type":"function","title":"erlang.read_timer/1","doc":"","ref":"erlang.html#read_timer/1"},{"type":"function","title":"erlang.read_timer/2","doc":"Reads the state of a timer that has been created by either\n[`erlang:start_timer`](`start_timer/4`) or\n[`erlang:send_after`](`send_after/4`). `TimerRef` identifies the timer, and was\nreturned by the BIF that created the timer.\n\n`Options`:\n\n- **`{async, Async}`** - Asynchronous request for state information. `Async`\n  defaults to `false`, which causes the operation to be performed synchronously.\n  In this case, the `Result` is returned by `erlang:read_timer`. When `Async` is\n  `true`, `erlang:read_timer` sends an asynchronous request for the state\n  information to the timer service that manages the timer, and then returns\n  `ok`. A message on the format `{read_timer, TimerRef, Result}` is sent to the\n  caller of `erlang:read_timer` when the operation has been processed.\n\nMore `Option`s can be added in the future.\n\nIf `Result` is an integer, it represents the time in milliseconds left until the\ntimer expires.\n\nIf `Result` is `false`, a timer corresponding to `TimerRef` could not be found.\nThis because the timer had expired, or been canceled, or because `TimerRef`\nnever has corresponded to a timer. Even if the timer has expired, it does not\ntell you whether or not the time-out message has arrived at its destination yet.\n\n> #### Note {: .info }\n>\n> The timer service that manages the timer can be co-located with another\n> scheduler than the scheduler that the calling process is executing on. If so,\n> communication with the timer service takes much longer time than if it is\n> located locally. If the calling process is in a critical path, and can do\n> other things while waiting for the result of this operation, you want to use\n> option `{async, true}`. If using option `{async, false}`, the calling process\n> is blocked until the operation has been performed.\n\nSee also [`erlang:send_after/4`](`send_after/4`),\n[`erlang:start_timer/4`](`start_timer/4`), and\n[`erlang:cancel_timer/2`](`cancel_timer/2`).","ref":"erlang.html#read_timer/2"},{"type":"function","title":"erlang.ref_to_list/1","doc":"Returns a string corresponding to the text representation of `Ref`.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging and is not to be used in application\n> programs.","ref":"erlang.html#ref_to_list/1"},{"type":"type","title":"erlang.reference/0","doc":"An Erlang [reference](`e:system:data_types.md#reference`).","ref":"erlang.html#t:reference/0"},{"type":"function","title":"erlang.register/2","doc":"Registers the name `RegName` with a process identifier (pid) or a port\nidentifier in the\n[`name registry`](`e:system:ref_man_processes.md#runtime-service`).\n`RegName`, which must be an atom, can be used instead of the pid or port\nidentifier in send operator (`RegName ! Message`) and most other BIFs that take\na pid or port identifies as an argument.\n\nFor example:\n\n```erlang\n> register(db, Pid).\ntrue\n```\n\nThe registered name is considered a\n[Directly Visible Erlang Resource](`e:system:ref_man_processes.md#visible-resources`)\nand is automatically unregistered when the process terminates.\n\nFailures:\n\n- **`badarg`** - If `PidOrPort` is not an existing local process or port.\n\n- **`badarg`** - If `RegName` is already in use.\n\n- **`badarg`** - If the process or port is already registered (already has a\n  name).\n\n- **`badarg`** - If `RegName` is the atom `undefined`.","ref":"erlang.html#register/2"},{"type":"function","title":"erlang.registered/0","doc":"Returns a list of names that have been registered using `register/2`.\n\nFor example:\n\n```erlang\n> registered().\n[code_server, file_server, init, user, my_db]\n```","ref":"erlang.html#registered/0"},{"type":"type","title":"erlang.registered_name/0","doc":"","ref":"erlang.html#t:registered_name/0"},{"type":"type","title":"erlang.registered_process_identifier/0","doc":"","ref":"erlang.html#t:registered_process_identifier/0"},{"type":"function","title":"erlang.resume_process/1","doc":"Decreases the suspend count on the process identified by `Suspendee`.\n\n`Suspendee` is previously to have been suspended through\n[`erlang:suspend_process/2`](`suspend_process/2`) or\n[`erlang:suspend_process/1`](`suspend_process/1`) by the process calling\n`erlang:resume_process(Suspendee)`. When the suspend count on `Suspendee`\nreaches zero, `Suspendee` is resumed, that is, its state is changed from\nsuspended into the state it had before it was suspended.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging only.\n\nFailures:\n\n- **`badarg`** - If `Suspendee` is not a process identifier.\n\n- **`badarg`** - If the process calling `erlang:resume_process/1` had not\n  previously increased the suspend count on the process identified by\n  `Suspendee`.\n\n- **`badarg`** - If the process identified by `Suspendee` is not alive.","ref":"erlang.html#resume_process/1"},{"type":"function","title":"erlang.round/1","doc":"Returns an integer by rounding `Number`.\n\nFor example:\n\n```erlang\nround(42.1).\n42\n```\n\n```erlang\nround(5.5).\n6\n```\n\n```erlang\nround(-5.5).\n-6\n```\n\n```erlang\nround(36028797018963969.0).\n36028797018963968\n```\n\nIn the last example, [`round(36028797018963969.0)`](`round/1`) evaluates to\n`36028797018963968`. The reason for this is that the number\n`36028797018963969.0` cannot be represented exactly as a float value. Instead,\nthe float literal is represented as `36028797018963968.0`, which is the closest\nnumber that can be represented exactly as a float value. See\n[Representation of Floating Point Numbers](`e:system:data_types.md#float_representation_problem`)\nfor additional information.","ref":"erlang.html#round/1"},{"type":"type","title":"erlang.scheduler_bind_type/0","doc":"The requested scheduler bind type.","ref":"erlang.html#t:scheduler_bind_type/0"},{"type":"function","title":"erlang.self/0","doc":"Returns the process identifier of the calling process.\n\nFor example:\n\n```erlang\n> self().\n<0.26.0>\n```","ref":"erlang.html#self/0"},{"type":"function","title":"erlang.send/2","doc":"Sends a message and returns `Msg`. This is the same as using the\n[send operator](`e:system:expressions.md#send`): `Dest ! Msg`.\n\n`Dest` can be a remote or local process identifier, an alias, a (local) port, a\nlocally registered name, or a tuple `{RegName, Node}` for a registered name at\nanother node.\n\nThe function fails with a `badarg` run-time error if `Dest` is an atom name, but\nthis name is not registered. This is the only case when `send` fails for an\nunreachable destination `Dest` (of correct type).\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.","ref":"erlang.html#send/2"},{"type":"function","title":"erlang.send/3","doc":"Either sends a message and returns `ok`, or does not send the message but\nreturns something else (see below). Otherwise the same as\n[`erlang:send/2`](`send/2`).\n\nFor more detailed explanation and warnings, see [`erlang:send_nosuspend/2,3`](`send_nosuspend/2`).\n\nOptions:\n\n- **`nosuspend`** - If the sender would have to be suspended to do the send,\n  `nosuspend` is returned instead.\n\n- **`noconnect`** - If the destination node would have to be auto-connected to\n  do the send, `noconnect` is returned instead.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.\n\n> #### Warning {: .warning }\n>\n> As with `erlang:send_nosuspend/2,3`: use with extreme care.","ref":"erlang.html#send/3"},{"type":"function","title":"erlang.send_after/3","doc":"","ref":"erlang.html#send_after/3"},{"type":"function","title":"erlang.send_after/4","doc":"Starts a timer. When the timer expires, the message `Msg` is sent to the process\nidentified by `Dest`. Apart from the format of the time-out message, this\nfunction works exactly as [`erlang:start_timer/4`](`start_timer/4`).","ref":"erlang.html#send_after/4"},{"type":"type","title":"erlang.send_destination/0","doc":"The destination for a send operation.\n\nThis can be a remote or local process identifier, a (local) port, a reference\ndenoting a process alias, a locally registered name, or a tuple `{RegName, Node}`\nfor a registered name at another node.","ref":"erlang.html#t:send_destination/0"},{"type":"function","title":"erlang.send_nosuspend/2","doc":"Send a message without suspending the caller.\n\nEquivalent to [`erlang:send(Dest, Msg, [nosuspend])`](`send/3`), but returns\n`true` if the message was sent and `false` if the message was not sent because\nthe sender would have had to be suspended.\n\nThis function is intended for send operations to an unreliable remote node\nwithout ever blocking the sending (Erlang) process. If the connection to the\nremote node (usually not a real Erlang node, but a node written in C or Java) is\noverloaded, this function _does not send the message_ and returns `false`.\n\nThe same occurs if `Dest` refers to a local port that is busy. For all other\ndestinations (allowed for the ordinary send operator `'!'`), this function sends\nthe message and returns `true`.\n\nThis function is only to be used in rare circumstances where a process\ncommunicates with Erlang nodes that can disappear without any trace, causing the\nTCP buffers and the drivers queue to be over-full before the node is shut down\n(because of tick time-outs) by `net_kernel`. The normal reaction to take when\nthis occurs is some kind of premature shutdown of the other node.\n\nNotice that ignoring the return value from this function would result in an\n_unreliable_ message passing, which is contradictory to the Erlang programming\nmodel. The message is _not_ sent if this function returns `false`.\n\nIn many systems, transient states of overloaded queues are normal. Although this\nfunction returns `false` does not mean that the other node is guaranteed to be\nnon-responsive, it could be a temporary overload. Also, a return value of `true`\ndoes only mean that the message can be sent on the (TCP) channel without\nblocking; the message is not guaranteed to arrive at the remote node. For a\ndisconnected non-responsive node, the return value is `true` (mimics the\nbehavior of operator `!`). The expected behavior and the actions to take when\nthe function returns `false` are application- and hardware-specific.\n\n> #### Warning {: .warning }\n>\n> Use with extreme care.","ref":"erlang.html#send_nosuspend/2"},{"type":"function","title":"erlang.send_nosuspend/3","doc":"Equivalent to [`erlang:send(Dest, Msg, [nosuspend | Options])`](`send/3`), but\nwith a Boolean return value.\n\nThis function behaves like [`erlang:send_nosuspend/2`](`send_nosuspend/2`), but\ntakes a third parameter, a list of options. The only option is `noconnect`,\nwhich makes the function return `false` if the remote node is not currently\nreachable by the local node. The normal behavior is to try to connect to the\nnode, which can stall the process during a short period. The use of option\n`noconnect` makes it possible to be sure not to get the slightest delay when\nsending to a remote process. This is especially useful when communicating with\nnodes that expect to always be the connecting part (that is, nodes written in C\nor Java).\n\nWhenever the function returns `false` (either when a suspend would occur or when\n`noconnect` was specified and the node was not already connected), the message\nis guaranteed _not_ to have been sent.\n\n> #### Warning {: .warning }\n>\n> Use with extreme care.","ref":"erlang.html#send_nosuspend/3"},{"type":"function","title":"erlang.set_cookie/1","doc":"Sets the magic cookie of the local node to the atom `Cookie`, which is also the\ncookie for all nodes that have no explicit cookie set with `set_cookie/2`\n`Cookie`.\n\nSee section [Distributed Erlang](`e:system:distributed.md`) in the\nErlang Reference Manual in System Documentation for more information.\n\nYou can get this value using `get_cookie/0`.\n\nFailure: `function_clause` if the local node is not alive.","ref":"erlang.html#set_cookie/1"},{"type":"function","title":"erlang.set_cookie/2","doc":"Sets the magic cookie for `Node` to the atom `Cookie`. If `Node` is the local\nnode, the function sets the cookie of all other nodes (that have no explicit\ncookie set with this function) to `Cookie`.\n\nSee section [Distributed Erlang](`e:system:distributed.md`) in the\nErlang Reference Manual in System Documentation for more information.\n\nYou can get this value using `get_cookie/1`.\n\nFailure: `function_clause` if the local node is not alive.","ref":"erlang.html#set_cookie/2"},{"type":"function","title":"erlang.setelement/3","doc":"Returns a tuple that is a copy of argument `Tuple1` with the element specified\nby integer argument `Index` (the first element is the element with index 1)\nreplaced by argument `Value`.\n\nFor example:\n\n```erlang\n> setelement(2, {10, green, bottles}, red).\n{10,red,bottles}\n```","ref":"erlang.html#setelement/3"},{"type":"function","title":"erlang.size/1","doc":"Returns the number of elements in a tuple or the number of bytes in a binary or\nbitstring.\n\nFor example:\n\n```erlang\n> size({morni, mulle, bwange}).\n3\n> size(<<11, 22, 33>>).\n3\n```\n\nFor bitstrings, the number of whole bytes is returned. That is, if the number of\nbits in the bitstring is not divisible by 8, the resulting number of bytes is\nrounded _down_.\n\nSee also `tuple_size/1`, `byte_size/1`, and `bit_size/1`.","ref":"erlang.html#size/1"},{"type":"function","title":"erlang.spawn/1","doc":"Returns the process identifier of a new process started by the application of\n`Fun` to the empty list `[]`. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn/1"},{"type":"function","title":"erlang.spawn/2","doc":"Returns the process identifier of a new process started by the application of\n`Fun` to the empty list `[]` on `Node`. If `Node` does not exist, a useless pid\nis returned. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn/2"},{"type":"function","title":"erlang.spawn/3","doc":"Returns the process identifier of a new process started by the application of\n`Module:Function` to `Args`.\n\n[`error_handler:undefined_function(Module, Function, Args)`](`error_handler`) is\n evaluated by the new process if `Module:Function/Arity` does not exist\n(where `Arity` is the length of `Args`). The error handler can be redefined\n(see `process_flag/2`). If\n`error_handler` is undefined, or the user has redefined the default\n`error_handler` and its replacement is undefined, a failure with reason `undef`\noccurs.\n\nExample:\n\n```erlang\n> spawn(speed, regulator, [high_speed, thin_cut]).\n<0.13.1>\n```","ref":"erlang.html#spawn/3"},{"type":"function","title":"erlang.spawn/4","doc":"Returns the process identifier (pid) of a new process started by the application\nof `Module:Function` to `Args` on `Node`. If `Node` does not exist, a useless\npid is returned. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn/4"},{"type":"function","title":"erlang.spawn_link/1","doc":"Returns the process identifier of a new process started by the application of\n`Fun` to the empty list `[]`. A link is created between the calling process and\nthe new process, atomically. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn_link/1"},{"type":"function","title":"erlang.spawn_link/2","doc":"Returns the process identifier (pid) of a new process started by the application\nof `Fun` to the empty list `[]` on `Node`. A link is created between the calling\nprocess and the new process, atomically. If `Node` does not exist, a useless pid\nis returned and an exit signal with reason `noconnection` is sent to the calling\nprocess. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn_link/2"},{"type":"function","title":"erlang.spawn_link/3","doc":"Returns the process identifier of a new process started by the application of\n`Module:Function` to `Args`. A link is created between the calling process and\nthe new process, atomically. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn_link/3"},{"type":"function","title":"erlang.spawn_link/4","doc":"Returns the process identifier (pid) of a new process started by the application\nof `Module:Function` to `Args` on `Node`. A link is created between the calling\nprocess and the new process, atomically. If `Node` does not exist, a useless pid\nis returned and an exit signal with reason `noconnection` is sent to the calling\nprocess. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn_link/4"},{"type":"function","title":"erlang.spawn_monitor/1","doc":"Returns the process identifier of a new process, started by the application of\n`Fun` to the empty list `[]`, and a reference for a monitor created to the new\nprocess. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn_monitor/1"},{"type":"function","title":"erlang.spawn_monitor/2","doc":"Returns the process identifier of a new process, started by the application of\n`Fun` to the empty list `[]` on the node `Node`, and a reference for a monitor\ncreated to the new process. Otherwise works like `spawn/3`.\n\nIf the node identified by `Node` does not support distributed `spawn_monitor()`,\nthe call will fail with a `notsup` exception.","ref":"erlang.html#spawn_monitor/2"},{"type":"function","title":"erlang.spawn_monitor/3","doc":"A new process is started by the application of `Module:Function` to `Args`. The\nprocess is monitored at the same time. Returns the process identifier and a\nreference for the monitor. Otherwise works like `spawn/3`.","ref":"erlang.html#spawn_monitor/3"},{"type":"function","title":"erlang.spawn_monitor/4","doc":"A new process is started by the application of `Module:Function` to `Args` on\nthe node `Node`. The process is monitored at the same time. Returns the process\nidentifier and a reference for the monitor. Otherwise works like `spawn/3`.\n\nIf the node identified by `Node` does not support distributed `spawn_monitor()`,\nthe call will fail with a `notsup` exception.","ref":"erlang.html#spawn_monitor/4"},{"type":"function","title":"erlang.spawn_opt/2","doc":"Returns the process identifier (pid) of a new process started by the application\nof `Fun` to the empty list `[]`. Otherwise works like `spawn_opt/4`.\n\nIf option `monitor` is specified, the newly created process is monitored, and\nboth the pid and reference for the monitor are returned.","ref":"erlang.html#spawn_opt/2"},{"type":"function","title":"erlang.spawn_opt/3","doc":"Returns the process identifier (pid) of a new process started by the application\nof `Fun` to the empty list `[]` on `Node`. If `Node` does not exist, a useless\npid is returned. Otherwise works like `spawn_opt/4`.\n\nValid options depends on what options are supported by the node identified by\n`Node`. A description of valid `Option`s for the local node of current OTP\nversion can be found in the documentation of `spawn_opt/4`.","ref":"erlang.html#spawn_opt/3"},{"type":"function","title":"erlang.spawn_opt/4","doc":"Works as `spawn/3`, except that an extra option list is specified when creating\nthe process.\n\nIf option `monitor` is specified, the newly created process is monitored, and\nboth the pid and reference for the monitor are returned.\n\nOptions:\n\n- **`link`** - Sets a link to the parent process (like `spawn_link/3` does).\n\n- **`monitor`** - Monitors the new process (like\n  [`monitor(process, Pid)`](`monitor/2`) does). A `{Pid, MonitorRef}` tuple will\n  be returned instead of just a `Pid`.\n\n- **`{monitor, MonitorOpts}`** - Monitors the new process with options (like\n  [`monitor(process, Pid, MonitorOpts)`](`monitor/3`) does). A\n  `{Pid, MonitorRef}` tuple will be returned instead of just a `Pid`.\n\n- **`{priority, Level}`** - Sets the priority of the new process. Equivalent to\n  executing [`process_flag(priority, Level)`](#process_flag_priority)\n  in the start function of the new process, except that the priority is set\n  before the process is selected for execution for the first time. For more\n  information on priorities, see\n  [`process_flag(priority, Level)`](#process_flag_priority).\n\n- **`{fullsweep_after, Number}`** - Useful only for performance tuning. Do not\n  use this option unless you know that there is problem with execution times or\n  memory consumption, and ensure that the option improves matters.\n\n  The Erlang runtime system uses a generational garbage collection scheme, using\n  an \"old heap\" for data that has survived at least one garbage collection. When\n  there is no more room on the old heap, a fullsweep garbage collection is done.\n\n  Option `fullsweep_after` makes it possible to specify the maximum number of\n  generational collections before forcing a fullsweep, even if there is room on\n  the old heap. Setting the number to zero disables the general collection\n  algorithm, that is, all live data is copied at every garbage collection.\n\n  A few cases when it can be useful to change `fullsweep_after`:\n\n  - If binaries that are no longer used are to be thrown away as soon as\n    possible. (Set `Number` to zero.)\n  - A process that mostly have short-lived data is fullsweeped seldom or never,\n    that is, the old heap contains mostly garbage. To ensure a fullsweep\n    occasionally, set `Number` to a suitable value, such as 10 or 20.\n  - In embedded systems with a limited amount of RAM and no virtual memory, you\n    might want to preserve memory by setting `Number` to zero. (The value can be\n    set globally, see [`erlang:system_flag/2`](`system_flag/2`).)\n\n- **`{min_heap_size, Size}`** - Useful only for performance tuning. Do not use\n  this option unless you know that there is problem with execution times or\n  memory consumption, and ensure that the option improves matters.\n\n  Gives a minimum heap size, in words. Setting this value higher than the system\n  default can speed up some processes because less garbage collection is done.\n  However, setting a too high value can waste memory and slow down the system\n  because of worse data locality. Therefore, use this option only for\n  fine-tuning an application and to measure the execution time with various\n  `Size` values.\n\n- **`{min_bin_vheap_size, VSize}`** - Useful only for performance tuning. Do not\n  use this option unless you know that there is problem with execution times or\n  memory consumption, and ensure that the option improves matters.\n\n  Gives a minimum binary virtual heap size, in words. Setting this value higher\n  than the system default can speed up some processes because less garbage\n  collection is done. However, setting a too high value can waste memory.\n  Therefore, use this option only for fine-tuning an application and to measure\n  the execution time with various `VSize` values.\n\n- **`{max_heap_size, Size}`** - Sets the `max_heap_size` process flag. The\n  default `max_heap_size` is determined by command-line argument\n  [`+hmax`](erl_cmd.md#%2Bhmax) in [erl](erl_cmd.md). For more information, see\n  the documentation of\n  [`process_flag(max_heap_size, Size)`](#process_flag_max_heap_size).\n\n- **`{message_queue_data, MQD}`** - Sets the value of the `message_queue_data`\n  process flag. `MQD` can be either `off_heap` or `on_heap`. The default value\n  of the `message_queue_data` process flag is determined by the command-line\n  argument [`+hmqd`](erl_cmd.md#%2Bhmqd) in [erl](erl_cmd.md). For more\n  information, see the documentation of\n  [`process_flag(message_queue_data, MQD)`](#process_flag_message_queue_data).\n\n- **`{async_dist, Enabled}`{: #spawn_opt_async_dist }** - Since: OTP 25.3\n\n  Set the [`async_dist`](#process_flag_async_dist) process flag of the\n  spawned process. This option will override the default value set by the\n  command line argument [`+pad  `](erl_cmd.md#%2Bpad).","ref":"erlang.html#spawn_opt/4"},{"type":"function","title":"erlang.spawn_opt/5","doc":"Returns the process identifier (pid) of a new process started by the application\nof `Module:Function` to `Args` on `Node`. If `Node` does not exist, a useless\npid is returned. Otherwise works like `spawn_opt/4`.\n\nValid options depends on what options are supported by the node identified by\n`Node`. A description of valid `Option`s for the local node of current OTP\nversion can be found in the documentation of `spawn_opt/4`.","ref":"erlang.html#spawn_opt/5"},{"type":"type","title":"erlang.spawn_opt_option/0","doc":"Options for [`spawn_opt()`](`spawn_opt/4`).","ref":"erlang.html#t:spawn_opt_option/0"},{"type":"function","title":"erlang.spawn_request/1","doc":"Equivalent to the call [`spawn_request(node(),Fun,[])`](`spawn_request/3`). That\nis, a spawn request on the local node with no options.","ref":"erlang.html#spawn_request/1"},{"type":"function","title":"erlang.spawn_request/2","doc":"Equivalent to [`spawn_request(node(),Fun,Options)`](`spawn_request/3`) or\n[`spawn_request(Node,Fun,[])`](`spawn_request/3`) depending on the arguments.\n\nThat is either:\n- a spawn request on the local node.\n- a spawn request with no options.","ref":"erlang.html#spawn_request/2"},{"type":"function","title":"erlang.spawn_request/3","doc":"Equivalent to\n[`spawn_request(Node,erlang,apply,[Fun,[]],Options)`](`spawn_request/5`) or\n[`spawn_request(node(),Module,Function,Args,[])`](`spawn_request/5`) depending\non the arguments.\n\nThat is either:\n\n- a spawn request using the fun `Fun` of arity zero as entry point\n- a spawn request on the local node with no options.\n\nThis function will fail with a `badarg` exception if:\n\n- `Node` is not an atom.\n- `Fun` is not a fun of arity zero.\n- `Options` is not a proper list of terms.","ref":"erlang.html#spawn_request/3"},{"type":"function","title":"erlang.spawn_request/4","doc":"Equivalent to\n[`spawn_request(Node,Module,Function,Args,[])`](`spawn_request/5`) or\n[`spawn_request(node(),Module,Function,Args,Options)`](`spawn_request/5`)\ndepending on the arguments.\n\nThat is either:\n- a spawn request with no options.\n- a spawn request on the local node.","ref":"erlang.html#spawn_request/4"},{"type":"function","title":"erlang.spawn_request/5","doc":"Asynchronously send a spawn request. Returns a request identifier `ReqId`.\n\n[](){: #spawn_request_success_message }\n\nIf the spawn operation succeeds, a new process is created on the node identified\nby `Node`. When a spawn operation succeeds, the caller will by default be sent a\nmessage on the form `{ReplyTag, ReqId, ok, Pid}` where `Pid` is the process\nidentifier of the newly created process. Such a message is referred to as a\n_success message_ below in the text. `ReplyTag` is by default the atom\n`spawn_reply` unless modified by the `{reply_tag, ReplyTag}` option. The new\nprocess is started by the application of `Module:Function` to `Args`.\n\n[](){: #spawn_request_error_message }\n\nThe spawn operation fails either if creation of a new process failed or if the\nspawn operation was interrupted by a connection failure. When a spawn operation\nfails, the caller will by default be sent a message on the form\n`{ReplyTag, ReqId, error, Reason}` where `Reason` is the error reason. Such a\nmessage is referred to as an _error message_ below in the text. Currently the\nfollowing spawn error `Reason`s are defined, but other reasons can appear at any\ntime without prior notice:\n\n- **`badopt`** - An invalid `Option` was passed as argument. Note that different\n  runtime systems may support different options.\n\n- **`notsup`** - The node identified by `Node` does not support spawn operations\n  issued by `spawn_request()`.\n\n- **`noconnection`** - Failure to set up a connection to the node identified by\n  `Node` or the connection to that node was lost during the spawn operation. In\n  the case the connection was lost, a process may or may not have been created.\n\n- **`system_limit`** - Could not create a new process due to that some system\n  limit was reached. Typically the process table was full.\n\nValid `Option`s:\n\n- **`monitor`** - In the absence of spawn operation failures, atomically sets up\n  a monitor to the newly created process. That is, as if the calling process had\n  called [`monitor(process, Pid)`](`monitor/2`) where `Pid` is the process\n  identifier of the newly created process. The `ReqId` returned by\n  `spawn_request()` is also used as monitor reference as if it was returned from\n  [`monitor(process, Pid)`](`monitor/2`).\n\n  The monitor will not be activated for the calling process until the spawn\n  operation has succeeded. The monitor can not be [demonitored](`demonitor/1`)\n  before the operation has succeeded. A `'DOWN'` message for the corresponding\n  monitor is guaranteed not to be delivered before a\n  [_success message_](#spawn_request_success_message) that corresponds\n  to the spawn operation. If the spawn operation fails, no `'DOWN'` message will\n  be delivered.\n\n  If the connection between the nodes involved in the spawn operation is lost\n  during the spawn operation, the spawn operation will fail with an error reason\n  of `noconnection`. A new process may or may not have been created.\n\n- **`{monitor, MonitorOpts}`** - In the absence of spawn operation failures,\n  atomically sets up a monitor to the newly created process. That is, as if the\n  calling process had called [`monitor(process, Pid, MonitorOpts)`](`monitor/2`)\n  where `Pid` is the process identifier of the newly created process. See the\n  `monitor` option above for more information.\n\n  Note that the monitor will not be activated for the calling process until the\n  spawn operation has succeeded. For example, in the case that an alias is\n  created using the monitor option, the alias will not be active until the\n  monitor is activated.\n\n- **`link`** - In absence of spawn operation failures, atomically sets up a link\n  between the calling process and the newly created process. That is, as if the\n  calling process had called [`link(Pid)`](`link/1`) where `Pid` is the process\n  identifier of the newly created process.\n\n  The link will not be activated for the calling process until the spawn\n  operation has succeeded. The link can not be removed before the operation has\n  succeeded. An exit signal due to the link is guaranteed not to be delivered\n  before a [_success message_](#spawn_request_success_message) that\n  corresponds to the spawn operation. If the spawn operation fails, no exit\n  signal due to the link will be delivered to the caller of `spawn_request()`.\n\n  If the connection between the nodes involved in the spawn operation is lost\n  during the spawn operation, the spawn operation will fail with an error reason\n  of `noconnection`. A new process may or may not have been created. If it has\n  been created, it will be delivered an exit signal with an exit reason of\n  `noconnection`.\n\n- **`{reply, Reply}`** - Valid `Reply` values:\n\n  - **`yes`** - A spawn reply message will be sent to the caller regardless of\n    whether the operation succeeds or not. If the call to `spawn_request()`\n    returns without raising an exception and the `reply` option is set to `yes`,\n    the caller is guaranteed to be delivered either a\n    [_success message_](#spawn_request_success_message) or an\n    [_error message_](#spawn_request_error_message). The `reply`\n    option is by default set to `yes`.\n\n  - **`no`** - No spawn reply message will be sent to the caller when the spawn\n    operation completes. This regardless of whether the operation succeeds or\n    not.\n\n  - **`error_only`** - No spawn reply message will be sent to the caller if the\n    spawn operation succeeds, but an\n    [_error message_](#spawn_request_error_message) will be sent to\n    the caller if the operation fails.\n\n  - **`success_only`** - No spawn reply message will be sent to the caller if\n    the spawn operation fails, but a\n    [_success message_](#spawn_request_success_message) will be sent\n    to the caller if the operation succeeds.\n\n- **`{reply_tag, ReplyTag}`** - Sets the reply tag to `ReplyTag` in the reply\n  message. That is, in the [_success_](#spawn_request_success_message)\n  or [_error_](#spawn_request_error_message) message that is sent to\n  the caller due to the spawn operation. The default reply tag is the atom\n  `spawn_reply`.\n\n- **`OtherOption`** - Other valid options depends on what options are supported\n  by the node identified by `Node`. A description of other valid `Option`s for\n  the local node of current OTP version can be found in the documentation of\n  `spawn_opt/4`.\n\nIf a spawn reply message is delivered, it is guaranteed to be delivered before\nany other signals from the newly spawned process are delivered to the process\nissuing the spawn request.\n\nThis function will fail with a `badarg` exception if:\n\n- `Node` is not an atom.\n- `Module` is not an atom.\n- `Function` is not an atom.\n- `Args` is not a proper list of terms.\n- `Options` is not a proper list of terms.\n\nNote that not all individual `Option`s are checked when the spawn request is\nsent. Some `Option`s can only be checked on reception of the request. Therefore\nan invalid option does _not_ cause a `badarg` exception, but will cause the\nspawn operation to fail with an error reason of `badopt`.\n\nA spawn request can be abandoned by calling `spawn_request_abandon/1`.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.","ref":"erlang.html#spawn_request/5"},{"type":"function","title":"erlang.spawn_request_abandon/1","doc":"Abandon a previously issued spawn request. `ReqId` corresponds to a request\nidentifier previously returned by [`spawn_request()`](`spawn_request/5`) in a\ncall from current process. That is, only the process that has made the request\ncan abandon the request.\n\nA spawn request can only be successfully abandoned until the spawn request has\ncompleted. When a spawn request has been successfully abandoned, the caller will\nnot be effected by future direct effects of the spawn request itself. For\nexample, it will not receive a spawn reply message. The request is however not\nwithdrawn, so a new process may or may not be created due to the request. If a\nnew process is created after the spawn request was abandoned, no monitors nor\nlinks will be set up to the caller of\n[`spawn_request_abandon/1`](`spawn_request_abandon/1`) due to the spawn request.\nIf the spawn request included the `link` option, the process created due to this\nrequest will be sent an exit signal from its parent with the exit reason\n`abandoned` when it is detected that the spawn operation has succeeded.\n\n> #### Note {: .info }\n>\n> A process created due to a spawn request that has been abandoned may\n> communicate with its parent as any other process. It is _only_ the direct\n> effects on the parent of the actual spawn request, that will be canceled by\n> abandoning a spawn request.\n\nReturn values:\n\n- **`true`** - The spawn request was successfully abandoned.\n\n- **`false`** - No spawn request was abandoned. The `ReqId` request identifier\n  did not correspond to an outstanding spawn request issued by the calling\n  process. The reason for this is either:\n\n  - `ReqId` corresponds to a spawn request previoulsy made by the calling\n    process. The spawn operation has completed and a spawn reply has already\n    been delivered to the calling process unless the spawn reply was disabled in\n    the request.\n  - `ReqId` does not correspond to a spawn request that has been made by the\n    calling process.\n\nThis function fail with a `badarg` exception if `ReqId` is not a reference.","ref":"erlang.html#spawn_request_abandon/1"},{"type":"function","title":"erlang.split_binary/2","doc":"Returns a tuple containing the binaries that are the result of splitting `Bin`\ninto two parts at position `Pos`.\n\nThis is not a destructive operation. After the operation, there are three binaries altogether.\n\nFor example:\n\n```erlang\n> B = list_to_binary(\"0123456789\").\n<<\"0123456789\">>\n> byte_size(B).\n10\n> {B1, B2} = split_binary(B,3).\n{<<\"012\">>,<<\"3456789\">>}\n> byte_size(B1).\n3\n> byte_size(B2).\n7\n```","ref":"erlang.html#split_binary/2"},{"type":"type","title":"erlang.stack_item/0","doc":"","ref":"erlang.html#t:stack_item/0"},{"type":"type","title":"erlang.stacktrace/0","doc":"An Erlang stacktrace as described by\n[Errors and Error Handling](`e:system:errors.md#stacktrace`) section in the\nErlang Reference Manual.","ref":"erlang.html#t:stacktrace/0"},{"type":"type","title":"erlang.stacktrace_extrainfo/0","doc":"","ref":"erlang.html#t:stacktrace_extrainfo/0"},{"type":"function","title":"erlang.start_timer/3","doc":"","ref":"erlang.html#start_timer/3"},{"type":"function","title":"erlang.start_timer/4","doc":"Starts a timer. When the timer expires, the message `{timeout, TimerRef, Msg}`\nis sent to the process identified by `Dest`.\n\n`Option`s:\n\n- **`{abs, false}`** - This is the default. It means the `Time` value is\n  interpreted as a time in milliseconds _relative_ current\n  [Erlang monotonic time](time_correction.md#erlang-monotonic-time).\n\n- **`{abs, true}`** - Absolute `Time` value. The `Time` value is interpreted as\n  an absolute Erlang monotonic time in milliseconds.\n\nMore `Option`s can be added in the future.\n\nThe absolute point in time, the timer is set to expire on, must be in the\ninterval\n`[ `[erlang:convert_time_unit](`convert_time_unit/3`)`(`[erlang:system_info](#system_info_start_time)`(start_time), native, millisecond), `[erlang:convert_time_unit](`convert_time_unit/3`)`(`[erlang:system_info](#system_info_end_time)`(end_time), native, millisecond) ]`.\nIf a relative time is specified, the `Time` value is not allowed to be negative.\n\nIf `Dest` is a `t:pid/0`, it must be a `t:pid/0` of a process created on the\ncurrent runtime system instance. This process has either terminated or not. If\n`Dest` is an `t:atom/0`, it is interpreted as the name of a locally registered\nprocess. The process referred to by the name is looked up at the time of timer\nexpiration. No error is returned if the name does not refer to a process.\n\nIf `Dest` is a `t:pid/0`, the timer is automatically canceled if the process\nreferred to by the `t:pid/0` is not alive, or if the process exits. This feature\nwas introduced in ERTS 5.4.11. Notice that timers are not automatically canceled\nwhen `Dest` is an `t:atom/0`.\n\nSee also [`erlang:send_after/4`](`send_after/4`),\n[`erlang:cancel_timer/2`](`cancel_timer/2`), and\n[`erlang:read_timer/2`](`read_timer/2`).\n\nFor more information on timers in Erlang in general, see the\n[*Timers*](`e:erts:time_correction.md#timers`) section of the\n[*Time and Time Correction in Erlang*](`e:erts:time_correction.md`)\nERTS User's guide.\n\nFailure: `badarg` if the arguments do not satisfy the requirements specified\nhere.","ref":"erlang.html#start_timer/4"},{"type":"function","title":"erlang.statistics/1","doc":"Returns statistics about the current system.\n\nThe possible flags are:\n\n- ```erlang\n  statistics(active_tasks) -> [non_neg_integer()]\n  ```\n  {: #statistics_active_tasks }\n\n  Returns the same as\n  [`statistics(active_tasks_all)`](#statistics_active_tasks_all) with\n  the exception that no information about the dirty IO run queue and its\n  associated schedulers is part of the result. That is, only tasks that are\n  expected to be CPU bound are part of the result.\n\n  Available since OTP 18.3\n\n- ```erlang\n  statistics(active_tasks_all) -> [non_neg_integer()]\n  ```\n  {: #statistics_active_tasks_all }\n\n  Returns a list where each element represents the amount of active processes and\n  ports on each run queue and its associated schedulers. That is, the number of\n  processes and ports that are ready to run, or are currently running. Values for\n  normal run queues and their associated schedulers are located first in the\n  resulting list. The first element corresponds to scheduler number 1 and so on.\n  If support for dirty schedulers exist, an element with the value for the dirty\n  CPU run queue and its associated dirty CPU schedulers follow and then as last\n  element the value for the dirty IO run queue and its associated dirty IO\n  schedulers follow. The information is _not_ gathered atomically. That is, the\n  result is not necessarily a consistent snapshot of the state, but instead quite\n  efficiently gathered.\n\n  > #### Note {: .info }\n  >\n  > Each normal scheduler has one run queue that it manages. If dirty schedulers\n  > are supported, all dirty CPU schedulers share one run queue, and all dirty IO\n  > schedulers share one run queue. That is, we have multiple normal run queues,\n  > one dirty CPU run queue and one dirty IO run queue. Work can _not_ migrate\n  > between the different types of run queues. Only work in normal run queues can\n  > migrate to other normal run queues. This has to be taken into account when\n  > evaluating the result.\n\n  See also\n  [`statistics(total_active_tasks)`](#statistics_total_active_tasks),\n  [`statistics(run_queue_lengths)`](#statistics_run_queue_lengths),\n  [`statistics(run_queue_lengths_all)`](#statistics_run_queue_lengths_all),\n  [`statistics(total_run_queue_lengths)`](#statistics_total_run_queue_lengths),\n  and\n  [`statistics(total_run_queue_lengths_all)`](#statistics_total_run_queue_lengths_all).\n\n  Available since OTP 20.0\n\n- ```erlang\n  statistics(context_switches) -> {non_neg_integer(), 0}\n  ```\n  {: #statistics_context_switches }\n\n  Returns the total number of context switches since the system started.\n\n- ```erlang\n  statistics(exact_reductions) -> {Total :: non_neg_integer(), SinceLastCall :: non_neg_integer()}\n  ```\n  {: #statistics_exact_reductions }\n\n  Returns the number of exact reductions.\n\n  > #### Note {: .info }\n  >\n  > [`statistics(exact_reductions)`](`statistics/1`) is a more expensive operation\n  > than [statistics(reductions)](#statistics_reductions).\n\n- ```erlang\n  statistics(garbage_collection) ->\n    { NumerOfGCs :: non_neg_integer(), WordsReclaimed :: non_neg_integer(), 0}\n  ```\n\n  Returns information about garbage collection, for example:\n\n  ```erlang\n  > statistics(garbage_collection).\n  {85,23961,0}\n  ```\n\n  This information can be invalid for some implementations.\n\n- ```erlang\n  statistics(io) -> {{input, non_neg_integer()}, {output, non_neg_integer()}}\n  ```\n\n  Returns `Input`, which is the total number of bytes received through ports, and\n  `Output`, which is the total number of bytes output to ports.\n\n- ```erlang\n  statistics(microstate_accounting) -> [MSAcc_Thread]\n  ```\n  {: #statistics_microstate_accounting }\n\n  Microstate accounting can be used to measure how much time the Erlang runtime\n  system spends doing various tasks. It is designed to be as lightweight as\n  possible, but some overhead exists when this is enabled. Microstate accounting\n  is meant to be a profiling tool to help finding performance bottlenecks. To\n  `start`/`stop`/`reset` microstate accounting, use system flag\n  [`microstate_accounting`](#system_flag_microstate_accounting).\n\n  [`statistics(microstate_accounting)`](`statistics/1`) returns a list of maps\n  representing some of the OS threads within ERTS. Each map contains `type` and\n  `id` fields that can be used to identify what thread it is, and also a counters\n  field that contains data about how much time has been spent in the various\n  states.\n\n  Example:\n\n  ```erlang\n  > erlang:statistics(microstate_accounting).\n  [#{counters => #{aux => 1899182914,\n                   check_io => 2605863602,\n                   emulator => 45731880463,\n                   gc => 1512206910,\n                   other => 5421338456,\n                   port => 221631,\n                   sleep => 5150294100},\n     id => 1,\n     type => scheduler}|...]\n  ```\n\n  The time unit is the same as returned by `os:perf_counter/0`. So, to convert it\n  to milliseconds, you can do something like this:\n\n  ```erlang\n  lists:map(\n    fun(#{ counters := Cnt } = M) ->\n           MsCnt = maps:map(fun(_K, PerfCount) ->\n                                      erlang:convert_time_unit(PerfCount, perf_counter, 1000)\n                             end, Cnt),\n           M#{ counters := MsCnt }\n    end, erlang:statistics(microstate_accounting)).\n  ```\n\n  Notice that these values are not guaranteed to be the exact time spent in each\n  state. This is because of various optimisation done to keep the overhead as\n  small as possible.\n\n  `MSAcc_Thread_Type`s:\n\n  - **`scheduler`** - The main execution threads that do most of the work. See\n    [erl +S](erl_cmd.md#%2BS) for more details.\n\n  - **`dirty_cpu_scheduler`** - The threads for long running cpu intensive work.\n    See [erl +SDcpu](erl_cmd.md#%2BSDcpu) for more details.\n\n  - **`dirty_io_scheduler`** - The threads for long running I/O work. See\n    [erl +SDio](erl_cmd.md#%2BSDio) for more details.\n\n  - **`async`** - Async threads are used by various linked-in drivers (mainly the\n    file drivers) do offload non-CPU intensive work. See\n    [erl +A](erl_cmd.md#async_thread_pool_size) for more details.\n\n  - **`aux`** - Takes care of any work that is not specifically assigned to a\n    scheduler.\n\n  - **`poll`** - Does the IO polling for the emulator. See\n    [erl +IOt](erl_cmd.md#%2BIOt) for more details.\n\n  The following `MSAcc_Thread_State`s are available. All states are exclusive,\n  meaning that a thread cannot be in two states at once. So, if you add the\n  numbers of all counters in a thread, you get the total runtime for that thread.\n\n  - **`aux`** - Time spent handling auxiliary jobs.\n\n  - **`check_io`** - Time spent checking for new I/O events.\n\n  - **`emulator`** - Time spent executing Erlang processes.\n\n  - **`gc`** - Time spent doing garbage collection. When extra states are enabled\n    this is the time spent doing non-fullsweep garbage collections.\n\n  - **`other`** - Time spent doing unaccounted things.\n\n  - **`port`** - Time spent executing ports.\n\n  - **`sleep`** - Time spent sleeping.\n\n  More fine-grained `MSAcc_Thread_State`s can be added through configure (such as\n  `./configure --with-microstate-accounting=extra`). Enabling these states causes\n  performance degradation when microstate accounting is turned off and increases\n  the overhead when it is turned on.\n\n  - **`alloc`** - Time spent managing memory. Without extra states this time is\n    spread out over all other states.\n\n  - **`bif`** - Time spent in BIFs. Without extra states this time is part of the\n    `emulator` state.\n\n  - **`busy_wait`** - Time spent busy waiting. This is also the state where a\n    scheduler no longer reports that it is active when using\n    [`statistics(scheduler_wall_time)`](#statistics_scheduler_wall_time).\n    So, if you add all other states but this and sleep, and then divide that by\n    all time in the thread, you should get something very similar to the\n    `scheduler_wall_time` fraction. Without extra states this time is part of the\n    `other` state.\n\n  - **`ets`** - Time spent executing ETS BIFs. Without extra states this time is\n    part of the `emulator` state.\n\n  - **`gc_full`** - Time spent doing fullsweep garbage collection. Without extra\n    states this time is part of the `gc` state.\n\n  - **`nif`** - Time spent in NIFs. Without extra states this time is part of the\n    `emulator` state.\n\n  - **`send`** - Time spent sending messages (processes only). Without extra\n    states this time is part of the `emulator` state.\n\n  - **`timers`** - Time spent managing timers. Without extra states this time is\n    part of the `other` state.\n\n  The utility module `m:msacc` can be used to more easily analyse these\n  statistics.\n\n  Returns `undefined` if system flag\n  [`microstate_accounting`](#system_flag_microstate_accounting) is\n  turned off.\n\n  The list of thread information is unsorted and can appear in different order\n  between calls.\n\n  > #### Note {: .info }\n  >\n  > The threads and states are subject to change without any prior notice.\n\n  Available since OTP 19.0\n\n- ```erlang\n  statistics(reductions) -> {Reductions :: non_neg_integer(), SinceLastCall :: non_neg_integer()}\n  ```\n  {: #statistics_reductions }\n\n  Returns information about reductions, for example:\n\n  ```erlang\n  > statistics(reductions).\n  {2046,11}\n  ```\n\n  > #### Change {: .info }\n  >\n  > As from ERTS 5.5 (Erlang/OTP R11B), this value does not include reductions\n  > performed in current time slices of currently scheduled processes. If an exact\n  > value is wanted, use\n  > [`statistics(exact_reductions)`](#statistics_exact_reductions).\n\n- ```erlang\n  statistics(run_queue) -> non_neg_integer()\n  ```\n  {: #statistics_run_queue }\n\n  Returns the total length of all normal and dirty CPU run queues. That is, queued\n  work that is expected to be CPU bound. The information is gathered atomically.\n  That is, the result is a consistent snapshot of the state, but this operation is\n  much more expensive compared to\n  [`statistics(total_run_queue_lengths)`](#statistics_total_run_queue_lengths),\n  especially when a large amount of schedulers is used.\n\n- ```erlang\n  statistics(run_queue_lengths) -> [non_neg_integer()]\n  ```\n  {: #statistics_run_queue_lengths }\n\n  Returns the same as\n  [`statistics(run_queue_lengths_all)`](#statistics_run_queue_lengths_all)\n  with the exception that no information about the dirty IO run queue is part of\n  the result. That is, only run queues with work that is expected to be CPU bound\n  is part of the result.\n\n  Available since OTP 18.3\n\n- ```erlang\n  statistics(run_queue_lengths_all) -> [non_neg_integer()]\n  ```\n  {: #statistics_run_queue_lengths_all }\n\n  Returns a list where each element represents the amount of processes and ports\n  ready to run for each run queue. Values for normal run queues are located first\n  in the resulting list. The first element corresponds to the normal run queue of\n  scheduler number 1 and so on. If support for dirty schedulers exist, values for\n  the dirty CPU run queue and the dirty IO run queue follow (in that order) at the\n  end. The information is _not_ gathered atomically. That is, the result is not\n  necessarily a consistent snapshot of the state, but instead quite efficiently\n  gathered.\n\n  > #### Note {: .info }\n  >\n  > Each normal scheduler has one run queue that it manages. If dirty schedulers\n  > are supported, all dirty CPU schedulers share one run queue, and all dirty IO\n  > schedulers share one run queue. That is, we have multiple normal run queues,\n  > one dirty CPU run queue and one dirty IO run queue. Work can _not_ migrate\n  > between the different types of run queues. Only work in normal run queues can\n  > migrate to other normal run queues. This has to be taken into account when\n  > evaluating the result.\n\n  See also\n  [`statistics(run_queue_lengths)`](#statistics_run_queue_lengths),\n  [`statistics(total_run_queue_lengths_all)`](#statistics_total_run_queue_lengths_all),\n  [`statistics(total_run_queue_lengths)`](#statistics_total_run_queue_lengths),\n  [`statistics(active_tasks)`](#statistics_active_tasks),\n  [`statistics(active_tasks_all)`](#statistics_active_tasks_all), and\n  [`statistics(total_active_tasks)`](#statistics_total_active_tasks),\n  [`statistics(total_active_tasks_all)`](#statistics_total_active_tasks_all).\n\n  Available since OTP 20.0\n\n- ```erlang\n  statistics(runtime) -> {Total :: non_neg_integer(), SinceLastCall :: non_neg_integer()}\n  ```\n\n  Returns information about runtime, in milliseconds.\n\n  This is the sum of the runtime for all threads in the Erlang runtime system and\n  can therefore be greater than the wall clock time.\n\n  > #### Warning {: .warning }\n  >\n  > This value might wrap due to limitations in the underlying functionality\n  > provided by the operating system that is used.\n\n  Example:\n\n  ```erlang\n  > statistics(runtime).\n  {1690,1620}\n  ```\n\n- ```erlang\n  statistics(scheduler_wall_time) ->\n    [{Id :: pos_integer,\n      ActiveTime :: non_neg_integer(),\n      TotalTime :: non_neg_integer()}] |\n    undefined\n  ```\n  {: #statistics_scheduler_wall_time }\n\n  Returns information describing how much time\n  [normal](#system_info_schedulers) and\n  [dirty CPU](#system_info_dirty_cpu_schedulers) schedulers in the\n  system have been busy. This value is normally a better indicator of how much\n  load an Erlang node is under instead of looking at the CPU utilization provided\n  by tools such as `top` or `sysstat`. This is because `scheduler_wall_time` also\n  includes time where the scheduler is waiting for some other reasource (such as\n  an internal mutex) to be available but does not use the CPU. In order to better\n  understand what a scheduler is busy doing you can use\n  [microstate accounting](#statistics_microstate_accounting).\n\n  The definition of a busy scheduler is when it is not idle and not\n  [busy waiting](erl_cmd.md#%2Bsbwt) for new work, that is:\n\n  - Executing process code\n  - Executing linked-in driver or NIF code\n  - Executing BIFs, or any other runtime handling\n  - Garbage collecting\n  - Handling any other memory management\n\n  Notice that a scheduler can also be busy even if the OS has scheduled out the\n  scheduler thread.\n\n  > #### Note {: .info }\n  >\n  > It is recommended to use the module `m:scheduler` instead of this function\n  > directly as it provides an easier way to get the information that you usually\n  > want.\n\n  If [enabled](#system_flag_scheduler_wall_time) this function returns a\n  list of tuples with `{SchedulerId, ActiveTime, TotalTime}`, where `SchedulerId`\n  is an integer ID of the scheduler, `ActiveTime` is the duration the scheduler\n  has been busy, and `TotalTime` is the total time duration since\n  [`scheduler_wall_time`](#system_flag_scheduler_wall_time) activation\n  for the specific scheduler. The time unit returned is undefined and can be\n  subject to change between releases, OSs, and system restarts.\n  `scheduler_wall_time` is only to be used to calculate relative values for\n  scheduler utilization. The `ActiveTime` can never exceed `TotalTime`. The list\n  of scheduler information is unsorted and can appear in different order between\n  calls.\n\n  The [disabled](#system_flag_scheduler_wall_time) this function returns\n  `undefined`.\n\n  The activation time can differ significantly between schedulers. Currently dirty\n  schedulers are activated at system start while normal schedulers are activated\n  some time after the `scheduler_wall_time` functionality is enabled.\n\n  Only information about schedulers that are expected to handle CPU bound work is\n  included in the return values from this function. If you also want information\n  about [dirty I/O schedulers](#system_info_dirty_io_schedulers), use\n  [`statistics(scheduler_wall_time_all)`](#statistics_scheduler_wall_time_all)\n  instead.\n\n  Normal schedulers will have scheduler identifiers in the range\n  `1 =  #### Note {: .info }\n  >\n  > The different types of schedulers handle specific types of jobs. Every job is\n  > assigned to a specific scheduler type. Jobs can migrate between different\n  > schedulers of the same type, but never between schedulers of different types.\n  > This fact has to be taken under consideration when evaluating the result\n  > returned.\n\n  You can use `scheduler_wall_time` to calculate scheduler utilization. First you\n  take a sample of the values returned by\n  `erlang:statistics(scheduler_wall_time)`.\n\n  ```erlang\n  > erlang:system_flag(scheduler_wall_time, true).\n  false\n  > Ts0 = lists:sort(erlang:statistics(scheduler_wall_time)), ok.\n  ok\n  ```\n\n  Some time later the user takes another snapshot and calculates scheduler\n  utilization per scheduler, for example:\n\n  ```erlang\n  > Ts1 = lists:sort(erlang:statistics(scheduler_wall_time)), ok.\n  ok\n  > lists:map(fun({{I, A0, T0}, {I, A1, T1}}) ->\n          {I, (A1 - A0)/(T1 - T0)} end, lists:zip(Ts0,Ts1)).\n  [{1,0.9743474730177548},\n   {2,0.9744843782751444},\n   {3,0.9995902361669045},\n   {4,0.9738012596572161},\n   {5,0.9717956667018103},\n   {6,0.9739235846420741},\n   {7,0.973237033077876},\n   {8,0.9741297293248656}]\n  ```\n\n  Using the same snapshots to calculate a total scheduler utilization:\n\n  ```erlang\n  > {A, T} = lists:foldl(fun({{_, A0, T0}, {_, A1, T1}}, {Ai,Ti}) ->\n          {Ai + (A1 - A0), Ti + (T1 - T0)} end, {0, 0}, lists:zip(Ts0,Ts1)),\n    TotalSchedulerUtilization = A/T.\n  0.9769136803764825\n  ```\n\n  Total scheduler utilization will equal `1.0` when all schedulers have been\n  active all the time between the two measurements.\n\n  Another (probably more) useful value is to calculate total scheduler utilization\n  weighted against maximum amount of available CPU time:\n\n  ```erlang\n  > WeightedSchedulerUtilization = (TotalSchedulerUtilization\n                                    * (erlang:system_info(schedulers)\n                                       + erlang:system_info(dirty_cpu_schedulers)))\n                                   / erlang:system_info(logical_processors_available).\n  0.9769136803764825\n  ```\n\n  This weighted scheduler utilization will reach `1.0` when schedulers are active\n  the same amount of time as maximum available CPU time. If more schedulers exist\n  than available logical processors, this value may be greater than `1.0`.\n\n  As of ERTS version 9.0, the Erlang runtime system will as default have more\n  schedulers than logical processors. This due to the dirty schedulers.\n\n  > #### Note {: .info }\n  >\n  > `scheduler_wall_time` is by default disabled. To enable it, use\n  > [`erlang:system_flag(scheduler_wall_time, true)`](#system_flag_scheduler_wall_time).\n\n  Available since OTP R15B01\n\n- ```erlang\n  statistics(scheduler_wall_time_all) ->\n    [{Id :: pos_integer,\n      ActiveTime :: non_neg_integer(),\n      TotalTime :: non_neg_integer()}] |\n    undefined\n  ```\n  {: #statistics_scheduler_wall_time_all }\n\n  Equivalent to\n  [`statistics(scheduler_wall_time)`](#statistics_scheduler_wall_time),\n  except that it also include information about all dirty I/O schedulers.\n\n  Dirty IO schedulers will have scheduler identifiers in the range\n  [`erlang:system_info(schedulers)`](#system_info_schedulers)`+`[`erlang:system_info(dirty_cpu_schedulers)`](#system_info_dirty_cpu_schedulers)`  #### Note {: .info }\n  >\n  > Note that work executing on dirty I/O schedulers are expected to mainly wait\n  > for I/O. That is, when you get high scheduler utilization on dirty I/O\n  > schedulers, CPU utilization is _not_ expected to be high due to this work.\n\n  Available since OTP 20.0\n\n- ```erlang\n  statistics(total_active_tasks) -> non_neg_integer()\n  ```\n  {: #statistics_total_active_tasks }\n\n  Equivalent to calling\n  `lists:sum(`[`statistics(active_tasks)`](#statistics_active_tasks)`)`,\n  but more efficient.\n\n  Available since OTP 18.3\n\n- ```erlang\n  statistics(total_active_tasks_all) -> non_neg_integer()\n  ```\n  {: #statistics_total_active_tasks_all }\n\n  Equivalent to calling\n  `lists:sum(`[`statistics(active_tasks_all)`](#statistics_active_tasks_all)`)`,\n  but more efficient.\n\n  Available since OTP 20.0\n\n- ```erlang\n  statistics(total_run_queue_lengths) -> non_neg_integer()\n  ```\n  {: #statistics_total_run_queue_lengths }\n\n  Equivalent to calling\n  `lists:sum(`[`statistics(run_queue_lengths)`](#statistics_run_queue_lengths)`)`,\n  but more efficient.\n\n  Available since OTP 18.3\n\n- ```erlang\n  statistics(total_run_queue_lengths_all) -> non_neg_integer()\n  ```\n  {: #statistics_total_run_queue_lengths_all }\n\n  Equivalent to calling\n  `lists:sum(`[`statistics(run_queue_lengths_all)`](#statistics_run_queue_lengths_all)`)`,\n  but more efficient.\n\n  Available since OTP 20.0\n\n- ```erlang\n  statistics(wall_clock) -> {Total :: non_neg_integer(), SinceLastCall :: non_neg_integer()}\n  ```\n  {: #statistics_wall_clock }\n\n  Returns information about wall clock. `wall_clock` can be used in the same\n  manner as `runtime`, except that real time is measured as opposed to runtime or\n  CPU time.","ref":"erlang.html#statistics/1"},{"type":"type","title":"erlang.string/0","doc":"A character string represented by a list of ASCII characters or unicode\ncodepoints.","ref":"erlang.html#t:string/0"},{"type":"type","title":"erlang.sub_level/0","doc":"","ref":"erlang.html#t:sub_level/0"},{"type":"function","title":"erlang.suspend_process/1","doc":"Suspends the process identified by `Suspendee`. Equivalent to calling\n[`erlang:suspend_process(Suspendee, [])`](`suspend_process/2`).\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging only.","ref":"erlang.html#suspend_process/1"},{"type":"function","title":"erlang.suspend_process/2","doc":"Increases the suspend count on the process identified by `Suspendee` and puts it\nin the suspended state if it is not already in that state. A suspended process\nis not scheduled for execution until the process has been resumed.\n\nA process can be suspended by multiple processes and can be suspended multiple\ntimes by a single process. A suspended process does not leave the suspended\nstate until its suspend count reaches zero. The suspend count of `Suspendee` is\ndecreased when [`erlang:resume_process(Suspendee)`](`resume_process/1`) is\ncalled by the same process that called `erlang:suspend_process(Suspendee)`. All\nincreased suspend counts on other processes acquired by a process are\nautomatically decreased when the process terminates.\n\nOptions (`Opt`s):\n\n- **`asynchronous`** - A suspend request is sent to the process identified by\n  `Suspendee`. `Suspendee` eventually suspends unless it is resumed before it\n  could suspend. The caller of `erlang:suspend_process/2` returns immediately,\n  regardless of whether `Suspendee` has suspended yet or not. The point in time\n  when `Suspendee` suspends cannot be deduced from other events in the system.\n  It is only guaranteed that `Suspendee` _eventually_ suspends (unless it is\n  resumed). If no `asynchronous` options has been passed, the caller of\n  `erlang:suspend_process/2` is blocked until `Suspendee` has suspended.\n\n- **`{asynchronous, ReplyTag}`** - A suspend request is sent to the process\n  identified by `Suspendee`. When the suspend request has been processed, a\n  reply message is sent to the caller of this function. The reply is on the form\n  `{ReplyTag, State}` where `State` is either:\n\n  - **`exited`** - `Suspendee` has exited.\n\n  - **`suspended`** - `Suspendee` is now suspended.\n\n  - **`not_suspended`** - `Suspendee` is not suspended. This can only happen\n    when the process that issued this request, have called\n    [`resume_process(Suspendee)`](`resume_process/1`) before getting the reply.\n\n  Apart from the reply message, the `{asynchronous, ReplyTag}` option behaves\n  exactly the same as the `asynchronous` option without reply tag.\n\n- **`unless_suspending`** - The process identified by `Suspendee` is suspended\n  unless the calling process already is suspending `Suspendee`. If\n  `unless_suspending` is combined with option `asynchronous`, a suspend request\n  is sent unless the calling process already is suspending `Suspendee` or if a\n  suspend request already has been sent and is in transit. If the calling\n  process already is suspending `Suspendee`, or if combined with option\n  `asynchronous` and a send request already is in transit, `false` is returned\n  and the suspend count on `Suspendee` remains unchanged.\n\nIf the suspend count on the process identified by `Suspendee` is increased,\n`true` is returned, otherwise `false`.\n\n> #### Warning {: .warning }\n>\n> This BIF is intended for debugging only.\n\n> #### Warning {: .warning }\n>\n> You can easily create deadlocks if processes suspends each other (directly or\n> in circles). In ERTS versions prior to ERTS version 10.0, the runtime system\n> prevented such deadlocks, but this prevention has now been removed due to\n> performance reasons.\n\nFailures:\n\n- **`badarg`** - If `Suspendee` is not a process identifier.\n\n- **`badarg`** - If the process identified by `Suspendee` is the same process as\n  the process calling `erlang:suspend_process/2`.\n\n- **`badarg`** - If the process identified by `Suspendee` is not alive.\n\n- **`badarg`** - If the process identified by `Suspendee` resides on another\n  node.\n\n- **`badarg`** - If `OptList` is not a proper list of valid `Opt`s.\n\n- **`system_limit`** - If the process identified by `Suspendee` has been\n  suspended more times by the calling process than can be represented by the\n  currently used internal data structures. The system limit is greater than\n  2,000,000,000 suspends and will never be lower.","ref":"erlang.html#suspend_process/2"},{"type":"function","title":"erlang.system_flag/2","doc":"Sets a system flag to the given value.\n\nThe possible flags to set are:\n\n- ```erlang\n  system_flag(backtrace_depths, non_neg_integer()) -> non_neg_integer()\n  ```\n\n   Sets the maximum depth of call stack back-traces in the exit reason element of\n  `'EXIT'` tuples. The flag also limits the stacktrace depth returned by\n  `process_info/2` item [`current_stacktrace`](#process_info_current_stacktrace).\n\n  Returns the old value of the flag.\n\n- ```erlang\n  system_flag(cpu_topology, cpu_topology()) -> cpu_topology()\n  ```\n  {: #system_flag_cpu_topology }\n\n  > #### Warning {: .warning }\n  >\n  > _This argument is deprecated._ Instead of using this argument, use\n  > command-line argument [`+sct`](erl_cmd.md#%2Bsct) in [erl](erl_cmd.md).\n  >\n  > When this argument is removed, a final CPU topology to use is determined at\n  > emulator boot time.\n\n  Sets the user-defined `CpuTopology`. The user-defined CPU topology overrides any\n  automatically detected CPU topology. By passing `undefined` as `CpuTopology`,\n  the system reverts to the CPU topology automatically detected. The returned\n  value equals the value returned from `erlang:system_info(cpu_topology)` before\n  the change was made.\n\n  Returns the old value of the flag.\n\n  The CPU topology is used when binding schedulers to logical processors. If\n  schedulers are already bound when the CPU topology is changed, the schedulers\n  are sent a request to rebind according to the new CPU topology.\n\n  The user-defined CPU topology can also be set by passing command-line argument\n  [`+sct`](erl_cmd.md#%2Bsct) to [erl](erl_cmd.md).\n\n  For information on type `CpuTopology` and more, see\n  [`erlang:system_info(cpu_topology)`](#system_info_cpu_topology) as\n  well as command-line flags [`+sct`](erl_cmd.md#%2Bsct) and\n  [`+sbt`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n- ```erlang\n  system_flag(dirty_cpu_schedulers_online, pos_integer()) -> pos_integer()\n  ```\n  {: #system_flag_dirty_cpu_schedulers_online }\n\n  Sets the number of dirty CPU schedulers online. Range is\n  `1 <= DirtyCPUSchedulersOnline <= N`, where `N` is the smallest of the return\n  values of `erlang:system_info(dirty_cpu_schedulers)` and\n  `erlang:system_info(schedulers_online)`.\n\n  Returns the old value of the flag.\n\n  The number of dirty CPU schedulers online can change if the number of schedulers\n  online changes. For example, if 12 schedulers and 6 dirty CPU schedulers are\n  online, and [`system_flag/2`](`system_flag/2`) is used to set the number of\n  schedulers online to 6, then the number of dirty CPU schedulers online is\n  automatically decreased by half as well, down to 3. Similarly, the number of\n  dirty CPU schedulers online increases proportionally to increases in the number\n  of schedulers online.\n\n  For more information, see\n  [`erlang:system_info(dirty_cpu_schedulers)`](#system_info_dirty_cpu_schedulers)\n  and\n  [`erlang:system_info(dirty_cpu_schedulers_online)`](#system_info_dirty_cpu_schedulers_online).\n\n  Available since OTP 17.0\n\n- ```erlang\n  system_flag(erts_alloc, {Alloc :: atom(), F :: atom(), V :: integer()}) ->\n    ok | notsup\n  ```\n\n  Sets system flags for [`erts_alloc(3)`](erts_alloc.md). `Alloc` is the allocator\n  to affect, for example `binary_alloc`. `F` is the flag to change and `V` is the\n  new value.\n\n  Only a subset of all `erts_alloc` flags can be changed at run time. This subset\n  is currently only the flag [`sbct`](erts_alloc.md#M_sbct).\n\n  Returns `ok` if the flag was set or `notsup` if not supported by `erts_alloc`.\n\n  Available since OTP 20.2.3\n\n- ```erlang\n  system_flag(fullsweep_after, non_neg_integer()) -> non_neg_integer()\n  ```\n\n  Sets system flag `fullsweep_after`. `Number` is a non-negative integer\n  indicating how many times generational garbage collections can be done without\n  forcing a fullsweep collection. The value applies to new processes, while\n  processes already running are not affected.\n\n  Returns the old value of the flag.\n\n  In low-memory systems (especially without virtual memory), setting the value to\n  `0` can help to conserve memory.\n\n  This value can also be set through (OS) environment variable\n  `ERL_FULLSWEEP_AFTER`.\n\n- ```erlang\n  system_flag(microstate_accounting, true | false | reset) -> boolean()\n  ```\n  {: #system_flag_microstate_accounting }\n\n  Turns on/off microstate accounting measurements. When passing reset, all\n  counters are reset to 0.\n\n  For more information see\n  [`statistics(microstate_accounting)`](#statistics_microstate_accounting).\n\n  Available since OTP 19.0\n\n- ```erlang\n  system_flag(min_heap_size, non_neg_integer()) -> non_neg_integer()\n  ```\n\n  Sets the default minimum heap size for processes. The size is specified in\n  words. The new `min_heap_size` effects only processes spawned after the change\n  of `min_heap_size` has been made. `min_heap_size` can be set for individual\n  processes by using `spawn_opt/4` or `process_flag/2`.\n\n  Returns the old value of the flag.\n\n- ```erlang\n  system_flag(min_bin_vheap_size, non_neg_integer()) -> non_neg_integer()\n  ```\n\n  Sets the default minimum binary virtual heap size for processes. The size is\n  specified in words. The new `min_bin_vhheap_size` effects only processes spawned\n  after the change of `min_bin_vheap_size` has been made. `min_bin_vheap_size` can\n  be set for individual processes by using [`spawn_opt/2,3,4`](`spawn_opt/4`) or\n  `process_flag/2`.\n\n  Returns the old value of the flag.\n\n  Available since OTP R13B04\n\n- ```erlang\n  system_flag(max_heap_size, max_heap_size()) -> max_heap_size()\n  ```\n  {: #system_flag_max_heap_size }\n\n  Sets the default maximum heap size settings for processes. The size is specified\n  in words. The new `max_heap_size` effects only processes spawned after the\n  change has been made. `max_heap_size` can be set for individual processes using\n  [`spawn_opt/2,3,4`](`spawn_opt/4`) or\n  [`process_flag/2`](#process_flag_max_heap_size).\n\n  Returns the old value of the flag.\n\n  For details on how the heap grows, see\n  [Sizing the heap](GarbageCollection.md#sizing-the-heap) in the ERTS internal\n  documentation.\n\n  Available since OTP 19.0\n\n- ```erlang\n  system_flag(multi_scheduling, BlockState) -> OldBlockState when\n    BlockState :: block | unblock | block_normal | unblock_normal,\n    OldBlockState :: blocked | disabled | enabled\n  ```\n  {: #system_flag_multi_scheduling }\n\n  If multi-scheduling is enabled, more than one scheduler thread is used by the\n  emulator. Multi-scheduling can be blocked in two different ways. Either all\n  schedulers but one is blocked, or all _normal_ schedulers but one is blocked.\n  When only normal schedulers are blocked, dirty schedulers are free to continue\n  to schedule processes.\n\n  If `BlockState =:= block`, multi-scheduling is blocked. That is, one and only\n  one scheduler thread will execute. If `BlockState =:= unblock` and no one else\n  blocks multi-scheduling, and this process has blocked only once,\n  multi-scheduling is unblocked.\n\n  If `BlockState =:= block_normal`, normal multi-scheduling is blocked. That is,\n  only one normal scheduler thread will execute, but multiple dirty schedulers can\n  execute. If `BlockState =:= unblock_normal` and no one else blocks normal\n  multi-scheduling, and this process has blocked only once, normal\n  multi-scheduling is unblocked.\n\n  One process can block multi-scheduling and normal multi-scheduling multiple\n  times. If a process has blocked multiple times, it must unblock exactly as many\n  times as it has blocked before it has released its multi-scheduling block. If a\n  process that has blocked multi-scheduling or normal multi-scheduling exits, it\n  automatically releases its blocking of multi-scheduling and normal\n  multi-scheduling.\n\n  The return values are `disabled`, `blocked`, `blocked_normal`, or `enabled`. The\n  returned value describes the state just after the call to\n  `erlang:system_flag(multi_scheduling, BlockState)` has been made. For\n  information about the return values, see\n  [`erlang:system_info(multi_scheduling)`](#system_info_multi_scheduling).\n\n  > #### Note {: .info }\n  >\n  > Blocking of multi-scheduling and normal multi-scheduling is normally not\n  > needed. If you feel that you need to use these features, consider it a few\n  > more times again. Blocking multi-scheduling is only to be used as a last\n  > resort, as it is most likely a _very inefficient_ way to solve the problem.\n\n  See also\n  [`erlang:system_info(multi_scheduling)`](#system_info_multi_scheduling),\n  [`erlang:system_info(normal_multi_scheduling_blockers)`](#system_info_normal_multi_scheduling_blockers),\n  [`erlang:system_info(multi_scheduling_blockers)`](#system_info_multi_scheduling_blockers),\n  and [`erlang:system_info(schedulers)`](#system_info_schedulers).\n\n- ```erlang\n  system_flag(outstanding_system_requests_limit, 1..134217727) -> 1..134217727\n  ```\n  {: #system_flag_outstanding_system_requests_limit }\n\n  Sets a limit on the amount of outstanding requests made by a system process\n  orchestrating system wide changes. Currently there are two such processes:\n\n  - **The Code Purger** - The code purger orchestrates checking of references to\n    old code before old code is removed from the system.\n\n  - **The Literal Area Collector** - The literal area collector orchestrates\n    copying of references from old literal areas before removal of such areas from\n    the system.\n\n  Each of these processes are allowed to have as many outstanding requests as this\n  limit is set to. By default this limit is set to twice the amount of\n  [schedulers](#system_info_schedulers) on the system. This will ensure\n  that schedulers will have enough work scheduled to perform these operations as\n  quickly as possible at the same time as other work will be interleaved with this\n  work. Currently used limit can be checked by calling\n  [`erlang:system_info(outstanding_system_requests_limit)`](#system_info_outstanding_system_requests_limit).\n\n  This limit can also be set by passing the command line argument\n  [`+zosrl  `](erl_cmd.md#%2Bzosrl) to `erl`.\n\n  Available since OTP 24.2\n\n- ```erlang\n  system_flag(scheduler_bind_type, scheduler_bind_type() | default_bind) ->\n    scheduler_bind_type()\n  ```\n  {: #system_flag_scheduler_bind_type }\n\n  > #### Warning {: .warning }\n  >\n  > _This argument is deprecated._ Instead of using this argument, use\n  > command-line argument [`+sbt`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md). When\n  > this argument is removed, a final scheduler bind type to use is determined at\n  > emulator boot time.\n\n  Controls if and how schedulers are bound to logical processors.\n\n  When `erlang:system_flag(scheduler_bind_type, How)` is called, an asynchronous\n  signal is sent to all schedulers online, causing them to try to bind or unbind\n  as requested.\n\n  > #### Note {: .info }\n  >\n  > If a scheduler fails to bind, this is often silently ignored, as it is not\n  > always possible to verify valid logical processor identifiers. If an error is\n  > reported, an error event is logged. To verify that the schedulers have bound\n  > as requested, call\n  > [`erlang:system_info(scheduler_bindings)`](#system_info_scheduler_bindings).\n\n  Schedulers can be bound on newer Linux, Solaris, FreeBSD, and Windows systems,\n  but more systems will be supported in future releases.\n\n  In order for the runtime system to be able to bind schedulers, the CPU topology\n  must be known. If the runtime system fails to detect the CPU topology\n  automatically, it can be defined. For more information on how to define the CPU\n  topology, see command-line flag [`+sct`](erl_cmd.md#%2Bsct) in\n  [erl](erl_cmd.md).\n\n  The runtime system does by default _not_ bind schedulers to logical processors.\n\n  > #### Note {: .info }\n  >\n  > If the Erlang runtime system is the only OS process binding threads to logical\n  > processors, this improves the performance of the runtime system. However, if\n  > other OS processes (for example, another Erlang runtime system) also bind\n  > threads to logical processors, there can be a performance penalty instead.\n  > Sometimes this performance penalty can be severe. If so, it is recommended to\n  > not bind the schedulers.\n\n  Schedulers can be bound in different ways. Argument `How` determines how\n  schedulers are bound and can be any of the following:\n\n  - **`unbound`** - Same as command-line argument [`+sbt u`](erl_cmd.md#%2Bsbt) in\n    [erl](erl_cmd.md).\n\n  - **`no_spread`** - Same as command-line argument [`+sbt ns`](erl_cmd.md#%2Bsbt)\n    in [erl](erl_cmd.md).\n\n  - **`thread_spread`** - Same as command-line argument\n    [`+sbt ts`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n  - **`processor_spread`** - Same as command-line argument\n    [`+sbt ps`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n  - **`spread`** - Same as command-line argument [`+sbt s`](erl_cmd.md#%2Bsbt) in\n    [erl](erl_cmd.md).\n\n  - **`no_node_thread_spread`** - Same as command-line argument\n    [`+sbt nnts`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n  - **`no_node_processor_spread`** - Same as command-line argument\n    [`+sbt nnps`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n  - **`thread_no_node_processor_spread`** - Same as command-line argument\n    [`+sbt tnnps`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n  - **`default_bind`** - Same as command-line argument\n    [`+sbt db`](erl_cmd.md#%2Bsbt) in [erl](erl_cmd.md).\n\n  The returned value equals `How` before flag `scheduler_bind_type` was changed.\n\n  Failures:\n\n  - **`notsup`** - If binding of schedulers is not supported.\n\n  - **`badarg`** - If `How` is not one of the documented alternatives.\n\n  - **`badarg`** - If CPU topology information is unavailable.\n\n  The scheduler bind type can also be set by passing command-line argument\n  [`+sbt`](erl_cmd.md#%2Bsbt) to [erl](erl_cmd.md).\n\n  For more information, see\n  [`erlang:system_info(scheduler_bind_type)`](#system_info_scheduler_bind_type),\n  [`erlang:system_info(scheduler_bindings)`](#system_info_scheduler_bindings),\n  as well as command-line flags [`+sbt`](erl_cmd.md#%2Bsbt) and\n  [`+sct`](erl_cmd.md#%2Bsct) in [erl](erl_cmd.md).\n\n- ```erlang\n  system_flag(scheduler_wall_time, boolean()) -> boolean()\n  ```\n  {: #system_flag_scheduler_wall_time }\n\n  Try enable or disable scheduler wall time measurements by passing `Boolean` as\n  either `true` or `false`.\n\n  For more information about how to use scheduler wall time measurements, see\n  [`statistics(scheduler_wall_time)`](#statistics_scheduler_wall_time).\n\n  Scheduler wall time measurements has a node global state. It is either enabled\n  for all processes on the node or disabled for all processes. Each process has a\n  logical counter initialized as zero. A call with `Boolean` as `true` will\n  increase that counter one step for the calling process. A call with `false` will\n  decrease it one step unless it already is zero. The node global state for\n  `scheduler_wall_time` will be enabled as long as there is at least one process\n  alive with a counter value larger than zero. When a process terminates, its\n  counter will also disappear. To ensure `scheduler_wall_time` is kept enabled,\n  the process that enabled it must therefore be kept alive.\n\n  Returns the old value of the node global state, `true` if scheduler wall time\n  measurements were enabled, `false` if it were disabled.\n\n  Scheduler wall time measurements do consume some cpu overhead and should not be\n  left turned on unless used.\n\n  Available since OTP R15B01\n\n- ```erlang\n  system_flag(schedulers_online, pos_integer()) -> pos_integer()\n  ```\n  {: #system_flag_schedulers_online }\n\n  Sets the number of schedulers online. Range is\n  `1 <= SchedulersOnline <= erlang:system_info(schedulers)`.\n\n  Returns the old value of the flag.\n\n  If the emulator was built with support for\n  [dirty schedulers](#system_flag_dirty_cpu_schedulers_online), changing\n  the number of schedulers online can also change the number of dirty CPU\n  schedulers online. For example, if 12 schedulers and 6 dirty CPU schedulers are\n  online, and [`system_flag/2`](`system_flag/2`) is used to set the number of\n  schedulers online to 6, then the number of dirty CPU schedulers online is\n  automatically decreased by half as well, down to 3. Similarly, the number of\n  dirty CPU schedulers online increases proportionally to increases in the number\n  of schedulers online.\n\n  For more information, see\n  [`erlang:system_info(schedulers)`](#system_info_schedulers) and\n  [`erlang:system_info(schedulers_online)`](#system_info_schedulers_online).\n\n- ```erlang\n  system_flag(system_logger, logger | undefined | pid()) -> logger | undefined | pid()\n  ```\n\n  Sets the process that will receive the logging messages generated by ERTS. If\n  set to `undefined`, all logging messages generated by ERTS will be dropped. The\n  messages will be in the format:\n\n  ```erlang\n  {log,Level,Format,ArgList,Metadata} where\n\n  Level = atom(),\n  Format = string(),\n  ArgList = list(term()),\n  Metadata = #{ pid => pid(),\n     group_leader => pid(),\n     time := logger:timestamp(),\n     error_logger := #{ emulator := true, tag := atom() }\n  ```\n\n  If the `system_logger` process dies, this flag will be reset to `logger`.\n\n  The default is the process named `logger`.\n\n  Returns the old value of the flag.\n\n  > #### Note {: .info }\n  >\n  > This function is designed to be used by the KERNEL `m:logger`. Be careful if\n  > you change it to something else as log messages may be lost. If you want to\n  > intercept emulator log messages, do it by adding a specialized handler to the\n  > KERNEL logger.\n\n  Available since OTP 21.2\n\n- ```erlang\n  system_flag(trace_control_word, non_neg_integer()) -> non_neg_integer()\n  ```\n\n  Sets the value of the node trace control word to `TCW`, which is to be an\n  unsigned integer. For more information, see function\n  [`set_tcw`](match_spec.md#set_tcw) in section \"Match Specifications in Erlang\"\n  in the User's Guide.\n\n  Returns the old value of the flag.\n\n- ```erlang\n  system_flag(time_offset, finalize) -> preliminary | final | volatile\n  ```\n  {: #system_flag_time_offset }\n\n  Finalizes the [time offset](`time_offset/0`) when\n  [single time warp mode](time_correction.md#single-time-warp-mode) is used. If\n  another time warp mode is used, the time offset state is left unchanged.\n\n  Returns the old state identifier, that is:\n\n  - If `preliminary` is returned, finalization was performed and the time offset\n    is now final.\n  - If `final` is returned, the time offset was already in the final state. This\n    either because another `erlang:system_flag(time_offset, finalize)` call or\n    because [no time warp mode](time_correction.md#no-time-warp-mode) is used.\n  - If `volatile` is returned, the time offset cannot be finalized because\n    [multi-time warp mode](time_correction.md#multi-time-warp-mode) is used.\n\n  Available since OTP 18.0","ref":"erlang.html#system_flag/2"},{"type":"function","title":"erlang.system_info/1","doc":"Returns information about the current system.\n\nThe documentation of this function is broken into the following sections in\norder to make it easier to navigate.\n\n- [`Memory Allocation`](`m:erlang#system_info/1-memory-allocation`) -\n  [`allocated_areas`](`m:erlang#system_info_allocated_areas`),\n  [`allocator`](`m:erlang#system_info_allocator`),\n  [`alloc_util_allocators`](`m:erlang#system_info_alloc_util_allocators`),\n  [`allocator_sizes`](`m:erlang#system_info_allocator_sizes`)\n\n- [`CPU Topology`](`m:erlang#system_info/1-cpu-topology`) -\n  [`cpu_topology`](`m:erlang#system_info_cpu_topology`),\n  [`logical_processors`](`m:erlang#system_info_logical_processors`),\n  [`update_cpu_info`](`m:erlang#system_info_update_cpu_info`)\n\n- [`Process Information`](`m:erlang#system_info/1-process-information`) -\n  [`fullsweep_after`](`m:erlang#system_info_fullsweep_after`),\n  [`garbage_collection`](`m:erlang#system_info_garbage_collection`),\n  [`heap_sizes`](`m:erlang#system_info_heap_sizes`),\n  [`heap_type`](`m:erlang#system_info_heap_type`),\n  [`max_heap_size`](`m:erlang#system_info_max_heap_size`),\n  [`message_queue_data`](`m:erlang#system_info_message_queue_data`),\n  [`min_heap_size`](`m:erlang#system_info_min_heap_size`),\n  [`min_bin_vheap_size`](`m:erlang#system_info_min_bin_vheap_size`),\n  [`procs`](`m:erlang#system_info_procs`)\n\n- [`System Limits`](`m:erlang#system_info/1-system-limits`) -\n  [`atom_count`](`m:erlang#system_info_atom_count`),\n  [`atom_limit`](`m:erlang#system_info_atom_limit`),\n  [`ets_count`](`m:erlang#system_info_ets_count`),\n  [`ets_limit`](`m:erlang#system_info_ets_limit`),\n  [`port_count`](`m:erlang#system_info_port_count`),\n  [`port_limit`](`m:erlang#system_info_port_limit`),\n  [`process_count`](`m:erlang#system_info_process_count`),\n  [`process_limit`](`m:erlang#system_info_process_limit`)\n\n- [`System Time`](`m:erlang#system_info/1-system-time`) -\n  [`end_time`](`m:erlang#system_info_end_time`),\n  [`os_monotonic_time_source`](`m:erlang#system_info_os_monotonic_time_source`),\n  [`os_system_time_source`](`m:erlang#system_info_os_system_time_source`),\n  [`start_time`](`m:erlang#system_info_start_time`),\n  [`time_correction`](`m:erlang#system_info_time_correction`),\n  [`time_offset`](`m:erlang#system_info_time_offset`),\n  [`time_warp_mode`](`m:erlang#system_info_time_warp_mode`),\n  [`tolerant_timeofday`](`m:erlang#system_info_tolerant_timeofday`)\n\n- [`Scheduler Information`](`m:erlang#system_info/1-scheduler-information`) -\n  [`dirty_cpu_schedulers`](`m:erlang#system_info_dirty_cpu_schedulers`),\n  [`dirty_cpu_schedulers_online`](`m:erlang#system_info_dirty_cpu_schedulers_online`),\n  [`dirty_io_schedulers`](`m:erlang#system_info_dirty_io_schedulers`),\n  [`multi_scheduling`](`m:erlang#system_info_multi_scheduling`),\n  [`multi_scheduling_blockers`](`m:erlang#system_info_multi_scheduling_blockers`),\n  [`normal_multi_scheduling_blockers`](`m:erlang#system_info_normal_multi_scheduling_blockers`),\n  [`scheduler_bind_type`](`m:erlang#system_info_scheduler_bind_type`),\n  [`scheduler_bindings`](`m:erlang#system_info_scheduler_bindings`),\n  [`scheduler_id`](`m:erlang#system_info_scheduler_id`),\n  [`schedulers`](`m:erlang#system_info_schedulers`),\n  [`smp_support`](`m:erlang#system_info_smp_support`),\n  [`threads`](`m:erlang#system_info_threads`),\n  [`thread_pool_size`](`m:erlang#system_info_thread_pool_size`)\n\n- [`Distribution Information`](`m:erlang#system_info/1-distribution-information`) -\n  [`creation`](`m:erlang#system_info_creation`),\n  [`delayed_node_table_gc`](`m:erlang#system_info_delayed_node_table_gc`),\n  [`dist`](`m:erlang#system_info_dist`),\n  [`dist_buf_busy_limit`](`m:erlang#system_info_dist_buf_busy_limit`),\n  [`dist_ctrl`](`m:erlang#system_info_dist_ctrl`)\n\n- [`System Information`](`m:erlang#system_info/1-system-information`) -\n  [`c_compiler_used`](`m:erlang#system_info_c_compiler_used`),\n  [`check_io`](`m:erlang#system_info_check_io`),\n  [`compat_rel`](`m:erlang#system_info_compat_rel`),\n  [`debug_compiled`](`m:erlang#system_info_debug_compiled`),\n  [`driver_version`](`m:erlang#system_info_driver_version`),\n  [`dynamic_trace`](`m:erlang#system_info_dynamic_trace`),\n  [`dynamic_trace_probes`](`m:erlang#system_info_dynamic_trace_probes`),\n  [`emu_flavor`](`m:erlang#system_info_emu_flavor`),\n  [`emu_type`](`m:erlang#system_info_emu_type`),\n  [`info`](`m:erlang#system_info_info`),\n  [`kernel_poll`](`m:erlang#system_info_kernel_poll`),\n  [`loaded`](`m:erlang#system_info_loaded`),\n  [`machine`](`m:erlang#system_info_machine`),\n  [`modified_timing_level`](`m:erlang#system_info_modified_timing_level`),\n  [`nif_version`](`m:erlang#system_info_nif_version`),\n  [`otp_release`](`m:erlang#system_info_otp_release`),\n  [`outstanding_system_requests_limit`](`m:erlang#system_info_outstanding_system_requests_limit`),\n  [`port_parallelism`](`m:erlang#system_info_port_parallelism`),\n  [`system_architecture`](`m:erlang#system_info_system_architecture`),\n  [`system_logger`](`m:erlang#system_info_system_logger`),\n  [`system_version`](`m:erlang#system_info_system_version`),\n  [`trace_control_word`](`m:erlang#system_info_trace_control_word`),\n  [`version`](`m:erlang#system_info_version`),\n  [`wordsize`](`m:erlang#system_info_wordsize`)","ref":"erlang.html#system_info/1"},{"type":"function","title":"Memory Allocation - erlang.system_info/1","doc":"Returns various information about the memory allocators of the current system (emulator) as specified by `Item`:\n\n* __`allocated_areas`__{: #system_info_allocated_areas } - Returns `[tuple()]` with\n  information about miscellaneous allocated memory areas.\n\n  Each tuple contains an atom describing the type of memory as first element and\n  the amount of allocated memory in bytes as second element. When information\n  about allocated and used memory is present, also a third element is present,\n  containing the amount of used memory in bytes.\n\n  `erlang:system_info(allocated_areas)` is intended for debugging, and the content\n  is highly implementation-dependent. The content of the results therefore\n  changes when needed without prior notice.\n\n  Notice that the sum of these values is _not_ the total amount of memory\n  allocated by the emulator. Some values are part of other values, and some\n  memory areas are not part of the result. For information about the total amount\n  of memory allocated by the emulator, see\n  [`erlang:memory/0,1`](`erlang:memory/0`).\n\n- `allocator`{: #system_info_allocator } - Returns\n  ```\n  {Allocator :: undefined | glibc,\n   Version :: [non_neg_integer()],\n   Features :: [atom()],\n   Settings :: [{Subsystem :: atom(),\n                 [{Parameter :: atom(),\n                   Value :: term()}]\n                 }]\n  }\n  ```\n\n  where\n\n  - `Allocator` corresponds to the `malloc()` implementation used. If\n    `Allocator` equals `undefined`, the `malloc()` implementation used cannot be\n    identified. `glibc` can be identified.\n  - `Version` is a list of integers (but not a string) representing the\n    version of the `malloc()` implementation used.\n  - `Features` is a list of atoms representing the allocation features used.\n  - `Settings` is a list of subsystems, their configurable parameters, and used\n    values. Settings can differ between different combinations of platforms,\n    allocators, and allocation features. Memory sizes are given in bytes.\n\n  See also \"System Flags Effecting erts_alloc\" in\n  [`erts_alloc(3)`](erts_alloc.md#flags).\n\n- `{allocator, Alloc}`{: #system_info_allocator_tuple } - Returns\n  information about the specified allocator. As from ERTS 5.6.1, the return\n  value is a list of `{instance, InstanceNo, InstanceInfo}` tuples, where\n  `InstanceInfo` contains information about a specific instance of the\n  allocator. If `Alloc` is not a recognized allocator, `undefined` is\n  returned. If `Alloc` is disabled, `false` is returned.\n\n  Notice that the information returned is highly implementation-dependent and\n  can be changed or removed at any time without prior notice. It was initially\n  intended as a tool when developing new allocators, but as it can be of\n  interest for others it has been briefly documented.\n\n  The recognized allocators are listed in [`erts_alloc(3)`](erts_alloc.md).\n  Information about super carriers can be obtained from ERTS 8.0 with\n  `{allocator, erts_mmap}` or from ERTS 5.10.4; the returned list when calling\n  with `{allocator, mseg_alloc}` also includes an `{erts_mmap, _}` tuple as one\n  element in the list.\n\n  After reading the `erts_alloc(3)` documentation, the returned information more\n  or less speaks for itself, but it can be worth explaining some things. Call\n  counts are presented by two values, the first value is giga calls, and the\n  second value is calls. `mbcs` and `sbcs` denote multi-block carriers, and\n  single-block carriers, respectively. Sizes are presented in bytes. When a\n  size is not presented, it is the amount of something. Sizes and amounts are\n  often presented by three values:\n\n  - The first is the current value.\n  - The second is the maximum value since the last call to\n    `erlang:system_info({allocator, Alloc})`.\n  - The third is the maximum value since the emulator was started.\n\n  If only one value is present, it is the current value. `fix_alloc` memory\n  block types are presented by two values. The first value is the memory pool\n  size and the second value is the used memory size.\n\n- `alloc_util_allocators`{: #system_info_alloc_util_allocators } - Returns a\n  list of the names of all allocators using the ERTS internal `alloc_util`\n  framework as atoms. For more information, see section\n  [The alloc_util framework](erts_alloc.md#alloc_util) in `erts_alloc(3)`.\n\n- `{allocator_sizes, Alloc}`{: #system_info_allocator_sizes } - Returns\n  various size information for the specified allocator. The information\n  returned is a subset of the information returned by\n  [`erlang:system_info({allocator, Alloc})`](`m:erlang#system_info_allocator_tuple`).","ref":"erlang.html#system_info/1-memory-allocation"},{"type":"function","title":"CPU Topology - erlang.system_info/1","doc":"Returns various information about the CPU topology of the current system (emulator) as specified by `Item`:\n\n- `cpu_topology`{: #system_info_cpu_topology } - Returns the `t:cpu_topology()`\n  currently used by the emulator. The CPU topology is used when binding\n  schedulers to logical processors. The CPU topology used is the\n  [user-defined CPU topology](`m:erlang#system_info_cpu_topology_defined`), if\n  such exists, otherwise the\n  [automatically detected CPU topology](`m:erlang#system_info_cpu_topology_detected`),\n  if such exists. If no CPU topology exists, `undefined` is returned.\n\n- `{cpu_topology, defined}`{: #system_info_cpu_topology_defined } - Returns\n  the user-defined `t:cpu_topology()`. For more information, see command-line flag\n  [`+sct`](erl_cmd.md#+sct) in `erl(1)` and argument\n  [`cpu_topology`](`m:erlang#system_info_cpu_topology`).\n\n- `{cpu_topology, detected}`{: #system_info_cpu_topology_detected } -\n  Returns the automatically detected `t:cpu_topology()`. The emulator detects the\n  CPU topology on some newer Linux, Solaris, FreeBSD, and Windows systems. On\n  Windows system with more than 32 logical processors, the CPU topology is not\n  detected.\n\n  For more information, see argument\n  [`cpu_topology`](`m:erlang#system_info_cpu_topology`).\n\n- `{cpu_topology, used}` - Returns `CpuTopology` used by the emulator. For\n  more information, see argument\n  [`cpu_topology`](`m:erlang#system_info_cpu_topology`).\n\n- `logical_processors`{: #system_info_logical_processors } - Returns the\n  detected number of logical processors configured in the system. The return\n  value is either an integer, or the atom `unknown` if the emulator cannot\n  detect the configured logical processors.\n\n- `logical_processors_available`{: #system_info_logical_processors_available\n  } - Returns the detected number of logical processors available to the Erlang\n  runtime system. The return value is either an integer, or the atom `unknown`\n  if the emulator cannot detect the available logical processors. The number of\n  available logical processors is less than or equal to the number of\n  [logical processors online](`m:erlang#system_info_logical_processors_online`).\n\n- `logical_processors_online`{: #system_info_logical_processors_online } -\n  Returns the detected number of logical processors online on the system. The\n  return value is either an integer, or the atom `unknown` if the emulator\n  cannot detect logical processors online. The number of logical processors\n  online is less than or equal to the number of\n  [logical processors configured](`m:erlang#system_info_logical_processors`).\n\n- `cpu_quota`{: #system_info_cpu_quota } - Returns the detected CPU quota\n  the emulator is limited by. The return value is an integer saying how many\n  processors' worth of runtime we get (between 1 and the number of logical\n  processors), or the atom `unknown` if the emulator cannot detect a quota.\n\n- `update_cpu_info`{: #system_info_update_cpu_info } - The runtime system\n  rereads the CPU information available and updates its internally stored\n  information about the\n  [detected CPU topology](`m:erlang#system_info_cpu_topology_detected`) and the\n  number of logical processors\n  [configured](`m:erlang#system_info_logical_processors`),\n  [online](`m:erlang#system_info_logical_processors_online`),\n  [available](`m:erlang#system_info_logical_processors_available`), and\n  [cpu quota](`m:erlang#system_info_cpu_quota`).\n\n  If the CPU information has changed since the last time it was read, the atom\n  `changed` is returned, otherwise the atom `unchanged`. If the CPU information\n  has changed, you probably want to\n  [adjust the number of schedulers online](`m:erlang#system_flag_schedulers_online`).\n  You typically want to have as many schedulers online as\n  [logical processors available](`m:erlang#system_info_logical_processors_available`).\n  \n  Since: OTP R14B","ref":"erlang.html#system_info/1-cpu-topology"},{"type":"function","title":"Process Information - erlang.system_info/1","doc":"Returns information about the default process heap settings:\n\n- `fullsweep_after`{: #system_info_fullsweep_after } - Returns\n  `{fullsweep_after, integer() >= 0}`, which is the `fullsweep_after` garbage\n  collection setting used by default. For more information, see\n  `garbage_collection` described below.\n\n- `garbage_collection`{: #system_info_garbage_collection } - Returns\n  `t:garbage_collection_defaults/0` describing the default garbage collection settings.\n  A process spawned on the local node by a `spawn` or `spawn_link` uses these\n  garbage collection settings. The default settings can be changed by using\n  [`erlang:system_flag/2`](`erlang:system_flag/2`).\n  [`spawn_opt/2,3,4`](`erlang:spawn_opt/4`) can spawn a process that does not\n  use the default settings.\n\n- `heap_sizes`{: #system_info_heap_sizes } - Returns a list of integers\n  representing valid heap sizes in words. All Erlang heaps are sized from sizes\n  in this list.\n\n- `heap_type`{: #system_info_heap_type } - Returns the heap type used by the\n  current emulator. One heap type exists:\n\n  - `private` - Each process has a heap reserved for its use and no\n    references between heaps of different processes are allowed. Messages\n    passed between processes are copied between heaps.\n\n- `max_heap_size`{: #system_info_max_heap_size } - Returns\n  `{max_heap_size, MaxHeapSize}`, where `MaxHeapSize` is the current\n  system-wide maximum heap size settings for spawned processes. This setting\n  can be set using the command-line flags [`+hmax`](erl_cmd.md#+hmax),\n  [`+hmaxk`](erl_cmd.md#+hmaxk), [`+hmaxel`](erl_cmd.md#+hmaxel) and\n  [`+hmaxibl`](erl_cmd.md#+hmaxib) in `erl(1)`. It can also be changed at runtime\n  using\n  [`erlang:system_flag(max_heap_size, MaxHeapSize)`](`m:erlang#system_flag_max_heap_size`).\n  For more details about the `max_heap_size` process flag, see\n  [`process_flag(max_heap_size, MaxHeapSize)`](`m:erlang#process_flag_max_heap_size`).\n  \n  Since: OTP 19.0\n\n- `message_queue_data`{: #system_info_message_queue_data } - Returns the\n  default value of the `message_queue_data` process flag, which can be either\n  `off_heap` or `on_heap`. The default value is set by the command-line\n  argument [`+hmqd`](erl_cmd.md#+hmqd) in `erl(1)`. For more information, see the\n  documentation of\n  [`process_flag(message_queue_data, MQD)`](`m:erlang#process_flag_message_queue_data`).\n  \n  Since: OTP 19.0\n\n- `min_heap_size`{: #system_info_min_heap_size } - Returns\n  `{min_heap_size, MinHeapSize}`, where `MinHeapSize` is the current\n  system-wide minimum heap size for spawned processes.\n  \n  Since: OTP R13B04\n\n- `min_bin_vheap_size`{: #system_info_min_bin_vheap_size } - Returns\n  `{min_bin_vheap_size, MinBinVHeapSize}`, where `MinBinVHeapSize` is the\n  current system-wide minimum binary virtual heap size for spawned processes.\n  \n  Since: OTP R13B04\n\n- `procs`{: #system_info_procs } - Returns a binary containing a string of\n  process and port information formatted as in Erlang crash dumps. For more\n  information, see section\n  [How to interpret the Erlang crash dumps](crash_dump.md) in the User's Guide.","ref":"erlang.html#system_info/1-process-information"},{"type":"function","title":"System Limits - erlang.system_info/1","doc":"Returns information about the current system (emulator) limits as specified by `Item`:\n\n- `atom_count`{: #system_info_atom_count } - Returns the number of atoms\n  currently existing at the local node. The value is given as an integer.\n  \n  Since: OTP 20.0\n\n- `atom_limit`{: #system_info_atom_limit } - Returns the maximum number of\n  atoms allowed. This limit can be increased at startup by passing\n  command-line flag [`+t`](erl_cmd.md#+t_size) to `erl(1)`.\n  \n  Since: OTP 20.0\n\n- `ets_count`{: #system_info_ets_count } - Returns the number of ETS tables\n  currently existing at the local node.\n  \n  Since: OTP 21.1\n\n- `ets_limit`{: #system_info_ets_limit } - Returns the limit for number of\n  ETS tables. This limit is [partially obsolete](`m:ets#max_ets_tables`) and\n  number of tables are only limited by available memory.\n  \n  Since: OTP R16B03\n\n- `port_count`{: #system_info_port_count } - Returns the number of ports\n  currently existing at the local node. The value is given as an integer. This\n  is the same value as returned by `length(erlang:ports())`, but more\n  efficient.\n  \n  Since: OTP R16B\n\n- `port_limit`{: #system_info_port_limit } - Returns the maximum number of\n  simultaneously existing ports at the local node as an integer. This limit can\n  be configured at startup by using command-line flag [`+Q`](erl_cmd.md#+Q) in\n  `erl(1)`.\n  \n  Since OTP R16B\n\n- `process_count`{: #system_info_process_count } - Returns the number of\n  processes currently existing at the local node. The value is given as an\n  integer. This is the same value as returned by `length(processes())`, but\n  more efficient.\n\n- `process_limit`{: #system_info_process_limit } - Returns the maximum\n  number of simultaneously existing processes at the local node. The value is\n  given as an integer. This limit can be configured at startup by using\n  command-line flag [`+P`](erl_cmd.md#+P) in `erl(1)`.","ref":"erlang.html#system_info/1-system-limits"},{"type":"function","title":"System Time - erlang.system_info/1","doc":"Returns information about the current system (emulator) time as specified by `Item`:\n\n- `end_time`{: #system_info_end_time } - The last\n  [Erlang monotonic time](`erlang:monotonic_time/0`) in `native`\n  [time unit](`t:time_unit/0`) that can be represented internally in\n  the current Erlang runtime system instance. The time between the\n  [start time](`m:erlang#system_info_start_time`) and the end time is at least a\n  quarter of a millennium.\n  \n  Since: OTP 18.0\n\n- `os_monotonic_time_source`{: #system_info_os_monotonic_time_source } -\n  Returns a list containing information about the source of\n  [OS monotonic time](time_correction.md#os-monotonic-time) that is used by the\n  runtime system.\n\n  If `[]` is returned, no OS monotonic time is available. The list contains\n  two-tuples with `Key`s as first element, and `Value`s as second element. The\n  order of these tuples is undefined. The following tuples can be part of the\n  list, but more tuples can be introduced in the future:\n\n  - `{function, Function}` - `Function` is the name of the function used.\n    This tuple always exists if OS monotonic time is available to the runtime\n    system.\n\n  - `{clock_id, ClockId}` - This tuple only exists if `Function` can be used\n    with different clocks. `ClockId` corresponds to the clock identifier used\n    when calling `Function`.\n\n  - `{resolution, OsMonotonicTimeResolution}` - Highest possible\n    [resolution](time_correction.md#time-resolution) of current OS monotonic\n    time source as parts per second. If no resolution information can be\n    retrieved from the OS, `OsMonotonicTimeResolution` is set to the resolution\n    of the time unit of `Function`s return value. That is, the actual\n    resolution can be lower than `OsMonotonicTimeResolution`. Notice that the\n    resolution does not say anything about the\n    [accuracy](time_correction.md#time-accuracy) or whether the\n    [precision](time_correction.md#time-precision) aligns with the resolution.\n    You do, however, know that the precision is not better than\n    `OsMonotonicTimeResolution`.\n\n  - `{used_resolution, UsedOsMonotonicTimeResolution}` - The OS monotonic time\n    resolution used by the runtime system. This is very often the same as\n    `OsMonotonicTimeResolution`. However, on some systems the resolution has to\n    be reduced in order to reliably produce monotonic timestamps. An example of\n    this is when `QueryPerformanceCounter()` is used as OS monotonic time\n    source on Windows. If such a reduction of the resolution has been done,\n    `UsedOsMonotonicTimeResolution` will be smaller than\n    `OsMonotonicTimeResolution`.\n\n  - `{extended, Extended}` - `Extended` equals `yes` if the range of time\n    values has been extended; otherwise `Extended` equals `no`. The range must\n    be extended if `Function` returns values that wrap fast. This typically is\n    the case when the return value is a 32-bit value.\n\n  - `{parallel, Parallel}` - `Parallel` equals `yes` if `Function` is called\n    in parallel from multiple threads. If it is not called in parallel, because\n    calls must be serialized, `Parallel` equals `no`.\n\n  - `{time, OsMonotonicTime}` - `OsMonotonicTime` equals current OS\n    monotonic time in `native` [time unit](`t:time_unit/0`).\n  \n  Since: OTP 18.0\n\n- `os_system_time_source`{: #system_info_os_system_time_source } - Returns a\n  list containing information about the source of\n  [OS system time](time_correction.md#os-system-time) that is used by the\n  runtime system.\n\n  The list contains two-tuples with `Key`s as first element, and `Value`s as\n  second element. The order of these tuples is undefined. The following tuples\n  can be part of the list, but more tuples can be introduced in the future:\n\n  - `{function, Function}` - `Function` is the name of the function used.\n\n  - `{clock_id, ClockId}` - Exists only if `Function` can be used with\n    different clocks. `ClockId` corresponds to the clock identifier used when\n    calling `Function`.\n\n  - `{resolution, OsSystemTimeResolution}` - Highest possible\n    [resolution](time_correction.md#time-resolution) of current OS system time\n    source as parts per second. If no resolution information can be retrieved\n    from the OS, `OsSystemTimeResolution` is set to the resolution of the time\n    unit of `Function`s return value. That is, the actual resolution can be\n    lower than `OsSystemTimeResolution`. Notice that the resolution does not\n    say anything about the [accuracy](time_correction.md#time-accuracy) or\n    whether the [precision](time_correction.md#time-precision) do align with the\n    resolution. You do, however, know that the precision is not better than\n    `OsSystemTimeResolution`.\n\n  - `{parallel, Parallel}` - `Parallel` equals `yes` if `Function` is called\n    in parallel from multiple threads. If it is not called in parallel, because\n    calls needs to be serialized, `Parallel` equals `no`.\n\n  - `{time, OsSystemTime}` - `OsSystemTime` equals current OS system time in\n    `native` [time unit](`t:time_unit/0`).\n  \n  Since: OTP 18.0\n\n- `start_time`{: #system_info_start_time } - The\n  [Erlang monotonic time](`erlang:monotonic_time/0`) in `native`\n  [time unit](`t:time_unit/0`) at the time when current Erlang runtime\n  system instance started.\n\n  See also [`erlang:system_info(end_time)`](`m:erlang#system_info_end_time`).\n  \n  Since: OTP 18.0\n\n- `time_correction`{: #system_info_time_correction } - Returns a `t:boolean()`\n  value indicating whether [time correction](time_correction.md#time-correction)\n  is enabled or not.\n  \n  Since: OTP 18.0\n\n- `time_offset`{: #system_info_time_offset } - Returns the state of the time\n  offset:\n\n  - `preliminary` - The time offset is preliminary, and will be changed and\n    finalized later. The preliminary time offset is used during the preliminary\n    phase of the\n    [single time warp mode](time_correction.md#single-time-warp-mode).\n\n  - `final` - The time offset is final. This either because\n    [no time warp mode](time_correction.md#no-time-warp-mode) is used, or\n    because the time offset have been finalized when\n    [single time warp mode](time_correction.md#single-time-warp-mode) is used.\n\n  - `volatile` - The time offset is volatile. That is, it can change at any\n    time. This is because\n    [multi-time warp mode](time_correction.md#multi-time-warp-mode) is used.\n  \n  Since: OTP 18.0\n\n- `time_warp_mode`{: #system_info_time_warp_mode } - Returns a value\n  identifying the [time warp mode](time_correction.md#time-warp-modes) that is\n  used:\n\n  - `no_time_warp` - The\n    [no time warp mode](time_correction.md#no-time-warp-mode) is used.\n\n  - `single_time_warp` - The\n    [single time warp mode](time_correction.md#single-time-warp-mode) is used.\n\n  - `multi_time_warp` - The\n    [multi-time warp mode](time_correction.md#multi-time-warp-mode) is used.\n  \n  Since: OTP 18.0\n\n- `tolerant_timeofday`{: #system_info_tolerant_timeofday } - Returns whether\n  a pre ERTS 7.0 backwards compatible compensation for sudden changes of system\n  time is `enabled` or `disabled`. Such compensation is `enabled` when the\n  [time offset](`m:erlang#system_info_time_offset`) is `final`, and\n  [time correction](`m:erlang#system_info_time_correction`) is enabled.\n  \n  Since: OTP 17.1","ref":"erlang.html#system_info/1-system-time"},{"type":"function","title":"Scheduler Information - erlang.system_info/1","doc":"Returns information about schedulers, scheduling and threads in the current system as specified by `Item`:\n\n- `dirty_cpu_schedulers`{: #system_info_dirty_cpu_schedulers } - Returns the\n  number of dirty CPU scheduler threads used by the emulator. Dirty CPU\n  schedulers execute CPU-bound native functions, such as NIFs, linked-in\n  driver code, and BIFs that cannot be managed cleanly by the normal emulator\n  schedulers.\n\n  The number of dirty CPU scheduler threads is determined at emulator boot time\n  and cannot be changed after that. However, the number of dirty CPU scheduler\n  threads online can be changed at any time. The number of dirty CPU schedulers\n  can be set at startup by passing command-line flag [`+SDcpu`](erl_cmd.md#+SDcpu)\n  or [`+SDPcpu`](erl_cmd.md#+SDPcpu) in `erl(1)`.\n\n  See also\n  [`erlang:system_flag(dirty_cpu_schedulers_online, DirtyCPUSchedulersOnline)`](`m:erlang#system_flag_dirty_cpu_schedulers_online`),\n  [`erlang:system_info(dirty_cpu_schedulers_online)`](`m:erlang#system_info_dirty_cpu_schedulers_online`),\n  [`erlang:system_info(dirty_io_schedulers)`](`m:erlang#system_info_dirty_io_schedulers`),\n  [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`),\n  [`erlang:system_info(schedulers_online)`](`m:erlang#system_info_schedulers_online`),\n  and\n  [`erlang:system_flag(schedulers_online, SchedulersOnline)`](`m:erlang#system_flag_schedulers_online`).\n  \n  Since: OTP 17.0\n\n- `dirty_cpu_schedulers_online`{: #system_info_dirty_cpu_schedulers_online\n  } - Returns the number of dirty CPU schedulers online. The return value\n  satisfies `1 <= DirtyCPUSchedulersOnline <= N`, where `N` is the smallest of\n  the return values of `erlang:system_info(dirty_cpu_schedulers)` and\n  `erlang:system_info(schedulers_online)`.\n\n  The number of dirty CPU schedulers online can be set at startup by passing\n  command-line flag [`+SDcpu`](erl_cmd.md#+SDcpu) in `erl(1)`.\n\n  For more information, see\n  [`erlang:system_info(dirty_cpu_schedulers)`](`m:erlang#system_info_dirty_cpu_schedulers`),\n  [`erlang:system_info(dirty_io_schedulers)`](`m:erlang#system_info_dirty_io_schedulers`),\n  [`erlang:system_info(schedulers_online)`](`m:erlang#system_info_schedulers_online`),\n  and\n  [`erlang:system_flag(dirty_cpu_schedulers_online, DirtyCPUSchedulersOnline)`](`m:erlang#system_flag_dirty_cpu_schedulers_online`).\n  \n  Since: OTP 17.0\n\n- `dirty_io_schedulers`{: #system_info_dirty_io_schedulers } - Returns the\n  number of dirty I/O schedulers as an integer. Dirty I/O schedulers execute\n  I/O-bound native functions, such as NIFs and linked-in driver code, which\n  cannot be managed cleanly by the normal emulator schedulers.\n\n  This value can be set at startup by passing command-line argument\n  [`+SDio`](erl_cmd.md#+SDio) in `erl(1)`.\n\n  For more information, see\n  [`erlang:system_info(dirty_cpu_schedulers)`](`m:erlang#system_info_dirty_cpu_schedulers`),\n  [`erlang:system_info(dirty_cpu_schedulers_online)`](`m:erlang#system_info_dirty_cpu_schedulers_online`),\n  and\n  [`erlang:system_flag(dirty_cpu_schedulers_online, DirtyCPUSchedulersOnline)`](`m:erlang#system_flag_dirty_cpu_schedulers_online`).\n  \n  Since: OTP 17.0\n\n- `multi_scheduling`{: #system_info_multi_scheduling } - Returns one of the\n  following:\n\n  - `disabled` - The emulator has been started with only one scheduler\n    thread.\n\n  - `blocked` - The emulator has more than one scheduler thread, but all\n    scheduler threads except one are blocked. That is, only one scheduler\n    thread schedules Erlang processes and executes Erlang code.\n\n  - `blocked_normal` - The emulator has more than one scheduler thread, but\n    all normal scheduler threads except one are blocked. Notice that dirty\n    schedulers are not blocked, and can schedule Erlang processes and execute\n    native code.\n\n  - `enabled` - The emulator has more than one scheduler thread, and no\n    scheduler threads are blocked. That is, all available scheduler threads\n    schedule Erlang processes and execute Erlang code.\n\n  See also\n  [`erlang:system_flag(multi_scheduling, BlockState)`](`m:erlang#system_flag_multi_scheduling`),\n  [`erlang:system_info(multi_scheduling_blockers)`](`m:erlang#system_info_multi_scheduling_blockers`),\n  [`erlang:system_info(normal_multi_scheduling_blockers)`](`m:erlang#system_info_normal_multi_scheduling_blockers`),\n  and [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`).\n\n- `multi_scheduling_blockers`{: #system_info_multi_scheduling_blockers } -\n  Returns a list of `Pid`s when multi-scheduling is blocked, otherwise the\n  empty list is returned. The `Pid`s in the list represent all the processes\n  currently blocking multi-scheduling. A `Pid` occurs only once in the list,\n  even if the corresponding process has blocked multiple times.\n\n  See also\n  [`erlang:system_flag(multi_scheduling, BlockState)`](`m:erlang#system_flag_multi_scheduling`),\n  [`erlang:system_info(multi_scheduling)`](`m:erlang#system_info_multi_scheduling`),\n  [`erlang:system_info(normal_multi_scheduling_blockers)`](`m:erlang#system_info_normal_multi_scheduling_blockers`),\n  and [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`).\n\n- `normal_multi_scheduling_blockers`{:\n  #system_info_normal_multi_scheduling_blockers } - Returns a list of `Pid`s\n  when normal multi-scheduling is blocked (that is, all normal schedulers but\n  one is blocked), otherwise the empty list is returned. The `Pid`s in the\n  list represent all the processes currently blocking normal multi-scheduling.\n  A `Pid` occurs only once in the list, even if the corresponding process has\n  blocked multiple times.\n\n  See also\n  [`erlang:system_flag(multi_scheduling, BlockState)`](`m:erlang#system_flag_multi_scheduling`),\n  [`erlang:system_info(multi_scheduling)`](`m:erlang#system_info_multi_scheduling`),\n  [`erlang:system_info(multi_scheduling_blockers)`](`m:erlang#system_info_multi_scheduling_blockers`),\n  and [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`).\n  \n  Since: OTP 19.0\n\n- `scheduler_bind_type`{: #system_info_scheduler_bind_type } - Returns\n  `t:scheduler_bind_type()`, information about how the user has requested\n  schedulers to be bound or not bound.\n\n  Notice that although a user has requested schedulers to be bound, they can\n  silently have failed to bind. To inspect the scheduler bindings, call\n  [`erlang:system_info(scheduler_bindings)`](`m:erlang#system_info_scheduler_bindings`).\n\n  For more information, see command-line argument [`+sbt`](erl_cmd.md#+sbt) in\n  `erl(1)` and\n  [`erlang:system_info(scheduler_bindings)`](`m:erlang#system_info_scheduler_bindings`).\n\n- `scheduler_bindings`{: #system_info_scheduler_bindings } - Returns\n  information about the currently used scheduler bindings.\n\n  A tuple of a size equal to\n  [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`) is\n  returned. The tuple elements are integers or the atom `unbound`. Logical\n  processor identifiers are represented as integers. The `N`th element of the\n  tuple equals the current binding for the scheduler with the scheduler\n  identifier equal to `N`. For example, if the schedulers are bound,\n  `element(erlang:system_info(scheduler_id), erlang:system_info(scheduler_bindings))`\n  returns the identifier of the logical processor that the calling process is\n  executing on.\n\n  Notice that only schedulers online can be bound to logical processors.\n\n  For more information, see command-line argument [`+sbt`](erl_cmd.md#+sbt) in\n  `erl(1)` and\n  [`erlang:system_info(schedulers_online)`](`m:erlang#system_info_schedulers_online`).\n\n- `scheduler_id`{: #system_info_scheduler_id } - Returns the scheduler ID\n  (`SchedulerId`) of the scheduler thread that the calling process is\n  executing on. `SchedulerId` is a positive integer, where\n  `1 <= SchedulerId <= erlang:system_info(schedulers)`.\n\n  See also\n  [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`).\n\n- `schedulers`{: #system_info_schedulers } - Returns the number of scheduler\n  threads used by the emulator. Scheduler threads online schedules Erlang\n  processes and Erlang ports, and execute Erlang code and Erlang linked-in\n  driver code.\n\n  The number of scheduler threads is determined at emulator boot time and cannot\n  be changed later. However, the number of schedulers online can be changed at\n  any time.\n\n  See also\n  [`erlang:system_flag(schedulers_online, SchedulersOnline)`](`m:erlang#system_flag_schedulers_online`),\n  [`erlang:system_info(schedulers_online)`](`m:erlang#system_info_schedulers_online`),\n  [`erlang:system_info(scheduler_id)`](`m:erlang#system_info_scheduler_id`),\n  [`erlang:system_flag(multi_scheduling, BlockState)`](`m:erlang#system_flag_multi_scheduling`),\n  [`erlang:system_info(multi_scheduling)`](`m:erlang#system_info_multi_scheduling`),\n  [`erlang:system_info(normal_multi_scheduling_blockers)`](`m:erlang#system_info_normal_multi_scheduling_blockers`)\n  and\n  [`erlang:system_info(multi_scheduling_blockers)`](`m:erlang#system_info_multi_scheduling_blockers`).\n\n- `schedulers_online`{: #system_info_schedulers_online } - Returns the\n  number of schedulers online. The scheduler identifiers of schedulers online\n  satisfy the relationship\n  `1 <= SchedulerId <= erlang:system_info(schedulers_online)`.\n\n  For more information, see\n  [`erlang:system_info(schedulers)`](`m:erlang#system_info_schedulers`) and\n  [`erlang:system_flag(schedulers_online, SchedulersOnline)`](`m:erlang#system_flag_schedulers_online`).\n\n- `smp_support`{: #system_info_smp_support } - Returns `true`.\n\n- `threads`{: #system_info_threads } - Returns `true`.\n\n- `thread_pool_size`{: #system_info_thread_pool_size } - Returns the number of async threads in the\n  async thread pool used for asynchronous driver calls\n  ([ `erl_driver:driver_async()`](erl_driver.md#driver_async)). The value is\n  given as an integer.","ref":"erlang.html#system_info/1-scheduler-information"},{"type":"function","title":"Distribution Information - erlang.system_info/1","doc":"Returns information about Erlang Distribution in the current system as specified by `Item`:\n\n- `async_dist`{: #system_info_async_dist } - Returns the value of the command line argument\n  [+pad  ](erl_cmd.md#+pad) which the runtime system use. This value\n  determines the default [`async_dist`](`m:erlang#process_flag_async_dist`)\n  value for newly spawned processes.\n  \n  Since: OTP 25.3\n\n- `creation`{: #system_info_creation } - Returns the \"creation\" value of the\n  local node as an integer. The creation is changed when a node is restarted.\n  The creation of a node is stored in process identifiers, port identifiers, and\n  references. This makes it possible to distinguish between identifiers from\n  different incarnations of a node. Creation values are currently 32-bit\n  positive integers, but this may change in future releases. If the node is not\n  alive, `0` is returned.\n\n- `delayed_node_table_gc`{: #system_info_delayed_node_table_gc } - Returns\n  the amount of time in seconds garbage collection of an entry in a node table\n  is delayed. This limit can be set on startup by passing command-line flag\n  [`+zdntgc`](erl_cmd.md#+zdntgc) to `erl(1)`. For more information, see the\n  documentation of the command-line flag.\n  \n  Since: OTP 18.0\n\n- `dist`{: #system_info_dist } - Returns a binary containing a string of\n  distribution information formatted as in Erlang crash dumps. For more\n  information, see section\n  [How to interpret the Erlang crash dumps](crash_dump.md) in the User's Guide.\n\n- `dist_buf_busy_limit`{: #system_info_dist_buf_busy_limit } - Returns the\n  value of the distribution buffer busy limit in bytes. This limit can be set\n  at startup by passing command-line flag [`+zdbbl`](erl_cmd.md#+zdbbl) to\n  `erl(1)`.\n  \n  Since: OTP R14B01\n\n- `dist_ctrl`{: #system_info_dist_ctrl } - Returns a list of tuples\n  `{Node :: node(), ControllingEntity :: port() | pid()}`, one entry for each\n  connected remote node. `Node` is the node name and `ControllingEntity` is the\n  port or process identifier responsible for the communication to that node.\n  More specifically, `ControllingEntity` for nodes connected through TCP/IP (the\n  normal case) is the socket used in communication with the specific node.","ref":"erlang.html#system_info/1-distribution-information"},{"type":"function","title":"System Information - erlang.system_info/1","doc":"Returns various information about the current system (emulator) as specified by `Item`:\n\n- `c_compiler_used`{: #system_info_c_compiler_used } - Returns a two-tuple\n  describing the C compiler used when compiling the runtime system. The first\n  element is an atom describing the name of the compiler, or `undefined` if\n  unknown. The second element is a term describing the version of the compiler,\n  or `undefined` if unknown.\n\n- `check_io`{: #system_info_check_io } - Returns a list containing\n  miscellaneous information about the emulators internal I/O checking. Notice\n  that the content of the returned list can vary between platforms and over\n  time. It is only guaranteed that a list is returned.\n\n- `compat_rel`{: #system_info_compat_rel } - Returns the compatibility mode\n  of the local node as an integer. The integer returned represents the\n  Erlang/OTP release that the current emulator has been set to be backward\n  compatible with. The compatibility mode can be configured at startup by using\n  command-line flag [`+R`](erl_cmd.md#compat_rel) in `erl(1)`.\n\n- `debug_compiled`{: #system_info_debug_compiled } - Returns `true` if the\n  emulator has been debug-compiled, otherwise `false`.\n\n- `driver_version`{: #system_info_driver_version } - Returns a string\n  containing the Erlang driver version used by the runtime system. It has the\n  form [\" . \"](erl_driver.md#version_management).\n\n- `dynamic_trace`{: #system_info_dynamic_trace } - Returns an atom\n  describing the dynamic trace framework compiled into the virtual machine. It\n  can be `dtrace`, `systemtap`, or `none`. For a commercial or standard build,\n  it is always `none`. The other return values indicate a custom configuration\n  (for example, `./configure --with-dynamic-trace=dtrace`). For more\n  information about dynamic tracing, see [`dyntrace(3)`](`m:dyntrace`) manual\n  page and the `README.dtrace`/`README.systemtap` files in the Erlang source\n  code top directory.\n  \n  Since: OTP R15B01\n\n- `dynamic_trace_probes`{: #system_info_dynamic_trace_probes } - Returns a\n  `t:boolean()` indicating if dynamic trace probes (`dtrace` or `systemtap`) are\n  built into the emulator. This can only be `true` if the virtual machine was\n  built for dynamic tracing (that is, `system_info(dynamic_trace)` returns\n  `dtrace` or `systemtap`).\n  \n  Since: OTP R15B01\n\n- `emu_flavor`{: #system_info_emu_flavor } - Returns an atom describing the\n  flavor of the runtime system. This will be either `emu` or `jit`. Possible\n  return values can be added or removed at any time without prior notice.\n  \n  Since: OTP 24.0\n\n- `emu_type`{: #system_info_emu_type } - Returns an atom describing the\n  build type of the runtime system. This is normally the atom `opt` for\n  optimized. Other possible return values are `debug`, `gcov`, `valgrind`,\n  `gprof`, and `lcnt`. Possible return values can be added or removed at any\n  time without prior notice.\n  \n  Since: OTP 24.0\n\n- `halt_flush_timeout`{: #system_info_halt_flush_timeout } - Returns the\n  default *halt flush timeout* set by the `erl`\n  [`+zhft  `](erl_cmd.md#+zhft) command line flag.\n\n  Since: OTP 27.0\n\n- `info`{: #system_info_info } - Returns a binary containing a string of\n  miscellaneous system information formatted as in Erlang crash dumps. For more\n  information, see section\n  [How to interpret the Erlang crash dumps](crash_dump.md) in the User's Guide.\n\n- `kernel_poll`{: #system_info_kernel_poll } - Returns `true` if the\n  emulator uses some kind of kernel-poll implementation, otherwise `false`.\n\n- `loaded`{: #system_info_loaded } - Returns a binary containing a string of\n  loaded module information formatted as in Erlang crash dumps. For more\n  information, see section\n  [How to interpret the Erlang crash dumps](crash_dump.md) in the User's Guide.\n\n- `machine`{: #system_info_machine } - Returns a string containing the\n  Erlang machine name.\n\n- `modified_timing_level`{: #system_info_modified_timing_level } - Returns\n  the modified timing-level (an `t:integer()`) if modified timing is enabled,\n  otherwise `undefined`. For more information about modified timing, see\n  command-line flag [`+T`](erl_cmd.md#+T_level) in `erl(1)`\n\n- `nif_version`{: #system_info_nif_version } - Returns a string containing\n  the version of the Erlang NIF interface used by the runtime system. It is on\n  the form \" . \".\n  \n  Since: OTP 17.4\n\n- `otp_release`{: #system_info_otp_release } -\n  Returns a string containing the OTP release number of the OTP release that the\n  currently executing ERTS application is part of.\n\n  As from Erlang/OTP 17, the OTP release number corresponds to the major OTP\n  version number. No `erlang:system_info()` argument gives the exact OTP\n  version. This is because the exact OTP version in the general case is\n  difficult to determine. For more information, see the description of versions\n  in [System principles](`e:system:versions.md`) in System Documentation.\n\n- `outstanding_system_requests_limit`{:\n  #system_info_outstanding_system_requests_limit } - Returns the limit on the\n  amount of outstanding requests made by a system process orchestrating system\n  wide changes. See\n  [`erlang:system_flag(outstanding_system_requests_limit, Limit)`](`m:erlang#system_flag_outstanding_system_requests_limit`)\n  for more information.\n  \n  Since: OTP 24.2\n\n- `port_parallelism`{: #system_info_port_parallelism } - Returns the default\n  port parallelism scheduling hint used. For more information, see\n  command-line argument [`+spp`](erl_cmd.md#+spp) in `erl(1)`.\n  \n  Since: OTP R16B\n\n- `system_architecture`{: #system_info_system_architecture } - Returns a\n  string containing the processor and OS architecture the emulator is built\n  for.\n\n- `system_logger`{: #system_info_system_logger } - Returns the current\n  `system_logger` as set by [`erlang:system_flag(system_logger,\n  *)`](`erlang:system_flag/2`).\n  \n  Since: OTP 21.3\n\n- `system_version`{: #system_info_system_version } - Returns a string\n  containing version number and some important properties, such as the number of\n  schedulers.\n\n- `trace_control_word`{: #system_info_trace_control_word } - Returns the\n  value of the node trace control word. For more information, see function\n  `get_tcw` in section [Match Specifications in Erlang](match_spec.md#get_tcw)\n  in the User's Guide.\n\n- `version`{: #system_info_version } - Returns a string containing the\n  version number of the emulator.\n\n- `wordsize`{: #system_info_wordsize } - Same as `{wordsize, internal}`.\n\n- `{wordsize, internal}` - Returns the size of Erlang term words in bytes as\n  an integer, that is, 4 is returned on a 32-bit architecture, and 8 is\n  returned on a 64-bit architecture.\n\n- `{wordsize, external}` - Returns the true word size of the emulator, that\n  is, the size of a pointer. The value is given in bytes as an integer. On a\n  pure 32-bit architecture, 4 is returned. On a 64-bit architecture, 8 is\n  returned.","ref":"erlang.html#system_info/1-system-information"},{"type":"function","title":"erlang.system_monitor/0","doc":"Returns the current system monitoring settings set by\n[`erlang:system_monitor/2`](`system_monitor/2`) as `{MonitorPid, Options}`, or\n`undefined` if no settings exist.\n\nThe order of the options can be different from the one that was set.","ref":"erlang.html#system_monitor/0"},{"type":"function","title":"erlang.system_monitor/1","doc":"When called with argument `undefined`, all system performance monitoring\nsettings are cleared.\n\nCalling the function with `{MonitorPid, Options}` as argument is the same as\ncalling [`erlang:system_monitor(MonitorPid, Options)`](`system_monitor/2`).\n\nReturns the previous system monitor settings just like\n[`erlang:system_monitor/0`](`system_monitor/0`).","ref":"erlang.html#system_monitor/1"},{"type":"function","title":"erlang.system_monitor/2","doc":"Sets the system performance monitoring options. `MonitorPid` is a local process\nidentifier (pid) receiving system monitor messages.\n\nThe second argument is a list of monitoring options:\n\n- **`{long_gc, Time}`** - If a garbage collection in the system takes at least\n  `Time` wall clock milliseconds, a message `{monitor, GcPid, long_gc, Info}` is\n  sent to `MonitorPid`. `GcPid` is the pid that was garbage collected. `Info` is\n  a list of two-element tuples describing the result of the garbage collection.\n\n  One of the tuples is `{timeout, GcTime}`, where `GcTime` is the time for the\n  garbage collection in milliseconds. The other tuples are tagged with\n  `heap_size`, `heap_block_size`, `stack_size`, `mbuf_size`, `old_heap_size`,\n  and `old_heap_block_size`. These tuples are explained in the description of\n  trace message [`gc_minor_start`](`m:trace#gc_minor_start`) (see\n  `trace:process/4`). New tuples can be added, and the order of the\n  tuples in the `Info` list can be changed at any time without prior notice.\n\n- **`{long_message_queue, {Disable, Enable}}`** - If the message queue length of\n  a process in the system reach `Enable` length, a `long_message_queue` monitor\n  message is sent to the process identified by `MonitorPid`. The monitor message\n  will be on the form `{monitor, Pid, long_message_queue, Long}`, where `Pid` is\n  the process identifier of the process that got a long message queue and `Long`\n  will equal `true` indicating that it is in a _long message queue_ state. No\n  more `long_message_queue` monitor messages will be sent due to the process\n  identified by `Pid` until its message queue length falls down to a length of\n  `Disable` length. When this happens, a `long_message_queue` monitor message\n  with `Long` equal to `false` will be sent to the process identified by\n  `MonitorPid` indicating that the process is no longer in a _long message\n  queue_ state. As of this, if the message queue length should again reach\n  `Enable` length, a new `long_message_queue` monitor message with `Long` set to\n  `true` will again be sent. That is, a `long_message_queue` monitor message is\n  sent when a process enters or leaves a _long message queue_ state where these\n  state changes are defined by the `Enable` and `Disable` parameters.\n\n  `Enable` length must be an integer larger than zero and `Disable` length must\n  be an integer larger than or equal to zero. `Disable` length must also be\n  smaller than `Enable` length. If the above is not satisfied the operation will\n  fail with a `badarg` error exception. You are recommended to use a much\n  smaller value for `Disable` length than `Enable` length in order not to be\n  flooded with `long_message_queue` monitor messages.\n\n- **`{long_schedule, Time}`** - If a process or port in the system runs\n  uninterrupted for at least `Time` wall clock milliseconds, a message\n  `{monitor, PidOrPort, long_schedule, Info}` is sent to `MonitorPid`.\n  `PidOrPort` is the process or port that was running. `Info` is a list of\n  two-element tuples describing the event.\n\n  If a `t:pid/0`, the tuples `{timeout, Millis}`, `{in, Location}`, and\n  `{out, Location}` are present, where `Location` is either an MFA\n  (`{Module, Function, Arity}`) describing the function where the process was\n  scheduled in/out, or the atom `undefined`.\n\n  If a `t:port/0`, the tuples `{timeout, Millis}` and `{port_op,Op}` are\n  present. `Op` is one of `proc_sig`, `timeout`, `input`, `output`, `event`, or\n  `dist_cmd`, depending on which driver callback was executing.\n\n  `proc_sig` is an internal operation and is never to appear, while the others\n  represent the corresponding driver callbacks `timeout`, `ready_input`,\n  `ready_output`, `event`, and `outputv` (when the port is used by\n  distribution). Value `Millis` in tuple `timeout` informs about the\n  uninterrupted execution time of the process or port, which always is equal to\n  or higher than the `Time` value supplied when starting the trace. New tuples\n  can be added to the `Info` list in a future release. The order of the tuples\n  in the list can be changed at any time without prior notice.\n\n  This can be used to detect problems with NIFs or drivers that take too long to\n  execute. 1 ms is considered a good maximum time for a driver callback or a\n  NIF. However, a time-sharing system is usually to consider everything < 100 ms\n  as \"possible\" and fairly \"normal\". However, longer schedule times can indicate\n  swapping or a misbehaving NIF/driver. Misbehaving NIFs and drivers can cause\n  bad resource utilization and bad overall system performance.\n\n- **`{large_heap, Size}`** - If a garbage collection in the system results in\n  the allocated size of a heap being at least `Size` words, a message\n  `{monitor, GcPid, large_heap, Info}` is sent to `MonitorPid`. `GcPid` and\n  `Info` are the same as for `long_gc` earlier, except that the tuple tagged\n  with `timeout` is not present.\n\n  The monitor message is sent if the sum of the sizes of all memory blocks\n  allocated for all heap generations after a garbage collection is equal to or\n  higher than `Size`.\n\n  When a process is killed by\n  [`max_heap_size`](#process_flag_max_heap_size), it is killed before\n  the garbage collection is complete and thus no large heap message is sent.\n\n- **`busy_port`** - If a process in the system gets suspended because it sends\n  to a busy port, a message `{monitor, SusPid, busy_port, Port}` is sent to\n  `MonitorPid`. `SusPid` is the pid that got suspended when sending to `Port`.\n\n- **`busy_dist_port`[](){: #busy_dist_port } **  \n   If a process in the system gets suspended because it sends to a process on a remote\n  node whose inter-node communication was handled by a busy port, a message `{monitor, SusPid, busy_dist_port, Port}`\n  is sent to `MonitorPid`. `SusPid` is the pid that got suspended when sending through\n  the inter-node communication port `Port`.\n\nReturns the previous system monitor settings just like\n[`erlang:system_monitor/0`](`system_monitor/0`).\n\nThe arguments to [`system_monitor/2`](`system_monitor/2`) specifies how all\nsystem monitoring on the node should be done, not how it should be changed. This\nmeans only one process at a time (`MonitorPid`) can be the receiver of system\nmonitor messages. Also, the way to clear a specific monitor option is to not\ninclude it in the list `Options`. All system monitoring will, however, be\ncleared if the process identified by `MonitorPid` terminates.\n\nThere are no special option values (like zero) to clear an option. Some of the\noptions have a unspecified minimum value. Lower values will be adjusted to the\nminimum value. For example, it is currently not possible to monitor all garbage\ncollections with `{long_gc, 0}`.\n\n> #### Note {: .info }\n>\n> If a monitoring process gets so large that it itself starts to cause system\n> monitor messages when garbage collecting, the messages enlarge the process\n> message queue and probably make the problem worse.\n>\n> Keep the monitoring process neat and do not set the system monitor limits too\n> tight.\n\nFailures:\n\n- **`badarg`** - If `MonitorPid` does not exist.\n\n- **`badarg`** - If `MonitorPid` is not a local process.","ref":"erlang.html#system_monitor/2"},{"type":"type","title":"erlang.system_monitor_option/0","doc":"","ref":"erlang.html#t:system_monitor_option/0"},{"type":"function","title":"erlang.system_profile/0","doc":"Returns the current system profiling settings set by\n[`erlang:system_profile/2`](`system_profile/2`) as `{ProfilerPid, Options}`, or\n`undefined` if there are no settings. The order of the options can be different\nfrom the one that was set.","ref":"erlang.html#system_profile/0"},{"type":"function","title":"erlang.system_profile/2","doc":"Sets system profiler options. `ProfilerPid` is a local process identifier (pid)\nor port receiving profiling messages. The receiver is excluded from all\nprofiling. The second argument is a list of profiling options:\n\n- **`exclusive`** - If a synchronous call to a port from a process is done, the\n  calling process is considered not runnable during the call runtime to the\n  port. The calling process is notified as `inactive`, and later `active` when\n  the port callback returns.\n\n- **`monotonic_timestamp`** - Time stamps in profile messages use\n  [Erlang monotonic time](time_correction.md#erlang-monotonic-time). The time\n  stamp (Ts) has the same format and value as produced by\n  `erlang:monotonic_time(nanosecond)`.\n\n- **`runnable_procs`** - If a process is put into or removed from the run queue,\n  a message, `{profile, Pid, State, Mfa, Ts}`, is sent to `ProfilerPid`. Running\n  processes that are reinserted into the run queue after having been pre-empted\n  do not trigger this message.\n\n- **`runnable_ports`** - If a port is put into or removed from the run queue, a\n  message, `{profile, Port, State, 0, Ts}`, is sent to `ProfilerPid`.\n\n- **`scheduler`** - If a scheduler is put to sleep or awoken, a message,\n  `{profile, scheduler, Id, State, NoScheds, Ts}`, is sent to `ProfilerPid`.\n\n- **`strict_monotonic_timestamp`** - Time stamps in profile messages consist of\n  [Erlang monotonic time](time_correction.md#erlang-monotonic-time) and a\n  monotonically increasing integer. The time stamp (Ts) has the same format and\n  value as produced by\n  `{erlang:monotonic_time(nanosecond), erlang:unique_integer([monotonic])}`.\n\n- **`timestamp`** - Time stamps in profile messages include a time stamp (Ts)\n  that has the same form as returned by `erlang:now()`. This is also the default\n  if no time stamp flag is specified. If `cpu_timestamp` has been enabled\n  through `trace:process/4`, this also effects the time stamp\n  produced in profiling messages when flag `timestamp` is enabled.\n\n> #### Note {: .info }\n>\n> `erlang:system_profile` behavior can change in a future release.","ref":"erlang.html#system_profile/2"},{"type":"type","title":"erlang.system_profile_option/0","doc":"","ref":"erlang.html#t:system_profile_option/0"},{"type":"function","title":"erlang.system_time/0","doc":"Returns current [Erlang system time](time_correction.md#erlang-system-time) in\n`native` [time unit](`t:time_unit/0`).\n\nCalling `erlang:system_time()` is equivalent to\n[`erlang:monotonic_time()`](`monotonic_time/0`)`+`[`erlang:time_offset()`](`time_offset/0`).\n\n> #### Note {: .info }\n>\n> This time is _not_ a monotonically increasing time in the general case. For\n> more information, see the documentation of\n> [time warp modes](time_correction.md#time-warp-modes) in the User's Guide.","ref":"erlang.html#system_time/0"},{"type":"function","title":"erlang.system_time/1","doc":"Returns current [Erlang system time](time_correction.md#erlang-system-time)\nconverted into the `Unit` passed as argument.\n\nCalling `erlang:system_time(Unit)` is equivalent to\n[`erlang:convert_time_unit`](`convert_time_unit/3`)`(`[`erlang:system_time()`](`system_time/0`)`, native, Unit)`.\n\n> #### Note {: .info }\n>\n> This time is _not_ a monotonically increasing time in the general case. For\n> more information, see the documentation of\n> [time warp modes](time_correction.md#time-warp-modes) in the User's Guide.","ref":"erlang.html#system_time/1"},{"type":"type","title":"erlang.term/0","doc":"All possible Erlang terms. Synonym for `t:any/0`.","ref":"erlang.html#t:term/0"},{"type":"function","title":"erlang.term_to_binary/1","doc":"Returns a binary data object that is the result of encoding `Term` according to\nthe [Erlang external term format.](erl_ext_dist.md)\n\nThis can be used for various purposes, for example, writing a term to a file in\nan efficient way, or sending an Erlang term to some type of communications\nchannel not supported by distributed Erlang.\n\n```erlang\n> Bin = term_to_binary(hello).\n<<131,100,0,5,104,101,108,108,111>>\n> hello = binary_to_term(Bin).\nhello\n```\n\nSee also `binary_to_term/1`.\n\n> #### Note {: .info }\n>\n> There is no guarantee that this function will return the same encoded\n> representation for the same term.","ref":"erlang.html#term_to_binary/1"},{"type":"function","title":"erlang.term_to_binary/2","doc":"Returns a binary data object that is the result of encoding `Term` according to\nthe Erlang external term format.\n\nCurrently supported options:\n\n- **`compressed`** - Compress the external term format. The compressed format is\n  automatically recognized by [`binary_to_term/1`](`binary_to_term/1`) as from\n  Erlang/OTP R7B.\n\n- **`{compressed, Level}`** - Compress the external term format to a given\n  level. The compression level is specified by `Level` which is an integer in\n  the range 0..9, where:\n\n  - **`0`** - No compression is done (it is the same as giving no `compressed`\n    option).\n\n  - **`1`** - Takes least time but may not compress as well as the higher\n    levels.\n\n  - **`6`** - Default level when option `compressed` is provided.\n\n  - **`9`** - Takes most time and tries to produce a smaller result. Notice\n    \"tries\" in the preceding sentence; depending on the input term, level 9\n    compression either does or does not produce a smaller result than level 1\n    compression.\n\n- **`{minor_version, Version}`**(Since R11B-4)  \n  The option can be used to control some encoding details. Valid values for\n  `Version` are:\n\n  - **`0`** - Floats are encoded using a textual representation.\n\n    Atoms that can be represented by a latin1 string are encoded using latin1\n    while only atoms that cannot be represented by latin1 are encoded using\n    utf8.\n\n  - **`1`** - Floats are encoded in a more space-efficient and exact way (namely\n    in the 64-bit IEEE format, rather than converted to a textual\n    representation). As from Erlang/OTP R11B-4,\n    [`binary_to_term/1`](`binary_to_term/1`) can decode this representation.\n\n    Atoms that can be represented by a latin1 string are encoded using latin1\n    while only atoms that cannot be represented by latin1 are encoded using\n    utf8.\n\n  - **`2`** - This is as of Erlang/OTP 26.0 the _default_. Atoms are\n    unconditionally encoded using utf8. Erlang/OTP systems as of R16B can decode\n    this representation.\n\n- **`deterministic`**(Since OTP 24.1)  \n  This option can be used to ensure that, within the same major release of\n  Erlang/OTP, the same encoded representation is returned for the same term.\n  There is still no guarantee that the encoded representation remains the same\n  between major releases of Erlang/OTP.\n\n  This option cannot be combined with the `local` option.\n\n- **`local`[](){: #term_to_binary_local } **(Since OTP 26.0)  \n   This option will cause encoding of `Term` to an alternative local version of the\n  external term format which when decoded by the same runtime system instance will\n  produce a term identical to the encoded term even when the node name and/or [creation](#system_info_creation)\n  of the current runtime system instance have changed between encoding and decoding.\n  When encoding without the `local` option, local identifiers such as [pids](`t:pid/0`),\n  [ports](`t:port/0`) and [references](`t:reference/0`) will not be the same if node\n  name and/or creation of the current runtime system instance changed between encoding\n  and decoding. This since such identifiers refer to a specific node by node name\n  and creation.\n\n  Node name and creation of a runtime system instance change when the\n  distribution is started or stopped. The distribution is started when the\n  runtime system is started using the [`-name`](erl_cmd.md#name) or\n  [`-sname`](erl_cmd.md#sname) command line arguments. Note that the actual\n  start of the distribution happens after other code in the startup phase has\n  begun executing. The distribution can also be started by calling\n  `net_kernel:start/2` and stopped by calling\n  [`net_kernel:stop/1`](`net_kernel:stop/0`) if it has not been started via the\n  command line.\n\n  The decoding of a term encoded with the `local` option, using for example\n  [`binary_to_term()`](`term_to_binary/1`), will try to verify that the term\n  actually was encoded by the same runtime system instance, and will in the vast\n  majority of cases fail if the encoding was performed by another runtime system\n  instance. You should however _not_ trust that this verification will work in\n  all cases. You _should_ make sure to _only_ decode terms encoded with the\n  `local` option on the same Erlang runtime system instance as the one that\n  encoded the terms.\n\n  Since it is only the runtime system that encoded a term using the `local`\n  option that can decode it, the local encoding is typically pieced together\n  with something else to produce a reply to where the `local` encoding\n  originates from. If a term encoded using the `local` option is stripped of its\n  leading version number, it can be added as part of a larger term (for example\n  as an element in a tuple) when encoding on the external term format using, for\n  example, [ei](`e:erl_interface:ei.md`). In the `ei` case, you would strip it\n  of the version number using\n  [`ei_decode_version()`](`e:erl_interface:ei.md#ei_decode_version`) and then\n  add the remaining local encoding to what you are encoding using for example\n  [`ei_x_append_buf()`](`e:erl_interface:ei.md#ei_x_append_buf`).\n\n  A good example of when you want to use the `local` option, is when you want to\n  make a request from a process to a port [driver](erl_driver.md) and utilize\n  the\n  [selective receive optimization](`e:system:eff_guide_processes.md#receiving-messages`)\n  when receiving the reply. In this scenario you want to create a reference,\n  serialize the reference on the external term format using the `local` option,\n  pass this to the driver in the request, and then wait for the reply message in\n  a selective receive matching on the reference. The driver should send the\n  reply using either\n  [`erl_drv_output_term()`](erl_driver.md#erl_drv_output_term) or\n  [`erl_drv_send_term()`](erl_driver.md#erl_drv_send_term) using the term type\n  [`ERL_DRV_EXT2TERM`](erl_driver.md#ERL_DRV_EXT2TERM) for the, in the request,\n  previously received reference on the external term format. Note that you\n  should not strip the leading version number from the local encoding when using\n  the term type `ERL_DRV_EXT2TERM` of this functionality. If you in this example\n  do not encode the reference using the `local` option, and the distribution is\n  started or stopped while the request is ongoing, the process that made the\n  request will hang indefinitely since the reference in the reply message will\n  never match.\n\n  This option cannot be combined with the `deterministic` option.\n\n  For more information see the [`LOCAL_EXT`](erl_ext_dist.md#local_ext) tag in\n  the documentation of the external term format.\n\nSee also `binary_to_term/1`.","ref":"erlang.html#term_to_binary/2"},{"type":"function","title":"erlang.term_to_iovec/1","doc":"Returns the encoding of `Term` according to the Erlang external term format as\n`t:ext_iovec/0`.\n\nThis function produce the same encoding as `term_to_binary/1`, but with another\nreturn type. The call\n[`iolist_to_binary(term_to_iovec(Term))`](`iolist_to_binary/1`) will produce\nexactly the same result as the call\n[`term_to_binary(Term)`](`term_to_binary/1`).\n\n`term_to_iovec()` is a pure optimization of the functionality `term_to_binary()`\nprovide. `term_to_iovec()` can for example refer directly to off heap binaries\ninstead of copying the binary data into the result.\n\nSee also `term_to_binary/1`.","ref":"erlang.html#term_to_iovec/1"},{"type":"function","title":"erlang.term_to_iovec/2","doc":"Returns the encoding of `Term` according to the Erlang external term format as\n`t:ext_iovec/0`.\n\nThis function produce the same encoding as `term_to_binary/2`, but with another\nreturn type. The call\n[`iolist_to_binary(term_to_iovec(Term, Opts))`](`iolist_to_binary/1`) will\nproduce exactly the same result as\n[`term_to_binary(Term, Opts)`](`term_to_binary/2`).\n\nCurrently recognised options are all options recognised by `term_to_binary/2`.\n\n`term_to_iovec()` is a pure optimization of the functionality `term_to_binary()`\nprovide. `term_to_iovec()` can for example refer directly to off heap binaries\ninstead of copying the binary data into the result.\n\nSee also `term_to_binary/2`.","ref":"erlang.html#term_to_iovec/2"},{"type":"function","title":"erlang.throw/1","doc":"Raises an exception of class `throw`. Intended to be used to do non-local\nreturns from functions.\n\nIf evaluated within a [catch expression](`e:system:expressions.md#catch-and-throw`), the\ncatch expression returns value `Any`.\n\nFor example:\n\n```erlang\n> catch throw({hello, there}).\n        {hello,there}\n```\n\nIf evaluated within a `try`\\-block of a\n[try expression](`e:system:expressions.md#try`), the value `Any` can be caught\nwithin the catch block.\n\nFor example:\n\n```erlang\ntry\n    throw({my_exception, \"Something happened\"})\ncatch\n    throw:{my_exception, Desc} ->\n        io:format(standard_error, \"Error: ~s~n\", [Desc])\nend\n```\n\nFailure: `nocatch` if not caught by an exception handler.\n\nSee the guide about [errors and error handling](`e:system:errors.md`) for\nadditional information.","ref":"erlang.html#throw/1"},{"type":"function","title":"erlang.time/0","doc":"Returns the current time as `{Hour, Minute, Second}`.\n\nThe time zone and Daylight Saving Time correction depend on the underlying OS.\nThe return value is based on the\n[OS System Time](time_correction.md#os-system-time).\n\nFor example:\n\n```erlang\n> time().\n{9,42,44}\n```","ref":"erlang.html#time/0"},{"type":"function","title":"erlang.time_offset/0","doc":"Returns the current time offset between\n[Erlang monotonic time](time_correction.md#erlang-monotonic-time) and\n[Erlang system time](time_correction.md#erlang-system-time) in `native`\n[time unit](`t:time_unit/0`). Current time offset added to an Erlang\nmonotonic time gives corresponding Erlang system time.\n\nThe time offset may or may not change during operation depending on the\n[time warp mode](time_correction.md#time-warp-modes) used.\n\n> #### Note {: .info }\n>\n> A change in time offset can be observed at slightly different points in time\n> by different processes.\n>\n> If the runtime system is in\n> [multi-time warp mode](time_correction.md#multi-time-warp-mode), the time\n> offset is changed when the runtime system detects that the\n> [OS system time](time_correction.md#os-system-time) has changed. The runtime\n> system will, however, not detect this immediately when it occurs. A task\n> checking the time offset is scheduled to execute at least once a minute; so,\n> under normal operation this is to be detected within a minute, but during\n> heavy load it can take longer time.","ref":"erlang.html#time_offset/0"},{"type":"function","title":"erlang.time_offset/1","doc":"Returns the current time offset between\n[Erlang monotonic time](time_correction.md#erlang-monotonic-time) and\n[Erlang system time](time_correction.md#erlang-system-time) converted into the\n`Unit` passed as argument.\n\nSame as calling\n[`erlang:convert_time_unit`](`convert_time_unit/3`)`(`[ `erlang:time_offset()`](`time_offset/0`)`, native, Unit)`\nhowever optimized for commonly used `Unit`s.","ref":"erlang.html#time_offset/1"},{"type":"type","title":"erlang.time_unit/0","doc":"The time unit used by erlang time APIs.\n\nSupported time unit representations:\n\n- **`PartsPerSecond :: integer() >= 1`** - Time unit expressed in parts per\n  second. That is, the time unit equals `1/PartsPerSecond` second.\n\n- **`second`** - Symbolic representation of the time unit represented by the\n  integer `1`.\n\n- **`millisecond`** - Symbolic representation of the time unit represented by\n  the integer `1000`.\n\n- **`microsecond`** - Symbolic representation of the time unit represented by\n  the integer `1000_000`.\n\n- **`nanosecond`** - Symbolic representation of the time unit represented by the\n  integer `1000_000_000`.\n\n- **`native`** - Symbolic representation of the native time unit used by the\n  Erlang runtime system.\n\n  The `native` time unit is determined at runtime system start, and remains the\n  same until the runtime system terminates. If a runtime system is stopped and\n  then started again (even on the same machine), the `native` time unit of the\n  new runtime system instance can differ from the `native` time unit of the old\n  runtime system instance.\n\n  One can get an approximation of the `native` time unit by calling\n  [`erlang:convert_time_unit(1, second, native)`](`convert_time_unit/3`). The\n  result equals the number of whole `native` time units per second. If the\n  number of `native` time units per second does not add up to a whole number,\n  the result is rounded downwards.\n\n  > #### Note {: .info }\n  >\n  > The value of the `native` time unit gives you more or less no information\n  > about the quality of time values. It sets a limit for the\n  > [resolution](time_correction.md#time-resolution) and for the\n  > [precision](time_correction.md#time-precision) of time values, but it gives\n  > no information about the [accuracy](time_correction.md#time-accuracy) of\n  > time values. The resolution of the `native` time unit and the resolution of\n  > time values can differ significantly.\n\n- **`perf_counter`** - Symbolic representation of the performance counter time\n  unit used by the Erlang runtime system.\n\n  The `perf_counter` time unit behaves much in the same way as the `native` time\n  unit. That is, it can differ between runtime restarts. To get values of this\n  type, call `os:perf_counter/0`.\n\n- **`t:deprecated_time_unit/0`** -\n  Deprecated symbolic representations kept for backwards-compatibility.\n\nThe `t:time_unit/0` type can be extended. To convert time values between time\nunits, use [`erlang:convert_time_unit/3`](`convert_time_unit/3`).","ref":"erlang.html#t:time_unit/0"},{"type":"type","title":"erlang.timeout/0","doc":"A timeout value that can be passed to a\n[receive expression](`e:system:expressions.md#receive`).","ref":"erlang.html#t:timeout/0"},{"type":"type","title":"erlang.timestamp/0","doc":"See [`erlang:timestamp/0`](`timestamp/0`).","ref":"erlang.html#t:timestamp/0"},{"type":"function","title":"erlang.timestamp/0","doc":"Returns current [Erlang system time](time_correction.md#erlang-system-time) on\nthe format `{MegaSecs, Secs, MicroSecs}`.\n\nThis format is the same as `os:timestamp/0` and the deprecated [`erlang:now/0`](`now/0`) use.\nThe reason for the existence of `erlang:timestamp()` is purely to simplify use for existing\ncode that assumes this time stamp format. Current Erlang system time can more\nefficiently be retrieved in the time unit of your choice using\n[`erlang:system_time/1`](`system_time/1`).\n\nThe `erlang:timestamp()` BIF is equivalent to:\n\n```c\ntimestamp() ->\n    ErlangSystemTime = erlang:system_time(microsecond),\n    MegaSecs = ErlangSystemTime div 1000_000_000_000,\n    Secs = ErlangSystemTime div 1000_000 - MegaSecs*1000_000,\n    MicroSecs = ErlangSystemTime rem 1000_000,\n    {MegaSecs, Secs, MicroSecs}.\n```\n\nIt, however, uses a native implementation that does not build garbage on the\nheap and with slightly better performance.\n\n> #### Note {: .info }\n>\n> This time is _not_ a monotonically increasing time in the general case. For\n> more information, see the documentation of\n> [time warp modes](time_correction.md#time-warp-modes) in the User's Guide.","ref":"erlang.html#timestamp/0"},{"type":"function","title":"erlang.tl/1","doc":"Returns the tail of `List`, that is, the list minus the first element\n\nIt works with improper lists.\n\nExamples:\n\n```erlang\n> tl([geesties, guilies, beasties]).\n[guilies, beasties]\n```\n\n```erlang\n> tl([geesties]).\n[]\n```\n\n```erlang\n> tl([geesties, guilies, beasties | improper_end]).\n[guilies, beasties | improper_end]\n```\n\n```erlang\n> tl([geesties | improper_end]).\nimproper_end\n```\n\nFailure: `badarg` if `List` is an empty list `[]`.","ref":"erlang.html#tl/1"},{"type":"function","title":"erlang.trace/3","doc":"Turn on or off trace flags on processes or ports for the static legacy trace session.\n\n  > #### Change {: .info }\n  >\n  > This function is superseded by `trace:process/4` and `trace:port/4` that\n  > operate on dynamic trace sessions.\n\nArgument `FlagList` can contain two additional options:\n\n- **`{tracer, Tracer}`** - Specifies where to send the trace messages. `Tracer`\n  must be the process identifier of a local process or the port identifier of a\n  local port.\n\n- **`{tracer, TracerModule, TracerState}`** - Specifies that a tracer module is\n  to be called instead of sending a trace message. The tracer module can then\n  ignore or change the trace message. For more details on how to write a tracer\n  module, see `m:erl_tracer`.\n\nIf no `tracer` is specified, the calling process receives all the trace\nmessages. The legacy trace session has no specified tracer.\n\nFor further documentation see `trace:process/4` and `trace:port/4`.","ref":"erlang.html#trace/3"},{"type":"function","title":"erlang.trace_delivered/1","doc":"Calling this function makes sure all trace messages have been delivered.\n\nThe delivery of trace messages (generated by [`erlang:trace/3`](`trace/3`),\n`m:seq_trace`, or [`erlang:system_profile/2`](`system_profile/2`)) is dislocated\non the time-line compared to other events in the system. If you know that\n`Tracee` has passed some specific point in its execution, and you want to know\nwhen at least all trace messages corresponding to events up to this point have\nreached the tracer, use `erlang:trace_delivered(Tracee)`.\n\nWhen it is guaranteed that all trace messages are delivered to the tracer up to\nthe point that `Tracee` reached at the time of the call to\n`erlang:trace_delivered(Tracee)`, then a `{trace_delivered, Tracee, Ref}`\nmessage is sent to the caller of `erlang:trace_delivered(Tracee)` .\n\nNotice that message `trace_delivered` does _not_ imply that trace messages have\nbeen delivered. Instead it implies that all trace messages that _are to be\ndelivered_ have been delivered. It is not an error if `Tracee` is not, and has\nnot been traced by someone, but if this is the case, _no_ trace messages have\nbeen delivered when the `trace_delivered` message arrives.\n\nNotice that `Tracee` must refer to a process currently or previously existing on\nthe same node as the caller of `erlang:trace_delivered(Tracee)` resides on. The\nspecial `Tracee` atom `all` denotes all processes that currently are traced in\nthe node.\n\nWhen used together with a [Tracer Module](`m:erl_tracer`), any message sent in\nthe trace callback is guaranteed to have reached its recipient before the\n`trace_delivered` message is sent.\n\nExample: Process `A` is `Tracee`, port `B` is tracer, and process `C` is the\nport owner of `B`. `C` wants to close `B` when `A` exits. To ensure that the\ntrace is not truncated, `C` can call `erlang:trace_delivered(A)` when `A` exits,\nand wait for message `{trace_delivered, A, Ref}` before closing `B`.\n\nFailure: `badarg` if `Tracee` does not refer to a process (dead or alive) on the\nsame node as the caller of `erlang:trace_delivered(Tracee)` resides on.","ref":"erlang.html#trace_delivered/1"},{"type":"type","title":"erlang.trace_flag/0","doc":"","ref":"erlang.html#t:trace_flag/0"},{"type":"function","title":"erlang.trace_info/2","doc":"Returns trace information about a port, process, function, or event for the\nstatic legacy trace session.\n\n  > #### Change {: .info }\n  >\n  > This function is superseded by `trace:info/3` that operates on dynamic trace\n  > sessions.","ref":"erlang.html#trace_info/2"},{"type":"type","title":"erlang.trace_info_flag/0","doc":"","ref":"erlang.html#t:trace_info_flag/0"},{"type":"type","title":"erlang.trace_info_item_result/0","doc":"","ref":"erlang.html#t:trace_info_item_result/0"},{"type":"type","title":"erlang.trace_info_return/0","doc":"","ref":"erlang.html#t:trace_info_return/0"},{"type":"type","title":"erlang.trace_match_spec/0","doc":"","ref":"erlang.html#t:trace_match_spec/0"},{"type":"function","title":"erlang.trace_pattern/2","doc":"Equivalent to [`erlang:trace_pattern(Event, MatchSpec, [])`](`trace_pattern/3`),\nretained for backward compatibility.","ref":"erlang.html#trace_pattern/2"},{"type":"function","title":"erlang.trace_pattern/3","doc":"Set trace pattern for call, send and receive tracing on the static legacy trace\nsession.\n\n  > #### Change {: .info }\n  >\n  > This function is superseded by `trace:function/4`, `trace:send/3` and\n  > `trace:recv/3` that operate on dynamic trace sessions.\n\nArgument `FlagList` can contain two additional options for call tracing:\n\n- **`{meta, Pid} | {meta, TracerModule, TracerState}`** - Turns on or off\n  meta-tracing for all types of function calls. Trace messages are sent to the\n  tracer whenever any of the specified functions are called. If no tracer is\n  specified, `self/0` is used as a default tracer process.\n\nFor further documentation see `trace:function/4` , `trace:send/3` and\n`trace:recv/3`.","ref":"erlang.html#trace_pattern/3"},{"type":"type","title":"erlang.trace_pattern_flag/0","doc":"","ref":"erlang.html#t:trace_pattern_flag/0"},{"type":"type","title":"erlang.trace_pattern_mfa/0","doc":"","ref":"erlang.html#t:trace_pattern_mfa/0"},{"type":"function","title":"erlang.trunc/1","doc":"Truncates the decimals of `Number`.\n\nFor example:\n\n```erlang\n> trunc(5.7).\n5\n```\n\n```erlang\n> trunc(-5.7).\n-5\n```\n\n```erlang\n> trunc(5).\n5\n```\n\n```erlang\n> trunc(36028797018963969.0).\n36028797018963968\n```\n\nIn the last example, [`trunc(36028797018963969.0)`](`trunc/1`) evaluates to\n`36028797018963968`. The reason for this is that the number\n`36028797018963969.0` cannot be represented exactly as a float value. Instead,\nthe float literal is represented as `36028797018963968.0`, which is the closest\nnumber that can be represented exactly as a float value. See\n[Representation of Floating Point Numbers](`e:system:data_types.md#float_representation_problem`)\nfor additional information.","ref":"erlang.html#trunc/1"},{"type":"type","title":"erlang.tuple/0","doc":"An Erlang [tuple](`e:system:data_types.md#tuple`).","ref":"erlang.html#t:tuple/0"},{"type":"function","title":"erlang.tuple_size/1","doc":"Returns an integer that is the number of elements in `Tuple`.\n\nFor example:\n\n```erlang\n> tuple_size({morni, mulle, bwange}).\n3\n```","ref":"erlang.html#tuple_size/1"},{"type":"function","title":"erlang.tuple_to_list/1","doc":"Returns a list corresponding to `Tuple`. `Tuple` can contain any Erlang terms.\nExample:\n\n```erlang\n> tuple_to_list({share, {'Ericsson_B', 163}}).\n[share,{'Ericsson_B',163}]\n```","ref":"erlang.html#tuple_to_list/1"},{"type":"function","title":"erlang.unalias/1","doc":"Deactivate the alias `Alias` previously created by the calling process.\n\nAn alias can, for example, be created via `alias/0` or `monitor/3`.\n[`unalias/1`](`unalias/1`) will always deactivate the alias regardless of\noptions used when creating the alias.\n\nReturns true if `Alias` was a currently active alias for current processes;\notherwise, false.\n\nFor more information on process aliases see the\n[_Process Aliases_](`e:system:ref_man_processes.md#process-aliases`) section of\nthe _Erlang Reference Manual_.","ref":"erlang.html#unalias/1"},{"type":"function","title":"erlang.unique_integer/0","doc":"Generates and returns an\n[integer unique on current runtime system instance](`e:system:system_limits.md#unique_integers`).\nEquivalent to calling [`erlang:unique_integer([])`](`unique_integer/1`).","ref":"erlang.html#unique_integer/0"},{"type":"function","title":"erlang.unique_integer/1","doc":"Generates and returns an\n[integer unique on current runtime system instance](`e:system:system_limits.md#unique_integers`).\nThe integer is unique in the sense that this BIF, using the same set of\nmodifiers, does not return the same integer more than once on the current\nruntime system instance. Each integer value can of course be constructed by\nother means.\n\nBy default, when `[]` is passed as `ModifierList`, both negative and positive\nintegers can be returned. This to use the range of integers that do not need\nheap memory allocation as much as possible. By default the returned integers are\nalso only guaranteed to be unique, that is, any returned integer can be smaller\nor larger than previously returned integers.\n\n`Modifier`s:\n\n- **positive** - Returns only positive integers.\n\n  Notice that by passing the `positive` modifier you will get heap allocated\n  integers (bignums) quicker.\n\n- **monotonic** - Returns\n  [strictly monotonically increasing](time_correction.md#strictly-monotonically-increasing)\n  integers corresponding to creation time. That is, the integer returned is\n  always larger than previously returned integers on the current runtime system\n  instance.\n\n  These values can be used to determine order between events on the runtime\n  system instance. That is, if both `X = erlang:unique_integer([monotonic])` and\n  `Y = erlang:unique_integer([monotonic])` are executed by different processes\n  (or the same process) on the same runtime system instance and `X   #### Warning {: .warning }\n  >\n  > Strictly monotonically increasing values are inherently quite expensive to\n  > generate and scales poorly. This is because the values need to be\n  > synchronized between CPU cores. That is, do not pass the `monotonic`\n  > modifier unless you really need strictly monotonically increasing values.\n\nAll valid `Modifier`s can be combined. Repeated (valid) `Modifier`s in the\n`ModifierList` are ignored.\n\n> #### Note {: .info }\n>\n> The set of integers returned by `erlang:unique_integer/1` using different sets\n> of `Modifier`s _will overlap_. For example, by calling\n> [`unique_integer([monotonic])`](`unique_integer/1`), and\n> [`unique_integer([positive, monotonic])`](`unique_integer/1`) repeatedly, you\n> will eventually see some integers that are returned by both calls.\n\nFailures:\n\n- **`badarg`** - if `ModifierList` is not a proper list.\n\n- **`badarg`** - if `Modifier` is not a valid modifier.","ref":"erlang.html#unique_integer/1"},{"type":"function","title":"erlang.universaltime/0","doc":"Returns the current date and time according to Universal Time Coordinated (UTC)\nin the form `{{Year, Month, Day}, {Hour, Minute, Second}}` if supported by the\nunderlying OS. Otherwise `erlang:universaltime()` is equivalent to\n`erlang:localtime()`. The return value is based on the\n[OS System Time](time_correction.md#os-system-time).\n\nFor example:\n\n```erlang\n> erlang:universaltime().\n{{1996,11,6},{14,18,43}}\n```","ref":"erlang.html#universaltime/0"},{"type":"function","title":"erlang.universaltime_to_localtime/1","doc":"Converts Universal Time Coordinated (UTC) date and time to local date and time\nin the form `{{Year, Month, Day}, {Hour, Minute, Second}}` if supported by the\nunderlying OS. Otherwise no conversion is done, and `Universaltime` is returned.\n\nFor example:\n\n```erlang\n> erlang:universaltime_to_localtime({{1996,11,6},{14,18,43}}).\n{{1996,11,7},{15,18,43}}\n```\n\nFailure: `badarg` if `Universaltime` denotes an invalid date and time.","ref":"erlang.html#universaltime_to_localtime/1"},{"type":"function","title":"erlang.unlink/1","doc":"Removes a link between the calling process and another process or a port\nidentified by `Id`.\n\nWe will from here on call the identified process or port unlinkee.\n\nA link can be set up using the `link/1` BIF. For more information on links and\nexit signals due to links, see the _Processes_ chapter in the _Erlang Reference\nManual_:\n\n- [Links](`e:system:ref_man_processes.md#links`)\n- [Sending Exit Signals](`e:system:ref_man_processes.md#sending_exit_signals`)\n- [Receiving Exit Signals](`e:system:ref_man_processes.md#receiving_exit_signals`)\n\nOnce [`unlink(Id)`](`unlink/1`) has returned, it is guaranteed that the link\nbetween the caller and the unlinkee has no effect on the caller in the future\n(unless the link is setup again). Note that if the caller is\n[trapping exits](#process_flag_trap_exit), an\n`{'EXIT', Id, ExitReason}` message due to the link may have been placed in the\nmessage queue of the caller before the [`unlink(Id)`](`unlink/1`) call\ncompleted. Also note that the `{'EXIT', Id, ExitReason}` message may be the\nresult of the link, but may also be the result of the unlikee sending the caller\nan exit signal by calling the `exit/2` BIF. Therefore, it may or may not be\nappropriate to clean up the message queue after a call to\n[`unlink(Id)`](`unlink/1`) as follows, when trapping exits:\n\n```erlang\nunlink(Id),\nreceive\n    {'EXIT', Id, _} ->\n        true\nafter 0 ->\n        true\nend\n```\n\nThe link removal is performed asynchronously. If such a link does not exist,\nnothing is done. A detailed description of the\n[link protocol](erl_dist_protocol.md#link_protocol) can be found in the\n_Distribution Protocol_ chapter of the _ERTS User's Guide_.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [_Blocking Signaling Over Distribution_](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_.\n\nFailure: `badarg` if `Id` does not identify a process or a node local port.","ref":"erlang.html#unlink/1"},{"type":"function","title":"erlang.unregister/1","doc":"Removes the [`registered name`](`register/2`) `RegName` associated with a\nprocess identifier or a port identifier from the\n[`name registry`](`e:system:ref_man_processes.md#runtime-service`).\n\nFor example:\n\n```erlang\n> unregister(db).\ntrue\n```\n\nKeep in mind that you can still receive signals associated with the registered\nname after it has been unregistered as the sender may have looked up the name\nbefore sending to it.\n\nUsers are advised not to unregister system processes.\n\nFailure: `badarg` if `RegName` is not a registered name.","ref":"erlang.html#unregister/1"},{"type":"function","title":"erlang.whereis/1","doc":"Returns the process identifier or port identifier with the\n[`registered name`](`register/2`) `RegName` from the\n[`name registry`](`e:system:ref_man_processes.md#runtime-service`). Returns\n`undefined` if the name is not registered.\n\nFor example:\n\n```erlang\n> whereis(db).\n<0.43.0>\n```","ref":"erlang.html#whereis/1"},{"type":"function","title":"erlang.yield/0","doc":"Tries to give other processes with the same or higher priority (if any) a chance\nto execute before returning. There is no guarantee that any other process runs\nbetween the invocation and return of `erlang:yield/0`.\n\nSee the documentation for\n[`receive-after` expressions](`e:system:expressions.md#receive`) for how to make\nthe current process sleep for a specific number of milliseconds.\n\n> #### Warning {: .warning }\n>\n> There is seldom or never any need to use this BIF. Using this BIF without a\n> thorough grasp of how the scheduler works can cause performance degradation.\n> The current implementation of this function puts the current process last in\n> the current scheduler's queue for processes of the same priority as the\n> current process.","ref":"erlang.html#yield/0"},{"type":"module","title":"init","doc":"Coordination of system startup.\n\nThis module is preloaded and contains the code for the `init` system process\nthat coordinates the startup of the system. The first function evaluated at\nstartup is [`boot(BootArgs)`](`boot/1`), where `BootArgs` is a list of\ncommand-line arguments supplied to the Erlang runtime system from the local\noperating system; see [`erl(1)`](erl_cmd.md).\n\n`init` reads the boot script, which contains instructions on how to initiate the\nsystem. For more information about boot scripts, see\n[`script(4)`](`e:sasl:script.md`).\n\n`init` also contains functions to restart, reboot, and stop the system.\n\n[](){: #flags }","ref":"init.html"},{"type":"module","title":"Command-Line Flags - init","doc":"> #### Warning {: .warning }\n>\n> The support for loading of code from archive files is experimental. The only\n> purpose of releasing it before it is ready is to obtain early feedback. The\n> file format, semantics, interfaces, and so on, can be changed in a future\n> release.\n\nThe `init` module interprets the following command-line flags:\n\n- **`--`** - Everything following `--` up to the next flag is considered plain\n  arguments and can be retrieved using `get_plain_arguments/0`.\n\n- **`-code_path_choice Choice`** - Can be set to `strict` or `relaxed`. It\n  controls how each directory in the code path is to be interpreted:\n\n  - Strictly as it appears in the `boot script`, or\n  - `init` is to be more relaxed and try to find a suitable directory if it can\n    choose from a regular `ebin` directory and an `ebin` directory in an archive\n    file.\n\n  It defaults to `strict` from OTP 27 and this option is scheduled for removal\n  in OTP 28.\n\n- **`-epmd_module Module`** - This flag is deprecated and has been replaced by\n  the `kernel` application parameter [`epmd_module`](`e:kernel:kernel_app.md#epmd_module`).\n\n- **`-eval Expr`** - Scans, parses, and evaluates an arbitrary expression `Expr`\n  during system initialization. If any of these steps fail (syntax error, parse\n  error, or exception during evaluation), Erlang stops with an error message. In\n  the following example Erlang is used as a hexadecimal calculator:\n\n  ```text\n  % erl -noshell -eval 'R = 16#1F+16#A0, io:format(\"~.16B~n\", [R])' \\\\\n  -s erlang halt\n  BF\n  ```\n\n  If multiple `-eval` expressions are specified, they are evaluated sequentially\n  in the order specified. `-eval` expressions are evaluated sequentially with\n  `-s` and `-run` function calls (this also in the order specified). As with\n  `-s` and `-run`, an evaluation that does not terminate blocks the system\n  initialization process.\n\n- **`-extra`** - Everything following `-extra` is considered plain arguments and\n  can be retrieved using `get_plain_arguments/0`.\n\n  Example:\n\n  ```erlang\n  % erl -extra +A 1 --\n  ...\n  1> init:get_plain_arguments().\n  [\"+A\",\"1\",\"--\"]\n  ```\n\n  The `-extra` flag can be passed on the command line, through `ERL_*FLAGS` or\n  `-args_file`. It only effects the remaining command-line flags in the entity\n  in which it is passed. If multiple `-extra` flags are passed they are\n  concatenated using the same order rules as `ERL_*FLAGS` or `-args_file` in\n  which they are given.\n\n  Example:\n\n  ```text\n  % ERL_AFLAGS=\"-extra a\" ERL_ZFLAGS=\"-extra d\" erl -extra b -extra c\n  ...\n  1> init:get_plain_arguments().\n  [\"a\",\"b\",\"-extra\",\"c\",\"d\"]\n  ```\n\n- **`-S Mod [Func [Arg1, Arg2, ...]]`** - Evaluates the specified function call\n  during system initialization. `Func` defaults to `start`. If no arguments are\n  provided, the function is assumed to be of arity 0. Otherwise it is assumed to\n  be of arity 1, taking the list `[Arg1,Arg2,...]` as argument. All arguments\n  are passed as strings. If an exception is raised, Erlang stops with an error\n  message.\n\n  Example:\n\n  ```text\n  % erl -S httpd serve --port 8080 /var/www/html\n  ```\n\n  This starts the Erlang runtime system and evaluates the function\n  `httpd:serve([\"--port\", \"8080\", \"/var/www/html\"])`. All arguments up to the\n  end of the command line will be passed to the called function.\n\n  The function is executed sequentially in an initialization process, which then\n  terminates normally and passes control to the user. This means that a `-S`\n  call that does not return blocks further processing; to avoid this, use some\n  variant of `spawn` in such cases.\n\n  The `-S` flag is only allowed on the command line. If passed through\n  `ERL_*FLAGS` or `-args_file` it will be parsed as a normal command line flag.\n\n- **`-run Mod [Func [Arg1, Arg2, ...]]`** - Evaluates the specified function\n  call during system initialization. `Func` defaults to `start`. If no arguments\n  are provided, the function is assumed to be of arity 0. Otherwise it is\n  assumed to be of arity 1, taking the list `[Arg1,Arg2,...]` as argument. All\n  arguments are passed as strings. If an exception is raised, Erlang stops with\n  an error message.\n\n  Example:\n\n  ```text\n  % erl -run foo -run foo bar -run foo bar baz 1 2\n  ```\n\n  This starts the Erlang runtime system and evaluates the following functions:\n\n  ```text\n  foo:start()\n  foo:bar()\n  foo:bar([\"baz\", \"1\", \"2\"]).\n  ```\n\n  The functions are executed sequentially in an initialization process, which\n  then terminates normally and passes control to the user. This means that a\n  `-run` call that does not return blocks further processing; to avoid this, use\n  some variant of `spawn` in such cases.\n\n  > #### Note {: .info }\n  >\n  > This flag will not forward arguments beginning with a hyphen (-) to the\n  > specified function, as these will be interpreted as flags to the runtime. If\n  > the function uses flags in this form, it is advised to use `-S` instead.\n\n- **`-s Mod [Func [Arg1, Arg2, ...]]`** - Evaluates the specified function call\n  during system initialization. `Func` defaults to `start`. If no arguments are\n  provided, the function is assumed to be of arity 0. Otherwise it is assumed to\n  be of arity 1, taking the list `[Arg1,Arg2,...]` as argument. All arguments\n  are passed as atoms. If an exception is raised, Erlang stops with an error\n  message.\n\n  Example:\n\n  ```text\n  % erl -s foo -s foo bar -s foo bar baz 1 2\n  ```\n\n  This starts the Erlang runtime system and evaluates the following functions:\n\n  ```text\n  foo:start()\n  foo:bar()\n  foo:bar([baz, '1', '2']).\n  ```\n\n  The functions are executed sequentially in an initialization process, which\n  then terminates normally and passes control to the user. This means that a\n  `-s` call that does not return blocks further processing; to avoid this, use\n  some variant of `spawn` in such cases.\n\n  Because of the limited length of atoms, it is recommended to use `-run`\n  instead.\n\n  > #### Note {: .info }\n  >\n  > This flag will not forward arguments beginning with a hyphen (-) to the\n  > specified function, as these will be interpreted as flags to the runtime. If\n  > the function uses flags in this form, it is advised to use `-S` instead,\n  > with the additional caveat that arguments are passed as strings instead of\n  > atoms.","ref":"init.html#module-command-line-flags"},{"type":"module","title":"Example - init","doc":"```erlang\n% erl -- a b -children thomas claire -ages 7 3 -- x y\n...\n\n1> init:get_plain_arguments().\n[\"a\",\"b\",\"x\",\"y\"]\n2> init:get_argument(children).\n{ok,[[\"thomas\",\"claire\"]]}\n3> init:get_argument(ages).\n{ok, [[\"7\",\"3\"]]}\n4> init:get_argument(silly).\nerror\n```","ref":"init.html#module-example"},{"type":"module","title":"See Also - init","doc":"`m:erl_prim_loader`, `m:heart`","ref":"init.html#module-see-also"},{"type":"function","title":"init.boot/1","doc":"Starts the Erlang runtime system.\n\nThis function is called when the emulator is started and coordinates system startup.\n\n`BootArgs` are all command-line arguments except the emulator flags, that is,\nflags and plain arguments; see [`erl(1)`](erl_cmd.md).\n\n`init` interprets some of the flags, see section\n[Command-Line Flags](`m:init#flags`) below. The remaining flags (\"user flags\")\nand plain arguments are passed to the `init` loop and can be retrieved by\ncalling `get_arguments/0` and `get_plain_arguments/0`, respectively.","ref":"init.html#boot/1"},{"type":"function","title":"init.get_argument/1","doc":"Returns all values associated with the command-line user flag `Flag`.\n\nIf `Flag` is provided several times, each `Values` is returned in preserved order.\nExample:\n\n```erlang\n% erl -a b c -a d\n...\n1> init:get_argument(a).\n{ok,[[\"b\",\"c\"],[\"d\"]]}\n```\n\nThe following flags are defined automatically and can be retrieved using this\nfunction:\n\n- **`root`** - The installation directory of Erlang/OTP, `$ROOT`:\n\n  ```text\n  2> init:get_argument(root).\n  {ok,[[\"/usr/local/otp/releases/otp_beam_solaris8_r10b_patched\"]]}\n  ```\n\n- **`progname`** - The name of the program which started Erlang:\n\n  ```erlang\n  3> init:get_argument(progname).\n  {ok,[[\"erl\"]]}\n  ```\n\n- **`home`{: #home }** - The home directory (on Unix, the value of $HOME):\n\n  ```erlang\n  4> init:get_argument(home).\n  {ok,[[\"/home/harry\"]]}\n  ```\n\nReturns `error` if no value is associated with `Flag`.","ref":"init.html#get_argument/1"},{"type":"function","title":"init.get_arguments/0","doc":"Returns all command-line flags and the system-defined flags, see\n`get_argument/1`.","ref":"init.html#get_arguments/0"},{"type":"function","title":"init.get_plain_arguments/0","doc":"Returns any plain command-line arguments as a list of strings (possibly empty).","ref":"init.html#get_plain_arguments/0"},{"type":"function","title":"init.get_status/0","doc":"The current status of the `init` process can be inspected.\n\nDuring system startup (initialization), `InternalStatus` is `starting`, and\n`ProvidedStatus` indicates how far the boot script has been interpreted. Each\n`{progress, Info}` term interpreted in the boot script affects `ProvidedStatus`,\nthat is, `ProvidedStatus` gets the value of `Info`.","ref":"init.html#get_status/0"},{"type":"type","title":"init.internal_status/0","doc":"Current status of init.","ref":"init.html#t:internal_status/0"},{"type":"type","title":"init.mode/0","doc":"Code loading mode.","ref":"init.html#t:mode/0"},{"type":"function","title":"init.reboot/0","doc":"Reboot the Erlang node.\n\nAll applications are taken down smoothly, all code is unloaded, and all ports\nare closed before the system terminates.\n\nIf command-line flag `-heart` was specified, the `heart` program tries to reboot\n the system. For more information, see `m:heart`.\n\nTo limit the shutdown time, the time `init` is allowed to spend taking down\napplications, command-line flag `-shutdown_time` is to be used.","ref":"init.html#reboot/0"},{"type":"function","title":"init.restart/0","doc":"The same as [`restart([])`](`restart/1`).","ref":"init.html#restart/0"},{"type":"function","title":"init.restart/1","doc":"Restart all Erlang applications.\n\nThe system is restarted _inside_ the running Erlang node, which means that the\nemulator is not restarted. All applications are taken down smoothly, all code is\nunloaded, and all ports are closed before the system is booted again in the same\nway as initially started.\n\nThe same `BootArgs` are used when restarting the system unless the `mode` option\nis given, allowing the code loading mode to be set to either `embedded` or\n`interactive`. All other `BootArgs` remain the same.\n\nTo limit the shutdown time, the time `init` is allowed to spend taking down\napplications, command-line flag `-shutdown_time` is to be used.","ref":"init.html#restart/1"},{"type":"function","title":"init.script_id/0","doc":"Gets the identity of the boot script used to boot the system.\n\n`Id` can be any Erlang term. In the delivered boot scripts, `Id` is `{Name, Vsn}`.\n`Name` and `Vsn` are strings.","ref":"init.html#script_id/0"},{"type":"function","title":"init.stop/0","doc":"The same as [`stop(0)`](`stop/1`).","ref":"init.html#stop/0"},{"type":"function","title":"init.stop/1","doc":"Stop the Erlang node.\n\nAll applications are taken down smoothly, all code is unloaded, and all ports\nare closed before the system terminates by calling [`halt(Status)`](`halt/1`).\nIf command-line flag `-heart` was specified, the `heart` program is terminated\nbefore the Erlang node terminates. For more information, see `m:heart`.\n\nTo limit the shutdown time, the time `init` is allowed to spend taking down\napplications, command-line flag `-shutdown_time` is to be used.","ref":"init.html#stop/1"},{"type":"module","title":"persistent_term","doc":"Persistent terms.\n\nThis module is similar to `m:ets` in that it provides a storage for Erlang terms\nthat can be accessed in constant time, but with the difference that\n`persistent_term` has been highly optimized for reading terms at the expense of\nwriting and updating terms. When a persistent term is updated or deleted, a\nglobal garbage collection pass is run to scan all processes for the deleted\nterm, and to copy it into each process that still uses it. Therefore,\n`persistent_term` is suitable for storing Erlang terms that are frequently\naccessed but never or infrequently updated.\n\n> #### Warning {: .warning }\n>\n> Persistent terms is an advanced feature and is not a general replacement for\n> ETS tables. Before using persistent terms, make sure to fully understand the\n> consequence to system performance when updating or deleting persistent terms.\n\nTerm lookup (using `get/1`) is done in constant time and without taking any\nlocks, and the term is **not** copied to the heap (as is the case with terms\nstored in ETS tables).\n\nStoring or updating a term (using `put/2`) is proportional to the number of\nalready created persistent terms because the hash table holding the keys will be\ncopied. In addition, the term itself will be copied.\n\nWhen a (complex) term is deleted (using `erase/1`) or replaced by another (using\n`put/2`), a global garbage collection is initiated. It works like this:\n\n- All processes in the system will be scheduled to run a scan of their heaps for\n  the term that has been deleted. While such scan is relatively light-weight, if\n  there are many processes, the system can become less responsive until all\n  processes have scanned their heaps.\n- If the deleted term (or any part of it) is still used by a process, that\n  process will do a major (fullsweep) garbage collection and copy the term into\n  the process. However, at most two processes at a time will be scheduled to do\n  that kind of garbage collection.\n\nDeletion of atoms and other terms that fit in one machine word is specially\noptimized to avoid doing a global GC. It is still not recommended to update\npersistent terms with such values too frequently because the hash table holding\nthe keys is copied every time a persistent term is updated.\n\nSome examples are suitable uses for persistent terms are:\n\n- Storing of configuration data that must be easily accessible by all processes.\n- Storing of references for NIF resources.\n- Storing of references for efficient counters.\n- Storing an atom to indicate a logging level or whether debugging is turned on.","ref":"persistent_term.html"},{"type":"module","title":"Storing Huge Persistent Terms - persistent_term","doc":"The current implementation of persistent terms uses the literal\n[allocator](erts_alloc.md) also used for literals (constant terms) in BEAM code.\nBy default, 1 GB of virtual address space is reserved for literals in BEAM code\nand persistent terms. The amount of virtual address space reserved for literals\ncan be changed by using the [`+MIscs option`](erts_alloc.md#MIscs) when starting\nthe emulator.\n\nHere is an example how the reserved virtual address space for literals can be\nraised to 2 GB (2048 MB):\n\n```text\n    erl +MIscs 2048\n```","ref":"persistent_term.html#module-storing-huge-persistent-terms"},{"type":"module","title":"Best Practices for Using Persistent Terms - persistent_term","doc":"It is recommended to use keys like `?MODULE` or `{?MODULE,SubKey}` to avoid name\ncollisions.\n\nPrefer creating a few large persistent terms to creating many small persistent\nterms. The execution time for storing a persistent term is proportional to the\nnumber of already existing terms.\n\nUpdating a persistent term with the same value as it already has is specially\noptimized to do nothing quickly; thus, there is no need compare the old and new\nvalues and avoid calling `put/2` if the values are equal.\n\nWhen atoms or other terms that fit in one machine word are deleted, no global GC\nis needed. Therefore, persistent terms that have atoms as their values can be\nupdated more frequently, but note that updating such persistent terms is still\nmuch more expensive than reading them.\n\nUpdating or deleting a persistent term will trigger a global GC if the term does\nnot fit in one machine word. Processes will be scheduled as usual, but all\nprocesses will be made runnable at once, which will make the system less\nresponsive until all processes have run and scanned their heaps for the deleted\nterms. One way to minimize the effects on responsiveness could be to minimize\nthe number of processes on the node before updating or deleting a persistent\nterm. It would also be wise to avoid updating terms when the system is at peak\nload.\n\nAvoid storing a retrieved persistent term in a process if that persistent term\ncould be deleted or updated in the future. If a process holds a reference to a\npersistent term when the term is deleted, the process will be garbage collected\nand the term copied to the process.\n\nAvoid updating or deleting more than one persistent term at a time. Each deleted\nterm will trigger its own global GC. That means that deleting N terms will make\nthe system less responsive N times longer than deleting a single persistent\nterm. Therefore, terms that are to be updated at the same time should be\ncollected into a larger term, for example, a map or a tuple.","ref":"persistent_term.html#module-best-practices-for-using-persistent-terms"},{"type":"module","title":"Example - persistent_term","doc":"The following example shows how lock contention for ETS tables can be minimized\nby having one ETS table for each scheduler. The table identifiers for the ETS\ntables are stored as a single persistent term:\n\n```erlang\n    %% There is one ETS table for each scheduler.\n    Sid = erlang:system_info(scheduler_id),\n    Tid = element(Sid, persistent_term:get(?MODULE)),\n    ets:update_counter(Tid, Key, 1).\n```","ref":"persistent_term.html#module-example"},{"type":"function","title":"persistent_term.erase/1","doc":"Erase the name for the persistent term with key `Key`.\n\nThe return value will be `true` if there was a persistent term with the key `Key`,\nand `false` if there was no persistent term associated with the key.\n\nIf there existed a previous persistent term associated with key `Key`, a global\nGC has been initiated when [`erase/1`](`erase/1`) returns. See\n[Description](`m:persistent_term`).","ref":"persistent_term.html#erase/1"},{"type":"function","title":"persistent_term.get/0","doc":"Retrieve the keys and values for all persistent terms.\n\nThe keys will be copied to the heap for the process calling `get/0`,\nbut the values will not.","ref":"persistent_term.html#get/0"},{"type":"function","title":"persistent_term.get/1","doc":"Retrieve the value for the persistent term associated with the key `Key`.\n\nThe lookup will be made in constant time and the value will not be copied to the\nheap of the calling process.\n\nThis function fails with a `badarg` exception if no term has been stored with\nthe key `Key`.\n\nIf the calling process holds on to the value of the persistent term and the\npersistent term is deleted in the future, the term will be copied to the\nprocess.","ref":"persistent_term.html#get/1"},{"type":"function","title":"persistent_term.get/2","doc":"Retrieve the value for the persistent term associated with the key `Key`.\n\nThe lookup will be made in constant time and the value will not be copied to the\nheap of the calling process.\n\nThis function returns `Default` if no term has been stored with the key `Key`.\n\nIf the calling process holds on to the value of the persistent term and the\npersistent term is deleted in the future, the term will be copied to the\nprocess.","ref":"persistent_term.html#get/2"},{"type":"function","title":"persistent_term.info/0","doc":"Return information about persistent terms in a map.\n\nThe map has the following keys:\n\n- **`count`** - The number of persistent terms.\n\n- **`memory`** - The total amount of memory (measured in bytes) used by all\n  persistent terms.","ref":"persistent_term.html#info/0"},{"type":"type","title":"persistent_term.key/0","doc":"Any Erlang term.","ref":"persistent_term.html#t:key/0"},{"type":"function","title":"persistent_term.put/2","doc":"Store the value `Value` as a persistent term and associate it with the key\n`Key`.\n\nIf the value `Value` is equal to the value previously stored for the key,\n[`put/2`](`put/2`) will do nothing and return quickly.\n\nIf there existed a previous persistent term associated with key `Key`, a global\nGC has been initiated when [`put/2`](`put/2`) returns. See\n[Description](`m:persistent_term`).","ref":"persistent_term.html#put/2"},{"type":"type","title":"persistent_term.value/0","doc":"Any Erlang term.","ref":"persistent_term.html#t:value/0"},{"type":"module","title":"zlib","doc":"zlib compression interface.\n\nThis module provides an API for the zlib library\n([www.zlib.net](http://www.zlib.net)). It is used to compress and decompress\ndata. The data format is described by\n[RFC 1950](https://www.ietf.org/rfc/rfc1950.txt),\n[RFC 1951](https://www.ietf.org/rfc/rfc1951.txt), and\n[RFC 1952](https://www.ietf.org/rfc/rfc1952.txt).\n\nA typical (compress) usage is as follows:\n\n```erlang\nZ = zlib:open(),\nok = zlib:deflateInit(Z,default),\n\nCompress = fun(end_of_data, _Cont) -> [];\n              (Data, Cont) ->\n                 [zlib:deflate(Z, Data)|Cont(Read(),Cont)]\n           end,\nCompressed = Compress(Read(),Compress),\nLast = zlib:deflate(Z, [], finish),\nok = zlib:deflateEnd(Z),\nzlib:close(Z),\nlist_to_binary([Compressed|Last])\n```\n\nIn all functions errors, `{'EXIT',{Reason,Backtrace}}`, can be thrown, where\n`Reason` describes the error.\n\nTypical `Reason`s:\n\n- **`badarg`** - Bad argument.\n\n- **`not_initialized`** - The stream hasn't been initialized, eg. if\n  `inflateInit/1` wasn't called prior to a call to `inflate/2`.\n\n- **`not_on_controlling_process`** - The stream was used by a process that\n  doesn't control it. Use `set_controlling_process/2` if you need to transfer a\n  stream to a different process.\n\n- **`data_error`** - The data contains errors.\n\n- **`stream_error`** - Inconsistent stream state.\n\n- **`{need_dictionary,Adler32}`** - See `inflate/2`.","ref":"zlib.html"},{"type":"function","title":"zlib.close/1","doc":"Closes the stream referenced by `Z`.","ref":"zlib.html#close/1"},{"type":"function","title":"zlib.compress/1","doc":"Compresses data with zlib headers and checksum.","ref":"zlib.html#compress/1"},{"type":"function","title":"zlib.deflate/2","doc":"Same as [`deflate(Z, Data, none)`](`deflate/3`).","ref":"zlib.html#deflate/2"},{"type":"function","title":"zlib.deflate/3","doc":"Compresses as much data as possible, and stops when the input buffer becomes\nempty.\n\nIt can introduce some output latency (reading input without producing any\noutput) except when forced to flush.\n\nIf `Flush` is set to `sync`, all pending output is flushed to the output buffer\nand the output is aligned on a byte boundary, so that the decompressor can get\nall input data available so far. Flushing can degrade compression for some\ncompression algorithms; thus, use it only when necessary.\n\nIf `Flush` is set to `full`, all output is flushed as with `sync`, and the\ncompression state is reset so that decompression can restart from this point if\nprevious compressed data has been damaged or if random access is desired. Using\n`full` too often can seriously degrade the compression.\n\nIf `Flush` is set to `finish`, pending input is processed, pending output is\nflushed, and [`deflate/3`](`deflate/3`) returns. Afterwards the only possible\noperations on the stream are `deflateReset/1` or `deflateEnd/1`.\n\n`Flush` can be set to `finish` immediately after\n[`deflateInit`](`deflateInit/1`) if all compression is to be done in one step.\n\nExample:\n\n```erlang\nzlib:deflateInit(Z),\nB1 = zlib:deflate(Z,Data),\nB2 = zlib:deflate(Z,<< >>,finish),\nzlib:deflateEnd(Z),\nlist_to_binary([B1,B2])\n```","ref":"zlib.html#deflate/3"},{"type":"function","title":"zlib.deflateEnd/1","doc":"Ends the deflate session and cleans all data used.\n\nNotice that this function throws a `data_error` exception if the last call to\n`deflate/3` was not called with `Flush` set to `finish`.","ref":"zlib.html#deflateEnd/1"},{"type":"function","title":"zlib.deflateInit/1","doc":"Same as `zlib:deflateInit(Z, default)`.","ref":"zlib.html#deflateInit/1"},{"type":"function","title":"zlib.deflateInit/2","doc":"Initializes a zlib stream for compression.\n\n`Level` decides the compression level to be used:\n\n- `default` gives default compromise between speed and compression\n- `none` (0) gives no compression\n- `best_speed` (1) gives best speed\n- `best_compression` (9) gives best compression","ref":"zlib.html#deflateInit/2"},{"type":"function","title":"zlib.deflateInit/6","doc":"Initiates a zlib stream for compression.\n\n- **`Level`** - Compression level to use:\n\n  - `default` gives default compromise between speed and compression\n  - `none` (0) gives no compression\n  - `best_speed` (1) gives best speed\n  - `best_compression` (9) gives best compression\n\n- **`Method`** - Compression method to use, currently the only supported method\n  is `deflated`.\n\n- **`WindowBits`** - The base two logarithm of the window size (the size of the\n  history buffer). It is to be in the range 8 through 15. Larger values result\n  in better compression at the expense of memory usage. Defaults to 15 if\n  `deflateInit/2` is used. A negative `WindowBits` value suppresses the zlib\n  header (and checksum) from the stream. Notice that the zlib source mentions\n  this only as a undocumented feature.\n\n  > #### Warning {: .warning }\n  >\n  > Due to a known bug in the underlying zlib library, `WindowBits` values 8 and\n  > -8 do not work as expected. In zlib versions before 1.2.9 values 8 and -8\n  > are automatically changed to 9 and -9. _From zlib version 1.2.9 value -8 is\n  > rejected_ causing `zlib:deflateInit/6` to fail (8 is still changed to 9). It\n  > also seem possible that future versions of zlib may fix this bug and start\n  > accepting 8 and -8 as is.\n  >\n  > Conclusion: Avoid values 8 and -8 unless you know your zlib version supports\n  > them.\n\n- **`MemLevel`** - Specifies how much memory is to be allocated for the internal\n  compression state: `MemLevel`=1 uses minimum memory but is slow and reduces\n  compression ratio; `MemLevel`=9 uses maximum memory for optimal speed.\n  Defaults to 8.\n\n- **`Strategy`** - Tunes the compression algorithm. Use the following values:\n\n  - `default` for normal data\n  - `filtered` for data produced by a filter (or predictor)\n  - `huffman_only` to force Huffman encoding only (no string match)\n  - `rle` to limit match distances to one (run-length encoding)\n\n  Filtered data consists mostly of small values with a somewhat random\n  distribution. In this case, the compression algorithm is tuned to compress\n  them better. The effect of `filtered` is to force more Huffman coding and less\n  string matching; it is somewhat intermediate between `default` and\n  `huffman_only`. `rle` is designed to be almost as fast as `huffman_only`, but\n  gives better compression for PNG image data.\n\n  `Strategy` affects only the compression ratio, but not the correctness of the\n  compressed output even if it is not set appropriately.","ref":"zlib.html#deflateInit/6"},{"type":"function","title":"zlib.deflateParams/3","doc":"Dynamically updates the compression level and compression strategy.\n\nThe interpretation of `Level` and `Strategy` is as in `deflateInit/6`. This can be\nused to switch between compression and straight copy of the input data, or to\nswitch to a different kind of input data requiring a different strategy. If the\ncompression level is changed, the input available so far is compressed with the\nold level (and can be flushed); the new level takes effect only at the next call\nof `deflate/3`.\n\nBefore the call of `deflateParams`, the stream state must be set as for a call\nof [`deflate/3`](`deflate/3`), as the currently available input may have to be\ncompressed and flushed.","ref":"zlib.html#deflateParams/3"},{"type":"function","title":"zlib.deflateReset/1","doc":"Equivalent to `deflateEnd/1` followed by [`deflateInit/1,2,6`](`deflateInit/1`),\nbut does not free and reallocate all the internal compression state.\n\nThe stream keeps the same compression level and any other attributes.","ref":"zlib.html#deflateReset/1"},{"type":"function","title":"zlib.deflateSetDictionary/2","doc":"Initializes the compression dictionary from the specified byte sequence without\nproducing any compressed output.\n\nThis function must be called immediately after\n[`deflateInit/1,2,6`](`deflateInit/1`) or `deflateReset/1`, before any call of\n`deflate/3`.\n\nThe compressor and decompressor must use the same dictionary (see\n`inflateSetDictionary/2`).\n\nThe Adler checksum of the dictionary is returned.","ref":"zlib.html#deflateSetDictionary/2"},{"type":"function","title":"zlib.gunzip/1","doc":"Uncompresses data with gz headers and checksum.","ref":"zlib.html#gunzip/1"},{"type":"function","title":"zlib.gzip/1","doc":"Compresses data with gz headers and checksum.","ref":"zlib.html#gzip/1"},{"type":"function","title":"zlib.inflate/2","doc":"Equivalent to [`inflate(Z, Data, [])`](`inflate/3`)","ref":"zlib.html#inflate/2"},{"type":"function","title":"zlib.inflate/3","doc":"Decompresses as much data as possible. It can introduce some output latency\n(reading input without producing any output).\n\nCurrently the only available option is `{exception_on_need_dict,boolean()}`\nwhich controls whether the function should throw an exception when a preset\ndictionary is required for decompression. When set to false, a `need_dictionary`\ntuple will be returned instead. See `inflateSetDictionary/2` for details.\n\n> #### Warning {: .warning }\n>\n> This option defaults to `true` for backwards compatibility but we intend to\n> remove the exception behavior in a future release. New code that needs to\n> handle dictionaries manually should always specify\n> `{exception_on_need_dict,false}`.","ref":"zlib.html#inflate/3"},{"type":"function","title":"zlib.inflateEnd/1","doc":"Ends the inflate session and cleans all data used.\n\nNotice that this function throws a `data_error` exception if no end of stream\nwas found (meaning that not all data has been uncompressed).","ref":"zlib.html#inflateEnd/1"},{"type":"function","title":"zlib.inflateGetDictionary/1","doc":"Returns the decompression dictionary currently in use by the stream.\n\nThis function must be called between [`inflateInit/1,2`](`inflateInit/1`) and\n[`inflateEnd`](`inflateEnd/1`).\n\nOnly supported if ERTS was compiled with zlib >= 1.2.8.","ref":"zlib.html#inflateGetDictionary/1"},{"type":"function","title":"zlib.inflateInit/1","doc":"Initializes a zlib stream for decompression.","ref":"zlib.html#inflateInit/1"},{"type":"function","title":"zlib.inflateInit/2","doc":"Initializes a decompression session on zlib stream.\n\n`WindowBits` is the base two logarithm of the maximum window size (the size of\nthe history buffer). It is to be in the range 8 through 15. Default to 15 if\n`inflateInit/1` is used.\n\nIf a compressed stream with a larger window size is specified as input,\n`inflate/2` throws the `data_error` exception.\n\nA negative `WindowBits` value makes zlib ignore the zlib header (and checksum)\nfrom the stream. Notice that the zlib source mentions this only as a\nundocumented feature.","ref":"zlib.html#inflateInit/2"},{"type":"function","title":"zlib.inflateReset/1","doc":"Equivalent to `inflateEnd/1` followed by `inflateInit/1`, but does not free and\nreallocate all the internal decompression state. The stream will keep attributes\nthat could have been set by `inflateInit/1,2`.","ref":"zlib.html#inflateReset/1"},{"type":"function","title":"zlib.inflateSetDictionary/2","doc":"Initializes the decompression dictionary from the specified uncompressed byte\nsequence.\n\nThis function must be called as a response to an inflate operation\n(eg. `safeInflate/2`) returning `{need_dictionary,Adler,Output}` or in the case\nof deprecated functions, throwing an\n`{'EXIT',{{need_dictionary,Adler},_StackTrace}}` exception.\n\nThe dictionary chosen by the compressor can be determined from the Adler value\nreturned or thrown by the call to the inflate function. The compressor and\ndecompressor must use the same dictionary (See `deflateSetDictionary/2`).\n\nAfter setting the dictionary the inflate operation should be retried without new\ninput.\n\nExample:\n\n```erlang\ndeprecated_unpack(Z, Compressed, Dict) ->\n     case catch zlib:inflate(Z, Compressed) of\n          {'EXIT',{{need_dictionary,_DictID},_}} ->\n                 ok = zlib:inflateSetDictionary(Z, Dict),\n                 Uncompressed = zlib:inflate(Z, []);\n          Uncompressed ->\n                 Uncompressed\n     end.\n\nnew_unpack(Z, Compressed, Dict) ->\n    case zlib:inflate(Z, Compressed, [{exception_on_need_dict, false}]) of\n        {need_dictionary, _DictId, Output} ->\n            ok = zlib:inflateSetDictionary(Z, Dict),\n            [Output | zlib:inflate(Z, [])];\n        Uncompressed ->\n            Uncompressed\n    end.\n```","ref":"zlib.html#inflateSetDictionary/2"},{"type":"function","title":"zlib.open/0","doc":"Opens a zlib stream.","ref":"zlib.html#open/0"},{"type":"function","title":"zlib.safeInflate/2","doc":"Like `inflate/2`, but returns once it has expanded beyond a small\nimplementation-defined threshold. It's useful when decompressing untrusted input\nwhich could have been maliciously crafted to expand until the system runs out of\nmemory.\n\nThis function returns `{continue | finished, Output}`, where Output is the data\nthat was decompressed in this call. New input can be queued up on each call if\ndesired, and the function will return `{finished, Output}` once all queued data\nhas been decompressed.\n\nThis function can introduce some output latency (reading input without producing\nany output).\n\nIf a preset dictionary is required for further decompression, this function\nreturns a `need_dictionary` tuple. See `inflateSetDictionary/2`) for details.\n\nExample:\n\n```erlang\nwalk(Compressed, Handler) ->\n    Z = zlib:open(),\n    zlib:inflateInit(Z),\n    loop(Z, Handler, zlib:safeInflate(Z, Compressed)),\n    zlib:inflateEnd(Z),\n    zlib:close(Z).\n\nloop(Z, Handler, {continue, Output}) ->\n    Handler(Output),\n    loop(Z, Handler, zlib:safeInflate(Z, []));\nloop(Z, Handler, {finished, Output}) ->\n    Handler(Output).\n```","ref":"zlib.html#safeInflate/2"},{"type":"function","title":"zlib.set_controlling_process/2","doc":"Changes the controlling process of `Z` to `Pid`, which must be a local process.","ref":"zlib.html#set_controlling_process/2"},{"type":"function","title":"zlib.uncompress/1","doc":"Uncompresses data with zlib headers and checksum.","ref":"zlib.html#uncompress/1"},{"type":"function","title":"zlib.unzip/1","doc":"Uncompresses data without zlib headers and checksum.","ref":"zlib.html#unzip/1"},{"type":"type","title":"zlib.zflush/0","doc":"","ref":"zlib.html#t:zflush/0"},{"type":"function","title":"zlib.zip/1","doc":"Compresses data without zlib headers and checksum.","ref":"zlib.html#zip/1"},{"type":"type","title":"zlib.zlevel/0","doc":"","ref":"zlib.html#t:zlevel/0"},{"type":"type","title":"zlib.zmemlevel/0","doc":"","ref":"zlib.html#t:zmemlevel/0"},{"type":"type","title":"zlib.zmethod/0","doc":"","ref":"zlib.html#t:zmethod/0"},{"type":"type","title":"zlib.zstrategy/0","doc":"","ref":"zlib.html#t:zstrategy/0"},{"type":"type","title":"zlib.zstream/0","doc":"A zlib stream, see `open/0`.","ref":"zlib.html#t:zstream/0"},{"type":"type","title":"zlib.zwindowbits/0","doc":"Normally in the range `-15..-8 | 8..15`.","ref":"zlib.html#t:zwindowbits/0"},{"type":"extras","title":"ERTS Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# ERTS Release Notes\n\nThis document describes the changes made to the ERTS application.","ref":"notes.html"},{"type":"extras","title":"Erts 15.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed failed runtime assert in debug VM when built with statically linked NIFs.\n\n  Own Id: OTP-19443 Aux Id: [GH-9306], [PR-9307]\n\n- Fixed a bug where reading a binary from `m:persistent_term` could cause a segmentation fault on Windows. This bug was introduced in Erlang/OTP 27.0.\n\n  Own Id: OTP-19458 Aux Id: [PR-9349], [GH-9222]\n\n- Fixed a crash in `erlexec` (an executable used by `erl` during startup) when a `PATH` longer than 10240 was set.\n\n  Own Id: OTP-19471 Aux Id: [PR-9331]\n\n- Fixed bug in `erlang:halt`. Two processes calling `erlang:halt` at the same time could lead to one of them crashing with `badarg` as if it called `erlang:halt(undefined,undefined)`.\n\n  Own Id: OTP-19490 Aux Id: [PR-8640], [GH-8634]\n\n- Fixed BEAM crash when a custom thread sends a large map (>128 keys) externally encoded with, for example, `erl_drv_send_term()`.\n\n  Own Id: OTP-19495 Aux Id: [GH-8208], [PR-8209]\n\n[GH-9306]: https://github.com/erlang/otp/issues/9306\n[PR-9307]: https://github.com/erlang/otp/pull/9307\n[PR-9349]: https://github.com/erlang/otp/pull/9349\n[GH-9222]: https://github.com/erlang/otp/issues/9222\n[PR-9331]: https://github.com/erlang/otp/pull/9331\n[PR-8640]: https://github.com/erlang/otp/pull/8640\n[GH-8634]: https://github.com/erlang/otp/issues/8634\n[GH-8208]: https://github.com/erlang/otp/issues/8208\n[PR-8209]: https://github.com/erlang/otp/pull/8209","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Disabled an unsafe runtime optimization in binary construction that caused silent memory corruption.\n\n  Own Id: OTP-19462 Aux Id: ERIERL-1177, [PR-9372]\n\n[PR-9372]: https://github.com/erlang/otp/pull/9372","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed configure tests for GCC 14\n\n  Own Id: OTP-19407 Aux Id: [GH-9211], [PR-9234]\n\n- Fix bug where log printouts would go missing when `application_controller` is stopping while log messages are being sent.\n  \n  This bug was introduced by OTP-19078 in Erlang/OTP 26.2.5.\n\n  Own Id: OTP-19418 Aux Id: [GH-9163], [PR-9274]\n\n[GH-9211]: https://github.com/erlang/otp/issues/9211\n[PR-9234]: https://github.com/erlang/otp/pull/9234\n[GH-9163]: https://github.com/erlang/otp/issues/9163\n[PR-9274]: https://github.com/erlang/otp/pull/9274","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- `gen_sctp:peeloff/2` has been fixed to inherit socket options to the peeled off socket more like `gen_tcp:accept/1`, for example the options `tos` or `tclass`.\n  \n  When setting SCTP options that are unsupported on the platform, some should be silently ignored, but a bug caused the option parsing to derail so the options after could bail out and cause an error instead.  This has been fixed.\n\n  Own Id: OTP-19225 Aux Id: [PR-8789]\n\n- Fixed a bug where Erlang would corrupt the terminal settings if stdin was a TTY but stdout was not.\n\n  Own Id: OTP-19232 Aux Id: [PR-8794], [GH-8487]\n\n- Fixed a bug in the non-JIT VM when loading a NIF over a function that is already traced by more than one session. This caused a VM crash. This bug has existed since OTP-27.0, where multiple trace sessions were introduced.\n\n  Own Id: OTP-19248 Aux Id: [PR-8856]\n\n- Fixed a bug where the loading of modules with extremely large binary construction instructions crashed the emulator on AArch64.\n\n  Own Id: OTP-19261 Aux Id: [GH-8815], [PR-8816]\n\n- [`inet:getifaddrs/0,1`](`inet:getifaddrs/1`) is improved when using\n  inet_backend = socket.\n\n  Own Id: OTP-19264\n\n- `win32reg:value/2` will no longer crash the emulator when the value is an unterminated REG_SZ of size 0.\n\n  Own Id: OTP-19283 Aux Id: [GH-8903], [PR-8912]\n\n- `Makefile` dependency generation on Windows in WSL 2 has been corrected.\n\n  Own Id: OTP-19300 Aux Id: [PR-8955]\n\n- Fix lock order violation if a NIF monitor `down` callback calls `enif_whereis_pid`. Would cause debug emulator to crash but could potentially lead to deadlocks in optimized emulator.\n\n  Own Id: OTP-19330 Aux Id: [GH-8983], [PR-9008]\n\n- Fixed compilation faults when compiling using `--enable-vm-probes`.\n\n  Own Id: OTP-19333\n\n- Fixed `erl_nif.h` on Windows to compile when gcc or clang is used.\n\n  Own Id: OTP-19341 Aux Id: [PR-9016]\n\n- Fixed a minor issue in the JIT debug information that confused tools like GDB and perf.\n\n  Own Id: OTP-19362 Aux Id: [PR-9003]\n\n[PR-8789]: https://github.com/erlang/otp/pull/8789\n[PR-8794]: https://github.com/erlang/otp/pull/8794\n[GH-8487]: https://github.com/erlang/otp/issues/8487\n[PR-8856]: https://github.com/erlang/otp/pull/8856\n[GH-8815]: https://github.com/erlang/otp/issues/8815\n[PR-8816]: https://github.com/erlang/otp/pull/8816\n[GH-8903]: https://github.com/erlang/otp/issues/8903\n[PR-8912]: https://github.com/erlang/otp/pull/8912\n[PR-8955]: https://github.com/erlang/otp/pull/8955\n[GH-8983]: https://github.com/erlang/otp/issues/8983\n[PR-9008]: https://github.com/erlang/otp/pull/9008\n[PR-9016]: https://github.com/erlang/otp/pull/9016\n[PR-9003]: https://github.com/erlang/otp/pull/9003","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Improved documentation of [timers](time_correction.md#timers).\n\n  Own Id: OTP-19360 Aux Id: ERIERL-1149, [PR-9062]\n\n- The label for a process can now be retrieved also using `process_info(Pid, label)` in addition to `proc_lib:get_label/1`.\n  \n  This new option is useful when one wants to retrieve more than one process info item. For example:\n  \n  ```\n  process_info(Pid, [label,registered_name])\n  ```\n\n  Own Id: OTP-19373 Aux Id: [PR-9108]\n\n[PR-9062]: https://github.com/erlang/otp/pull/9062\n[PR-9108]: https://github.com/erlang/otp/pull/9108","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 15.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- gen_udp:send on domain local can leak inet_reply messages.\n\n  Own Id: OTP-19332 Aux Id: [#8989]\n\n- net:getifaddrs does not properly report the running flag on windows.\n\n  Own Id: OTP-19366 Aux Id: OTP-19061, ERIERL-1134\n\n[#8989]: https://github.com/erlang/otp/issues/8989","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A bug has been fixed where receiving an SCTP message with `gen_sctp` could waste the first fragments of a message and only deliver the last fragment.\n  \n  This happened with low probability when the OS signaled that the socket was ready for reading in combination with an internal time-out retry.\n  \n  A bug has been fixed with a lingering time-out from after an SCTP connect that could stop the flow of incoming messages on an active `gen_tcp` socket.\n\n  Own Id: OTP-19235 Aux Id: ERIERL-1133, [PR-8837]\n\n- An boolean option `non_block_send` for SCTP, has ben added to be able to achieve the old behaviour to avoid blocking send operations by passing the OS network stack error message (`{error,eagain}` through.\n\n  Own Id: OTP-19258 Aux Id: OTP-19061, ERIERL-1134\n\n- The call `gen_tcp:send/2` could hang indefinitely despite having set the `send_timeout` option for the following unfortunate combination of circumstances:\n  \n  * The socket has to be in passive mode.\n  * All output buffers had to be filled util the `high_watermark` was hit, causing the `gen_tcp:send/2` operation to block.\n  * While the send operation was blocked, a `gen_tcp:recv/2,3` call had to be done from a different process.  It had to block, waiting for data for a while before completing the operation, and the received packet had to fill at least 75% of the receive buffer.\n  \n  Under these circumstances he information that a send operation was waiting got lost, so the send operation that blocked in the first placed would never return.  The data it had would be sent, though, and send operations from other processes, still work.\n  \n  This bug has been fixed.\n\n  Own Id: OTP-19267 Aux Id: [GH-6455], OTP-18520, ERIERL-1138, [PR-8892]\n\n- In rare circumstances, in code that matches multiple tuples, the JIT could generate code that would raise a `badmatch` exception even if the given tuples were correct.\n\n  Own Id: OTP-19268 Aux Id: [GH-8875], [PR-8895]\n\n- Fixed beam crash that could happen if resetting `call_time` or `call_memory` trace counters of a function while it is called. Bug exists since OTP R16.\n\n  Own Id: OTP-19269 Aux Id: [GH-8835], [PR-8897]\n\n[PR-8837]: https://github.com/erlang/otp/pull/8837\n[GH-6455]: https://github.com/erlang/otp/issues/6455\n[PR-8892]: https://github.com/erlang/otp/pull/8892\n[GH-8875]: https://github.com/erlang/otp/issues/8875\n[PR-8895]: https://github.com/erlang/otp/pull/8895\n[GH-8835]: https://github.com/erlang/otp/issues/8835\n[PR-8897]: https://github.com/erlang/otp/pull/8897","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- On Windows, successive failed socket calls caused socket to become \"uninitialized\".\n\n  Own Id: OTP-19251 Aux Id: [#8853]\n\n- The socket framework fails to start on a IPv6-only Windows machine.\n\n  Own Id: OTP-19254 Aux Id: [#8848]\n\n[#8853]: https://github.com/erlang/otp/issues/8853\n[#8848]: https://github.com/erlang/otp/issues/8848","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The `erl -man example` has been corrected to not consider values set in `ERL_ZFLAGS` and stop parsing arguments when a `--` is encountered.\n\n  Own Id: OTP-19098 Aux Id: [PR-8478], [GH-8477]\n\n- Compiler warnings for  Windows I/O back-end have been silenced.\n\n  Own Id: OTP-19113\n\n- Bugs related to `return_to` trace have been fixed. It did not work for more than once trace session and it did sometimes not trigger for exceptions.\n\n  Own Id: OTP-19122\n\n- Potential deadlocks while writing a crash dump have been eliminated.\n\n  Own Id: OTP-19133 Aux Id: [PR-8521], [GH-8498]\n\n- When loading a damaged or too old BEAM file, the runtime system could crash.\n\n  Own Id: OTP-19153 Aux Id: [PR-8623]\n\n- A scheduler thread could get stuck when deleting a memory allocator carrier when adjacent carriers were deleted and/or inserted simultaneously by other schedulers. This in turn could cause the other schedulers to get stuck as well.\n\n  Own Id: OTP-19154 Aux Id: [GH-8613], [PR-8627]\n\n- Statistics for number of carriers in a shared pool after calling `instrument:allocations` or `instrument:carriers` are now correct. Also, a potential bug in carrier block scanning was eliminated.\n\n  Own Id: OTP-19166 Aux Id: [PR-8636]\n\n- A race in the kTLS flavour of SSL distribution has been fixed so that `inet_drv.c` doesn't read ahead too much data, which could cause the kTLS encryption to be activated too late when some encrypted data had already been read into the `inet_drv.c` buffer as unencrypted.\n\n  Own Id: OTP-19175 Aux Id: [GH-8561], [PR-8690]\n\n- Fixed an emulator crash relating to compressed ETS tables.\n\n  Own Id: OTP-19176 Aux Id: [PR-8683]\n\n- A function (encode_sockaddr) was called with superfluous argument, on Windows, in the net nif.\n\n  Own Id: OTP-19181\n\n- Fixed a crash that could happen on reallocation failure.\n\n  Own Id: OTP-19192\n\n- Man pages are now available for `erl`, `erlc`, `dialyzer`, and all other programs that are included in Erlang/OTP.\n\n  Own Id: OTP-19201 Aux Id: [PR-8740]\n\n- A previous correction in the Erlang/OTP 27.0.1 emergency patch had the unfortunate side effect of sometimes causing an unnecessary fullsweep (major) garbage collection instead of a  generation (minor) garbage collection. This has been corrected.\n\n  Own Id: OTP-19209 Aux Id: [PR-8751], [PR-8539]\n\n- Fixed trace matchspec functions `trace` and `enable_trace` to use the session tracer when enabling trace flags on untraced processes.\n\n  Own Id: OTP-19211 Aux Id: [GH-8657]\n\n- Fixed a typo in the type spec for `t:erlang:garbage_collection_defaults/0`.\n\n  Own Id: OTP-19215 Aux Id: [PR-8757]\n\n- Corrected socket:ioctl for genaddr (SIOCGENADDR).\n\n  Own Id: OTP-19216\n\n- The support for Transparent Huge Pages has been disabled on non-amd64 Linux systems.\n\n  Own Id: OTP-19219 Aux Id: [PR-8702]\n\n- Fixed a race condition on Windows when upgrading from `-noshell` to a shell that would cause Erlang to crash with the error:\n  \n  ```\n  {'GetOverlappedResult',\n    'The I/O operation has been aborted because of either a thread exit or an application request.'}.\n  ```\n\n  Own Id: OTP-19220 Aux Id: [PR-8774], [GH-7621]\n\n[PR-8478]: https://github.com/erlang/otp/pull/8478\n[GH-8477]: https://github.com/erlang/otp/issues/8477\n[PR-8521]: https://github.com/erlang/otp/pull/8521\n[GH-8498]: https://github.com/erlang/otp/issues/8498\n[PR-8623]: https://github.com/erlang/otp/pull/8623\n[GH-8613]: https://github.com/erlang/otp/issues/8613\n[PR-8627]: https://github.com/erlang/otp/pull/8627\n[PR-8636]: https://github.com/erlang/otp/pull/8636\n[GH-8561]: https://github.com/erlang/otp/issues/8561\n[PR-8690]: https://github.com/erlang/otp/pull/8690\n[PR-8683]: https://github.com/erlang/otp/pull/8683\n[PR-8740]: https://github.com/erlang/otp/pull/8740\n[PR-8751]: https://github.com/erlang/otp/pull/8751\n[PR-8539]: https://github.com/erlang/otp/pull/8539\n[GH-8657]: https://github.com/erlang/otp/issues/8657\n[PR-8757]: https://github.com/erlang/otp/pull/8757\n[PR-8702]: https://github.com/erlang/otp/pull/8702\n[PR-8774]: https://github.com/erlang/otp/pull/8774\n[GH-7621]: https://github.com/erlang/otp/issues/7621","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Added functions `getservbyname` and `getservbyport` to the `net` module.\n\n  Own Id: OTP-19101 Aux Id: OTP-18835\n\n- Introduced enet | esock variants of `m:inet` functions, either when called with sockets,\n  with explicit inet_backend config or with the e inet_backend kernel config option.\n\n  Own Id: OTP-19132 Aux Id: OTP-19101\n\n- Optimize process and port creation when such tracing is not enabled by any trace session.\n\n  Own Id: OTP-19167 Aux Id: [PR-8655]\n\n- Compiler warnings for some removed functions have been corrected to point out the correct replacement functions.\n\n  Own Id: OTP-19186 Aux Id: [PR-8709]\n\n- A boolean option `read_ahead` has been implemented for `gen_tcp`, default `true`, to facilitate not reading past (caching data) the end of a packet.  In particular, for kTLS, caching data could read in data that was supposed to be decrypted by the platform's network stack, before crypto parameters could be activated.\n\n  Own Id: OTP-19199 Aux Id: OTP-19175, [GH-8561], [GH-8690], [GH-8785]\n\n- The `m:zip` module has been updated with support for:\n  \n  * zip64 archives - Archives larger than 4GB or with more than 2^32 entries.\n  * extended timestamps - Higher resolution and in UTC.\n  * UID/GID - Save and extract the original UID/GID.\n  * Fixes so that permission mode attributes are correctly read and set for files in archives.\n  * `zip:list_dir/2` now also returns directories, not only files. (You can disable this behaviour by using the option `skip_directories`).\n  \n  Various bugs in the original implementation have also been fixed, such as:\n  \n  * Correctly encode and decode the DOS timestamps for entries within an archive (that is the non-extended timestamp).\n  * Fix DOS timestamps to be set to localtime instead of UTC (use extended timestamps for UTC timestamps).\n  * Use the unix file attributes read from disk when creating archives instead of setting everything to 644.\n\n  Own Id: OTP-19214 Aux Id: [PR-8765]\n\n[PR-8655]: https://github.com/erlang/otp/pull/8655\n[PR-8709]: https://github.com/erlang/otp/pull/8709\n[GH-8561]: https://github.com/erlang/otp/issues/8561\n[GH-8690]: https://github.com/erlang/otp/issues/8690\n[GH-8785]: https://github.com/erlang/otp/issues/8785\n[PR-8765]: https://github.com/erlang/otp/pull/8765","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 15.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- In rare circumstances the JIT could do an unsafe in-place update of a tuple.\n\n  Own Id: OTP-19108 Aux Id: [PR-8539]\n\n- When a port command crashed in the inet driver during `gen_tcp:send/2`, a monitor `'DOWN'` message could be left lingering in the caller's mailbox. This has now been fixed.\n\n  Own Id: OTP-19121 Aux Id: [GH-8484]\n\n- `'DOWN'` messages originating from a monitored port, contained the atom `process` instead of the atom `port` as the third element when the exit reason was not an immediate term.\n\n  Own Id: OTP-19123 Aux Id: [GH-8484], [PR-8546]\n\n- Fix so that the options to enable Transparent Huge Page alignment of the Erlang VM executable are only applied to the Erlang VM and not other native programs such as `erlc` and `dialyzer`. This bug was introduced in Erlang/OTP 27.0.\n\n  Own Id: OTP-19137 Aux Id: [GH-8574]\n\n- When [*no time warp mode*](time_correction.md#no-time-warp-mode) was enabled, a smaller Erlang monotonic time could be read than a previously read time, i.e., breaking the monotonic property. The runtime system will abort when detecting an issue like this since OTP 24.3.4.17 and OTP 25.0.\n  \n  Up until OTP 25 *no time warp mode* is the default. As of OTP 26 [*multi time warp mode*](time_correction.md#multi-time-warp-mode) is the default.\n\n  Own Id: OTP-19147 Aux Id: ERIERL-1043, ERIERL-1106, [PR-8619]\n\n- When calling `trace:function(Session, _, true, [meta])` the meta tracer was incorrectly set to be the calling process. Now it's set to the session tracer as expected.\n\n  Own Id: OTP-19151 Aux Id: [PR-8616], [GH-8614]\n\n[PR-8539]: https://github.com/erlang/otp/pull/8539\n[GH-8484]: https://github.com/erlang/otp/issues/8484\n[GH-8484]: https://github.com/erlang/otp/issues/8484\n[PR-8546]: https://github.com/erlang/otp/pull/8546\n[GH-8574]: https://github.com/erlang/otp/issues/8574\n[PR-8619]: https://github.com/erlang/otp/pull/8619\n[PR-8616]: https://github.com/erlang/otp/pull/8616\n[GH-8614]: https://github.com/erlang/otp/issues/8614","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 15.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-15-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Bugs in how `erl -extra` interacts with passing flags via ERL_*FLAGS or `-args_file` have been fixed.\n\n  Own Id: OTP-18766 Aux Id: [PR-7639]\n\n- Fixed a bug that prevented the emulator from building on recent versions of Yocto Linux.\n\n  Own Id: OTP-18918 Aux Id: [PR-7952]\n\n- Fixed spectre mitigation configure test to work with GCC patches to always add `-fcf-protection=full`.\n\n  Own Id: OTP-18928 Aux Id: [PR-8006]\n\n- A  call to `socket:[recv|recvfrom|recvmsg]/*` with Timeout = 0 on Windows could cause a (case clause) crash if data is immediately available.\n\n  Own Id: OTP-19063 Aux Id: OTP-18835\n\n- Fix bug on Windows where `exit_status` would not be sent when a port exits after the stdin/stdout handles have been closed.\n\n  Own Id: OTP-19077 Aux Id: [PR-8324]\n\n[PR-7639]: https://github.com/erlang/otp/pull/7639\n[PR-7952]: https://github.com/erlang/otp/pull/7952\n[PR-8006]: https://github.com/erlang/otp/pull/8006\n[PR-8324]: https://github.com/erlang/otp/pull/8324","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Refactored how the JIT handles POSIX signals and how they affect thread stacks, allowing us to use the native stack register for Erlang stacks on more platforms.\n  \n  Notably, containers built on 64-bit x86 Alpine Linux images will now perform much better in sequential code. As an example, running `dialyzer` over the OTP code base finishes about 15% quicker.\n\n  Own Id: OTP-18568 Aux Id: [PR-7174]\n\n- The `m:instrument` module can now track allocations on a per-process or per-port basis.\n\n  Own Id: OTP-18577 Aux Id: [PR-7236]\n\n- The `pid` field returned from [`erlang:fun_info/1,2`](`erlang:fun_info/2`) is now always the pid for the `init` process of the local node, not the pid for the actual process that created the fun.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18594 Aux Id: [PR-7274]\n\n- By default, escripts will now be compiled instead of interpreted. That means that the `compiler` application must be installed.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18639 Aux Id: [PR-7348]\n\n- A binary returned from the `m:socket` receive functions is no longer created as a sub binary of an often large receive buffer binary (socket option `{otp,rcvbuf}`).  This avoids space waste, trusting the allocators to implement reallocation efficiently.\n\n  Own Id: OTP-18642 Aux Id: [GH-6152], [PR-7465]\n\n- The default process limit has been raised to `1048576` processes.\n\n  Own Id: OTP-18699 Aux Id: [PR-7388]\n\n- The `erlang:system_monitor/2` functionality is now able to monitor long message queues in the system.\n\n  Own Id: OTP-18709 Aux Id: [PR-7651]\n\n- The `erl` command now supports the `-S` flag, which is similar to the `-run` flag, except that it will pass all arguments up to end of the command line to the called function. (The `-run` flag will not pass arguments beginning with a hyphen.) Another difference is that `-S` will always call a function with one argument, passing an empty list if no arguments were given.\n\n  Own Id: OTP-18744 Aux Id: [PR-7470]\n\n- When implementing an alternative carrier for the Erlang distribution, a separate input handler process may now be registered, using `erlang:dist_ctrl_input_handler/2`, also in the case when the distribution controller is a port.\n\n  Own Id: OTP-18774 Aux Id: [PR-7110]\n\n- The call stack trace has now been added to the error reported by `erlang:process_flag/2` when `max_heap_size` limit has been exceeded.\n\n  Own Id: OTP-18779 Aux Id: [PR-7592]\n\n- `-callback` attributes have been added to `m:erl_tracer`.\n\n  Own Id: OTP-18794 Aux Id: [PR-7703]\n\n- For `inet_backend = socket`, setting the `active` socket option alone, to `once`, `true` or `N` has been optimized, as well as the corresponding data delivery.\n\n  Own Id: OTP-18835\n\n- New functions `socket:sendv/*` for sending I/O vectors have been added.\n\n  Own Id: OTP-18845\n\n- Socket options that take string now also accept binaries.\n\n  Own Id: OTP-18849 Aux Id: [PR-6510]\n\n- Native coverage support has been implemented in the JIT. It will  automatically be used by the `m:cover` tool to reduce the execution overhead when running cover-compiled code.\n  \n  There are also new APIs to support native coverage without using the `cover` tool.\n  \n  To instrument code for native coverage it must be compiled with the [`line_coverage`](`m:compile#line_coverage`) option.\n  \n  To enable native coverage in the runtime system, start it like so:\n  \n  ```text\n  $ erl +JPcover true\n  ```\n  \n  There are also the following new functions for supporting native coverage:\n  \n  * `code:coverage_support/0`\n  * `code:get_coverage/2`\n  * `code:reset_coverage/1`\n  * `code:get_coverage_mode/0`\n  * `code:get_coverage_mode/1`\n  * `code:set_coverage_mode/1`\n\n  Own Id: OTP-18856 Aux Id: [PR-7856]\n\n- Changed the default value of the command line flag `-code_path_choice` to `strict`. \n  \n  Note that for application systems using archives, it is necessary to add the `code_path_choice relaxed` to the command line that invokes `erl`.\n\n  Own Id: OTP-18894 Aux Id: [PR-7243]\n\n- Added module loading to `erl -init_debug` printouts.\n\n  Own Id: OTP-18929 Aux Id: [PR-8004]\n\n- When the runtime system halts, it performs various flush operations before terminating. By default there is no limit on how much time the flush operations are allowed to take. A new *halt flush timeout* functionality has been introduced which can be used for limiting the amount of time that the flushing operations are allowed to take. For more information see the documentation of the [`flush_timeout`](`m:erlang#halt_flush_timeout`) option of the [`erlang:halt/2`](`erlang:halt/2`) BIF and the documentation of the `erl` [`+zhft  `](erl_cmd.md#+zhft) command line flag.\n\n  Own Id: OTP-18938 Aux Id: [PR-8035], [GH-7438]\n\n- Optimized code loading by moving certain operations from the code server to the caller.\n\n  Own Id: OTP-18941 Aux Id: [PR-7981]\n\n- Updated asmjit to version a465fe71ab3d0e224b2b4bd0fac69ae68ab9239d\n\n  Own Id: OTP-18942\n\n- The deprecated functions in `m:zlib` have been removed. That includes `inflateChunk/{1,2}`, `getBufSize/1`, `setBufSize/2`, the CRC32 functions, and the Adler checksum functions.\n\n  Own Id: OTP-18950\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- Safe destructive update of tuples has been implemented in the compiler and runtime system. This allows the VM to update tuples in-place when it is safe to do so, thus improving performance by doing less copying but also by producing less garbage.\n  \n  Example:\n  \n  ```erlang\n  -record(rec, {a,b,c}).\n  \n  update(#rec{a=needs_update,b=N}=R0) ->\n      R = R0#rec{a=up_to_date},\n      if\n          N < 0 ->\n              R#rec{c=negative};\n          N == 0 ->\n              R#rec{c=zero};\n          N > 0 ->\n              R#rec{c=positive}\n      end.\n  ```\n  \n  The record updates in each of the three clauses of the `if` can safely be done in-place, because variable `R` is not used again.\n\n  Own Id: OTP-18972 Aux Id: [PR-8090]\n\n- The obsolete and undocumented support for opening a port to an external\n  resource by passing an atom (or a string) as first argument to\n  [`open_port()`](`erlang:open_port/2`), implemented by the vanilla driver,\n  has been removed. This feature has been scheduled for removal in OTP 27\n  since the release of OTP 26.\n\n  Own Id: OTP-18976 Aux Id: [PR-7125]\n\n- An optional NIF callback `ERL_NIF_OPT_ON_UNLOAD_THREAD` to be called by all scheduler threads when a NIF library is unloaded. Used for releasing thread specific data. Can be set with function `enif_set_option`.\n\n  Own Id: OTP-18977 Aux Id: [PR-7809]\n\n- There is a new module `m:trace` in Kernel providing the same trace functionality as `erlang:trace/3` and `erlang:trace_pattern/3`, but with the addition of **dynamic isolated trace sessions**.\n\n  Own Id: OTP-18980\n\n- Added the `+MMlp on|off` emulator option to let the `mseg` allocator use \"large pages\" (sometimes known as \"huge pages\" or \"super pages\"). This currently only affects super-carrier allocations, but may be extended in the future.\n\n  Own Id: OTP-18984 Aux Id: [PR-7977]\n\n- `inet_backend = socket` has been optimized and reworked to be more compatible with the original `inet_backend = inet`.\n\n  Own Id: OTP-19004 Aux Id: OTP-18835\n\n- The `socket` documentation has been reworked, and due to\n  that a few details were fixed:\n  * `socket:is_supported/1` now returns `true` for example for `protocols`\n    that is a \"category\", not an item.\n  * `socket:cancel_monitor/1` no longer badargs for a monitor that was set by\n    another process, instead it returns `false` as for other unknown\n    `reference()`s.\n\n  Own Id: OTP-19054\n\n[PR-7174]: https://github.com/erlang/otp/pull/7174\n[PR-7236]: https://github.com/erlang/otp/pull/7236\n[PR-7274]: https://github.com/erlang/otp/pull/7274\n[PR-7348]: https://github.com/erlang/otp/pull/7348\n[GH-6152]: https://github.com/erlang/otp/issues/6152\n[PR-7465]: https://github.com/erlang/otp/pull/7465\n[PR-7388]: https://github.com/erlang/otp/pull/7388\n[PR-7651]: https://github.com/erlang/otp/pull/7651\n[PR-7470]: https://github.com/erlang/otp/pull/7470\n[PR-7110]: https://github.com/erlang/otp/pull/7110\n[PR-7592]: https://github.com/erlang/otp/pull/7592\n[PR-7703]: https://github.com/erlang/otp/pull/7703\n[PR-6510]: https://github.com/erlang/otp/pull/6510\n[PR-7856]: https://github.com/erlang/otp/pull/7856\n[PR-7243]: https://github.com/erlang/otp/pull/7243\n[PR-8004]: https://github.com/erlang/otp/pull/8004\n[PR-8035]: https://github.com/erlang/otp/pull/8035\n[GH-7438]: https://github.com/erlang/otp/issues/7438\n[PR-7981]: https://github.com/erlang/otp/pull/7981\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8090]: https://github.com/erlang/otp/pull/8090\n[PR-7125]: https://github.com/erlang/otp/pull/7125\n[PR-7809]: https://github.com/erlang/otp/pull/7809\n[PR-7977]: https://github.com/erlang/otp/pull/7977","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 14.2.5.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed BEAM crash when a custom thread sends a large map (>128 keys) externally encoded with for example `erl_drv_send_term()`.\n\n  Own Id: OTP-19495 Aux Id: GH-8208, PR-8209","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Disabled an unsafe runtime optimization in binary construction that caused silent memory corruption.\n\n  Own Id: OTP-19462 Aux Id: ERIERL-1177, PR-9372","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed configure tests for GCC 14\n\n  Own Id: OTP-19407 Aux Id: GH-9211, PR-9234","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fix lock order violation if a NIF monitor `down` callback calls `enif_whereis_pid`. Would cause debug emulator to crash but could potentially lead to deadlocks in optimized emulator.\n\n  Own Id: OTP-19330 Aux Id: GH-8983, PR-9008\n* gen_udp:send on domain local can leak inet_reply messages.\n\n  Own Id: OTP-19332 Aux Id: #8989\n* net:getifaddrs does not properly report the running flag on windows.\n\n  Own Id: OTP-19366 Aux Id: OTP-19061, ERIERL-1134","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* A bug has been fixed where receiving an SCTP message with \\`gen_sctp\\` could waste the first fragments of a message and only deliver the last fragment.\n\n  This happened with low probability when the OS signaled that the socket was ready for reading in combination with an internal time-out retry.\n\n  A bug has been fixed with a lingering time-out from after an SCTP connect that could stop the flow of incoming messages on an active \\`gen_tcp\\` socket.\n\n  Own Id: OTP-19235 Aux Id: ERIERL-1133, PR-8837\n* On Windows, successive failed socket calls caused socket to become \"uninitialized\".\n\n  Own Id: OTP-19251 Aux Id: GH-8853\n* The socket framework fails to start on a IPv6-only Windows machine.\n\n  Own Id: OTP-19254 Aux Id: GH-8848\n* An boolean option \\`non_block_send\\` for SCTP, has ben added to be able to achieve the old behaviour to avoid blocking send operations by passing the OS network stack error message (\\`\\{error,eagain\\}\\` through.\n\n  Own Id: OTP-19258 Aux Id: OTP-19061, ERIERL-1134\n* The call \\`gen_tcp:send/2\\` could hang indefinitely despite having set the \\`send_timeout\\` option for the following unfortunate combination of circumstances:\n\n  \\* The socket has to be in passive mode. * All output buffers had to be filled util the \\`high_watermark\\` was hit, causing the \\`gen_tcp:send/2\\` operation to block. * While the send operation was blocked, a \\`gen_tcp:recv/2,3\\` call had to be done from a different process. It had to block, waiting for data for a while before completing the operation, and the received packet had to fill at least 75% of the receive buffer.\n\n  Under these circumstances he information that a send operation was waiting got lost, so the send operation that blocked in the first placed would never return. The data it had would be sent, though, and send operations from other processes, still work.\n\n  This bug has been fixed.\n\n  Own Id: OTP-19267 Aux Id: GH-6455, OTP-18520, ERIERL-1138, PR-8892\n* Fixed beam crash that could happen if resetting `call_time` or `call_memory` trace counters of a function while it is called. Bug exists since OTP R16.\n\n  Own Id: OTP-19269 Aux Id: GH-8835, PR-8897","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* A race in the kTLS flavour of SSL distribution has been fixed so inet_drv.c doesn't read ahead too much data which could cause the kTLS encryption to be activated too late when some encrypted data had already been read into the inet_drv.c buffer as unencrypted.\n\n  Own Id: OTP-19175 Aux Id: GH-8561, PR-8690","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* When [*no time warp mode*](time_correction.md#no-time-warp-mode) was enabled, a smaller Erlang monotonic time could be read than a previously read time, i.e., breaking the monotonic property. The runtime system will abort when detecting an issue like this since OTP 24.3.4.17 and OTP 25.0.\n\n  Up until OTP 25 *no time warp mode* is the default. As of OTP 26 [*multi time warp mode*](time_correction.md#multi-time-warp-mode) is the default.\n\n  Own Id: OTP-19147 Aux Id: ERIERL-1043, ERIERL-1106, PR-8619\n* A scheduler thread could get stuck when deleting a memory allocator carrier when adjacent carriers were deleted and/or inserted simultaneously by other schedulers. This in turn could cause the other schedulers to get stuck as well.\n\n  Own Id: OTP-19154 Aux Id: GH-8613, PR-8627","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* A call to socket:\\[recv|recvfrom|recvmsg]/* with Timeout = 0 on Windows could cause a (case clause) crash if data is immediately available.\n\n  Own Id: OTP-19063 Aux Id: OTP-18835\n* When a port command crashed in the inet driver during `gen_tcp:send/2`, a monitor `'DOWN'` message could be left lingering in the caller's mailbox. This has now been fixed.\n\n  Own Id: OTP-19121 Aux Id: GH-8484\n* `'DOWN'` messages originating from a monitored port, contained the atom `process` instead of the atom `port` as the third element when the exit reason was not an immediate term.\n\n  Own Id: OTP-19123 Aux Id: GH-8484, PR-8546","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* [`gen_sctp:send/3,4`](`gen_sctp:send/4`) now waits for the send to complete instead of returning an OS result such as `{error, ewouldblock}`.\n\n  Own Id: OTP-19061\n* ETS functions did not properly handle keys containing maps, sometimes matching too many or too few objects.\n\n  Own Id: OTP-19070 Aux Id: GH-8385\n* Fix CPU quota determination for cgroups.\n\n  The bug was introduced through OTP-18999.\n\n  Own Id: OTP-19071 Aux Id: OTP-18999 PR-8380","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"* Added a warning to open_port/2 regarding the BadBatBut attack affecting Windows.\n\n  Own Id: OTP-19069","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 14.2.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed CPU quota determination for cgroup version 2\n\n  Own Id: OTP-18999 Aux Id: GH-7928\n* Fix faulty reduction counting in exiting process which could cause it to do unnecessary yielding.\n\n  Own Id: OTP-19014\n* Fix bug in `re:run/3` where if an invalid UTF-8 subject was given, re:run could get stuck in an infinite loop. Bug was introduced in Erlang/OTP 22.1.\n\n  Own Id: OTP-19015 Aux Id: ERIERL-682\n* On AArch64 (ARM64), Erlang code using bit syntax construction compiled using Erlang/OTP 24 could crash the runtime system when run in Erlang/OTP 26.2.3.\n\n  Own Id: OTP-19021 Aux Id: GH-8238, PR-8248\n* Calling `erlang:trace/3` with first argument one of `ports`, `processes`, `existing_ports`, `existing_processes`, `existing` or `all`, could cause emulator crash if a dirty scheduler was executing a simultaneous trace action.\n\n  Own Id: OTP-19034\n* Fixed an integer overflow when the monotonic time unit reported by the operating system was greater than 10 and lower than 100 microseconds.\n\n  Own Id: OTP-19036 Aux Id: GH-8186\n* Fix option reuseaddr for FreeBSD 14\n\n  Own Id: OTP-19041\n* When a traced process executing on a dirty scheduler received an exit signal, the dirty scheduler could use the wrong thread specific data which could lead to a crash.\n\n  Own Id: OTP-19043 Aux Id: PR-8342\n* Fixed a more or less harmless bug that caused time correction of Erlang monotonic time to become slightly off on Windows platforms when `QueryPerformanceCounter()` was used as OS monotonic time source.\n\n  `erlang:system_info(os_monotonic_time_source)` now also returns information about *used resolution* which not always corresponds to the resolution of the OS monotonic time source.\n\n  Own Id: OTP-19048 Aux Id: PR-8343\n* When using IPv6, classic gen_udp failed to add (group) membership (drop was used instead).\n\n  Own Id: OTP-19049 Aux Id: #8176\n* Fix bug on Windows where \"Unknown event: 2\" would be printed to the console.\n\n  Own Id: OTP-19060","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"* Checks for monotonicity of monotonic time have been improved so that Erlang and OS monotonic time are checked separately.\n\n  A new `configure` argument `--enable-ensure-os-monotonic-time` has also been added. It enables functionality ensuring the monotonicity of monotonic timestamps delivered by the OS. When a non-monotonic timestamp is detected, it will be replaced by the last delivered monotonic timestamp before being used by Erlang's time functionality. Note that you do *not* want to enable this unless the OS monotonic time source on the system fails to produce monotonic timestamps. This since ensuring the monotonicity of OS monotonic timestamps will hurt scalability and performance of the system.\n\n  Own Id: OTP-19044 Aux Id: ERIERL-1043, PR-8342\n* For severe errors, when the \\`socket\\` module terminates the Erlang VM, now an erl_crash.dump is produced, to facilitate post mortem debugging.\n\n  Own Id: OTP-19058","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 14.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed compile warning in erl_nif.c for gcc-13.\n\n  Own Id: OTP-18906 Aux Id: PR-7930\n* Fix C++ compile error for macros `enif_select_read` and friends.\n\n  Own Id: OTP-18907 Aux Id: PR-7932\n* Fixed a name clash on Solaris that prevented the JIT from being built.\n\n  Own Id: OTP-18940 Aux Id: GH-8024\n* Fix termcap detection on solaris.\n\n  Own Id: OTP-18952 Aux Id: PR-8025\n* Fix heap corruption bug that could cause runaway memory consumption due to circular offheap list at process exit. Other symptoms may also be possible. Bug exists since OTP 25.0.\n\n  Own Id: OTP-18971 Aux Id: GH-8044\n* Do not clear tracing in old module instance if load fails with 'not_purged'.\n\n  Own Id: OTP-18979\n* When exceeding the \\`max_heap_size\\` limit in a garbage collection initiated by some bit syntax operations, the process would not always terminate immediately.\n\n  Own Id: OTP-18982\n* The code server could be hanging if a module with `on_load` function was loaded at the same time as another module was purged using `erlang:purge_module` directly.\n\n  Own Id: OTP-19006\n* A process optimized for parallel signal delivery could under some circumstances lose wakeup information. That is, the processes was not woken up to take care of the signal, so the signal would not be taken care of until the process was woken by another signal. Only processes configured with [`message_queue_data`](`m:erlang#process_flag_message_queue_data`) set to `off_heap` utilize this optimization.\n\n  Own Id: OTP-19008 Aux Id: GH-8119, PR-8201\n* Fix segfault when generating crashdump containing a fun places in persistent_term storage.\n\n  Own Id: OTP-19009 Aux Id: PR-8181\n* By default the JIT is disabled on Intel Macs, because of annoying poups on macOS Sonoma. It is now possible to explicitly enable the JIT on Intel Macs. Here is how: `./configure --enable-jit`\n\n  Own Id: OTP-19011","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* 32-bit runtime systems on most Unix like platforms could crash if a BIF timer was set with a huge timeout of more than 68 years into the future. In order for the crash to occur, the huge timer (at a later time than when it was set) had to become the nearest active timer set on the specific scheduler on which it was set. This could not happen on a system with only one scheduler since there would always be shorter timers in the system.\n\n  Setting a timer larger than 49 days on Windows could under rare circumstances cause the timeout to be delayed.\n\n  Own Id: OTP-18911 Aux Id: ERIERL-1023, PR-7983\n* Fix bug where the system installed openssl/md5.h would be confused with the vendored md5.h.\n\n  Own Id: OTP-18931 Aux Id: GH-7987 PR-7989\n* The JIT has now been disabled on x86 Macs to prevent annoying the \"verifying shm-xyz\" popups introduced in MacOS Sonoma.\n\n  ARM Macs are unaffected.\n\n  Own Id: OTP-18949\n* Garbage collection of a process on a dirty scheduler could collide with signal handling for that process causing a crash of the runtime system. This bug was introduced in OTP 25.3.2.8 and OTP 26.2.\n\n  Own Id: OTP-18957 Aux Id: GH-8051, PR-8088, OTP-18841","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Removed unnecessary PCRE source tar-ball.\n\n  Own Id: OTP-18902","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix erl.exe to to restore the console to its original state when exiting. This\n  bug was introduced in OTP 26.0 and only happens when erl.exe is run in\n  cmd.exe.\n\n  Own Id: OTP-18751 Aux Id: GH-7621 GH-7548\n\n- Fix faulty debug assert when page size is larger than 16kb, like on PowerPC.\n  Did crash debug VM directly at start.\n\n  Own Id: OTP-18802\n\n- `zlib` will no longer randomly return garbage (negative) Adler32 checksums.\n\n  Own Id: OTP-18811 Aux Id: ERIERL-994\n\n- Replaced unintentional Erlang Public License 1.1 headers in some files with\n  the intended Apache License 2.0 header.\n\n  Own Id: OTP-18815 Aux Id: PR-7780\n\n- A process with `message_queue_data` configured as `off_heap` could end up in\n  an inconsistent state when being `receive` traced, inspected using\n  [`process_info/2`](`process_info/2`) with the `message_queue_len` item, or\n  inspected using the break menu (CTRL-C). When it ended up in this inconsistent\n  state, it was not enqueued into a run queue even though it was set in a\n  runnable state.This also effected signals being sent to the process after it\n  had gotten into this inconsistent state, in such a way that it was from this\n  point not possible to communicate with it.\n\n  Own Id: OTP-18838 Aux Id: PR-7822, GH-7801\n\n- A race occurring when a process was selected for dirty execution\n  simultaneously as it was scheduled for handling a signal could cause the\n  process to end up in an inconsistent state. When it ended up in this\n  inconsistent state, it was not enqueued into a run queue even though it was\n  set in a runnable state. This also effected signals being sent to the process\n  after it had gotten into this inconsistent state, in such a way that it was\n  from this point not possible to communicate with it.\n\n  Own Id: OTP-18839 Aux Id: PR-7822, GH-7801\n\n- When a process had to to wait in the run queue for a long time before being\n  selected for dirty execution, it could not receive signals. This caused\n  inspection of such a process, for example using\n  [`process_info/2`](`process_info/2`), to take a long time.\n\n  This issue was introduced in OTP 25.3.2.6 and 26.1 when fixing an issue where\n  a constant flow of signals prevented a process from being able to execute\n  dirty.\n\n  Own Id: OTP-18841 Aux Id: PR-7822, GH-7801, OTP-18737\n\n- Fixed a bug in the JIT that miscompiled large `select_val` instructions.\n\n  Own Id: OTP-18842\n\n- Fix bug on Windows where large writes to `standard_io` could cause duplicate\n  data to be written.\n\n  Own Id: OTP-18871 Aux Id: GH-7838\n\n- The `struct ip_mreqn` field `imr_ifindex` had got an incorrect byte order\n  conversion that has been corrected.\n\n  Own Id: OTP-18880 Aux Id: GH-7736, PR-7761\n\n- On OTP 24 and OTP 25, incoming distributed messages larger than 64 KiB sent\n  using an alias leaked memory if the alias had been removed prior to entering\n  the node. This issue was not present on OTP 26.\n\n  Incoming distributed messages larger than 64 KiB sent using an alias which had\n  been removed on the receiving node could crash the node. This crash was quite\n  unlikely on OTP 24 and OTP 25, but very likely on OTP 26.\n\n  `'DOWN'` signals with exit reason larger than 64 KiB directed towards a\n  process on a node with a not matching creation leaked memory on the receiving\n  node. Such signals should however be very rare.\n\n  Own Id: OTP-18885 Aux Id: GH-7834, GH-7890, PR-7915","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Add Windows support for DGRAM socket connect.\n\n  Own Id: OTP-18762\n\n- [`process_info/2`](`erlang:process_info/2`) now supports lookup of values for\n  specific keys in the process dictionary. For example,\n  `{{dictionary, Key}, Value} = process_info(Pid, {dictionary, Key})`.\n\n  Own Id: OTP-18765 Aux Id: PR-7707\n\n- Removed unnecessary regexp library used when generating yielding BIFs.\n\n  Own Id: OTP-18830 Aux Id: PR-7823\n\n- Fix tty restore when `+Bc` is used.\n\n  Own Id: OTP-18872 Aux Id: GH-7832\n\n- Replaced old md5 implementation with an implementation from OpenSSL.\n\n  Own Id: OTP-18877\n\n- Removed unused `makewhatis` script.\n\n  Own Id: OTP-18899","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 14.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If the external term format encoding of an argument list part of a distributed\n  spawn operation was faulty, the newly spawned remote process could misbehave.\n  The misbehavior included hanging or interpret an incoming message as an\n  argument list to use. This was very unlikely to happen unless using an\n  alternate implementation of the distribution protocol which made a faulty\n  encoding of the argument list. The child process will now detect this error\n  and terminate before executing the user specified code.\n\n  Own Id: OTP-18790 Aux Id: PR-7742\n\n- Fix bugs where if the body of a matchspec would return a map with a variable\n  ('$1', '$\\_' etc) as one of the keys or values and the variable was not an\n  immidiate, the term would not be copied to the receiving processes heap. This\n  would later corrupt the term in the table as the GC could place move markers\n  in it, which in turn would cause the VM to crash.\n\n  Bug has been present for since OTP 17.0.\n\n  Own Id: OTP-18797 Aux Id: PR-7712 GH-7683","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- maps:put with existing key and identical value was not optimized as a no-op\n  correctly if having the same 32-bit hash as another key in the map. In\n  practice very rare and harmless.\n\n  Own Id: OTP-18592\n\n- Fixed an issue with truncated crash slogans on failed emulator start.\n\n  Own Id: OTP-18623 Aux Id: GH-7344\n\n- Fixed a bug where the emulator was unable to determine the current `cgroup`\n  CPU quota.\n\n  Own Id: OTP-18645 Aux Id: GH-7401\n\n- A process optimized for parallel signal delivery could under some\n  circumstances lose wakeup information. That is, the processes was not woken up\n  to take care of the signal, so the signal would not be taken care of until the\n  process was woken by another signal. Only processes configured with\n  [`message_queue_data`](`m:erlang#process_flag_message_queue_data`) set to\n  `off_heap` utilize this optimization.\n\n  Own Id: OTP-18647 Aux Id: PR-7595\n\n- Function socket:close/1 could cause a VM crash on Windows.\n\n  Own Id: OTP-18669 Aux Id: OTP-18029\n\n- Fixed a bug in the ARM JIT where it could accidentally add garbage trailing\n  bits when creating bitstrings whose size wasn't an even multiple of 8 bits.\n\n  Own Id: OTP-18672 Aux Id: GH-7469\n\n- Fix `erlang:system_info/1` documentation to show correct types.\n\n  Own Id: OTP-18674 Aux Id: PR-7472\n\n- Expanded the documentation about how to use the `standard_io`,\n  `standard_error` and `user` I/O devices.\n\n  Added the types [`io:standard_io/0`](`t:io:standard_io/0`),\n  `io:standard:error/0` and [`io:user/0`](`t:io:user/0`).\n\n  Own Id: OTP-18676 Aux Id: PR-7473 GH-7459\n\n- Fix compilation with GNU termcap.\n\n  Own Id: OTP-18702 Aux Id: GH-7381\n\n- Delivery time of message signals to a process not executing any `receive`\n  expressions could become very long, potentially infinite. For example, a\n  process checking for messages using\n  [`process_info(self(), message_queue_len)`](`process_info/2`) or\n  [`process_info(self(), messages)`](`process_info/2`) and avoiding to execute a\n  `receive` expression matching on messages could be very slow in detecting new\n  messages. Note that you are still discouraged from using `process_info()` this\n  way. A process that wants to check if there are messages available to handle\n  should execute a `receive` expression matching on messages.\n\n  Own Id: OTP-18706 Aux Id: GH-7413, PR-7595, ERIERL-979\n\n- On AArch64 (ARM64), when calculating both the quotient and remainder with a\n  divisor begin a power two, the remainder could be incorrectly calculated.\n\n  Own Id: OTP-18724 Aux Id: GH-7566, PR-7567\n\n- Fix bug causing \"magic\" references in a `compressed` ETS table to not keep the\n  referred object alive. The symptom would be the referred object being garbage\n  collected prematurely and the reference appearing stale, not referring to\n  anything. Examples of such magically referred objects are `atomics` and NIF\n  resources.\n\n  Own Id: OTP-18732 Aux Id: GH-7444, PR-7458\n\n- Matching out short bitstrings with a fixed size not divisible by 8 could could\n  lead to the runtime system terminating with an \"Overrun heap and stack\" error.\n\n  Own Id: OTP-18733 Aux Id: GH-7292\n\n- A constant flow of incoming non-message signals could prevent a process\n  needing to execute dirty from doing so.\n\n  Own Id: OTP-18737 Aux Id: PR-7595\n\n- A BEAM file usually contains a chunk with the tag \"Type\" containing type\n  information that can be used by the JIT. The `beam_lib:strip/1` takes care to\n  preserve that chunk, but a build/release tool that does customized stripping\n  could accidentally remove the chunk. Loading a BEAM file without the \"Type\"\n  chunk could cause incorrect behavior of the loaded code.\n\n  Own Id: OTP-18745 Aux Id: GH-7492, PR-7616\n\n- `gen_udp:recv/*` for Unix Domain Socket in binary mode and passive mode has\n  been fixed to not crash.\n\n  Own Id: OTP-18747 Aux Id: GH-7605\n\n- The cleanup operation of not yet delivered signals to a terminated process\n  yielded excessively.\n\n  Own Id: OTP-18752 Aux Id: PR-7633\n\n- Fixed minor hashing issue with the `local` option of\n  `term_to_binary()`/`term_to_iovec()`.\n\n  Own Id: OTP-18753 Aux Id: PR-7634","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Update gen_tcp_socket and gen_udp_socket to handle 'completion' (socket on\n  Windows).\n\n  Own Id: OTP-18586 Aux Id: OTP-18029\n\n- Add support for Unix Domain Sockets (only for STREAM sockets) on Windows for\n  'socket'.\n\n  Own Id: OTP-18611 Aux Id: OTP-18029, #5024\n\n- In Erlang/OTP 27, by default escripts will be compiled before being executed.\n  That means that the `compiler` application must be installed. It is possible\n  to force the escript to be interpreted by adding the directive\n  `-mode(interpret).` to the escript file.\n\n  In Erlang/OTP 28, support for interpreting an escript will be removed.\n\n  Own Id: OTP-18638\n\n- Add basic support for socket ioctl on Windows.\n\n  Own Id: OTP-18660\n\n- Removed erts/etc/darwin/Info.plist, as it is no longer necessary after macos\n  10.12\n\n  Own Id: OTP-18661 Aux Id: PR-6112\n\n- Add support for (Windows) socket option exclusiveaddruse.\n\n  Own Id: OTP-18686\n\n- \\[socket] Add support for the 'nopush' option.\n\n  Own Id: OTP-18687\n\n- Add support for socket option 'BSP STATE'.\n\n  Own Id: OTP-18693\n\n- Add tcp socket options 'keepcnt', 'keepidle' and 'keepintvl'.\n\n  Own Id: OTP-18698\n\n- Add support for misc (Windows) socket options ('max_msg_size' and 'maxdg').\n\n  Own Id: OTP-18710","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 14.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix using the IME (Input Method Editor) to enter text in cmd.exe and\n  powershell.exe on Windows.\n\n  Own Id: OTP-18630 Aux Id: PR-7275 GH-7029\n\n- Multiple socket:accept calls issue. When making multiple accept calls, only\n  the last call is active.\n\n  Own Id: OTP-18635 Aux Id: #7328\n\n- Fix the shell to ignore terminal delay when the terminal capabilities report\n  that they should be used.\n\n  Own Id: OTP-18636 Aux Id: PR-7352 GH-7308\n\n- Fix \"oldshell\" to echo characters while typing on Windows.\n\n  Own Id: OTP-18637 Aux Id: PR-7359 GH-7324\n\n- On Windows, a call to the function socket:close, when there are waiting active\n  calls to read, write or accept functions, could hang.\n\n  Own Id: OTP-18646\n\n- Fix issues when reading or configuring `standard_io` on Windows when erl.exe\n  is started using `-noshell` flag.\n\n  Own Id: OTP-18649 Aux Id: GH-7261 PR-7400\n\n- The following functions are now much faster when given a long list or binary:\n\n  - erlang:list_to_integer/1\n  - erlang:binary_to_integer/1\n  - erlang:binary_to_integer/2\n  - erlang:list_to_integer/2\n  - string:to_integer/1\n\n  Own Id: OTP-18659 Aux Id: PR-7426\n\n- On AArch64 (ARM64), equality and non-equality tests with literal bitstrings\n  could succeed when they should fail and vice versa.\n\n  Own Id: OTP-18663 Aux Id: GH-7433, PR-7437","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Build of the socket nif failed on Solaris 11.\n\n  Own Id: OTP-18585 Aux Id: OTP-18029\n\n- Fixed two reduction-counting bugs relating to binaries.\n\n  Own Id: OTP-18587\n\n- Constructing a binary segment not aligned with a byte boundary, with a size\n  not fitting in 31 bits, and with a value not fitting in a 64-bit word could\n  crash the runtime system.\n\n  Own Id: OTP-18597\n\n- When a binary construction failed because of bad size for a segment, the error\n  information was not always correct.\n\n  Own Id: OTP-18602 Aux Id: GH-7282\n\n- Fixed a crash when calling a fun that was defined in a module that had been\n  upgraded.\n\n  Own Id: OTP-18621 Aux Id: GH-7288","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 14.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-14-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If a local fun was called while reloading the _exact same_ module that defined\n  said fun, there was a small window in which the call would land in code that\n  was yet to be fully loaded.\n\n  Own Id: OTP-18016\n\n- Fix the TLS distribution to work when starting Erlang in embedded mode and a\n  connection is done before kernel is fully started.\n\n  Own Id: OTP-18248 Aux Id: PR-6227 GH-6085\n\n- erl `-remsh` has been improved to provide better error reasons and work when\n  using a shell without terminal support (that is an \"oldshell\").\n\n  Own Id: OTP-18271 Aux Id: PR-6279\n\n- Fix so that `-fno-omit-frame-pointer` is applied to all of the Erlang VM when\n  using the JIT so that tools, such as perf, can crawl the process stacks.\n\n  Own Id: OTP-18274 Aux Id: PR-6048\n\n- Compilation server now support unicode paths in compilation server for\n  filesystems that are encoded with unicode.\n\n  Own Id: OTP-18277 Aux Id: PR-6306\n\n- Reintroduced the optimization that turned anonymous functions without free\n  variables into literals (OTP-15195). This optimization was lost during\n  refactoring in OTP 24.\n\n  Alongside this fix, we plan to remove the \"fun creator pid\" feature in OTP 27.\n  See\n  [Upcoming Potential Incompatibilities](`e:general_info:upcoming_incompatibilities.md#fun_creator_pid`)\n  for more details.\n\n  Own Id: OTP-18498\n\n- Fixed a crash during tracing on certain platforms that cannot use the machine\n  stack for Erlang code (mainly OpenBSD and Linux with musl).\n\n  Own Id: OTP-18561","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The [`enif_set_option()`](erl_nif.md#enif_set_option) function has been\n  introduced into the NIF API. It can be used in order to set the\n  [`ERL_NIF_OPT_DELAY_HALT`](erl_nif.md#delay_halt) and/or\n  [`ERL_NIF_OPT_ON_HALT`](erl_nif.md#on_halt) options with which one can\n  synchronize halt of the runtime system with flushing enabled and execution of\n  NIFs.\n  [Halt of the runtime system _without_ flushing enabled](`erlang:halt/2`), now\n  terminates the runtime system without execution of `atexit`/`on_exit` handlers\n  that may have been installed into the runtime system which might be considered\n  a potential incompatibility.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17771 Aux Id: GH-5325, PR-6370\n\n- The TTY/terminal subsystem has been rewritten by moving more code to Erlang\n  from the old linked-in driver and implementing all the I/O primitives needed\n  in a NIF instead.\n\n  On Unix platforms the user should not notice a lot of difference, besides\n  better handling of unicode characters and fixing of some long standing bugs.\n\n  Windows users will notice that erl.exe has the same functionality as a normal\n  Unix shell and that werl.exe has been removed and replaced with a symlink to\n  erl.exe. This makes the Windows Erlang terminal experience identical to that\n  of Unix.\n\n  The re-write brings with it a number of bug fixes and feature additions:\n\n  - The TTY is now reset when Erlang exits, fixing zsh to not break when\n    terminating an Erlang session.\n  - `standard_error` now uses the same unicode mode as `standard_io`.\n  - Hitting backspace when searching the shell history with an empty search\n    string no longer breaks the shell.\n  - Tab expansion now works on remote nodes started using the JCL interface.\n  - It is now possible to configure the shell slogan and the session slogans\n    (that is the texts that appear when you start an Erlang shell). See the\n    kernel documentation for more details.\n  - Added shell:start_interactive for starting the interactive shell from a\n    non-interactive Erlang session (for example an escript).\n  - On Windows, when starting in detached mode the standard handler are now set\n    to `nul` devices instead of being unset.\n  - Standard I/O now always defaults to `unicode` mode if supported. Previously\n    the default was `latin1` if the runtime system had been started with\n    `-oldshell` or `-noshell` (for example in an `escript`). To send raw bytes\n    over standard out, one now explicitly has to specify\n    `io:setopts(standard_io, [{encoding, latin1}]).`\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17932 Aux Id: PR-6144 GH-3150 GH-3390 GH-4343 GH-4225\n\n- Add support for socket on Windows.\n\n  - Pre release status.\n  - Error codes not finalized.\n  - No explicit support for Windows specific options (socket options, flags for\n    read and write).\n  - New async api for Windows (completion). See the `Asynchronous calls` chapter\n    in the (Socket Usage) Users Guide.\n  - To ensure platform independence, gen_tcp and gen_udp is _intended_ to be\n    used (not yet updated).\n\n  Own Id: OTP-18029\n\n- Updated configure cache for Windows. This makes configure run faster on\n  Windows as many more checks are cached.\n\n  Own Id: OTP-18053 Aux Id: PR-6101\n\n- Optimized record updates.\n\n  Own Id: OTP-18126 Aux Id: PR-6033\n\n- Optimized internal hash routines.\n\n  Own Id: OTP-18131\n\n- As announced when OTP 25 was released,\n  [multi time warp mode](time_correction.md#multi-time-warp-mode) is now enabled\n  by default. This assumes that all code executing on the system is\n  [time warp safe](time_correction.md#time-warp-safe-code).\n\n  If you have old code in the system that is not time warp safe, you now\n  explicitly need to start the system in\n  [no time warp mode](time_correction.md#no-time-warp-mode) (or\n  [singe time warp mode](time_correction.md#single-time-warp-mode) if it is\n  partially time warp safe) in order to avoid problems. When starting the system\n  in no time warp mode, the system behaves as it did prior to the introduction\n  of the extended time functionality introduced in OTP 18.\n\n  If you have code that is not time warp safe, you are strongly encouraged to\n  change this so that you can use multi time warp mode. Compared to no time warp\n  mode, multi time warp mode improves scalability and performance as well as\n  accuracy and precision of time measurements.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18135 Aux Id: GH-4965, PR-6046\n\n- There are several new optimization for binary syntax in the JIT:\n\n  - Creation and matching of binaries with segments of fixed sizes have been\n    optimized.\n  - Creation and matching of UTF-8 segments have been optimized.\n  - Appending to binaries has been optimized.\n\n  Own Id: OTP-18137 Aux Id: PR-6259, PR-6404, PR-6576, PR-6804\n\n- As announced since the release of OTP 24, support for:\n\n  - version 4 node container types in the external term format are now\n    mandatory. That is, references supporting up to 5 32-bit integer\n    identifiers, and process and port identifiers with support for 64-bit data\n    storage. The distribution flag\n    [`DFLAG_V4_NC`](erl_dist_protocol.md#DFLAG_V4_NC) is therefor now also\n    mandatory. OTP has since OTP 24 supported this. Also note that the external\n    format produced by `term_to_binary()` and `term_to_iovec()` will\n    unconditionally produce pids, ports, and references supporting this larger\n    format.\n  - the [new link protocol](erl_dist_protocol.md#new_link_protocol) introduced\n    in OTP 23.3 is now mandatory. The distribution flag\n    [`DFLAG_UNLINK_ID`](erl_dist_protocol.md#DFLAG_UNLINK_ID) is therefor now\n    also mandatory.\n\n  Due to the above, OTP 26 nodes will refuse to connect to OTP nodes from\n  releases prior to OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18140 Aux Id: PR-6072\n\n- Optimization of\n  [_process aliases_](`e:system:ref_man_processes.md#process-aliases`) made\n  possible now that support for\n  [version 4 node container types](erl_dist_protocol.md#DFLAG_V4_NC) in the\n  external term format is mandatory.\n\n  Own Id: OTP-18141 Aux Id: OTP-18140, PR-6073\n\n- The compiler and JIT now generate better code for creation of small maps where\n  all keys are literals known at compile time.\n\n  Own Id: OTP-18185 Aux Id: GH-6139\n\n- When `erl -eval` fails to execute a command, an error description is printed\n  to standard_error.\n\n  Own Id: OTP-18227 Aux Id: PR-6254\n\n- Support for UTF-8 atoms and strings in the NIF interface including new\n  functions `enif_make_new_atom`, `enif_make_new_atom_len` and\n  `enif_get_string_length`.\n\n  Own Id: OTP-18334 Aux Id: PR-6434\n\n- The following `inet:setopts/2` options have been introduced:\n\n  - **[`reuseport`](`m:inet#option-reuseport`)** - Reuse of local port. Load\n    balancing may or may not be provided depending on underlying OS.\n\n  - **[`reuseport_lb`](`m:inet#option-reuseport_lb`)** - Reuse of local port.\n    Load balancing provided.\n\n  - **[`exclusiveaddruse`](`m:inet#option-exclusiveaddruse`)** - Exclusive\n    address/port usage on Windows. This socket option is Windows specific and\n    will silently be ignored on other systems.\n\n  The behavior of setting [`reuseaddr`](`m:inet#option-reuseaddr`) on Windows\n  have changed in a _backwards incompatible_ way. The underlying `SO_REUSEADDR`\n  socket option is now only set if both the `reusaddr` and the `reuseport`\n  `inet` options have been set. This since the underlying `SO_REUSEADDR` socket\n  option on Windows behaves similar to how BSD behaves if both the underlying\n  socket options `SO_REUSEADDR` and `SO_REUSEPORT` have been set. See the\n  documentation of the `reuseaddr` option for more information.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18344 Aux Id: PR-6522, PR-6944, OTP-18324, PR-6481, GH-6461\n\n- `erlang:display/1` will now print large maps in a more readable way (similar\n  to how small maps are printed).\n\n  Own Id: OTP-18360 Aux Id: PR-6497\n\n- The BIFs [`min/2`](`min/2`) and [`max/2`](`max/2`) are now allowed to be used\n  in guards and match specs.\n\n  Own Id: OTP-18367 Aux Id: GH-6544\n\n- Fail `enif_init_resource_type` and friends by returning NULL if not called\n  during load/upgrade. Old behavior was undefined.\n\n  Own Id: OTP-18369\n\n- New option `include_shared_binaries` for the `max_heap_size` process limit. If\n  set to `true`, large binaries (> 64 bytes), which may be referred by several\n  processes, are included in the memory sum compared against the `max_heap_size`\n  limit.\n\n  Own Id: OTP-18410 Aux Id: GH-5889, PR-6345\n\n- Map comprehensions as suggested in EEP 58 has now been implemented.\n\n  Own Id: OTP-18413 Aux Id: EEP-58, PR-6727\n\n- Some map operations have been optimized by changing the internal sort order of\n  atom keys. This changes the (undocumented) order of how atom keys in small\n  maps are printed and returned by `maps:to_list/1` and `maps:next/1`. The new\n  order is unpredictable and may change between different invocations of the\n  Erlang VM.\n\n  For applications where order is important, there is a new function\n  `maps:iterator/2` for creating iterators that return the map elements in a\n  deterministic order. There are also new modifiers `k` and `K` for the format\n  string for [`io:format()`](`t:io:format/0`) to support printing map elements\n  ordered.\n\n  Own Id: OTP-18414 Aux Id: PR-6151\n\n- Reduced memory usage of `file:read_file_info/1,2`\n\n  Own Id: OTP-18424 Aux Id: PR-6716\n\n- Add new function `current_stacktrace` for trace match specifications used by\n  `erlang:trace_pattern/3`.\n\n  This new option puts the current stacktrace of the caller into the trace\n  message sent to the trace receiver.\n\n  Own Id: OTP-18425 Aux Id: PR-6628, GH-5333\n\n- The amount of significant bits in node local process identifiers and port\n  identifiers has been extended from 28 bits to 60 bits on 64-bit runtime\n  systems. This makes these identifiers large enough to in practice never having\n  to be reused during the life time of a node.\n\n  Own Id: OTP-18435 Aux Id: PR-6827\n\n- New trace feature `call_memory`. Similar to `call_time` tracing, but instead\n  of measure accumulated time in traced functions it measures accumulated heap\n  space consumed by traced functions. It can be used to compare how much\n  different functions are contributing to garbage collection being triggered.\n\n  Own Id: OTP-18440 Aux Id: PR-6351\n\n- It is no longer necessary to enable a feature in the runtime system in order\n  to load modules that are using it. It is sufficient to enable the feature in\n  the compiler when compiling it.\n\n  That means that to use feature `maybe_expr` in Erlang/OTP 26, it is sufficient\n  to enable it during compilation.\n\n  In Erlang/OTP 27, feature `maybe_expr` will be enabled by default, but it will\n  be possible to disable it.\n\n  Own Id: OTP-18445\n\n- Handling of `on_load` modules during boot has been improved by adding an extra\n  step in the boot order for embedded mode that runs all `on_load` handlers,\n  instead of relying on explicit invocation of them, later, when the kernel\n  supervision tree starts.\n\n  This is mostly a code improvement and OTP internal simplification to avoid\n  future bugs and to simplify code maintenance.\n\n  Own Id: OTP-18447\n\n- Introduced the [`local`](`m:erlang#term_to_binary_local`) option of\n  [`term_to_binary/2`](`erlang:term_to_binary/2`) and\n  [`term_to_iovec/2`](`erlang:term_to_iovec/2`).\n\n  Own Id: OTP-18477 Aux Id: PR-7006\n\n- Document the commonly used practice to create and store static atoms at NIF\n  load time in callbacks `load` or `upgrade`.\n\n  Own Id: OTP-18483 Aux Id: PR-6888\n\n- Optimize `ets:lookup_element` for uncompressed tables by using a more\n  efficient method to copy the term from ETS to the heap of the calling process.\n\n  Own Id: OTP-18493 Aux Id: PR-6272\n\n- The default encoding of atoms by `term_to_binary` and `term_to_iovec` have\n  changed from Latin1 to UTF-8. The old encoding can still be obtained with\n  options `{minor_version, 1}`.\n\n  Apart from encoding code points between 128 and 255 with two bytes (UTF-8)\n  instead of one, most atoms will occupy one less byte as the length field use\n  only one byte instead of two if possible.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18505 Aux Id: PR-6991\n\n- The version of zlib included in the Erlang/OTP source code is now 1.2.13.\n\n  Own Id: OTP-18517\n\n- `gen_tcp:send/*`, `gen_udp:send/*` and `gen_sctp:send/*` have been optimized\n  to use the infamous receive reference optimization, so now sending should not\n  have bad performance when the calling process has a large message queue.\n\n  Own Id: OTP-18520 Aux Id: GH-6455\n\n- Added the new built-in type `t:dynamic/0` introduced in EEP-61, improving\n  support for gradual type checkers.\n\n  Own Id: OTP-18522\n\n- Optimize `maps:merge/2` memory consumption for small maps (<33 keys) by\n  reusing key tuples or entire maps if the result map has the same number of\n  keys as any of the argument maps.\n\n  Own Id: OTP-18523 Aux Id: PR-7004\n\n- Optimize `maps:merge/2` memory consumption further for small maps by mutating\n  2nd map to use literal key tuple of 1st map if both have the same keys.\n\n  Own Id: OTP-18524 Aux Id: PR-7004, OTP-18523\n\n- [`ceil/1`](`ceil/1`), [`floor/1`](`floor/1`),\n  [`is_bitstring/1`](`is_bitstring/1`), [`is_boolean/1`](`is_boolean/1`),\n  [`is_function/2`](`is_function/2`), and [`tuple_size/1`](`tuple_size/1`) can\n  now be used in match specifications.\n\n  Own Id: OTP-18526 Aux Id: GH-7045\n\n- Allow IPv6 addresses as host in `http` packets decoded by\n  `erlang:decode_packet/3` and `gen_tcp` packet option. The IPv6 address should\n  be enclosed within `[]` according to RFC2732.\n\n  Own Id: OTP-18540 Aux Id: PR-6900\n\n- Removed the experimental `erts_alloc_config` module. It no longer produced\n  good configurations and cannot be fixed in a reasonably backwards compatible\n  manner. It has since OTP 25 been deprecated and scheduled for removal in\n  OTP 26.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18549 Aux Id: PR-7105\n\n- ERTS internal thread names have been changed. All threads created by ERTS now\n  have a prefix `erts_` followed by a type name potentially followed by an\n  integer index. For example, normal schedulers are now named `erts_sched_ `,\n  dirty CPU schedulers `erts_dcpus_ `, and dirty IO schedulers\n  `erts_dios_ `. NIF and driver thread names are truncated at 15 characters\n  regardless of whether the underlying platform support more characters or not.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18552 Aux Id: PR-6973\n\n- Further robustify implementation of large maps (> 32 keys). Keys that happen\n  to have same internal 32-bit hash values are now put in collision nodes which\n  are traversed with linear search. This removes the demand for the internal\n  hash function when salted to eventually produce different hashes for all\n  possible pairs of unequal terms.\n\n  Own Id: OTP-18569\n\n- In Erlang/OTP 27, `0.0` will no longer be considered to be exactly equal to\n  `-0.0`. See\n  [Upcoming Potential Incompatibilities](`e:general_info:upcoming_incompatibilities.md#float_matching`).\n\n  Own Id: OTP-18574","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 13.2.2.14 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed BEAM crash when a custom thread sends a large map (>128 keys) externally encoded with for example `erl_drv_send_term()`.\n\n  Own Id: OTP-19495 Aux Id: GH-8208, PR-8209","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.13 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Disabled an unsafe runtime optimization in binary construction that caused silent memory corruption.\n\n  Own Id: OTP-19462 Aux Id: ERIERL-1177, PR-9372","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.12 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fix lock order violation if a NIF monitor `down` callback calls `enif_whereis_pid`. Would cause debug emulator to crash but could potentially lead to deadlocks in optimized emulator.\n\n  Own Id: OTP-19330 Aux Id: GH-8983, PR-9008","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.11 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed beam crash that could happen if resetting `call_time` or `call_memory` trace counters of a function while it is called. Bug exists since OTP R16.\n\n  Own Id: OTP-19269 Aux Id: GH-8835, PR-8897","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.10 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* `'DOWN'` messages originating from a monitored port, contained the atom `process` instead of the atom `port` as the third element when the exit reason was not an immediate term.\n\n  Own Id: OTP-19123 Aux Id: GH-8484, PR-8546\n* When [*no time warp mode*](time_correction.md#no-time-warp-mode) was enabled, a smaller Erlang monotonic time could be read than a previously read time, i.e., breaking the monotonic property. The runtime system will abort when detecting an issue like this since OTP 24.3.4.17 and OTP 25.0.\n\n  Up until OTP 25 *no time warp mode* is the default. As of OTP 26 [*multi time warp mode*](time_correction.md#multi-time-warp-mode) is the default.\n\n  Own Id: OTP-19147 Aux Id: ERIERL-1043, ERIERL-1106, PR-8619\n* A scheduler thread could get stuck when deleting a memory allocator carrier when adjacent carriers were deleted and/or inserted simultaneously by other schedulers. This in turn could cause the other schedulers to get stuck as well.\n\n  Own Id: OTP-19154 Aux Id: GH-8613, PR-8627","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.9 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* ETS functions did not properly handle keys containing maps, sometimes matching too many or too few objects.\n\n  Own Id: OTP-19070 Aux Id: GH-8385\n* Fix CPU quota determination for cgroups.\n\n  The bug was introduced through OTP-18999.\n\n  Own Id: OTP-19071 Aux Id: OTP-18999 PR-8380","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fixed CPU quota determination for cgroup version 2\n\n  Own Id: OTP-18999 Aux Id: GH-7928\n* Fix faulty reduction counting in exiting process which could cause it to do unnecessary yielding.\n\n  Own Id: OTP-19014\n* Calling `erlang:trace/3` with first argument one of `ports`, `processes`, `existing_ports`, `existing_processes`, `existing` or `all`, could cause emulator crash if a dirty scheduler was executing a simultaneous trace action.\n\n  Own Id: OTP-19034\n* Fixed an integer overflow when the monotonic time unit reported by the operating system was greater than 10 and lower than 100 microseconds.\n\n  Own Id: OTP-19036 Aux Id: GH-8186\n* When a traced process executing on a dirty scheduler received an exit signal, the dirty scheduler could use the wrong thread specific data which could lead to a crash.\n\n  Own Id: OTP-19043 Aux Id: PR-8342\n* Fixed a more or less harmless bug that caused time correction of Erlang monotonic time to become slightly off on Windows platforms when `QueryPerformanceCounter()` was used as OS monotonic time source.\n\n  `erlang:system_info(os_monotonic_time_source)` now also returns information about *used resolution* which not always corresponds to the resolution of the OS monotonic time source.\n\n  Own Id: OTP-19048 Aux Id: PR-8343","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"* Checks for monotonicity of monotonic time have been improved so that Erlang and OS monotonic time are checked separately.\n\n  A new `configure` argument `--enable-ensure-os-monotonic-time` has also been added. It enables functionality ensuring the monotonicity of monotonic timestamps delivered by the OS. When a non-monotonic timestamp is detected, it will be replaced by the last delivered monotonic timestamp before being used by Erlang's time functionality. Note that you do *not* want to enable this unless the OS monotonic time source on the system fails to produce monotonic timestamps. This since ensuring the monotonicity of OS monotonic timestamps will hurt scalability and performance of the system.\n\n  Own Id: OTP-19044 Aux Id: ERIERL-1043, PR-8342\n* For severe errors, when the \\`socket\\` module terminates the Erlang VM, now an erl_crash.dump is produced, to facilitate post mortem debugging.\n\n  Own Id: OTP-19058","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 13.2.2.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* Fix heap corruption bug that could cause runaway memory consumption due to circular offheap list at process exit. Other symptoms may also be possible. Bug exists since OTP 25.0.\n\n  Own Id: OTP-18971 Aux Id: GH-8044\n* The code server could be hanging if a module with `on_load` function was loaded at the same time as another module was purged using `erlang:purge_module` directly.\n\n  Own Id: OTP-19006\n* A process optimized for parallel signal delivery could under some circumstances lose wakeup information. That is, the processes was not woken up to take care of the signal, so the signal would not be taken care of until the process was woken by another signal. Only processes configured with [`message_queue_data`](`m:erlang#process_flag_message_queue_data`) set to `off_heap` utilize this optimization.\n\n  Own Id: OTP-19008 Aux Id: GH-8119, PR-8201\n* Fix bug in `re:run/3` where if an invalid UTF-8 subject was given, re:run could get stuck in an infinite loop. Bug was introduced in Erlang/OTP 22.1.\n\n  Own Id: OTP-19015 Aux Id: ERIERL-682","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* 32-bit runtime systems on most Unix like platforms could crash if a BIF timer was set with a huge timeout of more than 68 years into the future. In order for the crash to occur, the huge timer (at a later time than when it was set) had to become the nearest active timer set on the specific scheduler on which it was set. This could not happen on a system with only one scheduler since there would always be shorter timers in the system.\n\n  Setting a timer larger than 49 days on Windows could under rare circumstances cause the timeout to be delayed.\n\n  Own Id: OTP-18911 Aux Id: ERIERL-1023, PR-7983\n* Garbage collection of a process on a dirty scheduler could collide with signal handling for that process causing a crash of the runtime system. This bug was introduced in OTP 25.3.2.8 and OTP 26.2.\n\n  Own Id: OTP-18957 Aux Id: GH-8051, PR-8088, OTP-18841","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix faulty debug assert when page size is larger than 16kb, like on PowerPC.\n  Did crash debug VM directly at start.\n\n  Own Id: OTP-18802\n\n- A process with `message_queue_data` configured as `off_heap` could end up in\n  an inconsistent state when being `receive` traced, inspected using\n  [`process_info/2`](`process_info/2`) with the `message_queue_len` item, or\n  inspected using the break menu (CTRL-C). When it ended up in this inconsistent\n  state, it was not enqueued into a run queue even though it was set in a\n  runnable state.This also effected signals being sent to the process after it\n  had gotten into this inconsistent state, in such a way that it was from this\n  point not possible to communicate with it.\n\n  Own Id: OTP-18838 Aux Id: PR-7822, GH-7801\n\n- A race occurring when a process was selected for dirty execution\n  simultaneously as it was scheduled for handling a signal could cause the\n  process to end up in an inconsistent state. When it ended up in this\n  inconsistent state, it was not enqueued into a run queue even though it was\n  set in a runnable state. This also effected signals being sent to the process\n  after it had gotten into this inconsistent state, in such a way that it was\n  from this point not possible to communicate with it.\n\n  Own Id: OTP-18839 Aux Id: PR-7822, GH-7801\n\n- When a process had to to wait in the run queue for a long time before being\n  selected for dirty execution, it could not receive signals. This caused\n  inspection of such a process, for example using\n  [`process_info/2`](`process_info/2`), to take a long time.\n\n  This issue was introduced in OTP 25.3.2.6 and 26.1 when fixing an issue where\n  a constant flow of signals prevented a process from being able to execute\n  dirty.\n\n  Own Id: OTP-18841 Aux Id: PR-7822, GH-7801, OTP-18737\n\n- Fixed a bug in the JIT that miscompiled large `select_val` instructions.\n\n  Own Id: OTP-18842\n\n- On OTP 24 and OTP 25, incoming distributed messages larger than 64 KiB sent\n  using an alias leaked memory if the alias had been removed prior to entering\n  the node. This issue was not present on OTP 26.\n\n  Incoming distributed messages larger than 64 KiB sent using an alias which had\n  been removed on the receiving node could crash the node. This crash was quite\n  unlikely on OTP 24 and OTP 25, but very likely on OTP 26.\n\n  `'DOWN'` signals with exit reason larger than 64 KiB directed towards a\n  process on a node with a not matching creation leaked memory on the receiving\n  node. Such signals should however be very rare.\n\n  Own Id: OTP-18885 Aux Id: GH-7834, GH-7890, PR-7915\n\n- Removed unnecessary PCRE source tar-ball.\n\n  Own Id: OTP-18902","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Removed unnecessary regexp library used when generating yielding BIFs.\n\n  Own Id: OTP-18830 Aux Id: PR-7823\n\n- Replaced old md5 implementation with an implementation from OpenSSL.\n\n  Own Id: OTP-18877\n\n- Removed unused `makewhatis` script.\n\n  Own Id: OTP-18899","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 13.2.2.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If the external term format encoding of an argument list part of a distributed\n  spawn operation was faulty, the newly spawned remote process could misbehave.\n  The misbehavior included hanging or interpret an incoming message as an\n  argument list to use. This was very unlikely to happen unless using an\n  alternate implementation of the distribution protocol which made a faulty\n  encoding of the argument list. The child process will now detect this error\n  and terminate before executing the user specified code.\n\n  Own Id: OTP-18790 Aux Id: PR-7742\n\n- On Apple Silicon Macs running macOS Sonoma, the runtime system with the JIT\n  enabled would crash. Therefore, the `configure` script will by default now\n  disable the JIT on Macs with Apple Silicon. When building for earlier versions\n  of macOS, the JIT can be explicitly enabled by passing `--enable-jit` to the\n  `configure` script.\n\n  Own Id: OTP-18792 Aux Id: GH-7687\n\n- Fix bugs where if the body of a matchspec would return a map with a variable\n  ('$1', '$\\_' etc) as one of the keys or values and the variable was not an\n  immidiate, the term would not be copied to the receiving processes heap. This\n  would later corrupt the term in the table as the GC could place move markers\n  in it, which in turn would cause the VM to crash.\n\n  Bug has been present for since OTP 17.0.\n\n  Own Id: OTP-18797 Aux Id: PR-7712 GH-7683","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process optimized for parallel signal delivery could under some\n  circumstances lose wakeup information. That is, the processes was not woken up\n  to take care of the signal, so the signal would not be taken care of until the\n  process was woken by another signal. Only processes configured with\n  [`message_queue_data`](`m:erlang#process_flag_message_queue_data`) set to\n  `off_heap` utilize this optimization.\n\n  Own Id: OTP-18647 Aux Id: PR-7595\n\n- Delivery time of message signals to a process not executing any `receive`\n  expressions could become very long, potentially infinite. For example, a\n  process checking for messages using\n  [`process_info(self(), message_queue_len)`](`process_info/2`) or\n  [`process_info(self(), messages)`](`process_info/2`) and avoiding to execute a\n  `receive` expression matching on messages could be very slow in detecting new\n  messages. Note that you are still discouraged from using `process_info()` this\n  way. A process that wants to check if there are messages available to handle\n  should execute a `receive` expression matching on messages.\n\n  Own Id: OTP-18706 Aux Id: GH-7413, PR-7595, ERIERL-979\n\n- Fix bug causing \"magic\" references in a `compressed` ETS table to not keep the\n  referred object alive. The symptom would be the referred object being garbage\n  collected prematurely and the reference appearing stale, not referring to\n  anything. Examples of such magically referred objects are `atomics` and NIF\n  resources.\n\n  Own Id: OTP-18732 Aux Id: GH-7444, PR-7458\n\n- A constant flow of incoming non-message signals could prevent a process\n  needing to execute dirty from doing so.\n\n  Own Id: OTP-18737 Aux Id: PR-7595\n\n- The cleanup operation of not yet delivered signals to a terminated process\n  yielded excessively.\n\n  Own Id: OTP-18752 Aux Id: PR-7633","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Multiple socket:accept calls issue. When making multiple accept calls, only\n  the last call is active.\n\n  Own Id: OTP-18635 Aux Id: #7328\n\n- The following functions are now much faster when given a long list or binary:\n\n  - erlang:list_to_integer/1\n  - erlang:binary_to_integer/1\n  - erlang:binary_to_integer/2\n  - erlang:list_to_integer/2\n  - string:to_integer/1\n\n  Own Id: OTP-18659 Aux Id: PR-7426","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a crash during tracing on certain platforms that cannot use the machine\n  stack for Erlang code (mainly OpenBSD and Linux with musl).\n\n  Own Id: OTP-18561\n\n- Constructing a binary segment not aligned with a byte boundary, with a size\n  not fitting in 31 bits, and with a value not fitting in a 64-bit word could\n  crash the runtime system.\n\n  Own Id: OTP-18597","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Further robustify implementation of large maps (> 32 keys). Keys that happen\n  to have same internal 32-bit hash values are now put in collision nodes which\n  are traversed with linear search. This removes the demand for the internal\n  hash function when salted to eventually produce different hashes for all\n  possible pairs of unequal terms.\n\n  Own Id: OTP-18569","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 13.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If a runtime system which was starting the distribution already had existing\n  pids, ports, or references referring to a node with the same nodename/creation\n  pair that the runtime system was about to use, these already existing pids,\n  ports, or references would not work as expected in various situations after\n  the node had gone alive. This could only occur if the runtime system was\n  communicated such pids, ports, or references prior to the distribution was\n  started. That is, it was extremely unlikely to happen unless the distribution\n  was started dynamically and was even then very unlikely to happen. The runtime\n  system now checks for already existing pids, ports, and references with the\n  same nodename/creation pair that it is about to use. If such are found another\n  creation will be chosen in order to avoid these issues.\n\n  Own Id: OTP-18570 Aux Id: PR-7190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in the loader that prevented certain modules compiled with\n  `no_ssa_opt` from being loaded.\n\n  Own Id: OTP-18519 Aux Id: GH-7024\n\n- Implementations of the [`call()`](driver_entry.md#call) driver callback that\n  returned a faulty encoded result could cause a memory leak and could cause\n  invalid data on the heap of the processes calling `erlang:port_call/3`.\n\n  Own Id: OTP-18525 Aux Id: PR-7049\n\n- Fixed a memory corruption issue when upgrading code. The bug was introduced in\n  `OTP 25.3`\n\n  Own Id: OTP-18553\n\n- Fixed configure tests for a few ARM-specific instructions, which prevented the\n  emulator from being built on some platforms.\n\n  Own Id: OTP-18554\n\n- Aliases created in combination with a monitor using the\n  `{alias, explicit_unalias}` option stopped working from remote nodes when a\n  `'DOWN'` signal had been received due to the monitor or if the monitor was\n  removed using the `erlang:demonitor()` BIF.\n\n  This bug was introduced in OTP 24.3.4.10 and OTP 25.3.\n\n  Own Id: OTP-18557 Aux Id: PR-7131, OTP-18496\n\n- In rare circumstances, bit syntax matching of an invalid code point for a\n  `utf32` would crash the runtime system.\n\n  Own Id: OTP-18560\n\n- Building the runtime system failed when native atomic support was missing.\n  Note that execution on such systems have only been rudimentary tested.\n\n  Own Id: OTP-18563 Aux Id: GH-7114, PR-7159","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug on Windows where `file:read_file_info/1` would fail for files with\n  corrupt metadata.\n\n  Own Id: OTP-18348 Aux Id: GH-6356\n\n- Fix [`process_info(_, binary)`](`process_info/2`) to again include \"writable\n  binaries\" which were lost in OTP-25.0. Writable binaries are an optimization\n  used when binaries are appended upon in a loop.\n\n  Own Id: OTP-18373 Aux Id: PR-6574, GH-6573\n\n- Fix rare race when receiving fragmented messages on a terminating connection.\n  Could potentially cause memory leaks as well as double free crashes. Bug\n  exists since OTP 22.0.\n\n  Own Id: OTP-18382 Aux Id: PR-6585\n\n- Fixed bug that could maybe cause problems when a file descriptor number is\n  closed by a linked in driver and then opened (reused) and passed to\n  `enif_select` by a NIF. No actual symptoms seen, only failed internal\n  assertions in debug build.\n\n  Own Id: OTP-18391\n\n- The runtime system could crash when tracing a process executing on a dirty\n  scheduler.\n\n  Own Id: OTP-18398 Aux Id: PR-6495, GH-6448, GH-5984\n\n- In the binary syntax, attempting to match out integers with size exceeding 2\n  GiB could crash the runtime system.\n\n  Own Id: OTP-18406 Aux Id: GH-6701\n\n- Fixed edge case in floating-point negation where `A = 0.0, B = -A` did not\n  produce `B = -0.0` on x86_64 JIT.\n\n  Own Id: OTP-18411 Aux Id: GH-6717\n\n- Fixed an issue in the JIT that could crash the emulator on some platforms.\n\n  Own Id: OTP-18418\n\n- Added meta data to the windows installer.\n\n  Own Id: OTP-18429 Aux Id: PR-6587 GH-4232 GH-6537\n\n- Fixed ETS insertion order into `bag` and `duplicate_bag` of tuples with\n  identical keys when passed in a list to `ets:insert/2`. The insert order has\n  been head-to-tail but was accidentally changed in OTP 23.0. For `bag` it was\n  reverted (tail-to-head), while for `duplicate_bag` it was sometimes reverted\n  depending on the length of the list and number of \"reductions\" left for the\n  calling process.\n\n  This fix changes the insert order of `ets:insert/2` back to always be\n  head-to-tail of the list argument.\n\n  Own Id: OTP-18434 Aux Id: PR-6752\n\n- With the JIT for AArch64 (AMD64), calling `bxor` in with non-integer arguments\n  in a guard would crash the runtime system.\n\n  Own Id: OTP-18454 Aux Id: PR-6839\n\n- Fix bug regarding process flag `max_heap_size`. Could cause strange behavior\n  when a process was killed due to exceeding the limit.\n\n  Own Id: OTP-18457 Aux Id: PR-6816\n\n- Fixed binary comprehensions to be similar to other creation of binary data\n  with respect to its contribution of triggering garbage collection.\n\n  Own Id: OTP-18458\n\n- In rare circumstances, when a process exceeded its allowed heap size set by\n  option `max_heap_size`, it would not be killed as it should be, but instead\n  enter a kind of zombie state it would never get out of.\n\n  Own Id: OTP-18463 Aux Id: PR-6858\n\n- Instead of crashing, the [`list_to_integer/1`](`list_to_integer/1`) and\n  [`list_to_integer/2`](`list_to_integer/2`) BIFs now raise the `system_limit`\n  exception for overlong lists that can't be converted to integers. Similarly,\n  the `string:to_integer/1` BIF now returns `{error,system_limit}` for overlong\n  lists.\n\n  Own Id: OTP-18475 Aux Id: PR-6897\n\n- Active process aliases of a process at its termination leaked memory.\n\n  Own Id: OTP-18496 Aux Id: GH-6947, PR-6953","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Support for fully asynchronous distributed signaling where send operations\n  _never_ block. This functionality is by default disabled and can be enabled\n  per process. For more information see the documentation of\n  [`process_flag(async_dist, Bool)`](`m:erlang#process_flag_async_dist`).\n\n  Own Id: OTP-18374 Aux Id: PR-6632\n\n- Added the `+JPperf no_fp` option to explicitly disable Erlang frame pointers\n  otherwise added when using the `+JPperf map` option.\n\n  Own Id: OTP-18426","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 13.1.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Comparisons between small numbers and pids or ports would in some edge cases\n  say that the number was greater than the pid or port, violating the term\n  order.\n\n  Own Id: OTP-18415\n\n- [`process_info(Pid, status)`](`process_info/2`) when `Pid /= self()` could\n  return an erroneous result.\n\n  Own Id: OTP-18421 Aux Id: PR-6806","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.1.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in selective receive optimization that could crash 32-bit\n  emulators.\n\n  Own Id: OTP-18383 Aux Id: ERIERL-905\n\n- A race condition which was very rarely triggered could cause the signal queue\n  of a process to become inconsistent causing the runtime system to crash.\n\n  Own Id: OTP-18388 Aux Id: OTP-17462, PR-6662","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix perf/gdb JIT symbols to not contain `CodeInfoPrologue` for the JIT\n  internal module erts_beamasm.\n\n  Own Id: OTP-18256 Aux Id: PR-6316\n\n- Fixed minor memory leaks.\n\n  Own Id: OTP-18281 Aux Id: PR-4840\n\n- Fix bugs in `ets:insert` and `ets:insert_new` when called with a list of\n  tuples to insert while a concurrent process either deletes or renames the\n  table. The table deletion could be done with `ets:delete/1` or be caused by\n  termination of the table owning process.\n\n  Symptoms are either VM crash or strange incorrect behavior from the insert\n  operation. The risk of triggering the bugs increases with the length of the\n  list of tuple to insert. Bugs exist since OTP 23.0.\n\n  Own Id: OTP-18284 Aux Id: PR-6305\n\n- Boost execution of scheduled thread progress jobs. This to prevent memory\n  exhaustion in extremely rapid allocation/deallocation scenarios, such as\n  repeated ETS table creations/deletions.\n\n  Own Id: OTP-18294 Aux Id: PR-6390\n\n- Fix segv crash during crash dumping an ETS table doing\n  `ets:delete_all_objects`.\n\n  Own Id: OTP-18295\n\n- Spec for function net:if_names/0 incorrect\n\n  Own Id: OTP-18296 Aux Id: OTP-16464\n\n- Fix bug in `binary_to_term` decoding a binary term 2Gbyte or larger.\n\n  Own Id: OTP-18306 Aux Id: GH-6393, PR-6401\n\n- Documentation of `erlang:module_loaded/1` has been adjusted:\n\n  - It did not previously say that the BIF only returns `true` for modules\n    loaded as _current code_.\n  - The warning claiming that the BIF should only be used by the code server has\n    been removed.\n\n  Own Id: OTP-18313 Aux Id: PR-6456\n\n- Fix [`list_to_atom/1`](`list_to_atom/1`) for negative code points. Could\n  either return with a positive code point or fail with an incorrect exception.\n\n  Own Id: OTP-18321\n\n- Fix rare bug causing VM crash when sending to a pid of a spawning process\n  returned from `erlang:processes/0`.\n\n  Only seen when provoked by system process literal_area_collector, triggered by\n  a module purge operation, on a VM started with +Meamin (no customized\n  allocators).\n\n  Own Id: OTP-18322 Aux Id: PR-6479\n\n- gen_udp:open/2 with option(s) add_membership or drop_membership would drop\n  earlier options.\n\n  Own Id: OTP-18323 Aux Id: #6476\n\n- The `inet:setopts/2` `{reuseaddr, true}` option will now be ignored on Windows\n  unless the socket is an UDP socket. For more information see the documentation\n  of the `reuseaddr` option part of the documentation of `inet:setopts/2`.\n\n  Prior to OTP 25 the `{reuseaddr, true}` option was ignored for all sockets on\n  Windows, but as of OTP 25.0 this was changed so that it was not ignored for\n  any sockets.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18324 Aux Id: GH-6461, PR-6481\n\n- Fix bug in `binary_to_term` decoding a list of length 1G or longer.\n\n  Own Id: OTP-18328 Aux Id: GH-6439, PR-6440\n\n- Fix bug in `binary_to_term` (and distributed receive) when decoding a large\n  map (>32 keys) with unsorted small maps (<= 32) as keys of the large map.\n\n  This was only a problem if the term was encoded by `erl_interface`,\n  `jinterface` or otherwise, as the VM itself always encodes small maps with\n  sorted keys.\n\n  The \"binary_to_term\" would appear as successful but the created large map was\n  internally inconsistent. The smaller key-maps could not be found with maps:get\n  and friends. Other operations such as map compare and merge could probably\n  also give incorrect results.\n\n  Own Id: OTP-18343 Aux Id: GH-6496\n\n- Fix Windows bug in `open_port({spawn, Command}, ..)` when `Command` is found\n  via the OS search PATH and that directory path contains white spaces. The port\n  program would start but the command line arguments to it could be incorrect.\n\n  Own Id: OTP-18345 Aux Id: GH-6387, PR-6396","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.1.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in selective receive optimization that could crash 32-bit\n  emulators.\n\n  Own Id: OTP-18383 Aux Id: ERIERL-905\n\n- A race condition which was very rarely triggered could cause the signal queue\n  of a process to become inconsistent causing the runtime system to crash.\n\n  Own Id: OTP-18388 Aux Id: OTP-17462, PR-6662","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Add abandon carrier free utilization limit (`+Muacful`) option to erts_alloc.\n  This option allows the user to mark unused segments in a memory carrier as\n  re-useable by the OS if needed.\n\n  This functionality was a non-configurable default before Erlang/OTP 25, but\n  removed due to performance issues.\n\n  Own Id: OTP-18290 Aux Id: ERIERL-866 PR-6378","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Listen sockets created with the socket module, leaked (erlang-) monitors.\n\n  Own Id: OTP-18240 Aux Id: #6285\n\n- [Notifications about available distribution data](`erlang:dist_ctrl_get_data_notification/1`)\n  sent to distribution controller processes could be lost. Distribution\n  controller processes can be used when implementing an alternative distribution\n  carrier. The default distribution over tcp was not effected and the bug was\n  also not present on x86/x86_64 platforms.\n\n  Own Id: OTP-18258 Aux Id: GH-6309, PR-6324","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed inconsistency bugs in `m:global` due to `nodeup`/`nodedown` messages not\n  being delivered before/after traffic over connections. Also fixed various\n  other inconsistency bugs and deadlocks in both `m:global_group` and `global`.\n\n  As building blocks for these fixes, a new BIF `erlang:nodes/2` has been\n  introduced and `net_kernel:monitor_nodes/2` has been extended.\n\n  The [`-hidden`](erl_cmd.md#hidden) and\n  [`-connect_all`](erl_cmd.md#connect_all) command line arguments did not work\n  if multiple instances were present on the command line which has been fixed.\n  The new kernel parameter [`connect_all`](`e:kernel:kernel_app.md#connect_all`)\n  has also been introduced in order to replace the `-connect_all` command line\n  argument.\n\n  Own Id: OTP-17934 Aux Id: PR-6007\n\n- Fixed IPv6 multicast_if and membership socket options.\n\n  Own Id: OTP-18091 Aux Id: #5789\n\n- Accept funs (NEW_FUN_EXT) with incorrectly encoded size field. This is a\n  workaround for a bug (OTP-18104) existing in OTP 23 and 24 that could cause\n  incorrect size fields in certain cases. The emulator does not use the decoded\n  size field, but `erl_interface` still does and is not helped by this\n  workaround.\n\n  Own Id: OTP-18093 Aux Id: OTP-18104, PR-5987\n\n- Fixed issue with inet:getifaddrs hanging on pure IPv6 Windows\n\n  Own Id: OTP-18102 Aux Id: #5904\n\n- Fix faulty distribution encoding of terms with either\n\n  - a fun with bit-string or export-fun in its environment when encoded toward a\n    not yet established (pending) connection\n  - or a fun with a binary/bitstring, in its environment, referring to an\n    off-heap binary (larger than 64 bytes).\n\n  The symptom could be failed decoding on the receiving side leading to aborted\n  connection. Fix OTP-18093 is a workaround for theses bugs that makes the VM\n  accepts such faulty encoded funs.\n\n  The first encoding bug toward pending connection exists only in OTP 23 and 24,\n  but the second one exists also on OTP 25.\n\n  Own Id: OTP-18104 Aux Id: OTP-18093\n\n- Fixed emulator crash that could happen during crashdump generation of ETS\n  tables with options `ordered_set` and `{write_concurrency,true}`.\n\n  Own Id: OTP-18144 Aux Id: GH-5981\n\n- Retrieval of monotonic and system clock resolution on MacOS could cause a\n  crash and/or erroneous results.\n\n  Own Id: OTP-18160 Aux Id: PR-6103\n\n- Fix bug where the max allowed size of `erl +hmax` was lower than what was\n  allowed by `process_flag`.\n\n  Own Id: OTP-18161 Aux Id: PR-6081\n\n- On computers with ARM64 (AArch64) processors, the JIT could generate incorrect\n  code when more than 4095 bits were skipped at the tail end of a binary match.\n\n  Own Id: OTP-18201\n\n- In rare circumstances, an [`is_binary/1`](`is_binary/1`) guard test could\n  succeed when given a large integer.\n\n  Own Id: OTP-18216 Aux Id: GH-6239, PR-6240\n\n- Fix bug causing `ets:info` (and sometimes `ets:whereis`) to return 'undefined'\n  for an existing table if a concurrent process were doing `ets:insert` with a\n  long list on the same table.\n\n  Own Id: OTP-18218 Aux Id: ERIERL-855\n\n- Fix writing and reading of more than 2 GB in a single read/write operation on\n  macOS. Before this fix attempting to read/write more than 2GB would result in\n  `{error,einval}`.\n\n  Own Id: OTP-18222 Aux Id: PR-6248 GH-6242\n\n- Fix bug sometimes causing emulator crash at node shutdown when there are\n  pending connections. Only seen when running duel distribution protocols,\n  inet_drv and inet_tls_dist.\n\n  Own Id: OTP-18243 Aux Id: GH-6247, PR-6258","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Yield when adjusting large process message queues due to\n\n  - copying terms from a literal area prior to removing the literal area.\n  - changing the `message_queue_data` state from `on_heap` to `off_heap`.\n\n  The message queue adjustment work will now be interleaved with all other types\n  of work that processes have to do, even other message queue adjustment work.\n\n  Own Id: OTP-17340 Aux Id: PR-6133\n\n- Add rudimentary debug feature (option) for the inet-driver based sockets, such\n  as gen_tcp and gen_udp.\n\n  Own Id: OTP-18032\n\n- Introduced the `hidden` and `dist_listen` options to `net_kernel:start/2`.\n\n  Also documented the [`-dist_listen`](erl_cmd.md#dist_listen) command line\n  argument which was erroneously documented as a `kernel` parameter and not as a\n  command line argument.\n\n  Own Id: OTP-18107 Aux Id: PR-6009\n\n- New documentation chapter \"Debugging NIFs and Port Drivers\" under\n  Interoperability Tutorial.\n\n  Own Id: OTP-18109\n\n- Add new API function erl_features:configurable/0\n\n  Own Id: OTP-18199 Aux Id: PR-5790","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 13.0.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The [`monitor/3`](`erlang:monitor/3`) BIF did not apply options to the created\n  monitor if the target process or port did not exist. That is, the\n  corresponding down message would get a `` `DOWN` `` tag even if a custom tag\n  had been set, and the returned reference was not an alias even if the `alias`\n  option had been passed.\n\n  Own Id: OTP-18190 Aux Id: GH-6185, PR-6209\n\n- The `erlang:monotonic_time/1`, `erlang:system_time/1`, `erlang:time_offset/1`,\n  and `os:system_time/1` BIFs erroneously failed when passed the argument\n  `native`.\n\n  Own Id: OTP-18197 Aux Id: GH-6165, PR-6213","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Distributed exit signals could be lost under the following conditions:\n\n  - An exit signal from a parent process to a child process was lost if:\n\n    - the parent process terminated before the spawn request that created the\n      child had completed,\n    - the spawn request set up a link between parent and child\n    - the spawn request was distributed, and\n    - the exit reason was larger than one machine word.\n\n  - Loss of a connection over which a not yet completed spawn request was\n    ongoing could cause loss of exit signals. Such loss of exit signals was very\n    rare. Besides the above described connection loss also the following\n    conditions had to be satisfied:\n\n    - The spawn request that was interrupted by the connection loss also had to\n      set up a link between the parent process and the child process.\n    - The parent process that issued the spawn request also had to be\n      terminating while the spawn request was interrupted by the connection\n      loss.\n    - The same parent process also had to have made other spawn requests to\n      other nodes than to the node to which the connection was lost.\n    - These spawn requests to the other nodes also had to set up links.\n    - These spawn requests to the other nodes also had to be not yet completed\n      at the time of the connection loss. That is, the spawn reply from the\n      child process had not yet reached the parent process.\n\n    If all the conditions above were met, exit signals to the children spawned\n    due to the above described spawn requests to other nodes _could_ be lost.\n\n    The above bug also caused a significant memory leak when it was triggered\n    since the destruction of the parent process never completed.\n\n  Own Id: OTP-18164 Aux Id: PR-6114\n\n- A race could cause [`process_info(Pid, message_queue_len)`](`process_info/2`)\n  on other processes to return invalid results.\n\n  Own Id: OTP-18169 Aux Id: PR-6134\n\n- Fixed reduction counting for handling process system tasks.\n\n  Own Id: OTP-18170 Aux Id: PR-6135\n\n- Priority elevation of terminating processes did not work which could cause\n  execution of such processes to be delayed.\n\n  Own Id: OTP-18175 Aux Id: PR-6142\n\n- An unlink operation made by a process that terminated before the unlink\n  operation completed, i.e., before it had received an unlink-ack signal from\n  the linked process, caused an exit signal to erroneously be sent from the\n  terminating process to the process being unlinked. This exit signal would most\n  often be ignored by the receiver, but if the receiver of the exit signal\n  concurrently set up a new link, it could receive the exit signal with the\n  actual exit reason of the terminating process instead of a `noproc` exit\n  reason. It is however very hard to detect that this has happened and has no\n  obvious negative consequences, so it should be considered harmless.\n\n  A distributed unlink-ack signal received by a terminating process was also not\n  properly removed which could cause a minor memory leak.\n\n  Own Id: OTP-18177 Aux Id: PR-6150","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- On computers with the ARM64 (AArch64) architecture (such as Apple Silicon\n  Macs) a `rem` expression followed by a `div` expression with the same operands\n  could evaluate to the wrong result if the result of the `rem` expression was\n  unused.\n\n  Own Id: OTP-18143","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A `spawn_reply` signal from a remote node could be delayed and be delivered\n  after other signals from the newly spawned process.\n\n  When this bug triggered, the connection to the node where the process was\n  spawned sometimes could be taken down due to the bug. The following error\n  message would then be logged if this happened:\n  `Missing 'spawn_reply' signal from the node   detected by   on the node  . The node   probably suffers from the bug with ticket id OTP-17737.`\n\n  This bug only affected processes which had enabled\n  [`off_heap` `message_queue_data`](`m:erlang#process_flag_message_queue_data`)\n  and parallel reception of signals had been automatically enabled.\n\n  This bug was introduced in OTP 25.0, ERTS version 13.0.\n\n  Own Id: OTP-18105 Aux Id: OTP-16982, PR-6003\n\n- Fixed type spec of `erlang:system_info(dist_ctrl)`.\n\n  Own Id: OTP-18106 Aux Id: PR-5992\n\n- The zlib built in to the runtime system has been updated to version 1.2.12.\n  (Note that on most platforms, the platform's own zlib is used.)\n\n  Own Id: OTP-18123 Aux Id: GH-5994\n\n- The `erlang:is_alive()` BIF could return `true` before configured distribution\n  service was available. This bug was introduced in OTP 25.0 ERTS version 13.0.\n\n  The `erlang:monitor_node()` and `erlang:monitor()` BIFs could erroneously fail\n  even though configured distribution service was available. This occurred if\n  these BIFs were called after the distribution had been started using dynamic\n  node name assignment but before the name had been assigned.\n\n  Own Id: OTP-18124 Aux Id: OTP-17558, PR-6032","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 13.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-13-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The socket option 'reuseaddr' is _no longer_ ignored on Windows.\n\n  Own Id: OTP-17447 Aux Id: GH-4819\n\n- The growth rate of writable binaries has been adjusted to only increase by 20%\n  after 16MB in size. Before this change the size would always double.\n\n  This change may degrade write performance of large binaries.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17569 Aux Id: PR-4793\n\n- Fix reduction counting bug in `re:run` that caused the function to yield too\n  frequently when doing `global` matches.\n\n  Own Id: OTP-17661 Aux Id: PR-5165\n\n- Fix spelling mistakes in epmd error messages.\n\n  Own Id: OTP-17758 Aux Id: PR-5391\n\n- Fix bug where the \"newshell\" would trigger a newline at the column width of\n  the terminal, even if the next character to be printed was a newline. This\n  would cause the terminal to render two newlines instead of one.\n\n  Own Id: OTP-17779 Aux Id: GH-5403 PR-5599\n\n- Fix the memory value returned from `ets:info(Tid,memory)` when the\n  `read_concurrency` option is used.\n\n  Before this fix the memory used by the scheduler specific lock cache lines was\n  not counted towards the total. This caused the returned memory usage to be\n  very incorrect on systems with many schedulers for tables with man locks.\n\n  Own Id: OTP-17832 Aux Id: PR-5494\n\n- Fix the undocumented `--profile_boot` option to work again.\n\n  Own Id: OTP-17836 Aux Id: PR-5546\n\n- \\[socket] Encode of sockaddr has been improved.\n\n  Own Id: OTP-18020\n\n- Fix `erl_child_setup` (the program used by `open_port({spawn,...})` and\n  `os:cmd/1`) to better handle partial reads from the Erlang VM.\n\n  Own Id: OTP-18047 Aux Id: PR-5861\n\n- The runtime system would crash when attempting to create more than 33554431\n  atoms.\n\n  Own Id: OTP-18068 Aux Id: GH-5903","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Users can now configure ETS tables with the `{write_concurrency, auto}`\n  option. This option forces tables to automatically change the number of locks\n  that are used at run-time depending on how much concurrency is detected. The\n  `{decentralized_counters, true}` option is enabled by default when\n  `{write_concurrency, auto}` is active.\n\n  Benchmark results comparing this option with the other ETS optimization\n  options are available here:\n\n  https://erlang.org/bench/ets_bench_result_lock_config.html\n\n  Own Id: OTP-15991 Aux Id: PR-5208\n\n- The net module now works on Windows.\n\n  Own Id: OTP-16464\n\n- To enable more optimizations, BEAM files compiled with OTP 21 and earlier\n  cannot be loaded in OTP 25.\n\n  Own Id: OTP-16702\n\n- Optimize minor garbage collection for processes with large number of binaries,\n  funs and/or external pids/ports/refs. This is a continuation of the\n  optimization (OTP-17602) released in OTP-24.1.\n\n  Own Id: OTP-16852 Aux Id: ERL-1347, PR-5195\n\n- The signal queue of a process with message_queue_data=off_heap\\* has been\n  optimized to allow parallel reception of signals from multiple processes.\n\n  This is possible to do as Erlang only guarantees that signals (i.e., message\n  signals and non-message signals) sent from a single process to another process\n  are ordered in send order. However, there are no ordering guarantees for\n  signals sent from different processes to a particular process. Therefore,\n  several processes can send signals in parallel to a specific process without\n  synchronizing with each other. However, such signal sending was previously\n  always serialized as the senders had to acquire the lock for the outer signal\n  queue of the receiving process. This parallel signal sending optimization\n  yields much better scalability for signal sending than what was previously\n  possible, see https://erlang.org/bench/sigq_bench_result.html for benchmark\n  results.\n\n  \\* Information about how to enable the message_queue_data=off_heap setting can\n  be found in the documentation of the function erlang:process_flag/2.\n\n  Own Id: OTP-16982 Aux Id: PR-5020\n\n- The JIT now works for 64-bit ARM processors.\n\n  Own Id: OTP-17119 Aux Id: PR-4869\n\n- Added support for the compile attribute `-nifs()` to empower compiler and\n  loader with information about which functions may be overridden as NIFs by\n  `erlang:load_nif/2`. It is recommended to use this attribute in all modules\n  that load NIF libraries.\n\n  Own Id: OTP-17151 Aux Id: ERIERL-590, PR-5479\n\n- A test case has been added to the otp_SUITE that test that the dependency\n  versions for OTP's applications are correct. The test case uses xref to check\n  if the used functions are available in the specified dependency versions. The\n  test case depends on the Erlang/OTP team's testing infrastructure and will be\n  skipped if its dependencies are not met.\n\n  Own Id: OTP-17224\n\n- An Erlang installation directory is now relocatable on the file system given\n  that the paths in the installation's `RELEASES` file are paths that are\n  relative to the installations root directory. The\n  `` `release_handler:create_RELEASES/4 `` function can generate a `RELEASES`\n  file with relative paths if its `RootDir` parameter is set to the empty\n  string.\n\n  Own Id: OTP-17304\n\n- The following distribution flags are now mandatory: `DFLAG_BIT_BINARIES`,\n  `DFLAG_EXPORT_PTR_TAG`, `DFLAG_MAP_TAGS`, `DFLAG_NEW_FLOATS`, and\n  `DFLAG_FUN_TAGS`. This mainly concerns libraries or application that implement\n  the distribution protocol themselves.\n\n  Own Id: OTP-17318 Aux Id: PR-4972\n\n- Input for `configure` scripts adapted to `autoconf` 2\\.71.\n\n  Own Id: OTP-17414 Aux Id: PR-4967\n\n- When binary construction using the binary syntax fails, the error message\n  printed in the shell and by `erl_error:format_exception/3,4` will contain more\n  detailed information about what went wrong.\n\n  Own Id: OTP-17504 Aux Id: GH-4971, PR-5281, PR-5752\n\n- The configuration files [`.erlang`](erl_cmd.md),\n  [`.erlang.cookie`](`e:system:distributed.md`) and\n  [`.erlang.crypt`](`m:beam_lib#module-erlang-crypt`) can now be located in the XDG\n  Config Home directory.\n\n  See the documentation for each file and `filename:basedir/2` for more details.\n\n  Own Id: OTP-17554 Aux Id: GH-5016 PR-5408 OTP-17821\n\n- Make [`byte_size/1`](`byte_size/1`) and `binary_part/2/3` callable from match\n  specs (in ETS and tracing).\n\n  Own Id: OTP-17555 Aux Id: PR-5027\n\n- Dynamic node name improvements: `erlang:is_alive/0` changed to return true for\n  pending dynamic node name and new function `net_kernel:get_state/0`.\n\n  Own Id: OTP-17558 Aux Id: OTP-17538, PR-5111, GH-5402\n\n- A new option called `short` has been added to the functions\n  `erlang:float_to_list` and `erlang:float_to_binary`. This option creates the\n  shortest correctly rounded string representation of the given float that can\n  be converted back to the same float again.\n\n  Own Id: OTP-17562 Aux Id: GH-4492\n\n- The tagged tuple tests and fun-calls have been optimized and are now a little\n  bit cheaper than previously.\n\n  These optimizations become possible after making sure that all boxed terms\n  have at least one word allocated after the arity word. This has been\n  accomplished by letting all empty tuples refer to the same empty tuple literal\n  which also reduces memory usage for empty tuples.\n\n  Own Id: OTP-17608\n\n- The signal queue benchmark in parallel_messages_SUITE and the ETS benchmark in\n  ets_SUITE have benchmark result visualization HTML pages with \"fill-screen\"\n  buttons to make the graphs bigger. This button did not work as intended\n  before. When pressing the button for a graph, the last graph got replaced with\n  a bigger version and not the one over the button. This is now fixed.\n\n  Own Id: OTP-17630\n\n- The test case num_bif_SUITE:t_float_to_string previously failed sometimes as\n  it assumed a certain rounding of floats printed with sprintf but the rounding\n  type is platform specific.\n\n  Own Id: OTP-17636\n\n- Optimize interpreter to create heap binaries of small match contexts if\n  possible.\n\n  This optimization was already done in the JIT.\n\n  Own Id: OTP-17660 Aux Id: PR-5164\n\n- Optimize integer multiplication for x86 JIT\n\n  Own Id: OTP-17667 Aux Id: PR-5237\n\n- Removed use of node creation value zero as a wildcard. Also prevent zero from\n  being used as creation by `erl_interface` and `jinterface` nodes.\n\n  Own Id: OTP-17682 Aux Id: PR-5347\n\n- Distributed spawn operations now require\n  [distributed `spawn_request()`](erl_dist_protocol.md#DFLAG_SPAWN) support.\n  Distributed `spawn_request()` was introduced in OTP 23. That is, distributed\n  spawn operations against Erlang nodes of releases prior to OTP 23 will fail.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17683 Aux Id: PR-5306\n\n- The Erlang compiler now includes type information in BEAM files, and the JIT\n  can now use that type information to do optimizations such as eliminating or\n  simplifying type tests.\n\n  Own Id: OTP-17684 Aux Id: PR-5316, PR-5664\n\n- Improved the JIT's support for external tools like `perf` and `gdb`, allowing\n  them to show line numbers and even the original Erlang source code when that\n  can be found.\n\n  To aid them in finding the source code, the `absolute_path` compiler option\n  has been added to embed the absolute file path of a module.\n\n  Own Id: OTP-17685\n\n- Add \\[32-bit] to the Erlang shell title row for 32-bit VMs.\n\n  Own Id: OTP-17717 Aux Id: PR-5290\n\n- Instructions for how to build the runtime system for iOS/iPadOS can now be\n  found in `HOWTO/INSTALL.md`.\n\n  Own Id: OTP-17728 Aux Id: PR-5284\n\n- Add support for static Elixir NIF modules with non-alphanumeric characters by\n  using new macro `STATIC_ERLANG_NIF_LIBNAME`.\n\n  Own Id: OTP-17729 Aux Id: PR-5477\n\n- Add new function `caller_line` to for trace match specifications used by\n  erlang:trace_pattern/3.\n\n  This new option puts the line number of the caller into the trace message sent\n  to the trace receiver.\n\n  Own Id: OTP-17753 Aux Id: PR-5305 GH-5297\n\n- A new `erl` command line argument `+ssrct` has been introduced which will\n  cause the runtime system to skip reading CPU topology information. This reduce\n  start up time especially when the CPU topology is large. Reading of CPU\n  topology information is now also skipped if a user defined CPU topology is set\n  using the `+sct` command line argument.\n\n  Own Id: OTP-17762 Aux Id: GH-5204, PR-5219\n\n- The default time warp mode will change in Erlang/OTP 26. Added a warning about\n  this upcoming potential incompatibility to the documentation.\n\n  Own Id: OTP-17772 Aux Id: GH-4965 PR-5644\n\n- The emulator will no longer mark unused memory as discardable (e.g. through\n  `madvise(2)`), as it caused more problems than it solved.\n\n  Own Id: OTP-17824\n\n- When a record matching or record update fails, a\n  `{badrecord,ExpectedRecordTag}` exception used to be raised. In this release,\n  the exception has been changed to `{badrecord,ActualValue}`, where\n  `ActualValue` is the actual that was found instead of the expected record.\n\n  Own Id: OTP-17841 Aux Id: PR-5694\n\n- Removed the previously undocumented and unsupported `emem` tool.\n\n  Own Id: OTP-17892 Aux Id: PR-5591\n\n- Remove version number from the default install path on Windows.\n\n  Own Id: OTP-17899 Aux Id: PR-5524\n\n- On Windows apply the limit flag JOB_OBJECT_LIMIT_BREAKAWAY_OK in the Erlang\n  service to be able to start a OS child process with a different session\n  number.\n\n  Own Id: OTP-17927 Aux Id: PR-5283\n\n- New erl command line option `+IOs`. It can be used to disable scheduler thread\n  poll optimization, which has been seen to cause degraded event latency in some\n  use cases.\n\n  Own Id: OTP-17945 Aux Id: GH-4759, PR-5809\n\n- An API for multihomed SCTP connect has been added in the guise of\n  `gen_sctp:connectx_init/*`\n\n  Own Id: OTP-17951 Aux Id: PR-5656\n\n- \\[socket] Add encoding of the field hatype of the type sockaddr_ll (family\n  'packet').\n\n  Own Id: OTP-17968 Aux Id: OTP-16464\n\n- A cross compilation issue has been fixed about finding libdlpi during the\n  configure phase.\n\n  Own Id: OTP-17985 Aux Id: GH-5728\n\n- [`process_info/2`](`erlang:process_info/2`) now also accepts `parent` as\n  argument. When passed, the process identifier of the parent process will be\n  returned.\n\n  Own Id: OTP-17999 Aux Id: PR-5768\n\n- Add function attributes to `erl_nif` and `erl_driver` APis to improve compiler\n  detection of interface misuse.\n\n  Own Id: OTP-18006 Aux Id: PR-5932\n\n- The exported type `t:erlang:send_destination/0` has been introduced.\n\n  Own Id: OTP-18033 Aux Id: PR-2926, GH-5376\n\n- Building of the C/C++ make dependencies on Windows has been optimized to be a\n  lot faster.\n\n  Own Id: OTP-18036 Aux Id: PR-5846\n\n- `file:sync/1` will now use the `F_BARRIERFSYNC` flag when available on Mac OS.\n\n  Own Id: OTP-18038","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.3.2.17 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* The code server could be hanging if a module with `on_load` function was loaded at the same time as another module was purged using `erlang:purge_module` directly.\n\n  Own Id: OTP-19006\n* Fix bug in `re:run/3` where if an invalid UTF-8 subject was given, re:run could get stuck in an infinite loop. Bug was introduced in Erlang/OTP 22.1.\n\n  Own Id: OTP-19015 Aux Id: ERIERL-682\n* Calling `erlang:trace/3` with first argument one of `ports`, `processes`, `existing_ports`, `existing_processes`, `existing` or `all`, could cause emulator crash if a dirty scheduler was executing a simultaneous trace action.\n\n  Own Id: OTP-19034\n* Fixed an integer overflow when the monotonic time unit reported by the operating system was greater than 10 and lower than 100 microseconds.\n\n  Own Id: OTP-19036 Aux Id: GH-8186\n* When a traced process executing on a dirty scheduler received an exit signal, the dirty scheduler could use the wrong thread specific data which could lead to a crash.\n\n  Own Id: OTP-19043 Aux Id: PR-8342\n* Fixed a more or less harmless bug that caused time correction of Erlang monotonic time to become slightly off on Windows platforms when `QueryPerformanceCounter()` was used as OS monotonic time source.\n\n  `erlang:system_info(os_monotonic_time_source)` now also returns information about *used resolution* which not always corresponds to the resolution of the OS monotonic time source.\n\n  Own Id: OTP-19048 Aux Id: PR-8343","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"* Checks for monotonicity of monotonic time have been improved so that Erlang and OS monotonic time are checked separately.\n\n  A new `configure` argument `--enable-ensure-os-monotonic-time` has also been added. It enables functionality ensuring the monotonicity of monotonic timestamps delivered by the OS. When a non-monotonic timestamp is detected, it will be replaced by the last delivered monotonic timestamp before being used by Erlang's time functionality. Note that you do *not* want to enable this unless the OS monotonic time source on the system fails to produce monotonic timestamps. This since ensuring the monotonicity of OS monotonic timestamps will hurt scalability and performance of the system.\n\n  Own Id: OTP-19044 Aux Id: ERIERL-1043, PR-8342","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.3.2.16 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* 32-bit runtime systems on most Unix like platforms could crash if a BIF timer was set with a huge timeout of more than 68 years into the future. In order for the crash to occur, the huge timer (at a later time than when it was set) had to become the nearest active timer set on the specific scheduler on which it was set. This could not happen on a system with only one scheduler since there would always be shorter timers in the system.\n\n  Setting a timer larger than 49 days on Windows could under rare circumstances cause the timeout to be delayed.\n\n  Own Id: OTP-18911 Aux Id: ERIERL-1023, PR-7983","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.15 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix faulty debug assert when page size is larger than 16kb, like on PowerPC.\n  Did crash debug VM directly at start.\n\n  Own Id: OTP-18802\n\n- On OTP 24 and OTP 25, incoming distributed messages larger than 64 KiB sent\n  using an alias leaked memory if the alias had been removed prior to entering\n  the node. This issue was not present on OTP 26.\n\n  Incoming distributed messages larger than 64 KiB sent using an alias which had\n  been removed on the receiving node could crash the node. This crash was quite\n  unlikely on OTP 24 and OTP 25, but very likely on OTP 26.\n\n  `'DOWN'` signals with exit reason larger than 64 KiB directed towards a\n  process on a node with a not matching creation leaked memory on the receiving\n  node. Such signals should however be very rare.\n\n  Own Id: OTP-18885 Aux Id: GH-7834, GH-7890, PR-7915\n\n- Removed unnecessary PCRE source tar-ball.\n\n  Own Id: OTP-18902","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Removed unnecessary regexp library used when generating yielding BIFs.\n\n  Own Id: OTP-18830 Aux Id: PR-7823\n\n- Replaced old md5 implementation with an implementation from OpenSSL.\n\n  Own Id: OTP-18877\n\n- Removed unused `makewhatis` script.\n\n  Own Id: OTP-18899","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.3.2.14 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug causing \"magic\" references in a `compressed` ETS table to not keep the\n  referred object alive. The symptom would be the referred object being garbage\n  collected prematurely and the reference appearing stale, not referring to\n  anything. Examples of such magically referred objects are `atomics` and NIF\n  resources.\n\n  Own Id: OTP-18732 Aux Id: GH-7444, PR-7458\n\n- The cleanup operation of not yet delivered signals to a terminated process\n  yielded excessively.\n\n  Own Id: OTP-18752 Aux Id: PR-7633\n\n- If the external term format encoding of an argument list part of a distributed\n  spawn operation was faulty, the newly spawned remote process could misbehave.\n  The misbehavior included hanging or interpret an incoming message as an\n  argument list to use. This was very unlikely to happen unless using an\n  alternate implementation of the distribution protocol which made a faulty\n  encoding of the argument list. The child process will now detect this error\n  and terminate before executing the user specified code.\n\n  Own Id: OTP-18790 Aux Id: PR-7742\n\n- Fix bugs where if the body of a matchspec would return a map with a variable\n  ('$1', '$\\_' etc) as one of the keys or values and the variable was not an\n  immidiate, the term would not be copied to the receiving processes heap. This\n  would later corrupt the term in the table as the GC could place move markers\n  in it, which in turn would cause the VM to crash.\n\n  Bug has been present for since OTP 17.0.\n\n  Own Id: OTP-18797 Aux Id: PR-7712 GH-7683","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.13 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The following functions are now much faster when given a long list or binary:\n\n  - erlang:list_to_integer/1\n  - erlang:binary_to_integer/1\n  - erlang:binary_to_integer/2\n  - erlang:list_to_integer/2\n  - string:to_integer/1\n\n  Own Id: OTP-18659 Aux Id: PR-7426","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.12 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- In rare circumstances, bit syntax matching of an invalid code point for a\n  `utf32` would crash the runtime system.\n\n  Own Id: OTP-18560\n\n- If a runtime system which was starting the distribution already had existing\n  pids, ports, or references referring to a node with the same nodename/creation\n  pair that the runtime system was about to use, these already existing pids,\n  ports, or references would not work as expected in various situations after\n  the node had gone alive. This could only occur if the runtime system was\n  communicated such pids, ports, or references prior to the distribution was\n  started. That is, it was extremely unlikely to happen unless the distribution\n  was started dynamically and was even then very unlikely to happen. The runtime\n  system now checks for already existing pids, ports, and references with the\n  same nodename/creation pair that it is about to use. If such are found another\n  creation will be chosen in order to avoid these issues.\n\n  Own Id: OTP-18570 Aux Id: PR-7190\n\n- Constructing a binary segment not aligned with a byte boundary, with a size\n  not fitting in 31 bits, and with a value not fitting in a 64-bit word could\n  crash the runtime system.\n\n  Own Id: OTP-18597","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Further robustify implementation of large maps (> 32 keys). Keys that happen\n  to have same internal 32-bit hash values are now put in collision nodes which\n  are traversed with linear search. This removes the demand for the internal\n  hash function when salted to eventually produce different hashes for all\n  possible pairs of unequal terms.\n\n  Own Id: OTP-18569","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.3.2.11 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug sometimes causing emulator crash at node shutdown when there are\n  pending connections. Only seen when running duel distribution protocols,\n  inet_drv and inet_tls_dist.\n\n  Own Id: OTP-18243 Aux Id: GH-6247, PR-6258\n\n- Fix bug in `binary_to_term` (and distributed receive) when decoding a large\n  map (>32 keys) with unsorted small maps (<= 32) as keys of the large map.\n\n  This was only a problem if the term was encoded by `erl_interface`,\n  `jinterface` or otherwise, as the VM itself always encodes small maps with\n  sorted keys.\n\n  The \"binary_to_term\" would appear as successful but the created large map was\n  internally inconsistent. The smaller key-maps could not be found with maps:get\n  and friends. Other operations such as map compare and merge could probably\n  also give incorrect results.\n\n  Own Id: OTP-18343 Aux Id: GH-6496\n\n- Implementations of the [`call()`](driver_entry.md#call) driver callback that\n  returned a faulty encoded result could cause a memory leak and could cause\n  invalid data on the heap of the processes calling `erlang:port_call/3`.\n\n  Own Id: OTP-18525 Aux Id: PR-7049\n\n- Aliases created in combination with a monitor using the\n  `{alias, explicit_unalias}` option stopped working from remote nodes when a\n  `'DOWN'` signal had been received due to the monitor or if the monitor was\n  removed using the `erlang:demonitor()` BIF.\n\n  This bug was introduced in OTP 24.3.4.10 and OTP 25.3.\n\n  Own Id: OTP-18557 Aux Id: PR-7131, OTP-18496","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.10 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Active process aliases of a process at its termination leaked memory.\n\n  Own Id: OTP-18496 Aux Id: GH-6947, PR-6953","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.9 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [`process_info(Pid, status)`](`process_info/2`) when `Pid /= self()` could\n  return an erroneous result.\n\n  Own Id: OTP-18421 Aux Id: PR-6806\n\n- In rare circumstances, when a process exceeded its allowed heap size set by\n  option `max_heap_size`, it would not be killed as it should be, but instead\n  enter a kind of zombie state it would never get out of.\n\n  Own Id: OTP-18463 Aux Id: PR-6858","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in selective receive optimization that could crash 32-bit\n  emulators.\n\n  Own Id: OTP-18383 Aux Id: ERIERL-905\n\n- A race condition which was very rarely triggered could cause the signal queue\n  of a process to become inconsistent causing the runtime system to crash.\n\n  Own Id: OTP-18388 Aux Id: OTP-17462, PR-6662","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Spec for function net:if_names/0 incorrect\n\n  Own Id: OTP-18296 Aux Id: OTP-16464\n\n- Fix bug in `binary_to_term` decoding a binary term 2Gbyte or larger.\n\n  Own Id: OTP-18306 Aux Id: GH-6393, PR-6401\n\n- Fix [`list_to_atom/1`](`list_to_atom/1`) for negative code points. Could\n  either return with a positive code point or fail with an incorrect exception.\n\n  Own Id: OTP-18321\n\n- Fix bug in `binary_to_term` decoding a list of length 1G or longer.\n\n  Own Id: OTP-18328 Aux Id: GH-6439, PR-6440","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [Notifications about available distribution data](`erlang:dist_ctrl_get_data_notification/1`)\n  sent to distribution controller processes could be lost. Distribution\n  controller processes can be used when implementing an alternative distribution\n  carrier. The default distribution over tcp was not effected and the bug was\n  also not present on x86/x86_64 platforms.\n\n  Own Id: OTP-18258 Aux Id: GH-6309, PR-6324","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix writing and reading of more than 2 GB in a single read/write operation on\n  macOS. Before this fix attempting to read/write more than 2GB would result in\n  `{error,einval}`.\n\n  Own Id: OTP-18222 Aux Id: PR-6248 GH-6242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug causing `ets:info` (and sometimes `ets:whereis`) to return 'undefined'\n  for an existing table if a concurrent process were doing `ets:insert` with a\n  long list on the same table.\n\n  Own Id: OTP-18218 Aux Id: ERIERL-855","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix faulty distribution encoding of terms with either\n\n  - a fun with bit-string or export-fun in its environment when encoded toward a\n    not yet established (pending) connection\n  - or a fun with a binary/bitstring, in its environment, referring to an\n    off-heap binary (larger than 64 bytes).\n\n  The symptom could be failed decoding on the receiving side leading to aborted\n  connection. Fix OTP-18093 is a workaround for theses bugs that makes the VM\n  accepts such faulty encoded funs.\n\n  The first encoding bug toward pending connection exists only in OTP 23 and 24,\n  but the second one exists also on OTP 25.\n\n  Own Id: OTP-18104 Aux Id: OTP-18093\n\n- Distributed exit signals could be lost under the following conditions:\n\n  - An exit signal from a parent process to a child process was lost if:\n\n    - the parent process terminated before the spawn request that created the\n      child had completed,\n    - the spawn request set up a link between parent and child\n    - the spawn request was distributed, and\n    - the exit reason was larger than one machine word.\n\n  - Loss of a connection over which a not yet completed spawn request was\n    ongoing could cause loss of exit signals. Such loss of exit signals was very\n    rare. Besides the above described connection loss also the following\n    conditions had to be satisfied:\n\n    - The spawn request that was interrupted by the connection loss also had to\n      set up a link between the parent process and the child process.\n    - The parent process that issued the spawn request also had to be\n      terminating while the spawn request was interrupted by the connection\n      loss.\n    - The same parent process also had to have made other spawn requests to\n      other nodes than to the node to which the connection was lost.\n    - These spawn requests to the other nodes also had to set up links.\n    - These spawn requests to the other nodes also had to be not yet completed\n      at the time of the connection loss. That is, the spawn reply from the\n      child process had not yet reached the parent process.\n\n    If all the conditions above were met, exit signals to the children spawned\n    due to the above described spawn requests to other nodes _could_ be lost.\n\n    The above bug also caused a significant memory leak when it was triggered\n    since the destruction of the parent process never completed.\n\n  Own Id: OTP-18164 Aux Id: PR-6114\n\n- A race could cause [`process_info(Pid, message_queue_len)`](`process_info/2`)\n  on other processes to return invalid results.\n\n  Own Id: OTP-18169 Aux Id: PR-6134\n\n- Fixed reduction counting for handling process system tasks.\n\n  Own Id: OTP-18170 Aux Id: PR-6135\n\n- Priority elevation of terminating processes did not work which could cause\n  execution of such processes to be delayed.\n\n  Own Id: OTP-18175 Aux Id: PR-6142\n\n- An unlink operation made by a process that terminated before the unlink\n  operation completed, i.e., before it had received an unlink-ack signal from\n  the linked process, caused an exit signal to erroneously be sent from the\n  terminating process to the process being unlinked. This exit signal would most\n  often be ignored by the receiver, but if the receiver of the exit signal\n  concurrently set up a new link, it could receive the exit signal with the\n  actual exit reason of the terminating process instead of a `noproc` exit\n  reason. It is however very hard to detect that this has happened and has no\n  obvious negative consequences, so it should be considered harmless.\n\n  A distributed unlink-ack signal received by a terminating process was also not\n  properly removed which could cause a minor memory leak.\n\n  Own Id: OTP-18177 Aux Id: PR-6150\n\n- The [`monitor/3`](`erlang:monitor/3`) BIF did not apply options to the created\n  monitor if the target process or port did not exist. That is, the\n  corresponding down message would get a `` `DOWN` `` tag even if a custom tag\n  had been set, and the returned reference was not an alias even if the `alias`\n  option had been passed.\n\n  Own Id: OTP-18190 Aux Id: GH-6185, PR-6209\n\n- The `erlang:monotonic_time/1`, `erlang:system_time/1`, `erlang:time_offset/1`,\n  and `os:system_time/1` BIFs erroneously failed when passed the argument\n  `native`.\n\n  Own Id: OTP-18197 Aux Id: GH-6165, PR-6213","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed emulator crash that could happen during crashdump generation of ETS\n  tables with options `ordered_set` and `{write_concurrency,true}`.\n\n  Own Id: OTP-18144 Aux Id: GH-5981","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Accept funs (NEW_FUN_EXT) with incorrectly encoded size field. This is a\n  workaround for a bug (OTP-18104) existing in OTP 23 and 24 that could cause\n  incorrect size fields in certain cases. The emulator does not use the decoded\n  size field, but `erl_interface` still does and is not helped by this\n  workaround.\n\n  Own Id: OTP-18093 Aux Id: OTP-18104, PR-5987\n\n- The zlib built in to the runtime system has been updated to version 1.2.12.\n  (Note that on most platforms, the platform's own zlib is used.)\n\n  Own Id: OTP-18123 Aux Id: GH-5994","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Let EPMD tolerate failure when binding to IPv4/IPv6 loopback intefaces in\n  addition to user-supplied addresses via `ERL_EPMD_ADDRESS` or the `-address`\n  option. This can happen, for example, if the host system has ipv6 disabled via\n  the disable_ipv6 sysctl.\n\n  Own Id: OTP-17970 Aux Id: PR-5762\n\n- Fixed a rare bug in [`binary_to_term/1`](`binary_to_term/1`),\n  `enif_make_map_from_arrays`, `erl_drv_send_term`, and Erlang distribution that\n  could crash the emulator.\n\n  Own Id: OTP-18027\n\n- Fixed a rare race in `persistent_term:get/1,2` that could cause it to return\n  the value of another key.\n\n  Own Id: OTP-18065 Aux Id: GH-5908\n\n- Fix bug where the process message queue was left in an inconsistent state when\n  changing from on_heap to off_heap message queue data causing the GC to\n  segfault.\n\n  Own Id: OTP-18075 Aux Id: PR-5927\n\n- Fix functions that convert universal to localtime (such as erlang:localtime/0\n  and erlang:universaltime_to_localtime/1) to fetch the correct localtime if it\n  is changed after the start of the VM.\n\n  Own Id: OTP-18076 Aux Id: ERIERL-802 PR-5905\n\n- Fix memory leak when a process doing a distributed fragmented send is sent an\n  exit signal. Before this fix the receiving node would be left with an\n  incomplete message that would remain until the nodes were disconnected. The\n  bug has existed since Erlang/OTP 21.\n\n  Own Id: OTP-18077 Aux Id: GH-5876 PR-5892\n\n- Corrected the behaviour of the shutdown function when using with the\n  inet_backend = socket. It was not sufficiently compatible with the \"old\"\n  gen_tcp.\n\n  Own Id: OTP-18080 Aux Id: GH-5930","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- `erlang:open_port({spawn, _},_)` has been fixed on Windows to handle\n  whitespace characters in the path correctly.\n\n  This could, for example, cause execution of the resolver helper program\n  `inet_gethost` to fail and instead possibly execute a different program.\n\n  Own Id: OTP-17978 Aux Id: OTP-17958\n\n- Fix race condition when creating crash dump that could cause multiple threads\n  to race when writing the initial information in a crash dump.\n\n  The race condition was introduced in erts-12.2 (Erlang/OTP 24.2).\n\n  Own Id: OTP-17993 Aux Id: PR-5806\n\n- Fix Erlang monotonic time on MacOS. Previously used OS monotonic time\n  primitive on MacOS is buggy and will not be used anymore. It has been replaced\n  with usage of another OS monotonic time primitive that does not appear to be\n  buggy.\n\n  Own Id: OTP-17998 Aux Id: PR-5825, GH-5554","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in the x86 JIT that might cause floating point instructions to\n  wrongly throw an exception.\n\n  Own Id: OTP-17822\n\n- Preserve correct `nodedown_reason` if supervised distribution controller\n  processes exit with `{shutdown, Reason}`.\n\n  Own Id: OTP-17838 Aux Id: PR-5748\n\n- Handling of `send_timeout` for `gen_tcp` has been corrected so that the\n  timeout is honored also when sending 0 bytes.\n\n  Own Id: OTP-17840\n\n- By default `global` does _not_ take any actions to restore a fully connected\n  network when connections are lost due to network issues. This is problematic\n  for all applications expecting a fully connected network to be provided, such\n  as for example `mnesia`, but also for `global` itself. A network of\n  overlapping partitions might cause the internal state of `global` to become\n  inconsistent. Such an inconsistency can remain even after such partitions have\n  been brought together to form a fully connected network again. The effect on\n  other applications that expects that a fully connected network is maintained\n  may vary, but they might misbehave in very subtle hard to detect ways during\n  such a partitioning.\n\n  In order to prevent such issues, we have introduced a _prevent overlapping\n  partitions_ fix which can be enabled using the\n  [`prevent_overlapping_partitions`](`e:kernel:kernel_app.md#prevent_overlapping_partitions`)\n  `kernel(6)` parameter. When this fix has been enabled, `global` will actively\n  disconnect from nodes that reports that they have lost connections to other\n  nodes. This will cause fully connected partitions to form instead of leaving\n  the network in a state with overlapping partitions. Note that this fix _has_\n  to be enabled on _all_ nodes in the network in order to work properly. Since\n  this quite substantially changes the behavior, this fix is currently disabled\n  by default. Since you might get hard to detect issues without this fix you\n  are, however, _strongly_ advised to enable this fix in order to avoid issues\n  such as the ones described above. As of OTP 25 this fix will become enabled by\n  default.\n\n  Own Id: OTP-17843 Aux Id: ERIERL-732, PR-5611\n\n- Corrected the type specification of `erlang:seq_trace/2`.\n\n  Own Id: OTP-17900 Aux Id: GH-5667\n\n- Fix memory leak when tracing on running on a process that only handle system\n  tasks or non-message signals (for example process_info requests).\n\n  Own Id: OTP-17904 Aux Id: ERIERL-757","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Add support for using socket:sockaddr_in() and socket:sockaddr_in6() when\n  using gen_sctp, gen_tcp and gen_udp. This will make it possible to use Link\n  Local IPv6 addresses.\n\n  Own Id: OTP-17455 Aux Id: GH-4852\n\n- Show `on_load` failure reasons in embedded mode.\n\n  Own Id: OTP-17718 Aux Id: PR-5199\n\n- Compile date saved in the Erlang VM executable has been removed.\n\n  Own Id: OTP-17891 Aux Id: PR-5589\n\n- Improve documentation for the dynamic node name feature.\n\n  Own Id: OTP-17918","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a memory leak in `file:read_file_info/2` and `file:read_file/1` on\n  Windows.\n\n  Own Id: OTP-17827 Aux Id: GH-5527\n\n- Fix GC emulator crash when `spawn_request` was used when message tracing was\n  enabled.\n\n  Own Id: OTP-17871 Aux Id: PR-5612","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- When matching and constructing `utf16` segments in the binary syntax, the\n  `native` flag would be ignored. That is, the endian would always be big endian\n  even on a little-endian computer (almost all modern computers).\n\n  Own Id: OTP-17713\n\n- Fix the help printout of `+JPperf`.\n\n  Own Id: OTP-17749 Aux Id: PR-5378 GH-5361\n\n- Fix bug that could cause Erlang to deadlock during creation of an Erlang crash\n  dump.\n\n  Own Id: OTP-17751 Aux Id: PR-5315\n\n- Fixed C++ build errors on some aarch64 platforms.\n\n  Own Id: OTP-17763 Aux Id: GH-5351\n\n- For macOS, the `Info.plist` file embedded in the runtime system now only\n  contains the absolute minimum amount of information needed for the web view in\n  `wx` to work towards `localhost`. The other fields have been removed, allowing\n  an application packaged in a bundle to specify the application name and other\n  parameter in its own `Info.plist` file.\n\n  Own Id: OTP-17785 Aux Id: PR-5393\n\n- Fix bug in internal stacks (WSTACK and ESTACK) used by\n  [`term_to_binary/2`](`term_to_binary/2`) to encode terms. The bug could cause\n  a segfault if a very very large map was to be encoded with the `deterministic`\n  option given.\n\n  Own Id: OTP-17804 Aux Id: PR-5372\n\n- Improve the error printout when [`open_port/2`](`open_port/2`) fails because\n  of invalid arguments.\n\n  Own Id: OTP-17805 Aux Id: PR-5406\n\n- Fix bug in crash dumps where the stackframe of a process would be printed\n  using an incorrect format.\n\n  Crash dump viewer has also been fixed to be able read the broken stack format.\n\n  The bug has existed since Erlang/OTP 23.0.\n\n  Own Id: OTP-17814 Aux Id: PR-5462","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- An option for enabling dirty scheduler specific allocator instances has been\n  introduced. By default such allocator instances are disabled. For more\n  information see the documentation of the [`+Mdai`](erts_alloc.md#Mdai) `erl`\n  command line argument.\n\n  Own Id: OTP-17363 Aux Id: GH-4728, PR-5187\n\n- Minor optimization of receive markers in message queues.\n\n  Own Id: OTP-17673 Aux Id: OTP-16226\n\n- All predefined types have been added to the `erlang` module together with\n  documentation.\n\n  Any reference to a predefined type now links to that documentation so that the\n  user can view it.\n\n  Own Id: OTP-17689 Aux Id: PR-5292\n\n- Suppress a code checker warning caused by debug builds of YCF. YCF tries to\n  get a conservative estimate of the bottom of the stack by reading and\n  returning a call stack allocated variable.\n\n  Own Id: OTP-17719\n\n- Add file and product properties to erl.exe and werl.exe.\n\n  Own Id: OTP-17724 Aux Id: ERL-1224\n\n- Micro optimization in bitstring append operations.\n\n  Own Id: OTP-17760 Aux Id: ERIERL-725, PR-5414\n\n- Responsiveness of processes executing on `normal` or `low` priority could\n  suffer due to code purging or literal area removal on systems with a huge\n  amount of processes. This since during these operations all processes on the\n  system were scheduled for execution at once.\n\n  This problem has been fixed by introducing a limit on outstanding purge and\n  copy literal requests in the system. By default this limit is set to twice the\n  amount of schedulers on the system. This will ensure that schedulers will have\n  enough work scheduled to perform these operations as quickly as possible at\n  the same time as other work will be interleaved to a much higher degree.\n  Performance of these operations will however be somewhat degraded due to the\n  overhead of enforcing this limit compared to when using a very large limit.\n\n  This limit can be set by passing the `+zosrl` command line argument to `erl`,\n  or by calling\n  `erlang:system_flag(outstanding_system_requests_limit, NewLimit)`.\n\n  Own Id: OTP-17796 Aux Id: ERIERL-729, PR-5473","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.1.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The runtime system could call `select()` with a too large timeout value when\n  executing on MacOS. This could in turn cause the runtime system to crash.\n\n  Own Id: OTP-17735 Aux Id: GH-5339\n\n- The fix for Linux's behaviour when reconnecting an UDP socket in PR-5120\n  released in OTP-24.1.2 has been refined to only dissolve the socket's\n  connection before a connect if the socket is already connected, that is: only\n  for a reconnect.\n\n  This allows code to open a socket with an ephemeral port, get the port number\n  and connect; without the port number changing (on Linux). This turned out to\n  have at least one valid use case (besides test cases).\n\n  Should one reconnect the socket then the port number may change, on Linux; it\n  is a known quirk, which can be worked around by binding to a specific port\n  number when opening the socket. If you can do without an ephemeral port, that\n  is...\n\n  Own Id: OTP-17736 Aux Id: GH-5279, PR-5120, OTP-17559\n\n- Certain distributed signals that for various reasons must to be forced into\n  the distribution buffer even when it is full would instead be lost if the\n  distribution buffer was full when sent. The effected signals:\n\n  - `EXIT` signals with exit reasons of one word size.\n  - `DOWN` signals with exit reasons of one word size.\n  - `demonitor` signals from a terminating process.\n  - `unlink_ack` signals on OTP 23 and 24.\n  - `spawn_reply` signals on OTP 23 and 24.\n\n  Own Id: OTP-17737 Aux Id: GH-5346, GH-4989","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.1.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug where a gen_tcp write error that happened during a delayed_send would\n  cause a use after free segfault.\n\n  Own Id: OTP-17731 Aux Id: PR-5285\n\n- Fix x86 JIT bug where a `rem` instruction could cause a segfault if given\n  values that would cause an badarith exception.\n\n  Own Id: OTP-17732 Aux Id: PR-5331 ERIERL-664","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Reduction counter was not updated before and after doing `apply` operations on\n  the runtime system with the jit enabled. This caused reduction counting to get\n  out of sync if a garbage collection was made as part of the `apply` operation.\n\n  Own Id: OTP-17675\n\n- This fixes a bug in `erts_factory_undo` that caused the heap to not be reset\n  correctly. The `erts_factory_undo` function is, for example, called when a\n  [`binary_to_term/1`](`binary_to_term/1`) call fails to reset the heap to its\n  state before the [`binary_to_term/1`](`binary_to_term/1`) call. This can cause\n  the heap to contain invalid terms which potentially can cause issues (e.g.,\n  crashes) when the whole heap is scanned.\n\n  Own Id: OTP-17677\n\n- When attempting to construct a binary with an segment having an illegal type\n  for the size (e.g. an atom), there could be an unnecessary memory allocation\n  (and subsequent deallocation) before the operation failed. Amended to fail\n  before allocating any memory for the binary.\n\n  Own Id: OTP-17686\n\n- Fix bug in `persistent_term` when a key-value pair contains a magic reference\n  that is referred more than once. Magic references are NIF resources or\n  returned from BIFs like `ets:new`, `atomics:new`. The bug could cause the\n  memory of the referred resource to be prematurely deallocated.\n\n  The bug also apply to magic references in message passing on a runtime built\n  with configure option `--enable-sharing-preserving`.\n\n  Bug exist for 64-bit since OTP-24.0 and for 32-bit since OTP-20.0.\n\n  Own Id: OTP-17700 Aux Id: GH-5271, PR-5273\n\n- Fixed a crash when inspecting the stack trace of an exception raised at a very\n  high line number.\n\n  This bug was introduced in OTP 24.\n\n  Own Id: OTP-17712\n\n- The following two bugs that caused `erlang:demonitor()` to behave erroneously\n  have been fixed. The bugs were only triggered if the monitor that was removed\n  by `demonitor()` had previously been created simultaneously as a monitor and\n  as an alias.\n\n  - A demonitor operation on a monitor created using the\n    `{alias, reply_demonitor}` option erroneously behaved as if the\n    `{alias, explicit_unalias}` option had been used.\n  - A demonitor operation did not prevent a corresponding `'DOWN'` message from\n    being delivered if the monitor reference was kept as an active alias after\n    the operation. This could only occur if the monitored process simultaneously\n    terminated before the demonitor signal reached it, and the exit reason was\n    not an immediate term. That is, a term larger than one machine word.\n\n  Own Id: OTP-17722 Aux Id: GH-5310, PR-5313","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-1-2"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The python scripts that existed in\n  erts/lib_src/yielding_c_fun/lib/tiny_regex_c/scripts had a license that was\n  incompatible with Erlang/OTP's license. This ticket removes these scripts that\n  were not used by us.\n\n  Own Id: OTP-17658","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A race between an exiting port and handling of simultaneously received signals\n  to that port could cause a runtime system crash. The effected signals are\n  `link`, `monitor` and `demonitor`. On OTP 22 a similar race could also cause a\n  memory leak when receiving an `unlink` signal.\n\n  Own Id: OTP-17642 Aux Id: PR-5248\n\n- [A user defined tag on a monitor message](`erlang:monitor/3`) could cause the\n  runtime system to crash when the monitor message had been received.\n\n  Own Id: OTP-17646 Aux Id: GH-5221, PR-5232\n\n- A call to [`erlang:demonitor(Ref)`](`erlang:demonitor/1`) where the reference\n  `Ref` referred to an active alias, but not an active monitor, caused the\n  runtime system to crash.\n\n  Own Id: OTP-17647 Aux Id: GH-5225, PR-5230\n\n- The message queue of a process entered an inconsistent state after a `receive`\n  expression with an invalid timeout value was executed. If the exception raised\n  due to the invalid timeout value was caught, the following `receive`\n  expression executed by the process could fail to match messages already\n  present in the message queue.\n\n  On OTP 24 this could also cause the whole runtime system to crash.\n\n  Own Id: OTP-17651 Aux Id: GH-5235, PR-5244\n\n- Sending a `Port ! {PortOwner, close}` signal from a process other than the\n  port owner could erroneously trigger a `badsig` exit signal being sent to the\n  port owner process even though the correct `PortOwner` had been passed in the\n  signal.\n\n  Own Id: OTP-17665 Aux Id: PR-5248","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Atoms with Unicode code points greater than 255 (for example Greek or Cyrillic\n  characters) would not be displayed correctly by `crashdump_viewer`.\n\n  Own Id: OTP-17377\n\n- Fix rare minor memory leak related to jit code loading.\n\n  Own Id: OTP-17445 Aux Id: PR-4843\n\n- The extended error information has been corrected and improved for the\n  following BIFs: [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`),\n  [`list_to_existing_atom/1`](`list_to_existing_atom/1`),\n  `erlang:send_after/{3,4}`, and `erlang:start_timer/{3,4}`.\n\n  Own Id: OTP-17449 Aux Id: GH-4900\n\n- Fix bug provoked when building with gcc 10 and link time optimization (-flto),\n  causing Erlang compiler to crash. Bug exists since OTP-24.0.\n\n  Own Id: OTP-17477 Aux Id: GH-4846, PR-4894\n\n- Corrected bugs where builds were not reducible even when the `deterministic`\n  option was given. In particular, modules with map literals with more than 32\n  elements could cause this problem.\n\n  As part of this fix, the `term_to_binary` BIF now accepts the option\n  `deterministic`.\n\n  Own Id: OTP-17495 Aux Id: PR-5153\n\n- After an exception has been caught in a process, the stack trace would be kept\n  in the process longer than necessary.\n\n  Own Id: OTP-17512\n\n- Fix rare race bug in memory management of distribution entries. Have been seen\n  to cause VM crash when massive number of repeated concurrent failing\n  connection attempts.\n\n  Own Id: OTP-17513 Aux Id: GH-4964, PR-5015\n\n- The configure test for `--disable-esock-socket-registry` has been corrected so\n  disabling now works.\n\n  Own Id: OTP-17539\n\n- `init:stop()` no longer unloads loaded code before terminating the runtime\n  system. On systems with slow CPUs (such as Raspberry PI Zero), that can\n  significantly speed up termination of the runtime system.\n\n  Own Id: OTP-17542 Aux Id: GH-5031, PR-5032\n\n- Fixed match specifications that use maps in either the guard or the body to\n  work properly.\n\n  With this fix both keys and values in maps can be expressions.\n\n  Various other crashes and bugs when using maps in match specifications have\n  also been fixed.\n\n  Own Id: OTP-17567 Aux Id: PR-4915 PR-5115\n\n- Parsing of the result value in the native DNS resolver has been made more\n  defensive against incorrect results.\n\n  Own Id: OTP-17578 Aux Id: ERIERL-683\n\n- When [`binary_to_term/2`](`binary_to_term/2`) failed, the extended error\n  information would always blame the second argument even if the actual error\n  was in the first argument.\n\n  Own Id: OTP-17591 Aux Id: GH-5171\n\n- On 32-bit computers, `binary_to_term/1,2` is now more resilient against\n  corrupted binaries containing maps in the external format.\n\n  Own Id: OTP-17604\n\n- A call to [`process_info(Pid, status)`](`process_info/2`) could erroneously\n  report the status `running` when it should have reported `waiting`. This\n  occurred when the calling process was executing on a higher priority than the\n  process being inspected. This bug has been present since OTP 21.0 (erts\n  version 10.0).\n\n  Own Id: OTP-17628","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Optimize memory usage of erts internal processes used during code\n  loading/purging by hibernating them after a long time of inactivity.\n\n  Own Id: OTP-17426 Aux Id: PR-4785\n\n- Add the type `t:erlang:stacktrace/0`.\n\n  Own Id: OTP-17453 Aux Id: PR-4764\n\n- The arity argument of [`error/2,3`](`erlang:error/2`) can now be `none` to\n  indicate that the calling functions arity should be used.\n\n  Own Id: OTP-17456 Aux Id: PR-4764\n\n- Optimize match spec compiler for immediate (single word) constant terms.\n\n  Own Id: OTP-17469\n\n- Functions `erlang:set_cookie(Cookie)` and `erlang:get_cookie(Node)` have been\n  added for completeness and to facilitate configuring distributed nodes with\n  different cookies.\n\n  The documentation regarding distribution cookies has been improved to be less\n  vague.\n\n  Own Id: OTP-17538 Aux Id: GH-5063, PR-5111\n\n- A workaround has been implemented for Linux's quirky behaviour to not adjust\n  the source IP address when connecting a connected (reconnecing) UDP socket.\n\n  The workaround is to, on Linux, always dissolve any connection before\n  connecting an UDP socket.\n\n  Own Id: OTP-17559 Aux Id: GH-5092, PR-5120\n\n- The internal documentation for how to use Yielding C Fun (YCF) has been\n  updated to contain text about best practices for using YCF for ERTS.\n\n  Own Id: OTP-17596\n\n- Optimize garbage collection for processes with large number of binaries, funs\n  and/or external pids/ports/refs.\n\n  Own Id: OTP-17602 Aux Id: PR-5149","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 12.0.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A call to the `process_info()` BIF could end up hanging for ever due to a bug\n  introduced when the new selective receive optimization was introduced in OTP\n  24.0. Note that this bug only effects `process_info()`.\n\n  Own Id: OTP-17548 Aux Id: PR-5078, OTP-10391\n\n- Fix buffer overrun problem in the tty driver. The problem happens on some\n  platforms when using the CTRL+R functionality of newshell with very long\n  strings in the history.\n\n  Own Id: OTP-17560 Aux Id: GH-5116\n\n- Fix race-condition that could cause a crash when tracing scheduling or garbage\n  collections on a process that was running on a dirty scheduler.\n\n  Own Id: OTP-17568 Aux Id: PR-4940\n\n- Fix rare bug where re:run would crash/return invalid results when given a\n  subbinary as subject.\n\n  This bug has existed since Erlang/OTP 20.0.\n\n  Own Id: OTP-17585 Aux Id: GH-5150\n\n- `binary_to_term/1,2` is now more resilient against corrupted binaries\n  containing maps in the external format.\n\n  Own Id: OTP-17594","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A call to `erlang:cancel_timer(_, [{info, false}])` could cause the calling\n  process to block forever in the call. Note that only the synchronous version\n  of the call (that is, the `async` option is `false`) in combination with the\n  `info` option set to `false` was effected by this bug.\n\n  Own Id: OTP-17472 Aux Id: PR-4932\n\n- Microstate accounting (msacc) and `os:perf_counter()` unintentionally used\n  system time instead of monotonic time for time measurements on a lot of\n  systems. These systems were all non x86/x86_64 systems or x86/x86_64 systems\n  without a reliable and constant rdtsc instruction.\n\n  The lock counting (lcnt) built runtime system also unintentionally used system\n  time instead of monotonic time for time measurements on all systems.\n\n  Own Id: OTP-17493\n\n- Simultaneous calls to `erlang:system_flag(schedulers_online, _)` could cause\n  callers to end up in a suspended state forever.\n\n  Own Id: OTP-17500 Aux Id: GH-4809","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Not yet handled alias-message signals in the signal queue at the time when a\n  garbage collection was performed could cause a memory corruption which in turn\n  could result in a crash of the runtime system. This bug was introduced in OTP\n  24.0.\n\n  Own Id: OTP-17431 Aux Id: GH-4858, PR-4870, OTP-16718\n\n- Fixed bug when using external pids/ports in keys of big maps (> 32). Could\n  cause runtime crash. Bug exists since OTP 24.0.\n\n  Own Id: OTP-17436 Aux Id: PR-4875\n\n- After a node restart with `init:restart/0,1`, the module `socket` was not\n  usable because supporting tables had been cleared and not re-initialized. This\n  has now been fixed.\n\n  Handling of the \".\" domain as a search domain was incorrect and caused a crash\n  in the DNS resolver `inet_res`, which has now been fixed.\n\n  Own Id: OTP-17439 Aux Id: GH-4827, PR-4888, GH-4838\n\n- A call to `port_command()` could cause a scheduler to end up in an eternal\n  loop if the port was busy and the calling process had incoming signals at the\n  time of the call. This bug was introduced in OTP 23.3.2 (ERTS version 11.2.1),\n  OTP 22.3.4.18 (ERTS version 10.7.2.10), and OTP 21.3.8.23 (ERTS version\n  10.3.5.18).\n\n  Own Id: OTP-17448 Aux Id: GH-4898, PR-4903, OTP-17291\n\n- Bug fixes and code cleanup for the new `socket` implementation, such as:\n\n  Assertions on the result of demonitoring has been added in the NIF code, where\n  appropriate.\n\n  Internal state handling for socket close in the NIF code has been reviewed.\n\n  Looping over `close()` for `EINTR` in the NIF code has been removed, since it\n  is strongly discouraged on Linux and Posix is not clear about if it is\n  allowed.\n\n  The `inet_backend` temporary socket option for legacy `gen_tcp` sockets has\n  been documented.\n\n  The return value from `net:getaddrinfo/2` has been corrected: the `protocol`\n  field is now an `t:atom/0`, instead of, incorrectly,\n  [`list(atom())`](`t:list/1`). The documentation has also been corrected about\n  this return type.\n\n  Deferred close of a `socket:sendfile/*` file was broken and has been\n  corrected.\n\n  Some debug code, not enabled by default, in the socket NIF has been corrected\n  to not accidentally core dump for debug printouts of more or less innocent\n  events.\n\n  Own Id: OTP-17452\n\n- Dirty execution of a process in combination with an unlink signal from a port\n  to the process could cause the signal queue of the process to enter into an\n  inconsistent state. The result of the inconsistency typically caused a crash\n  of the runtime system. This bug was introduced in OTP 23.3 (ERTS version\n  11.2).\n\n  Own Id: OTP-17462 Aux Id: GH-4885, PR-4914, OTP-17127","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 12.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-12-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- `file:open/2` now throws an badarg error when opened with both the `ram` and\n  `raw` options.\n\n  Own Id: OTP-16822 Aux Id: PR-2723\n\n- The estone benchmark has been updated to better reflect changes in the\n  compiler and run-time system.\n\n  Own Id: OTP-16879\n\n- Fix profile guided optimization of run-time system when using GCC 7 or later.\n\n  Own Id: OTP-16880\n\n- Fix double close of fd when creating crash dump.\n\n  Own Id: OTP-16884\n\n- Improve `erl` error message when unable to open included `args_file`.\n\n  Own Id: OTP-17014\n\n- Remove warning text about the `--` operation from documentation\n\n  The `--` operation was optimized in Erlang/OTP 22 so that its worst case\n  complexity is O(N*log(N)), where N is the total size of the input lists.\n  Therefore, the warning in the documentation saying that the time complexity is\n  proportional to length(A)*length(B) is incorrect and is no longer needed.\n  Notice that Erlang/OTP 21 will no longer be supported when Erlang/OTP 24 gets\n  released.\n\n  Own Id: OTP-17020\n\n- A floating point zero (0.0) can be both positive (+0.0) and negative (-0.0).\n  Multiple bugs in the compiler, runtime system, and STDLIB have been fixed to\n  ensure that the minus sign on 0.0 is not lost.\n\n  Own Id: OTP-17077 Aux Id: ERL-1431, PR-2903, PR-2905, PR-2906\n\n- Fix compiler warnings produced by the clang compiler.\n\n  Own Id: OTP-17105 Aux Id: PR-2872\n\n- Windows process `erl.exe` killed if its service process `erlsrv.exe`\n  terminates.\n\n  Own Id: OTP-17131 Aux Id: PR-3031, GH-4360\n\n- The `configure` scripts in `crypto` and `erts` now fail if a requested feature\n  cannot be enabled.\n\n  Large parts of the `configure` script of `crypto` have been rewritten with\n  various improvements and bug fixes. It is now better at finding usable OpenSSL\n  libraries, but will in the following cases fail to detect OpenSSL libraries\n  where it previously sometimes detected the libraries by chance:\n\n  - OpenSSL installations with `include` directory and `lib` directory parts\n    installed in different base directories. In order to detect such\n    installations after this change, the user must explicitly specify the\n    locations using the\n    [`--with-ssl= `](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring`)\n    and the\n    [`--with-ssl-incl= `](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring`)\n    `configure` command line arguments.\n  - When building with old `gcc` compilers or other compilers on Debian\n    derivatives with multiarch directories under the `lib` directory. In order\n    to detect such installations after this change, the user must explicitly\n    specify the multiarch directory name using the\n    [`--with-ssl-lib-subdir=lib/ `](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring`)\n    `configure` command line argument.\n\n  Own Id: OTP-17254 Aux Id: ERIERL-618, GH-4230\n\n- The `erl` command line arguments `+Bi`, `+Bd`, and `+B` erroneously caused\n  reception of the `USR1` signal to terminate the runtime system without\n  creating a crash dump. Reception of the `USR1` signal now always cause\n  termination _with_ creation of a crash dump, regardless of command line\n  arguments passed. This bug has existed at least since OTP R5B.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17275 Aux Id: PR-4553\n\n- Add check to make sure that when passing an option to `erl` that requires an\n  argument, but none is given, we report an error. This fixes a bug introduced\n  in OTP-22.1 via OTP-15926.\n\n  Own Id: OTP-17314 Aux Id: OTP-15926, GH-4624, PR-\n\n- The \"Last calls\" section in crash dumps have been updated to print newlines\n  after each non-function `save_calls` state (send, receive, timeout).\n\n  Own Id: OTP-17329 Aux Id: PR-4730\n\n- Sockets created with socket:accept not counted (socket:info/0).\n\n  Own Id: OTP-17372","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The experimental `socket` module can now use any protocol (by name) the OS\n  supports. Suggested in PR-2641, implemented in PR-2670.\n\n  Own Id: OTP-14601 Aux Id: PR-2641, PR-2670, OTP-16749\n\n- New functions `enif_dynamic_resource_call` enables NIFs to call native code in\n  another NIF module. The call is done via a resource callback function\n  `dyncall` supplied by the user with the new `enif_init_resource_type`.\n\n  Own Id: OTP-14753\n\n- Runtime support for new improved selective receive optimization.\n\n  Own Id: OTP-16226 Aux Id: OTP-10391\n\n- The deprecated function `erlang:get_stacktrace/0` has been removed. Use the\n  new syntax in try/catch to retrieve the stack backtrace.\n\n  Own Id: OTP-16653\n\n- Support for handling abstract code created before OTP R15 has been dropped.\n\n  Own Id: OTP-16678 Aux Id: PR-2627\n\n- Extended error information for failing BIF calls as proposed in\n  [EEP 54](https://github.com/erlang/eep/blob/master/eeps/eep-0054.md) has been\n  implemented.\n\n  When a BIF call from the Erlang shell fails, more information about which\n  argument or arguments that were in error will be printed. The same extended\n  error information will by `proc_lib`, `common_test`, and `qlc` when BIF calls\n  fail.\n\n  For applications that wish to provide the same extended error information,\n  there are new functions `erl_error:format_exception/3` and\n  `erl_error:format_exception/4`.\n\n  There is a new [`error/3`](`error/3`) BIF that allows applications or\n  libraries to provide extended error information in the same way for their own\n  exceptions.\n\n  Own Id: OTP-16686\n\n- The `m:erlang` module documentation has been updated to improve clarity and\n  description of edge cases.\n\n  Own Id: OTP-16687 Aux Id: PR-2996 PR-2762\n\n- An example implementation of Erlang distribution over UDS using distribution\n  processes has been introduced.\n\n  Thanks to Jérôme de Bretagne\n\n  Own Id: OTP-16703 Aux Id: PR-2620\n\n- Improve code generation when creating funs by adding a new beam instruction\n  make_fun3 that does not do GC and allows for better register allocation.\n\n  Own Id: OTP-16712\n\n- The [_process alias_](`e:system:ref_man_processes.md#process-aliases`) feature\n  as outlined by\n  [EEP 53](https://github.com/erlang/eep/blob/master/eeps/eep-0053.md) has been\n  introduced. It is introduced in order to provide a lightweight mechanism that\n  can prevent late replies after timeout or connection loss. For more\n  information, see EEP 53 and the documentation of the new\n  [`alias/1`](`erlang:alias/1`) BIF and the new options to the\n  [`monitor/3`](`erlang:monitor/3`) BIF.\n\n  The `call` operation in the framework used by `gen_server`, `gen_statem`, and\n  `gen_event` has been updated to utilize alias in order to prevent late\n  responses. The `gen_statem` behavior still use a proxy process in the\n  distributed case, since it has always prevented late replies and aliases won't\n  work against pre OTP 24 nodes. The proxy process can be removed in OTP 26.\n\n  The alias feature also made it possible to introduce new functions similar to\n  the [`erpc:receive_response()`](`erpc:receive_response/2`) function in the gen\n  behaviors, so the new functions\n  [`gen_server:receive_response()`](`gen_server:receive_response/2`),\n  [`gen_statem:receive_response()`](`gen_statem:receive_response/2`),\n  [`gen_event:receive_response()`](`gen_event:receive_response/2`) have also\n  been introduced.\n\n  Own Id: OTP-16718 Aux Id: PR-2735\n\n- Accept 64-bit process identifiers from external nodes. This is the first step\n  in an upgrade path toward using 64-bit pids in a future OTP release.\n\n  Own Id: OTP-16720 Aux Id: PR-2680\n\n- The experimental new socket API has been further developed. Some backwards\n  incompatible changes with respect to OTP 23 have been made.\n\n  The control message format has been changed so a decoded value is now in the\n  'value' field instead of in the 'data' field. The 'data' field now always\n  contains binary data.\n\n  Some type names have been changed regarding message headers and control\n  message headers.\n\n  `socket:bind/2` now returns plain `ok` instead of `{ok, Port}` which was only\n  relevant for the `inet` and `inet6` address families and often not\n  interesting. To find out which port was chosen use `socket:sockname/1`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16749 Aux Id: OTP-14601\n\n- Remove old unused `+MYm` and `ERL_MALLOC_LIB` options.\n\n  Own Id: OTP-16788\n\n- Increase timer resolution on windows.\n\n  Own Id: OTP-16814 Aux Id: PR-2704\n\n- The code loader has been rewritten in order to be able to load JIT:ed code. As\n  a consequence of this, it is no longer possible to load HiPE code.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16878\n\n- Add support in the Erlang/OTP build system to generate a compilation database\n  that can be used by third-party tools (such as irony in Emacs) to compile the\n  erts C and C++ source code. Create the database using `make compdb`.\n\n  Own Id: OTP-16881\n\n- The BeamAsm JIT-compiler has been added to Erlang/OTP. The JIT-compiler is\n  enabled by default on most x86 64-bit platforms that have a C++ compiler that\n  can compile C++17. To verify that a JIT enabled emulator is running you can\n  use [`erlang:system_info(emu_flavor)`](`m:erlang#system_info_emu_flavor`).\n\n  For more information see the\n  [internal documentation of BeamAsm in erts](BeamAsm.md).\n\n  Own Id: OTP-16885 Aux Id: PR-2745\n\n- By default all ERTS internal memory allocators based on `alloc_util` will now\n  use their own separate carrier pool for migration of carriers instead of using\n  a node global carrier pool. This was the default behavior between OTP 17 and\n  OTP 21, but changed to use a node global carrier pool as of OTP 22.0. Usage of\n  the node global carrier pool proved troublesome since it had a tendency to\n  spread long lived blocks into allocators with normally short lived blocks\n  causing increased memory fragmentation. The node global carrier pool behavior\n  as well as other behaviors can be configured using the\n  [`+M cp`](erts_alloc.md#M_cp) command line argument.\n\n  Own Id: OTP-16898 Aux Id: OTP-16856\n\n- New functions have been added to the `maps` module: `merge_with/3`,\n  `intersect/2`, `intersect_with/3`, `filtermap/2`, `from_keys/2`, and\n  `maps:foreach/2`.\n\n  `maps:merge_with/3` is the same as `merge/2` but takes an extra fun that is\n  used to combine items with the same key.\n\n  `maps:intersect/2` computes the intersection of two maps.\n\n  `maps:intersect_with/3` is the same as `intersect/2` but takes an extra fun\n  that is used to combine intersecting items.\n\n  `maps:filtermap/2` allows filtering and mapping of a map in a single pass.\n\n  `maps:from_keys/2` constructs a map from a list of keys and a single value and\n  can be used to optimize sets operations such as from_list/1, filter/2,\n  intersection/2, and subtract/2.\n\n  `maps:foreach/2` allows iteration over a map without returning any value.\n\n  Own Id: OTP-16936 Aux Id: ERL-1367\n\n- Change `escript`s to output any errors or warnings to standard error instead\n  of standard out.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16945\n\n- A new erl parameter for specifying a file descriptor with configuration data\n  has been added. This makes it possible to pass the parameter \"-configfd FD\"\n  when executing the erl command. When this option is given, the system will try\n  to read and parse configuration parameters from the file descriptor.\n\n  Own Id: OTP-16952\n\n- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- The pretty printer for floating point number have been changed to make it\n  easier to see if the integer part of the number has been rounded. After the\n  change the digit that may have been rounded always appears last or just before\n  the exponent character (e or E). This is accomplished by always printing the\n  number using scientific notation if it is so large that the integer part could\n  be rounded.\n\n  Own Id: OTP-16980 Aux Id: ERL-1308\n\n- The `erlang:monitor_node/2` BIF will now fail with a `notalive` exception if\n  distribution has not been started on the current node; it used to fail with a\n  `badarg` exception.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16987\n\n- Accept references up to a size of 160-bits from remote nodes. This is the\n  first step in an upgrade path toward using references up to 160-bits in a\n  future OTP release.\n\n  Own Id: OTP-17005 Aux Id: OTP-16718\n\n- Accept 64-bit port identifiers from external nodes. This is the first step in\n  an upgrade path toward using 64-bit port identifiers in a future OTP release.\n\n  Own Id: OTP-17007\n\n- One can now pass the ERL_ROOTDIR environment variable to the erl and start\n  scrips. This makes it easier to use Erlang for Android apps. On Android, apps\n  don't control where they will be installed.\n\n  Own Id: OTP-17028\n\n- All long running functions in the maps API are now yielding. In previous\n  releases the functions `maps:from_list/1`, `maps:keys/1` and `maps:values/1`\n  did not yield. This could cause unfair scheduling of processes.\n\n  Own Id: OTP-17057\n\n- `socket:sendfile/2,3,4,5` has been implemented, for platforms that support the\n  underlying socket library call.\n\n  Own Id: OTP-17154 Aux Id: OTP-16749\n\n- The bit matching and construction syntax now supports 16-bit floats (IEEE\n  754-2008).\n\n  Own Id: OTP-17207\n\n- Add [`process_flag(fullsweep_after, N)`](`process_flag/2`) to change\n  `fullsweep_after` value in an already spawned process.\n\n  Own Id: OTP-17285 Aux Id: PR-4651\n\n- The `max_heap_size` error report has been updated to include the message queue\n  size.\n\n  Own Id: OTP-17293 Aux Id: PR-4672\n\n- Introduce new types `t:nonempty_binary/0` and `t:nonempty_bitstring/0`.\n\n  Own Id: OTP-17301 Aux Id: GH-4636\n\n- Optimize updates of large maps with identical keys and values. E.g. in the\n  example below the original `Map` will be reused as the return of the second\n  update.\n\n  `1> Map = LargeMap#{ a => b }.`\n\n  `2> Map#{ a := b }.`\n\n  The same optimization was done for small maps (< 33 keys) in erts-10.4 (OTP\n  22.0).\n\n  Own Id: OTP-17310 Aux Id: PR-4656\n\n- The previously undocumented internal `-no_epmd` option has been made\n  documented and public.\n\n  Own Id: OTP-17341 Aux Id: PR-2945\n\n- Reduce memory carrier super alignment on 64-bit architectures. In practice\n  allows more fine grained control over configuration of memory carrier sizes,\n  from increments of 256kb to 16kb.\n\n  Own Id: OTP-17368","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.2.2.18 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix [`list_to_atom/1`](`list_to_atom/1`) for negative code points. Could\n  either return with a positive code point or fail with an incorrect exception.\n\n  Own Id: OTP-18321\n\n- A race condition which was very rarely triggered could cause the signal queue\n  of a process to become inconsistent causing the runtime system to crash.\n\n  Own Id: OTP-18388 Aux Id: OTP-17462, PR-6662\n\n- [`process_info(Pid, status)`](`process_info/2`) when `Pid /= self()` could\n  return an erroneous result.\n\n  Own Id: OTP-18421 Aux Id: PR-6806\n\n- In rare circumstances, when a process exceeded its allowed heap size set by\n  option `max_heap_size`, it would not be killed as it should be, but instead\n  enter a kind of zombie state it would never get out of.\n\n  Own Id: OTP-18463 Aux Id: PR-6858\n\n- Implementations of the [`call()`](driver_entry.md#call) driver callback that\n  returned a faulty encoded result could cause a memory leak and could cause\n  invalid data on the heap of the processes calling `erlang:port_call/3`.\n\n  Own Id: OTP-18525 Aux Id: PR-7049\n\n- If a runtime system which was starting the distribution already had existing\n  pids, ports, or references referring to a node with the same nodename/creation\n  pair that the runtime system was about to use, these already existing pids,\n  ports, or references would not work as expected in various situations after\n  the node had gone alive. This could only occur if the runtime system was\n  communicated such pids, ports, or references prior to the distribution was\n  started. That is, it was extremely unlikely to happen unless the distribution\n  was started dynamically and was even then very unlikely to happen. The runtime\n  system now checks for already existing pids, ports, and references with the\n  same nodename/creation pair that it is about to use. If such are found another\n  creation will be chosen in order to avoid these issues.\n\n  Own Id: OTP-18570 Aux Id: PR-7190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.17 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [Notifications about available distribution data](`erlang:dist_ctrl_get_data_notification/1`)\n  sent to distribution controller processes could be lost. Distribution\n  controller processes can be used when implementing an alternative distribution\n  carrier. The default distribution over tcp was not effected and the bug was\n  also not present on x86/x86_64 platforms.\n\n  Own Id: OTP-18258 Aux Id: GH-6309, PR-6324","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.16 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Distributed exit signals could be lost under the following conditions:\n\n  - An exit signal from a parent process to a child process was lost if:\n\n    - the parent process terminated before the spawn request that created the\n      child had completed,\n    - the spawn request set up a link between parent and child\n    - the spawn request was distributed, and\n    - the exit reason was larger than one machine word.\n\n  - Loss of a connection over which a not yet completed spawn request was\n    ongoing could cause loss of exit signals. Such loss of exit signals was very\n    rare. Besides the above described connection loss also the following\n    conditions had to be satisfied:\n\n    - The spawn request that was interrupted by the connection loss also had to\n      set up a link between the parent process and the child process.\n    - The parent process that issued the spawn request also had to be\n      terminating while the spawn request was interrupted by the connection\n      loss.\n    - The same parent process also had to have made other spawn requests to\n      other nodes than to the node to which the connection was lost.\n    - These spawn requests to the other nodes also had to set up links.\n    - These spawn requests to the other nodes also had to be not yet completed\n      at the time of the connection loss. That is, the spawn reply from the\n      child process had not yet reached the parent process.\n\n    If all the conditions above were met, exit signals to the children spawned\n    due to the above described spawn requests to other nodes _could_ be lost.\n\n    The above bug also caused a significant memory leak when it was triggered\n    since the destruction of the parent process never completed.\n\n  Own Id: OTP-18164 Aux Id: PR-6114\n\n- A race could cause [`process_info(Pid, message_queue_len)`](`process_info/2`)\n  on other processes to return invalid results.\n\n  Own Id: OTP-18169 Aux Id: PR-6134\n\n- Fixed reduction counting for handling process system tasks.\n\n  Own Id: OTP-18170 Aux Id: PR-6135\n\n- Priority elevation of terminating processes did not work which could cause\n  execution of such processes to be delayed.\n\n  Own Id: OTP-18175 Aux Id: PR-6142\n\n- An unlink operation made by a process that terminated before the unlink\n  operation completed, i.e., before it had received an unlink-ack signal from\n  the linked process, caused an exit signal to erroneously be sent from the\n  terminating process to the process being unlinked. This exit signal would most\n  often be ignored by the receiver, but if the receiver of the exit signal\n  concurrently set up a new link, it could receive the exit signal with the\n  actual exit reason of the terminating process instead of a `noproc` exit\n  reason. It is however very hard to detect that this has happened and has no\n  obvious negative consequences, so it should be considered harmless.\n\n  A distributed unlink-ack signal received by a terminating process was also not\n  properly removed which could cause a minor memory leak.\n\n  Own Id: OTP-18177 Aux Id: PR-6150\n\n- The `erlang:monotonic_time/1`, `erlang:system_time/1`, `erlang:time_offset/1`,\n  and `os:system_time/1` BIFs erroneously failed when passed the argument\n  `native`.\n\n  Own Id: OTP-18197 Aux Id: GH-6165, PR-6213\n\n- Fix writing and reading of more than 2 GB in a single read/write operation on\n  macOS. Before this fix attempting to read/write more than 2GB would result in\n  `{error,einval}`.\n\n  Own Id: OTP-18222 Aux Id: PR-6248 GH-6242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.15 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix faulty distribution encoding of terms with either\n\n  - a fun with bit-string or export-fun in its environment when encoded toward a\n    not yet established (pending) connection\n  - or a fun with a binary/bitstring, in its environment, referring to an\n    off-heap binary (larger than 64 bytes).\n\n  The symptom could be failed decoding on the receiving side leading to aborted\n  connection. Fix OTP-18093 is a workaround for theses bugs that makes the VM\n  accepts such faulty encoded funs.\n\n  The first encoding bug toward pending connection exists only in OTP 23 and 24,\n  but the second one exists also on OTP 25.\n\n  Own Id: OTP-18104 Aux Id: OTP-18093","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.14 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Accept funs (NEW_FUN_EXT) with incorrectly encoded size field. This is a\n  workaround for a bug (OTP-18104) existing in OTP 23 and 24 that could cause\n  incorrect size fields in certain cases. The emulator does not use the decoded\n  size field, but `erl_interface` still does and is not helped by this\n  workaround.\n\n  Own Id: OTP-18093 Aux Id: OTP-18104, PR-5987\n\n- The zlib built in to the runtime system has been updated to version 1.2.12.\n  (Note that on most platforms, the platform's own zlib is used.)\n\n  Own Id: OTP-18123 Aux Id: GH-5994\n\n- Fixed emulator crash that could happen during crashdump generation of ETS\n  tables with options `ordered_set` and `{write_concurrency,true}`.\n\n  Own Id: OTP-18144 Aux Id: GH-5981","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.13 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Let EPMD tolerate failure when binding to IPv4/IPv6 loopback intefaces in\n  addition to user-supplied addresses via `ERL_EPMD_ADDRESS` or the `-address`\n  option. This can happen, for example, if the host system has ipv6 disabled via\n  the disable_ipv6 sysctl.\n\n  Own Id: OTP-17970 Aux Id: PR-5762\n\n- Fixed a rare bug in [`binary_to_term/1`](`binary_to_term/1`),\n  `enif_make_map_from_arrays`, `erl_drv_send_term`, and Erlang distribution that\n  could crash the emulator.\n\n  Own Id: OTP-18027\n\n- Fixed a rare race in `persistent_term:get/1,2` that could cause it to return\n  the value of another key.\n\n  Own Id: OTP-18065 Aux Id: GH-5908\n\n- Fix bug where the process message queue was left in an inconsistent state when\n  changing from on_heap to off_heap message queue data causing the GC to\n  segfault.\n\n  Own Id: OTP-18075 Aux Id: PR-5927\n\n- Fix functions that convert universal to localtime (such as erlang:localtime/0\n  and erlang:universaltime_to_localtime/1) to fetch the correct localtime if it\n  is changed after the start of the VM.\n\n  Own Id: OTP-18076 Aux Id: ERIERL-802 PR-5905\n\n- Fix memory leak when a process doing a distributed fragmented send is sent an\n  exit signal. Before this fix the receiving node would be left with an\n  incomplete message that would remain until the nodes were disconnected. The\n  bug has existed since Erlang/OTP 21.\n\n  Own Id: OTP-18077 Aux Id: GH-5876 PR-5892","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.12 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix Erlang monotonic time on MacOS. Previously used OS monotonic time\n  primitive on MacOS is buggy and will not be used anymore. It has been replaced\n  with usage of another OS monotonic time primitive that does not appear to be\n  buggy.\n\n  Own Id: OTP-17998 Aux Id: PR-5825, GH-5554","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.11 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- By default `global` does _not_ take any actions to restore a fully connected\n  network when connections are lost due to network issues. This is problematic\n  for all applications expecting a fully connected network to be provided, such\n  as for example `mnesia`, but also for `global` itself. A network of\n  overlapping partitions might cause the internal state of `global` to become\n  inconsistent. Such an inconsistency can remain even after such partitions have\n  been brought together to form a fully connected network again. The effect on\n  other applications that expects that a fully connected network is maintained\n  may vary, but they might misbehave in very subtle hard to detect ways during\n  such a partitioning.\n\n  In order to prevent such issues, we have introduced a _prevent overlapping\n  partitions_ fix which can be enabled using the\n  [`prevent_overlapping_partitions`](`e:kernel:kernel_app.md#prevent_overlapping_partitions`)\n  `kernel(6)` parameter. When this fix has been enabled, `global` will actively\n  disconnect from nodes that reports that they have lost connections to other\n  nodes. This will cause fully connected partitions to form instead of leaving\n  the network in a state with overlapping partitions. Note that this fix _has_\n  to be enabled on _all_ nodes in the network in order to work properly. Since\n  this quite substantially changes the behavior, this fix is currently disabled\n  by default. Since you might get hard to detect issues without this fix you\n  are, however, _strongly_ advised to enable this fix in order to avoid issues\n  such as the ones described above. As of OTP 25 this fix will become enabled by\n  default.\n\n  Own Id: OTP-17843 Aux Id: ERIERL-732, PR-5611\n\n- Fix memory leak when tracing on running on a process that only handle system\n  tasks or non-message signals (for example process_info requests).\n\n  Own Id: OTP-17904 Aux Id: ERIERL-757","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.10 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix GC emulator crash when `spawn_request` was used when message tracing was\n  enabled.\n\n  Own Id: OTP-17871 Aux Id: PR-5612","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.9 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a memory leak in `file:read_file_info/2` and `file:read_file/1` on\n  Windows.\n\n  Own Id: OTP-17827 Aux Id: GH-5527","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Responsiveness of processes executing on `normal` or `low` priority could\n  suffer due to code purging or literal area removal on systems with a huge\n  amount of processes. This since during these operations all processes on the\n  system were scheduled for execution at once.\n\n  This problem has been fixed by introducing a limit on outstanding purge and\n  copy literal requests in the system. By default this limit is set to twice the\n  amount of schedulers on the system. This will ensure that schedulers will have\n  enough work scheduled to perform these operations as quickly as possible at\n  the same time as other work will be interleaved to a much higher degree.\n  Performance of these operations will however be somewhat degraded due to the\n  overhead of enforcing this limit compared to when using a very large limit.\n\n  This limit can be set by passing the `+zosrl` command line argument to `erl`,\n  or by calling\n  `erlang:system_flag(outstanding_system_requests_limit, NewLimit)`.\n\n  Own Id: OTP-17796 Aux Id: ERIERL-729, PR-5473","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.2.2.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The runtime system could call `select()` with a too large timeout value when\n  executing on MacOS. This could in turn cause the runtime system to crash.\n\n  Own Id: OTP-17735 Aux Id: GH-5339\n\n- Certain distributed signals that for various reasons must to be forced into\n  the distribution buffer even when it is full would instead be lost if the\n  distribution buffer was full when sent. The effected signals:\n\n  - `EXIT` signals with exit reasons of one word size.\n  - `DOWN` signals with exit reasons of one word size.\n  - `demonitor` signals from a terminating process.\n  - `unlink_ack` signals on OTP 23 and 24.\n  - `spawn_reply` signals on OTP 23 and 24.\n\n  Own Id: OTP-17737 Aux Id: GH-5346, GH-4989","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A call to [`process_info(Pid, status)`](`process_info/2`) could erroneously\n  report the status `running` when it should have reported `waiting`. This\n  occurred when the calling process was executing on a higher priority than the\n  process being inspected. This bug has been present since OTP 21.0 (erts\n  version 10.0).\n\n  Own Id: OTP-17628\n\n- A race between an exiting port and handling of simultaneously received signals\n  to that port could cause a runtime system crash. The effected signals are\n  `link`, `monitor` and `demonitor`. On OTP 22 a similar race could also cause a\n  memory leak when receiving an `unlink` signal.\n\n  Own Id: OTP-17642 Aux Id: PR-5248\n\n- The message queue of a process entered an inconsistent state after a `receive`\n  expression with an invalid timeout value was executed. If the exception raised\n  due to the invalid timeout value was caught, the following `receive`\n  expression executed by the process could fail to match messages already\n  present in the message queue.\n\n  On OTP 24 this could also cause the whole runtime system to crash.\n\n  Own Id: OTP-17651 Aux Id: GH-5235, PR-5244\n\n- Sending a `Port ! {PortOwner, close}` signal from a process other than the\n  port owner could erroneously trigger a `badsig` exit signal being sent to the\n  port owner process even though the correct `PortOwner` had been passed in the\n  signal.\n\n  Own Id: OTP-17665 Aux Id: PR-5248\n\n- This fixes a bug in `erts_factory_undo` that caused the heap to not be reset\n  correctly. The `erts_factory_undo` function is, for example, called when a\n  [`binary_to_term/1`](`binary_to_term/1`) call fails to reset the heap to its\n  state before the [`binary_to_term/1`](`binary_to_term/1`) call. This can cause\n  the heap to contain invalid terms which potentially can cause issues (e.g.,\n  crashes) when the whole heap is scanned.\n\n  Own Id: OTP-17677\n\n- Fix bug in `persistent_term` when a key-value pair contains a magic reference\n  that is referred more than once. Magic references are NIF resources or\n  returned from BIFs like `ets:new`, `atomics:new`. The bug could cause the\n  memory of the referred resource to be prematurely deallocated.\n\n  The bug also apply to magic references in message passing on a runtime built\n  with configure option `--enable-sharing-preserving`.\n\n  Bug exist for 64-bit since OTP-24.0 and for 32-bit since OTP-20.0.\n\n  Own Id: OTP-17700 Aux Id: GH-5271, PR-5273","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The python scripts that existed in\n  erts/lib_src/yielding_c_fun/lib/tiny_regex_c/scripts had a license that was\n  incompatible with Erlang/OTP's license. This ticket removes these scripts that\n  were not used by us.\n\n  Own Id: OTP-17658","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.2.2.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Parsing of the result value in the native DNS resolver has been made more\n  defensive against incorrect results.\n\n  Own Id: OTP-17578 Aux Id: ERIERL-683\n\n- On 32-bit computers, `binary_to_term/1,2` is now more resilient against\n  corrupted binaries containing maps in the external format.\n\n  Own Id: OTP-17604","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix buffer overrun problem in the tty driver. The problem happens on some\n  platforms when using the CTRL+R functionality of newshell with very long\n  strings in the history.\n\n  Own Id: OTP-17560 Aux Id: GH-5116\n\n- Fix race-condition that could cause a crash when tracing scheduling or garbage\n  collections on a process that was running on a dirty scheduler.\n\n  Own Id: OTP-17568 Aux Id: PR-4940\n\n- Fix rare bug where re:run would crash/return invalid results when given a\n  subbinary as subject.\n\n  This bug has existed since Erlang/OTP 20.0.\n\n  Own Id: OTP-17585 Aux Id: GH-5150\n\n- `binary_to_term/1,2` is now more resilient against corrupted binaries\n  containing maps in the external format.\n\n  Own Id: OTP-17594","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Microstate accounting (msacc) and `os:perf_counter()` unintentionally used\n  system time instead of monotonic time for time measurements on a lot of\n  systems. These systems were all non x86/x86_64 systems or x86/x86_64 systems\n  without a reliable and constant rdtsc instruction.\n\n  The lock counting (lcnt) built runtime system also unintentionally used system\n  time instead of monotonic time for time measurements on all systems.\n\n  Own Id: OTP-17493\n\n- Simultaneous calls to `erlang:system_flag(schedulers_online, _)` could cause\n  callers to end up in a suspended state forever.\n\n  Own Id: OTP-17500 Aux Id: GH-4809\n\n- Fix rare race bug in memory management of distribution entries. Have been seen\n  to cause VM crash when massive number of repeated concurrent failing\n  connection attempts.\n\n  Own Id: OTP-17513 Aux Id: GH-4964, PR-5015","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A call to `erlang:cancel_timer(_, [{info, false}])` could cause the calling\n  process to block forever in the call. Note that only the synchronous version\n  of the call (that is, the `async` option is `false`) in combination with the\n  `info` option set to `false` was effected by this bug.\n\n  Own Id: OTP-17472 Aux Id: PR-4932","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A call to `port_command()` could cause a scheduler to end up in an eternal\n  loop if the port was busy and the calling process had incoming signals at the\n  time of the call. This bug was introduced in OTP 23.3.2 (ERTS version 11.2.1),\n  OTP 22.3.4.18 (ERTS version 10.7.2.10), and OTP 21.3.8.23 (ERTS version\n  10.3.5.18).\n\n  Own Id: OTP-17448 Aux Id: GH-4898, PR-4903, OTP-17291\n\n- Dirty execution of a process in combination with an unlink signal from a port\n  to the process could cause the signal queue of the process to enter into an\n  inconsistent state. The result of the inconsistency typically caused a crash\n  of the runtime system. This bug was introduced in OTP 23.3 (ERTS version\n  11.2).\n\n  Own Id: OTP-17462 Aux Id: GH-4885, PR-4914, OTP-17127","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug in match spec compilator seen to cause a stack overflow crash on debug\n  VM for certain match specs. Could potentially cause problems for standard VM,\n  but has not been verified. Match specs are used by `ets:match/select`\n  functions and `erlang:trace_pattern`.\n\n  Own Id: OTP-17379 Aux Id: PR-4804","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The following signals could pass before other signals from the same sender to\n  the same receiver. That is, these signals could arrive too early.\n\n  - `garbage-collect` request. Sent from one process to another using one of the\n    `garbage_collect/0` BIFs.\n  - `check-process-code` request. Sent from one process to another using one of\n    the `check_process_code()` BIFs.\n  - `is-process-alive` reply. Sent as a response to a process calling the\n    `is_process_alive()` BIF.\n  - `process-info` reply. Sent as a response to a process calling one of the\n    `process_info()` BIFs.\n  - `port-command` reply. Sent as a response to a process calling one of the\n    `port_command()` BIFs.\n  - `port-connect` reply. Sent as a response to a process calling the\n    `port_connect()` BIF.\n  - `port-close` reply. Sent as a response to a process calling the\n    `port_close()` BIF.\n  - `port-control` reply. Sent as a response to a process calling the\n    `port_control()` BIF.\n  - `port-call` reply. Sent as a response to a process calling the `port_call()`\n    BIF.\n  - `port-info` reply. Sent as a response to a process calling one of the\n    `port_info()` BIFs.\n\n  Own Id: OTP-17291\n\n- Fix bug in `persistent_term:get/0` and `info/0` that could cause VM crash in\n  rare cases. Bug exists since OTP 23.0.\n\n  Own Id: OTP-17298\n\n- Fixed a bug in `zlib` where decompression would crash with `data_error` on\n  some valid inputs.\n\n  Own Id: OTP-17299 Aux Id: GH-4710\n\n- A garbage collection of a literal area missed messages that entirely consisted\n  of a term in a literal area. This could in turn lead to a crash of the runtime\n  system.\n\n  Own Id: OTP-17307\n\n- A call to [`process_flag(message_queue_data, off_heap)`](`process_flag/2`)\n  could cause a crash of the runtime system when sequential tracing was enabled.\n\n  Own Id: OTP-17349","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix memory leak of about 6 words when `erlang:process_flag/3` is called with a\n  pid of an already dead process. Bug exists since OTP-21.0.\n\n  Own Id: OTP-17081 Aux Id: PR-2930\n\n- Fixed small memory leak in `erl_drv_send_term` and `erl_drv_output_term` when\n  failing due to the term being invalid.\n\n  Own Id: OTP-17089 Aux Id: PR-2934\n\n- The DTrace/SystemTap `process_heap_grow` probe is now called with valid the\n  heap and stack pointers for the process in question.\n\n  Own Id: OTP-17096 Aux Id: PR-2932\n\n- Fixed a performance issue in memory allocation for Linux kernels that didn't\n  support `MADV_FREE`.\n\n  Own Id: OTP-17124\n\n- A [new link protocol](erl_dist_protocol.md#new_link_protocol) has been\n  introduced which prevents links from ending up in an inconsistent state where\n  one participant considers itself linked while the other doesn't. This bug has\n  always existed in the distributed case, but has since OTP 21 also existed in\n  the node local case since the distributed link protocol then was adopted also\n  for node local links. The bug could, however, only trigger if both\n  participants operated on the link simultaneously.\n\n  Own Id: OTP-17127\n\n- Fix memory leak when receiving sigchld from port program to already dead port.\n\n  Own Id: OTP-17163\n\n- Fix bug where complex seq_trace tokens (that is lists, tuples, maps etc) could\n  becomes corrupted by the GC. The bug was introduced in OTP-21.\n\n  Own Id: OTP-17209 Aux Id: PR-3039\n\n- Fixed WSLPATH environment variable addition to PATH on windows, the last\n  character was lost.\n\n  Own Id: OTP-17229\n\n- Fixed a bug in the timer implementation which could cause timers that were set\n  to more than 37.25 hours in the future to be delayed. This could occur if\n  there were multiple timers scheduled to be triggered very close in time, but\n  still at different times, and the scheduler thread handling the timers was not\n  able to handle them quickly enough. Delayed timers were in this case triggered\n  when another unrelated timer was triggered.\n\n  Own Id: OTP-17253\n\n- Fixed small memory leak in `erlang:trace/3` if option `{tracer,_}` is included\n  and the option list is invalid or the call races with a concurrent trace or\n  code change operation.\n\n  Own Id: OTP-17265 Aux Id: PR-4596\n\n- Fix configure check for `inet_pton` on 32-bit windows. The failure of this\n  check would cause epmd to be built without ipv6 support.\n\n  Own Id: OTP-17283","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Various address sanitizer support.\n\n  Own Id: OTP-16959 Aux Id: PR-2965\n\n- The emulator will now honor `cgroup2` CPU quotas.\n\n  Own Id: OTP-17002\n\n- Improved memory barrier usage on ARMv8 hardware, and specifically on Apple\n  silicon.\n\n  Own Id: OTP-17195 Aux Id: PR-4505, PR-4538\n\n- Improved memory barrier usage on 64-bit POWER hardware.\n\n  Own Id: OTP-17200 Aux Id: PR-4510\n\n- Fix a file descriptor leak when using sendfile and the remote side closes the\n  connection. This bug has been present since OTP-21.0.\n\n  Own Id: OTP-17244\n\n- Refinement of the documentation of the `message_queue_data` process flag.\n\n  Own Id: OTP-17252 Aux Id: PR-4568","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.1.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug that could cause some work scheduled for execution on scheduler\n  threads to be delayed until other similar work appeared. Beside delaying\n  various cleanup of internal data structures also the following could be\n  delayed:\n\n  - Termination of a distribution controller process\n  - Disabling of the distribution on a node\n  - Gathering of memory allocator information using the `instrument` module\n  - Enabling, disabling, and gathering of `msacc` information\n  - Delivery of `'CHANGE'` messages when time offset is monitored\n  - A call to `erlang:cancel_timer()`\n  - A call to `erlang:read_timer()`\n  - A call to `erlang:statistics(io | garbage_collection | scheduler_wall_time)`\n  - A call to `ets:all()`\n  - A call to `erlang:memory()`\n  - A call to `erlang:system_info({allocator | allocator_sizes, _})`\n  - A call to `erlang:trace_delivered()`\n\n  The bug existed on runtime systems running on all types of hardware except for\n  x86/x86_64.\n\n  Own Id: OTP-17185","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.1.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-7"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Make windows installer remove write access rights for non admin users when\n  installing to a non default directory. Reduces the risk for DLL sideloading,\n  but the user should always be aware of the access rights for the installation.\n\n  Own Id: OTP-17097","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.1.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The `suspend_process()` and `resume_process()` BIFs did not check their\n  arguments properly which could cause an emulator crash.\n\n  Own Id: OTP-17080\n\n- The runtime system would get into an infinite loop if the runtime system was\n  started with more than 1023 file descriptors already open.\n\n  Own Id: OTP-17088 Aux Id: ERIERL-580","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.1.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix emulator crash when sending small bit-strings over Erlang distribution\n  while the connection is being setup.\n\n  The fault was introduced in OTP-23.0\n\n  Own Id: OTP-17083 Aux Id: ERIERL-572","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.1.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug which could cause VM crash when a NIF is loaded at the same time as\n  the Erlang implementation of the NIF is called. Bug exists since OTP 23.0.\n\n  Own Id: OTP-16859\n\n- Fixed `enif_make_map_*` functions in debug build when given environment from\n  `enif_alloc_env`.\n\n  Own Id: OTP-16863 Aux Id: ERL-1352\n\n- Fixed broken configuration option `--disable-pie`.\n\n  Own Id: OTP-16864\n\n- Fixed rare distribution bug in race between received signal\n  (link/monitor/spawn_request/spawn_reply) and disconnection. Symptom: VM crash.\n  Since: OTP 21.0.\n\n  Own Id: OTP-16869 Aux Id: ERL-1337\n\n- Fixed a performance issue when extremely many items were stored in the process\n  dictionary. (Fixing this bug also eliminates a compiler warning emitted by the\n  latest version of Clang.)\n\n  Own Id: OTP-16888\n\n- Remove `-ftree-copyrename` from flags passed to compiler when building erts.\n  The flag is not used by modern gcc's and is not supported by clang.\n\n  Own Id: OTP-16894\n\n- Modules using complicated nested binary comprehensions could fail to load.\n\n  Own Id: OTP-16899\n\n- Fixed a race in `file:read_file/1` were an incomplete file could be returned\n  if another OS process swapped the file out while reading.\n\n  Own Id: OTP-16948 Aux Id: PR-2792\n\n- The call [`list_to_integer(\"10\", true)`](`list_to_integer/2`) would return `4`\n  instead of raising an exception. Certain other atoms would also be interpreted\n  as a number base.\n\n  Own Id: OTP-17030\n\n- On macOS 11 (Big Sur), erl would not start if the maximum number of file\n  descriptors were unlimited (`ulimit -n unlimited`).\n\n  Own Id: OTP-17055 Aux Id: ERL-1417","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Add manifest to all executables and dynamic libraries.\n\n  Own Id: OTP-17067 Aux Id: PR-2907","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a crash when exceptions were thrown during call time tracing.\n\n  Own Id: OTP-16994","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bugs causing issues when enabling the ERTS internal allocators on a\n  system built with the undocumented and unsupported `SMALL_MEMORY` feature.\n\n  Own Id: OTP-16939\n\n- The inet driver used to use 16 as maximum elements in an I/O vector passed to\n  `writev()` (and `WSASend()` on Windows). When the data to send contained lots\n  of elements, this caused a performance degradation since repeated calls to\n  `writev()` had to be made to a much larger extent. The inet driver now looks\n  up actual maximum amount of elements that can be used on the system, instead\n  of just assuming 16. On most systems this will result in a maximum amount of\n  I/O vector elements of 1024.\n\n  As of OTP 23.0 the term encoding of signals to send over the distribution are\n  encoded into I/O vectors of buffers instead of into a single buffer. Reference\n  counted binaries are referred to directly from the I/O vector instead of being\n  copied into the single buffer. That is, Erlang signals containing huge amounts\n  of reference counted binaries was effected by this performance degradation.\n\n  Own Id: OTP-16955 Aux Id: ERL-1343, OTP-15618\n\n- In the distributed case, a faulty `reply` option in a call to the\n  `spawn_request()` BIF erroneously caused a `badarg` exception instead of a\n  `badopt` error message reply.\n\n  Own Id: OTP-16991 Aux Id: OTP-15251","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- inet:setopts(\\[\\{active,once\\}]) wakes up IO polling thread unnecessarily,\n  leading to lock contention and visibly higher CPU utilization.\n\n  Own Id: OTP-16847 Aux Id: ERL-1301\n\n- Two bugs in the ERTS internal thread wakeup functionality have been fixed.\n  These bugs mainly hit when all threads in the system tried to go to sleep.\n  When the bugs were triggered, certain operations were delayed until a thread\n  woke up due to some other reason. Most important operations effected were code\n  loading, persistent term updates, and memory deallocation.\n\n  Own Id: OTP-16870\n\n- Fixed bug in `ets:select_replace/2` on `compressed` tables that could produce\n  faulty results or VM crash. Bug exists since OTP 20.\n\n  Own Id: OTP-16874 Aux Id: ERL-1356, PR-2763\n\n- When compiling Erlang/OTP on macOS using Xcode 12, the performance of the BEAM\n  interpreter would be degraded.\n\n  Own Id: OTP-16892","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- As of OTP 22, the allocator specific memory carrier pools were replaced by a\n  node global carrier pool. This unfortunately caused substantial memory\n  fragmentation in some cases due to long lived data being spread into carriers\n  used by allocators mainly handling short lived data.\n\n  A new command line argument `+M cp` has been introduced with which one can\n  enable the old behavior as well as configuring other behaviors for the carrier\n  pools. In order to configure the old behavior, with allocator specific carrier\n  pools for all allocators, pass `+Mucp :` (including the colon character) as a\n  command line argument to `erl` when starting the Erlang system.\n\n  The default configuration for carrier pools will be changed to `+Mucp :` some\n  time in the future, but not in this patch.\n\n  Own Id: OTP-16856","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Update the documentation of the abstract format to use `ANNO` instead of\n  `LINE`.\n\n  Own Id: OTP-16625 Aux Id: PR-2609\n\n- The emulator will no longer revert to the default number of schedulers when\n  running under a CPU quota lower than 1 CPU.\n\n  Own Id: OTP-16710 Aux Id: ERL-1280\n\n- Fixed a problem with crash dumps. When a process that contained reference to\n  literals internally created by the runtime system (such as the tuple returned\n  by `os:type/0`), the literal would not be included in the crash dump and the\n  crashdump viewer would complain about the heap being incomplete.\n\n  Own Id: OTP-16713\n\n- Fix configure detection of PGO for clang.\n\n  Own Id: OTP-16738\n\n- The to_erl program has been fixed to correctly interpret newline as only\n  newline and not newline+return.\n\n  This bug would cause the terminal to behave strangely when using lines longer\n  than the terminal size.\n\n  Own Id: OTP-16741\n\n- A race condition when changing process priority by calling\n  [`process_flag(priority, Prio)`](`process_flag/2`) could cause elevation of\n  priority for a system task to be ignored. This bug hit if the system task was\n  scheduled on the process calling `process_flag()` at the same time as the\n  priority was changed. The bug is quite harmless and should hit very seldom if\n  ever.\n\n  Own Id: OTP-16770\n\n- Adjust `/bin/sh` to `/system/bin/sh` in scripts when installing on Android.\n\n  Own Id: OTP-16833 Aux Id: PR-2729\n\n- In rare circumstances, when loading a BEAM file generated by an alternative\n  code generator (not the Erlang compiler in OTP) or from handwritten or patched\n  BEAM code, the loader could do an unsafe optimization.\n\n  Own Id: OTP-16850 Aux Id: ERL-1344\n\n- A memory and file descriptor leak in socket has been fixed. (When a newly\n  opened socket that had not entered the fd into the VM's poll set (neither\n  received, sent, accepted nor connected) was abandoned without closing (process\n  died), after assigning a different controlling process, then a memory block\n  and the file descriptor could be leaked.)\n\n  Own Id: OTP-16857\n\n- The documentation of [`statistics(run_queue)`](`statistics/1`) erroneously\n  stated that it returns the total length of all normal run queues when it is\n  the total length of all normal and dirty CPU run queues that is returned. The\n  documentation has been updated to reflect the actual behavior.\n\n  Own Id: OTP-16866 Aux Id: ERL-1355","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Changes in order to build on the Haiku operating system.\n\n  Thanks to Calvin Buckley\n\n  Own Id: OTP-16707 Aux Id: PR-2638\n\n- When building the inet driver on Windows, there where many compiler warnings\n  regarding type casting (used when calling the debug macro). This has now been\n  resolved.\n\n  Own Id: OTP-16715\n\n- Make (use of) the socket registry optional (still enabled by default). Its now\n  possible to build OTP with the socket registry turned off, turn it off by\n  setting an environment variable and controlling in runtime (via function calls\n  and arguments when creating sockets).\n\n  Own Id: OTP-16763\n\n- Change default filename encoding on android to UTF-8.\n\n  Own Id: OTP-16821 Aux Id: PR-2733\n\n- Clarification of the format of the atom cache header used by the distribution.\n\n  Own Id: OTP-16848 Aux Id: PR-2737","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 11.0.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The ERTS internal I/O poll implementation could get into an inconsistent state\n  causing input events to be ignored.\n\n  Own Id: OTP-16780 Aux Id: PR-2701","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in `erlang:load_nif/2` that could cause it to throw `badarg`\n  exception if a concurrent code change operation was in progress. Bug existed\n  since OTP 23.0.\n\n  Own Id: OTP-16704 Aux Id: ERL-1273, PR-16704\n\n- Minor fix of debug compiled VM.\n\n  Own Id: OTP-16717\n\n- An unintentional reuse of an already used emulator internal event object could\n  cause a wakeup signal to a thread to be lost. In worst case this could cause\n  the runtime system to hang. This hang was however quite rare.\n\n  Own Id: OTP-16766 Aux Id: ERL-1304\n\n- NIF threads and driver threads on non-Linux systems leaked internal resources\n  when terminating. On Windows these resources were one event per thread. On\n  most other systems one mutex and one condition variable per thread. On these\n  other systems that also lacked `pthread_cond_timedwait()` also a pipe with its\n  file descriptors was leaked.\n\n  Own Id: OTP-16772 Aux Id: ERL-1304","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug when sending an export fun (eg `lists:reverse/1`) on a not yet\n  established connection. It could cause VM crash. Bug exists since OTP 23.0.\n\n  Own Id: OTP-16693 Aux Id: ERL-1254, PR-2640","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The functionality utilized by BIFs for temporary disabling of garbage\n  collection while yielding could cause system task queues to become\n  inconsistent on a process executing such a BIF. Process system tasks are for\n  example utilized when purging code, garbage collecting literal data, and when\n  issuing an ordinary garbage collection from another process.\n\n  The bug does not trigger frequently. Multiple code purges in direct sequence\n  makes it more likely that this bug is triggered. In the cases observed, this\n  has resulted in a hanging code purge operation.\n\n  Own Id: OTP-16639 Aux Id: ERL-1236\n\n- SCTP and UDP recv/2,3 hangs indefinitely if socket is closed while recv is\n  called (socket in passive mode).\n\n  Own Id: OTP-16654 Aux Id: ERL-1242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 11.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-11-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- BIFs now behave like ordinary functions with regard to tracing, allowing\n  `call_count` tracing and fixing a few bugs where return trace messages were\n  lost when BIFs tail-called themselves or other functions (\"trapping\").\n\n  Own Id: OTP-14734 Aux Id: ERL-496\n\n- Fix various compiler warnings on 64-bit Windows.\n\n  Own Id: OTP-15800\n\n- `erlang:fun_info(fun foo/1, name/1)` used to return a function name based on\n  the name of the function that `fun foo/1` was used in. The name returned is\n  now `-fun.foo/1-`.\n\n  Own Id: OTP-15837\n\n- `file:allocate/3` will now update the file size on all platforms.\n\n  Own Id: OTP-16155 Aux Id: PR-2408\n\n- `erlang:decode_packet` with type set to `httph` no longer accepts http headers\n  that have whitespaces in between the header name and the colon. That is:\n\n  `Content-Type : text/html`\n\n  is no longer allowed. This has been changed to conform with RFC 7230 and thus\n  protect against http desync attacks.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16168 Aux Id: ERL-1053\n\n- Fix the quoting rules in `erl -args_file`, `ERL_FLAGS`, `ERL_AFLAGS` and\n  `ERL_ZFLAGS` to work as unix sh quoting.\n\n  This bug fix can make previous configuration options to `erl` passed through\n  `ERL_FLAGS`, `ERL_AFLAGS`, `ERL_ZFLAGS` or `-args_file` not be interpreted in\n  the same way as before the fix.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16244 Aux Id: ERL-1051\n\n- Fix the Erlang distribution to handle the scenario when a node connects that\n  can handle message fragmentation but can not handle the atom cache. This bug\n  only affects users that have implemented a custom distribution carrier. It has\n  been present since OTP-21.\n\n  The `DFLAG_FRAGMENT` distribution flag was added to the set of flags that can\n  be rejected by a distribution implementation.\n\n  Own Id: OTP-16284\n\n- Compiling a match specification with excessive nesting caused the runtime\n  system to crash due to scheduler stack exhaustion. Instead of crashing the\n  runtime system, effected functions will now raise a `system_limit` error\n  exception in this situation.\n\n  Own Id: OTP-16431 Aux Id: ERL-592\n\n- Fixed a bug that prevented Erlang from being started on Windows if it were\n  installed on certain paths.\n\n  Own Id: OTP-16478 Aux Id: ERL-1115\n\n- Fix bug on Windows causing bad performance when standard input is closed,\n  especially if the VM is only assigned one CPU core. Could be provoked for\n  example by starting erl or escript via function `os:cmd/1`. Could be avoided\n  with command line option `-noinput`.\n\n  The bad performance was caused by an io thread spinning indefinitely.\n\n  Own Id: OTP-16521 Aux Id: ERL-716\n\n- Fixed a bug on Unix platforms that would cause `file:read_file_info/1` to\n  return incorrect results if the emulator's effective user or group id differed\n  from its actual ones.\n\n  Own Id: OTP-16571\n\n- socket: Compile problems on Android when PACKET_FASTROUTE and PACKET_USER are\n  both defined and has the same value. Use of PACKET_FASTROUTE has been removed\n  as it may be unused and also only for none user-land.\n\n  Own Id: OTP-16576 Aux Id: ERL-1208\n\n- Fixed bug in erl_crash.dump generation that could cause a SEGV core dump if a\n  recently cancelled timer was found.\n\n  Own Id: OTP-16596 Aux Id: ERL-1105, PR-2606","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Improved concurrency of `erlang:load_nif/2` as it does no longer block other\n  schedulers from executing during initial load of a NIF library.\n\n  Own Id: OTP-10278\n\n- EEP-52 has been implemented.\n\n  In binary matching, the size of the segment to be matched is now allowed to be\n  a guard expression, and similarly in map matching the keys can now be guard\n  expressions. See the Erlang Reference Manual and Programming Examples for more\n  details.\n\n  Language compilers or code generators that generate Core Erlang code may need\n  to be updated to be compatible with the compiler in OTP 23. For more details,\n  see the section Backwards Compatibility in\n  [EEP 52](http://erlang.org/eeps/eep-0052.html).\n\n  Own Id: OTP-14708\n\n- Internally in BEAM, handling of continuation pointers has been simplified.\n  This change is not user-visible, except when examining a process stack in the\n  crashdump viewer. The continuation pointer for a function will now be stored\n  below the y(0) for that function.\n\n  Own Id: OTP-15077\n\n- `seq_trace` tokens are now propagated to spawned processes.\n\n  Own Id: OTP-15232 Aux Id: ERL-700\n\n- Improvements of distributed spawn operations. These include both scalability\n  and performance improvements as well as new functionality.\n\n  New functionality:\n\n  - A distributed [`spawn_monitor()`](`erlang:spawn_monitor/4`) BIF.\n  - Support for `monitor` option in the distributed\n    [`spawn_opt()`](`erlang:spawn_opt/5`) BIF.\n  - New [`spawn_request()`](`erlang:spawn_request/5`) BIFs for asynchronous\n    spawn of processes. `spawn_request()` supports all options that\n    `spawn_opt()` support plus a few more.\n\n  Own Id: OTP-15251\n\n- Make `ets:insert/2` and `ets:insert_new/2` yield scheduler execution on long\n  lists of records to insert.\n\n  Own Id: OTP-15517 Aux Id: ERL-560\n\n- Increased size of node incarnation numbers (aka \"creation\"), from 2 bits to 32\n  bits. This will reduce the risk of pids/ports/refs, from different node\n  incarnation with the same name, being mixed up.\n\n  Own Id: OTP-15603\n\n- The runtime system can now encode Erlang terms to the Erlang external term\n  format as I/O vectors. The main benefit of this is that reference counted\n  binaries can be referred to directly instead of copied into a new binary.\n\n  The default Erlang distribution over TCP will always utilize this. Alternate\n  distribution implementations utilizing a port as distribution controller will\n  utilize this if the driver implements the [`outputv`](driver_entry.md#outputv)\n  callback. Alternate Erlang distribution implementations utilizing a process as\n  distribution controller will utilize this if I/O vectors are utilized by the\n  functionality that processes the data returned from\n  [`erlang:dist_ctrl_get_data()`](`erlang:dist_ctrl_get_data/1`).\n\n  The return type for data returned by\n  [`erlang:dist_ctrl_get_data()`](`erlang:dist_ctrl_get_data/1`) has been\n  changed from `t:iodata/0` to `iovec()`. Note that `iovec()` data is valid\n  `t:iodata/0` so old implementations using `erlang:dist_ctrl_get_data()` do not\n  need to be changed, but may benefit from being changed depending on usage\n  scenario.\n\n  The new BIFs [`term_to_iovec/1`](`erlang:term_to_iovec/1`) and\n  [`term_to_iovec/2`](`erlang:term_to_iovec/2`) have been introduced. These work\n  exactly as `term_to_binary()` with the corresponding arity except the return\n  type.\n\n  Own Id: OTP-15618\n\n- Improved ETS scalability of concurrent calls that change the size of a table,\n  like `ets:insert/2` and `ets:delete/2`.\n\n  This performance feature was implemented for `ordered_set` in OTP 22.0 and\n  does now apply for all ETS table types.\n\n  The improved scalability may come at the cost of longer latency of\n  `ets:info(T,size)` and `ets:info(T,memory)`. A new table option\n  `decentralized_counters` has therefore been added. It is default `true` for\n  `ordered_set` with `write_concurrency` enabled and default `false` for all\n  other table types.\n\n  Own Id: OTP-15744 Aux Id: OTP-15623, PR-2229\n\n- Directories can now be opened by `file:open/2` when passing the `directory`\n  option.\n\n  Own Id: OTP-15835 Aux Id: PR-2212\n\n- Add Hygon Dhyana as known processor to enable support for atomic operations.\n\n  Own Id: OTP-15840\n\n- Make `erlang:phash2` functions consume reductions proportional to the size of\n  the input term and yield scheduler when reductions are depleted.\n\n  Own Id: OTP-15842 Aux Id: PR-2182\n\n- Fix various build issues when compiling Erlang/OTP to the IBM AIX platform.\n\n  Own Id: OTP-15866 Aux Id: PR-2110\n\n- Add configure options `--enable-pie` and `--disable-pie` to control the build\n  of position independent executables.\n\n  Own Id: OTP-15868\n\n- `file:read_file_info/2` can now be used on opened files and directories.\n\n  Own Id: OTP-15956 Aux Id: PR-2231\n\n- Add arity-1 versions of `atom_to_binary`, `binary_to_atom` and\n  `binary_to_existing_atom`, all with `utf8` as default encoding.\n\n  Own Id: OTP-15995 Aux Id: PR-2358\n\n- Optimized the erts internal hash table implementation for faster lookups. The\n  internal hash is used for things like; the process registry, executing\n  erlang:apply/2, executing M:func(test), and more.\n\n  Own Id: OTP-16014 Aux Id: PR-2345\n\n- CPU quotas are now taken into account when deciding the default number of\n  online schedulers, improving performance in container environments where\n  quotas are applied, such as `docker` with the `--cpus` flag.\n\n  Own Id: OTP-16105 Aux Id: ERL-927\n\n- The `-config` option to `erl` now can take multiple config files without\n  repeating the `-config` option. Example:\n\n  erl -config sys local\n\n  Own Id: OTP-16148 Aux Id: PR-2373\n\n- Removed the `scheduler_poll` and `async I/O` dtrace and LTTng trace probes.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16215\n\n- Optimized `persistent_term:put/2` and [`erase/1`](`erase/1`) to consume less\n  CPU in many cases.\n\n  Own Id: OTP-16237 Aux Id: PR-2389\n\n- The possibility to run Erlang distribution without relying on EPMD has been\n  extended. To achieve this a couple of new options to the inet distribution has\n  been added.\n\n  - **\\-dist_listen false** - Setup the distribution channel, but do not listen\n    for incoming connection. This is useful when you want to use the current\n    node to interact with another node on the same machine without it joining\n    the entire cluster.\n\n  - **\\-erl_epmd_port Port** - Configure a default port that the built-in EPMD\n    client should return. This allows the local node to know the port to connect\n    to for any other node in the cluster.\n\n  The `erl_epmd` callback API has also been extended to allow returning `-1` as\n  the creation which means that a random creation will be created by the node.\n\n  In addition a new callback function called `listen_port_please` has been added\n  that allows the callback to return which listen port the distribution should\n  use. This can be used instead of `inet_dist_listen_min/max` if the listen port\n  is to be fetched from an external service.\n\n  Own Id: OTP-16250\n\n- On systems without `closefrom()`, such as Linux, iterating over all possible\n  file descriptors and calling `close()` for each is inefficient. This is\n  markedly so when the maximum number of file descriptors has been tuned to a\n  large number.\n\n  Instead, in erl_child_setup, walk the open descriptors under `/dev/fd` and\n  close only those which are open.\n\n  This optimization affects the CPU usage of starting a new Erlang instance.\n\n  Own Id: OTP-16270\n\n- Optimized `maps:merge/2` for trivial cases of an empty map(s) or same map.\n\n  Own Id: OTP-16283 Aux Id: PR-2441\n\n- The new experimental `socket` module has been moved to the Kernel application.\n\n  Own Id: OTP-16312\n\n- Improved the presentation of allocations and carriers in the `instrument`\n  module.\n\n  Own Id: OTP-16327\n\n- As announced in OTP 22.0, the previously existing limited support for VxWorks\n  has now been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16329 Aux Id: OTP-15621\n\n- The return value when using the `httph` and `httph_bin` option to\n  `erlang:decode_packet/3` and `inet:setopts/2` has been changed to also include\n  the original header unmodified. See `erlang:decode_packet/3`. Example:\n\n  ```erlang\n   >\n  \t    erlang:decode_packet(httph_bin,<<\"HELLO:\n  \t    hi\\r\\n\\r\\n\">>,[]).\n  \t    {ok,{http_header,0,<<\"Hello\">>,<<\"HELLO\">>,<<\"hi\">>},<<\"\\r\\n\">>}\n  ```\n\n  Own Id: OTP-16347 Aux Id: PR-2466\n\n- Ensure `net_kernel:monitor_nodes/1` sends `nodedown` messages of a failed\n  connection before `nodeup` messages of a reestablished connection toward the\n  same node.\n\n  Own Id: OTP-16362\n\n- Update of [sequential tracing](`m:seq_trace#whatis`) to also support other\n  information transfers than message passing.\n\n  Own Id: OTP-16370 Aux Id: OTP-15251, OTP-15232\n\n- socket: It is now possible to create a socket from an already existing file\n  descriptor.\n\n  Own Id: OTP-16398 Aux Id: ERL-1154\n\n- socket: The socket:supports/1 function now also report if netns is supported\n  or not.\n\n  Own Id: OTP-16432\n\n- `=:=` has been optimized to return `false` immediately when comparing two maps\n  of different sizes.\n\n  Own Id: OTP-16454\n\n- Changed the behaviour of passing the `erl` command line argument\n  [`+A 0`](erl_cmd.md#async_thread_pool_size) to silently imply `+A 1`. That is,\n  it will no longer be possible to completely disable the async thread pool.\n  Disabling of the async thread pool has since OTP 21 had no benefits; only lots\n  of drawbacks.\n\n  Own Id: OTP-16482\n\n- The deprecated `erlang:get_stacktrace/0` BIF now returns an empty list instead\n  of a stacktrace. To retrieve the stacktrace, use the extended try/catch syntax\n  that was introduced in OTP 21. `erlang:get_stacktrace/0` is scheduled for\n  removal in OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16484\n\n- `init:restart/1` has been introduced. `init:restart/1` can be utilized for\n  changing the code loading mode during a restart.\n\n  Own Id: OTP-16492 Aux Id: PR-2461\n\n- Improve configure for the net nif, which should increase portability.\n\n  Own Id: OTP-16530 Aux Id: OTP-16464\n\n- socket: Socket counters and socket global counters are now represented as maps\n  (instead of property lists).\n\n  Own Id: OTP-16535\n\n- Reduced the resource usage of `erlc` in parallel builds (e.g. `make -j128`).\n\n  Own Id: OTP-16543 Aux Id: ERL-1186\n\n- The experimental socket module has gotten restrictions removed so now the\n  'seqpacket' socket type should work for any communication domain (protocol\n  family) where the OS supports it, typically the Unix Domain.\n\n  Own Id: OTP-16550 Aux Id: ERIERL-476\n\n- Updated the internal `pcre` library to `8.44`.\n\n  Own Id: OTP-16557\n\n- There is now cost in terms of reductions when copying binary data using the\n  binary syntax.\n\n  Own Id: OTP-16601 Aux Id: OTP-16577\n\n- The executable `erl_call` is now part of the `erts` distribution in addition\n  to `erl_interface`.\n\n  Own Id: OTP-16602\n\n- Fix a buffer overflow bug that caused EPMD to consume 100% CPU after many\n  nodes had been connected on the same time on NetBSD.\n\n  Own Id: OTP-16615\n\n- `erl -remsh` now uses the dynamic node names feature by default. See the\n  [erl](erl_cmd.md) documentation for details.\n\n  Own Id: OTP-16616\n\n- socket: By default the socket options rcvtimeo and sndtimeo are now disabled.\n  To enable these, OTP now has to be built with the configure option\n  --enable-esock-rcvsndtimeo\n\n  Own Id: OTP-16620\n\n- The environment variable $HOME does no longer have to be set before Erlang can\n  be started.\n\n  Own Id: OTP-16635 Aux Id: ERL-476 PR-2390","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.7.2.19 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-19"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"* A race could cause [`process_info(Pid, message_queue_len)`](`process_info/2`) on other processes to return invalid results.\n\n  Own Id: OTP-18169 Aux Id: PR-6134\n* Fixed reduction counting for handling process system tasks.\n\n  Own Id: OTP-18170 Aux Id: PR-6135\n* Priority elevation of terminating processes did not work which could cause execution of such processes to be delayed.\n\n  Own Id: OTP-18175 Aux Id: PR-6142\n* The `erlang:monotonic_time/1`, `erlang:system_time/1`, `erlang:time_offset/1`, and `os:system_time/1` BIFs erroneously failed when passed the argument `native`.\n\n  Own Id: OTP-18197 Aux Id: GH-6165, PR-6213\n* Notifications about available distribution data sent to distribution controller processes could be lost. Distribution controller processes can be used when implementing an alternative distribution carrier. The default distribution over tcp was not effected and the bug was also not present on x86/x86_64 platforms.\n\n  Own Id: OTP-18258 Aux Id: GH-6309, PR-6324","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.18 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug where the process message queue was left in an inconsistent state when\n  changing from on_heap to off_heap message queue data causing the GC to\n  segfault.\n\n  Own Id: OTP-18075 Aux Id: PR-5927\n\n- Fix functions that convert universal to localtime (such as erlang:localtime/0\n  and erlang:universaltime_to_localtime/1) to fetch the correct localtime if it\n  is changed after the start of the VM.\n\n  Own Id: OTP-18076 Aux Id: ERIERL-802 PR-5905\n\n- Fix memory leak when a process doing a distributed fragmented send is sent an\n  exit signal. Before this fix the receiving node would be left with an\n  incomplete message that would remain until the nodes were disconnected. The\n  bug has existed since Erlang/OTP 21.\n\n  Own Id: OTP-18077 Aux Id: GH-5876 PR-5892","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.17 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- By default `global` does _not_ take any actions to restore a fully connected\n  network when connections are lost due to network issues. This is problematic\n  for all applications expecting a fully connected network to be provided, such\n  as for example `mnesia`, but also for `global` itself. A network of\n  overlapping partitions might cause the internal state of `global` to become\n  inconsistent. Such an inconsistency can remain even after such partitions have\n  been brought together to form a fully connected network again. The effect on\n  other applications that expects that a fully connected network is maintained\n  may vary, but they might misbehave in very subtle hard to detect ways during\n  such a partitioning.\n\n  In order to prevent such issues, we have introduced a _prevent overlapping\n  partitions_ fix which can be enabled using the\n  `prevent_overlapping_partitions` `kernel(6)` parameter. When this fix has been\n  enabled, `global` will actively disconnect from nodes that reports that they\n  have lost connections to other nodes. This will cause fully connected\n  partitions to form instead of leaving the network in a state with overlapping\n  partitions. Note that this fix _has_ to be enabled on _all_ nodes in the\n  network in order to work properly. Since this quite substantially changes the\n  behavior, this fix is currently disabled by default. Since you might get hard\n  to detect issues without this fix you are, however, _strongly_ advised to\n  enable this fix in order to avoid issues such as the ones described above. As\n  of OTP 25 this fix will become enabled by default.\n\n  Own Id: OTP-17843 Aux Id: ERIERL-732, PR-5611\n\n- Fix memory leak when tracing on running on a process that only handle system\n  tasks or non-message signals (for example process_info requests).\n\n  Own Id: OTP-17904 Aux Id: ERIERL-757\n\n- Fix Erlang monotonic time on MacOS. Previously used OS monotonic time\n  primitive on MacOS is buggy and will not be used anymore. It has been replaced\n  with usage of another OS monotonic time primitive that does not appear to be\n  buggy.\n\n  Own Id: OTP-17998 Aux Id: PR-5825, GH-5554","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.16 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-16"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Responsiveness of processes executing on `normal` or `low` priority could\n  suffer due to code purging or literal area removal on systems with a huge\n  amount of processes. This since during these operations all processes on the\n  system were scheduled for execution at once.\n\n  This problem has been fixed by introducing a limit on outstanding purge and\n  copy literal requests in the system. By default this limit is set to twice the\n  amount of schedulers on the system. This will ensure that schedulers will have\n  enough work scheduled to perform these operations as quickly as possible at\n  the same time as other work will be interleaved to a much higher degree.\n  Performance of these operations will however be somewhat degraded due to the\n  overhead of enforcing this limit compared to when using a very large limit.\n\n  This limit can be set by passing the `+zosrl` command line argument to `erl`,\n  or by calling\n  `erlang:system_flag(outstanding_system_requests_limit, NewLimit)`.\n\n  Own Id: OTP-17796 Aux Id: ERIERL-729, PR-5473","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.7.2.15 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The runtime system could call `select()` with a too large timeout value when\n  executing on MacOS. This could in turn cause the runtime system to crash.\n\n  Own Id: OTP-17735 Aux Id: GH-5339\n\n- Certain distributed signals that for various reasons must to be forced into\n  the distribution buffer even when it is full would instead be lost if the\n  distribution buffer was full when sent. The effected signals:\n\n  - `EXIT` signals with exit reasons of one word size.\n  - `DOWN` signals with exit reasons of one word size.\n  - `demonitor` signals from a terminating process.\n  - `unlink_ack` signals on OTP 23 and 24.\n  - `spawn_reply` signals on OTP 23 and 24.\n\n  Own Id: OTP-17737 Aux Id: GH-5346, GH-4989","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.14 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- On 32-bit computers, `binary_to_term/1,2` is now more resilient against\n  corrupted binaries containing maps in the external format.\n\n  Own Id: OTP-17604\n\n- A call to [`process_info(Pid, status)`](`process_info/2`) could erroneously\n  report the status `running` when it should have reported `waiting`. This\n  occurred when the calling process was executing on a higher priority than the\n  process being inspected. This bug has been present since OTP 21.0 (erts\n  version 10.0).\n\n  Own Id: OTP-17628\n\n- A race between an exiting port and handling of simultaneously received signals\n  to that port could cause a runtime system crash. The effected signals are\n  `link`, `monitor` and `demonitor`. On OTP 22 a similar race could also cause a\n  memory leak when receiving an `unlink` signal.\n\n  Own Id: OTP-17642 Aux Id: PR-5248\n\n- The message queue of a process entered an inconsistent state after a `receive`\n  expression with an invalid timeout value was executed. If the exception raised\n  due to the invalid timeout value was caught, the following `receive`\n  expression executed by the process could fail to match messages already\n  present in the message queue.\n\n  On OTP 24 this could also cause the whole runtime system to crash.\n\n  Own Id: OTP-17651 Aux Id: GH-5235, PR-5244\n\n- Sending a `Port ! {PortOwner, close}` signal from a process other than the\n  port owner could erroneously trigger a `badsig` exit signal being sent to the\n  port owner process even though the correct `PortOwner` had been passed in the\n  signal.\n\n  Own Id: OTP-17665 Aux Id: PR-5248\n\n- This fixes a bug in `erts_factory_undo` that caused the heap to not be reset\n  correctly. The `erts_factory_undo` function is, for example, called when a\n  [`binary_to_term/1`](`binary_to_term/1`) call fails to reset the heap to its\n  state before the [`binary_to_term/1`](`binary_to_term/1`) call. This can cause\n  the heap to contain invalid terms which potentially can cause issues (e.g.,\n  crashes) when the whole heap is scanned.\n\n  Own Id: OTP-17677\n\n- Fix bug in `persistent_term` when a key-value pair contains a magic reference\n  that is referred more than once. Magic references are NIF resources or\n  returned from BIFs like `ets:new`, `atomics:new`. The bug could cause the\n  memory of the referred resource to be prematurely deallocated.\n\n  The bug also apply to magic references in message passing on a runtime built\n  with configure option `--enable-sharing-preserving`.\n\n  Bug exist for 64-bit since OTP-24.0 and for 32-bit since OTP-20.0.\n\n  Own Id: OTP-17700 Aux Id: GH-5271, PR-5273","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.13 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in `zlib` where decompression would crash with `data_error` on\n  some valid inputs. The bug could also cause extraction from a zip archive\n  using `zip:extract()` to fail.\n\n  Own Id: OTP-17470 Aux Id: ERIERL-657\n\n- A call to `erlang:cancel_timer(_, [{info, false}])` could cause the calling\n  process to block forever in the call. Note that only the synchronous version\n  of the call (that is, the `async` option is `false`) in combination with the\n  `info` option set to `false` was effected by this bug.\n\n  Own Id: OTP-17472 Aux Id: PR-4932\n\n- Microstate accounting (msacc) and `os:perf_counter()` unintentionally used\n  system time instead of monotonic time for time measurements on a lot of\n  systems. These systems were all non x86/x86_64 systems or x86/x86_64 systems\n  without a reliable and constant rdtsc instruction.\n\n  The lock counting (lcnt) built runtime system also unintentionally used system\n  time instead of monotonic time for time measurements on all systems.\n\n  Own Id: OTP-17493\n\n- Simultaneous calls to `erlang:system_flag(schedulers_online, _)` could cause\n  callers to end up in a suspended state forever.\n\n  Own Id: OTP-17500 Aux Id: GH-4809\n\n- Fix rare race bug in memory management of distribution entries. Have been seen\n  to cause VM crash when massive number of repeated concurrent failing\n  connection attempts.\n\n  Own Id: OTP-17513 Aux Id: GH-4964, PR-5015\n\n- Fix buffer overrun problem in the tty driver. The problem happens on some\n  platforms when using the CTRL+R functionality of newshell with very long\n  strings in the history.\n\n  Own Id: OTP-17560 Aux Id: GH-5116\n\n- Fix race-condition that could cause a crash when tracing scheduling or garbage\n  collections on a process that was running on a dirty scheduler.\n\n  Own Id: OTP-17568 Aux Id: PR-4940\n\n- Fix rare bug where re:run would crash/return invalid results when given a\n  subbinary as subject.\n\n  This bug has existed since Erlang/OTP 20.0.\n\n  Own Id: OTP-17585 Aux Id: GH-5150\n\n- `binary_to_term/1,2` is now more resilient against corrupted binaries\n  containing maps in the external format.\n\n  Own Id: OTP-17594","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.12 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A call to `port_command()` could cause a scheduler to end up in an eternal\n  loop if the port was busy and the calling process had incoming signals at the\n  time of the call. This bug was introduced in OTP 23.3.2 (ERTS version 11.2.1),\n  OTP 22.3.4.18 (ERTS version 10.7.2.10), and OTP 21.3.8.23 (ERTS version\n  10.3.5.18).\n\n  Own Id: OTP-17448 Aux Id: GH-4898, PR-4903, OTP-17291","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.11 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug in match spec compilator seen to cause a stack overflow crash on debug\n  VM for certain match specs. Could potentially cause problems for standard VM,\n  but has not been verified. Match specs are used by `ets:match/select`\n  functions and `erlang:trace_pattern`.\n\n  Own Id: OTP-17379 Aux Id: PR-4804\n\n- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.10 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The following signals could pass before other signals from the same sender to\n  the same receiver. That is, these signals could arrive too early.\n\n  - `garbage-collect` request. Sent from one process to another using one of the\n    `garbage_collect/0` BIFs.\n  - `check-process-code` request. Sent from one process to another using one of\n    the `check_process_code()` BIFs.\n  - `is-process-alive` reply. Sent as a response to a process calling the\n    `is_process_alive()` BIF.\n  - `process-info` reply. Sent as a response to a process calling one of the\n    `process_info()` BIFs.\n  - `port-command` reply. Sent as a response to a process calling one of the\n    `port_command()` BIFs.\n  - `port-connect` reply. Sent as a response to a process calling the\n    `port_connect()` BIF.\n  - `port-close` reply. Sent as a response to a process calling the\n    `port_close()` BIF.\n  - `port-control` reply. Sent as a response to a process calling the\n    `port_control()` BIF.\n  - `port-call` reply. Sent as a response to a process calling the `port_call()`\n    BIF.\n  - `port-info` reply. Sent as a response to a process calling one of the\n    `port_info()` BIFs.\n\n  Own Id: OTP-17291\n\n- A garbage collection of a literal area missed messages that entirely consisted\n  of a term in a literal area. This could in turn lead to a crash of the runtime\n  system.\n\n  Own Id: OTP-17307\n\n- A call to [`process_flag(message_queue_data, off_heap)`](`process_flag/2`)\n  could cause a crash of the runtime system when sequential tracing was enabled.\n\n  Own Id: OTP-17349","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.9 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in the timer implementation which could cause timers that were set\n  to more than 37.25 hours in the future to be delayed. This could occur if\n  there were multiple timers scheduled to be triggered very close in time, but\n  still at different times, and the scheduler thread handling the timers was not\n  able to handle them quickly enough. Delayed timers were in this case triggered\n  when another unrelated timer was triggered.\n\n  Own Id: OTP-17253\n\n- Fix bug in call_time tracing (used by eprof) that could cause VM crash. Bug\n  exists since OTP-22.2 (but not in OTP-23).\n\n  Own Id: OTP-17290 Aux Id: GH-4635","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Fix a file descriptor leak when using sendfile and the remote side closes the\n  connection. This bug has been present since OTP-21.0.\n\n  Own Id: OTP-17244","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.7.2.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug that could cause some work scheduled for execution on scheduler\n  threads to be delayed until other similar work appeared. Beside delaying\n  various cleanup of internal data structures also the following could be\n  delayed:\n\n  - Termination of a distribution controller process\n  - Disabling of the distribution on a node\n  - Gathering of memory allocator information using the `instrument` module\n  - Enabling, disabling, and gathering of `msacc` information\n  - Delivery of `'CHANGE'` messages when time offset is monitored\n  - A call to `erlang:cancel_timer()`\n  - A call to `erlang:read_timer()`\n  - A call to `erlang:statistics(io | garbage_collection | scheduler_wall_time)`\n  - A call to `ets:all()`\n  - A call to `erlang:memory()`\n  - A call to `erlang:system_info({allocator | allocator_sizes, _})`\n  - A call to `erlang:trace_delivered()`\n\n  The bug existed on runtime systems running on all types of hardware except for\n  x86/x86_64.\n\n  Own Id: OTP-17185","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The `suspend_process()` and `resume_process()` BIFs did not check their\n  arguments properly which could cause an emulator crash.\n\n  Own Id: OTP-17080\n\n- The runtime system would get into an infinite loop if the runtime system was\n  started with more than 1023 file descriptors already open.\n\n  Own Id: OTP-17088 Aux Id: ERIERL-580","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed rare distribution bug in race between received signal\n  (link/monitor/spawn_request/spawn_reply) and disconnection. Symptom: VM crash.\n  Since: OTP 21.0.\n\n  Own Id: OTP-16869 Aux Id: ERL-1337","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bugs causing issues when enabling the ERTS internal allocators on a\n  system built with the undocumented and unsupported `SMALL_MEMORY` feature.\n\n  Own Id: OTP-16939","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- inet:setopts(\\[\\{active,once\\}]) wakes up IO polling thread unnecessarily,\n  leading to lock contention and visibly higher CPU utilization.\n\n  Own Id: OTP-16847 Aux Id: ERL-1301\n\n- The documentation of [`statistics(run_queue)`](`statistics/1`) erroneously\n  stated that it returns the total length of all normal run queues when it is\n  the total length of all normal and dirty CPU run queues that is returned. The\n  documentation has been updated to reflect the actual behavior.\n\n  Own Id: OTP-16866 Aux Id: ERL-1355\n\n- Two bugs in the ERTS internal thread wakeup functionality have been fixed.\n  These bugs mainly hit when all threads in the system tried to go to sleep.\n  When the bugs were triggered, certain operations were delayed until a thread\n  woke up due to some other reason. Most important operations effected were code\n  loading, persistent term updates, and memory deallocation.\n\n  Own Id: OTP-16870\n\n- Fixed bug in `ets:select_replace/2` on `compressed` tables that could produce\n  faulty results or VM crash. Bug exists since OTP 20.\n\n  Own Id: OTP-16874 Aux Id: ERL-1356, PR-2763","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- As of OTP 22, the allocator specific memory carrier pools were replaced by a\n  node global carrier pool. This unfortunately caused substantial memory\n  fragmentation in some cases due to long lived data being spread into carriers\n  used by allocators mainly handling short lived data.\n\n  A new command line argument `+M cp` has been introduced with which one can\n  enable the old behavior as well as configuring other behaviors for the carrier\n  pools. In order to configure the old behavior, with allocator specific carrier\n  pools for all allocators, pass `+Mucp :` (including the colon character) as a\n  command line argument to `erl` when starting the Erlang system.\n\n  The default configuration for carrier pools will be changed to `+Mucp :` some\n  time in the future, but not in this patch.\n\n  Own Id: OTP-16856","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.7.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The ERTS internal I/O poll implementation could get into an inconsistent state\n  causing input events to be ignored.\n\n  Own Id: OTP-16780 Aux Id: PR-2701","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- An unintentional reuse of an already used emulator internal event object could\n  cause a wakeup signal to a thread to be lost. In worst case this could cause\n  the runtime system to hang. This hang was however quite rare.\n\n  Own Id: OTP-16766 Aux Id: ERL-1304\n\n- NIF threads and driver threads on non-Linux systems leaked internal resources\n  when terminating. On Windows these resources were one event per thread. On\n  most other systems one mutex and one condition variable per thread. On these\n  other systems that also lacked `pthread_cond_timedwait()` also a pipe with its\n  file descriptors was leaked.\n\n  Own Id: OTP-16772 Aux Id: ERL-1304","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in erl_crash.dump generation that could cause a SEGV core dump if a\n  recently cancelled timer was found.\n\n  Own Id: OTP-16596 Aux Id: ERL-1105, PR-2606\n\n- The functionality utilized by BIFs for temporary disabling of garbage\n  collection while yielding could cause system task queues to become\n  inconsistent on a process executing such a BIF. Process system tasks are for\n  example utilized when purging code, garbage collecting literal data, and when\n  issuing an ordinary garbage collection from another process.\n\n  The bug does not trigger frequently. Multiple code purges in direct sequence\n  makes it more likely that this bug is triggered. In the cases observed, this\n  has resulted in a hanging code purge operation.\n\n  Own Id: OTP-16639 Aux Id: ERL-1236\n\n- SCTP and UDP recv/2,3 hangs indefinitely if socket is closed while recv is\n  called (socket in passive mode).\n\n  Own Id: OTP-16654 Aux Id: ERL-1242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A literal area could prematurely be released before all uses of it had been\n  removed. This occurred either when a terminating process had a complex exit\n  reason referring to a literal that concurrently was removed, or when a\n  terminating process continued executing a dirty NIF accessing a literal (via\n  the heap) that concurrently was removed.\n\n  Own Id: OTP-16640 Aux Id: OTP-16193\n\n- The VM could potentially crash when checking process code of a process that\n  terminated while executing a dirty NIF. The checking of process code is part\n  of a code purge operation.\n\n  Own Id: OTP-16641\n\n- System tasks of `low` priority were not interleaved with `normal` priority\n  system tasks as they should. This could potentially delay garbage collection\n  of another process longer than intended if the garbage collection was\n  requested from a `low` priority process.\n\n  Own Id: OTP-16642","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [re:run(Subject, RE, \\[unicode])](`re:run/3`) returned `nomatch` instead of\n  failing with a `badarg` error exception when `Subject` contained illegal utf8\n  and `RE` was passed as a binary. This has been corrected along with\n  corrections of reduction counting in `re:run()` error cases.\n\n  Own Id: OTP-16553\n\n- Fixed a bug that could cause the emulator to crash when purging modules or\n  persistent terms.\n\n  Own Id: OTP-16555 Aux Id: ERL-1188\n\n- Fixed a bug in a receive optimization. This could cause a `receive` not to\n  match even though a matching message was present in the message queue. This\n  bug was introduced in ERTS version 10.6 (OTP 22.2).\n\n  Own Id: OTP-16572 Aux Id: ERL-1199, OTP-16269","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- `gen_udp:recv(S, N, 0)` corrupted the internal state for the socket so after\n  receive with `{active, once}` it always returned `{error, timeout}`, and\n  wasted the received UDP packets. This bug has now been fixed.\n\n  Reported and pinpointed by Alexander Petrovsky.\n\n  Own Id: OTP-16059\n\n- The atom esock_atom_user and esock_atom_kernel was never actually created.\n  This has now been corrected.\n\n  Own Id: OTP-16381\n\n- Fixed bug in `socket` module that could potentially lead to scheduler\n  deadlocks.\n\n  Own Id: OTP-16384\n\n- Fix bug causing VM crash if `down` or `stop` callback of a NIF resource is\n  called after the NIF module has been purged. The fix will postpone unloading\n  until all such resource objects have been garbage collected.\n\n  Own Id: OTP-16399\n\n- Fixed bug in `ets:update_counter/4`, when called with an invalid `UpdateOp`\n  and a `Key` that does not exist, causing `ets:info(T,size)` to return\n  incorrect values. Bug exists since OTP-19.0.2.\n\n  Own Id: OTP-16404 Aux Id: ERL-1127\n\n- Fix potential heap corrupting bugs when a process calls a BIF that blocks\n  other normal schedulers and then writes to its own heap without the main\n  process lock. A NIF running on a dirty scheduler trying to interact with such\n  a process could corrupt its heap. The fixed BIFs were related to code loading\n  and tracing.\n\n  Own Id: OTP-16417\n\n- Fixed bug in `erlang:list_to_ref/1` when called with a reference created by a\n  remote note. Function [`list_to_ref/1`](`list_to_ref/1`) is intended for\n  debugging and not to be used in application programs. Bug exist since OTP\n  20.0.\n\n  Own Id: OTP-16438\n\n- The prim_net nif (net/kernel) made use of an undefined atom, notsup. This has\n  now been corrected.\n\n  Own Id: OTP-16440\n\n- Corrected the valid range of the `erl` command line argument\n  [`+SDio  `](erl_cmd.md#%2BSDio) from `0..1024` to\n  `1..1024`. `+SDio 0` was erroneously allowed which just caused the VM to crash\n  on the first dirty I/O job scheduled.\n\n  Own Id: OTP-16481\n\n- Fix a crash when attempting to log faults when loading files during early\n  boot.\n\n  Own Id: OTP-16491","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- For [socket](`m:socket#`), not all send and receive flags are supported on all\n  platforms. In order to (at least) simplify testing, the\n  socket:supports/0,1,2,3 functions has been extended with send_flags and\n  recv_flags items, which indicates what the current platform can manage.\n\n  Own Id: OTP-16153\n\n- Add a \"full featured\" version of getifaddrs in the net module.\n\n  Own Id: OTP-16212 Aux Id: ERL-1070\n\n- The options `busy_limits_port` and `busy_limits_msgq` have been added to the\n  BIF `erlang:open_port/2`. The `busy_limits_port` option can be used for\n  controlling the busy state of a port executing the `spawn_driver` or the\n  `fd_driver`. The `busy_limits_msgq` option can be used for controlling the\n  busy state of the port message queue.\n\n  Own Id: OTP-16306 Aux Id: ERIERL-439\n\n- A socket \"registry\" has been added making it possible to list current open\n  sockets.\n\n  Own Id: OTP-16309\n\n- The counters managed by the socket nif has been extended. Their \"size\" has\n  been increased from 32 bit to 64. Two max package size (for read and write)\n  has been added. And four accept counters has been added.\n\n  Own Id: OTP-16387\n\n- Add gcc option `-fno-common` to detect accidental name clashes of global\n  variables.\n\n  Own Id: OTP-16420 Aux Id: PR-2513\n\n- New dynamic lock checker that verifies locking orders and detects potential\n  deadlock bugs in drivers and NIFs. Enabled together with the old static lock\n  checker (for ERTS internal locks) in emulator started with `-emu_type debug`\n  or built with configuration option `--enable-lock-checking`.\n\n  Own Id: OTP-16427","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.6.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process could get into an inconsistent state where it was runnable, but\n  never scheduled for execution. This could occur when a mix of `normal` and\n  `low` priority processes where scheduled on the same type of dirty scheduler\n  simultaneously.\n\n  Own Id: OTP-16446 Aux Id: ERL-1157","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.6.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process could end up in a state where it got endlessly rescheduled without\n  making any progress. This occurred when a system task, such as check of\n  process code (part of a code purge), was scheduled on a high priority process\n  trying to execute on a dirty scheduler.\n\n  Own Id: OTP-16436 Aux Id: ERL-1152","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Improved signal handling for processes executing dirty. For example, avoid\n  busy wait in dirty signal handler process when process is doing garbage\n  collection on dirty scheduler.\n\n  Own Id: OTP-16358","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.6.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Taking a scheduler offline could cause timers set while executing on that\n  scheduler to be delayed until the scheduler was put online again. This bug was\n  introduced in ERTS version 10.0 (OTP 21.0).\n\n  Own Id: OTP-16371\n\n- The `ets:update_counter/4` core dumped when given an ordered_set with\n  write_concurrency enabled and an invalid position. This bug has been fixed.\n\n  Own Id: OTP-16378 Aux Id: ERL-1125\n\n- A process calling\n  [`erlang:system_flag(multi_scheduling, block)`](`m:erlang#system_flag_multi_scheduling`)\n  could end up blocked waiting for the operation to complete indefinitely.\n\n  Own Id: OTP-16379","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Duplicate entries for \\[socket:]getopt and \\[socket:]setopt in man page.\n\n  Own Id: OTP-16333 Aux Id: ERL-1104","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.6.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Corrected an issue with the new socket api which could cause a core dump. A\n  race during socket close could cause a core dump (an invalid nif environment\n  free).\n\n  Own Id: OTP-16314 Aux Id: ERL-1098\n\n- Corrected an issue with the new socket api which could cause a core dump. When\n  multiple accept processes waiting for a connect a connect could cause a core\n  dump.\n\n  Own Id: OTP-16359","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The functions [`unicode:characters_to_list()`](`unicode:characters_to_list/2`)\n  and [`unicode:characters_to_binary()`](`unicode:characters_to_binary/3`)\n  raised a `badarg` exception instead of returning an error tuple when passed\n  very large invalid code points as input.\n\n  Own Id: OTP-16052\n\n- `file:allocate/3` will now work properly on Mac OS.\n\n  Own Id: OTP-16074 Aux Id: ERL-1042, PR-2386\n\n- For [socket](`m:socket#`), invalid encoding of send and receive flags caused\n  badarg and send failure.\n\n  Own Id: OTP-16149\n\n- Fix a bug in `re` on platforms where the native stack grows upwards, for\n  instance on HP PA-RISC.\n\n  Own Id: OTP-16150 Aux Id: ERL-1043\n\n- For [socket](`m:socket#`), unable to properly decode the timestamp control\n  message header on FreeBSD. We incorrectly used the SO_TIMESTAMP flag for the\n  timestamp control message header type. It should have been SCM_TIMESTAMP. This\n  caused the timestamp control message header to not be fully decoded.\n\n  Own Id: OTP-16151 Aux Id: #2400\n\n- For [socket](`m:socket#`), when setting the ip option 'recvtos' to true,\n  thereby indicating that we want to receive the TOS control message header, we\n  don't actually get TOS but RECVTOS on FreeBSD (and maybe others)\\! This was\n  previously not handled.\n\n  Own Id: OTP-16152 Aux Id: OTP-16114\n\n- Fixed a bug where the emulator would print out error messages forever if it\n  crashed during startup.\n\n  Own Id: OTP-16159 Aux Id: ERL-1060\n\n- For [socket](`m:socket#`), wrong type for protocol caused segmentation fault\n  if protocol was provided as \\{raw, integer()\\}.\n\n  Own Id: OTP-16163 Aux Id: ERL-1061\n\n- For [socket](`m:socket#`), when setting the ip option 'recvttl' to true,\n  thereby indicating that we want to receive the TTL control message header, we\n  don't actually get TTL but RECVTTL on Solaris (and maybe others)\\! This was\n  previously not handled.\n\n  Own Id: OTP-16172 Aux Id: OTP-16114\n\n- For [socket](`m:socket#`), IPv6 control message headers was incorrectly\n  decoded with level ip instead of ipv6.\n\n  Own Id: OTP-16173\n\n- Fix configure bug where `clock_getres` would not correctly be detected causing\n  `erlang:system_info(os_system_time_source)` to return an incorrect resolution.\n\n  This bug effects all OSs that use `clock_gettime` to get time (basically all\n  OSs except windows) and has been present since OTP-19.2.\n\n  Own Id: OTP-16191 Aux Id: ERL-1067\n\n- Fix bugs when using `ERLC_USE_SERVER=true` on Windows when building\n  Erlang/OTP.\n\n  Change the cookie used by the compile server to be hard coded instead of using\n  the users cookie.\n\n  Own Id: OTP-16192\n\n- Fix so that `persistent_term` is listed in the erts application file.\n\n  Own Id: OTP-16194\n\n- Fix bug in call_time tracing which could sometimes cause call time\n  measurements being attributed to the wrong function.\n\n  Own Id: OTP-16195 Aux Id: ERL-1027\n\n- The [socket](`m:socket#`) socket option 'peek_off' has been disabled. If\n  peek_off was set and then socket:recv/3 was called with the peek flag, the\n  call could hang.\n\n  Own Id: OTP-16196\n\n- Handle possibly uninitiated (control message header) data.\n\n  Own Id: OTP-16197\n\n- For [net](`m:net#`), a couple of NI macros was deprecated in new versions of\n  glibc, so these are no longer used (IDN_ALLOW_UNASSIGNED and\n  IDN_USE_STD3_ASCII_RULES).\n\n  Own Id: OTP-16203\n\n- The string value from a get operation needed to be truncated.\n\n  Own Id: OTP-16204\n\n- Fix misleading seq_trace message for remote send operation toward named\n  process. Changed receiver to be `{Name,Node}` instead of just `Name`.\n\n  Own Id: OTP-16206 Aux Id: PR-2423\n\n- Fixed a bug causing actual nodedown reason reported by\n  [`net_kernel:monitor_nodes(true, [nodedown_reason])`](`net_kernel:monitor_nodes/2`)\n  to be lost and replaced by the reason `killed`.\n\n  Own Id: OTP-16216\n\n- For [socket](`m:socket#`), the timestamp creation used when printing warning\n  messages and debug printouts did not work. The used buffer was too small.\n\n  Own Id: OTP-16223\n\n- Fix compiler warnings generated by GCC 8\n\n  Own Id: OTP-16235\n\n- Fix `erl -emu_type` to accept the option `opt` which means the normal\n  optimized emulator. This can be used to override the `-emu_type` option from\n  environment variables.\n\n  Own Id: OTP-16297\n\n- Corrected the function spec to reflect the actual code of the function\n  socket:bind.\n\n  Own Id: OTP-16310 Aux Id: ERL-1082\n\n- Fixed a performance issue in ETS lookup when using the `compressed` option and\n  the term contained atoms. Before this fix the decompress algorithm for atoms\n  would unnecessarily take a global lock to validate the atom.\n\n  Own Id: OTP-16316","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- For [socket](`m:socket#`), not all send and receive flags are supported on all\n  platforms. In order to (at least) simplify testing, the\n  socket:supports/0,1,2,3 functions has been extended with send_flags and\n  recv_flags items, which indicates what the current platform can manage.\n\n  Own Id: OTP-16153\n\n- For [socket](`m:socket#`), add support for IPv6 socket options tclass and\n  recvtclass. Both has been added, but the use of them are platform dependent.\n  Call socket:supports(options, ipv6, Opt) to be sure what option to use in\n  order to request a TCLASS control message header.\n\n  Own Id: OTP-16180\n\n- For [socket](`m:socket#`), the TCP socket option cork was not supported even\n  though the supports function reported it as such.\n\n  Own Id: OTP-16205\n\n- The Kernel application's User's Guide now contain a Logger Cookbook with\n  common usage patterns.\n\n  Own Id: OTP-16208\n\n- Add a \"full featured\" version of getifaddrs in the net module.\n\n  Own Id: OTP-16212 Aux Id: ERL-1070\n\n- Fix an inefficiency introduced by the bug fix in OTP-16241 which fixed a\n  problem with the receive optimization. That bug fix introduced an inefficiency\n  when using the receive optimization and a burst of messages arrive at once\n  when the receiving process' mailbox was empty.\n\n  Own Id: OTP-16269 Aux Id: OTP-16241\n\n- For [socket](`m:socket#`), added support for the socket option extended_err.\n  Andreas Schultz.\n\n  Own Id: OTP-16302 Aux Id: #2449\n\n- ETS tables have been optimized to not use any locks when running in a system\n  with only one scheduler enabled. This can provide significant performance\n  gains for applications that use ETS tables heavily.\n\n  Own Id: OTP-16315","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.5.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Large amounts of quickly executed dirty work could cause heavy contention on\n  an internal spin lock. The spin lock was replaced by a mutex which behaves\n  much better under these conditions.\n\n  Own Id: OTP-16301 Aux Id: ERL-1079","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.5.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A literal area could prematurely be released before all uses of it had been\n  removed. This occurred either when a terminating process had a complex exit\n  reason referring to a literal that concurrently was removed, or when a\n  terminating process continued executing a dirty NIF accessing a literal (via\n  the heap) that concurrently was removed.\n\n  Own Id: OTP-16193\n\n- Fix bug causing VM crash due to memory corruption of distribution entry.\n  Probability of crash increases if Erlang distribution is frequently\n  disconnected and reestablished towards same node names. Bug exists since\n  OTP-21.0.\n\n  Own Id: OTP-16224 Aux Id: ERL-1044\n\n- Fixed bug causing crash of VM built with configuration\n  `--enable--sharing-preserving`. Provoked when a sent message contains both a\n  bit string and the heap binary (< 65 bytes) which the bit string was matched\n  from. Bug exists since OTP-19.0 but has seen to be easier to provoke since\n  OTP-22.1.\n\n  Own Id: OTP-16265 Aux Id: ERL-1064","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.5.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The compiler could do an unsafe optimization of receives, which would cause a\n  receive to only scan part of the message queue.\n\n  This bug fix in the compiler fixes a bug in the socket module.\n\n  Own Id: OTP-16219 Aux Id: ERL-1076\n\n- Fix bug where the receive marker used by the runtime to do the receive queue\n  optimization could be incorrectly set. The symptom of this would be that a\n  message that should match in a receive never matches.\n\n  The bug requires the OTP-22 compiler and multiple selective receives to\n  trigger. See OTP-16219 for details about the bug fix in the compiler.\n\n  Own Id: OTP-16241 Aux Id: ERL-1076 OTP-16219","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.5.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Erlang/OTP can now be built on macOS Catalina (10.15).\n\n  Own Id: OTP-16177 Aux Id: ERL-1063","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.5.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5-2"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Added the environment variable `ERLC_SERVER_ID`, which allows multiple compile\n  servers to run separately under the same user.\n\n  Own Id: OTP-16125 Aux Id: ERIERL-412","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.5.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A terminating process sending distributed `'EXIT'` or `'DOWN'` signals while\n  terminating could end up in a state where no progress at all was made. This\n  was triggered by a distribution channel that the terminating process was\n  sending on got busy. This bug has existed since ERTS version 10.4 (OTP 22.0).\n\n  Own Id: OTP-16069\n\n- When communicating with a simultaneously exiting port via the\n  `erlang:port_*()` BIFs one could sometimes get stray `{Ref, What}` messages.\n  Where `Ref` was a reference and `What` usually were the atom `badarg`.\n\n  Own Id: OTP-16107 Aux Id: ERL-1049","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If you set `{linger,{true,0}}` on a `gen_tcp` listen socket, accept a\n  connection on that socket, and then close the accepted socket, now the linger\n  zero setting is transferred to the accepted socket. Before this correction\n  that information was lost and the close behaviour on the accepted socket\n  incorrect.\n\n  Own Id: OTP-15370 Aux Id: ERIERL-353\n\n- Sending ancillary data implemented in OTP-15747 accidentally left behind test\n  code that caused all UDP sends to fail on Windows. This has now been fixed.\n\n  Own Id: OTP-15422 Aux Id: OTP-15747\n\n- In the socket nif, used invalid flags when if-def'ing for supported TCP flags:\n  TCP_MAXSEG and TCP_NODELAY (the support function).\n\n  Own Id: OTP-15827\n\n- Fixed memory leaks in experimental socket module.\n\n  Own Id: OTP-15830\n\n- `re:run()` now yields when validating utf8 in a large subject.\n\n  Own Id: OTP-15836 Aux Id: ERL-876\n\n- Fixed bug in `seq_trace:set_token(label,Term)` which could cause VM crash if\n  `Term` was heap allocated (not an atom, small integer, local pid or port). Bug\n  exists since OTP 21.0 when terms other than small integers were first allowed\n  as labels.\n\n  Own Id: OTP-15849 Aux Id: ERL-700\n\n- Extra `-mode` flags given to `erl` are ignored with a warning.\n\n  Own Id: OTP-15852\n\n- Don't loop indefinitely when `--enable-pgo` is given to configure, but\n  compiler does not support pgo.\n\n  Own Id: OTP-15853 Aux Id: PR-2254\n\n- Fix `seq_trace:print/2` not to raise `badarg` exception if label is not a\n  small integer. Bug exists since OTP 21.0.\n\n  Own Id: OTP-15859 Aux Id: ERL-700\n\n- Fixed hipe_flush_icache_range for non-Linux OS on ARM.\n\n  Own Id: OTP-15874 Aux Id: ERL-958, PR-2266\n\n- The fix in OTP-15871 was too conservative and disabled the offending load-time\n  optimization in some cases where it was safe.\n\n  Own Id: OTP-15881\n\n- Upgraded the ERTS internal PCRE library from version 8.42 to version 8.43. See\n  [http://pcre.org/original/changelog.txt](http://pcre.org/original/changelog.txt)\n  for information about changes made to PCRE. This library implements major\n  parts of the `m:re` regular expressions module.\n\n  Own Id: OTP-15889\n\n- Fix race condition when closing a socket while using `{active,N}` on Windows.\n\n  Own Id: OTP-15901 Aux Id: ERL-960 PR-2272\n\n- Allow more than one `-config` command line option to `erl` on Windows to\n  conform with other OS.\n\n  Own Id: OTP-15918 Aux Id: ERL-912\n\n- Fix so that ERL_FLAGS environment variable does not interfere with command\n  line arguments. Before this fix you could write:\n\n  `ERL_FLAGS=\"10\" erl +S`\n\n  and erlang would start as if `+S` had been given the argument `10`.\n\n  Own Id: OTP-15931\n\n- The bug with ID ERL-717 has been fixed. The functions `io:columns()` and\n  `io:rows()` only worked correctly inside interactive erlang shells before this\n  fix. These functions returned `{error,enotsup}` before this fix even if stdout\n  and stdin were connected to a terminal when they were invoked from an escript\n  or a program started with e.g., `erl -noshell`.\n\n  Own Id: OTP-15959 Aux Id: ERL-717\n\n- Do not use named label in `ethread.c` inline assemble. This allows erts to be\n  compiled using gcc 9.1.0 with LTO enabled.\n\n  Own Id: OTP-15971 Aux Id: PR-2333\n\n- `erlang:fun_to_list/1` will now escape the module and function name when\n  necessary.\n\n  Own Id: OTP-15975 Aux Id: ERL-1009\n\n- [`process_info(P,binary)`](`process_info/2`) would neglect to look through\n  heap fragments, potentially missing a few binaries associated with the\n  process.\n\n  Own Id: OTP-15978 Aux Id: ERIERL-366\n\n- HiPE is now automatically disabled on systems with non-glibc implementation\n  (for instance musl). This is because musl does not provide the API's for\n  guaranteeing that signals are delivered on the correct native stack.\n\n  Own Id: OTP-16037\n\n- Fixed bug triggered if a process is killed during call to\n  `persistent_term:put` or `persistent_term:erase`.\n\n  Own Id: OTP-16041\n\n- Add units to all memory slogans in the crash dump documentation.\n\n  Own Id: OTP-16042\n\n- Fix a bug in `binary_to_term` that would crash the emulator if a term larger\n  than 16GB was to be decoded.\n\n  Own Id: OTP-16058 Aux Id: PR-2382\n\n- Fixed bug related to an exiting process sending EXIT and DOWN signals to\n  remote linked/monitored processes. Bugs exists since OTP 22.0.\n\n  Own Id: OTP-16060","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- `erlc` can now automatically use a compile server to avoid starting an Erlang\n  system for each file to be compiled in a multi-file project. See the\n  documentation for how to enable it.\n\n  Own Id: OTP-15738 Aux Id: PR-2361\n\n- The possibility to send ancillary data, in particular the TOS field, has been\n  added to `gen_udp:send/4,5`.\n\n  Own Id: OTP-15747 Aux Id: ERIERL-294\n\n- The net module has been split into 'net' (kernel) and prim_net (preloaded).\n\n  Own Id: OTP-15765\n\n- Socket counters now works as expected and can also be extracted with the (new)\n  info function.\n\n  Own Id: OTP-15818\n\n- `re:run()` now avoids validating utf8 in the subject more than once in the\n  same call. This validation could previously be performed multiple times when\n  the `global` option was passed.\n\n  Own Id: OTP-15831 Aux Id: ERL-876\n\n- The un-documented function `erlang:dist_get_stat/1` now returns the real value\n  of what the distribution queue contains instead of a boolean.\n\n  Own Id: OTP-15905 Aux Id: PR-2270\n\n- ETS `ordered_set` tables with `write_concurrency` enabled has got a\n  performance issue fixed. There were no limits for the values of internal\n  statistics counters before this fix. This could result in that the data\n  structure sometimes reacted slowly to a change in how many parallel processes\n  were using it.\n\n  Own Id: OTP-15906\n\n- Optimize the reception of large distribution messages.\n\n  Own Id: OTP-15926 Aux Id: PR-2291\n\n- Binary matching and functions like [`split_binary/2`](`split_binary/2`) will\n  now create heap binaries when the results are small enough, reducing the\n  chances of small sub-binaries keeping large binaries alive.\n\n  Own Id: OTP-15977 Aux Id: ERIERL-366\n\n- Fixed rare emulator crash in `instrument:allocations/0-1`.\n\n  Own Id: OTP-15983\n\n- Ports could pass very small binaries as reference counted off heap binaries to\n  processes. This could cause an unnecessary large memory usage and an\n  unnecessary load on the binary allocator. Small binaries are now always passed\n  as heap binaries to processes.\n\n  Own Id: OTP-16001 Aux Id: ERIERL-366\n\n- `unicode:characters_to_binary()` could return very small binaries as reference\n  counted off heap binaries. This could cause an unnecessary large memory usage\n  and an unnecessary load on the binary allocator. Small binaries are now always\n  returned as heap binaries.\n\n  Own Id: OTP-16002 Aux Id: ERIERL-366\n\n- Improved `erl_nif` documentation regarding `on_load` and Erlang stub/fallback\n  functions.\n\n  Own Id: OTP-16028 Aux Id: PR-2362\n\n- New feature `ets:info(_, binary)` to get information about all reference\n  counted binaries kept by a table. This is the same kind of debug information\n  that [`process_info(_, binary)`](`process_info/2`) returns for a process.\n\n  Own Id: OTP-16035 Aux Id: ERIERL-366","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.4.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- An invalid value test caused the socket:setopt(Socket, ip, add_membership,\n  ip_mreq()) to fail with badarg. The same for drop_membership.\n\n  Own Id: OTP-15908 Aux Id: ERL-980\n\n- Fixed bug causing VM crash when doing textual dump of a process containing an\n  unhandled monitor down signal. Textual process dumps can be done with\n  `erlang:system_info(procs)`, trace feature `process_dump`, Erlang shell break\n  menu and a crashdump. Bug exist since OTP 21.0.\n\n  Own Id: OTP-15909 Aux Id: ERL-979\n\n- `lists:subtract/2` would produce incorrect results for some inputs on 64-bit\n  platforms.\n\n  Own Id: OTP-15938 Aux Id: ERL-986\n\n- Fixed a bug in the loader that was similar to `OTP-15938`, yielding incorrect\n  code for some inputs on 64-bit platforms.\n\n  Own Id: OTP-15939\n\n- Fixed bug causing scheduler threads in rare cases to block spinnning\n  indefinitely. Bug exists since OTP 21.0.\n\n  Own Id: OTP-15941 Aux Id: PR-2313","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.4.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a buffer overflow when\n  [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`) and\n  `list_to_existing_atom/2` was used with the `latin1` encoding.\n\n  Own Id: OTP-15819 Aux Id: ERL-944\n\n- The runtime system disconnected a connection if it received an\n  [`exit/2`](`exit/2`) signal where the recipient was a process on an old\n  incarnation of the current node. That is, the receiving node had the same node\n  name, but another \"creation\" number. The signal will now just be dropped since\n  the receiving process no longer exists.\n\n  Own Id: OTP-15867 Aux Id: ERIERL-373","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.4.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed [`process_info(Pid,reductions)`](`process_info/2`) to not categorically\n  increase reduction count of the measured process `Pid`. Repeated reduction\n  measure of an idle process will most often (but not guaranteed) return the\n  same value, like it behaved before OTP 21.3.8.\n\n  Own Id: OTP-15865 Aux Id: ERL-964\n\n- Fixed an incorrect load-time optimization that could cause a crash when\n  extracting deeply nested tuple elements.\n\n  Own Id: OTP-15871 Aux Id: ERIERL-374\n\n- Fix bug causing VM crash when pressing P for \"proc info\" in Erlang shell break\n  menu. Bug exists since OTP 22.0.\n\n  Own Id: OTP-15873 Aux Id: ERL-965","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.4.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- In nested use of `try`/`catch`, rethrowing an exception using `erlang:raise/3`\n  with a different class would not always be able to change the class of the\n  exception.\n\n  Own Id: OTP-15834 Aux Id: ERIERL-367","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Do not allocate new bitstring/binary when an empty binary is appended.\n\n  Own Id: OTP-15535 Aux Id: PR-2055\n\n- Document that [`process_info(_, current_function)`](`process_info/2`) can\n  return `{current_function, undefined}` in case of execution of native code.\n\n  Own Id: OTP-15543 Aux Id: PR-2089\n\n- Fixed bug in `ets:select`, `ets:match` and friends which could cause the table\n  to remain fixated (as if `ets:safe_fixtable` had been called) after the call\n  returned. This could happen for `protected` tables if another concurrent\n  running process transferred table ownership to the process during its\n  ets:select/match call. Ownership can be transferred using either\n  `ets:give_away` or the `heir` table option.\n\n  Own Id: OTP-15672\n\n- Fixed a Windows-specific bug in `file:list_dir/1` that caused it to misbehave\n  on network shares.\n\n  Own Id: OTP-15693\n\n- Fixed bug when calling `enif_whereis_*` from NIF resource destructor. Symptoms\n  could be emulator crash or hanging scheduler threads.\n\n  Own Id: OTP-15694 Aux Id: ERL-863\n\n- Fixed a bug in the error case of [`apply/3`](`apply/3`), where the exception\n  would erroneously have an empty argument list in some cases.\n\n  Own Id: OTP-15698\n\n- A bug has been fixed in the `maps` implementation that could cause a crash or\n  memory usage to grow until the machine ran out of memory. This could happen\n  when inserting a new key-value pair with a key `K1` containing a binary `B1`\n  into a map `M` having a key `K2` with a binary `B2` if the following\n  conditions were met:\n\n  - `B1 =/= B2`\n  - `size(B1) >= 4294967296`\n  - `size(B2) >= 4294967296`\n  - `size(M) >= 32`\n  - `(size(B1) rem 4294967296) == (size(B2) rem 4294967296)`\n  - the first `(size(B1) rem 4294967296)` bytes are the same both in `B1` and\n    `B2`\n  - substituting `B1` in `K1` with `B2` would create a term with the same value\n    as `K2`\n\n  The root cause of the problem is that the `maps` implementation only hashed\n  the first `(X rem 4294967296)` bytes of binaries so that different binaries\n  could get the same hash value independently of the hash seed.\n\n  Own Id: OTP-15707\n\n- `term_to_binary()` and distributed sends will now throw a `system_limit`\n  exception instead of producing erroneous results when trying to encode a\n  binary larger than 4 GB.\n\n  Own Id: OTP-15708\n\n- The vxworks configure has been updated to respect the environment CFLAGS.\n\n  Own Id: OTP-15773\n\n- Fix configure to not enable PGO (profile guided optimizations) when linking of\n  the PGO binary fails. For instance this happens when there is no gcov lib\n  installed.\n\n  Own Id: OTP-15788\n\n- Fix bug on OpenBSD where sockets using `active, true` or `active, N` could\n  cause the system to live lock. The bug was introduced in erts-10.2 (OTP-21.2).\n\n  Own Id: OTP-15791","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Add support for Erlang Distribution protocol to split the payload of large\n  signals into several fragments. This allows other processes to communicate\n  uninterrupted during the transmission of these signals.\n\n  Own Id: OTP-13397\n\n- A simple socket API is provided through the socket module. This is a low level\n  API that does _not_ replace gen\\_\\[tcp|udp|sctp]. It is intended to\n  _eventually_ replace the inet driver, but not the high level gen-modules\n  (gen_tcp, gen_udp and gen_sctp). It also provides a basic API that facilitates\n  the implementation of other protocols, that is TCP, UDP and SCTP.\n\n  Known issues are; No support for the Windows OS (currently).\n\n  Own Id: OTP-14831\n\n- Added NIF functions\n  [`enif_set_pid_undefined`](erl_nif.md#enif_set_pid_undefined),\n  [`enif_is_pid_undefined`](erl_nif.md#enif_is_pid_undefined) and\n  [`enif_compare_pids`](erl_nif.md#enif_compare_pids).\n\n  Own Id: OTP-15011 Aux Id: PR-2147\n\n- Underutilized memory segments (carriers) can now move between all allocator\n  instances, rather than just between instances of the same type, which greatly\n  reduces memory usage in some scenarios.\n\n  Own Id: OTP-15063\n\n- The emulator will now mark free blocks in pooled carriers with\n  `madvise(2) + MADV_FREE` (or similar), letting the OS reclaim the associated\n  physical memory if necessary.\n\n  Own Id: OTP-15075\n\n- New `ERL_NIF_SELECT_CANCEL` feature added to `enif_select` in order to cancel\n  (or \"deselect\") a read or write event on a previously selected file\n  descriptor.\n\n  Own Id: OTP-15095\n\n- ETS option `write_concurrency` now also affects and improves the scalability\n  of `ordered_set` tables. The implementation is based on a data structure\n  called contention adapting search tree, where the lock granularity adapts to\n  the actual amount of concurrency exploited by the applications in runtime.\n\n  Own Id: OTP-15128\n\n- Build configuration of the `crypto` application has been moved from the `erts`\n  application into the `crypto` application.\n\n  Own Id: OTP-15129\n\n- Anonymous functions that don't capture environment are now created at\n  load-time instead of in run-time.\n\n  Own Id: OTP-15195 Aux Id: PR-1812\n\n- Optimize updates of maps with identical keys and values. E.g. in the example\n  below the original Map will be reused as the return of the update.\n\n  1> Map = #\\{ a => b \\}. #\\{ a => b \\} 2> Map#\\{ a := b \\}.\n\n  Own Id: OTP-15211 Aux Id: PR-1889\n\n- Optimize `binary:match/2` and `binary:matches/2` to use memchr internally.\n\n  Own Id: OTP-15238 Aux Id: PR-1803\n\n- The runtime system used to terminate when a message larger than 2 Gb was\n  passed over the distribution. The send operation will now instead throw a\n  `system_limit` exception.\n\n  Own Id: OTP-15261\n\n- Change the first module called by erts to be named erl_init instead of\n  otp_ring0. systools in sasl have been updated to reflect this change.\n\n  Own Id: OTP-15336 Aux Id: PR-1825\n\n- Minor adjustments made to build system for parallel configure.\n\n  Own Id: OTP-15340 Aux Id: OTP-14625\n\n- Two new NIF interface functions `enif_select_read` and `enif_select_write`.\n  They are similar to existing `enif_select` but allow a custom event message as\n  an argument.\n\n  Own Id: OTP-15349 Aux Id: PR-2084\n\n- The embedded copy of `zlib` has been updated from `1.2.8` to `1.2.11`.\n\n  Note that this copy is only used as a fallback when the target platform\n  doesn't provide any `zlib` development libraries. If your system provides\n  `zlib` then it will be used even if it is older than `1.2.11`.\n\n  Own Id: OTP-15351 Aux Id: ERL-749\n\n- New NIF function `enif_make_monitor_term`.\n\n  Own Id: OTP-15362 Aux Id: PR-2127\n\n- Appending lists (The ++ operator) will now yield properly on large inputs.\n\n  Own Id: OTP-15427\n\n- The [`length/1`](`length/1`) BIF used to calculate the length of the list in\n  one go without yielding, even if the list was very long. In OTP 22,\n  [`length/1`](`length/1`) will yield when called with long lists.\n\n  Own Id: OTP-15439\n\n- Processes sending messages are now punished with a reduction cost based on\n  message size. That is, a process sending a large message will yield earlier\n  than before.\n\n  Own Id: OTP-15513 Aux Id: ERL-773\n\n- The transitory emulator option `+ztma true` (introduced in OTP 21.3) has been\n  removed.\n\n  Own Id: OTP-15581 Aux Id: OTP-15580\n\n- In OTP 22, HiPE (the native code compiler) is not fully functional. The\n  reasons for this are:\n\n  There are new BEAM instructions for binary matching that the HiPE native code\n  compiler does not support.\n\n  The new optimizations in the Erlang compiler create new combination of\n  instructions that HiPE currently does not handle correctly.\n\n  If erlc is invoked with the `+native` option, and if any of the new binary\n  matching instructions are used, the compiler will issue a warning and produce\n  a BEAM file without native code.\n\n  Own Id: OTP-15596\n\n- The termination behaviour of processes has changed to allow processes to yield\n  while sending link exit/monitor down signals.\n\n  The erl crash dump has been expanded to now also include processes that are\n  termeinating but have not yet terminated.\n\n  Own Id: OTP-15610\n\n- The dist messages EXIT, EXIT2 and MONITOR_DOWN have been updated with new\n  versions that send the reason term as part of the payload of the message\n  instead of as part of the control message.\n\n  The old versions are still present and can be used when communicating with\n  nodes that don't support the new versions.\n\n  Own Id: OTP-15611\n\n- When sending messages, exit, exit2 and monitor down distributed signals, the\n  process sending will now yield appropriately.\n\n  This means that a terminating process will yield and possibly be suspended on\n  busy distribution entries while they are terminating. This means that any\n  memory held by such processes will not be released until after all\n  exit/monitor down signals have been sent.\n\n  Own Id: OTP-15612\n\n- All external pids/ports/refs created by erlang:list_to_pid/port/ref debug\n  functions now compare equal to any other pid/port/ref with the same number\n  from that node.\n\n  Before this change they compared differently because the node creation of the\n  pid/port/ref did not compare equal to any real pid/port/ref creation.\n\n  This will mostly effect pids/ports/refs typed in the shell.\n\n  Own Id: OTP-15613\n\n- The `persistent_term` functions [`put/2`](`put/2`) and [`erase/1`](`erase/1`)\n  are now yielding.\n\n  Own Id: OTP-15615\n\n- A new\n  [`erlang:dist_ctrl_set_opt(DHandle, get_size, Value)`](`erlang:dist_ctrl_set_opt/3`)\n  option has been added. This option makes it possible to configure the\n  distribution channel identified by `DHandle` so that\n  [`erlang:dist_ctrl_get_data(DHandle)`](`erlang:dist_ctrl_get_data/1`) also\n  returns the size of the data to pass over the channel.\n\n  Own Id: OTP-15617\n\n- Previously, all ETS tables used centralized counter variables to keep track of\n  the number of items stored and the amount of memory consumed. These counters\n  can cause scalability problems (especially on big NUMA systems). This change\n  adds an implementation of a decentralized counter and modifies the\n  implementation of ETS so that ETS tables of type `ordered_set` with\n  `write_concurrency` enabled use the decentralized counter. Experiments\n  indicate that this change substantially improves the scalability of ETS\n  `ordered_set` tables with `write_concurrency` enabled in scenarios with\n  frequent `ets:insert/2` and `ets:delete/2` calls.\n\n  Own Id: OTP-15623 Aux Id: PR-2190\n\n- The [`iolist_size/1`](`iolist_size/1`) function is now yielding which means\n  that an Erlang/OTP system will be responsive even if the applications running\n  on the system frequently call [`iolist_size/1`](`iolist_size/1`) with large\n  iolists.\n\n  Own Id: OTP-15631\n\n- A simple test suite for the net module has been added.\n\n  Own Id: OTP-15635\n\n- Added the NIF function `enif_term_type`, which helps avoid long sequences of\n  `enif_is_xyz` by returning the type of the given term. This is especially\n  helpful for NIFs that serialize terms, such as JSON encoders, where it can\n  improve both performance and readability.\n\n  Own Id: OTP-15640\n\n- The last call optimization is now applied to BIFs. When calling a BIF in the\n  tail position of a function, the return address and stack frame will now be\n  discarded before calling the BIF. As a consequence of this change, the\n  immediate caller of a tail-called BIF will no longer be available in stack\n  backtraces.\n\n  Own Id: OTP-15674 Aux Id: PR-2177\n\n- Fix GC bug where distributed messages in a processes mailbox would cause extra\n  GCs. This can be very expensive if there many messages in the mailbox.\n\n  Own Id: OTP-15703\n\n- Internal documentation has now been added to the _Erts_ and _Compiler_\n  applications.\n\n  The internal documents for _Erts_ describe miscellaneous interesting\n  implementation details. Those details can change at any time.\n\n  The internal documentation for _Compiler_ documents the API for the Core\n  Erlang modules. While we will not change those APIs without good reason, we\n  don't give the same guarantees about backward compatibility as for the rest of\n  the APIs in OTP.\n\n  Own Id: OTP-15715\n\n- The performance of non-bignum integer arithmetic has been improved.\n\n  Own Id: OTP-15740\n\n- The `-remsh` option to `erl` now automatically adds the local systems hostname\n  to the target node if no nodename is given. e.g.\n\n  `erl -name foo -remsh bar`  \n  `erl -sname foo -remsh bar`\n\n  Own Id: OTP-15794 Aux Id: PR-2219","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.3.5.19 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-19"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug in match spec compilator seen to cause a stack overflow crash on debug\n  VM for certain match specs. Could potentially cause problems for standard VM,\n  but has not been verified. Match specs are used by `ets:match/select`\n  functions and `erlang:trace_pattern`.\n\n  Own Id: OTP-17379 Aux Id: PR-4804\n\n- A call to `port_command()` could cause a scheduler to end up in an eternal\n  loop if the port was busy and the calling process had incoming signals at the\n  time of the call. This bug was introduced in OTP 23.3.2 (ERTS version 11.2.1),\n  OTP 22.3.4.18 (ERTS version 10.7.2.10), and OTP 21.3.8.23 (ERTS version\n  10.3.5.18).\n\n  Own Id: OTP-17448 Aux Id: GH-4898, PR-4903, OTP-17291","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.18 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The following signals could pass before other signals from the same sender to\n  the same receiver. That is, these signals could arrive too early.\n\n  - `garbage-collect` request. Sent from one process to another using one of the\n    `garbage_collect/0` BIFs.\n  - `check-process-code` request. Sent from one process to another using one of\n    the `check_process_code()` BIFs.\n  - `is-process-alive` reply. Sent as a response to a process calling the\n    `is_process_alive()` BIF.\n  - `process-info` reply. Sent as a response to a process calling one of the\n    `process_info()` BIFs.\n  - `port-command` reply. Sent as a response to a process calling one of the\n    `port_command()` BIFs.\n  - `port-connect` reply. Sent as a response to a process calling the\n    `port_connect()` BIF.\n  - `port-close` reply. Sent as a response to a process calling the\n    `port_close()` BIF.\n  - `port-control` reply. Sent as a response to a process calling the\n    `port_control()` BIF.\n  - `port-call` reply. Sent as a response to a process calling the `port_call()`\n    BIF.\n  - `port-info` reply. Sent as a response to a process calling one of the\n    `port_info()` BIFs.\n\n  Own Id: OTP-17291\n\n- A garbage collection of a literal area missed messages that entirely consisted\n  of a term in a literal area. This could in turn lead to a crash of the runtime\n  system.\n\n  Own Id: OTP-17307\n\n- A call to [`process_flag(message_queue_data, off_heap)`](`process_flag/2`)\n  could cause a crash of the runtime system when sequential tracing was enabled.\n\n  Own Id: OTP-17349","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.17 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in the timer implementation which could cause timers that were set\n  to more than 37.25 hours in the future to be delayed. This could occur if\n  there were multiple timers scheduled to be triggered very close in time, but\n  still at different times, and the scheduler thread handling the timers was not\n  able to handle them quickly enough. Delayed timers were in this case triggered\n  when another unrelated timer was triggered.\n\n  Own Id: OTP-17253","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Fix a file descriptor leak when using sendfile and the remote side closes the\n  connection. This bug has been present since OTP-21.0.\n\n  Own Id: OTP-17244","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.3.5.16 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug that could cause some work scheduled for execution on scheduler\n  threads to be delayed until other similar work appeared. Beside delaying\n  various cleanup of internal data structures also the following could be\n  delayed:\n\n  - Termination of a distribution controller process\n  - Disabling of the distribution on a node\n  - Gathering of memory allocator information using the `instrument` module\n  - Enabling, disabling, and gathering of `msacc` information\n  - Delivery of `'CHANGE'` messages when time offset is monitored\n  - A call to `erlang:cancel_timer()`\n  - A call to `erlang:read_timer()`\n  - A call to `erlang:statistics(io | garbage_collection | scheduler_wall_time)`\n  - A call to `ets:all()`\n  - A call to `erlang:memory()`\n  - A call to `erlang:system_info({allocator | allocator_sizes, _})`\n  - A call to `erlang:trace_delivered()`\n\n  The bug existed on runtime systems running on all types of hardware except for\n  x86/x86_64.\n\n  Own Id: OTP-17185","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.15 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed rare distribution bug in race between received signal\n  (link/monitor/spawn_request/spawn_reply) and disconnection. Symptom: VM crash.\n  Since: OTP 21.0.\n\n  Own Id: OTP-16869 Aux Id: ERL-1337\n\n- The `suspend_process()` and `resume_process()` BIFs did not check their\n  arguments properly which could cause an emulator crash.\n\n  Own Id: OTP-17080\n\n- The runtime system would get into an infinite loop if the runtime system was\n  started with more than 1023 file descriptors already open.\n\n  Own Id: OTP-17088 Aux Id: ERIERL-580","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.14 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The ERTS internal I/O poll implementation could get into an inconsistent state\n  causing input events to be ignored.\n\n  Own Id: OTP-16780 Aux Id: PR-2701\n\n- The documentation of [`statistics(run_queue)`](`statistics/1`) erroneously\n  stated that it returns the total length of all normal run queues when it is\n  the total length of all normal and dirty CPU run queues that is returned. The\n  documentation has been updated to reflect the actual behavior.\n\n  Own Id: OTP-16866 Aux Id: ERL-1355\n\n- Two bugs in the ERTS internal thread wakeup functionality have been fixed.\n  These bugs mainly hit when all threads in the system tried to go to sleep.\n  When the bugs were triggered, certain operations were delayed until a thread\n  woke up due to some other reason. Most important operations effected were code\n  loading, persistent term updates, and memory deallocation.\n\n  Own Id: OTP-16870\n\n- Fixed bug in `ets:select_replace/2` on `compressed` tables that could produce\n  faulty results or VM crash. Bug exists since OTP 20.\n\n  Own Id: OTP-16874 Aux Id: ERL-1356, PR-2763","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.13 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- An unintentional reuse of an already used emulator internal event object could\n  cause a wakeup signal to a thread to be lost. In worst case this could cause\n  the runtime system to hang. This hang was however quite rare.\n\n  Own Id: OTP-16766 Aux Id: ERL-1304\n\n- NIF threads and driver threads on non-Linux systems leaked internal resources\n  when terminating. On Windows these resources were one event per thread. On\n  most other systems one mutex and one condition variable per thread. On these\n  other systems that also lacked `pthread_cond_timedwait()` also a pipe with its\n  file descriptors was leaked.\n\n  Own Id: OTP-16772 Aux Id: ERL-1304","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.12 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The functionality utilized by BIFs for temporary disabling of garbage\n  collection while yielding could cause system task queues to become\n  inconsistent on a process executing such a BIF. Process system tasks are for\n  example utilized when purging code, garbage collecting literal data, and when\n  issuing an ordinary garbage collection from another process.\n\n  The bug does not trigger frequently. Multiple code purges in direct sequence\n  makes it more likely that this bug is triggered. In the cases observed, this\n  has resulted in a hanging code purge operation.\n\n  Own Id: OTP-16639 Aux Id: ERL-1236\n\n- A literal area could prematurely be released before all uses of it had been\n  removed. This occurred either when a terminating process had a complex exit\n  reason referring to a literal that concurrently was removed, or when a\n  terminating process continued executing a dirty NIF accessing a literal (via\n  the heap) that concurrently was removed.\n\n  Own Id: OTP-16640 Aux Id: OTP-16193\n\n- The VM could potentially crash when checking process code of a process that\n  terminated while executing a dirty NIF. The checking of process code is part\n  of a code purge operation.\n\n  Own Id: OTP-16641\n\n- System tasks of `low` priority were not interleaved with `normal` priority\n  system tasks as they should. This could potentially delay garbage collection\n  of another process longer than intended if the garbage collection was\n  requested from a `low` priority process.\n\n  Own Id: OTP-16642","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.11 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [re:run(Subject, RE, \\[unicode])](`re:run/3`) returned `nomatch` instead of\n  failing with a `badarg` error exception when `Subject` contained illegal utf8\n  and `RE` was passed as a binary. This has been corrected along with\n  corrections of reduction counting in `re:run()` error cases.\n\n  Own Id: OTP-16553\n\n- Fixed a bug that could cause the emulator to crash when purging modules or\n  persistent terms.\n\n  Own Id: OTP-16555 Aux Id: ERL-1188","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.10 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in `ets:update_counter/4`, when called with an invalid `UpdateOp`\n  and a `Key` that does not exist, causing `ets:info(T,size)` to return\n  incorrect values. Bug exists since OTP-19.0.2.\n\n  Own Id: OTP-16404 Aux Id: ERL-1127\n\n- A process could get into an inconsistent state where it was runnable, but\n  never scheduled for execution. This could occur when a mix of `normal` and\n  `low` priority processes where scheduled on the same type of dirty scheduler\n  simultaneously.\n\n  Own Id: OTP-16446 Aux Id: ERL-1157\n\n- Corrected the valid range of the `erl` command line argument\n  [`+SDio  `](erl_cmd.md#%2BSDio) from `0..1024` to\n  `1..1024`. `+SDio 0` was erroneously allowed which just caused the VM to crash\n  on the first dirty I/O job scheduled.\n\n  Own Id: OTP-16481","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.9 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process could end up in a state where it got endlessly rescheduled without\n  making any progress. This occurred when a system task, such as check of\n  process code (part of a code purge), was scheduled on a high priority process\n  trying to execute on a dirty scheduler.\n\n  Own Id: OTP-16436 Aux Id: ERL-1152\n\n- Fixed bug in `erlang:list_to_ref/1` when called with a reference created by a\n  remote note. Function [`list_to_ref/1`](`list_to_ref/1`) is intended for\n  debugging and not to be used in application programs. Bug exist since OTP\n  20.0.\n\n  Own Id: OTP-16438","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Taking a scheduler offline could cause timers set while executing on that\n  scheduler to be delayed until the scheduler was put online again. This bug was\n  introduced in ERTS version 10.0 (OTP 21.0).\n\n  Own Id: OTP-16371\n\n- A process calling\n  [`erlang:system_flag(multi_scheduling, block)`](`m:erlang#system_flag_multi_scheduling`)\n  could end up blocked waiting for the operation to complete indefinitely.\n\n  Own Id: OTP-16379","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A literal area could prematurely be released before all uses of it had been\n  removed. This occurred either when a terminating process had a complex exit\n  reason referring to a literal that concurrently was removed, or when a\n  terminating process continued executing a dirty NIF accessing a literal (via\n  the heap) that concurrently was removed.\n\n  Own Id: OTP-16193\n\n- Fix bug causing VM crash due to memory corruption of distribution entry.\n  Probability of crash increases if Erlang distribution is frequently\n  disconnected and reestablished towards same node names. Bug exists since\n  OTP-21.0.\n\n  Own Id: OTP-16224 Aux Id: ERL-1044\n\n- Fix bug where the receive marker used by the runtime to do the receive queue\n  optimization could be incorrectly set. The symptom of this would be that a\n  message that should match in a receive never matches.\n\n  The bug requires the OTP-22 compiler and multiple selective receives to\n  trigger. See OTP-16219 for details about the bug fix in the compiler.\n\n  Own Id: OTP-16241 Aux Id: ERL-1076 OTP-16219\n\n- Fixed bug causing crash of VM built with configuration\n  `--enable--sharing-preserving`. Provoked when a sent message contains both a\n  bit string and the heap binary (< 65 bytes) which the bit string was matched\n  from. Bug exists since OTP-19.0 but has seen to be easier to provoke since\n  OTP-22.1.\n\n  Own Id: OTP-16265 Aux Id: ERL-1064","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix a bug in `binary_to_term` that would crash the emulator if a term larger\n  than 16GB was to be decoded.\n\n  Own Id: OTP-16058 Aux Id: PR-2382\n\n- When communicating with a simultaneously exiting port via the\n  `erlang:port_*()` BIFs one could sometimes get stray `{Ref, What}` messages.\n  Where `Ref` was a reference and `What` usually were the atom `badarg`.\n\n  Own Id: OTP-16107 Aux Id: ERL-1049","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [`process_info(P,binary)`](`process_info/2`) would neglect to look through\n  heap fragments, potentially missing a few binaries associated with the\n  process.\n\n  Own Id: OTP-15978 Aux Id: ERIERL-366\n\n- Fixed bug triggered if a process is killed during call to\n  `persistent_term:put` or `persistent_term:erase`.\n\n  Own Id: OTP-16041","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Fixed rare emulator crash in `instrument:allocations/0-1`.\n\n  Own Id: OTP-15983","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.3.5.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug causing VM crash when doing textual dump of a process containing an\n  unhandled monitor down signal. Textual process dumps can be done with\n  `erlang:system_info(procs)`, trace feature `process_dump`, Erlang shell break\n  menu and a crashdump. Bug exist since OTP 21.0.\n\n  Own Id: OTP-15909 Aux Id: ERL-979\n\n- `lists:subtract/2` would produce incorrect results for some inputs on 64-bit\n  platforms.\n\n  Own Id: OTP-15938 Aux Id: ERL-986\n\n- Fixed a bug in the loader that was similar to `OTP-15938`, yielding incorrect\n  code for some inputs on 64-bit platforms.\n\n  Own Id: OTP-15939\n\n- Fixed bug causing scheduler threads in rare cases to block spinnning\n  indefinitely. Bug exists since OTP 21.0.\n\n  Own Id: OTP-15941 Aux Id: PR-2313","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If you set `{linger,{true,0}}` on a `gen_tcp` listen socket, accept a\n  connection on that socket, and then close the accepted socket, now the linger\n  zero setting is transferred to the accepted socket. Before this correction\n  that information was lost and the close behaviour on the accepted socket\n  incorrect.\n\n  Own Id: OTP-15370 Aux Id: ERIERL-353\n\n- Fixed [`process_info(Pid,reductions)`](`process_info/2`) to not categorically\n  increase reduction count of the measured process `Pid`. Repeated reduction\n  measure of an idle process will most often (but not guaranteed) return the\n  same value, like it behaved before OTP 21.3.8.\n\n  Own Id: OTP-15865 Aux Id: ERL-964\n\n- The runtime system disconnected a connection if it received an\n  [`exit/2`](`exit/2`) signal where the recipient was a process on an old\n  incarnation of the current node. That is, the receiving node had the same node\n  name, but another \"creation\" number. The signal will now just be dropped since\n  the receiving process no longer exists.\n\n  Own Id: OTP-15867 Aux Id: ERIERL-373","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The possibility to send ancillary data, in particular the TOS field, has been\n  added to `gen_udp:send/4,5`.\n\n  Own Id: OTP-15747 Aux Id: ERIERL-294","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.3.5.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- In nested use of `try`/`catch`, rethrowing an exception using `erlang:raise/3`\n  with a different class would not always be able to change the class of the\n  exception.\n\n  Own Id: OTP-15834 Aux Id: ERIERL-367\n\n- Fixed bug in `seq_trace:set_token(label,Term)` which could cause VM crash if\n  `Term` was heap allocated (not an atom, small integer, local pid or port). Bug\n  exists since OTP 21.0 when terms other than small integers were first allowed\n  as labels.\n\n  Own Id: OTP-15849 Aux Id: ERL-700\n\n- Fix `seq_trace:print/2` not to raise `badarg` exception if label is not a\n  small integer. Bug exists since OTP 21.0.\n\n  Own Id: OTP-15859 Aux Id: ERL-700","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a buffer overflow when\n  [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`) and\n  `list_to_existing_atom/2` was used with the `latin1` encoding.\n\n  Own Id: OTP-15819 Aux Id: ERL-944","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed more bugs in [`process_info(reductions)`](`process_info/1`) causing it\n  to sometimes behave non-monotonic. That is, a subsequent call toward the same\n  process could return a lower reduction value.\n\n  Own Id: OTP-15793 Aux Id: ERIERL-337, OTP-15709","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Add missing documentation of new external tags `NEW_PID`, `NEW_PORT` and\n  `NEWER_REFERENCE` introduced in OTP 19.\n\n  These new tags are planned to be \"activated\" in OTP 23 when distribution\n  capability flag `DFLAG_BIG_CREATION` becomes mandatory. Older nodes (>= 19)\n  are able to decode these new tags and send them back to the new node. Nodes\n  older than OTP 23 will however never encode their own local pids, ports and\n  references using the new tags.\n\n  Own Id: OTP-15766","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix `erlang:open_port/2` with the `fd` option to correctly cleanup the pollset\n  when the port is closed. Before this fix there would be error printouts sent\n  to logger when the same fd was reused in a new port.\n\n  Own Id: OTP-15753 Aux Id: ERL-900","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in `seq_trace:reset_trace/0` that could crash the emulator.\n\n  Own Id: OTP-15704\n\n- Fixed bug in [`process_info(reductions)`](`process_info/1`) causing it to\n  sometimes return invalid results.\n\n  Own Id: OTP-15709 Aux Id: ERIERL-337","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- If a suspend/resume signal pair was sent to a process while it was executing\n  dirty, the receiving process could later end up in a suspended state\n  indefinitely. This bug was introduced in ERTS version 10.0 (OTP 21.0).\n\n  Suspend/resume signals are sent from\n  [`erlang:suspend_process()`](`erlang:suspend_process/1`)/[`erlang:resume_process()`](`erlang:resume_process/1`).\n  The `m:dbg` trace tool utilize this functionality and could thus trigger this\n  bug.\n\n  Own Id: OTP-15688\n\n- Fix a possible deadlock when terminating the ERTS caused by a dirty scheduler\n  not releasing it's run-queue lock when terminating.\n\n  Own Id: OTP-15690 Aux Id: PR-2172","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- When multiplying a number by itself, a word beyond the number on the heap\n  could be read (and ignored). This bug was extremely unlikely to actually cause\n  a real problem.\n\n  Own Id: OTP-15484\n\n- Fix bug where doing `seq_trace:reset_trace()` while another process was doing\n  a garbage collection could cause the run-time system to segfault.\n\n  Own Id: OTP-15490\n\n- Fix reading of ancillary data from packet oriented sockets on old Linux kernel\n  versions. Without this fix, getting the data would cause the port to enter an\n  infinite loop.\n\n  Own Id: OTP-15494\n\n- Fix bug where crash dumping or doing `erlang:system_info(procs)` while another\n  process was doing a garbage collection could cause the run-time system to\n  segfault.\n\n  Own Id: OTP-15527\n\n- Fix `erlang:system_info(kernel_poll)` to return correct value. Before this\n  fix, the call always returned `false`.\n\n  Own Id: OTP-15556\n\n- Fix bug in `enif_make_map_from_arrays` that would produce broken maps when\n  number of keys were 32. Bug exists since OTP 21.0.\n\n  Own Id: OTP-15567\n\n- Fix a bug in `binary:encode_unsigned` that may cause a read of uninitialized\n  memory.\n\n  The bug existed since the function was added (OTP R16B02).\n\n  Own Id: OTP-15583 Aux Id: PR-2118\n\n- Fixed a bug that could cause `heart` to kill an exiting node before it had\n  time to flush all buffered writes. If environment variable\n  `HEART_KILL_SIGNAL=SIGABRT` was set a superfluous core dump could also be\n  generated.\n\n  Own Id: OTP-15599 Aux Id: ERIERL-298\n\n- Fix `enif_consume_timeslice` to be a no-op on dirty scheduler and not crash\n  debug compiled emulator.\n\n  Own Id: OTP-15604\n\n- Fixed macro redefinition warnings.\n\n  Own Id: OTP-15629\n\n- `to_erl` fixed to not garble terminal input beyond 7-bit ASCII.\n\n  Own Id: OTP-15650 Aux Id: ERL-854, PR-2161\n\n- Minor fixes for `make clean`.\n\n  Own Id: OTP-15657\n\n- Fixed a bug in all `ets:select*` and `ets:match*` functions that could in some\n  rare cases lead to very poor performance.\n\n  Own Id: OTP-15660 Aux Id: ERL-869","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Add `erlang:system_flag(system_logger, Pid)` and\n  `erlang:system_info(system_logger)`. This system_flag can be used to set the\n  process that will receive the logging messages generated by ERTS.\n\n  Own Id: OTP-15375\n\n- [`integer_to_list/2`](`integer_to_list/2`) and\n  [`integer_to_binary/2`](`integer_to_binary/2`) are now implemented in C,\n  improving their performance.\n\n  Own Id: OTP-15503 Aux Id: PR-2052\n\n- Improved `term_to_binary` to do more fair reduction count and yielding when\n  encoding large byte lists (strings).\n\n  Own Id: OTP-15514 Aux Id: ERL-774\n\n- Made internal port drivers more robust against `erlang:port_control` with\n  invalid arguments and added documentation warnings about such abuse.\n\n  Own Id: OTP-15555 Aux Id: ERIERL-231\n\n- Fix bug on NetBSD where the `exit_status` from a port program would never be\n  sent.\n\n  Own Id: OTP-15558 Aux Id: ERL-725\n\n- There is a new function `persistent:term(Key, Default)` to allow specifying a\n  default when looking up a persistent term.\n\n  Own Id: OTP-15576 Aux Id: ERL-843\n\n- A transitory emulator option '`+ztma true`' has been added to allow running\n  existing BEAM code that relies on \"tuple calls\" (dispatch on parameterized\n  modules) which has been compiled under OTP 20 or earlier. This option will be\n  removed in OTP 22, so such modules should eventually be recompiled with the\n  `+tuple_calls` option.\n\n  Own Id: OTP-15580 Aux Id: PR-2113","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.2.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixes of install/release phase in build system.\n\n  - The source tree was modified when installing/releasing and/or applying a\n    patch.\n  - Some files were installed with wrong access rights.\n  - If applying a patch (using `otp_patch_apply`) as another user (except root)\n    than the user that built the source, the documentation was not properly\n    updated.\n\n  Own Id: OTP-15551\n\n- Setting the `recbuf` size of an inet socket the `buffer` is also automatically\n  increased. Fix a bug where the auto adjustment of inet buffer size would be\n  triggered even if an explicit inet buffer size had already been set.\n\n  Own Id: OTP-15651 Aux Id: ERIERL-304\n\n- Reading from UDP using active `true` or active `N` mode has been optimized\n  when more packets than specified by `read_packets` are available on the\n  socket.\n\n  Own Id: OTP-15652 Aux Id: ERIERL-304","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.2.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- When using the `{linger,{true,T}}` option; `gen_tcp:listen/2` used the full\n  linger time before returning for example `eaddrinuse`. This bug has now been\n  corrected.\n\n  Own Id: OTP-14728 Aux Id: ERIERL-303","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.2.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug where doing a `gen_tcp:send` on a socket with `delay_send` set to true\n  could cause a segfault if the other side closes the connection.\n\n  Bug was introduced in erts-10.2 (OTP-21.2).\n\n  Own Id: OTP-15536 Aux Id: ERL-827\n\n- Fix a race condition when a port program closes that could result in the next\n  started port to hang during startup.\n\n  When this fault happens the following error is normally (but not always)\n  logged:\n\n  `=ERROR REPORT==== 14-Jan-2019::10:45:52.868246 ===`  \n  `Bad input fd in erts_poll()! fd=11, port=#Port<0.505>, driver=spawn, name=/bin/sh -s unix:cmd`\n\n  Bug was introduced in erts-10.0 (OTP-21.0).\n\n  Own Id: OTP-15537\n\n- Fix a bug where polling for external events could be delayed for a very long\n  time if all active schedulers were 100% loaded.\n\n  Bug was introduced in erts-10.2 (OTP-21.2).\n\n  Own Id: OTP-15538 Aux Id: ERIERL-229","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a crash when dangling files were closed after `init:restart/0`.\n\n  Own Id: OTP-15495 Aux Id: ERL-821\n\n- A bug that could cause dirty schedulers to become unresponsive has been fixed.\n\n  Own Id: OTP-15509 Aux Id: PR-2027, PR-2093","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug on big endian architectures when changing file permissions or\n  ownership with `file:change_mode`, `change_owner`, `change_group` or\n  `write_file_info`. Bug exists since OTP-21.0.\n\n  Own Id: OTP-15485\n\n- Fixed bug in `atomics` with option `{signed,false}` when returned values are\n  `(1 bsl 63)` or larger. Could cause heap corruption leading to VM crash or\n  other unpleasant symptoms. Bug exists since OTP-21.2 when module `atomics` was\n  introduced.\n\n  Own Id: OTP-15486 Aux Id: PR-2061\n\n- Fixed bug in operator `band` of two negative operands causing erroneous result\n  if the absolute value of one of the operands have the lowest `N*W` bits as\n  zero and the other absolute value is not larger than `N*W` bits. `N` is an\n  integer of 1 or larger and `W` is 32 or 64 depending on word size.\n\n  Own Id: OTP-15487 Aux Id: ERL-804","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- When a process was waiting for a TCP socket send operation to complete, and\n  another process closed the socket during that send, the sending process could\n  hang. This bug has now been corrected.\n\n  Own Id: OTP-12242 Aux Id: ERL-561\n\n- Document `bit_size` in match specifications and allow it in `ets:fun2ms`.\n\n  Own Id: OTP-15343 Aux Id: PR-1962\n\n- Fixed bug in `ets:select_replace` when called with a fully bound key could\n  cause a following call to `ets:next` or `ets:prev` to crash the emulator or\n  return invalid result.\n\n  Own Id: OTP-15346\n\n- When a module has been purged from memory, any literals belonging to that\n  module will be copied to all processes that hold references to them. The max\n  heap size limit would be ignored in the garbage collection initiated when\n  copying literals to a process. If the max heap size was exceeded, the process\n  would typically be terminated in the following garbage collection. Corrected\n  to terminate the process directly if copying a literal would exceed the max\n  heap size.\n\n  Own Id: OTP-15360\n\n- Fix compilation of run_erl on Solaris 11.4 and later.\n\n  Own Id: OTP-15389\n\n- Fixed a bug where `lists:reverse/1-2` could use far too many reductions. This\n  bug was introduced in `OTP 21.1`.\n\n  Own Id: OTP-15436\n\n- Fixed a bug where a dirty scheduler could stay awake forever if a distribution\n  entry was removed as part of a dirty GC.\n\n  Own Id: OTP-15446 Aux Id: PR-2024\n\n- Fix microstate accounting handing in various places. Most importantly the GC\n  states when the GC is run on a dirty scheduler are now managed correctly.\n\n  Own Id: OTP-15450 Aux Id: ERIERL-229\n\n- Fixed bug in `file:sendfile` when the send operation failed. For sockets in\n  `active` modes it could cause emulator crash or a hanging call. For sockets\n  with `{active,false}` an unexpected `{inet_reply, _, _}` message could be sent\n  to the calling process. The bug exists since OTP-21.0.\n\n  Own Id: OTP-15461 Aux Id: ERL-784\n\n- The erts configure script has been updated to reject any CFLAGS that does not\n  have `-O`. This in order to prevent the common mistake of forgetting to add\n  `-O2` to custom CFLAGS.\n\n  Own Id: OTP-15465\n\n- Fix reduction count in lists:member/2\n\n  Own Id: OTP-15474 Aux Id: ERIERL-229","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- New `counters` and `atomics` modules supplies access to highly efficient\n  operations on mutable fixed word sized variables.\n\n  Own Id: OTP-13468\n\n- There is a new module `persistent_term` that implements a term storage\n  suitable for terms that are frequently used but never or infrequently updated.\n  Lookups are done in constant time without copying the terms.\n\n  Own Id: OTP-14669 Aux Id: PR-1989\n\n- A function `inet:getifaddrs/1` that takes a list with a namespace option has\n  been added, for platforms that support that feature, for example Linux\n  (only?).\n\n  Own Id: OTP-15121 Aux Id: ERIERL-189, PR-1974\n\n- Added the `nopush` option for TCP sockets, which corresponds to `TCP_NOPUSH`\n  on \\*BSD and `TCP_CORK` on Linux.\n\n  This is also used internally in `file:sendfile` to reduce latency on\n  subsequent send operations.\n\n  Own Id: OTP-15357 Aux Id: ERL-698\n\n- List subtraction (The `--` operator) will now yield properly on large inputs.\n\n  Own Id: OTP-15371\n\n- Optimize handling of send_delay for tcp sockes to better work with the new\n  pollthread implementation introduced in OTP-21.\n\n  Own Id: OTP-15471 Aux Id: ERIERL-229\n\n- Optimize driver_set_timer with a zero timeout to short-circuit and not create\n  any timer structure, but instead schedule the timer immediately.\n\n  Own Id: OTP-15472 Aux Id: ERIERL-229\n\n- Add `erl_xcomp_code_model_small` as a cross configure variable in order to let\n  the emulator be build with the assumption that a small code model will be used\n  on the target machine.\n\n  Own Id: OTP-15473 Aux Id: ERIERL-229\n\n- Add a new pollset that is made to handle sockets that use `{active, true}` or\n  `{active, N}`. The new pollset will not be polled by a pollthread, but instead\n  polled by a normal scheduler.\n\n  This change was made because of the overhead associated with constantly having\n  to re-apply the ONESHOT mechanism on fds that all input events were\n  interesting.\n\n  The new pollset is only active on platforms that support concurrent kernel\n  poll updates, i.e. Linux and BSD.\n\n  Own Id: OTP-15475 Aux Id: ERIERL-229\n\n- Fix bug where emulator would segfault if a literal message was sent when\n  sequence tracing was enabled.\n\n  Own Id: OTP-15478 Aux Id: ERL-741","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-1-3"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Added an optional `./configure` flag to compile the emulator with spectre\n  mitigation: `--with-spectre-mitigation`\n\n  Note that this requires a recent version of GCC with support for spectre\n  mitigation and the `--mindirect-branch=thunk` flag, such as `8.1`.\n\n  Own Id: OTP-15430 Aux Id: ERIERL-237","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a rare bug where files could be closed on a normal instead of an IO\n  scheduler, resulting in system instability if the operation blocked.\n\n  Own Id: OTP-15421","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A bug where the socket option 'pktoptions' caused a read of uninitialized\n  memory has been fixed. Would cause malfunction on FreeBSD.\n\n  Own Id: OTP-14297 Aux Id: OTP-15141\n\n- Fixed a memory leak on errors when reading files.\n\n  Own Id: OTP-15318\n\n- File access through UNC paths works again on Windows. This regression was\n  introduced in OTP 21.\n\n  Own Id: OTP-15333 Aux Id: ERL-737","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix the seq_trace token to not be cleared when a process receives messages\n  sent by erts. Some examples of when this could happen is all port BIFs, i.e.\n  `open_port`, `port_command` etc etc.\n\n  Fix so that messages sent by nifs can be traced using normal and `seq_trace`\n  tracing.\n\n  Own Id: OTP-15038 Aux Id: ERL-602\n\n- Fixed specs and documentation for `process_info` item `monitored_by` to\n  include port identifiers and nif resources as possible types.\n\n  Own Id: OTP-15180 Aux Id: ERL-648\n\n- Fix bug in generation of erl_crash.dump, which could cause VM to crash.\n\n  Bug exist since erts-9.2 (OTP-20.2).\n\n  Own Id: OTP-15181\n\n- Fix bug where ctrl-break or ctrl-c would not trigger the break mode properly\n  on Windows. This bug was introduced in erts-10.0 (OTP-21).\n\n  Own Id: OTP-15205\n\n- Fix a performance bug for reception of UDP packages, where a memory buffer\n  would be reallocated when it should not have been.\n\n  Introduce a limit on the maximum automatic increase of the UDP user-space\n  buffer to the theoretical max of the network PATH, i.e. 65535.\n\n  Own Id: OTP-15206\n\n- Fix alignment of erts allocator state internally in erts. With the improper\n  alignment the emulator would refuse to start when compiled with clang on\n  32-bit systems.\n\n  Own Id: OTP-15208 Aux Id: PR-1897 ERL-677\n\n- Fix bug where too many concurrent calls to\n  `erlang:open_port({spawn,\"cmd\"},...)` would result in the emulator terminating\n  with the reason \"Failed to write to erl_child_setup: \". After this fix the\n  `open_port` call will throw an `emfile` exception instead.\n\n  Own Id: OTP-15210\n\n- Upgraded the ERTS internal PCRE library from version 8.41 to version 8.42. See\n  [http://pcre.org/original/changelog.txt](http://pcre.org/original/changelog.txt)\n  for information about changes made to PCRE. This library implements major\n  parts of the `m:re` regular expressions module.\n\n  Own Id: OTP-15217\n\n- Fix `open_port({fd,X,Y}, ...)` to release the file descriptors from the\n  pollset when closing the port. Without this fix the same file descriptor\n  number could not be reused when doing multiple open_port and port_close\n  sequences.\n\n  Own Id: OTP-15236 Aux Id: ERL-692\n\n- Fixed bug in [`float_to_list/2`](`float_to_list/2`) and\n  [`float_to_binary/2`](`float_to_binary/2`) with options\n  `[{decimals,0},compact]` causing totally wrong results. Bug exists since\n  OTP-21.0.\n\n  Own Id: OTP-15276 Aux Id: PR-1920\n\n- Fixed bug in `erlang:memory` causing `ets` to report too much. This small\n  false memory leak (16 bytes each time) can only happen when a specific race\n  condition occurs between scheduler threads on a table with option\n  `write_concurrency`.\n\n  Own Id: OTP-15278\n\n- Minor `configure` test fixes\n\n  Own Id: OTP-15282\n\n- Improved robustness of distribution connection setup. In OTP-21.0 a truly\n  asynchronous connection setup was introduced. This is further improvement on\n  that work to make the emulator more robust and also be able to recover in\n  cases when involved Erlang processes misbehave.\n\n  Own Id: OTP-15297 Aux Id: OTP-15279, OTP-15280","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The socket options `recvtos`, `recvttl`, `recvtclass` and `pktoptions` have\n  been implemented in the socket modules. See the documentation for the\n  `gen_tcp`, `gen_udp` and `inet` modules. Note that support for these in the\n  runtime system is platform dependent. Especially for `pktoptions` which is\n  very Linux specific and obsoleted by the RFCs that defined it.\n\n  Own Id: OTP-15145 Aux Id: ERIERL-187","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 10.0.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- As of ERTS version 10.0 (OTP 21.0) the `erl_child_setup` program, which\n  creates port programs, ignores `TERM` signals. This setting was\n  unintentionally inherited by port programs. Handling of `TERM` signals in port\n  programs has now been restored to the default behavior. That is, terminate the\n  process.\n\n  Own Id: OTP-15289 Aux Id: ERIERL-235, OTP-14943, ERL-576\n\n- The fix made for OTP-15279 in erts-10.07 (OTP-21.0.8) was not complete. It\n  could cause a new connection attempt to be incorrectly aborted in certain\n  cases. This fix will amend that flaw.\n\n  Own Id: OTP-15296 Aux Id: OTP-15279, ERIERL-226","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process could get stuck in an infinite rescheduling loop between normal and\n  dirty schedulers. This bug was introduced in ERTS version 10.0.\n\n  Thanks to Maxim Fedorov for finding and fixing this issue.\n\n  Own Id: OTP-15275 Aux Id: PR-1943\n\n- Garbage collection of a distribution entry could cause an emulator crash if\n  `net_kernel` had not brought previous connection attempts on it down properly.\n\n  Own Id: OTP-15279 Aux Id: ERIERL-226","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A race between termination of a process and resume of the same process via\n  `erlang:resume_process/1` could cause the VM to crash. This bug was introduced\n  in erts version 10.0 (OTP 21.0).\n\n  Own Id: OTP-15237\n\n- When tracing on `running`, `in` trace events could be lost when a process was\n  rescheduled between a dirty and a normal scheduler.\n\n  Own Id: OTP-15269 Aux Id: ERL-713","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug which caused an emulator crash when `enif_send()` was called by a\n  NIF that executed on a dirty scheduler. The bug was either triggered when the\n  NIF called `enif_send()` without a message environment, or when the process\n  executing the NIF was `send` traced.\n\n  Own Id: OTP-15223\n\n- Fixed a bug causing some Erlang references to be inconsistently ordered. This\n  could for example cause failure to look up certain elements with references as\n  keys in search data structures. This bug was introduced in R13B02.\n\n  Thanks to Simon Cornish for finding the bug and supplying a fix.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15225","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug that prevented the `noshell` option from working correctly on Mac\n  OS X and BSD.\n\n  Own Id: OTP-15169\n\n- Fixed a crash when matching directly against a literal map using a single key\n  that had been saved on the stack.\n\n  Own Id: OTP-15184\n\n- Fix node crash when passing a bad time option to `file:read_file_info/2`.\n\n  Own Id: OTP-15196","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a scheduler bug that caused normal schedulers to run dirty code.\n\n  Own Id: OTP-15154\n\n- Fixed a bug in `erlang:trace_info/2` which caused the emulator to crash when a\n  bad argument was passed. The bug was introduced in ERTS version 10.0.\n\n  Own Id: OTP-15183 Aux Id: ERL-670","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a rare bug that could cause processes to be scheduled after they had\n  been freed.\n\n  Own Id: OTP-15067 Aux Id: ERL-573\n\n- Fixed a race condition in the inet driver that could cause receive to hang\n  when the emulator was compiled with gcc 8.\n\n  Own Id: OTP-15158 Aux Id: ERL-654","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The keys used in `os:getenv` and `os:putenv` are case-insensitive again on\n  Windows.\n\n  Own Id: OTP-15147 Aux Id: ERL-644","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 10.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-10-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The type specifications for [`file:posix/0`](`t:file:posix/0`) and\n  [`inet:posix/0`](`t:inet:posix/0`) have been updated according to which errors\n  file and socket operations should be able to return.\n\n  Own Id: OTP-14019 Aux Id: ERL-550\n\n- Fix error printout from run_erl and a bug that could cause unintended fds to\n  be leaked into the started program.\n\n  Own Id: OTP-14537 Aux Id: PR1529\n\n- File operations used to accept [filenames](`t:file:name_all/0`) containing\n  null characters (integer value zero). This caused the name to be truncated and\n  in some cases arguments to primitive operations to be mixed up. Filenames\n  containing null characters inside the filename are now _rejected_ and will\n  cause primitive file operations to fail.\n\n  Also environment variable operations used to accept\n  [names](`t:os:env_var_name/0`) and [values](`t:os:env_var_value/0`) of\n  environment variables containing null characters (integer value zero). This\n  caused operations to silently produce erroneous results. Environment variable\n  names and values containing null characters inside the name or value are now\n  _rejected_ and will cause environment variable operations to fail.\n\n  Primitive environment variable operations also used to accept the `$=`\n  character in environment variable names causing various problems. `$=`\n  characters in environment variable names are now also _rejected_.\n\n  Also `os:cmd/1` now reject null characters inside its\n  [command](`t:os:os_command/0`).\n\n  `erlang:open_port/2` will also reject null characters inside the port name\n  from now on.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14543 Aux Id: ERL-370\n\n- Fix bugs related to the bookkeeping of microstate accounting states.\n\n  Own Id: OTP-14652\n\n- `os:putenv` and `os:getenv` no longer access the process environment directly\n  and instead work on a thread-safe emulation. The only observable difference is\n  that it's _not_ kept in sync with libc `getenv(3)` / `putenv(3)`, so those who\n  relied on that behavior in drivers or NIFs will need to add manual\n  synchronization.\n\n  On Windows this means that you can no longer resolve DLL dependencies by\n  modifying the `PATH` just before loading the driver/NIF. To make this less of\n  a problem, the emulator now adds the target DLL's folder to the DLL search\n  path.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14666\n\n- Corrected `erlang:is_builtin(erlang, M, F)` to return `true` for\n  [`apply/2`](`apply/2`) and `yield/0`.\n\n  Own Id: OTP-14713 Aux Id: ERL-500\n\n- Fixed a bug where the PATH environment variable wasn't updated correctly on a\n  release downgrade, effectively keeping the PATH of the new release.\n\n  Own Id: OTP-14719\n\n- A receive optimization that avoids scanning the entire message queue when\n  receiving a message containing a freshly created reference could in rare\n  circumstances (involving recursive calls to the functions that does the\n  receive) cause the receive to hang. This has been corrected.\n\n  Own Id: OTP-14782 Aux Id: ERL-511\n\n- Fix building of Erlang/OTP on platforms which have small data area with short\n  addressing. For example the PowerPC/RTEMS platform.\n\n  Own Id: OTP-14909 Aux Id: PR-1692\n\n- Fixed a crash when `enif_make_binary` is called with a binary produced by\n  `enif_inspect_binary` in a different environment.\n\n  Own Id: OTP-14931\n\n- Fixed a crash when `enif_make_binary` is called more than once with a binary\n  that had previously been added to an `enif_ioq`.\n\n  Own Id: OTP-14932\n\n- The erl_child_setup program now ignores SIGTERM signals.\n\n  Own Id: OTP-14943 Aux Id: ERL-576\n\n- Force 64-bit alignment on pre-allocators on architectures which needs it.\n\n  Own Id: OTP-14977\n\n- Fixed a bug where dirty scheduler picked up non-dirty work.\n\n  Own Id: OTP-14978\n\n- Calls to `gen_tcp:send/2` on closed sockets now returns `{error, closed}`\n  instead of `{error,enotconn}`.\n\n  Own Id: OTP-15001\n\n- `erlang:monotonic_time/1` failed with `badarg` when passing the `perf_counter`\n  time unit as argument.\n\n  Own Id: OTP-15008\n\n- Fix bug where rapid `init:restart()` calls would sometimes crash because a\n  code load request leaked in between the restarts.\n\n  Own Id: OTP-15013\n\n- Improve [`float_to_list(F, [{decimals,D}])`](`float_to_list/2`) to closer\n  conform with `io_lib:format(\"~.*f\", [D,F])`.\n\n  There are however, still cases when `float_to_list` does not produce the exact\n  same result as `io_lib:format`, especially for large values `F` and/or many\n  decimals `D`.\n\n  Own Id: OTP-15015 Aux Id: OTP-14890\n\n- Fixed a deadlock that would occur on certain allocators when a reallocation\n  failed with `+ramv` enabled.\n\n  Own Id: OTP-15024\n\n- Fix bug that made it impossible to use an erl_tracer as the seq_trace trace\n  receiver.\n\n  Own Id: OTP-15029\n\n- Fix bug where a large (> 1 GB) emulator generated error logger message would\n  cause the emulator to crash.\n\n  Own Id: OTP-15032\n\n- The emulator will no longer crash when reading the file information of an\n  ordinary file that has an NTFS reparse point, such as files stored in a\n  OneDrive-mapped folder.\n\n  Own Id: OTP-15062 Aux Id: ERL-615\n\n- Fixed bug in `enif_binary_to_term` which could cause memory corruption for\n  immediate terms (atoms, small integers, pids, ports, empty lists).\n\n  Own Id: OTP-15080\n\n- Fixed bug in `erlang:system_profile/2` that could cause superfluous\n  `{profile,_,active,_,_}` messages for terminating processes.\n\n  Own Id: OTP-15085\n\n- On OSs with per thread CPU time support, change `cpu_timestamp` in\n  `erlang:trace/3` to use it instead of per process CPU time. This makes this\n  option usable on such OSs when running multiple schedulers.\n\n  Own Id: OTP-15090\n\n- Fix segfault in abort_signal_task which could happen if a port terminated\n  while there were outstanding port tasks that were not signals, for example a\n  ready_input/ready_output event.\n\n  Own Id: OTP-15108 Aux Id: ERL-621\n\n- Fixed bug in `ets` that could cause VM crash if process A terminates after\n  fixating a table and process B deletes the table at \"the same time\". The table\n  fixation could be done with `ets:safe_fixtable` or if process A terminates in\n  the middle of a long running `select` or `match` call.\n\n  Own Id: OTP-15109\n\n- Owner and group changes through `file:write_file_info`, `file:change_owner`,\n  and `file:change_group` will no longer report success on permission errors.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15118\n\n- Fix a bug error reporting from escripts on windows where the error message\n  would get garbled.\n\n  Own Id: OTP-15119 Aux Id: PR-1826\n\n- Fix segfault when a process is internally re-scheduled while being traced for\n  in out events. This bug was introduced in erts-8.0 (OTP-19.0).\n\n  Own Id: OTP-15125","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- It is now possible to open device files and FIFOs with `file:open/2`.\n\n  Own Id: OTP-11462\n\n- The `erlang:system_flag(scheduler_wall_time,Bool)` call is now reference\n  counted and will be turned off if the (last) process that started the\n  performance statistics dies. Thus it is no longer possible to start the\n  statistics with\n  `rpc:call(Node, erlang, system_flag, [scheduler_wall_time, true])` since it\n  will be turned off directly afterwards when the rpc process dies.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11694\n\n- A new logging API is added to Erlang/OTP, see the `m:logger` manual page, and\n  section [Logging](`e:kernel:logger_chapter.md`) in the Kernel User's Guide.\n\n  Calls to `error_logger` are automatically redirected to the new API, and\n  legacy error logger event handlers can still be used. It is, however,\n  recommended to use the Logger API directly when writing new code.\n\n  Notice the following potential incompatibilities:\n\n  - Kernel configuration parameters `error_logger` still works, but is overruled\n    if the default handler's output destination is configured with Kernel\n    configuration parameter `logger`.\n\n    In general, parameters for configuring error logger are overwritten by new\n    parameters for configuring Logger.\n\n  - The concept of SASL error logging is deprecated, meaning that by default the\n    SASL application does not affect which log events are logged.\n\n    By default, supervisor reports and crash reports are logged by the default\n    Logger handler started by Kernel, and end up at the same destination\n    (terminal or file) as other standard log event from Erlang/OTP.\n\n    Progress reports are not logged by default, but can be enabled by setting\n    the primary log level to info, for example with the Kernel configuration\n    parameter `logger_level`.\n\n    To obtain backwards compatibility with the SASL error logging functionality\n    from earlier releases, set Kernel configuration parameter\n    `logger_sasl_compatible` to `true`. This prevents the default Logger handler\n    from logging any supervisor-, crash-, or progress reports. Instead, SASL\n    adds a separate Logger handler during application start, which takes care of\n    these log events. The SASL configuration parameters `sasl_error_logger` and\n    `sasl_errlog_type` specify the destination (terminal or file) and severity\n    level to log for these events.\n\n  Since Logger is new in Erlang/OTP 21.0, we do reserve the right to introduce\n  changes to the Logger API and functionality in patches following this release.\n  These changes might or might not be backwards compatible with the initial\n  version.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13295\n\n- `gen_sctp:connect_init/4` or rather connect in `inet_drv.c` for SCTP has been\n  fixed to not check the write file descriptor for writeability after a connect,\n  since for SCTP (SOCK_SEQPACKET) that property does not seem to be any kind of\n  indicator for when a connect has finished. This fixes connects that the OS\n  returned as \"in progress\" that was misinterpreted by `gen_sctp:connect_init`\n  as failed.\n\n  Own Id: OTP-13760 Aux Id: PR-1592\n\n- The file driver has been rewritten as a NIF, decreasing the latency of file\n  operations. Notable incompatibilities are:\n\n  - The `use_threads` option for `file:sendfile/5` no longer has any effect; we\n    either use non-blocking `sendfile(2)` or fall back to `file:read` \\+\n    `gen_tcp:send`.\n  - The file-specific DTrace probes have been removed. The same effect can be\n    achieved with normal tracing together with the `nif__entry`/`nif__return`\n    probes to track scheduling.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14256\n\n- The I/O polling functionality of erts has been re-written to better make use\n  of the OSs polling mechanisms. This change means that erts will now always\n  prefer to use a kernel-polling mechanism if possible. Also all of the I/O\n  polling has been moved to dedicated threads instead of being placed in the\n  scheduler loops.\n\n  As a result of this, the `erl` options `+K` and `+secio` have been removed. It\n  is still possible to disable kernel-poll, but it has to be done at compile\n  time through the configure option `--disable-kernel-poll`.\n\n  The new `erl` options [`+IOt`](erl_cmd.md#%2BIOt) and\n  [`+IOp`](erl_cmd.md#%2BIOp) can be used to change how many IO poll threads and\n  poll sets that erts should use. See their respective documentation for more\n  details.\n\n  Own Id: OTP-14346\n\n- Truly asynchronous auto-connect. Earlier, when `erlang:send` was aimed toward\n  an unconnected node, the function would not return until the connection setup\n  had completed (or failed). Now the function returns directly after the message\n  has been enqueued and the connection setup started.\n\n  The same applies to all distributed operations that may trigger auto-connect,\n  i.e. `'!'`, `send`, `link`, `monitor`, `monitor_node`, [`exit/2`](`exit/2`)\n  and `group_leader`.\n\n  The interface for all these functions are unchanged as they do not return\n  connection failures. The only exception is `erlang:monitor` where a _possible\n  incompatibility_ is introduced: An attempt to monitor a process on a primitive\n  node (such as erl_interface or jinterface), where remote process monitoring is\n  not implemented, will no longer fail with `badarg` exception. Instead a\n  monitor will be created, but it will only supervise the connection to the\n  node.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14370\n\n- Changed the default behaviour of `.erlang` loading: `.erlang` is no longer\n  loaded from the current directory. `c:erlangrc(PathList)` can be used to\n  search and load an `.erlang` file from user specified directories.\n\n  `escript`, `erlc`, `dialyzer` and `typer` no longer load an `.erlang` at all.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14439\n\n- New functionality for implementation of alternative carriers for the Erlang\n  distribution has been introduced. This mainly consists of support for usage of\n  distribution controller processes (previously only ports could be used as\n  distribution controllers). For more information see\n  [ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](alt_dist.md#distribution-module).\n\n  Own Id: OTP-14459\n\n- Add support for the lcc compiler and in extension the Elbrus 2000 platform.\n\n  Own Id: OTP-14492\n\n- Support for \"tuple calls\" have been removed from the run-time system. Tuple\n  calls was an undocumented and unsupported feature which allowed the module\n  argument for an apply operation to be a tuple: `Var = dict:new(), Var:size()`.\n  This \"feature\" frequently caused confusion, especially when such call failed.\n  The stacktrace would point out functions that don't exist in the source code.\n\n  For legacy code that need to use parameterized modules or tuple calls for some\n  other reason, there is a new compiler option called `tuple_calls`. When this\n  option is given, the compiler will generate extra code that emulates the old\n  behavior for calls where the module is a variable.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14497\n\n- Creation of small maps with literal keys has been optimized to be faster and\n  potentially use less memory. The keys are combined into a literal key tuple\n  which is put into the literal pool. The key tuple can be shared between many\n  instances of maps having the same keys.\n\n  Own Id: OTP-14502\n\n- When an exception is thrown, include the arguments of the call in the\n  stacktrace for BIFs `band`, `bor`, `bsl`, `bsr`, `bxor`, `div`, `rem` and the\n  operators `+`, `-`, `*` and `/`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14508\n\n- The non-smp emulators have been removed. This means that the configure options\n  `--disable-threads` and `--enable-plain-emulator` have been removed and\n  configure will now refuse to build Erlang/OTP on platforms without thread\n  support.\n\n  In order to achieve a similar setup as the non-smp emulator, it is possible to\n  start Erlang/OTP with the `+S 1` option.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14518\n\n- Modules that use floating point constants compiled with R15 or earlier will\n  need to be re-compiled before they can be loaded.\n\n  Own Id: OTP-14575\n\n- Implementation of true asynchronous signaling between processes in order to\n  improve scalability. Signals affected include exit, monitor, demonitor,\n  monitor triggered, link, unlink, and group leader.\n\n  Own Id: OTP-14589\n\n- Added a PGO (profile guided optimization) pass to the build step of erts. This\n  can be disabled by passing --disable-pgo to configure.\n\n  Own Id: OTP-14604\n\n- Improved the performance of `binary:split` and `binary:match`.\n\n  Own Id: OTP-14610 Aux Id: PR-1480\n\n- It is not longer possible to disable dirty schedulers when building erlang.\n\n  Own Id: OTP-14613\n\n- Loaded BEAM code in a 64-bit system requires less memory because of better\n  packing of operands for instructions.\n\n  These memory savings were achieved by major improvements to the `beam_makeops`\n  scripts used when building the run time system and BEAM compiler. There is\n  also new for documentation for `beam_makeops` that describes how new BEAM\n  instructions and loader transformations can be implemented. The documentation\n  is found in here in a source directory or git repository:\n  erts/emulator/internal_doc/beam_makeops.md. An online version can be found\n  here:\n  https://github.com/erlang/otp/blob/master/erts/emulator/internal_doc/beam_makeops.md\n\n  Own Id: OTP-14626\n\n- `file:read_file` has been changed to read the content of files that report a\n  size of 0 even when data can be read from them. An example of such a file is\n  `/proc/cpuinfo` on Linux.\n\n  Own Id: OTP-14637 Aux Id: ERL-327 PR-1524\n\n- It is no longer possible to disable the `temp_alloc` allocator. Disabling it\n  caused serious performance degradations and was never what was wanted.\n\n  Own Id: OTP-14651\n\n- The reduction cost of sending messages is now constant. It will no longer\n  scale according to the length of the receiving process' message queue.\n\n  Own Id: OTP-14667\n\n- Improved loading of modules with `-on_load` directive, to no longer block all\n  schedulers when the load operation is completed.\n\n  Own Id: OTP-14680\n\n- On platforms with real-time signals available, SIGRTMIN+1 is now used as the\n  internal scheduler suspend signal instead of SIGUSR2.\n\n  Own Id: OTP-14682\n\n- When the value returned from a '`catch`' expression is ignored, no stacktrace\n  will be built if an exception is caught. That will save time and produce less\n  garbage. There are also some minor optimizations of '`try`/`catch`' both in\n  the compiler and run-time system.\n\n  Own Id: OTP-14683\n\n- The guarantees and non-guarantees of `erlang:get_stacktrace/0` are now\n  documented.\n\n  Own Id: OTP-14687\n\n- There is a new syntax in '`try/catch`' for retrieving the stacktrace without\n  calling '`erlang:get_stacktrace/0`'. See the reference manual for a\n  description of the new syntax. The '`erlang:get_stacktrace/0`' BIF is now\n  deprecated.\n\n  Own Id: OTP-14692\n\n- New 'used' option for [`binary_to_term/2`](`binary_to_term/2`) that will also\n  return number of bytes actually read from the binary. This enables easy access\n  to any extra data in the binary located directly after the returned term.\n\n  Own Id: OTP-14780\n\n- Added more statistics for `erlang:system_info({allocator,A})` in the\n  `mbcs_pool` section.\n\n  Own Id: OTP-14795 Aux Id: ERL-88\n\n- Added `enif_ioq_peek_head` to retrieve Erlang terms from NIF IO queues without\n  having to resort to copying.\n\n  Own Id: OTP-14797\n\n- There is a new option '`makedep_side_effect`' for the compiler and `-MMD` for\n  '`erlc`' that generates dependencies and continues to compile as normal.\n\n  Own Id: OTP-14830\n\n- Added `ets:whereis/1` for retrieving the table identifier of a named table.\n\n  Own Id: OTP-14884\n\n- `seq_trace` labels may now be any erlang term.\n\n  Own Id: OTP-14899\n\n- Optimized the common case of `monitor` followed by `send` to the same local\n  process. The monitor signal is now delayed in order to be piggybacked with the\n  sent message and thereby only get one lock operation on the message queue of\n  the receiver. A delayed monitor signal is flushed if no `send` has been done\n  at the latest when the process is scheduled out.\n\n  Own Id: OTP-14901\n\n- Make hipe compiled code work on x86_64 (amd64) with OS security feature PIE,\n  where executable code can be loaded into a random location. Old behavior, if\n  hipe was enabled, was to disable PIE build options for the VM.\n\n  Own Id: OTP-14903\n\n- The number of driver async threads will now default to 1 as the standard\n  drivers do not use them anymore. Users that changed this value to tweak the\n  file driver should replace `+A` with `+SDio` since it now uses dirty IO\n  schedulers instead of async threads.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14928\n\n- Optimize `==` and `/=` for binaries with different sizes to be constant in\n  time instead of proportional to the size of their common prefix.\n\n  Own Id: OTP-14934 Aux Id: PR-1708\n\n- Refactorings making some internal process flags available for other usage.\n\n  Own Id: OTP-14948\n\n- Removed need for HiPE to allocate native executable memory in low 2GB address\n  space on x86_64. Command line option `+MXscs` is thereby obsolete and ignored.\n\n  Own Id: OTP-14951\n\n- Added `enif_make_map_from_arrays` for creating a populated map, analogous to\n  `enif_make_list_from_array`.\n\n  Own Id: OTP-14954\n\n- Added configuration switches for busy-wait and wake up thresholds for dirty\n  schedulers, and changing these settings for normal schedulers will no longer\n  affect dirty schedulers.\n\n  Refer to the documentation for details. The new switches are\n  [\\+sbwtdcpu](erl_cmd.md#%2Bsbwtdcpu), [\\+sbwtdio](erl_cmd.md#%2Bsbwtdio),\n  [\\+swtdcpu](erl_cmd.md#%2Bswtdcpu), and [\\+swtdio](erl_cmd.md#%2Bswtdio).\n\n  The default busy wait threshold for dirty scheduler threads has also been\n  lowered to `short`.\n\n  Own Id: OTP-14959\n\n- The list of \"taints\" now also includes dynamic loaded drivers in addition to\n  NIF libraries. Statically linked drivers and NIF libraries that are part of\n  erts are not included. The \"taints\" are returned by `system_info(taints)` and\n  printed in the header of `erl_crash.dump` files.\n\n  Own Id: OTP-14960\n\n- Added `instrument:allocations` and `instrument:carriers` for retrieving\n  information about memory utilization and fragmentation.\n\n  The old `instrument` interface has been removed, as have the related options\n  `+Mim` and `+Mis`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14961\n\n- The process suspend functionality used by the `erlang:suspend_process/2` BIF\n  has been reimplemented using the newly introduced true asynchronous signaling\n  between processes. This mainly to reduce memory usage in the process control\n  block of all processes, but also in order to simplify the implementation.\n\n  > #### Warning {: .warning }\n  >\n  > You can easily create deadlocks if processes suspends each other (directly\n  > or in circles). In ERTS versions prior to ERTS version 10.0, the runtime\n  > system prevented such deadlocks, but this prevention has now been removed\n  > due to performance reasons.\n\n  Other ERTS internal functionality that used the previous process suspend\n  functionality have also been reimplemented to use asynchronous signaling\n  instead.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14964 Aux Id: OTP-14589\n\n- Added the `nifs` option to `?MODULE:module_info/1` for listing a module's\n  installed NIF functions.\n\n  Own Id: OTP-14965\n\n- New implementation of `erlang:process_info/[1,2]`.\n\n  In the general case when inspecting another process, the new implementation\n  sends an asynchronous process-info request signal to the other process and\n  waits for the result instead of locking the other process and reading the\n  result directly. In some special cases where no conflicts occur, signal order\n  won't be violated, and the amount of data requested is guaranteed to be small,\n  the inspected process may be inspected directly.\n\n  Appropriate amount of reductions are now also bumped when inspecting a\n  process.\n\n  Own Id: OTP-14966\n\n- Removed process start time from crash dump in order to save memory in process\n  control block.\n\n  Own Id: OTP-14975 Aux Id: PR-1597\n\n- Optimize `erlang:put/2` when updating existing key with a new immediate value\n  (atom, small integer, pid, port).\n\n  Own Id: OTP-14976\n\n- `erlang:process_info/1` has been changed to no longer include `messages` by\n  default. Instead `erlang:process_info/2` should be used.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14986 Aux Id: PR-1745\n\n- New `erlang:system_info(ets_count)` to get total number of ets tables existing\n  at the local node.\n\n  Own Id: OTP-14987\n\n- New NIF functions: `enif_mutex_name`, `enif_cond_name`, `enif_rwlock_name`,\n  `enif_thread_name`, `enif_vfprintf`, `enif_vsnprintf`.\n\n  Own Id: OTP-14994\n\n- When `erlang:system_flag(backtrace_depth, 0)` has been called, all exceptions\n  will now contain the entry for _one_ function (despite the zero). It used to\n  be that a hand-made stack backtrace passed to `erlang:raise/3` would be\n  truncated to an empty list.\n\n  Own Id: OTP-15026\n\n- Fixed bug for named `ets` tables which could cause unexpected results from\n  matchspec iteration functions (`ets:select*` and `ets:match*`) if the table\n  was deleted and recreated with the same name during the iteration. The\n  iteration could incorrectly continue through the recreated table. The expected\n  correct behavior is now for the iteration call to fail with a `badarg`\n  exception if the table is deleted before the iteration has completed.\n\n  Own Id: OTP-15031\n\n- Two new guards BIFs operating on maps have been added:\n  [`map_get/2`](`map_get/2`) and [`is_map_key/2`](`is_map_key/2`). They do the\n  same as `maps:get/2` and `maps:is_key/2`, respectively, except that they are\n  allowed to be used in guards.\n\n  Own Id: OTP-15037 Aux Id: PR-1784, PR-1802\n\n- Release run-queue lock while cleaning up terminated dirty process.\n\n  Own Id: OTP-15081\n\n- The callback module passed as `-epmd_module` to erl has been expanded to be\n  able to do name and port resolving.\n\n  Documentation has also been added in the `m:erl_epmd` reference manual and\n  ERTS User's Guide\n  [How to Implement an Alternative Node Discovery for Erlang Distribution](alt_disco.md).\n\n  Own Id: OTP-15086 Aux Id: PR-1694","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.3.3.15 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process could end up in a state where it got endlessly rescheduled without\n  making any progress. This occurred when a system task, such as check of\n  process code (part of a code purge), was scheduled on a high priority process\n  trying to execute on a dirty scheduler.\n\n  Own Id: OTP-16436 Aux Id: ERL-1152\n\n- Fixed bug in `erlang:list_to_ref/1` when called with a reference created by a\n  remote note. Function [`list_to_ref/1`](`list_to_ref/1`) is intended for\n  debugging and not to be used in application programs. Bug exist since OTP\n  20.0.\n\n  Own Id: OTP-16438\n\n- A process could get into an inconsistent state where it was runnable, but\n  never scheduled for execution. This could occur when a mix of `normal` and\n  `low` priority processes where scheduled on the same type of dirty scheduler\n  simultaneously.\n\n  Own Id: OTP-16446 Aux Id: ERL-1157\n\n- Fixed erroneous mapping of exit reason from `kill` to `killed` on reception of\n  some exit signals due to a broken link. This bug has existed since ERTS\n  version 5.5.2 (OTP R11).\n\n  This bug was also unknowingly fixed in ERTS version 10.0 (OTP 21.0) due to a\n  new ERTS internal implementation of signaling between processes.\n\n  Own Id: OTP-16465 Aux Id: ERL-1165, OTP-6160, OTP-14589\n\n- Corrected the valid range of the `erl` command line argument\n  [`+SDio  `](erl_cmd.md#%2BSDio) from `0..1024` to\n  `1..1024`. `+SDio 0` was erroneously allowed which just caused the VM to crash\n  on the first dirty I/O job scheduled.\n\n  Own Id: OTP-16481","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.14 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process calling\n  [`erlang:system_flag(multi_scheduling, block)`](`m:erlang#system_flag_multi_scheduling`)\n  could end up blocked waiting for the operation to complete indefinitely.\n\n  Own Id: OTP-16379","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.13 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A literal area could prematurely be released before all uses of it had been\n  removed. This occurred either when a terminating process had a complex exit\n  reason referring to a literal that concurrently was removed, or when a\n  terminating process continued executing a dirty NIF accessing a literal (via\n  the heap) that concurrently was removed.\n\n  Own Id: OTP-16193","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.12 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The runtime system disconnected a connection if it received an\n  [`exit/2`](`exit/2`) signal where the recipient was a process on an old\n  incarnation of the current node. That is, the receiving node had the same node\n  name, but another \"creation\" number. The signal will now just be dropped since\n  the receiving process no longer exists.\n\n  Own Id: OTP-15867 Aux Id: ERIERL-373\n\n- Fix a bug in `binary_to_term` that would crash the emulator if a term larger\n  than 16GB was to be decoded.\n\n  Own Id: OTP-16058 Aux Id: PR-2382\n\n- When communicating with a simultaneously exiting port via the\n  `erlang:port_*()` BIFs one could sometimes get stray `{Ref, What}` messages.\n  Where `Ref` was a reference and `What` usually were the atom `badarg`.\n\n  Own Id: OTP-16107 Aux Id: ERL-1049","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.11 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a buffer overflow when\n  [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`) and\n  `list_to_existing_atom/2` was used with the `latin1` encoding.\n\n  Own Id: OTP-15819 Aux Id: ERL-944","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.10 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixes of install/release phase in build system.\n\n  - The source tree was modified when installing/releasing and/or applying a\n    patch.\n  - Some files were installed with wrong access rights.\n  - If applying a patch (using `otp_patch_apply`) as another user (except root)\n    than the user that built the source, the documentation was not properly\n    updated.\n\n  Own Id: OTP-15551\n\n- Minor fixes for `make clean`.\n\n  Own Id: OTP-15657\n\n- Fixed a bug in all `ets:select*` and `ets:match*` functions that could in some\n  rare cases lead to very poor performance.\n\n  Own Id: OTP-15660 Aux Id: ERL-869\n\n- Fix a possible deadlock when terminating the ERTS caused by a dirty scheduler\n  not releasing it's run-queue lock when terminating.\n\n  Own Id: OTP-15690 Aux Id: PR-2172\n\n- Add missing documentation of new external tags `NEW_PID`, `NEW_PORT` and\n  `NEWER_REFERENCE` introduced in OTP 19.\n\n  These new tags are planned to be \"activated\" in OTP 23 when distribution\n  capability flag `DFLAG_BIG_CREATION` becomes mandatory. Older nodes (>= 19)\n  are able to decode these new tags and send them back to the new node. Nodes\n  older than OTP 23 will however never encode their own local pids, ports and\n  references using the new tags.\n\n  Own Id: OTP-15766","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.9 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-9"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Added an optional `./configure` flag to compile the emulator with spectre\n  mitigation: `--with-spectre-mitigation`\n\n  Note that this requires a recent version of GCC with support for spectre\n  mitigation and the `--mindirect-branch=thunk` flag, such as `8.1`.\n\n  Own Id: OTP-15430 Aux Id: ERIERL-237","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.3.3.8 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A bug that could cause dirty schedulers to become unresponsive has been fixed.\n\n  Own Id: OTP-15509 Aux Id: PR-2027, PR-2093","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in operator `band` of two negative operands causing erroneous result\n  if the absolute value of one of the operands have the lowest `N*W` bits as\n  zero and the other absolute value is not larger than `N*W` bits. `N` is an\n  integer of 1 or larger and `W` is 32 or 64 depending on word size.\n\n  Own Id: OTP-15487 Aux Id: ERL-804","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-6"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- List subtraction (The `--` operator) will now yield properly on large inputs.\n\n  Own Id: OTP-15371","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.3.3.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- ERTS internal trees of monitor structures could get into an inconsistent\n  state. This could cause `'DOWN'` messages not to be delivered when they\n  should, as well as delivery of `'DOWN'` messages that should not be delivered.\n\n  This bug was introduced in ERTS version 9.0 (OTP 20.0) and was fixed in ERTS\n  version 10.0 (OTP 21.0) due to a rewrite of the monitor code. That is, this\n  bug only exist in the OTP 20 release.\n\n  Own Id: OTP-15399 Aux Id: ERL-751, ERIERL-262, OTP-14205","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in `ets:select_replace` when called with a fully bound key could\n  cause a following call to `ets:next` or `ets:prev` to crash the emulator or\n  return invalid result.\n\n  Own Id: OTP-15346","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug which caused an emulator crash when `enif_send()` was called by a\n  NIF that executed on a dirty scheduler. The bug was either triggered when the\n  NIF called `enif_send()` without a message environment, or when the process\n  executing the NIF was `send` traced.\n\n  Own Id: OTP-15223\n\n- Fixed a bug causing some Erlang references to be inconsistently ordered. This\n  could for example cause failure to look up certain elements with references as\n  keys in search data structures. This bug was introduced in R13B02.\n\n  Thanks to Simon Cornish for finding the bug and supplying a fix.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15225","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a race condition in the inet driver that could cause receive to hang\n  when the emulator was compiled with gcc 8.\n\n  Own Id: OTP-15158 Aux Id: ERL-654\n\n- Fix bug in generation of erl_crash.dump, which could cause VM to crash.\n\n  Bug exist since erts-9.2 (OTP-20.2).\n\n  Own Id: OTP-15181","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a rare bug that could cause processes to be scheduled after they had\n  been freed.\n\n  Own Id: OTP-15067 Aux Id: ERL-573","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in `ets` that could cause VM crash if process A terminates after\n  fixating a table and process B deletes the table at \"the same time\". The table\n  fixation could be done with `ets:safe_fixtable` or if process A terminates in\n  the middle of a long running `select` or `match` call.\n\n  Own Id: OTP-15109","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in `enif_binary_to_term` which could cause memory corruption for\n  immediate terms (atoms, small integers, pids, ports, empty lists).\n\n  Own Id: OTP-15080\n\n- Fixed bug in `erlang:system_profile/2` that could cause superfluous\n  `{profile,_,active,_,_}` messages for terminating processes.\n\n  Own Id: OTP-15085","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a crash in `heart:get_cmd/0` when the stored command was too long.\n\n  Own Id: OTP-15034","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a `configure` test for `libz` internals that unintentionally caused\n  various native code in OTP to link against `libz`. Under certain circumstances\n  this caused the build of OTP to fail.\n\n  Own Id: OTP-14840 Aux Id: ERL-529\n\n- File names containing unicode codepoints larger than 255 were not correctly\n  encoded in stack traces.\n\n  Own Id: OTP-14847 Aux Id: ERL-544\n\n- Fix HiPE bug for binary constructs like `< >` which could in rare cases\n  cause faulty results or VM crash.\n\n  This fix affects both the `hipe` compiler and `erts` runtime in an\n  _incompatible_ way. Old hipe compiled files need to be recompiled to load and\n  run properly as native.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14850 Aux Id: PR-1664\n\n- Fix [`term_to_binary/2`](`term_to_binary/2`) spec for `minor_version`.\n\n  Own Id: OTP-14876 Aux Id: ERL-548\n\n- Fix bug in erlang:binary_to_integer/2 where invalid characters were not\n  detected for bases larger then 10. e.g.\n  [`binary_to_integer(<<\":\">>, 16)`](`binary_to_integer/2`) would return 3 and\n  not badarg as it should.\n\n  Own Id: OTP-14879\n\n- Fixed bug in [`float_to_list/2`](`float_to_list/2`) and\n  [`float_to_binary/2`](`float_to_binary/2`) with option `decimals` that caused\n  a faulty rounding up of the last decimal digit for about 6% of floats with a\n  fraction part.\n\n  For example, [`float_to_list(0.145, [{decimals,1}])`](`float_to_list/2`)\n  returned `\"0.2\"` instead of `\"0.1\"`.\n\n  Own Id: OTP-14890\n\n- Fix bug causing slow hipe execution in modules loaded early during boot or\n  loaded by `code:atomic_load` or `code:finish_loading`.\n\n  Own Id: OTP-14891\n\n- Fixed a buffer overflow in an internal string formatting function that could\n  be hit if specifying a long floating-point format specifier to `erts_sprintf`\n  or similar.\n\n  Own Id: OTP-14920\n\n- `erlang:iolist_to_iovec/1` and `enif_inspect_iovec` will no longer fail when\n  provided with binaries that have been matched-out on a non-byte boundary.\n\n  Own Id: OTP-14921\n\n- [`iolist_to_binary/1`](`iolist_to_binary/1`) and `erlang:iolist_to_iovec/1`\n  will now badarg if supplied with a bitstring (without a list).\n\n  Own Id: OTP-14926\n\n- Reject loading modules with names containing directory separators ('/' or '\\\\'\n  on Windows).\n\n  Own Id: OTP-14933 Aux Id: ERL-564, PR-1716\n\n- Fix potential dead-lock when the tracer process dies while a the traced\n  process is running on a dirty scheduler.\n\n  Own Id: OTP-14938","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- More crash dump info such as: process binary virtual heap stats, full info for\n  process causing out-of-mem during GC, more port related info, and dirty\n  scheduler info.\n\n  Own Id: OTP-14820","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-2-1"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Improve search algorithm of abandoned memory carriers. Instead of limited\n  linear search, each allocator instance maintain a balanced search tree of all\n  its abandoned carriers for faster and more exhaustive search.\n\n  Own Id: OTP-14915 Aux Id: ERIERL-88\n\n- New erts_alloc command line options `+M_acnl` and `+M_acfml` to limit carrier\n  abandonment.\n\n  Own Id: OTP-14916 Aux Id: ERIERL-88\n\n- New family of `erts_alloc` strategies: Age Order First Fit. Similar to\n  \"address order\", but instead the oldest possible carrier is always chosen for\n  allocation.\n\n  Own Id: OTP-14917 Aux Id: ERIERL-88\n\n- Add possibility to change allocator options at runtime with\n  `system_info(erts_alloc, ...)`. Only option `sbct` (single block carrier\n  threshold) is currently supported via this interface.\n\n  Own Id: OTP-14918 Aux Id: ERIERL-88","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.2.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-2-0-1"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Extra internal consistency checks wrt communication with erl_child_setup\n  process.\n\n  Own Id: OTP-15488 Aux Id: ERIERL-231","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix a bug in tracing where the \\{caller\\} match spec function would be set to\n  undefined incorrectly when used in conjunction with return_to or return_trace\n  on some functions.\n\n  The functions effected are: erlang:put/2, erlang:erase/1,\n  erlang:process_info/1,2, erlang:nif_load/2, erts_internal:garbage_collection/1\n  and erts_internal:check_process_code/1.\n\n  Because of this bug, the analysis done by fprof could become incorrect when\n  the functions above are the tail-call in a function.\n\n  Own Id: OTP-14677\n\n- Fix emulator deadlock that would happen if `trap_exit` was set to true and a\n  process sends an exit signal to itself using\n  [`exit(self(), Reason)`](`exit/2`) while receive tracing was enabled for that\n  process.\n\n  Own Id: OTP-14678 Aux Id: ERL-495\n\n- Writing of crash dumps is significantly faster.\n\n  Maps are now included in crash dumps.\n\n  Constants terms would only be shown in one process, while other processes\n  referencing the same constant term would show a marker for incomplete heap.\n\n  Own Id: OTP-14685 Aux Id: OTP-14611, OTP-14603, OTP-14595\n\n- The fallback home directory for windows has been changed to be the PROFILE\n  directory instead of the WINDOWS directory. The fallback is used when the\n  environment variables HOMEDRIVE and HOMEPATH have not been set.\n\n  Own Id: OTP-14691\n\n- Fix bug for hipe compiled code using `< >` binary construction that\n  could cause faulty result or even VM crash.\n\n  On architectures other than x86_64, code need to be recompiled to benefit from\n  this fix.\n\n  Own Id: OTP-14740\n\n- Fixed bug in `erlang:garbage_collect/2` and `erlang:check_process_code/3`,\n  when called with option `{async,ReqestId}`. Could cause VM crash or heap\n  corruption if `RequestId` was an immediate term (like a pid, atom or small\n  integer). Bug exists since OTP-17.0.\n\n  Own Id: OTP-14752\n\n- ERL*NIF_MINOR_VERSION wasn't bumped with the addition of `enif_ioq*\\*`.\n\n  Own Id: OTP-14779\n\n- Purging of loaded code that contained \"fake literals\" (for example the magic\n  reference obtained from '`ets:new/2`') would crash the runtime system.\n  Corrected.\n\n  Own Id: OTP-14791\n\n- Setting the size of the atom table to a number near 2147483647 (using the\n  '`+t`' option) would cause the emulator to exit with a failure to allocate a\n  huge amount of memory. This has been corrected. Also the usage message for the\n  '`+t`' option has been corrected to show the correct upper limit 2147483647\n  instead of 0.\n\n  Own Id: OTP-14796\n\n- Fixed a bug that prevented registered process names from being resolved in\n  lcnt results.\n\n  Own Id: OTP-14803\n\n- Formatting bugs were fixed in several HiPE debug BIFs.\n\n  Own Id: OTP-14804","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Binaries and some other data in crash dumps are now encoded in base64 (instead\n  of in hex), which will reduce the size of crash dumps.\n\n  A few bugs in the handling of sub binaries in `crashdump_viewer` have been\n  fixed.\n\n  Own Id: OTP-14686\n\n- Micro optimization for send operations of messages to other nodes. The local\n  ack-message, which is otherwise sent back from TPC/IP port driver to sending\n  client process, is now ignored earlier for distributed send operations.\n\n  Own Id: OTP-14689","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.1.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in file closure on Unix; close(2) was retried on EINTR which could\n  cause a different (recently opened) file to be closed as well.\n\n  Own Id: OTP-14775\n\n- A race-condition when tearing down a connection with active node monitors\n  could cause the runtime system to crash.\n\n  This bug was introduced in ERTS version 8.0 (OTP 19.0).\n\n  Own Id: OTP-14781 Aux Id: OTP-13047","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.1.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Microstate accounting sometimes produced incorrect results for dirty\n  schedulers.\n\n  Own Id: OTP-14707\n\n- Fixed a regression in `zlib:gunzip/1` that prevented it from working when the\n  decompressed size was a perfect multiple of 16384. This regression was\n  introduced in 20.1.1\n\n  Own Id: OTP-14730 Aux Id: ERL-507\n\n- Fixed a memory corruption bug in `enif_inspect_iovec`; writable binaries\n  stayed writable after entering the iovec.\n\n  Own Id: OTP-14745\n\n- Fixed a crash in `enif_inspect_iovec` on encountering empty binaries.\n\n  Own Id: OTP-14750\n\n- `zlib:deflateParams/3` will no longer return `buf_error` when called after\n  `zlib:deflate/2` with zlib `1.2.11`.\n\n  Own Id: OTP-14751","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Added zlib:set_controlling_process/2 to move a zstream() between processes.\n\n  Own Id: OTP-14672 Aux Id: ERL-494\n\n- Fix so that schedulers are bound correctly when the first available cpu is not\n  the first detected cpu. e.g. when using \"taskset -c X..Y\" when X is not equal\n  to 0.\n\n  Own Id: OTP-14694","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug that could cause a VM crash when a corrupt message is received on\n  distribution channel from other node.\n\n  Own Id: OTP-14661 Aux Id: ERIERL-80","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The new zlib module returned a data_error when inflating concatenated streams,\n  which was incompatible with the old module's behavior of returning the\n  uncompressed data up to the end of the first stream.\n\n  Own Id: OTP-14648\n\n- zlib:gunzip/1 will no longer stop at the end of the first stream when\n  decompressing concatenated gzip files.\n\n  Own Id: OTP-14649","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Changed `erlang:apply/2` to raise a `badarg` exception if the second argument\n  is not a proper list. Previous behavior was a misleading `undef` exception.\n\n  Own Id: OTP-14490 Aux Id: ERL-432\n\n- On macOS, `crypto` would crash if `observer` had been started before `crypto`.\n  On the beta for macOS 10.13 (High Sierra), `crypto` would crash. Both of those\n  bugs have been fixed.\n\n  Own Id: OTP-14499 Aux Id: ERL-251 ERL-439\n\n- Fixed bug in enif_whereis_pid/port that could cause heap corruption in rare\n  cases.\n\n  Own Id: OTP-14523\n\n- Fix so that trace messages generated when in a dirty nif are flushed correctly\n  when the dirty nif is done executing.\n\n  Own Id: OTP-14538\n\n- Fix escape code handling when using ANSI color codes in the shell.\n\n  Own Id: OTP-14549 Aux Id: PR1536\n\n- Upgraded the ERTS internal PCRE library from version 8.40 to version 8.41. See\n  [http://pcre.org/original/changelog.txt](http://pcre.org/original/changelog.txt)\n  for information about changes made to PCRE. This library implements major\n  parts of the `m:re` regular expressions module.\n\n  Own Id: OTP-14574\n\n- Fixed a bug causing [`statistics(runtime)`](`statistics/1`) to produce\n  negative values and a bug in [`statistics(wall_clock)`](`statistics/1`)\n  causing it to produce values one second too long.\n\n  [`statistics(runtime)`](`statistics/1`) now also use `getrusage()` as source\n  when available preventing the returned value from wrapping as frequent as\n  before.\n\n  Own Id: OTP-14597 Aux Id: ERL-465\n\n- Fixed small memory leak that could occur when sending to a terminating port.\n\n  Own Id: OTP-14609\n\n- Fix bug causing VM crash when a module with `-on_load` directive is loaded\n  while `erlang:trace(on_load, ...)` is enabled.\n\n  Own Id: OTP-14612\n\n- A warning that the compiler may optimize away atoms have been added to the\n  documentation of [`list_to_existing_atom/1`](`list_to_existing_atom/1`) and\n  [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`).\n\n  Own Id: OTP-14614 Aux Id: ERL-453","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Lock counting can now be fully toggled at runtime in the lock counting\n  emulator (`-emu_type lcnt`). Everything is enabled by default to match the old\n  behavior, but specific categories can be toggled at will with minimal runtime\n  overhead when disabled. Refer to the documentation on `lcnt:rt_mask/1` for\n  details.\n\n  Own Id: OTP-13170\n\n- The `zlib` module has been refactored and all its operations will now yield\n  appropriately, allowing them to be used freely in concurrent applications.\n\n  The following functions have been deprecated, but will not produce compiler\n  warnings until OTP 21: `zlib:adler32`, `zlib:crc32`, `zlib:inflateChunk`,\n  `zlib:getBufSize`, `zlib:setBufSize`.\n\n  The behavior of throwing an error when a dictionary is required for\n  decompression has also been deprecated. Refer to the documentation on\n  `inflateSetDictionary/2` for details.\n\n  Own Id: OTP-14185\n\n- `lcnt:collect` and `lcnt:clear` will no longer block all other threads in the\n  runtime system.\n\n  Own Id: OTP-14412\n\n- Add `erlang:iolist_to_iovec/1`, which converts an iolist() to an\n  erlang:iovec(), which suitable for use with `enif_inspect_iovec`.\n\n  Own Id: OTP-14520\n\n- When provided with bad arguments, the `zlib` module will now raise named\n  exceptions instead of just `badarg`. For example, `not_initialized` when using\n  `zlib:inflate/2` with an uninitialized stream.\n\n  Own Id: OTP-14527\n\n- `erlang:halt/2` allows any Unicode string as slogan for the crash dump.\n\n  Own Id: OTP-14553\n\n- Add new nif API functions for managing an I/O Queue. The added functions are:\n\n  - [`enif_ioq_create()`](erl_nif.md#enif_ioq_create)\n  - [`enif_ioq_destroy()`](erl_nif.md#enif_ioq_destroy)\n  - [`enif_ioq_enq_binary()`](erl_nif.md#enif_ioq_enq_binary)\n  - [`enif_ioq_enqv()`](erl_nif.md#enif_ioq_enqv)\n  - [`enif_ioq_deq()`](erl_nif.md#enif_ioq_deq)\n  - [`enif_ioq_peek()`](erl_nif.md#enif_ioq_peek)\n  - [`enif_inspect_iovec()`](erl_nif.md#enif_inspect_iovec)\n  - [`enif_free_iovec()`](erl_nif.md#enif_free_iovec)\n\n  Own Id: OTP-14598","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 9.0.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in `binary_to_term` and `binary_to_atom` that could cause VM crash.\n  Typically happens when the last character of an UTF8 string is in the range\n  128 to 255, but truncated to only one byte. Bug exists in `binary_to_term`\n  since ERTS version 5.10.2 (OTP_R16B01) and `binary_to_atom` since ERTS version\n  9.0 (OTP-20.0).\n\n  Own Id: OTP-14590 Aux Id: ERL-474","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.0.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A timer internal bit-field used for storing scheduler id was too small. As a\n  result, VM internal timer data structures could become inconsistent when using\n  1024 schedulers on the system. Note that systems with less than 1024\n  schedulers are not effected by this bug.\n\n  This bug was introduced in ERTS version 7.0 (OTP 18.0).\n\n  Own Id: OTP-14548 Aux Id: OTP-11997, ERL-468\n\n- Automatic cleanup of a BIF timer, when the owner process terminated, could\n  race with the timeout of the timer. This could cause the VM internal data\n  structures to become inconsistent which very likely caused a VM crash.\n\n  This bug was introduced in ERTS version 9.0 (OTP 20.0).\n\n  Own Id: OTP-14554 Aux Id: OTP-14356, ERL-468","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Binary append operations did not check for overflow, resulting in nonsensical\n  results when huge binaries were appended.\n\n  Own Id: OTP-14524","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Added missing release notes for OTP-14491 (\"performance bug in\n  pre-allocators\") which was included in erts-9.0.1 (OTP-20.0.1).\n\n  Own Id: OTP-14494\n\n- Fixed a bug that prevented TCP sockets from being closed properly on send\n  timeouts.\n\n  Own Id: OTP-14509\n\n- Fixed bug in operator `bxor` causing erroneuos result when one operand is a\n  big _negative_ integer with the lowest `N*W` bits as zero and the other\n  operand not larger than `N*W` bits. `N` is an integer of 1 or larger and `W`\n  is 32 or 64 depending on word size.\n\n  Own Id: OTP-14514","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in gen_tcp:send where it never returned when repeatedly called on\n  a remotely closed TCP socket.\n\n  Own Id: OTP-13939 Aux Id: ERL-193\n\n- Fixed segfault that could happen during cleanup of aborted\n  erlang:port_command/3 calls. A port_command is aborted if the port is closed\n  at the same time as the port_command was issued. This bug was introduced in\n  erts-8.0.\n\n  Own Id: OTP-14481\n\n- Fixed implementation of [`statistics(wall_clock)`](`statistics/1`) and\n  [`statistics(runtime)`](`statistics/1`) so that values do not unnecessarily\n  wrap due to the emulator. Note that the values returned by\n  [`statistics(runtime)`](`statistics/1`) may still wrap due to limitations in\n  the underlying functionality provided by the operating system.\n\n  Own Id: OTP-14484\n\n- Fix performance bug in pre-allocators that could cause them to permanently\n  fall back on normal more expensive memory allocation. Pre-allocators are used\n  for quick allocation of short lived meta data used by messages and other\n  scheduled tasks. Bug exists since OTP_R15B02. \\[this release note was missing\n  in erts-9.0.1]\n\n  Own Id: OTP-14491","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 9.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-9-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix various bugs regarding loading, upgrade and purge of HiPE compiled code:\n\n  - The native code memory for a purged module was never deallocated.\n  - Wrong functions could in some cases be called after a module upgrade.\n  - `erlang:check_process_code` did not check for recursive calls made from\n    native code.\n\n  Own Id: OTP-13968\n\n- Hipe optional LLVM backend does require LLVM version 3.9 or later as older\n  versions forced strong dependencies on erts internals structures.\n\n  Own Id: OTP-14238\n\n- When an exception such as '[`throw(HugeTerm)`](`throw/1`)' was caught,\n  `HugeTerm` term would be kept in the process until the next exception\n  occurred, potentially increasing the heap size for the process. That has been\n  corrected.\n\n  Own Id: OTP-14255 Aux Id: OTP-14400, OTP-14401\n\n- Slogans in crash dumps have been extended to print more complex terms.\n\n  Own Id: OTP-14303\n\n- Fixed bug when using `enif_inspect_binary` in combination with `enif_copy`. In\n  some circumstances the inspected binary could be reallocated by the\n  `enif_copy` call when it shouldn't have been.\n\n  Own Id: OTP-14304\n\n- The address family `local` (AF_UNIX / AF_LOCAL) now does not ensure zero\n  termination of Linux Abstract Addresses so they can use all bytes.\n\n  Own Id: OTP-14305\n\n- Use `-fno-PIE` for Gentoo Hardened and others that don't accept linker flag\n  `-no-pie`.\n\n  Own Id: OTP-14307 Aux Id: PR-1379\n\n- Disable hipe for `ppc64le` architecture (little endian) as it is not, and has\n  never been, supported. It was earlier equated with `ppc64` (big endian) which\n  lead to broken build without `--disable-hipe`.\n\n  Own Id: OTP-14314 Aux Id: ERL-369, PR-1394\n\n- Fix 'epmd -kill' to return a failure exit status code if epmd was not killed\n  because of some error.\n\n  Own Id: OTP-14324\n\n- Fixed the following dirty scheduler related bugs:\n\n  - the `+SDPcpu` command line argument could cause the amount of dirty CPU\n    schedulers to be set to zero\n  - `erlang:system_flag(multi_scheduling, _)` failed when only one normal\n    scheduler was used together with dirty scheduler support\n\n  Own Id: OTP-14335\n\n- Fix erlexec to handle mismatch in sysconf and proc fs when figuring out the\n  cpu topology. This behaviour has been seen when using docker together with\n  `--cpuset-cpus`.\n\n  Own Id: OTP-14352\n\n- Fixed memory segment cache used for multiblock carriers. Huge (> 2GB) memory\n  segments could cause a VM crash. Creation of such huge memory segments used\n  for multiblock carriers is however very uncommon.\n\n  Own Id: OTP-14360 Aux Id: ERL-401, PR-1417\n\n- Fix bug causing `code:is_module_native` to falsely return true when `local`\n  call trace is enabled for the module.\n\n  Own Id: OTP-14390\n\n- Fix emulator crash when receive tracing on a `trace_delivered` message.\n\n  Own Id: OTP-14411\n\n- Fix file:sendfile error handling on SunOS when a connection is closed during\n  transmission.\n\n  Own Id: OTP-14424\n\n- `escript` did not handle paths with spaces correct.\n\n  Own Id: OTP-14433\n\n- Fix erroneous lock check assertion when `wx` is run on MacOS X.\n\n  Own Id: OTP-14437 Aux Id: ERL-360\n\n- Active-mode TCP sockets are now cleaned up properly on send/shutdown errors.\n\n  Own Id: OTP-14441 Aux Id: ERL-430\n\n- Fix compilation of hipe_mkliterals when the LIBS configure variable had to be\n  set.\n\n  Own Id: OTP-14447","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Added `erlang:garbage_collect/2` that takes an option list as the last\n  argument that can be used to control whether a minor or a major garbage\n  collection is to be done. Doing a minor collection only collects terms that\n  have recently died, but is cheaper than a major collection.\n\n  Own Id: OTP-11695\n\n- Optimized test for tuples with an atom as first element.\n\n  Own Id: OTP-12148\n\n- Erlang literals are no longer copied during process to process messaging.\n\n  Own Id: OTP-13529\n\n- Add support in the `erl_nif` API for asynchronous message notifications when\n  sockets or other file descriptors are ready to accept read or write\n  operations. The following functions have been added:\n\n  - enif_select\n  - enif_monitor_process\n  - enif_demonitor_process\n  - enif_compare_monitors\n  - enif_open_resource_type_x\n\n  Own Id: OTP-13684\n\n- There are two new guard BIFs '[`floor/1`](`floor/1`)' and\n  '[`ceil/1`](`ceil/1`)'. They both return integers. In the '`math`' module,\n  there are two new BIFs with the same names that return floating point values.\n\n  Own Id: OTP-13692\n\n- Remove deprecated `erlang:hash/2`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13827\n\n- Replaced usage of deprecated symbolic [`time unit`](`t:erlang:time_unit/0`)\n  representations.\n\n  Own Id: OTP-13831 Aux Id: OTP-13735\n\n- Added support in zlib for extraction of the inflation dictionary.\n\n  Own Id: OTP-13842\n\n- The previously used purge strategy has been removed. The optional purge\n  strategy introduced in ERTS version 8.1 is now the only strategy available.\n\n  The new purge strategy is slightly incompatible with the old strategy.\n  Previously processes holding `fun`s that referred to the module being purged\n  either failed a soft purge, or was killed during a hard purge. The new\n  strategy completely ignores `fun`s. If `fun`s referring to the code being\n  purged exist, and are used after a purge, an exception will be raised upon\n  usage. That is, the behavior will be exactly the same as the case when a `fun`\n  is received by a process after the purge.\n\n  For more information see the documentation of `erlang:check_process_code/3`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13844 Aux Id: OTP-13833\n\n- Dirty schedulers are now enabled by default when the runtime system is built\n  with SMP support.\n\n  Own Id: OTP-13860\n\n- Improved ETS lookup/insert/delete speed for large `set`, `bag` and\n  `duplicate_bag` by a significant reduction of the hash load factor. This speed\n  improvement comes at the expense of less than one word per table entry. Tables\n  with less than 256 entries are not affected at all.\n\n  Own Id: OTP-13903\n\n- The NIF library `reload` feature is not supported anymore. It has been marked\n  as deprecated since OTP R15B. This means that you are only allowed to do one\n  successful call to `erlang:load_nif/2` for each module instance. A second call\n  to `erlang:load_nif/2` will return `{error, {reload, _}}` even if the NIF\n  library implements the `reload` callback.\n\n  Runtime upgrade of a NIF library is still supported by using the Erlang module\n  upgrade mechanics with a current and an old module instance existing at the\n  same time with their corresponding NIF libraries.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13908\n\n- Add `erlang:system_info(atom_count)` and `erlang:system_info(atom_limit)` to\n  provide a way to retrieve the current and maximum number of atoms.\n\n  Own Id: OTP-13976\n\n- The function `fmod/2` has been added to the `math` module.\n\n  Own Id: OTP-14000\n\n- `erlang:load_nif/2` returns new error type `notsup` when called for a HiPE\n  compiled module, which is not supported.\n\n  Own Id: OTP-14002\n\n- Add driver and nif lock instrumentation to lcnt\n\n  Own Id: OTP-14069\n\n- Reduce memory pressure by converting sub-binaries to heap-binaries when\n  possible. This is done during garbage collection.\n\n  Own Id: OTP-14149\n\n- Dirty schedulers are now enabled and supported on Erlang runtime systems with\n  SMP support.\n\n  Besides support for dirty NIFs also support for dirty BIFs and dirty garbage\n  collection have been introduced. All garbage collections that potentially will\n  take a long time to complete are now performed on dirty schedulers if enabled.\n\n  `erlang:statistics/1` with arguments inspecting scheduler and run queue states\n  have been changed due to the dirty scheduler support. Code using this\n  functionality may have to be rewritten taking these incompatibilities into\n  consideration. Examples of such uses are calls to\n  [`erlang:statistics(scheduler_wall_time)`](`m:erlang#statistics_scheduler_wall_time`),\n  [`statistics(total_run_queue_lengths)`](`m:erlang#statistics_total_run_queue_lengths`),\n  [`statistics(total_active_tasks)`](`m:erlang#statistics_total_active_tasks`),\n  etc.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14152\n\n- Atoms may now contain arbitrary Unicode characters.\n\n  Own Id: OTP-14178\n\n- Introduce an event manager in Erlang to handle OS signals. A subset of OS\n  signals may be subscribed to and those are described in the Kernel\n  application.\n\n  Own Id: OTP-14186\n\n- The `escript` program now handles symbolic links to escripts.\n\n  This is useful for standalone systems with `escript`s residing on a bin\n  directory not included in the execution path (as it may cause their `erl`\n  program(s) to override the desired one). Instead the `escript`s can be\n  referred to via symbolic links from a bin directory in the path.\n\n  Own Id: OTP-14201 Aux Id: PR-1293\n\n- All uses of the magic binary kludge has been replaced by uses of erlang\n  references.\n\n  A magic binary was presented as an empty binary, but actually referred other\n  data internally in the Erlang VM. Since they were presented as empty binaries,\n  different magic binaries compared as equal, and also lost their internal data\n  when passed out of an erlang node.\n\n  The new usage of references has not got any of these strange semantic issues,\n  and the usage of these references has been optimized to give the same\n  performance benefits as well as memory usage benefits as magic binaries had.\n\n  A couple of examples of previous uses of magic binaries are match\n  specifications and NIF resources.\n\n  Own Id: OTP-14205\n\n- The non-smp emulators have been deprecated and are scheduled for removal in\n  OTP-21.\n\n  In preparation for this, the threaded non-smp emulator is no longer built by\n  default and has to be enabled using the --enable-plain-emulator to configure.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14272\n\n- Allow HiPE to run on VM built with `--enable-m32-build`.\n\n  Own Id: OTP-14330 Aux Id: PR-1397\n\n- Upgraded the OTP internal PCRE library from version 8.33 to version 8.40. This\n  library is used for implementation of the `m:re` regular expressions module.\n\n  Besides various bug fixes, the new version allows for better stack protection.\n  In order to utilize this feature, the stack size of normal scheduler threads\n  is now by default set to 128 kilo words on all platforms. The stack size of\n  normal scheduler threads can be set upon system start by passing the\n  [`+sss`](erl_cmd.md#sched_thread_stack_size) command line argument to the\n  [`erl`](erl_cmd.md) command.\n\n  See\n  [http://pcre.org/original/changelog.txt](http://pcre.org/original/changelog.txt)\n  for information about changes made to PCRE between the versions 8.33 and 8.40.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14331 Aux Id: ERL-208\n\n- Remove generation of atoms in old latin1 external format in the distribution\n  between erlang nodes, `erl_interface`, and `jinterface`. The new utf8 format\n  for atoms was introduced in OTP R16. An OTP 20 node can therefore not connect\n  to nodes older than R16.\n\n  Atoms that can be encoded using latin1 are still encoded by `term_to_binary()`\n  using latin1 encoding. Note that all atoms will by default be encoded using\n  utf8 in a future Erlang/OTP release. For more information see the\n  documentation of `erlang:term_to_binary/2`.\n\n  Own Id: OTP-14337\n\n- Added function `re:version/0` which returns information about the OTP internal\n  PCRE version used for implementation of the `re` module.\n\n  Own Id: OTP-14347 Aux Id: PR-1412\n\n- Added new debug bif `erlang:list_to_port/1`.\n\n  Own Id: OTP-14348\n\n- Various improvements of timer management internally in the VM. These\n  improvements both reduced memory consumption of timer wheels as well as reduce\n  the amount of work that has to be performed in order to handle timers.\n\n  Own Id: OTP-14356\n\n- Sockets can now be bound to device (SO_BINDTODEVICE) on platforms where it is\n  supported.\n\n  This has been implemented e.g to support VRF-Lite under Linux; see\n  [VRF ](https://www.kernel.org/doc/Documentation/networking/vrf.txt), and\n  GitHub pull request [\\#1326](https://github.com/erlang/otp/pull/1326).\n\n  Own Id: OTP-14357 Aux Id: PR-1326\n\n- Added the following [`erl`](erl_cmd.md) command line arguments with which you\n  can set suggested stack for dirty schedulers:\n\n  - **[`+sssdcpu`](erl_cmd.md#dcpu_sched_thread_stack_size)** - for dirty CPU\n    schedulers\n\n  - **[`+sssdio`](erl_cmd.md#dio_sched_thread_stack_size)** - for dirty IO\n    schedulers\n\n  The default suggested stack size for dirty schedulers is 40 kilo words.\n\n  Own Id: OTP-14380\n\n- Changed erts startup program name, argv 0, to use the environment variable\n  `ESCRIPT_NAME` so that `erlc`, `dialyzer`, `typer`, `ct_run`, or the escript\n  name can be seen with external programs, such as ps and htop (depending on\n  options), on unix.\n\n  Own Id: OTP-14381\n\n- Improvements of `escript` documentation.\n\n  Own Id: OTP-14384 Aux Id: OTP-14201\n\n- Add function `enif_hash` for NIFs to calculate hash values of arbitrary terms.\n\n  Own Id: OTP-14385 Aux Id: PR-1413\n\n- '`./configure --enable-lock-counter`' will enabling building of an additional\n  emulator that has support for lock counting. (The option previously existed,\n  but would turn on lock counting in the default emulator being built.) To start\n  the lock-counting emulator, use '`erl -emu_type lcnt`'.\n\n  On Windows, `erl` recognized the undocumented option `-debug` for starting a\n  debug-compiled emulator. That option has been removed. Use\n  '`erl -emu_type debug`' instead.\n\n  Own Id: OTP-14407\n\n- Warnings have been added to the relevant documentation about not using\n  un-secure distributed nodes in exposed environments.\n\n  Own Id: OTP-14425\n\n- Improvement of the documentation of the environment variable\n  `ERL_CRASH_DUMP_SECONDS` as well as the default behavior when it is not set.\n\n  Own Id: OTP-14434\n\n- Enabled off-heap message queue for some system processes that might receive\n  large amounts of messages.\n\n  Own Id: OTP-14438\n\n- ETS lock indexes have been replaced with the table name in LCNT results.\n\n  Own Id: OTP-14442 Aux Id: ERIERL-22\n\n- Introduced the new functions\n  [`enif_whereis_pid()`](erl_nif.md#enif_whereis_pid) and\n  [`enif_whereis_port()`](erl_nif.md#enif_whereis_port).\n\n  Own Id: OTP-14453 Aux Id: PR-1400","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 8.3.5.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed bug in operator `band` of two negative operands causing erroneous result\n  if the absolute value of one of the operands have the lowest `N*W` bits as\n  zero and the other absolute value is not larger than `N*W` bits. `N` is an\n  integer of 1 or larger and `W` is 32 or 64 depending on word size.\n\n  Own Id: OTP-15487 Aux Id: ERL-804","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Added an optional `./configure` flag to compile the emulator with spectre\n  mitigation: `--with-spectre-mitigation`\n\n  Note that this requires a recent version of GCC with support for spectre\n  mitigation and the `--mindirect-branch=thunk` flag, such as `8.1`.\n\n  Own Id: OTP-15430 Aux Id: ERIERL-237","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 8.3.5.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed small memory leak that could occur when sending to a terminating port.\n\n  Own Id: OTP-14609 Aux Id: ERIERL-238","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.5.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a race condition in the inet driver that could cause receive to hang\n  when the emulator was compiled with gcc 8.\n\n  Own Id: OTP-15158 Aux Id: ERL-654\n\n- Fixed a bug causing some Erlang references to be inconsistently ordered. This\n  could for example cause failure to look up certain elements with references as\n  keys in search data structures. This bug was introduced in R13B02.\n\n  Thanks to Simon Cornish for finding the bug and supplying a fix.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15225","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.5.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in file closure on Unix; close(2) was retried on EINTR which could\n  cause a different (recently opened) file to be closed as well.\n\n  Own Id: OTP-14775\n\n- A race-condition when tearing down a connection with active node monitors\n  could cause the runtime system to crash.\n\n  This bug was introduced in ERTS version 8.0 (OTP 19.0).\n\n  Own Id: OTP-14781 Aux Id: OTP-13047","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.5.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A timer internal bit-field used for storing scheduler id was too small. As a\n  result, VM internal timer data structures could become inconsistent when using\n  1024 schedulers on the system. Note that systems with less than 1024\n  schedulers are not effected by this bug.\n\n  This bug was introduced in ERTS version 7.0 (OTP 18.0).\n\n  Own Id: OTP-14548 Aux Id: OTP-11997, ERL-468\n\n- Fixed bug in `binary_to_term` and `binary_to_atom` that could cause VM crash.\n  Typically happens when the last character of an UTF8 string is in the range\n  128 to 255, but truncated to only one byte. Bug exists in `binary_to_term`\n  since ERTS version 5.10.2 (OTP_R16B01) and `binary_to_atom` since ERTS version\n  9.0 (OTP-20.0).\n\n  Own Id: OTP-14590 Aux Id: ERL-474\n\n- Fix bug causing VM crash when a module with `-on_load` directive is loaded\n  while `erlang:trace(on_load, ...)` is enabled.\n\n  Own Id: OTP-14612\n\n- Fixed bug that could cause a VM crash when a corrupt message is received on\n  distribution channel from other node.\n\n  Own Id: OTP-14661 Aux Id: ERIERL-80","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.5.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix performance bug in pre-allocators that could cause them to permanently\n  fall back on normal more expensive memory allocation. Pre-allocators are used\n  for quick allocation of short lived meta data used by messages and other\n  scheduled tasks. Bug exists since OTP_R15B02.\n\n  Own Id: OTP-14491\n\n- Fixed a bug that prevented TCP sockets from being closed properly on send\n  timeouts.\n\n  Own Id: OTP-14509\n\n- Fixed bug in operator `bxor` causing erroneuos result when one operand is a\n  big _negative_ integer with the lowest `N*W` bits as zero and the other\n  operand not larger than `N*W` bits. `N` is an integer of 1 or larger and `W`\n  is 32 or 64 depending on word size.\n\n  Own Id: OTP-14514","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.5.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug in gen_tcp:send where it never returned when repeatedly called on\n  a remotely closed TCP socket.\n\n  Own Id: OTP-13939 Aux Id: ERL-193\n\n- Fixed segfault that could happen during cleanup of aborted\n  erlang:port_command/3 calls. A port_command is aborted if the port is closed\n  at the same time as the port_command was issued. This bug was introduced in\n  erts-8.0.\n\n  Own Id: OTP-14481\n\n- Fixed implementation of [`statistics(wall_clock)`](`statistics/1`) and\n  [`statistics(runtime)`](`statistics/1`) so that values do not unnecessarily\n  wrap due to the emulator. Note that the values returned by\n  [`statistics(runtime)`](`statistics/1`) may still wrap due to limitations in\n  the underlying functionality provided by the operating system.\n\n  Own Id: OTP-14484","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Active-mode TCP sockets are now cleaned up properly on send/shutdown errors.\n\n  Own Id: OTP-14441 Aux Id: ERL-430\n\n- A code purge operation could under certain circumstances expand the size of\n  hibernated processes.\n\n  Own Id: OTP-14444 Aux Id: ERIERL-24\n\n- Fix so that the ERL_ZZ_SIGTERM_KILL introduced in erts-8.3.4 works.\n\n  Own Id: OTP-14451","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Add option to make SIGTERM trigger the OS default behaviour instead of doing a\n  graceful shutdown. To activate this bahviour the environment variable\n  ERL_ZZ_SIGTERM_KILL should be set to \"true\". This option only works in OTP 19\n  as OTP 20 will have a different way to deal with SIGTERM.\n\n  Own Id: OTP-14418 Aux Id: ERIERL-15","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed memory segment cache used for multiblock carriers. Huge (> 2GB) memory\n  segments could cause a VM crash. Creation of such huge memory segments used\n  for multiblock carriers is however very uncommon.\n\n  Own Id: OTP-14360 Aux Id: ERL-401, PR-1417\n\n- Fix release note for OTP-14290 in ERTS version 8.3.1. It was erroneously\n  placed under \"Known Bugs and Problems\".\n\n  Own Id: OTP-14363 Aux Id: OTP-14290","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The `+Bi` command line argument of `erl` erroneously caused `SIGTERM` to be\n  ignored by the VM as well as of all its child processes. This bug was\n  introduced in erts version 8.3.\n\n  Own Id: OTP-14358 Aux Id: OTP-14085","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Invoking `init:stop/0` via the SIGTERM signal, in a non-SMP BEAM, could cause\n  BEAM to terminate with fatal error. This has now been fixed and the BEAM will\n  terminate normally when SIGTERM is received.\n\n  Own Id: OTP-14290\n\n- Trying to open a directory with file:read_file/1 on Unix leaked a file\n  descriptor. This bug has now been fixed.\n\n  Own Id: OTP-14308 Aux Id: ERL-383","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a number of bugs that caused faulty stack-traces to be generated. The\n  faulty stack traces were generated either when applying the following\n  functions or tracing the following functions:\n\n  - `erlang:error/1`\n  - `erlang:error/2`\n  - `erlang:exit/1`\n  - `erlang:throw/1`\n\n  Own Id: OTP-14055\n\n- Corrected documentation about memory footprint for maps.\n\n  Own Id: OTP-14118\n\n- Fix [`process_info(Pid, current_stacktrace)`](`process_info/2`) to use stack\n  depth limit set by `system_flag(backtrace_depth)`. The old behavior was a hard\n  coded depth limit of 8.\n\n  Own Id: OTP-14119 Aux Id: PR-1263\n\n- A process calling\n  [`erlang:system_flag(multi_scheduling, block)`](`m:erlang#system_flag_multi_scheduling`)\n  could end up hanging forever in the call.\n\n  Own Id: OTP-14121\n\n- Dirty scheduler bug fixes:\n\n  - Fixed call time tracing of process being scheduled on dirty scheduler.\n  - GC info from dirty schedulers.\n  - Multi scheduling block with dirty schedulers could crash the runtime system.\n  - Process structures could be removed prematurely.\n  - GC on dirty scheduler could crash the runtime system.\n  - Termination of a process executing on a dirty scheduler could cause a\n    runtime system crash.\n\n  Own Id: OTP-14122\n\n- Fixed crash that occurred when writing timer data to a crash dump.\n\n  Own Id: OTP-14133\n\n- A literal area could be removed while still referred from processes.\n\n  Own Id: OTP-14134\n\n- Fixed a bug in the garbage collector that could crash the runtime system.\n\n  Own Id: OTP-14135\n\n- Fixed a bug in call-time trace for NIFs which caused tracing to erroneously be\n  started multiple times for one call.\n\n  Own Id: OTP-14136\n\n- Remove a debug printout and an unnecessary garbage collection when handling\n  exceptions in hipe compiled code.\n\n  Own Id: OTP-14153\n\n- Fix bug in tracing of garbage collection that could cause VM crash. Bug exists\n  since OTP 19.0.\n\n  Own Id: OTP-14154\n\n- Fix bug in `binary_to_term` for binaries created by `term_to_binary `with\n  option `compressed`. The bug can cause `badarg` exception for a valid binary\n  when Erlang VM is linked against a `zlib` library of version 1.2.9 or newer.\n  Bug exists since OTP 17.0.\n\n  Own Id: OTP-14159 Aux Id: ERL-340\n\n- Fix suspension of schedulers when generating a crashdump.\n\n  Own Id: OTP-14164\n\n- NIF resources was not handled in a thread-safe manner in the runtime system\n  without SMP support.\n\n  As a consequence of this fix, the following driver functions are now\n  thread-safe also in the runtime system without SMP support:\n\n  - `driver_free_binary()`\n  - `driver_realloc_binary()`\n  - `driver_binary_get_refc()`\n  - `driver_binary_inc_refc()`\n  - `driver_binary_dec_refc()`\n\n  Own Id: OTP-14202\n\n- Fix `erlang:round/1` for large floating point numbers with an odd absolute\n  value between `(1 bsl 52)` and `(1 bsl 53)`. The result was falsely calculated\n  as the next higher even number even though all integer values up to\n  `(1 bsl 53)` can be represented as floats with full precision.\n\n  Own Id: OTP-14227\n\n- Add size of literals to module code size in crash dump and `(l)oaded` command\n  in break menu like it used to be before OTP-19.0.\n\n  Own Id: OTP-14228\n\n- Fix potential bug in `enif_send` when called without a process context and\n  with argument `msg_env` as `NULL`.\n\n  Own Id: OTP-14229\n\n- Fix bug where passing an appendable binary to `erlang:port_control()` could\n  crash the emulator.\n\n  Own Id: OTP-14231\n\n- Receive expressions with timeout in the Erlang shell could cause a VM crash.\n\n  Own Id: OTP-14241 Aux Id: ERL-365","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- A received SIGTERM signal to beam will generate a `'stop'` message to the\n  `init` process and terminate the Erlang VM nicely. This is equivalent to\n  calling `init:stop/0`.\n\n  Own Id: OTP-14085\n\n- Workaround for buggy Android implementation of `PTHREAD_STACK_MIN` causing\n  build of runtime system to crash on undeclared `PAGE_SIZE`.\n\n  Own Id: OTP-14165 Aux Id: ERL-319\n\n- Add configure option --without-thread-names that removes the naming of\n  individual emulator threads.\n\n  Own Id: OTP-14234\n\n- Add warning in documentation of `zlib:deflateInit/6` about option\n  `WindowsBits` values 8 and -8.\n\n  Own Id: OTP-14254 Aux Id: ERL-362","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 8.2.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug in `binary_to_term` for binaries created by `term_to_binary `with\n  option `compressed`. The bug can cause `badarg` exception for a valid binary\n  when Erlang VM is linked against a `zlib` library of version 1.2.9 or newer.\n  Bug exists since OTP 17.0.\n\n  Own Id: OTP-14159 Aux Id: ERL-340\n\n- The driver efile_drv when opening a file now use fstat() on the open file\n  instead of stat() before opening, if fstat() exists. This avoids a race when\n  the file happens to change between stat() and open().\n\n  Own Id: OTP-14184 Aux Id: seq-13266","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix a quite rare bug causing VM crash during code loading and the use of\n  export funs (fun M:F/A) of not yet loaded modules. Requires a very specific\n  timing of concurrent scheduler threads. Has been seen on ARM but can probably\n  also occurred on other architectures. Bug has existed since OTP R16.\n\n  Own Id: OTP-14144 Aux Id: seq13242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed `configure` failures on MacOSX. Most important `clock_gettime()` was\n  detected when building for MacOSX - El Capitan using XCode 8 despite it is not\n  available until MacOSX - Sierra.\n\n  Own Id: OTP-13904 Aux Id: ERL-256\n\n- `code:add_pathsa/1` and command line option `-pa` both revert the given list\n  of directories when adding it at the beginning of the code path. This is now\n  documented.\n\n  Own Id: OTP-13920 Aux Id: ERL-267\n\n- Fix a compilation error of erts in OpenBSD related to the usage of the\n  \\_\\_errno variable.\n\n  Own Id: OTP-13927\n\n- Fixed so that when enabling tracing on a process that had an invalid tracer\n  associated with it, the new tracer overwrites the old tracer. Before this fix,\n  calling erlang:trace/3 would behave as if the tracer was still alive and not\n  apply the new trace.\n\n  This fault was introduced in ERTS 8.0.\n\n  Own Id: OTP-13928\n\n- Fix parsing of `-profile_boot 'true' | 'false'`\n\n  Own Id: OTP-13955 Aux Id: ERL-280\n\n- A slight improvement of `erlang:get_stacktrace/0` for exceptions raised in\n  hipe compiled code. Beam compiled functions in such stack trace was earlier\n  replaced by some unrelated function. They are now instead omitted. This is an\n  attempt to reduce the confusion in the absence of a complete and correct stack\n  trace for mixed beam and hipe functions.\n\n  Own Id: OTP-13992\n\n- Correct type declaration of match specification head.\n\n  Own Id: OTP-13996\n\n- HiPE code loading failed for x86_64 if gcc was configured with\n  `--enable-default-pie`. Fixed by disabling PIE, if needed for HiPE, when\n  building the VM.\n\n  Own Id: OTP-14031 Aux Id: ERL-294, PR-1239\n\n- Faulty arguments could be presented on exception from a NIF that had\n  rescheduled itself using `enif_schedule_nif()`.\n\n  Own Id: OTP-14048\n\n- The runtime system could crash if a garbage collection on a process was\n  performed immediately after a NIF had been rescheduled using\n  `enif_schedule_nif()`.\n\n  Own Id: OTP-14049\n\n- A reference to purged code could be left undetected by the purge operation if\n  a process just had rescheduled a NIF call using `enif_schedule_nif()` when the\n  process was checked. This could cause a runtime system crash.\n\n  Own Id: OTP-14050\n\n- Fixed a number of dirty scheduler related bugs:\n\n  - Process priority was not handled correct when scheduling on a dirty\n    scheduler.\n  - The runtime system could crash when an exit signal with a compound exit\n    reason was sent to a process executing on a dirty scheduler.\n  - The runtime system crashed when call tracing a process executing on a dirty\n    scheduler.\n  - A code purge operation could end up hanging forever when a process executed\n    on a dirty scheduler\n\n  Own Id: OTP-14051","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Fix minor soft purge race bug that could incorrectly trigger code_server to\n  load new code for the module if the soft purge failed and no current version\n  of the module existed.\n\n  Own Id: OTP-13925\n\n- To ease troubleshooting, `erlang:load_nif/2` now includes the return value\n  from a failed call to load/reload/upgrade in the text part of the error tuple.\n  The `crypto` NIF makes use of this feature by returning the source line\n  where/if the initialization fails.\n\n  Own Id: OTP-13951\n\n- New environment variable `ERL_CRASH_DUMP_BYTES` can be used to limit the size\n  of crash dumps. If the limit is reached, crash dump generation is aborted and\n  the generated file will be truncated.\n\n  Own Id: OTP-14046","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 8.1.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A code purge operation could under certain circumstances expand the size of\n  hibernated processes.\n\n  Own Id: OTP-14444 Aux Id: ERIERL-24","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The emulator got a dynamic library dependency towards libsctp, which on Linux\n  was not intended since the emulator there loads and resolves the needed sctp\n  functions in runtime. This has been fixed and a configure switch\n  --enable-sctp=lib has been added for those who want such a library dependency.\n\n  Own Id: OTP-13956 Aux Id: ERL-262, ERL-133\n\n- Fix SIGUSR1 crashdump generation\n\n  Do not generate a core when a crashdump is asked for.\n\n  Own Id: OTP-13997\n\n- The new functions in `code` that allows loading of many modules at once had a\n  performance problem. While executing a helper function in the\n  `erl_prim_loader` process, garbage messages were produced. The garbages\n  messages were ignored and ultimately discarded, but there would be a negative\n  impact on performance and memory usage. The number of garbage message depended\n  on both the number of modules to be loaded and the length of the code path.\n\n  The functions affected of this problem were: `atomic_load/1`,\n  `ensure_modules_loaded/1`, and `prepare_loading/1`.\n\n  Own Id: OTP-14009","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug for calls from hipe code to BIFs that disable GC while yielding. Has\n  been causing Dialyzer crashes on ARM (and presumably all other non-intel\n  platforms).\n\n  Own Id: OTP-13724 Aux Id: PR-1116\n\n- Fix a bug where changing the current working directory of the VM would not\n  change the current working directory of programs spawned using\n  `erlang:open_port({spawn,\"\"}, ...)`.\n\n  Own Id: OTP-13733 Aux Id: ERL-175\n\n- Fix a bug where disabling tracing from a process that had return_to tracing\n  enabled and was tracing on `erlang:trace/3` would cause a segmentation fault.\n\n  Own Id: OTP-13734\n\n- Update all erts documentation to use simpler English, use consistent\n  terminology and be easier to navigate.\n\n  Own Id: OTP-13740\n\n- Add dirty schedulers to the microstate accounting statistics.\n\n  Own Id: OTP-13744\n\n- Fixed dirty scheduler build support on 32-bit windows.\n\n  Own Id: OTP-13759\n\n- inet:getstat(Socket) on an SCTP socket returned 0 for send stats. This bug has\n  now been corrected. Reported by systra as issue ERL-102 on bugs.erlang.org.\n\n  Own Id: OTP-13773 Aux Id: ERL-102\n\n- AF_UNSPEC and unknown address families were misread by UDP receive in\n  prim_inet resulting in an exception. This bug has now been corrected.\n\n  Own Id: OTP-13775\n\n- Sweep HiPE stack for literals during code purge.\n\n  Own Id: OTP-13777 Aux Id: PR-1122\n\n- Fix bug in run_erl for OpenBSD that could cause it on rare occations to exit\n  without starting the program (erl) at all.\n\n  Own Id: OTP-13795\n\n- Update build scripts to not make assumptions about where env, cp and perl are\n  located.\n\n  Own Id: OTP-13800\n\n- Fixed a bug where init:stop could deadlock if a process with infinite shutdown\n  timeout (e.g. a supervisor) attempted to load code while terminating.\n\n  Own Id: OTP-13802\n\n- Fixed a segmentation fault on sparc CPUs when free'ing a tracer module's\n  state.\n\n  Own Id: OTP-13803\n\n- `fun`s was not properly handled during purge of a module. This could cause a\n  crash of the VM after a purge of a module.\n\n  Own Id: OTP-13809\n\n- Fixed a memory leak when the process monitoring a port crashed.\n\n  Own Id: OTP-13818\n\n- Fixed multiple dirty scheduler related tracing bugs.\n\n  Own Id: OTP-13822\n\n- Fix error handling in beam code runtime loader for a number of cases when\n  index and size fields got corrupted (negative) values.\n\n  Own Id: OTP-13848 Aux Id: ERL-216\n\n- Minor fix of dirty scheduler implementation.\n\n  Own Id: OTP-13852\n\n- Calls to `erl_drv_send_term()` or `erl_drv_output_term()` from a non-scheduler\n  thread while the corresponding port was invalid caused the emulator to enter\n  an inconsistent state which eventually caused an emulator crash.\n\n  Own Id: OTP-13866\n\n- Fix a rare race condition in `erlang:open_port({spawn, \"\"}, ...)` that would\n  result in the erl_child_setup program aborting and cause the emulator to exit.\n\n  Own Id: OTP-13868\n\n- Driver and NIF operations accessing processes or ports could cause an emulator\n  crash when used from non-scheduler threads. Those operations are:\n\n  - `erl_drv_send_term()`\n  - `driver_send_term()`\n  - `erl_drv_output_term()`\n  - `driver_output_term()`\n  - `enif_send()`\n  - `enif_port_command()`\n\n  Own Id: OTP-13869\n\n- Fix start scripts generation dependency in Makefile\n\n  Own Id: OTP-13871 Aux Id: ERL-241\n\n- The VM could crash if `erlang:get_stacktrace()` was called after a rescheduled\n  NIF had thrown an exception.\n\n  Own Id: OTP-13877\n\n- Calling `code:delete/1` before a loading a module with an on_load function,\n  the old code would be overwritten, causing a memory or a crash if NIFs were\n  involved. (Thanks to vans163 for reporting this bug.)\n\n  Own Id: OTP-13893 Aux Id: ERL-240","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Improved accuracy of timeouts on MacOS X. This by setting premature timeouts\n  followed by a short actual timeout during scheduler wait.\n\n  Own Id: OTP-13698\n\n- Added the following symbolic time unit representations to the\n  `t:erlang:time_unit/0` type:\n\n  - `second`\n  - `millisecond`\n  - `microsecond`\n  - `nanosecond`\n\n  The following symbolic time unit representations are now _deprecated_, but\n  still part of the [`erlang:time_unit()`](`t:erlang:time_unit/0`) type:\n\n  - `seconds`\n  - `milli_seconds`\n  - `micro_seconds`\n  - `nano_seconds`\n\n  Own Id: OTP-13735\n\n- Fix maps hashing entropy of maps with maps keys.\n\n  Own Id: OTP-13763 Aux Id: ERL-199\n\n- Improved dirty scheduler support. A purge of a module can now be performed\n  without having to wait for completion of all ongoing dirty NIF calls.\n\n  Note that when enabling support for dirty schedulers, a new purge strategy\n  will as of ERTS version 8.1 be enabled. This new strategy is not fully\n  backwards compatible with the strategy used by default. For more information\n  see the documentation of `erlang:check_process_code/3`.\n\n  Own Id: OTP-13808 Aux Id: OTP-13833\n\n- A new purge strategy has been introduced. The new strategy will by default be\n  disabled during the OTP 19 release, but will be the only strategy available as\n  of the OTP 20 release.\n\n  The new strategy is slightly incompatible with the strategy being used by\n  default in OTP 19. Using the default strategy, processes holding `fun`s that\n  refer to the module being purged either fail a soft purge, or will be killed\n  during a hard purge. The new strategy completely ignores `fun`s. If `fun`s\n  referring to the code being purged exist, and are used after a purge, an\n  exception will be raised upon usage. That is, the behavior will be exactly the\n  same as the case when a `fun` is received by a process after the purge.\n\n  The new strategy can optionally be enabled when building OTP during OTP 19,\n  and will automatically be enabled if the runtime system is built with support\n  for dirty schedulers.\n\n  For more information see the documentation of `erlang:check_process_code/3`.\n\n  Own Id: OTP-13833\n\n- Fixed unnecessary overestimation of heap size need during garbage collection.\n\n  Own Id: OTP-13851","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 8.0.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a VM crash that occurred in a garbage collection of a process when it\n  had received binaries. This bug was introduced in ERTS version 8.0 (OTP 19.0).\n\n  Own Id: OTP-13890","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.0.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a VM crash that occurred in garbage collection of a process when it had\n  received maps over the distribution. This bug was introduced in ERTS version\n  8.0 (OTP 19.0).\n\n  Own Id: OTP-13889","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a race that could cause a lost wakeup of a process that timed out in a\n  `receive ... after`. This bug was introduced in ERTS version 7.0.\n\n  Own Id: OTP-13798 Aux Id: OTP-11997\n\n- Fixed segfault after writing an erl crash dump.\n\n  Own Id: OTP-13799","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix scheduler deadlock bug in `ets:update_counter/4` when key is not found and\n  inserting the default object causes the table to grow.\n\n  Own Id: OTP-13731 Aux Id: ERL-188\n\n- Fix VM abort \"Overrun stack and heap\" in garbage collection triggered by a\n  `bsl` operation and some very specific heap conditions.\n\n  Own Id: OTP-13732 Aux Id: seq13142","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A memory allocation bug in [`group_leader/2`](`group_leader/2`) could cause an\n  emulator crash when garbage collecting a process that had been assigned a\n  remote group leader. This bug was introduced in ERTS version 8.0.\n\n  Own Id: OTP-13716","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 8.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-8-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The handling of `on_load` functions has been improved. The major improvement\n  is that if a code upgrade fails because the `on_load` function fails, the\n  previous version of the module will now be retained.\n\n  Own Id: OTP-12593\n\n- `is_builtin(erlang, apply, 3)` will now return `true`.\n\n  Own Id: OTP-13034\n\n- Fix `enif_get_list_length` to return false if list is improper or have length\n  larger than `UINT_MAX` (did return true and an incorrect length value).\n\n  Own Id: OTP-13288 Aux Id: PR913\n\n- Cleanup hipe signal handling code for x86 and make it more portable.\n\n  Own Id: OTP-13341 Aux Id: PR951\n\n- Make file:datasync use fsync instead of fdatasync on Mac OSX.\n\n  Own Id: OTP-13411\n\n- Make sure to create a crash dump when running out of memory. This was\n  accidentally removed in the erts-7.3 release.\n\n  Own Id: OTP-13419\n\n- A bug has been fixed where if erlang was started +B on a unix platform it\n  would be killed by a SIGUSR2 signal when creating a crash dump.\n\n  Own Id: OTP-13425\n\n- Fix race between [`process_flag(trap_exit,true)`](`process_flag/2`) and a\n  received exit signal.\n\n  A process could terminate due to exit signal even though\n  [`process_flag(trap_exit,true)`](`process_flag/2`) had returned. A very\n  specific timing between call to [`process_flag/2`](`process_flag/2`) and exit\n  signal from another scheduler was required for this to happen.\n\n  Own Id: OTP-13452\n\n- Don't search for non-existing Map keys twice\n\n  For `maps:get/2,3` and `maps:find/2`, searching for an immediate key, e.g. an\n  atom, in a small map, the search was performed twice if the key did not exist.\n\n  Own Id: OTP-13459\n\n- When an abnormally large distribution message is about to be sent, the VM has\n  been changed to create a crash dump instead of a core dump.\n\n  Own Id: OTP-13474\n\n- Fix `erlang:process_info/2` type specification\n\n  Own Id: OTP-13485 Aux Id: ERL-123\n\n- Fix bug in [`open_port/2`](`open_port/2`) with option `{args, List}`. A vm\n  crash could be caused by an improper `List`.\n\n  Own Id: OTP-13489 Aux Id: ERL-127\n\n- Fixed a race-condition bug where the emulator could crash when\n  `erlang:system_profile/1,2` was enabled and a process had to be re-scheduled\n  during termination.\n\n  Own Id: OTP-13494 Aux Id: ERL-126\n\n- Fixed bugs where the reduction counter was not handled correct.\n\n  Own Id: OTP-13512\n\n- Fixed typo in description of the `EPMD_DUMP_REQ` response.\n\n  Own Id: OTP-13517\n\n- Fixed a bug where a process flagged as sensitive would sometimes record its\n  save_calls when it shouldn't.\n\n  Own Id: OTP-13540\n\n- Update configure scripts to not use hard-coded path for /bin/pwd and /bin/rm.\n\n  Own Id: OTP-13562\n\n- When passing a larger binary than the outputv callback of a linked-in driver\n  can handle in one io vector slot, the binary is now split into multiple slots\n  in the io vector. This change only effects system where the max size of an io\n  vector slot is smaller then the word size of the system (e.g. Windows).\n\n  This change means that it is now possible on Windows to send binaries that are\n  larger than 4GB to port_command, which is what is used for file:write,\n  gen_tcp:send etc.\n\n  Own Id: OTP-13628\n\n- Workaround of Maps output in crashdumps. Currently the atom 'undefined' is\n  generated instead of Map data if a Map type is encountered during crash.\n\n  Own Id: OTP-13657","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The tracing support has been extended to allow a\n  [tracer module](`m:erl_tracer`) to be the trace event handler instead of a\n  process or port. The [tracer module](`m:erl_tracer`) makes it possible for\n  trace tools to filter or manipulate trace event data without the trace event\n  first having to be copied from the traced process or port.\n\n  With the introduction of this feature, `erlang:trace(all|existing, _, _)` now\n  also returns the tracer process as part of the number of processes on which\n  tracing is enabled. The is incompatible with the previous releases.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10267\n\n- Introduce LTTng tracing of Erlang Runtime System\n\n  For LTTng to be enabled OTP needs to be built with configure option\n  `--with-dynamic-trace=lttng`.\n\n  This feature introduces tracepoints for schedulers, drivers, memory carriers,\n  memory and async thread pool.\n\n  For a list of all tracepoints, see\n  [Runtime Tools User's Guide](`e:runtime_tools:lttng.md`) .\n\n  Own Id: OTP-10282\n\n- Make it possible to monitor/demonitor ports using the `erlang:monitor/2` API.\n  The process and port information functions have also been updated to include\n  information about monitors from processes to ports.\n\n  Own Id: OTP-11384\n\n- Add microstate accounting\n\n  Microstate accounting is a way to track which state the different threads\n  within ERTS are in. The main usage area is to pin point performance\n  bottlenecks by checking which states the threads are in and then from there\n  figuring out why and where to optimize.\n\n  Since checking whether microstate accounting is on or off is relatively\n  expensive only a few of the states are enabled by default and more states can\n  be enabled through configure.\n\n  There is a convenience module called msacc that has been added to\n  runtime_tools that can assist in gathering and interpreting the data from\n  Microstate accounting.\n\n  For more information see\n  [erlang:statistics(microstate*accounting, *)](`m:erlang#statistics_microstate_accounting`)\n  and the `m:msacc` module in runtime_tools.\n\n  Own Id: OTP-12345\n\n- The port of Erlang/OTP to the real-time operating system OSE has been removed.\n\n  Own Id: OTP-12573\n\n- Sharing preserved copy for messages and exit signals\n\n  Enable sharing preserved copy with configure option\n  `--enable-sharing-preserving`. This will preserve sharing, within the process,\n  when communication with other processes in the Erlang node. There is a\n  trade-off, the copy is more costly but this cost can be reclaimed if there is\n  a lot of sharing in the message. In addition literals will not be copied in a\n  send except during a purge phase of the module where the literals are located.\n  This feature is considered experimental in 19.0.\n\n  Own Id: OTP-12590 Aux Id: OTP-10251\n\n- Halfword BEAM has been removed.\n\n  Own Id: OTP-12883\n\n- Added `os:perf_counter/1`.\n\n  The perf_counter is a very very cheap and high resolution timer that can be\n  used to timestamp system events. It does not have monoticity guarantees, but\n  should on most OS's expose a monotonous time.\n\n  Own Id: OTP-12908\n\n- Support for a fragmented young heap generation. That is, the young heap\n  generation can consist of multiple non continuous memory areas. The main\n  reason for this change is to avoid extra copying of messages that could not be\n  allocated directly on the receivers heap.\n\n  Own Id: OTP-13047\n\n- Erlang linked-in driver can now force the call to open_port to block until a\n  call to erl_drv_init_ack is made inside the driver. This is useful when you\n  want to do some asynchronous initialization, for example getting configuration\n  from a pipe, and you want the initial open_port call to fail if the\n  configuration is incomplete or wrong. See the erl_driver documentation for\n  more details on the API.\n\n  Own Id: OTP-13086\n\n- Erlang linked-in drivers can now set their own pids as seen in\n  `erlang:port_info/1` by using the `erl_drv_set_pid` function. For more details\n  see the erl_driver documentation.\n\n  Own Id: OTP-13087\n\n- The functionality behind `erlang:open_port/2` when called with spawn or\n  spawn_executable has been redone so that the forking of the new program is\n  done in a separate process called erl_child_setup. This allows for a much more\n  robust implementation that uses less memory and does not block the entire\n  emulator if the program to be started is on an un-accessible NFS. Benchmarks\n  have shown this approach to be about 3-5 times as fast as the old approach\n  where the fork/vfork was done by erts. This is a pure stability and\n  performance fix, however some error messages may have changed, which is why it\n  is marked as a backwards incompatible change.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13088\n\n- Improved yielding strategy in the implementation of the following native\n  functions:\n\n  - `erlang:binary_to_list/1`\n  - `erlang:binary_to_list/3`\n  - `erlang:bitstring_to_list/1`\n  - `erlang:list_to_binary/1`\n  - `erlang:iolist_to_binary/1`\n  - `erlang:list_to_bitstring/1`\n  - `binary:list_to_bin/1`\n\n  This in order to improve performance of these functions.\n\n  Own Id: OTP-13096\n\n- All garbage collections of processes now bump reductions. Also the amount of\n  reductions bumped when garbage collecting has been adjusted. It now better\n  corresponds to the amount of work performed. This in order to improve the real\n  time characteristics of the system.\n\n  Own Id: OTP-13097\n\n- New functions that can load multiple modules at once have been added to the\n  '`code`' module. The functions are `code:atomic_load/1`,\n  `code:prepare_loading/1`, `code:finish_loading/1`, and\n  `code:ensure_modules_loaded/1`.\n\n  Own Id: OTP-13111\n\n- The `-boot_var` option for `erl` now only supports a single key and single\n  value (as documented). The option used to allow multiple key/value pairs, but\n  that behavior was undocumented.\n\n  The function `erl_prim_loader:start/3` has been removed. Its documentation has\n  also been removed.\n\n  The undocumented and unsupported function `erl_prim_loader:get_files/2` has\n  been removed.\n\n  Own Id: OTP-13112\n\n- Low level BIF `erlang:purge_module/1` is made more robust against incorrect\n  use. Lingering processes that still refer the old code are now killed before\n  the module is purged to prevent fatal VM behavior.\n\n  Own Id: OTP-13122\n\n- Improved dirty scheduler implementation. For more information see the\n  [NIF documentation](erl_nif.md#dirty_nifs).\n\n  > #### Note {: .info }\n  >\n  > - The dirty scheduler support is still _experimental_.\n  > - The support for determining whether dirty NIF support exist or not at\n  >   compile time using the C preprocessor macro\n  >   `ERL_NIF_DIRTY_SCHEDULER_SUPPORT` has been removed.\n  > - The `enif_is_on_dirty_scheduler()` function has been removed. Use\n  >   [`enif_thread_type()`](erl_nif.md#enif_thread_type) instead.\n\n  Own Id: OTP-13123\n\n- Various optimizations done to process dictionary access.\n\n  Own Id: OTP-13167\n\n- Added max_heap_size process flag. max_heap_size allows the user to limit the\n  maximum heap used by a process. See\n  [erlang:process_flag](`erlang:process_flag/2`) for more details.\n\n  Own Id: OTP-13174\n\n- Allow dynamic drivers and NIF libraries to be built with gcc option\n  `-fvisibility=hidden` for faster loading and more optimized code.\n\n  Own Id: OTP-13227\n\n- Add `erlang:process_info(Pid, garbage_collection_info)` which returns extended\n  garbage_collection information. For more details see the documentation.\n\n  Own Id: OTP-13265\n\n- The functions `erlang:list_to_integer/1` and `string:to_integer/1` have been\n  optimized for large inputs.\n\n  Own Id: OTP-13293\n\n- Improved memory allocation strategy for hipe native code on x86_64 (amd64)\n  architectures by reserving enough low virtual address space needed for the\n  HiPE/AMD64 small code model. The default virtual address area for hipe code is\n  set to 512Mb, but can be changed with emulator flag `+MXscs`.\n\n  Own Id: OTP-13359\n\n- Introduction of configurable management of data referred to by the message\n  queue of a process. Each process can be configured individually.\n\n  It is now possible to configure the message queue of a process, so that all\n  data referred by it will be kept outside of the heap, and by this prevent this\n  data from being part of garbage collections.\n\n  For more information see the documentation of\n  [`process_flag(message_queue_data, MQD)`](`m:erlang#process_flag_message_queue_data`).\n\n  Own Id: OTP-13366 Aux Id: OTP-13047\n\n- Processes now yield when scanning large message queues and not finding a\n  matching message. This in order to improve real time characteristics.\n\n  Own Id: OTP-13401\n\n- Optimized an erts internal function that is used to traverse erlang terms. The\n  internal function was mainly used by term_to_binary and comparison of terms.\n  Benchmarks have shown up to a 10% performance increase in those functions\n  after the optimization.\n\n  Own Id: OTP-13440\n\n- Add the following NIF API functions:\n\n  - [`enif_cpu_time`](erl_nif.md#enif_cpu_time)\n  - [`enif_now_time`](erl_nif.md#enif_now_time)\n  - [`enif_make_unique_integer`](erl_nif.md#enif_make_unique_integer)\n  - [`enif_is_process_alive`](erl_nif.md#enif_is_process_alive)\n  - [`enif_is_port_alive`](erl_nif.md#enif_is_port_alive)\n  - [`enif_term_to_binary`](erl_nif.md#enif_term_to_binary)\n  - [`enif_binary_to_term`](erl_nif.md#enif_binary_to_term)\n  - [`enif_port_command`](erl_nif.md#enif_port_command)\n\n  For details of what each function does, see the erl_nif documentation.\n\n  Own Id: OTP-13442\n\n- Optimize `'++'` operator and `lists:append/2` by using a single pass to build\n  a new list while checking for properness.\n\n  Own Id: OTP-13487\n\n- Handle terms (pids,ports and refs) from nodes with a 'creation' value larger\n  than 3. This is a preparation of the distribution protocol to allow OTP 19\n  nodes to correctly communicate with future nodes (20 or higher). The\n  'creation' value differentiates different incarnations of the same node\n  (name).\n\n  Own Id: OTP-13488\n\n- Don't send unasked for systemd notifications in epmd\n\n  Own Id: OTP-13493 Aux Id: PR-999\n\n- The enif_send API has been extended to allow NULL to be used as the message\n  environment. When used this way, a message environment is implicitly created\n  and the given term is copied into that environment before sending. This can be\n  an optimization if many small messages are being sent by the nif.\n\n  Own Id: OTP-13495\n\n- The tracing support has been extended to allow tracing on ports. Ports can be\n  traced on using the 'ports', 'send' and 'receive' trace flags.\n\n  The first argument of `erlang:trace/3` has been extended so that `'all'`,\n  `'existing'` and `'new'` now include both processes and ports. New `Tracee`\n  variants, `'all_processes'`, `'all_ports'`, `'existing_processes'` etc have\n  been added to specify only processes or ports.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13496\n\n- When the `'procs'` trace flag is enabled, a `'spawned'` trace event is now\n  also generated by a newly created process. The previous event `'spawn'`\n  remains, but as it is generated by the process that did the spawn, it is not\n  guaranteed that it is ordered with other trace events from the newly spawned\n  process. So when tracking the lifetime of a process this new event should be\n  used as the creation event.\n\n  This new trace event is marked as an incompatibility because tools that expect\n  certain trace events when enabling 'procs' will have to updated.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13497\n\n- Add the `erlang:match_spec_test/3` function. The functions allows the testing\n  of match specifications for both tracing and ets tables. It can be used to\n  test that a match specification does the expected filtering on specific data.\n  It also returns more verbose error reasons for incorrectly constructed match\n  specifications.\n\n  Own Id: OTP-13501\n\n- The erts internal tracing support has been changed to have much less overhead\n  and be more scalable.\n\n  This rewrite does not break any backwards incompatibilities, but it does\n  change the ordering of some trace messages when compared to previous releases.\n  It should be noted that this only applies to trace messages sent to processes\n  or ports, it does not apply to the new tracer module. However in future\n  releases they may also be effected by this.\n\n  Trace messages are only guaranteed to be ordered from one traced process or\n  port. In previous releases this was not visible as a `'send'` trace message\n  would always arrive before the corresponding `'receive'` trace message that is\n  no longer always the case. This also means that timestamped trace messages may\n  seem to arrive out of order as the timestamp is taken when the event is\n  triggered and not when it is put in the queue of the tracer.\n\n  Own Id: OTP-13503\n\n- Add possibility to filter `send` and `receive` trace with match\n  specifications.\n\n  Own Id: OTP-13507\n\n- Add `maps:update_with/3,4` and `maps:take/2`\n\n  Own Id: OTP-13522 Aux Id: PR-1025\n\n- Introduce LTTng tracing via Erlang tracing.\n\n  For LTTng to be enabled OTP needs to be built with configure option\n  `--with-dynamic-trace=lttng`.\n\n  The dynamic trace module `dyntrace` is now capable to be used as a LTTng sink\n  for Erlang tracing. For a list of all tracepoints, see\n  [Runtime Tools User's Guide](`e:runtime_tools:lttng.md`) .\n\n  This feature also introduces an incompatible change in trace tags. The trace\n  tags `gc_start` and `gc_end` has been split into `gc_minor_start`,\n  `gc_minor_end` and `gc_major_start`, `gc_major_end`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13532\n\n- Print heap pointers for garbing processes during crashdump\n\n  Own Id: OTP-13541 Aux Id: PR-1026\n\n- Changed and improved low level memory statistics returned by\n  `erlang:system_info/1`. The info for `erts_mmap` has been moved from\n  `mseg_alloc` to its own section returned by `{allocator, erts_mmap}`.\n\n  Own Id: OTP-13560\n\n- Add enif_snprintf to the NIF API\n\n  The function `enif_snprintf` is similar to `snprintf` call but can handle\n  formatting of Erlang terms via `%T` format specifier.\n\n  Own Id: OTP-13580\n\n- The warning in the documentation for `erlang:raise/3` has been removed. It is\n  now officially perfectly fine to use raise/3 in production code.\n\n  Own Id: OTP-13599\n\n- Fix bugs caused by the VM sometimes truncating object sizes or offsets to 32\n  bits on 64-bit hosts. These bugs were mainly found when working with large\n  unicode strings and nifs environments.\n\n  Own Id: OTP-13606\n\n- Add `-start_epmd` command line option, this lets you disable automatic\n  starting of epmd when starting a distributed node.\n\n  Add `-epmd_module` command line option, this lets you specify a module to\n  register and look-up node names in. The default module is `erl_epmd`.\n\n  Own Id: OTP-13627\n\n- `erlang:halt` now truncates strings longer than 200 characters instead of\n  failing with `badarg`.\n\n  Own Id: OTP-13630\n\n- Fix possible race in poller wake up on windows\n\n  Own Id: OTP-13634","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.3.1.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1-6"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- List subtraction (The `--` operator) will now yield properly on large inputs.\n\n  Own Id: OTP-15371","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.3.1.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed small memory leak that could occur when sending to a terminating port.\n\n  Own Id: OTP-14609 Aux Id: ERIERL-238","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.3.1.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix performance bug in pre-allocators that could cause them to permanently\n  fall back on normal more expensive memory allocation. Pre-allocators are used\n  for quick allocation of short lived meta data used by messages and other\n  scheduled tasks. Bug exists since OTP_R15B02.\n\n  Own Id: OTP-14491\n\n- Fixed bug in operator `bxor` causing erroneuos result when one operand is a\n  big _negative_ integer with the lowest `N*W` bits as zero and the other\n  operand not larger than `N*W` bits. `N` is an integer of 1 or larger and `W`\n  is 32 or 64 depending on word size.\n\n  Own Id: OTP-14514\n\n- A timer internal bit-field used for storing scheduler id was too small. As a\n  result, VM internal timer data structures could become inconsistent when using\n  1024 schedulers on the system. Note that systems with less than 1024\n  schedulers are not effected by this bug.\n\n  This bug was introduced in ERTS version 7.0 (OTP 18.0).\n\n  Own Id: OTP-14548 Aux Id: OTP-11997, ERL-468\n\n- Fixed bug in `binary_to_term` and `binary_to_atom` that could cause VM crash.\n  Typically happens when the last character of an UTF8 string is in the range\n  128 to 255, but truncated to only one byte. Bug exists in `binary_to_term`\n  since ERTS version 5.10.2 (OTP_R16B01) and `binary_to_atom` since ERTS version\n  9.0 (OTP-20.0).\n\n  Own Id: OTP-14590 Aux Id: ERL-474","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.3.1.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A bug has been fixed where if erlang was started +B on a unix platform it\n  would be killed by a SIGUSR2 signal when creating a crash dump.\n\n  Own Id: OTP-13425 Aux Id: ERL-94\n\n- Calls to `erl_drv_send_term()` or `erl_drv_output_term()` from a non-scheduler\n  thread while the corresponding port was invalid caused the emulator to enter\n  an inconsistent state which eventually caused an emulator crash.\n\n  Own Id: OTP-13866\n\n- Driver and NIF operations accessing processes or ports could cause an emulator\n  crash when used from non-scheduler threads. Those operations are:\n\n  - `erl_drv_send_term()`\n  - `driver_send_term()`\n  - `erl_drv_output_term()`\n  - `driver_output_term()`\n  - `enif_send()`\n  - `enif_port_command()`\n\n  Own Id: OTP-13869\n\n- Fix bug in `binary_to_term` for binaries created by `term_to_binary `with\n  option `compressed`. The bug can cause `badarg` exception for a valid binary\n  when Erlang VM is linked against a `zlib` library of version 1.2.9 or newer.\n  Bug exists since OTP 17.0.\n\n  Own Id: OTP-14159 Aux Id: ERL-340","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.3.1.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a race that could cause a lost wakeup of a process that timed out in a\n  `receive ... after`. This bug was introduced in ERTS version 7.0.\n\n  Own Id: OTP-13798 Aux Id: OTP-11997\n\n- Fixed segfault after writing an erl crash dump.\n\n  Own Id: OTP-13799","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.3.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix scheduler deadlock bug in `ets:update_counter/4` when key is not found and\n  inserting the default object causes the table to grow.\n\n  Own Id: OTP-13731 Aux Id: ERL-188","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- [`process_info(Pid, last_calls)`](`process_info/2`) did not work for\n  `Pid /= self()`.\n\n  Own Id: OTP-13418\n\n- Make sure to create a crash dump when running out of memory. This was\n  accidentally removed in the erts-7.3 release.\n\n  Own Id: OTP-13419\n\n- Schedulers could be woken by a premature timeout on Linux. This premature\n  wakeup was however harmless.\n\n  Own Id: OTP-13420\n\n- A process communicating with a port via one of the `erlang:port_*` BIFs could\n  potentially end up in an inconsistent state if the port terminated during the\n  communication. When this occurred the process could later block in a `receive`\n  even though it had messages matching in its message queue.\n\n  This bug was introduced in erts version 5.10 (OTP R16A).\n\n  Own Id: OTP-13424 Aux Id: OTP-10336\n\n- The reference count of a process structure could under rare circumstances be\n  erroneously managed. When this happened invalid memory accesses occurred.\n\n  Own Id: OTP-13446\n\n- Fix race between [`process_flag(trap_exit,true)`](`process_flag/2`) and a\n  received exit signal.\n\n  A process could terminate due to exit signal even though\n  [`process_flag(trap_exit,true)`](`process_flag/2`) had returned. A very\n  specific timing between call to [`process_flag/2`](`process_flag/2`) and exit\n  signal from another scheduler was required for this to happen.\n\n  Own Id: OTP-13452","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The '-path' flag to 'erl' has been documented. This flag replaces the path\n  specified in the boot script. It has always existed, but was earlier only\n  documented in SASL (script).\n\n  Own Id: OTP-13060\n\n- The `call_time` tracing functionality internally used a time based on OS\n  system time in order to measure call time which could cause erroneous results\n  if OS system time was changed during tracing.\n\n  This functionality now use Erlang monotonic time in order to measure time.\n  Besides fixing the erroneous results due to OS system time being used, the\n  results are often also better since Erlang monotonic time often has better\n  accuracy and precision.\n\n  Own Id: OTP-13216\n\n- Fix behaviour of -delay_write command line switch of epmd, which is used for\n  debugging - in some cases epmd was sleeping twice the requested amount of\n  time.\n\n  Own Id: OTP-13220\n\n- Fix race between timeout and exit signal that could cause a process to ignore\n  the exit signal and continue execution. Bug exist since OTP 18.0.\n\n  Own Id: OTP-13245\n\n- Fix bug in `erlang:halt/1,2` for large exit status values, causing either\n  `badarg` (on 32-bit) or exit with a crash dump and/or core dump (on 64-bit).\n  Make `erlang:halt/1,2` tolerate any non negative integer as exit status and\n  truncate high order bits if the OS does not support it.\n\n  Own Id: OTP-13251 Aux Id: ERL-49\n\n- `gen_tcp:accept/2` was not\n  [time warp safe](time_correction.md#time-warp-safe-code). This since it used\n  the same time as returned by `erlang:now/0` when calculating timeout. This has\n  now been fixed.\n\n  Own Id: OTP-13254 Aux Id: OTP-11997, OTP-13222\n\n- Fix faulty error handling when writing to a compressed file.\n\n  Own Id: OTP-13270\n\n- Fix sendfile usage for large files on FreeBSD\n\n  Own Id: OTP-13271\n\n- Fix bug that could cause\n  [`process_info(P,current_location)`](`process_info/2`) to crash emulator for\n  hipe compiled modules.\n\n  Own Id: OTP-13282 Aux Id: ERL-79\n\n- Out of memory errors have been changed to cause an exit instead of abort.\n\n  Own Id: OTP-13292\n\n- When calling `garbage_collect/[1,2]` or `check_process_code/[2,3]` from a\n  process with a higher priority than the priority of the process operated on,\n  the run queues could end up in an inconsistent state. This bug has now been\n  fixed.\n\n  Own Id: OTP-13298 Aux Id: OTP-11388\n\n- A workaround for an issue with older gcc versions (less than 5) and inline\n  assembly on 32-bit x86 caused an emulator crash when it had been compiled with\n  a newer gcc version. An improved `configure` test, run when building OTP, now\n  detects whether the workaround should be used or not.\n\n  Own Id: OTP-13326 Aux Id: ERL-80","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Introduced new statistics functionality in order to more efficiently retrieve\n  information about run able and active processes and ports. For more\n  information see:\n\n  - [`statistics(total_run_queue_lengths)`](`m:erlang#statistics_total_run_queue_lengths`)\n  - [`statistics(run_queue_lengths)`](`m:erlang#statistics_run_queue_lengths`)\n  - [`statistics(total_active_tasks)`](`m:erlang#statistics_total_active_tasks`)\n  - [`statistics(active_tasks)`](`m:erlang#statistics_active_tasks`)\n\n  Own Id: OTP-13201\n\n- Time warp safety improvements.\n\n  Introduced the options `monotonic_timestamp`, and `strict_monotonic_timestamp`\n  to the trace, sequential trace, and system profile functionality. This since\n  the already existing `timestamp` option is not time warp safe.\n\n  Introduced the option `safe_fixed_monotonic_time` to `ets:info/2` and\n  `dets:info/2`. This since the already existing `safe_fixed` option is not time\n  warp safe.\n\n  Own Id: OTP-13222 Aux Id: OTP-11997\n\n- Fix a register race where down nodes goes undetected in epmd\n\n  Own Id: OTP-13301\n\n- Improved the gcc inline assembly implementing double word atomic compare and\n  exchange on x86/x86_64 so that it also can be used when compiling with clang.\n\n  Own Id: OTP-13336\n\n- An optimization preventing a long wait for a scheduler thread looking up\n  information about a process executing on another scheduler thread had\n  unintentionally been lost in erts-5.10 (OTP R16A). This optimization has now\n  been reintroduced.\n\n  Own Id: OTP-13365 Aux Id: OTP-9892","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.2.1.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-2-1-1"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Introduced new statistics functionality in order to more efficiently retrieve\n  information about run able and active processes and ports. For more\n  information see:\n\n  - [`statistics(total_run_queue_lengths)`](`m:erlang#statistics_total_run_queue_lengths`)\n  - [`statistics(run_queue_lengths)`](`m:erlang#statistics_run_queue_lengths`)\n  - [`statistics(total_active_tasks)`](`m:erlang#statistics_total_active_tasks`)\n  - [`statistics(active_tasks)`](`m:erlang#statistics_active_tasks`)\n\n  Own Id: OTP-13201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Revert \"Fix erroneous splitting of emulator path\"\n\n  Own Id: OTP-13202\n\n- Fix HiPE enabled emulator for FreeBSD.\n\n  Own Id: OTP-13204 Aux Id: pr926","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Small documentation fixes\n\n  Own Id: OTP-13017\n\n- Fix memory corruption bug caused by disabling distribution and then re-enable\n  distribution with a node name that has previously been used by a remote node.\n\n  Own Id: OTP-13076 Aux Id: seq12959\n\n- Renamed variables with name bool as Visual Studio 2015 now treats this is a\n  keyword.\n\n  Own Id: OTP-13079\n\n- `erl_prim_loader` has not supported custom loaders for several releases. In\n  the documentation for `erl_prim_loader`, all references to custom loaders have\n  now been removed.\n\n  Own Id: OTP-13102\n\n- Fixed compilation of erts together with libc versions that do not define\n  \\_\\_uint32_t.\n\n  Own Id: OTP-13105\n\n- erl -make now returns non-zero exit codes on failure\n\n  Own Id: OTP-13107\n\n- Fix crash on init:restart in embedded mode caused by on_load handler process\n  not being relaunched leading to load failure for modules such as crypto and\n  asn1rt_nif that need it to be present for correct NIF loading.\n\n  Own Id: OTP-13115\n\n- Fix maps decode in erlang:binary_to_term/1\n\n  Decoding a term with a large (HAMT) map in an small (FLAT) map could cause a\n  critical error if the external format was not produced by beam.\n\n  Own Id: OTP-13125\n\n- Fix very rare bug in GC when big maps with a lot of hash collisions from a\n  remote node are waiting in inner message queue.\n\n  Own Id: OTP-13146\n\n- Fixed a bug that could cause a crash dump to become almost empty.\n\n  Own Id: OTP-13150","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Updated the xmllint target to just check the xml files with real documentation\n  content.  \n  Corrected some errors and added some missing target in the DTD's.\n\n  Own Id: OTP-13026\n\n- Add function enif_getenv to read OS environment variables in a portable way\n  from NIFs.\n\n  Own Id: OTP-13147","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug in ETS that could cause stray objects marked for deletion to\n  occasionally be missed by the cleanup done by `safe_fixtable(_,false)`.\n\n  Own Id: OTP-12870\n\n- Fixed VM crash that could occur if a trace port was linked to a process, and\n  the trace port terminated abnormally while handling a trace message. This bug\n  has always existed in the runtime system with SMP support.\n\n  Own Id: OTP-12901\n\n- Instead of aborting, the vm now creates a crash dump when a system process is\n  terminated.\n\n  Own Id: OTP-12934\n\n- Fixed a rare emulator dead lock that occurred when\n  erlang:process_flag(priority,...) was called by a process that was also\n  scheduled for an internal system activity.\n\n  Own Id: OTP-12943\n\n- The runtime system on various posix platforms (except for Linux and Solaris)\n  could crash when large amounts of file-descriptors were in use.\n\n  Own Id: OTP-12954\n\n- A beam file compiled by hipe for an incompatible runtime system was sometimes\n  not rejected by the loader, which could lead to vm crash. This fix will also\n  allow the same hipe compiler to be used by both normal and debug-built vm.\n\n  Own Id: OTP-12962\n\n- Fix bug in `maps:merge/2` when called by hipe compiled code that could cause\n  vm crash. Bug exists since erts-7.0 (OTP 18.0).\n\n  Own Id: OTP-12965\n\n- When tracing with `process_dump` option, the VM could abort if there was an\n  ongoing binary match somewhere in the call stack of the traced process.\n\n  Own Id: OTP-12968\n\n- Fixed possible output deadlock in tty driver when hitting \"CTRL-C\" in a\n  non-smp emulator shell on unix.\n\n  Own Id: OTP-12987 Aux Id: Seq12947\n\n- Fix `binary_to_integer` to throw badarg for \"+\" and \"-\" similar to\n  `list_to_integer`.\n\n  Own Id: OTP-12988\n\n- Suppress warning of unused argument when using macro enif_make_pid.\n\n  Own Id: OTP-12989","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Changed default clock source used for OS system time on MacOS X to\n  `gettimeofday()` in order to improve performance. The system can be configured\n  during build to use the previously used higher resolution clock source by\n  passing the switch\n  [`--with-clock-resolution=high`](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring`)\n  when configuring the build.\n\n  Own Id: OTP-12945 Aux Id: OTP-12892\n\n- Added the `configure` option\n  [`--disable-saved-compile-time`](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring`)\n  which disables saving of compile date and time in the emulator binary.\n\n  Own Id: OTP-12971","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.0.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a binary memory leak when printing to shell using the tty driver (i.e.\n  not -oldshell).\n\n  Own Id: OTP-12941\n\n- Fix a bug where the standard error port sometimes crashes with eagain as the\n  reason.\n\n  Own Id: OTP-12942\n\n- When tracing with `process_dump` option, the VM could abort if there was an\n  ongoing binary match somewhere in the call stack of the traced process./\n\n  Own Id: OTP-12968","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.0.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process could end up in an inconsistent half exited state in the runtime\n  system without SMP support. This could occur if the processes was traced by a\n  port that it also was linked to, and the port terminated abnormally while\n  handling a trace message for the process.\n\n  This bug has always existed in the runtime system without SMP support, but\n  never in the runtime system with SMP support.\n\n  Own Id: OTP-12889 Aux Id: seq12885\n\n- Removed unnecessary copying of data when retrieving corrected Erlang monotonic\n  time.\n\n  Own Id: OTP-12894\n\n- Changed default OS monotonic clock source chosen at build time. This in order\n  to improve performance. The behavior will now on most systems be that (both OS\n  and Erlang) monotonic time stops when the system is suspended.\n\n  If you prefer that monotonic time elapse during suspend of the machine, you\n  can pass the command line argument\n  `--enable-prefer-elapsed-monotonic-time-during-suspend` to `configure` when\n  building Erlang/OTP. The configuration stage will try to find such a clock\n  source, but might not be able to find it. Note that there might be a\n  performance penalty associated with such a clock source.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12895\n\n- `erlang:system_info(end_time)` returned a faulty value on 32-bit\n  architectures.\n\n  Own Id: OTP-12896","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- The `configure` command line argument\n  `--enable-gettimeofday-as-os-system-time` has been added which force usage of\n  `gettimeofday()` for OS system time. This will improve performance of\n  `os:system_time()` and `os:timestamp()` on MacOS X, at the expense of worse\n  accuracy, resolution and precision of Erlang monotonic time, Erlang system\n  time, and OS system time.\n\n  Own Id: OTP-12892","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 7.0.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix a rare hanging of the VM seen to happen just after emulator start. Bug\n  exists since R14.\n\n  Own Id: OTP-12859 Aux Id: seq12882","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 7.0 - ERTS Release Notes","doc":"","ref":"notes.html#erts-7-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix issuing with spaces and quoting in the arguments when using\n  erlang:open_port spawn_executable on windows. The behavior now mimics how unix\n  works. This change implies a backwards incompatibility for how\n  spawn_executable works on windows.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11905\n\n- Fix global call trace when hipe compiled code call beam compiled functions.\n  Tracing of beam functions should now always work regardless who the caller is.\n\n  Own Id: OTP-11939\n\n- Correct cache alignment for ETS `write_concurrency` locks to improve\n  performance by reduced false sharing. May increase memory footprint for tables\n  with `write_concurrency`.\n\n  Own Id: OTP-11974\n\n- All possibly blocking operations in the fd/spawn and terminal driver have been\n  converted to non-blocking operations. Before this fix it was possible for the\n  VM to be blocked for a long time if the entity consuming stdout/stderr did not\n  consume it fast enough.\n\n  Own Id: OTP-12239\n\n- Add missing overhead for offheap binaries created from external format. This\n  fix can improve the garbage collection of large binaries originating from\n  `binary_to_term` or messages from remote nodes.\n\n  Own Id: OTP-12554\n\n- Ensure hashing of zero is consistent\n\n  Erlang treats positive and negative zero as equal:\n\n  `true = 0.0 =:= 0.0/-1`\n\n  However, Erlangs hash functions: hash, phash and phash2 did not reflect this\n  behaviour. The hash values produced by the different hash functions would not\n  be identical for positive and negative zero.\n\n  This change ensures that hash value of positive zero is always produced\n  regardless of the signedness of the zero float, i.e.,\n\n  `true = erlang:phash2(0.0) =:= erlang:phash2(0.0/-1)`\n\n  Own Id: OTP-12641\n\n- Ensure NIF term creation disallows illegal floating point values and too long\n  atoms. Such values will cause a NIF to throw badarg exception when it returns.\n\n  Own Id: OTP-12655\n\n- Fixed building of Map results from match_specs\n\n  A faulty \"box-value\" entered into the heap which could cause a segmentation\n  fault in the garbage collector if it was written on a heap fragment.\n\n  Own Id: OTP-12656\n\n- Fix hipe bug when matching a \"writable\" binary. The bug has been seen to\n  sometimes cause a failed binary matching of a correct utf8 character, but\n  other symptoms are also possible.\n\n  Own Id: OTP-12667\n\n- Keep dirty schedulers from waking other schedulers.\n\n  Own Id: OTP-12685\n\n- Disable floating point exceptions if the VM is compiled by clang/llvm. This is\n  a known long-standing problem in clang/llvm.\n\n  Own Id: OTP-12717\n\n- Fix bug in `file:sendfile` for FreeBSD causing not the entire file to be sent.\n\n  Own Id: OTP-12720\n\n- Fix the broken Android support in erl_child_setup.c\n\n  Own Id: OTP-12751\n\n- Faulty statistics reported by the `fix_alloc` allocator.\n\n  Own Id: OTP-12766\n\n- Fix two erts_snprintf() calls to correct sizes.\n\n  \\- run_erl.c (ose): Use the size of the signal type, not its pointer. -\n  erl_node_tables.c: Use the size of the \\_BUFFER in erts_snprintf() to make\n  sure we can use the full space.\n\n  Own Id: OTP-12771\n\n- Delayed memory allocations could be delayed an unnecessarily long time.\n\n  Own Id: OTP-12812\n\n- Make sure that timeouts on a pool of acceptors are released in the correct\n  order.\n\n  Own Id: OTP-12817\n\n- Fix segmentation fault in module_info for deleted modules\n\n  Own Id: OTP-12820\n\n- Fix garbage collection of literals in code purge\n\n  During code purging and check_process_code, the checking of the binary\n  reference embedded in the match binary state was omitted for the tracing\n  tests. This would cause the binary match state to reference deallocated\n  memory.\n\n  Own Id: OTP-12821\n\n- A bug has been corrected for gen_tcp:close so when \\{linger,\\{true,0\\}\\} is in\n  effect it does not wait for data in the driver queue to transfer out before\n  closing the port. Bug fix by Rory Byrne.\n\n  Own Id: OTP-12840\n\n- The documentation of the driver callback [`start()`](driver_entry.md#start)\n  erroneously stated that a return value of `ERL_DRV_ERROR_ERRNO` caused the\n  error value to be passed via `erl_errno` when it should have been `errno`.\n\n  Own Id: OTP-12855","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Add `md5` and `module` entries to `?MODULE:module_info/0/1` and remove\n  obsolete entry 'import'.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11940\n\n- Debug function `erlang:display/1` shows content of binaries and bitstrings,\n  not only the length.\n\n  Own Id: OTP-11941\n\n- The time functionality of Erlang has been extended. This both includes a\n  [new API](time_correction.md#new-time-api) for time, as well as\n  [time warp modes](time_correction.md#time-warp-modes) which alters the\n  behavior of the system when system time changes. _You are strongly encouraged\n  to use the new API_ instead of the old API based on `erlang:now/0`.\n  `erlang:now/0` has been deprecated since it is and forever will be a\n  scalability bottleneck. For more information see the\n  [Time and Time Correction](time_correction.md) chapter of the ERTS User's\n  Guide.\n\n  Besides the API changes and time warp modes a lot of scalability and\n  performance improvements regarding time management has been made internally in\n  the runtime system. Examples of such improvements are scheduler specific timer\n  wheels, scheduler specific BIF timer management, parallel retrieval of\n  monotonic time and system time on systems with primitives that are not buggy.\n\n  Own Id: OTP-11997\n\n- `erlang:function_exported(M, F, A)` will now return `true` if `M:F/A` refers\n  to a BIF.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12099\n\n- New BIF: `erlang:get_keys/0`, lists all keys associated with the process\n  dictionary. Note: `erlang:get_keys/0` is auto-imported.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12151 Aux Id: seq12521\n\n- Make distributed send of large messages yield to improve real-time\n  characteristics.\n\n  Own Id: OTP-12232\n\n- Use high accuracy poll timeouts\n\n  Where available, use poll/select API's that can handle time resolutions less\n  than 1ms. In the cases where such API's are not available the timeout is\n  rounded up to the nearest ms.\n\n  Own Id: OTP-12236\n\n- The internal group to user_drv protocol has been changed to be synchronous in\n  order to guarantee that output sent to a process implementing the user_drv\n  protocol is printed before replying. This protocol is used by the\n  standard_output device and the ssh application when acting as a client.\n\n  This change changes the previous unlimited buffer when printing to standard_io\n  and other devices that end up in user_drv to 1KB.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12240\n\n- The previously introduced \"eager check I/O\" feature is now enabled by default.\n\n  Eager check I/O can be disabled using the `erl` command line argument:\n  `+secio false`\n\n  Characteristics impact compared to previous default:\n\n  - Lower latency and smoother management of externally triggered I/O\n    operations.\n  - A slightly reduced priority of externally triggered I/O operations.\n\n  Own Id: OTP-12254 Aux Id: OTP-12117\n\n- Properly support maps in match_specs\n\n  Own Id: OTP-12270\n\n- The notice that a crashdump has been written has been moved to be printed\n  before the crashdump is generated instead of afterwords. The wording of the\n  notice has also been changed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12292\n\n- New function `ets:take/2`. Works the same as `ets:delete/2` but also returns\n  the deleted object(s).\n\n  Own Id: OTP-12309\n\n- Tracing with cpu_timestamp option has been enabled on Linux.\n\n  Own Id: OTP-12366\n\n- ets:info/1,2 now contains information about whether write_concurrency or\n  read_concurrency is enabled.\n\n  Own Id: OTP-12376\n\n- Improved usage of `gcc`'s builtins for atomic memory access. These are used\n  when no other implementation of atomic memory operations is available. For\n  example, when compiling for ARM when `libatomic_ops` is not available.\n\n  The largest improvement will be seen when compiling with a `gcc` with support\n  for the `__atomic_*` builtins (using a `gcc` of at least version 4.7), but\n  also when only the legacy `__sync_*` builtins are available (using a `gcc` of\n  at least version 4.1) an improvement can be seen.\n\n  For more information see the\n  \"[Atomic Memory Operations and the VM](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring_atomic-memory-operations-and-the-vm`)\"\n  section of `$ERL_TOP/HOWTO/INSTALL.md`.\n\n  Own Id: OTP-12383\n\n- Introduce `math:log2/1` function to math module.\n\n  Own Id: OTP-12411\n\n- The documentation of the Abstract Format (in the ERTS User's Guide) has been\n  updated with types and specification. (Thanks to Anthony Ramine.)\n\n  The explicit representation of parentheses used in types of the abstract\n  format has been removed. Instead the new functions\n  `erl_parse:type_inop_prec()` and `erl_parse:type_preop_prec()` can be used for\n  inserting parentheses where needed.\n\n  Own Id: OTP-12492\n\n- Remove perfctr support\n\n  Development of perfctr in the linux kernel ceased in 2010. The perfctr support\n  code in the Erlang VM is thus effectively dead code and therefore removed.\n\n  Own Id: OTP-12508\n\n- `zlib:inflateChunk/2` has been added. It works like `zlib:inflate/2`, but\n  decompresses no more data than will fit in the buffer configured by\n  `zlib:setBufSize/2`.\n\n  Own Id: OTP-12548\n\n- Use linear search for small select_val arrays\n\n  Own Id: OTP-12555\n\n- New BIF ets:update_counter/4 with a default object as argument, which will be\n  inserted in the table if the key was not found.\n\n  Own Id: OTP-12563\n\n- Export missing types from zlib module\n\n  Own Id: OTP-12584\n\n- Use persistent hashmaps for large Maps\n\n  Maps will use a persistent hashmap implementation when the number of pairs in\n  a Map becomes sufficiently large. The change will occur when a Map reaches 33\n  pairs in size but this limit might change in the future.\n\n  The most significant impact for the user by this change is speed, and to a\n  lesser degree memory consumption and introspection of Maps. Memory consumption\n  size is probalistic but lesser than `gb_trees` or `dict` for instance. Any\n  other impacts will be transparent for the user except for the following\n  changes.\n\n  Semantics of Maps have changed in two incompatible ways compared to the\n  experimental implementation in OTP 17:\n\n  - Hashing of maps is done different by `erlang:phash2/1,2`, `erlang:phash/1`\n    and `erlang:hash/2`.\n  - Comparing two maps with ==, /=, =<, <, >= and >, is done different if the\n    keys contain floating point numbers.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12585\n\n- Scalability improvement for `erlang:make_ref/0`, and other functionality that\n  create references. Each scheduler now manage its own set of references. By\n  this no communication at all is needed when creating references.\n\n  Previous implementation generated a strictly monotonically increasing sequence\n  of references corresponding to creation time on the runtime system instance.\n  This is _not_ the case with current implementation. You can only expect\n  reference to be unique. The Erlang/OTP documentation has never mentioned\n  anything else but the uniqueness property, so this change _is_ fully\n  compatible. The only reason we've marked this as a potential incompatibility\n  is since an early draft for an Erlang specification mentions strict\n  monotonicity as a property.\n\n  If you need to create data with a strict monotonicity property use\n  [erlang:unique_integer(\\[monotonic])](`erlang:unique_integer/1`). Do _not_ use\n  the deprecated [erlang:now()](`erlang:now/0`).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12610\n\n- Enable different abort signal from heart\n\n  By using environment variable HEART_KILL_SIGNAL, heart can now use a different\n  signal to kill the old running Erlang.\n\n  By default the signal is SIGKILL but SIGABRT may also be used by setting\n  environment variable: HEART_KILL_SIGNAL=SIGABRT\n\n  Own Id: OTP-12613 Aux Id: seq12826\n\n- Update autconf to latest version 2015-03-04\n\n  Own Id: OTP-12646\n\n- Optimization of timers internally in the VM. This include process timers\n  (`receive ... after`), port timers (`driver_set_timer()`) as well as BIF\n  timers (`erlang:send_after()`/`erlang:start_timer()`).\n\n  Each scheduler thread now has its own lock-free timer service instead of one\n  locked central service. This dramatically improves performance of timer\n  management on systems with a large amount of schedulers and timers.\n\n  The timer service internal data structure has also been optimized to be able\n  to handle more timers than before. That is, each timer service is by its self\n  able to handle more timers without dramatic performance loss than the old\n  centralized timer service.\n\n  The API of BIF timers has also been extended. Timeout values are for example\n  no longer limited to 32-bit integers. For more information see the\n  documentation of `erlang:start_timer/4`, `erlang:send_after/4`,\n  `erlang:cancel_timer/2`, and `erlang:read_timer/2`.\n\n  Characteristics impact: Calls to the synchronous versions of\n  `erlang:cancel_timer()`, and `erlang:read_timer()` may take substantially\n  longer time to complete than before. This occur when the timer that is\n  accessed is managed by a remote scheduler. You typically want to use the new\n  asynchronous option in order to avoid blocking the calling process.\n\n  Own Id: OTP-12650 Aux Id: OTP-11997\n\n- Specialize instructions from common assembler patterns\n\n  Specialize common instructions of `rem`, `band`, `minus` and `plus` in the\n  beam loader. This will reduce the number of fetches and thus lessen the\n  instruction dispatch pressure during runtime and speed up those operations in\n  some common cases.\n\n  Specialize move patterns from x-registers to the stack with a new\n  `move_window` instruction. This change will reduce instruction dispatch\n  pressure.\n\n  Own Id: OTP-12690\n\n- Fix cross compilation for Android.\n\n  Own Id: OTP-12693\n\n- Fix incorrect use of autoconf macro AC_EGREP_CPP, which could cause faulty\n  configuration if run from a path containing the string 'yes'.\n\n  Own Id: OTP-12706\n\n- Minimal Java version is now 1.6\n\n  Own Id: OTP-12715\n\n- Send format and args on process exit to error_logger\n\n  Previously, the emulator would generate a whole string with values and call\n  the error_logger passing `\"~s~n\"`. This changes it to a format string\n  containing `~p` with the respective values as arguments.\n\n  Own Id: OTP-12735\n\n- Map error logger warnings to warning messages by default.\n\n  Own Id: OTP-12755\n\n- Configure architecture ppc64le architecture as a ppc64\n\n  Own Id: OTP-12761\n\n- Add function `enif_raise_exception` to allow a NIF to raise an error exception\n  with any type of reason.\n\n  Own Id: OTP-12770\n\n- Optimized node table statistics retrieval.\n\n  Own Id: OTP-12777\n\n- Map beam error logger warnings to warning messages by default. Previously\n  these messages were mapped to the error channel by default.\n\n  Own Id: OTP-12781\n\n- gen_tcp:shutdown/2 is now asynchronous\n\n  This solves the following problems with the old implementation:\n\n  It doesn't block when the TCP peer is idle or slow. This is the expected\n  behaviour when shutdown() is called: the caller needs to be able to continue\n  reading from the socket, not be prevented from doing so.\n\n  It doesn't truncate the output. The current version of gen_tcp:shutdown/2 will\n  truncate any outbound data in the driver queue after about 10 seconds if the\n  TCP peer is idle of slow. Worse yet, it doesn't even inform anyone that the\n  data has been truncated: 'ok' is returned to the caller; and a FIN rather than\n  an RST is sent to the TCP peer.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12797\n\n- Introduced delayed node table GC. This in order to avoid oscillation of\n  entries in and out of the tables. The oscillation caused unnecessary lock\n  contention on the table locks. The delay length can be set by passing the\n  [`+zdntgc`](erl_cmd.md#%2Bzdntgc) command line argument.\n\n  Characteristics impact: The tables can grow to very large sizes with unused\n  entries if the node is get huge amounts of short lived connections from other\n  nodes. This problem can be alleviated by shortening the length of the delay\n  using the `+zdntgc` command line argument.\n\n  Own Id: OTP-12802\n\n- Improved implementation of [`erlang:statistics`](`erlang:statistics/1`)`(io)`\n  in order to reduce contention between schedulers.\n\n  Characteristics impact: The actual call to `erlang:statistics(io)` takes\n  longer time to complete, but the overall impact on the system is improved.\n\n  Own Id: OTP-12842\n\n- There are many cases where user code needs to be able to distinguish between a\n  socket that was closed normally and one that was aborted. Setting the option\n  \\{show_econnreset, true\\} enables the user to receive ECONNRESET errors on\n  both active and passive sockets.\n\n  Own Id: OTP-12843\n\n- Do not preallocate too large event pool\n\n  A default pool size of 4000 is too excessive for the common case. This\n  corresponds directly to the number of threads in the system. Change\n  ERTS_TS_EV_ALLOC_DEFAULT_POOL_SIZE to 2048. Change ERTS_TS_EV_ALLOC_POOL_SIZE\n  to 32.\n\n  Own Id: OTP-12849","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 6.4.1.7 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-4-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- A process communicating with a port via one of the `erlang:port_*` BIFs could\n  potentially end up in an inconsistent state if the port terminated during the\n  communication. When this occurred the process could later block in a `receive`\n  even though it had messages matching in its message queue.\n\n  This bug was introduced in erts version 5.10 (OTP R16A).\n\n  Own Id: OTP-13424 Aux Id: OTP-10336\n\n- Calls to `erl_drv_send_term()` or `erl_drv_output_term()` from a non-scheduler\n  thread while the corresponding port was invalid caused the emulator to enter\n  an inconsistent state which eventually caused an emulator crash.\n\n  Own Id: OTP-13866\n\n- Driver and NIF operations accessing processes or ports could cause an emulator\n  crash when used from non-scheduler threads. Those operations are:\n\n  - `erl_drv_send_term()`\n  - `driver_send_term()`\n  - `erl_drv_output_term()`\n  - `driver_output_term()`\n  - `enif_send()`\n  - `enif_port_command()`\n\n  Own Id: OTP-13869\n\n- Fix bug in `binary_to_term` for binaries created by `term_to_binary `with\n  option `compressed`. The bug can cause `badarg` exception for a valid binary\n  when Erlang VM is linked against a `zlib` library of version 1.2.9 or newer.\n  Bug exists since OTP 17.0.\n\n  Own Id: OTP-14159 Aux Id: ERL-340\n\n- Fixed bug in operator `bxor` causing erroneuos result when one operand is a\n  big _negative_ integer with the lowest `N*W` bits as zero and the other\n  operand not larger than `N*W` bits. `N` is an integer of 1 or larger and `W`\n  is 32 or 64 depending on word size.\n\n  Own Id: OTP-14514\n\n- Fixed bug in `binary_to_term` and `binary_to_atom` that could cause VM crash.\n  Typically happens when the last character of an UTF8 string is in the range\n  128 to 255, but truncated to only one byte. Bug exists in `binary_to_term`\n  since ERTS version 5.10.2 (OTP_R16B01) and `binary_to_atom` since ERTS version\n  9.0 (OTP-20.0).\n\n  Own Id: OTP-14590 Aux Id: ERL-474","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.4.1.6 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-4-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- When calling `garbage_collect/[1,2]` or `check_process_code/[2,3]` from a\n  process with a higher priority than the priority of the process operated on,\n  the run queues could end up in an inconsistent state. This bug has now been\n  fixed.\n\n  Own Id: OTP-13298 Aux Id: OTP-11388","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.4.1.5 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-4-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fixed a bug that could cause a crash dump to become almost empty.\n\n  Own Id: OTP-13150","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.4.1.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-4-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The 'raw' socket option could not be used multiple times in one call to any\n  e.g gen_tcp function because only one of the occurrences were used. This bug\n  has been fixed, and also a small bug concerning propagating error codes from\n  within inet:setopts/2.\n\n  Own Id: OTP-11482 Aux Id: seq12872","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.4.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- The VTS mode in Common Test has been modified to use a private version of the\n  Webtool application (ct_webtool).\n\n  Own Id: OTP-12704 Aux Id: OTP-10922","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.4 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix missing quotation in the `LM_FIND_EMU_CC` `autoconf` macro which could\n  cause build failures.\n\n  Own Id: OTP-12388\n\n- Fix erroneous printout of monitors in crashdump file.\n\n  Own Id: OTP-12537\n\n- The runtime system without SMP support could crash in the BIF\n  [`port_control/3`](`port_control/3`) if the port that was being accessed died\n  during the call to the BIF.\n\n  Own Id: OTP-12544 Aux Id: Seq12777\n\n- Avoid corrupt oversized integer to be created from binary matching. Instead\n  throw system_limit exception which is the correct behavior. A peculiar symptom\n  of this bug was that bitwise operations (band, bor, bxor) on such oversized\n  integers could return the empty list []. Credit: Mikael Pettersson, Nico\n  Kruber\n\n  Own Id: OTP-12556\n\n- A race condition when calling `port_info/1` could cause a memory fault has\n  been fixed.\n\n  Own Id: OTP-12587\n\n- Fix comparison of exact terms. An overflow that could cause faulty comparisons\n  has been fixed. Comparison of exact terms is exclusively used within Maps.\n\n  Own Id: OTP-12623\n\n- Fix bug in [`list_to_integer/1`](`list_to_integer/1`) for very long lists that\n  could cause VM crash.\n\n  Own Id: OTP-12624","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Introduced a runtime system internal 64-bit API for atomic memory operations.\n\n  Own Id: OTP-12351\n\n- Add command line argument option for the initial size of process dictionaries.\n\n  Use '+hpds  ' to set initial process dictionary size for spawned\n  processes.\n\n  Own Id: OTP-12535 Aux Id: seq12809\n\n- Fix documentation on $char for Unicode\n\n  Own Id: OTP-12545","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 6.3.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix getifaddrs realloc pointer error\n\n  When a buffer was exhausted and subsequently reallocated, we could get an\n  unsafe pointer pointing to faulty memory.\n\n  For this to occur we would need to have a large number of interfaces and a\n  reallocation of memory to a lower addresses.\n\n  The symptom would be garbage returned from erlang:port_control(Port, 25, [])\n  (prim_inet:getifaddrs(Port) resulting in a badarg) or a segmentation fault.\n\n  Own Id: OTP-12445\n\n- Don't close all file descriptors twice in child_setup\n\n  The commit c2b4eab25c907f453a394d382c04cd04e6c06b49 introduced an error in\n  which child_setup erroneously tried to close all file descriptors twice.\n\n  Use closefrom() if available when closing all file descriptors.\n\n  The function closefrom() was only used in the vfork() case before but is now\n  also used in the fork() case if available.\n\n  Own Id: OTP-12446\n\n- During a crashdump all file descriptors are closed to ensure the closing of\n  the epmd port and to reserve a file descriptor for the crashdump file.\n\n  If a driver (third party library) cannot handle closing of sockets this could\n  result in a segmentation fault in which case a crashdump would not be\n  produced. This is now fixed by only closing inets sockets via an emergency\n  close callback to the driver and thus closing the epmd socket.\n\n  Own Id: OTP-12447","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.3 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix HiPE debug lock checking on OS X 64bit\n\n  Position-independent code is mandatory on OS X. We use r11 as an intermediate\n  register to fill BIF_P->hipe.bif_callee. This fixes the following error when\n  doing \\`make debug FLAVOR=smp\\`:\n\n  clang -cc1as: fatal error: error in backend: 32-bit absolute addressing is not\n  supported in 64-bit mode\n\n  Own Id: OTP-12188\n\n- Fix race bug that could cause VM crash in `erlang:port_get_data/1` if the port\n  was closed by a concurrent process. Also fix fatal bug if `port_set_data/2` is\n  called with a non-immediate data term. Both bugs exist since R16B01.\n\n  Own Id: OTP-12208\n\n- Correct make variable SSL_DED_LD_RUNTIME_LIBRARY_PATH when erl_xcomp_sysroot\n  ends with a slash.\n\n  Own Id: OTP-12216 Aux Id: seq12700\n\n- Fix two cases of unreachable code caused by false use of assignment operators.\n\n  Own Id: OTP-12222\n\n- Fix bug when hipe compiled code makes tail call to a BIF that disables GC\n  while trapping (sush as binary_to_list, list_to_binary, binary_to_term,\n  term_to_binary).\n\n  Own Id: OTP-12231\n\n- Fix bug when a migrated empty memory carrier is reused just before it should\n  be destroyed by the thread that created it.\n\n  Own Id: OTP-12249\n\n- Prevents compile-time errors in NIFs, when the compiler is instructed to treat\n  missing field initializers as errors, by adding an initializer for the new\n  options field which was added to ErlNifEntry for 17.3.\n\n  Own Id: OTP-12266\n\n- Fixed CPU topology detection on FreeBSD systems where Erlang/OTP is compiled\n  by new C compilers (including, but possibly not limited to, gcc 4.9 and\n  clang).\n\n  Own Id: OTP-12267\n\n- Use C99 function isfinite() instead of finite() when available on non GCC\n  compilers.\n\n  Own Id: OTP-12268\n\n- Fix bug on windows where an incorrect number of links could be returned when\n  doing file:read_file_info on a directory.\n\n  Own Id: OTP-12269\n\n- Fix rare bug when purging module on VM started with +Meamin.\n\n  Own Id: OTP-12273\n\n- Repair run_erl terminal window size adjustment sent from to_erl. This was\n  broken in OTP 17.0 which could lead to strange cursor behaviour in the to_erl\n  shell.\n\n  Own Id: OTP-12275 Aux Id: seq12739\n\n- Fixed bug on windows causing gen_tcp/udp to return an error when given an fd\n  to work with.\n\n  Own Id: OTP-12289\n\n- Fix various internal erts issues where negating a signed integer in C would\n  trigger undefined behavior. This fixes issues when dividing with bignums and\n  list_to_integer.\n\n  Own Id: OTP-12290\n\n- When flushing output to stdout on windows, the emulator could sometimes hang\n  indefinitely waiting for the flush to complete. This has been fixed.\n\n  Own Id: OTP-12291\n\n- Fix so that non-smp emulators with dirty scheduler support shows the correct\n  number of dirty schedulers when calling erlang:system_info(system_version).\n\n  Own Id: OTP-12295\n\n- Add `nif_version` to `erlang:system_info/1` in order to get the NIF API\n  version of the runtime system in a way similar to `driver_version`.\n\n  Own Id: OTP-12298\n\n- Fix bug that could cause the return value from dirty NIF with zero arity to be\n  treated as garbage, leading to VM crash.\n\n  Own Id: OTP-12300\n\n- Improve allocation carrier migration search logic. This will reduce the risk\n  of failed migrations that could lead to excess memory consumption. It will\n  also improve smp performance due to reduced memory contention on the migration\n  pool.\n\n  Own Id: OTP-12323","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ERTS Release Notes","doc":"- Introduced support for eager check I/O.\n\n  By default eager check I/O will be disabled, but this will most likely be\n  changed in OTP 18. When eager check I/O is enabled, schedulers will more\n  frequently check for I/O work. Outstanding I/O operations will however not be\n  prioritized to the same extent as when eager check I/O is disabled.\n\n  Eager check I/O can be enabled using the `erl` command line argument:\n  `+secio true`\n\n  Characteristics impact when enabled:\n\n  - Lower latency and smoother management of externally triggered I/O\n    operations.\n  - A slightly reduced priority of externally triggered I/O operations.\n\n  Own Id: OTP-12117\n\n- Fix erts .app-file\n\n  Own Id: OTP-12189\n\n- Add configure option --with-ssl-incl=PATH to support OpenSSL installations\n  with headers and libraries at different places.\n\n  Own Id: OTP-12215 Aux Id: seq12700\n\n- Optimization of atomic memory operations with release barrier semantics on\n  32-bit PowerPC when using the implementation included in OTP.\n\n  Own Id: OTP-12250\n\n- Minor adjustment of scheduler activation code making sure that an activation\n  of a scheduler is not prevented by its run-queue being non-empty. (Thanks to\n  Songlu Cai)\n\n  Own Id: OTP-12287\n\n- Improved support for atomic memory operations provided by the\n  [libatomic_ops](https://github.com/ivmai/libatomic_ops/) library. Most\n  importantly support for use of native double word atomics when implemented by\n  `libatomic_ops` (for example, implemented for ARM).\n\n  The\n  [`$ERL_TOP/HOWTO/INSTALL.md`](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_configuring_atomic-memory-operations-and-the-vm`)\n  document now also more clearly describes when you want to build together with\n  a `libatomic_ops` installation.\n\n  Own Id: OTP-12302\n\n- Add configure option --with-ssl-rpath to control which runtime library path to\n  use for dynamic linkage toward OpenSSL.\n\n  Own Id: OTP-12316 Aux Id: seq12753\n\n- Added systemd notify support to epmd\n\n  Own Id: OTP-12321","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Erts 6.2.1 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- Fix bug when an migrated empty memory carrier is reused just before it should\n  be destroyed by the thread that created it.\n\n  Own Id: OTP-12249\n\n- Repair run_erl terminal window size adjustment sent from to_erl. This was\n  broken in OTP 17.0 which could lead to strange cursor behaviour in the to_erl\n  shell.\n\n  Own Id: OTP-12275 Aux Id: seq12739","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erts 6.2 - ERTS Release Notes","doc":"","ref":"notes.html#erts-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ERTS Release Notes","doc":"- General documentation updates.\n\n  Own Id: OTP-12052\n\n- A bug in the VM code implementing sending of signals to ports could cause the\n  receiving port queue to remain in a busy state forever. When this state had\n  been reached, processes sending command signals to the port either got\n  suspended forever, or, if the `nosuspend` feature was used, always failed to\n  send to the port. This bug was introduced in ERTS version 5.10.\n\n  In order for this bug to be triggered on a port, one had to at least once\n  utilize the `nosuspend` functionality when passing a signal to the port. This\n  by either calling\n\n  - [`port_command(Port, Data, [nosuspend | Options])`](`erlang:port_command/3`),\n  - [`erlang:send(Port, {PortOwner, {command, Data}}, [nosuspend | Options])`](`erlang:send/3`),\n  - [`erlang:send_nosuspend(Port, {PortOwner, {command, Data}})`](`erlang:send_nosuspend/2`),\n    or\n  - [`erlang:send_nosuspend(Port, {PortOwner, {command, Data}}, Options)`](`erlang:send_nosuspend/3`).\n\n  Thanks Vasily Demidenok for reporting the issue, and Sergey Kudryashov for\n  providing a testcase.\n\n  Own Id: OTP-12082 Aux Id: OTP-10336\n\n- Fix size overflow bug at memory allocation. A memory allocation call, with an\n  insane size close to the entire address space, could return successfully as if\n  it had allocated just a few bytes. (Thanks to Don A. Bailey for reporting)\n\n  Own Id: OTP-12091\n\n- Fix various issues where negating a signed integer would trigger undefined\n  behaviour. This fixes issues in the enif_make_int64 interface and some edge\n  cases inside the erlang runtime system.\n\n  Own Id: OTP-12097\n\n- The documentation erroneously listed the [`+swct`](erl_cmd.md#%2Bswct) command\n  line argument under `+sws`.\n\n  Own Id: OTP-12102 Aux Id: OTP-10994\n\n- Profiling messages could be delivered out of order when profiling on\n  `runnable_procs` and/or `runnable_ports` using `erlang:system_profile/2`. This\n  bug was introduced in ERTS version 5.10.\n\n  Own Id: OTP-12105 Aux Id: OTP-10336\n\n- Various logging fixes, including: Add run queue index to the process dump in\n  crash dumps.  \n  Add thread index to enomem slogan when crashing.  \n  Remove error logger message for sending messages to old instances of the same\n  node.\n\n  Own Id: OTP-12115\n\n- Fix compiler warnings reported by LLVM\n\n  Own Id: OTP-12138\n\n- Correct conversion of `MIN_SMALL` by\n  [`list_to_integer/1`](`list_to_integer/1`) and\n  [`binary_to_integer/1`](`binary_to_integer/1`). The bug produced an\n  unnormalized bignum which can cause strange behavior such as comparing\n  different to a correct `MIN_SMALL` integer. The value `MIN_SMALL` is\n  `-(1 bsl 27) = -134217728` on a 32-bit VM and\n  `-(1 bsl 59) = -576460752303423488` on a 64-bit VM. (Thanks to Jesper Louis\n  Andersen, Mikael Pettersson