---
title: FAQ
weight: 6
aliases:
  - /contributing/faq/
---

## How to add a new open-source linter to `golangci-lint`

See [there](/docs/contributing/new-linters#how-to-add-a-public-linter-to-golangci-lint).

## How to add a new private linter to `golangci-lint`

See [there](/docs/contributing/new-linters#how-to-add-a-private-linter-to-golangci-lint).

## How to update an existing linter

We use [Dependabot](https://github.com/golangci/golangci-lint/blob/HEAD/.github/dependabot.yml) to update dependencies, including linters.  
The updates happen at least automatically once a week (Sunday 11am UTC).

No pull requests to update a linter will be accepted unless you are the author of the linter and specific changes are required.

## How to add a configuration option to an existing linter

Add a new field to the [linter settings struct](https://github.com/golangci/golangci-lint/blob/HEAD/pkg/config/linters_settings.go).  
Document it in [.golangci.next.reference.yml](https://github.com/golangci/golangci-lint/blob/HEAD/.golangci.next.reference.yml).  
Pass it to the linter.

## How to see `INFO` or `DEBUG` logs

See [tutorial about debugging](/docs/contributing/debug/).
