%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF"],
    "XMM2":  ["0x0101010101010101", "0x0101010101010101", "0x0101010101010101", "0x0101010101010101"],
    "XMM3":  ["0xFF000100FF01FF00", "0xFF000100FF01FF00", "0xFF000100FF01FF00", "0xFF000100FF01FF00"],
    "XMM4":  ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x0101010101010101", "0x0101010101010101", "0x0101010101010101", "0x0101010101010101"],
    "XMM6":  ["0x0101010101010101", "0x0101010101010101", "0x0101010101010101", "0x0101010101010101"],
    "XMM7":  ["0x0100010001010100", "0x0100010001010100", "0x0100010001010100", "0x0100010001010100"],
    "XMM8":  ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0x0101010101010101", "0x0101010101010101", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0x0101010101010101", "0x0101010101010101", "0x0000000000000000", "0x0000000000000000"],
    "XMM11": ["0x0100010001010100", "0x0100010001010100", "0x0000000000000000", "0x0000000000000000"],
    "XMM12": ["0x0101010101010101", "0x0101010101010101", "0x0101010101010101", "0x0101010101010101"],
    "XMM13": ["0x0101010101010101", "0x0101010101010101", "0x0000000000000000", "0x0000000000000000"],
    "XMM14": ["0x0101010101010101", "0x0101010101010101", "0x0101010101010101", "0x0101010101010101"],
    "XMM15": ["0x0101010101010101", "0x0101010101010101", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovaps ymm1, [rdx + 32 * 1]
vmovaps ymm2, [rdx + 32 * 2]
vmovaps ymm3, [rdx + 32 * 3]

; Test with full zero
vpabsb ymm4, [rdx + 32 * 0]
vpabsb xmm8, [rdx + 32 * 0]

; Test with full negative
vpabsb ymm5, [rdx + 32 * 1]
vpabsb xmm9, [rdx + 32 * 1]
vpabsb ymm12, ymm1
vpabsb xmm13, xmm1

; Test with full positive
vpabsb ymm6, [rdx + 32 * 2]
vpabsb xmm10, [rdx + 32 * 2]
vpabsb ymm14, ymm2
vpabsb xmm15, xmm2

; Test a mix
vpabsb ymm7, [rdx + 32 * 3]
vpabsb xmm11, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000

dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

dq 0x0101010101010101
dq 0x0101010101010101
dq 0x0101010101010101
dq 0x0101010101010101

dq 0xFF000100FF01FF00
dq 0xFF000100FF01FF00
dq 0xFF000100FF01FF00
dq 0xFF000100FF01FF00
