import PropTypes from "prop-types";
export var registry = PropTypes.shape({
  ArrayFieldTemplate: PropTypes.elementType,
  FieldTemplate: PropTypes.elementType,
  ObjectFieldTemplate: PropTypes.elementType,
  definitions: PropTypes.object.isRequired,
  rootSchema: PropTypes.object,
  fields: PropTypes.objectOf(PropTypes.elementType).isRequired,
  formContext: PropTypes.object.isRequired,
  widgets: PropTypes.objectOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object])).isRequired
});
export var fieldProps = {
  autofocus: PropTypes.bool,
  disabled: PropTypes.bool,
  errorSchema: PropTypes.object,
  formData: PropTypes.any,
  idSchema: PropTypes.object,
  onBlur: PropTypes.func,
  onChange: PropTypes.func.isRequired,
  onFocus: PropTypes.func,
  rawErrors: PropTypes.arrayOf(PropTypes.string),
  readonly: PropTypes.bool,
  registry: registry.isRequired,
  required: PropTypes.bool,
  schema: PropTypes.object.isRequired,
  uiSchema: PropTypes.shape({
    "ui:options": PropTypes.shape({
      addable: PropTypes.bool,
      orderable: PropTypes.bool,
      removable: PropTypes.bool
    })
  })
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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