import { ServerConnection } from '../serverconnection';
/**
 * The url for the terminal service.
 */
export declare const TERMINAL_SERVICE_URL = "api/terminals";
/**
 * Whether the terminal service is available.
 */
export declare function isAvailable(): boolean;
/**
 * The server model for a terminal session.
 */
export interface IModel {
    /**
     * The name of the terminal session.
     */
    readonly name: string;
}
/**
 * Start a new terminal session.
 *
 * @param settings - The server settings to use.
 *
 * @param name - The name of the target terminal.
 *
 * @param cwd - The path in which the terminal will start.
 *
 * @returns A promise that resolves with the session model.
 */
export declare function startNew(settings?: ServerConnection.ISettings, name?: string, cwd?: string): Promise<IModel>;
/**
 * List the running terminal sessions.
 *
 * @param settings - The server settings to use.
 *
 * @returns A promise that resolves with the list of running session models.
 */
export declare function listRunning(settings?: ServerConnection.ISettings): Promise<IModel[]>;
/**
 * Shut down a terminal session by name.
 *
 * @param name - The name of the target session.
 *
 * @param settings - The server settings to use.
 *
 * @returns A promise that resolves when the session is shut down.
 */
export declare function shutdownTerminal(name: string, settings?: ServerConnection.ISettings): Promise<void>;
