/*
 The MIT License

 Copyright (c) 2010-2020 Paul R. Holser, Jr.

 Permission is hereby granted, free of charge, to any person obtaining
 a copy of this software and associated documentation files (the
 "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish,
 distribute, sublicense, and/or sell copies of the Software, and to
 permit persons to whom the Software is furnished to do so, subject to
 the following conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package com.pholser.junit.quickcheck.test.generator;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;

public class APair extends ComponentizedGenerator<Pair> {
    private X x;

    public APair() {
        super(Pair.class);
    }

    @Override public Pair<?, ?> generate(
        SourceOfRandomness random,
        GenerationStatus status) {

        return new Pair<>(
            componentGenerators().get(0).generate(random, status),
            componentGenerators().get(1).generate(random, status),
            x != null);
    }

    @Override public int numberOfNeededComponents() {
        return 2;
    }

    @Override public BigDecimal magnitude(Object value) {
        Pair<?, ?> narrowed = narrow(value);

        return componentGenerators().get(0).magnitude(narrowed.first())
            .multiply(componentGenerators().get(1).magnitude(narrowed.second()));
    }

    public void configure(X x) {
        this.x = x;
    }
}
