/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.model;

import java.beans.ConstructorProperties;

public final class RegionSchema {
    private final String realmKey;
    private final String realmDomainComponent;
    private final String regionKey;
    private final String regionIdentifier;

    public static boolean isValid(RegionSchema regionSchema) {
        if (regionSchema.getRealmKey() == null || regionSchema.getRealmDomainComponent() == null || regionSchema.getRegionIdentifier() == null || regionSchema.getRegionKey() == null) {
            return false;
        }
        if (regionSchema.getRealmKey() != null && regionSchema.getRealmKey().isEmpty()) {
            return false;
        }
        if (regionSchema.getRegionIdentifier() != null && regionSchema.getRegionIdentifier().isEmpty()) {
            return false;
        }
        if (regionSchema.getRealmDomainComponent() != null && regionSchema.getRealmDomainComponent().isEmpty()) {
            return false;
        }
        return regionSchema.getRegionKey() == null || !regionSchema.getRegionKey().isEmpty();
    }

    @ConstructorProperties(value={"realmKey", "realmDomainComponent", "regionKey", "regionIdentifier"})
    public RegionSchema(String realmKey, String realmDomainComponent, String regionKey, String regionIdentifier) {
        this.realmKey = realmKey;
        this.realmDomainComponent = realmDomainComponent;
        this.regionKey = regionKey;
        this.regionIdentifier = regionIdentifier;
    }

    public String getRealmKey() {
        return this.realmKey;
    }

    public String getRealmDomainComponent() {
        return this.realmDomainComponent;
    }

    public String getRegionKey() {
        return this.regionKey;
    }

    public String getRegionIdentifier() {
        return this.regionIdentifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionSchema)) {
            return false;
        }
        RegionSchema other = (RegionSchema)o;
        String this$realmKey = this.getRealmKey();
        String other$realmKey = other.getRealmKey();
        if (this$realmKey == null ? other$realmKey != null : !this$realmKey.equals(other$realmKey)) {
            return false;
        }
        String this$realmDomainComponent = this.getRealmDomainComponent();
        String other$realmDomainComponent = other.getRealmDomainComponent();
        if (this$realmDomainComponent == null ? other$realmDomainComponent != null : !this$realmDomainComponent.equals(other$realmDomainComponent)) {
            return false;
        }
        String this$regionKey = this.getRegionKey();
        String other$regionKey = other.getRegionKey();
        if (this$regionKey == null ? other$regionKey != null : !this$regionKey.equals(other$regionKey)) {
            return false;
        }
        String this$regionIdentifier = this.getRegionIdentifier();
        String other$regionIdentifier = other.getRegionIdentifier();
        return !(this$regionIdentifier == null ? other$regionIdentifier != null : !this$regionIdentifier.equals(other$regionIdentifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realmKey = this.getRealmKey();
        result = result * 59 + ($realmKey == null ? 43 : $realmKey.hashCode());
        String $realmDomainComponent = this.getRealmDomainComponent();
        result = result * 59 + ($realmDomainComponent == null ? 43 : $realmDomainComponent.hashCode());
        String $regionKey = this.getRegionKey();
        result = result * 59 + ($regionKey == null ? 43 : $regionKey.hashCode());
        String $regionIdentifier = this.getRegionIdentifier();
        result = result * 59 + ($regionIdentifier == null ? 43 : $regionIdentifier.hashCode());
        return result;
    }

    public String toString() {
        return "RegionSchema(realmKey=" + this.getRealmKey() + ", realmDomainComponent=" + this.getRealmDomainComponent() + ", regionKey=" + this.getRegionKey() + ", regionIdentifier=" + this.getRegionIdentifier() + ")";
    }
}

