# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit findlib toolchain-funcs

DESCRIPTION="OCaml interface to the Tcl/Tk GUI framework"
HOMEPAGE="https://garrigue.github.io/labltk/"
SRC_URI="https://github.com/garrigue/${PN}/archive/${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="QPL-1.0 LGPL-2"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm ~arm64 ~hppa ~loong ~ppc ~ppc64 ~riscv ~x86 ~amd64-linux ~x86-linux"
IUSE="+ocamlopt X"

RDEPEND="dev-lang/tk:=
	>=dev-lang/ocaml-5:=[ocamlopt?,X(+)?]
	<dev-lang/ocaml-5.4"
DEPEND="${RDEPEND}
	dev-ml/findlib
"

PATCHES=(
	"${FILESDIR}"/${PN}-8.06.14-findlib.patch
	"${FILESDIR}"/${PN}-8.06.14-shuffle.patch
)

src_prepare() {
	sed -i \
		-e "s|ranlib|$(tc-getRANLIB)|" \
		frx/Makefile \
		|| die
	default
}

src_configure() {
	./configure --use-findlib --verbose $(usex X "--tk-x11" "--tk-no-x11") || die "configure failed!"
}

src_compile() {
	emake -j1 all
	use ocamlopt && emake -j1 opt
}

src_install() {
	findlib_src_preinst
	dodir /usr/bin
	emake \
		INSTALLDIR="${D}/$(ocamlc -where)/labltk" \
		INSTALLBINDIR="${ED}/usr/bin/" \
		RANLIB=$(tc-getRANLIB) \
		install
	dodoc Changes README.mlTk
}
