/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evoxml.util.XMLUnits;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;

public class NewickParser
extends AbstractXMLObjectParser {
    public static final String NEWICK = "newick";
    public static final String UNITS = "units";
    public static final String RESCALE_HEIGHT = "rescaleHeight";
    public static final String RESCALE_LENGTH = "rescaleLength";
    public static final String SCALE = "scale";
    public static final String USING_DATES = "usingDates";
    public static final String USING_HEIGHTS = "usingHeights";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("usingDates", true), AttributeRule.newBooleanRule("usingHeights", true), AttributeRule.newDoubleRule("rescaleHeight", true, "Attempt to rescale the tree to the given root height"), AttributeRule.newDoubleRule("rescaleLength", true, "Attempt to rescale the tree to the given total length"), AttributeRule.newDoubleRule("scale", true, "Attempt to rescale the branch lengths by a factor."), new StringAttributeRule("units", "The branch length units of this tree", Units.UNIT_NAMES, true), new ElementRule(String.class, "The NEWICK format tree. Tip labels are taken to be Taxon IDs")};

    @Override
    public String getParserName() {
        return NEWICK;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Serializable serializable;
        Object object;
        NodeRef nodeRef;
        int n;
        FlexibleTree flexibleTree;
        Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
        boolean bl = true;
        if (xMLObject.hasAttribute(USING_DATES)) {
            bl = xMLObject.getAttribute(USING_DATES, true);
        }
        boolean bl2 = false;
        if (xMLObject.hasAttribute(USING_HEIGHTS)) {
            bl2 = xMLObject.getAttribute(USING_HEIGHTS, true);
        }
        if (bl && bl2) {
            throw new XMLParseException("Unable to use both dates and node heights. Specify value of usingDates attribute.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            if (!(xMLObject.getChild(i) instanceof String)) {
                throw new XMLParseException("illegal element in newick element");
            }
            stringBuffer.append((String)xMLObject.getChild(i));
        }
        StringReader stringReader = new StringReader(stringBuffer.toString());
        NewickImporter newickImporter = new NewickImporter(stringReader);
        try {
            flexibleTree = (FlexibleTree)newickImporter.importTree(null);
        }
        catch (IOException iOException) {
            throw new XMLParseException("error parsing tree in newick element");
        }
        catch (NewickImporter.BranchMissingException branchMissingException) {
            throw new XMLParseException("branch missing in tree in newick element");
        }
        catch (Importer.ImportException importException) {
            throw new XMLParseException("error parsing tree in newick element - " + importException.getMessage());
        }
        if (flexibleTree == null) {
            throw new XMLParseException("Failed to read tree");
        }
        flexibleTree.setUnits(type);
        for (n = 0; n < flexibleTree.getNodeCount(); ++n) {
            nodeRef = flexibleTree.getNode(n);
            if (!(flexibleTree.getBranchLength(nodeRef) < 0.0)) continue;
            throw new XMLParseException("Starting tree has one or more negative branch lengths");
        }
        for (n = 0; n < flexibleTree.getTaxonCount(); ++n) {
            nodeRef = (FlexibleNode)flexibleTree.getExternalNode(n);
            String string = ((FlexibleNode)nodeRef).getTaxon().getId();
            Taxon taxon = null;
            object = this.getStore().get(string);
            if (object != null && ((XMLObject)object).getNativeObject() instanceof Taxon) {
                taxon = (Taxon)((XMLObject)object).getNativeObject();
            }
            if (taxon == null) {
                throw new XMLParseException("unknown taxon, " + string + ", in newick tree");
            }
            ((FlexibleNode)nodeRef).setTaxon(taxon);
        }
        if (bl) {
            double d;
            int n2;
            double d2 = 0.0;
            boolean bl3 = true;
            for (n2 = 0; n2 < flexibleTree.getTaxonCount(); ++n2) {
                object = flexibleTree.getExternalNode(n2);
                serializable = (Date)flexibleTree.getTaxonAttribute(n2, "date");
                if (serializable == null) {
                    serializable = (Date)flexibleTree.getNodeAttribute(flexibleTree.getExternalNode(n2), "date");
                }
                d = 0.0;
                double d3 = flexibleTree.getNodeHeight((NodeRef)object);
                if (serializable != null) {
                    d = Taxon.getHeightFromDate(serializable);
                }
                double d4 = d - d3;
                if (n2 == 0) {
                    d2 = d4;
                } else if (Math.abs(d4 - d2) > 1.0E-5) {
                    bl3 = false;
                }
                flexibleTree.setNodeHeight((NodeRef)object, d);
            }
            if (bl3) {
                System.out.println("  Changing height of all nodes by " + d2);
                for (n2 = 0; n2 < flexibleTree.getInternalNodeCount(); ++n2) {
                    object = flexibleTree.getInternalNode(n2);
                    serializable = (Date)flexibleTree.getNodeAttribute((NodeRef)object, "date");
                    if (serializable != null) {
                        d = Taxon.getHeightFromDate(serializable);
                        flexibleTree.setNodeHeight((NodeRef)object, d);
                        continue;
                    }
                    if (!bl3) continue;
                    flexibleTree.setNodeHeight((NodeRef)object, flexibleTree.getNodeHeight((NodeRef)object) + d2);
                }
            }
            MutableTree.Utils.correctHeightsForTips(flexibleTree);
        } else if (!bl2) {
            System.out.println("Tree is assumed to be ultrametric");
            for (n = 0; n < flexibleTree.getTaxonCount(); ++n) {
                nodeRef = flexibleTree.getExternalNode(n);
                double d = flexibleTree.getNodeHeight(nodeRef);
                if (d == 0.0) continue;
                double d5 = 0.0;
                System.out.println("  Changing height of leaf node " + flexibleTree.getTaxon(nodeRef.getNumber()) + " from " + d + " to " + d5);
                flexibleTree.setNodeHeight(nodeRef, d5);
            }
        } else {
            System.out.println("Using node heights.");
        }
        if (xMLObject.hasAttribute(RESCALE_HEIGHT)) {
            double d = xMLObject.getDoubleAttribute(RESCALE_HEIGHT);
            double d6 = d / flexibleTree.getNodeHeight(flexibleTree.getRoot());
            for (int i = 0; i < flexibleTree.getInternalNodeCount(); ++i) {
                serializable = flexibleTree.getInternalNode(i);
                flexibleTree.setNodeHeight((NodeRef)serializable, flexibleTree.getNodeHeight((NodeRef)serializable) * d6);
            }
        }
        if (xMLObject.hasAttribute(RESCALE_LENGTH)) {
            double d = xMLObject.getDoubleAttribute(RESCALE_LENGTH);
            double d7 = d / TreeUtils.getTreeLength(flexibleTree, flexibleTree.getRoot());
            for (int i = 0; i < flexibleTree.getInternalNodeCount(); ++i) {
                serializable = flexibleTree.getInternalNode(i);
                flexibleTree.setNodeHeight((NodeRef)serializable, flexibleTree.getNodeHeight((NodeRef)serializable) * d7);
            }
        }
        if (xMLObject.hasAttribute(SCALE)) {
            double d = xMLObject.getDoubleAttribute(SCALE);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Scale must be greater than 0.");
            }
            for (int i = 0; i < flexibleTree.getInternalNodeCount(); ++i) {
                NodeRef nodeRef2 = flexibleTree.getInternalNode(i);
                flexibleTree.setNodeHeight(nodeRef2, flexibleTree.getNodeHeight(nodeRef2) * d);
            }
        }
        return flexibleTree;
    }

    @Override
    public String getParserDescription() {
        return "Constructs a tree from a NEWICK format tree description";
    }

    @Override
    public String getExample() {
        return "<" + this.getParserName() + " " + UNITS + "=\"" + Units.Utils.getDefaultUnitName(Units.Type.YEARS) + "\"> ((A:1.0, B:1.0):1.0,(C:2.0, D:2.0):1.0); </" + this.getParserName() + ">";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Class getReturnType() {
        return Tree.class;
    }
}

