/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ImageSelection
implements Transferable {
    private Image image;

    public ImageSelection(Image image) {
        this.image = image;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.imageFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.image;
    }

    public static ImageSelection setClipboard(Image image) {
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
        return imageSelection;
    }

    public static ImageSelection copyComponent(Component component, boolean bl, boolean bl2) {
        Dimension dimension = component.getSize();
        Image image = component.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl2) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }
        component.paint(graphics2D);
        return ImageSelection.setClipboard(image);
    }
}

