/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import java.util.Set;

public class BranchLengthStatistic
extends TreeStatistic {
    private Tree tree = null;
    private Set<String> leafSet = null;

    public BranchLengthStatistic(String string, Tree tree, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        if (taxonList == null) {
            throw new IllegalArgumentException("taxa cannot be null");
        }
        this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSet);
        if (nodeRef == null) {
            throw new RuntimeException("No node found that is MRCA of " + this.leafSet);
        }
        return this.tree.getBranchLength(nodeRef);
    }
}

