/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.cartogram;

import dr.util.FileHelpers;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class CartogramMapping {
    public static final String CARTOGRAM_OUTPUT = "cartogram";
    private Rectangle2D boundingBox;
    private int gridXSize;
    private int gridYSize;
    private double dX;
    private double dY;
    private Point2D[][] gridPt;
    private boolean loaded = false;
    private double averageDensity = 1.0;

    public CartogramMapping(int n, int n2, Rectangle2D rectangle2D) {
        this.gridXSize = n;
        this.gridYSize = n2;
        this.boundingBox = rectangle2D;
        this.gridPt = new Point2D[n + 1][n2 + 1];
        this.dX = (rectangle2D.getMaxX() - rectangle2D.getMinX()) / (double)n;
        this.dY = (rectangle2D.getMaxY() - rectangle2D.getMinY()) / (double)n2;
    }

    public double getAverageDensity() {
        return this.averageDensity;
    }

    public void setAverageDensity(double d) {
        this.averageDensity = d;
    }

    public void readCartogramOutput(String string) throws IOException {
        this.readCartogramOutput(FileHelpers.getFile(string));
    }

    public void readCartogramOutput(File file) throws IOException {
        BufferedReader bufferedReader = file.getName().endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new FileReader(file));
        for (int i = 0; i <= this.gridYSize; ++i) {
            for (int j = 0; j <= this.gridXSize; ++j) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    throw new IOException("Premature end of file in '" + file + "'");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                try {
                    double d = Double.parseDouble(stringTokenizer.nextToken());
                    double d2 = Double.parseDouble(stringTokenizer.nextToken());
                    this.gridPt[j][i] = new Point2D.Double(d, d2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Unable to parse line: " + string + " in '" + file + "'");
                }
            }
        }
        bufferedReader.close();
        this.loaded = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("grid: [x=" + this.gridXSize + ",y=" + this.gridYSize + "], boundingBox: " + this.boundingBox.toString());
        return stringBuilder.toString();
    }

    public Point2D map(Point2D point2D) {
        if (!this.boundingBox.contains(point2D)) {
            return null;
        }
        if (!this.loaded) {
            return point2D;
        }
        double d = (point2D.getX() - this.boundingBox.getMinX()) / this.dX;
        double d2 = (point2D.getY() - this.boundingBox.getMinY()) / this.dY;
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        assert (d3 >= 0.0 && d4 < 1.0 && d4 >= 0.0 && d4 < 1.0);
        Point2D point2D2 = this.gridPt[n][n2];
        Point2D point2D3 = this.gridPt[n + 1][n2];
        Point2D point2D4 = this.gridPt[n][n2 + 1];
        Point2D point2D5 = this.gridPt[n + 1][n2 + 1];
        double d5 = (1.0 - d3) * (1.0 - d4) * point2D2.getX() + d3 * (1.0 - d4) * point2D3.getX() + (1.0 - d3) * d4 * point2D4.getX() + d3 * d4 * point2D5.getX();
        double d6 = (1.0 - d3) * (1.0 - d4) * point2D2.getY() + d3 * (1.0 - d4) * point2D3.getY() + (1.0 - d3) * d4 * point2D4.getY() + d3 * d4 * point2D5.getY();
        return new Point2D.Double(d5, d6);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        String string = stringArray[2];
        CartogramMapping cartogramMapping = new CartogramMapping(n, n2, new Rectangle2D.Double(0.0, 0.0, n, n2));
        try {
            String string2;
            cartogramMapping.readCartogramOutput(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while ((string2 = bufferedReader.readLine()) != null && string2.length() != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                Point2D.Double double_ = new Point2D.Double(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()));
                System.out.println(cartogramMapping.map(double_));
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(-1);
        }
    }
}

