/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.stats.DiscreteStatistics;

public class BetaKDEDistribution
extends KernelDensityEstimatorDistribution {
    private double range;

    public BetaKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3) {
        super(doubleArray, d, d2, d3);
    }

    @Override
    public double getFromPoint() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getToPoint() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void processBounds(Double d, Double d2) {
        if (d == null || d2 == null || d2 - d <= 0.0) {
            throw new RuntimeException("BetaKDEDistribution must be bounded");
        }
        if (d > DiscreteStatistics.min(this.sample) || d2 < DiscreteStatistics.max(this.sample)) {
            throw new RuntimeException("Sample range outside bounds: " + DiscreteStatistics.min(this.sample) + " -> " + DiscreteStatistics.max(this.sample));
        }
        this.lowerBound = d;
        this.upperBound = d2;
        double[] dArray = this.sample;
        this.sample = new double[this.sample.length];
        this.range = d2 - d;
        for (int i = 0; i < this.N; ++i) {
            this.sample[i] = (dArray[i] - this.lowerBound) / this.range;
        }
    }

    @Override
    protected void setBandWidth(Double d) {
        if (d == null) {
            double d2 = DiscreteStatistics.stdev(this.sample);
            this.bandWidth = d2 * Math.pow(this.N, -0.4);
        } else {
            this.bandWidth = d;
        }
    }

    @Override
    protected double evaluateKernel(double d) {
        double d2 = (d - this.lowerBound) / this.range;
        double d3 = d2 / this.bandWidth - 1.0;
        double d4 = (1.0 - d2) / this.bandWidth - 1.0;
        if (d2 < 2.0 * this.bandWidth) {
            d3 = this.getRho(d2, this.bandWidth) - 1.0;
        } else if (d2 > 1.0 - 2.0 * this.bandWidth) {
            d4 = this.getRho(1.0 - d2, this.bandWidth) - 1.0;
        }
        double d5 = GammaFunction.lnGamma(d3 + d4 + 2.0) - GammaFunction.lnGamma(d3 + 1.0) - GammaFunction.lnGamma(d4 + 1.0);
        double d6 = 0.0;
        for (int i = 0; i < this.N; ++i) {
            d6 += Math.pow(this.sample[i], d3) * Math.pow(1.0 - this.sample[i], d4);
        }
        return d6 * Math.exp(d5) / (double)this.N / this.range;
    }

    private double getRho(double d, double d2) {
        return 2.0 * d2 * d2 + 2.5 - Math.sqrt(4.0 * d2 * d2 * d2 * d2 + 6.0 * d2 * d2 + 2.25 - d * d - d / d2);
    }

    public double sampleMean() {
        return DiscreteStatistics.mean(this.sample);
    }
}

