/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeTransform;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class SingleScalarTreeTransform
extends TreeTransform {
    private final Parameter scale;

    public SingleScalarTreeTransform(Parameter parameter) {
        super("singleScalarTreeTransform");
        parameter.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        this.scale = parameter;
        this.addVariable(parameter);
    }

    @Override
    public double transform(Tree tree, NodeRef nodeRef, double d) {
        if (tree.isExternal(nodeRef)) {
            return d;
        }
        double d2 = tree.getNodeHeight(tree.getRoot());
        return d2 - this.getScaleForNode(tree, nodeRef) * (d2 - d);
    }

    @Override
    protected double getScaleForNode(Tree tree, NodeRef nodeRef) {
        return this.scale.getParameterValue(0);
    }

    @Override
    public String getInfo() {
        return "Linear transform by " + this.scale.getId();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged(this.scale);
    }
}

