/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AffineTransformParser
extends AbstractXMLObjectParser {
    public static final String AFFINE_TRANSFORM = "affineTransform";
    private static final String DIMENSION = "dim";
    private static final String LOCATION = "location";
    private static final String SCALE = "scale";

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        double d;
        double d2 = xMLObject.hasAttribute(LOCATION) ? xMLObject.getDoubleAttribute(LOCATION) : 0.0;
        double d3 = d = xMLObject.hasAttribute(SCALE) ? xMLObject.getDoubleAttribute(SCALE) : 1.0;
        if (d <= 0.0) {
            throw new XMLParseException("The 'scale' attribute of the transform xml element must be greater than 0.");
        }
        Transform.ParsedTransform parsedTransform = new Transform.ParsedTransform();
        if (xMLObject.hasAttribute(DIMENSION)) {
            int n = xMLObject.getIntegerAttribute(DIMENSION);
            if (n < 1) {
                throw new XMLParseException("The 'dim' attribute of the transform xml element must be greater than 0.");
            }
            parsedTransform.transform = new Transform.Array(new Transform.AffineTransform(d2, d), n, null);
        } else {
            parsedTransform.transform = new Transform.AffineTransform(d2, d);
        }
        return parsedTransform;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newDoubleRule(LOCATION, true), AttributeRule.newDoubleRule(SCALE, true), AttributeRule.newIntegerRule(DIMENSION, true)};
    }

    @Override
    public String getParserDescription() {
        return "Computes: (parameter - location) / scale.";
    }

    @Override
    public Class getReturnType() {
        return Transform.ParsedTransform.class;
    }

    @Override
    public String getParserName() {
        return AFFINE_TRANSFORM;
    }
}

