/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.datatransfer;

import ch.randelshofer.quaqua.datatransfer.MimeTypeParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MimeTypeParameterList
implements Cloneable {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String rawdata) throws MimeTypeParseException {
        this.parse(rawdata);
    }

    public int hashCode() {
        int code = 0x2D82D82;
        String paramName = null;
        Enumeration enm = this.getNames();
        while (enm.hasMoreElements()) {
            paramName = (String)enm.nextElement();
            code += paramName.hashCode();
            code += this.get(paramName).hashCode();
        }
        return code;
    }

    public boolean equals(Object thatObject) {
        if (!(thatObject instanceof MimeTypeParameterList)) {
            return false;
        }
        MimeTypeParameterList that = (MimeTypeParameterList)thatObject;
        if (this.size() != that.size()) {
            return false;
        }
        String name = null;
        String thisValue = null;
        String thatValue = null;
        Set entries = this.parameters.entrySet();
        Iterator iterator = entries.iterator();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            thisValue = (String)entry.getValue();
            thatValue = (String)that.parameters.get(name);
            if (!(thisValue == null || thatValue == null ? thisValue != thatValue : !thisValue.equals(thatValue))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(String rawdata) throws MimeTypeParseException {
        int length = rawdata.length();
        if (length <= 0) return;
        int currentIndex = MimeTypeParameterList.skipWhiteSpace(rawdata, 0);
        int lastIndex = 0;
        if (currentIndex >= length) return;
        char currentChar = rawdata.charAt(currentIndex);
        while (currentIndex < length && currentChar == ';') {
            String value;
            boolean foundit;
            ++currentIndex;
            if ((currentIndex = MimeTypeParameterList.skipWhiteSpace(rawdata, currentIndex)) >= length) throw new MimeTypeParseException("Couldn't find parameter name");
            lastIndex = currentIndex;
            currentChar = rawdata.charAt(currentIndex);
            while (currentIndex < length && MimeTypeParameterList.isTokenChar(currentChar)) {
                currentChar = rawdata.charAt(++currentIndex);
            }
            String name = rawdata.substring(lastIndex, currentIndex).toLowerCase();
            if ((currentIndex = MimeTypeParameterList.skipWhiteSpace(rawdata, currentIndex)) >= length || rawdata.charAt(currentIndex) != '=') throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            ++currentIndex;
            if ((currentIndex = MimeTypeParameterList.skipWhiteSpace(rawdata, currentIndex)) >= length) throw new MimeTypeParseException("Couldn't find a value for parameter named " + name);
            currentChar = rawdata.charAt(currentIndex);
            if (currentChar == '\"') {
                lastIndex = ++currentIndex;
                if (currentIndex >= length) throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                foundit = false;
                while (currentIndex < length && !foundit) {
                    currentChar = rawdata.charAt(currentIndex);
                    if (currentChar == '\\') {
                        currentIndex += 2;
                        continue;
                    }
                    if (currentChar == '\"') {
                        foundit = true;
                        continue;
                    }
                    ++currentIndex;
                }
                if (currentChar != '\"') throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                value = MimeTypeParameterList.unquote(rawdata.substring(lastIndex, currentIndex));
                ++currentIndex;
            } else {
                if (!MimeTypeParameterList.isTokenChar(currentChar)) throw new MimeTypeParseException("Unexpected character encountered at index " + currentIndex);
                lastIndex = currentIndex;
                foundit = false;
                while (currentIndex < length && !foundit) {
                    currentChar = rawdata.charAt(currentIndex);
                    if (MimeTypeParameterList.isTokenChar(currentChar)) {
                        ++currentIndex;
                        continue;
                    }
                    foundit = true;
                }
                value = rawdata.substring(lastIndex, currentIndex);
            }
            this.parameters.put(name, value);
            if ((currentIndex = MimeTypeParameterList.skipWhiteSpace(rawdata, currentIndex)) >= length) continue;
            currentChar = rawdata.charAt(currentIndex);
        }
        if (currentIndex >= length) return;
        throw new MimeTypeParseException("More characters encountered in input than expected.");
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String name) {
        return (String)this.parameters.get(name.trim().toLowerCase());
    }

    public void set(String name, String value) {
        this.parameters.put(name.trim().toLowerCase(), value);
    }

    public void remove(String name) {
        this.parameters.remove(name.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            buffer.append("; ");
            String key = (String)keys.nextElement();
            buffer.append(key);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote((String)this.parameters.get(key)));
        }
        return buffer.toString();
    }

    public Object clone() {
        MimeTypeParameterList newObj = null;
        try {
            newObj = (MimeTypeParameterList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        newObj.parameters = (Hashtable)this.parameters.clone();
        return newObj;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static int skipWhiteSpace(String rawdata, int i) {
        int length = rawdata.length();
        if (i < length) {
            char c = rawdata.charAt(i);
            while (i < length && Character.isWhitespace(c)) {
                c = rawdata.charAt(++i);
            }
        }
        return i;
    }

    private static String quote(String value) {
        boolean needsQuotes = false;
        int length = value.length();
        for (int i = 0; i < length && !needsQuotes; ++i) {
            needsQuotes = !MimeTypeParameterList.isTokenChar(value.charAt(i));
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)((double)length * 1.5));
            buffer.append('\"');
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value;
    }

    private static String unquote(String value) {
        int valueLength = value.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
        boolean escaped = false;
        for (int i = 0; i < valueLength; ++i) {
            char currentChar = value.charAt(i);
            if (!escaped && currentChar != '\\') {
                buffer.append(currentChar);
                continue;
            }
            if (escaped) {
                buffer.append(currentChar);
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return buffer.toString();
    }
}

