/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.distance.DistanceMatrix;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;

public abstract class ClusteringTree
extends SimpleTree {
    protected DistanceMatrix distanceMatrix;
    protected int numClusters;
    protected SimpleNode[] clusters;
    protected SimpleNode newCluster;
    protected int besti;
    protected int abi;
    protected int bestj;
    protected int abj;
    protected int[] tipCount;
    protected int[] alias;
    protected double[][] distance;
    protected int minimumTaxa;

    public ClusteringTree(DistanceMatrix distanceMatrix, int n) {
        this.distanceMatrix = distanceMatrix;
        if (distanceMatrix.getTaxonCount() < n) {
            throw new IllegalArgumentException("less than " + n + " taxa in distance matrix");
        }
        this.init(distanceMatrix);
        while (true) {
            this.findNextPair();
            if (this.numClusters < n) break;
            this.newCluster();
        }
        this.finish();
    }

    protected double getDist(int n, int n2) {
        return this.distance[this.alias[n]][this.alias[n2]];
    }

    protected void init(DistanceMatrix distanceMatrix) {
        int n;
        this.numClusters = distanceMatrix.getTaxonCount();
        this.clusters = new SimpleNode[this.numClusters];
        this.distance = new double[this.numClusters][this.numClusters];
        for (n = 0; n < this.numClusters; ++n) {
            for (int i = 0; i < this.numClusters; ++i) {
                this.distance[n][i] = distanceMatrix.getElement(n, i);
            }
        }
        for (n = 0; n < this.numClusters; ++n) {
            this.clusters[n] = new SimpleNode();
            this.clusters[n].setTaxon(distanceMatrix.getTaxon(n));
        }
        this.alias = new int[this.numClusters];
        this.tipCount = new int[this.numClusters];
        for (n = 0; n < this.numClusters; ++n) {
            this.alias[n] = n;
            this.tipCount[n] = 1;
        }
    }

    protected void newCluster() {
        int n;
        this.newCluster = new SimpleNode();
        this.newCluster.setHeight(this.newNodeHeight());
        this.newCluster.addChild(this.clusters[this.abi]);
        this.newCluster.addChild(this.clusters[this.abj]);
        this.clusters[this.abi] = this.newCluster;
        this.clusters[this.abj] = null;
        for (n = 0; n < this.numClusters; ++n) {
            if (n == this.besti || n == this.bestj) continue;
            int n2 = this.alias[n];
            double d = this.updatedDistance(this.besti, this.bestj, n);
            this.distance[this.abi][n2] = d;
            this.distance[n2][this.abi] = d;
            this.distance[this.abj][n2] = -1.0;
            this.distance[n2][this.abj] = -1.0;
        }
        this.distance[this.abi][this.abi] = 0.0;
        this.distance[this.abj][this.abj] = -1.0;
        for (n = this.bestj; n < this.numClusters - 1; ++n) {
            this.alias[n] = this.alias[n + 1];
        }
        int n3 = this.abi;
        this.tipCount[n3] = this.tipCount[n3] + this.tipCount[this.abj];
        this.tipCount[this.abj] = 0;
        --this.numClusters;
    }

    protected void finish() {
        this.adoptNodes(this.newCluster);
        this.distance = null;
    }

    protected abstract void findNextPair();

    protected abstract double newNodeHeight();

    protected abstract double updatedDistance(int var1, int var2, int var3);
}

