/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Attribute;

public class DataSliceFromMatrixParameter
extends Parameter.Proxy
implements Attribute<double[]> {
    private final MatrixParameterInterface parameter;
    private final int slice;
    private final SliceDirection direction;

    public DataSliceFromMatrixParameter(MatrixParameterInterface matrixParameterInterface, int n, SliceDirection sliceDirection) {
        super(DataSliceFromMatrixParameter.makeParameterName(matrixParameterInterface, n, sliceDirection), sliceDirection.getLength(matrixParameterInterface));
        this.parameter = matrixParameterInterface;
        this.slice = n;
        this.direction = sliceDirection;
    }

    private static String makeParameterName(Parameter parameter, int n, SliceDirection sliceDirection) {
        return parameter.getParameterName() + "." + (n + 1) + "." + sliceDirection.name();
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.parameter.getBounds();
    }

    @Override
    public double getParameterValue(int n) {
        return this.direction.getValue(this.parameter, this.slice, n);
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.direction.setValue(this.parameter, this.slice, n, d);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.direction.setValueQuietly(this.parameter, this.slice, n, d);
    }

    @Override
    public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
        super.fireParameterChangedEvent(n, changeType);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    public static enum SliceDirection {
        ROW_WISE("rows"){

            @Override
            public double getValue(MatrixParameterInterface matrixParameterInterface, int n, int n2) {
                return matrixParameterInterface.getParameterValue(n, n2);
            }

            @Override
            public void setValue(MatrixParameterInterface matrixParameterInterface, int n, int n2, double d) {
                matrixParameterInterface.setParameterValue(n, n2, d);
            }

            @Override
            public void setValueQuietly(MatrixParameterInterface matrixParameterInterface, int n, int n2, double d) {
                matrixParameterInterface.setParameterValueQuietly(n, n2, d);
            }

            @Override
            public int getLength(MatrixParameterInterface matrixParameterInterface) {
                return matrixParameterInterface.getColumnDimension();
            }

            @Override
            public int getCount(MatrixParameterInterface matrixParameterInterface) {
                return matrixParameterInterface.getRowDimension();
            }
        }
        ,
        COLUMN_WISE("columns"){

            @Override
            public double getValue(MatrixParameterInterface matrixParameterInterface, int n, int n2) {
                return matrixParameterInterface.getParameterValue(n2, n);
            }

            @Override
            public void setValue(MatrixParameterInterface matrixParameterInterface, int n, int n2, double d) {
                matrixParameterInterface.setParameterValue(n2, n, d);
            }

            @Override
            public void setValueQuietly(MatrixParameterInterface matrixParameterInterface, int n, int n2, double d) {
                matrixParameterInterface.setParameterValueQuietly(n2, n, d);
            }

            @Override
            public int getLength(MatrixParameterInterface matrixParameterInterface) {
                return matrixParameterInterface.getRowDimension();
            }

            @Override
            public int getCount(MatrixParameterInterface matrixParameterInterface) {
                return matrixParameterInterface.getColumnDimension();
            }
        };

        private final String name;

        private SliceDirection(String string2) {
            this.name = string2;
        }

        public abstract double getValue(MatrixParameterInterface var1, int var2, int var3);

        public abstract void setValue(MatrixParameterInterface var1, int var2, int var3, double var4);

        public abstract void setValueQuietly(MatrixParameterInterface var1, int var2, int var3, double var4);

        public abstract int getLength(MatrixParameterInterface var1);

        public abstract int getCount(MatrixParameterInterface var1);

        public String getName() {
            return this.name;
        }
    }
}

