/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.LogisticGrowth;

public class ExponentialLogistic
extends LogisticGrowth {
    private double r2 = 0.1;
    private double time = 1.0;

    public ExponentialLogistic() {
    }

    public ExponentialLogistic(double N0, double r, double c, double time, double r2) {
        super(N0, r, c);
        this.r2 = r2;
        this.time = time;
    }

    public double getR2() {
        return this.r2;
    }

    public void setR2(double r2) {
        this.r2 = r2;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getDemographic(double t) {
        double transition_time = this.getTime();
        if (t < transition_time) {
            return super.getDemographic(t);
        }
        double r2 = this.getR2();
        double N1 = super.getDemographic(transition_time);
        return N1 * Math.exp(-r2 * (t - transition_time));
    }

    public double getIntensity(double t) {
        throw new UnsupportedOperationException();
    }

    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException();
    }

    public boolean hasIntegral() {
        return false;
    }

    public double getIntegral(double start, double finish) {
        throw new UnsupportedOperationException();
    }

    public int getArgumentCount() {
        return 4;
    }

    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "r2";
            }
            case 4: {
                return "t";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getShape();
            }
            case 3: {
                return this.getR2();
            }
            case 4: {
                return this.getTime();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    public void setArgument(int n, double value) {
        switch (n) {
            case 0: {
                this.setN0(value);
                break;
            }
            case 1: {
                this.setGrowthRate(value);
                break;
            }
            case 2: {
                this.setShape(value);
                break;
            }
            case 3: {
                this.setR2(value);
                break;
            }
            case 4: {
                this.setTime(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    public double getLowerBound(int n) {
        return 0.0;
    }

    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

