% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcObject.R
\name{writeMCMCObject}
\alias{writeMCMCObject}
\title{Write MCMC Object}
\usage{
writeMCMCObject(mcmc, file)
}
\arguments{
\item{mcmc}{MCMC object that has run the model fitting algorithm.}

\item{file}{A filename where the data will be stored.}
}
\value{
This function has no return value.
}
\description{
\code{writeMCMCObject} stores the MCMC information from the 
model fitting run in a file.
}
\examples{

## saving the MCMC object after model fitting
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- c(rep(1,floor(length(genome)/2)),rep(2,ceiling(length(genome)/2)))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE, 
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)
writeMCMCObject(mcmc = mcmc, file = file.path(tempdir(), "file.Rda"))

}
}
