% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.map}
\alias{arguments.map}
\title{Available map functions in BTSR package}
\arguments{
\item{map}{a non-negative integer from 1 to 5 corresponding to the map
function. Default is \code{map = 4}. See the Section \link[=arguments.map]{The map function}.}
}
\description{
This documentation describes the \code{map} argument in \link[=BARC.functions]{BARC}
models and the map functions implemented in the BTSR package.
}
\section{The map function}{
The map function \eqn{T:[0,1] \to [0,1]} in BARC models is a dynamical
system, i.e., a function, potentially depending on a \eqn{r}-dimensional
vector of parameters \eqn{\theta}. As for today, for all implemented maps,
\eqn{r = 1}.

Available choices are
\itemize{
\item \code{map = 1}, \eqn{\theta = k}, for \eqn{k} integer greater or equal to 2.
\deqn{T(u) = (ku)(\text{mod } 1)}

\item \code{map = 2}, \eqn{0 \le \theta \le 1}
\deqn{T(u) = \dfrac{u}{\theta}I( u < \theta) +
  \theta\dfrac{(u - \theta)}{(1 - \theta)}I(u \ge \theta)}

\item \code{map = 3} (logistic map), \eqn{ 0 \le \theta \le 4},
\deqn{T(u) = \theta(1-\theta)}

\item \code{map = 4} (Manneville-Pomeau map), \eqn{0 < \theta < 1}
\deqn{T(u) = (u + u^{1+\theta})(\text{mod } 1)}

\item \code{map = 5} (Lasota-Mackey's map),
\deqn{T(u) = \dfrac{u}{(1 - u)}I(u \le 0.5) + (2u - 1)I(u > 0.5)}
}
}

