% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_multreg.R
\name{ss_multreg}
\alias{ss_multreg}
\title{Sample Size Calculation for multiple regression analysis}
\usage{
ss_multreg(df, prop = NULL, logistic = FALSE, verbose = TRUE)
}
\arguments{
\item{df}{Degrees of freedom planned to be introduced}

\item{prop}{Minimum prevalence of the expected event (Required if planned regression is a logistic regression)}

\item{logistic}{Logical operator to indicate wether the planned regression analysis is a logistic regression or not.}

\item{verbose}{Logical operator to indicate wether the results should be printed in console. Default is \code{TRUE}}
}
\value{
An object class \code{ss_multreg_obj} indicating the sample size calculation for a regression analysis.
}
\description{
Calculates the recommended sample size for a multiple regression analysis.
}
\examples{

# Lineal multiple regression with 4 degrees of freedom
ss_multreg(4, logistic = FALSE)

# Logistic multiple regression with 4 degrees of freedom
# and 60\% of probability of the event

ss_multreg(4, prop = .6, logistic = TRUE)

}
\references{
Peduzzi P, Concato J, Kemper E, Holford TR, Feinstein AR. A simulation study of the number of events per variable in logistic regression analysis. Journal of Clinical Epidemiology. diciembre de 1996;49(12):1373–9.

Pierdant-Pérez M, Patiño-López MI, Flores-García JA, Jacques-García FA. Implementación de un curso virtual de lectura crítica en estudiantes de medicina durante la pandemia COVID-19. Inv Ed Med. el 1 de octubre de 2023;12(48):64–71.
}
