% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq.R
\name{compute_EQRN_seq_GPDLoss}
\alias{compute_EQRN_seq_GPDLoss}
\title{Generalized Pareto likelihood loss of a EQRN_seq predictor}
\usage{
compute_EQRN_seq_GPDLoss(
  fit_eqrn,
  X,
  Y,
  intermediate_quantiles = NULL,
  interm_lvl = fit_eqrn$interm_lvl,
  seq_len = fit_eqrn$seq_len,
  device = default_device()
)
}
\arguments{
\item{fit_eqrn}{Fitted \code{"EQRN_seq"} object.}

\item{X}{Matrix of covariates.}

\item{Y}{Response variable vector corresponding to the rows of \code{X}.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{seq_len}{Data sequence length (i.e. number of past observations) used to predict each response quantile.
By default, the training \code{fit_eqrn$seq_len} is used.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Negative GPD log likelihood of the conditional EQRN predicted parameters
over the response exceedances over the intermediate quantiles.
}
\description{
Generalized Pareto likelihood loss of a EQRN_seq predictor
}
