% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_age_gnfi3.R
\name{h_age_gnfi3}
\alias{h_age_gnfi3}
\title{Estimate Tree Height Growth With the 3rd German National Forest Inventory
Growth Model (2012)}
\usage{
h_age_gnfi3(species_id, age_yr, h_m_known, age_yr_known)
}
\arguments{
\item{species_id}{Vector of species id's preferably following the
\emph{ger_nfi_2012} species coding. Ideally, these species_id's are provided as
a \code{\link{fe_species_ger_nfi_2012}} object. See Details for how other
species codings are handled.}

\item{age_yr}{Single numeric value or vector of ages (in years) for which the
height is to be calculated}

\item{h_m_known}{Vector of known height (m) values at age
\code{age_yr_known}}

\item{age_yr_known}{Vector of ages (years) for which the height
\code{h_m_known} is known}
}
\value{
A single height value or vector of height values corresponding to
\code{age_yr}
}
\description{
Tree height growth model of the third German National Forest Inventory of
2012 \insertCite{bwi3_methods_2017}{ForestElementsR}. Allows to estimate a
tree's height at any age if its height is known at a given age.
}
\details{
Originally, the function was parameterized for species and species groups
corresponding to the national forest inventory's species coding
(\code{\link{fe_species_ger_nfi_2012}}). We have attributed in addition these
the original parameters also to the species codings
\code{\link{fe_species_tum_wwk_short}}, and
\code{\link{fe_species_bavrn_state_short}}. When called with a given species
coding, the function will try to use the "nearest" of these three
alternatives. Fallback option is the attempt to use
\code{\link{fe_species_tum_wwk_short}}.
}
\examples{
  # A European beech tree has a height of 25.2 m at age 75. Estimate
  # its height at age 83
  h_age_gnfi3(100, 83, 25.2, 75) # 100 is ger_nfi_2012 code for E. beech

  # Do the same backward in time, height at age 67
  h_age_gnfi3(100, 67, 25.2, 75)

  # Apply for more than one tree, different species, same age
  h_known   <- c(23.1, 16.2, 35.2, 19.3, 21.8)
  species   <- as_fe_species_tum_wwk_short(c(3, 3, 3, 6, 6))
  h_age_gnfi3(
    species, age_yr = 70, h_m_known = h_known, age_yr_known = 60
  )

}
\references{
\insertAllCited{}
}
\seealso{
Other growth functions: 
\code{\link{age_d_gnfi3}()},
\code{\link{age_h_gnfi3}()},
\code{\link{d_age_gnfi3}()}
}
\concept{growth functions}
