% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{site_index}
\alias{site_index}
\title{Find Site Indexes With a Yield Table}
\usage{
site_index(age, size, ytable, si_variable)
}
\arguments{
\item{age}{Age (years) of the stand to be site indexed}

\item{size}{Size value, typically a height (m), of the stand to be site
indexed. Must correspond to the parameter \code{si_variable} (see below)}

\item{ytable}{A yield table, must be an \code{fe_yield_table} object}

\item{si_variable}{Name of the stand size variable, typically a height (m),
to be used for site indexing. Must correspond to the parameter \code{size}
(see above). If  \code{si_variable} is not part of the yield table object's
slot \code{$site_index_variable}, the function will terminate with an
error.}
}
\value{
The site index resulting from \code{age} and \code{height}
}
\description{
Find Site Indexes With a Yield Table
}
\examples{
  site_index(72, 19.7, fe_ytable_pine_wiedemann_moderate_1943, "h_q_m")

}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
