% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{ytable_lookup}
\alias{ytable_lookup}
\title{Look Up Values From Yield Tables}
\usage{
ytable_lookup(age, si, variable, ytable)
}
\arguments{
\item{age}{Stand age (years)}

\item{si}{Site index (according to the yield table of interest's
(\code{ytable}) site index definition). If si is outside the yield table's
coverage, an extrapolated value is returned, and a warning is raised.}

\item{variable}{Name of the variable to be looked up. If the name is not
one of the variable names available in the \code{\link{fe_yield_table}}
object, the function will terminate with an error.}

\item{ytable}{A yield table, must be an \code{fe_yield_table} object}
}
\value{
The requested yield table value
}
\description{
Provide yield table values for a given age and site index. If necessary,
values are linearly inter- and extrapolated.
}
\examples{
  age <- 72
  si  <- 3.2

  ytable_lookup(
    age, si, "h_q_m", fe_ytable_spruce_gehrhardt_moderate_1921
  )

  ytable_lookup(
    age, si, "v_m3_ha", fe_ytable_spruce_gehrhardt_moderate_1921
  )

  ytable_lookup(
    age, si, "mai_m3_ha_yr", fe_ytable_spruce_gehrhardt_moderate_1921
  )


}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
