% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{eliminate_redundant_elements}
\alias{eliminate_redundant_elements}
\title{Eliminate Redundant Genomic Elements}
\usage{
eliminate_redundant_elements(input, element_type = "exon")
}
\arguments{
\item{input}{A data frame containing genomic element coordinates (exons or introns) with columns \code{seqnames}, \code{start}, \code{end}, and \code{gene_id}.}

\item{element_type}{The type of genomic element to process. Valid options are \code{"exon"} (default) or \code{"intron"}.}
}
\value{
A data frame with redundant elements removed, retaining only unique entries based on coordinates and gene ID.
}
\description{
Removes redundant genomic elements (exons or introns) from a data frame, ensuring each element is uniquely represented. Redundancy is determined by genomic coordinates and gene ID.
}
\details{
This function uses genomic coordinates (chromosome, start, end) and gene ID to identify and remove duplicate entries. For exons, coordinates are directly compared. For introns, coordinates are derived from \code{intron_start} and \code{intron_end} columns (check \code{extract_introns} function for more details)
}
\examples{
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
# Eliminate redundant exons
nonredundant_exons <- eliminate_redundant_elements(gtf_v1, element_type = "exon")

}
