% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skip_if_no_modules.R
\name{skip_if_no_modules}
\alias{skip_if_no_modules}
\title{Check if Python Modules are Available}
\usage{
skip_if_no_modules(module_names)
}
\arguments{
\item{module_names}{A vector of names of the Python modules to check.}
}
\value{
Nothing is returned explicitly, but if a specified module is not available, the function invokes \code{testthat::skip} to skip the tests that require that module.
}
\description{
This helper function checks if a list of Python modules are available. If any are not, it skips the tests.
}
\examples{
\donttest{
# Example usage within a test file:
module_names <- c("numpy", "pandas", "sklearn")
skip_if_no_modules(module_names)
}

}
