% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data.Curve-class.R,
%   R/RLum.Data.Image-class.R, R/RLum.Data.Spectrum-class.R,
%   R/RLum.Results-class.R
\name{set_RLum}
\alias{set_RLum}
\alias{set_RLum,RLum.Analysis-method}
\alias{set_RLum,RLum.Data.Curve-method}
\alias{set_RLum,RLum.Data.Image-method}
\alias{set_RLum,RLum.Data.Spectrum-method}
\alias{set_RLum,RLum.Results-method}
\title{General setter function for RLum-class objects}
\usage{
set_RLum(class, originator, .uid = create_UID(), .pid = NA_character_, ...)

\S4method{set_RLum}{RLum.Analysis}(
  class,
  originator,
  .uid,
  .pid,
  protocol = NA_character_,
  records = list(),
  info = list()
)

\S4method{set_RLum}{RLum.Data.Curve}(
  class,
  originator,
  .uid,
  .pid,
  recordType = NA_character_,
  curveType = NA_character_,
  data = matrix(0, ncol = 2),
  info = list()
)

\S4method{set_RLum}{RLum.Data.Image}(
  class,
  originator,
  .uid,
  .pid,
  recordType = "Image",
  curveType = NA_character_,
  data = array(),
  info = list()
)

\S4method{set_RLum}{RLum.Data.Spectrum}(
  class,
  originator,
  .uid,
  .pid,
  recordType = "Spectrum",
  curveType = NA_character_,
  data = matrix(),
  info = list()
)

\S4method{set_RLum}{RLum.Results}(class, originator, .uid, .pid, data = list(), info = list())
}
\arguments{
\item{class}{\link{character} (\strong{required}):
name of the S4 class to create, must correspond to one of the \linkS4class{RLum}
classes.}

\item{originator}{\link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\link{character} (\emph{automatic}):
unique ID for this object, by default set using the internal C++ function
\code{create_UID}.}

\item{.pid}{\link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{...}{further arguments passed to the specific class method}

\item{protocol}{\link{character} (\emph{optional}):
sets protocol type for analysis object. Value may be used by subsequent analysis functions.}

\item{records}{\link{list} (\emph{optional}):
list of \linkS4class{RLum.Analysis} objects}

\item{info}{\link{list} (\emph{optional}):
a list containing additional info data for the object.}

\item{recordType}{\link{character} (\emph{optional}):
record type (e.g., "OSL")}

\item{curveType}{\link{character} (\emph{optional}):
curve type (e.g., "predefined" or "measured")}

\item{data}{\link{matrix} or \link{list} (\emph{with default}):
a matrix containing raw curve data or a list containing the data to be
stored in the object (for \linkS4class{RLum.Results} objects) . If \code{data} itself
is a \code{RLum.Data.Curve}-object this can be used to re-construct the object,
i.e. modified parameters except \code{.uid}, \code{.pid} and \code{originator}. The rest
will be subject to copy and paste unless provided.}
}
\value{
An object of the specified \linkS4class{RLum} class.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the given class, the corresponding
method to create an object from this class will be selected.
}
\section{Functions}{
\itemize{
\item \code{set_RLum(RLum.Analysis)}: Construction method for \linkS4class{RLum.Analysis} objects.

\item \code{set_RLum(RLum.Data.Curve)}: Construction method for \linkS4class{RLum.Data.Curve} objects.

\item \code{set_RLum(RLum.Data.Image)}: Construction method for \linkS4class{RLum.Data.Image} objects.

\item \code{set_RLum(RLum.Data.Spectrum)}: Construction method for \linkS4class{RLum.Data.Spectrum} objects.

\item \code{set_RLum(RLum.Results)}: Construction method for \linkS4class{RLum.Results} objects.

}}
\section{Function version}{
 0.3.0
}

\examples{

## produce empty objects from each class
set_RLum(class = "RLum.Data.Curve")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Analysis")
set_RLum(class = "RLum.Results")

## produce a curve object with arbitrary curve values
object <- set_RLum(
class = "RLum.Data.Curve",
curveType = "arbitrary",
recordType = "OSL",
data = matrix(c(1:100,exp(-c(1:100))),ncol = 2))

## plot this curve object
plot_RLum(object)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. set_RLum(): General setter function for RLum-class objects. Function version 0.3.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
