% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blast.R
\name{filter_asv_blast}
\alias{filter_asv_blast}
\alias{filter_taxa_blast}
\title{Filter undesirable taxa using blast against a custom database.}
\usage{
filter_asv_blast(
  physeq,
  fasta_for_db = NULL,
  database = NULL,
  clean_pq = TRUE,
  add_info_to_taxtable = TRUE,
  id_filter = 90,
  bit_score_filter = 50,
  min_cover_filter = 50,
  e_value_filter = 1e-30,
  ...
)

filter_taxa_blast(
  physeq,
  fasta_for_db = NULL,
  database = NULL,
  clean_pq = TRUE,
  add_info_to_taxtable = TRUE,
  id_filter = 90,
  bit_score_filter = 50,
  min_cover_filter = 50,
  e_value_filter = 1e-30,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fasta_for_db}{path to a fasta file to make the blast database}

\item{database}{path to a blast database}

\item{clean_pq}{(logical)
If set to TRUE, empty samples and empty taxa (ASV, OTU) are discarded
after filtering.}

\item{add_info_to_taxtable}{(logical, default TRUE) Does the blast information
are added to the taxtable ?}

\item{id_filter}{(default: 90) cut of in identity percent to keep result}

\item{bit_score_filter}{(default: 50) cut of in bit score to keep result
The higher the bit-score, the better the sequence similarity.
The bit-score is the requires size of a sequence database in which the current
match could be found just by chance. The bit-score is a log2 scaled and
normalized raw-score. Each increase by one doubles the required database size
(2bit-score).}

\item{min_cover_filter}{(default: 50) cut of in query cover (\%) to keep result}

\item{e_value_filter}{(default: 1e-30)  cut of in e-value (\%) to keep result
The BLAST E-value is the number of expected hits of similar quality (score)
that could be found just by chance.}

\item{...}{Additional arguments passed on to\code{blast_pq()} function. See \code{?blast_pq}.
Note that params \code{unique_per_seq} must be left to TRUE and \code{score_filter}
must be left to FALSE.}
}
\value{
A new \code{\link[phyloseq]{phyloseq-class}} object.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Use the blast software.
}
