% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{MomCumSkewNorm}
\alias{MomCumSkewNorm}
\title{Moments and cumulants d-variate Skew Normal}
\usage{
MomCumSkewNorm(r = 4, omega, alpha, nMu = FALSE)
}
\arguments{
\item{r}{the highest moment and cumulant order}

\item{omega}{A \eqn{d \times d} correlation matrix}

\item{alpha}{shape parameter d-vector}

\item{nMu}{if it is TRUE then moments are calculated as well}
}
\value{
A list of theoretical moments and cumulants
}
\description{
Computes the theoretical values of moments and cumulants up to the r-th order.
Warning: if nMu = TRUE it can be very slow
}
\examples{
alpha<-c(10,5,0)
omega<-diag(3)
MomCumSkewNorm(r=4,omega,alpha)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 (5.5) p.247, Lemma 5.1 p. 246

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
