% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_datatable.R
\name{NasdaqDataLink.datatable}
\alias{NasdaqDataLink.datatable}
\title{Retrieves Data from the Nasdaq Data Link Datatable endpoint}
\usage{
NasdaqDataLink.datatable(datatable_code, paginate = FALSE, ...)
}
\arguments{
\item{datatable_code}{Datatable code on Nasdaq Data Link specified as a string.}

\item{paginate}{When set to TRUE, fetches up to 1,000,000 rows of data}

\item{...}{Additional named values that are interpreted as Nasdaq Data Link API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Retrieves Data from the Nasdaq Data Link Datatable endpoint
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
NasdaqDataLink.datatable('ZACKS/FC', paginate=TRUE)
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
