% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_adapters.R
\name{sql_adapter}
\alias{sql_adapter}
\title{Load Price Data from SQL Database}
\usage{
sql_adapter(
  db_path,
  symbols,
  start_date = NULL,
  end_date = NULL,
  auto_update = TRUE,
  frequency = "daily"
)
}
\arguments{
\item{db_path}{Path to SQLite database file}

\item{symbols}{Character vector of stock symbols to load}

\item{start_date}{Start date (YYYY-MM-DD) or NULL}

\item{end_date}{End date (YYYY-MM-DD) or NULL}

\item{auto_update}{Auto-update database before loading (default: TRUE)}

\item{frequency}{"daily", "weekly", or "monthly" (default: "daily")}
}
\value{
data.table with Date column and one column per symbol
}
\description{
Loads stock price data from SQLite database with automatic frequency conversion.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && file.exists("sp500.db")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
prices <- sql_adapter(
  db_path   = "sp500.db",
  symbols   = c("AAPL", "MSFT"),
  start_date = "2020-01-01",
  end_date   = "2020-12-31",
  frequency  = "weekly"
)
head(prices)
}
\dontshow{\}) # examplesIf}
}
