% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_objects.R
\name{sd}
\alias{sd}
\alias{sd.default}
\alias{sd.symbolic_interval}
\alias{sd.symbolic_tbl}
\title{Generic function for the standard desviation}
\usage{
sd(x, ...)

\method{sd}{default}(x, na.rm = FALSE, ...)

\method{sd}{symbolic_interval}(x, method = c("centers", "interval", "billard"), na.rm = FALSE, ...)

\method{sd}{symbolic_tbl}(x, ...)
}
\arguments{
\item{x}{A symbolic variable.}

\item{...}{As in R sd function.}

\item{na.rm}{As in R sd function.}

\item{method}{The method to be use.}
}
\value{
return a real number.
}
\description{
Compute the symbolic standard desviation.
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{sd}
