% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rationalMatrix.R
\name{QisInjective}
\alias{QisInjective}
\title{Check injectivity}
\usage{
QisInjective(M)
}
\arguments{
\item{M}{a matrix such that \code{as.character(Mij)} is 
a quoted integer or a quoted fraction for each entry \code{Mij}}
}
\value{
A Boolean value indicating whether the linear map corresponding to 
  \code{M} is injective.
}
\description{
Checks whether a rational matrix represents an injective linear 
  map (i.e. has trivial kernel).
}
\examples{
library(RationalMatrix)
set.seed(666L)
M <- matrix(rpois(35L, 1), 5L, 7L)
QisInjective(M)
}
