% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{unique_table_name}
\alias{unique_table_name}
\title{Create a name for a temporary table}
\usage{
unique_table_name(scope = "SCDB")
}
\arguments{
\item{scope}{(\code{character(1)})\cr
A naming scope to generate the table name within.}
}
\value{
A character string for a table name based on the given scope parameter
}
\description{
This function is heavily inspired by the unexported dbplyr function unique_table_name
}
\examples{
  print(unique_table_name()) # SCDB_<10 alphanumerical letters>
  print(unique_table_name()) # SCDB_<10 alphanumerical letters>

  print(unique_table_name("test")) # test_<10 alphanumerical letters>
  print(unique_table_name("test")) # test_<10 alphanumerical letters>

}
