% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plankton_toolbox.R
\name{get_peg_list}
\alias{get_peg_list}
\title{Get the latest EG-Phyto/PEG biovolume Excel list}
\usage{
get_peg_list(
  file = NULL,
  sheet = NULL,
  force = FALSE,
  url = "https://www.ices.dk/data/Documents/ENV/PEG_BVOL.zip",
  clean_cache_days = 30,
  verbose = TRUE
)
}
\arguments{
\item{file}{Character string specifying which file in the zip archive to read.
Defaults to the first Excel file in the archive.}

\item{sheet}{Character or numeric; the name or index of the sheet to read from the Excel file.
If neither argument specifies the sheet, defaults to the first sheet.}

\item{force}{Logical; if \code{TRUE}, forces re-download of the zip file even if a cached copy exists.}

\item{url}{Character string with the URL of the PEG zip file.
Defaults to the official ICES link.}

\item{clean_cache_days}{Numeric; if not \code{NULL}, cached PEG zip files older than
this number of days will be automatically deleted and replaced by a new download.
Defaults to 30. Set to \code{NULL} to disable automatic cleanup.}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}
}
\value{
A tibble with the contents of the requested Excel file.
}
\description{
This function downloads the EG-Phyto (previously PEG) biovolume zip archive from ICES (using
\code{cache_peg_zip()}), unzips it, and reads the first Excel file by default.
You can also specify which file in the archive to read.
}
\examples{
\donttest{
  # Read the first Excel file from the PEG zip
  peg_list <- get_peg_list()
  head(peg_list)
}
}
\seealso{
\code{\link[=clean_shark4r_cache]{clean_shark4r_cache()}} to manually clear cached files.
}
