% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoffs.R
\name{knockoffDMC}
\alias{knockoffDMC}
\title{Group knockoffs of discrete Markov chains}
\usage{
knockoffDMC(X, pInit, Q, groups = NULL, seed = 123, cluster = NULL,
  display_progress = FALSE)
}
\arguments{
\item{X}{an integer matrix of size n-by-p containing the original variables.}

\item{pInit}{an array of length K, containing the marginal distribution of the states for the first variable.}

\item{Q}{an array of size (p-1,K,K), containing a list of p-1 transition matrices between the K states of the Markov chain.}

\item{groups}{an array of length p, describing the group membership of each variable (default: NULL).}

\item{seed}{an integer random seed (default: 123).}

\item{cluster}{a computing cluster object created by \link[parallel]{makeCluster} (default: NULL).}

\item{display_progress}{whether to show progress bar (default: FALSE).}
}
\value{
An integer matrix of size n-by-p containing the knockoff variables.
}
\description{
This function constructs knockoffs of variables distributed as a discrete Markov chain.
}
\details{
Each element of the matrix X should be an integer value between 0 and K-1.
The transition matrices contained in Q are defined such that \eqn{P[X_{j+1}=k|X_{j}=l]=Q[j,l,k]}.
}
\examples{
# Generate data
p = 10; K = 5;
pInit = rep(1/K,K)
Q = array(stats::runif((p-1)*K*K),c(p-1,K,K))
for(j in 1:(p-1)) { Q[j,,] = Q[j,,] / rowSums(Q[j,,]) }
X = sampleDMC(pInit, Q, n=20)
# Generate knockoffs
Xk = knockoffDMC(X, pInit, Q)
# Generate group-knockoffs for groups of size 3
groups = rep(seq(p), each=3, length.out=p)
Xk = knockoffDMC(X, pInit, Q, groups=groups)

}
\references{
\insertRef{sesia2019}{SNPknock}
  \insertRef{sesia2019multi}{SNPknock}
}
\seealso{
Other knockoffs: \code{\link{knockoffGenotypes}},
  \code{\link{knockoffHMM}},
  \code{\link{knockoffHaplotypes}}
}
\concept{knockoffs}
