% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone-utils.r
\name{tz_time_diff}
\alias{tz_time_diff}
\title{Time difference between two time zones}
\usage{
tz_time_diff(
  when = lubridate::now(),
  tz.target = lubridate::tz(when),
  tz.reference = "UTC"
)
}
\arguments{
\item{when}{datetime A time instant}

\item{tz.target, tz.reference}{character Two time zones using names
recognized by functions from package 'lubridate'}
}
\value{
A \code{numeric} value.
}
\description{
Returns the difference in local time expressed in hours between two time
zones at a given instant in time. The difference due to daylight saving time
or Summer and Winter time as well as historical changes in time zones are
taken into account.
}
\note{
This function is implemented using functions from package 'lubridate'.
  For details on the handling of time zones, please, consult the
  documentation for \code{\link{Sys.timezone}} about system differences in
  time zone names and handling.
}
