% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_08_claim_inflation.R
\name{claim_payment_inflation}
\alias{claim_payment_inflation}
\title{Size of Partial Payments (With Inflation)}
\usage{
claim_payment_inflation(
  frequency_vector,
  payment_size_list,
  payment_time_list,
  occurrence_list,
  claim_size_list,
  base_inflation_vector,
  si_occurrence_function,
  si_payment_funtion
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the occurrence
periods.}

\item{payment_size_list}{(compound) list of payment size pattern (without
inflation).}

\item{payment_time_list}{(compound) list of payment times on a \strong{continuous}
time scale.}

\item{occurrence_list}{(compound) list of occurrence times on a
\strong{continuous} time scale.}

\item{claim_size_list}{list of claim sizes.}

\item{base_inflation_vector}{vector showing \strong{quarterly} base inflation
rates (quarterly effective) for all the periods under consideration (default
at nil base inflation).}

\item{si_occurrence_function}{function of \code{occurrence_time} and
\code{claim_size} that outputs the superimposed inflation index with respect
to claim occurrence time (see Details for the default inflation function).}

\item{si_payment_funtion}{function of \code{payment_time} and
\code{claim_size} that outputs the superimposed inflation index with respect
to payment time (see Details for the default inflation function).}
}
\description{
Converts the (compound) list of constant-dollar-value payment sizes to a
(compound) list of inflated payment sizes by applying inflation rates on a
continuous time scale. \cr \cr
Compare with \code{claim_payment_size()} which generates the constant dollar
amount of partial payment sizes. Note that the constant dollar values are as
of time 0.
}
\details{
Returns a compound list structure such that the \eqn{j}th component
of the \eqn{i}th sub-list gives the \strong{inflated} payment pattern (as a
vector) for the \eqn{j}th claim of occurrence period \eqn{i}. \cr \cr
By default we assume
\itemize{
\item Nil base inflation.
\item No superimposed inflation by (continuous) occurrence time for the first 20
quarters (converted to the relevant \code{time_unit}); beyond 20 quarters, the
inflation index is given by
\deqn{1 - 0.4 max(0, 1 - claim_size/(0.25 * ref_claim))}
where \code{ref_claim} is a package-wise global variable that user is required to
define at the top of their code using \code{\link{set_parameters}}. The
interpretation is that, due to some external change to the insurance scheme
at the end of occurrence quarter 20, the smallest claims will reduce by up to
40\% in size. This change will not impact claims exceeding \code{0.25*ref_claim} in
size. The reduction varies linearly between these claim sizes.
\item Superimposed inflation by (continuous) payment time operates at a period
rate of \deqn{\gamma * max(0, 1 - claim_size/ref_claim)} where \eqn{\gamma} is
equivalent to a 30\% p.a. inflation rate (converted to the relevant
\code{time_unit}). The interpretation is that, for claims of small size the
payment time superimposed inflation tends to be very high (30\% p.a.);
whereas for claims exceeding \code{ref_claim} in dollar values as of \eqn{t = 0},
the payment time superimposed inflation is nil. The rate of inflation
varies linearly between claim sizes of zero and \code{ref_claim}. \cr \cr
}

\strong{Remark on continuous inflation}: We note that \code{SynthETIC} works with
exact transaction times, so time has been measured continuously throughout
the program. This allows us to apply inflation on a continous time scale too.
For example, we asked the users to provide base inflation as a vector of
quarterly base inflation rates, quarterly effective for all the periods under
consideration. This data is generally available online (e.g. the Australian
quarterly inflation is available on RBA's website - see
\href{https://www.rba.gov.au/inflation/measures-cpi.html#quarterly}{link}). We
then interpolate the quarterly inflation rates to compute the addition of
inflation by exact times. In the case of above, if we observed quarterly
inflation rates of 0.6\%, 0.5\%, 0.7\% and 0.3\% for one particular year, then
the base inflation applied to a payment at time \eqn{t = 1.82} quarters will
be \eqn{1.006 * 1.005^{0.82}}.

\strong{Remark on out-of-bound payment times}: This function includes adjustment
for out-of-bound transaction dates, by forcing payments that were projected
to fall out of the maximum development period to be paid at the exact end of
the maximum development period allowed. For example, if we consider 40
periods of development and a claim incurred in the interval (20, 21] was
projected to have a payment at time 62.498210, then we would treat such a
payment as if it occurred at time 60 for the purpose of inflation.
}
\examples{
# remove SI occurrence and SI payment
SI_occurrence <- function(occurrence_time, claim_size) {1}
SI_payment <- function(payment_time, claim_size) {1}
# base inflation constant at 0.02 p.a. effective
# (length is 80 to cover the maximum time period)
base_inflation_vector <- rep((1 + 0.02)^(1/4) - 1, times = 80)
attach(test_claims_object)
payment_inflated_list <- claim_payment_inflation(
  frequency_vector, payment_size_list, payment_time_list,
  occurrence_list, claim_size_list, base_inflation_vector,
  SI_occurrence, SI_payment
)
detach(test_claims_object) # undo the attach
# inflated payments for claim 1 of occurrence period 1
payment_inflated_list[[1]][[1]]
}
