% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/free_bary_23L.R
\name{rbary23L}
\alias{rbary23L}
\title{Free-Support Barycenter by von Lindheim (2023)}
\usage{
rbary23L(atoms, marginals = NULL, weights = NULL)
}
\arguments{
\item{atoms}{a length-\eqn{K} list where each element is an \eqn{(N_k \times P)} matrix of atoms.}

\item{marginals}{marginal distributions for empirical measures; if \code{NULL} (default), uniform weights are set for all measures. Otherwise, it should be a length-\eqn{K} list where each element is a length-\eqn{N_i} vector of nonnegative weights that sum to 1.}

\item{weights}{weights for each individual measure; if \code{NULL} (default), each measure is considered equally. Otherwise, it should be a length-\eqn{K} vector.}
}
\value{
a list with two elements:
\describe{
  \item{support}{an \eqn{(N_1 \times P)} matrix of barycenter support points (same number of atoms as the first empirical measure).}
  \item{weight}{a length-\eqn{N_1} vector representing barycenter weights (copied from the first marginal).}
}
}
\description{
For a collection of empirical measures \eqn{\lbrace \mu_k\rbrace_{k=1}^K}, this 
function implements the free-support barycenter algorithm introduced by \insertCite{vonlindheim_2023_SimpleApproximativeAlgorithms;textual}{T4transport}.
The algorithm takes the first input and its marginal as a reference and performs one-step update of the support. 
This version implements `reference` algorithm with \eqn{p=2}.
}
\examples{
\donttest{
#-------------------------------------------------------------------
#     Free-Support Wasserstein Barycenter of Four Gaussians
#
# * class 1 : samples from Gaussian with mean=(-4, -4)
# * class 2 : samples from Gaussian with mean=(+4, +4)
# * class 3 : samples from Gaussian with mean=(+4, -4)
# * class 4 : samples from Gaussian with mean=(-4, +4)
#
#  The barycenter is computed using the first measure as a reference.
#  All measures have uniform weights.
#  The barycenter function also considers uniform weights.
#-------------------------------------------------------------------
## GENERATE DATA
#  Empirical Measures
set.seed(100)
unif4 = round(runif(4, 100, 200))
dat1 = matrix(rnorm(unif4[1]*2, mean=-4, sd=0.5),ncol=2)
dat2 = matrix(rnorm(unif4[2]*2, mean=+4, sd=0.5),ncol=2) 
dat3 = cbind(rnorm(unif4[3], mean=+4, sd=0.5), rnorm(unif4[3], mean=-4, sd=0.5))
dat4 = cbind(rnorm(unif4[4], mean=-4, sd=0.5), rnorm(unif4[4], mean=+4, sd=0.5))

myatoms = list()
myatoms[[1]] = dat1
myatoms[[2]] = dat2
myatoms[[3]] = dat3
myatoms[[4]] = dat4

## COMPUTE
fsbary = rbary23L(myatoms)

## VISUALIZE
#  aligned with CRAN convention
opar <- par(no.readonly=TRUE)

#  plot the input measures
plot(myatoms[[1]], col="gray90", pch=19, cex=0.5, xlim=c(-6,6), ylim=c(-6,6), main="Input Measures")
points(myatoms[[2]], col="gray90", pch=19, cex=0.5)
points(myatoms[[3]], col="gray90", pch=19, cex=0.5)
points(myatoms[[4]], col="gray90", pch=19, cex=0.5)

#  plot the barycenter
points(fsbary$support, col="red", cex=1.5)
par(opar)
}

}
\references{
\insertAllCited{}
}
\concept{free_bary}
