% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{get_partialdatetime}
\alias{get_partialdatetime}
\title{Parse \code{--DTC} variable and Determine Components}
\usage{
get_partialdatetime(dtc, create_datetime)
}
\arguments{
\item{dtc}{The \code{'--DTC'} date to parse

A character date is expected in a format like \code{yyyy-mm-dd} or
\code{yyyy-mm-ddThh:mm:ss}. Trailing components can be omitted and \code{-} is a
valid value for any component.

\describe{
\item{Default value}{none}
}}

\item{create_datetime}{logical scalar. If \code{TRUE} returns Datetime components.
If \code{FALSE} returns Date components.

\describe{
\item{Default value}{none}
}}
}
\value{
A list of character vectors. The elements of the list are named
"year", "month", "day", "hour", "minute", and "second". Missing components
are set to \code{NA_character_}.
}
\description{
Parse \code{--DTC} variable and Determine Components
}
\details{
The function can be replaced by the parttime parser once it is
available.
}
\examples{
# Datetime
# Get partial datetime components for a complete datetime string
dtc_complete <- admiral:::get_partialdatetime("2020-03-15T12:34:56", TRUE)
print(dtc_complete)

# Get partial datetime components for a partial datetime string
dtc_partial <- admiral:::get_partialdatetime("2020-03-15T12:34", TRUE)
print(dtc_partial)

# Get partial datetime components for a date-only string
dtc_date_only <- admiral:::get_partialdatetime("2020-03-15", TRUE)
print(dtc_date_only)

# Get partial datetime components for an incomplete year string
dtc_year_partial <- admiral:::get_partialdatetime("2020", TRUE)
print(dtc_year_partial)

# Date
# Get partial date components for a complete datetime string
dtc_complete <- admiral:::get_partialdatetime("2020-03-15T12:34:56", FALSE)
print(dtc_complete)

# Get partial date components for a partial datetime string
dtc_partial <- admiral:::get_partialdatetime("2020-03-15T12:34", FALSE)
print(dtc_partial)

# Get partial date components for a year and month only string
dtc_month_only <- admiral:::get_partialdatetime("2020-03", FALSE)
print(dtc_month_only)

# Get partial date components for an incomplete year string
dtc_year_partial <- admiral:::get_partialdatetime("2020", FALSE)
print(dtc_year_partial)

}
\seealso{
\code{\link[=impute_dtc_dtm]{impute_dtc_dtm()}}, \code{\link[=impute_dtc_dt]{impute_dtc_dt()}}

Utilities used for date imputation:
\code{\link{dt_level}()},
\code{\link{dtm_level}()},
\code{\link{get_imputation_target_date}()},
\code{\link{get_imputation_target_time}()},
\code{\link{restrict_imputed_dtc_dt}()},
\code{\link{restrict_imputed_dtc_dtm}()}
}
\concept{utils_impute}
\keyword{internal}
