% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.participants}
\alias{amber.participants}
\title{Get the participants}
\usage{
amber.participants(
  amber,
  study = NULL,
  interviewDesign = NULL,
  campaign = NULL,
  code = NULL,
  identifier = NULL,
  valid = NULL,
  query = list(),
  skip = 0,
  limit = 100,
  df = TRUE
)
}
\arguments{
\item{amber}{An Amber object}

\item{study}{Study identifier (name or id), optional.}

\item{interviewDesign}{Interview design identifier (name or id), optional.}

\item{campaign}{Campaign identifier (name or id), optional.}

\item{code}{Participant interview code, optional}

\item{identifier}{Participant identifier, optional}

\item{valid}{Participant is valid (logical): active and in the valid date range}

\item{query}{A search query}

\item{skip}{Number of items to skip}

\item{limit}{Max number of items}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
A data.frame (or a named list of raw results when 'df' is FALSE)
}
\description{
Get the participants of one or several interview design campaign(s).
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")

# Find all participants
amber.participants(a)

# Find all participants for a specific participant/patient study identifier
amber.participants(a, identifier = "1231")

# Find all participants which data is equal to some value
# (will not work if the data are encrypted in the database)
amber.participants(a, query = list(data.country = "fr"))

# Find the participants of a study interview campaign
amber.participants(a, study = "Liftup", campaign = "base")

amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.interviews_step_actions}()},
\code{\link{amber.interviews_step_data}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
