% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_read_base.R
\name{amf_read_base}
\alias{amf_read_base}
\title{Read AmeriFlux BASE data product}
\usage{
amf_read_base(file, unzip = TRUE, parse_timestamp = FALSE)
}
\arguments{
\item{file}{A BASE data file, either in a zipped file or a comma-separate
value (csv) file}

\item{unzip}{Logical, whether to unzip. The default is TRUE. Set FALSE if
reading from a previously unzipped csv file.}

\item{parse_timestamp}{Logical, whether to parse the time stamp. Set TRUE
to parse and add timekeeping columns.}
}
\value{
A data frame containing data. See AmeriFlux website
 \url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/}
for details about file format, variable definition, units, and convention.
If \code{parse_timestamp} = TRUE, the following six time-keeping columns are
added in the returned data frame:
\itemize{
  \item YEAR - Year (YYYY)
  \item MONTH - Month (MM)
  \item DAY - Day of the month (DD)
  \item DOY - Day of the year (DDD)
  \item HOUR - Hour of the day (HH), based on the middle time of the interval
  \item MINUTE - Minute of the hour (mm), based on the middle time of the
  interval
  \item TIMESTAMP - An object of class "POSIXlt" in the UTC time zone,
  based on the middle time of the interval
}
}
\description{
This function read in the BASE data file downloaded
from AmeriFlux. See AmeriFlux web page
\url{https://ameriflux.lbl.gov/data/data-processing-pipelines/base-publish/}
for details about BASE data product. Use \code{\link{amf_variables}}
to get a list of standard variable names and units.
}
\examples{
# read the BASE from a zip file, using the example data file
base <- amf_read_base(file = system.file("extdata",
                                         "AMF_US-CRT_BASE-BADM_2-5.zip",
                                          package = "amerifluxr"),
                      unzip = TRUE,
                      parse_timestamp = TRUE)

# read the BASE from a csv file
base <- amf_read_base(file = system.file("extdata",
                                         "AMF_US-CRT_BASE_HH_2-5.csv",
                                          package = "amerifluxr"),
                      unzip = FALSE,
                      parse_timestamp = FALSE)
}
\seealso{
\code{\link{amf_parse_basename}}, \code{\link{amf_filter_base}}
}
