% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createClusterBulk.R
\name{createClusterBulk}
\alias{createClusterBulk}
\title{Create serial thermal cluster}
\usage{
createClusterBulk(
  cluster_object,
  area_zone,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{cluster_object}{\code{list} mutiple list containing the parameters for writing each cluster}

\item{area_zone}{\code{character} name of area to create cluster}

\item{add_prefix}{\code{logical} prefix cluster name with area name}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.

\code{list} containing meta information about the simulation
}
\description{
For each area, the thermal cluster data are generated :
\itemize{
\item Writing \code{.ini} files
\item Writing time_series files
\item Writing prepro_data files
\item Writing prepro_modulation files
}
}
\details{
see the example to write a cluster object,
see the original function \code{\link[=createCluster]{createCluster()}}

Structure of \code{cluster_object} :

The list must be structured with named items
\itemize{
\item \code{parameter} : \code{list} of paramaters to write in .ini file
\item \code{overwrite} : \code{logical} to choose to overwrite an existing cluster (if not present, set to \code{FALSE})
\item \code{time_series} : \code{matrix} or \code{data.frame} the "ready-made" 8760-hour time-series
\item \code{prepro_data} : \code{matrix} or \code{data.frame} Pre-process data
\item \code{prepro_modulation} : \code{matrix} or \code{data.frame} Pre-process modulation
}

Details for sublist \code{cluster_object[["parameter"]]} :
\itemize{
\item \code{name} : Name for the cluster,
it will prefixed by area name, unless you set add_prefix = FALSE
\item \code{group} : Group of the cluster, depends on cluster type
\item \code{...} : Parameters to write in the Ini file
}
}
\examples{
\dontrun{

# /!\/!\/!\ use or create a study /!\/!\/!\

# data preparation for sutructures
ts <- matrix(rep(c(0, 8000), each = 24*364), 
             ncol = 2)

df_pd <- matrix(rep(c(1, 1, 1, 0), each = 24*365), 
                ncol = 4)

df_pm <- matrix(data = c(rep(1, times = 365 * 24 * 3), rep(0, times = 365 * 24 * 1)), 
                ncol = 4)


# Example cluster object
zone_test_1 <- list(
  `CCGT old 1`= list(
  parameter= list(
  name= "CCGT old 1",
  group = "Other",
  unitcount= 10L,
  nominalcapacity= 100,
   enabled= "true",
   `min-stable-power`= 80L,
   `min-up-time`= 20L,
   `min-down_time`= 30L),
   overwrite= TRUE,
   time_series = ts_8760,
   prepro_data = df_pd,
   prepro_modulation = df_pm))
 
 # overwrite existing cluster
zone_test_2 <- list(
 `PEAK`= list(parameter= list(
   name= "PEAK",
   group = "Other"),
   overwrite= TRUE,
   time_series = ts,
   prepro_data = df_pd,
   prepro_modulation = df_pm))

# Create multiple areas with multiple clusters
list_areas <- antaresRead::getAreas()[1:5]

lapply(list_areas, createClusterBulk,
cluster_object = c(zone_test_1, zone_test_2),
add_prefix = TRUE)

}

}
