% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readIniFile.R
\name{read-ini}
\alias{read-ini}
\alias{readIni}
\alias{readIniFile}
\alias{readIniAPI}
\title{Read configuration options from file or API}
\usage{
readIni(pathIni, opts = antaresRead::simOptions(), default_ext = ".ini")

readIniFile(file, stringsAsFactors = FALSE)

readIniAPI(study_id, path, host, token = NULL)
}
\arguments{
\item{pathIni}{Path to config/ini file to read.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[=setSimulationPath]{setSimulationPath()}}}

\item{default_ext}{Default extension used for config files.}

\item{file}{File path.}

\item{stringsAsFactors}{logical: should character vectors be converted to factors?}

\item{study_id}{Study's identifier.}

\item{path}{Path of configuration object to read.}

\item{host}{Host of AntaREST server API.}

\item{token}{API personnal access token.}
}
\value{
A list with an element for each section of the .ini file.
}
\description{
Read configuration options from file or API
}
\examples{
\dontrun{
library(antaresRead)
library(antaresEditObject)

# With physical study:
setSimulationPath("../tests-studies/Study_V8.2/", simulation = "input")
readIni("settings/generaldata")

# With API
setSimulationPathAPI(
  host = "http://localhost:8080",
  study_id = "73427ae1-be83-44e0-b04f-d5127e53424c",
  token = NULL,
  simulation = "input"
)
readIni("settings/generaldata")

}
}
