% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mollicEpipedon.R
\name{hasDarkColors}
\alias{hasDarkColors}
\title{Find horizons with colors darker than a Munsell hue, value, chroma threshold}
\usage{
hasDarkColors(
  p,
  d_hue = NA,
  m_hue = NA,
  d_value = 5,
  d_chroma = NA,
  m_value = 3,
  m_chroma = 3,
  dhuenm = "d_hue",
  dvalnm = "d_value",
  dchrnm = "d_chroma",
  mhuenm = "m_hue",
  mvalnm = "m_value",
  mchrnm = "m_chroma"
)
}
\arguments{
\item{p}{A SoilProfileCollection.}

\item{d_hue}{Optional: character vector of dry hues to match (default: NA)}

\item{m_hue}{Optional: character vector of moist hues to match (default: NA)}

\item{d_value}{Maximum value of dry value (default: 5)}

\item{d_chroma}{Optional: Maximum value of dry chroma (default: NA)}

\item{m_value}{Maximum value of moist value (default: 3)}

\item{m_chroma}{Maximum value of moist chroma (default: 3)}

\item{dhuenm}{Column name containing dry hue.}

\item{dvalnm}{Column name containing dry value.}

\item{dchrnm}{Column name containing dry chroma.}

\item{mhuenm}{Column name containing moist hue.}

\item{mvalnm}{Column name containing moist value.}

\item{mchrnm}{Column name containing moist chroma.}
}
\value{
Boolean value (for each horizon in \code{p}) reflecting whether "darkness" criteria are met.
}
\description{
\code{hasDarkColors} returns a boolean value by horizon representing whether darkness thresholds are met. The code is fully vectorized and deals with missing data and optional thresholds.

Default arguments are set up for "5-3-3 colors" -- the basic criteria for Mollic/Umbric epipedon/mineral soil darkness. Any of the thresholds or column names can be altered. Any thresholds that are set equal to \code{NA} will be ignored.
}
\examples{
# construct a fake profile
spc <- data.frame(id=1, taxsubgrp = "Lithic Haploxeralfs",
                  hzdesgn  = c("A","AB","Bt","BCt","R"),
                  hzdept   = c(0, 20, 32, 42,  49),
                  hzdepb   = c(20, 32, 42, 49, 200),
                  d_value  = c(5,   5,  5,  6,  NA),
                  m_value  = c(2.5, 3,  3,  4,  NA),
                  m_chroma = c(2,   3,  4,  4,  NA))

# promote to SoilProfileCollection
depths(spc) <- id ~ hzdept + hzdepb

# print results in table
data.frame(id = spc[[idname(spc)]],
           hz_desgn = spc$hzdesgn,
           has_dark_colors = hasDarkColors(spc))

}
\author{
Andrew G. Brown
}
