% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amofa.R
\name{amofa}
\alias{amofa}
\title{Adaptive Mixture of Factor Analyzers (AMoFA)}
\usage{
amofa(data, itmax = 100, verbose = FALSE, varimax = FALSE)
}
\arguments{
\item{data}{An \emph{n} by \emph{p} data matrix, where \emph{n} is the number of
observations and \emph{p} is the number of dimensions of the data.}

\item{itmax}{The maximum number of EM iterations allowed for the estimation of each MFA model.}

\item{verbose}{Boolean indicating whether or not to print more
verbose output, including the number of EM-iterations used and the total
running time. Default is FALSE.}

\item{varimax}{Boolean indicating whether the output factor loading matrices should be constrained
using varimax rotation or not.}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{model}:}{ A list specifying the final MFA model. This contains: \itemize{
\item{\code{B}:}{ A list containing the factor loading matrices for each component.}
\item{\code{D}:}{ A \emph{p} by \emph{p} by \emph{g} array of error variance matrices.}
\item{\code{mu}:}{  A \emph{p} by \emph{g} array containing the mean of each cluster.}
\item{\code{pivec}:}{ A 1 by g vector containing the mixing
proportions for each FA in the mixture.}
\item{\code{numFactors}:}{ A \emph{1} by \emph{g} vector containing the number of factors for each FA.}}
}
\item{\code{clustering}:}{ A list specifying the clustering produced by the final model. This contains: \itemize{
\item{\code{responsibilities}:}{ A \emph{n} by \emph{g} matrix containing the probability
that each point belongs to each FA in the mixture.}
\item{\code{allocations}:}{ A \emph{n} by 1 matrix containing which
FA in the mixture each point is assigned to based on the responsibilities.}}}
\item{\code{diagnostics}:}{ A list containing various pieces of information related to the fitting process of the algorithm. This contains: \itemize{
\item{\code{bic}:}{ The BIC of the final model.}
\item{\code{logL}:}{ The log-likelihood of the final model.}
\item{\code{totalEM}:}{ The total number of EM iterations used.}
\item{\code{progress}:}{ A matrix containing information about the decisions
made by the algorithm.}
\item{\code{times}:}{ The time taken for each loop in the algorithm.}
\item{\code{totalTime}:}{ The total time taken to fit the final model.}}}
}
}
\description{
An implementation of the Adaptive Mixture of Factor Analyzers (AMoFA)
algorithm from \insertCite{kaya2015adaptive}{autoMFA}. This code is a R port of the MATLAB code which was
included with that paper.
}
\examples{
RNGversion('4.0.3'); set.seed(3)
MFA.fit <- amofa(autoMFA::MFA_testdata)

}
\references{
\insertRef{kaya2015adaptive}{autoMFA}
}
