% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeharp.R, R/th_getter-length.R
\name{TreeHarp-class}
\alias{TreeHarp-class}
\alias{TreeHarp}
\alias{TreeHarp,logical-method}
\alias{TreeHarp,missing-method}
\alias{length,TreeHarp-method}
\alias{show,TreeHarp-method}
\alias{names,TreeHarp-method}
\title{An R expression as a tree.}
\usage{
TreeHarp(lang_obj, quote_arg, ...)

TreeHarp(lang_obj, quote_arg, ...)

\S4method{TreeHarp}{logical}(lang_obj, quote_arg, ...)

\S4method{TreeHarp}{missing}(lang_obj, quote_arg, ...)

\S4method{length}{TreeHarp}(x)

\S4method{show}{TreeHarp}(object)

\S4method{names}{TreeHarp}(x)
}
\arguments{
\item{lang_obj}{This should be an adjacency list for a tree (not a graph), or the
adjacency matrix of a tree, or the expression to be parsed. If it is a list,
only child nodes should be indicated (see the examples).}

\item{quote_arg}{If this argument is missing or FALSE, then the class of 
\code{lang_obj} will be evaluated, and, if it is either a list or matrix, 
the TreeHarp object will be returned. 

If this argument is TRUE, the \code{lang_obj} argument will be quoted and a 
parse tree for the expression will be computed and used as the tree.}

\item{...}{Unused at the moment.}

\item{x}{A Treeharp object.}

\item{object}{A TreeHarp object.}
}
\value{
Constructors return an object of class TreeHarp.

\code{length}: An integer of length 1.

\code{print}: Returns NULL. It prints a string representation of a 
TreeHarp object.

\code{names}: A character vector with length equal to the number of 
nodes.
}
\description{
This class is used to represent a \emph{single} R expression as a tree.
}
\details{
The following validity checks are conducted on the object:
\enumerate{
\item Is the graph connected? If no, the object is invalid.
\item Are there cycles? If yes, the object is invalid.
\item Are the nodes labelled in a BFS ordering? If not, the object is not 
valid.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{TreeHarp(logical)}: A constructor for TreeHarp.

Converts either adjacency list or matrix into a TreeHarp object.

\item \code{TreeHarp(missing)}: A constructor for TreeHarp.

Converts language object into a TreeHarp object.

\item \code{length(TreeHarp)}: To get the length of a tree.

The length of the tree refers to the number of nodes in the tree.

\item \code{show(TreeHarp)}: To print a tree representation.

A string representation of a TreeHarp object.

\item \code{names(TreeHarp)}: To get tree labels

This function returns the node labels of the tree.

}}
\section{Slots}{

\describe{
\item{\code{adjList}}{The adjacency list of the tree. The list must be named. The
nodes should be labelled in Breadth-First Order. The first component must
be the root of the tree. Leaves of the tree should be NULL elements.}

\item{\code{nodeTypes}}{A data frame describing the type of node. The columns in the 
data frame will be derived from the expression used to instantiate the 
object. The column names will be id (node id), name, call_status, 
formal_arg and depth. This slot can be left missing (i.e., populated with 
NA). This latter feature is useful when we just wish to test something out.

This slot is only populated automatically when an R expression is provided 
as \code{lang_obj} and \code{quote_arg} is TRUE.}

\item{\code{repr}}{A string representation of the tree. This will be printed when the 
show method of TreeHarp is called.}

\item{\code{call}}{The language object that was used to construct the tree (if it 
was). If the object was constructed from a list/matrix, this will be NA.}
}}

\examples{
l1 <- list(a=c(2,3), b=NULL, c=NULL)
# directly using new() 
treeharp1 <- new("TreeHarp", adjList = l1, nodeTypes = NA)

# using one of the constructor methods (for lists)
treeharp2 <- TreeHarp(l1)

# using the constructor for matrices.
m1 <- matrix(0L, 3, 3)
dimnames(m1) <- list(letters[1:3], letters[1:3])
m1[1, ] <- c(0, 1L, 1L)
m1[, 1] <- c(0, 1L, 1L)
treeharp3 <- TreeHarp(m1)

# Supplying a language object to get the same tree (with nodeTypes 
# populated)
ex1 <- quote(a(b,c))
TreeHarp(ex1, TRUE)

}
